/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.util.Escape;
import org.jmol.util.TextFormat;

public class Quaternion {
    public float q0;
    public float q1;
    public float q2;
    public float q3;
    public Matrix3f mat;
    private static final Quaternion qTemp = new Quaternion(0.0f, 0.0f, 0.0f, 0.0f);

    public Quaternion(Quaternion q) {
        this.q0 = q.q0;
        this.q1 = q.q1;
        this.q2 = q.q2;
        this.q3 = q.q3;
    }

    public void setRef(Quaternion qref) {
        if (qref == null) {
            this.fixQ(this);
            return;
        }
        if (this.dot(qref) >= 0.0f) {
            return;
        }
        this.q0 *= -1.0f;
        this.q1 *= -1.0f;
        this.q2 *= -1.0f;
        this.q3 *= -1.0f;
    }

    private Quaternion(float q0, float q1, float q2, float q3) {
        this.q0 = q0;
        this.q1 = q1;
        this.q2 = q2;
        this.q3 = q3;
    }

    public Quaternion(Point4f pt) {
        float factor = pt.distance(new Point4f(0.0f, 0.0f, 0.0f, 0.0f));
        if (factor == 0.0f) {
            this.q0 = 1.0f;
            return;
        }
        this.q0 = pt.w / factor;
        this.q1 = pt.x / factor;
        this.q2 = pt.y / factor;
        this.q3 = pt.z / factor;
    }

    public Quaternion(Tuple3f pt, float theta) {
        if (pt.x == 0.0f && pt.y == 0.0f && pt.z == 0.0f) {
            this.q0 = 1.0f;
            return;
        }
        double fact = Math.sin((double)(theta / 2.0f) * Math.PI / 180.0) / Math.sqrt(pt.x * pt.x + pt.y * pt.y + pt.z * pt.z);
        this.q0 = (float)Math.cos((double)(theta / 2.0f) * Math.PI / 180.0);
        this.q1 = (float)((double)pt.x * fact);
        this.q2 = (float)((double)pt.y * fact);
        this.q3 = (float)((double)pt.z * fact);
    }

    public Quaternion(Matrix3f mat) {
        double z;
        double y;
        double x;
        double w;
        double trace = mat.m00 + mat.m11 + mat.m22;
        if (trace >= 0.5) {
            w = Math.sqrt(1.0 + trace);
            x = (double)(mat.m21 - mat.m12) / w;
            y = (double)(mat.m02 - mat.m20) / w;
            z = (double)(mat.m10 - mat.m01) / w;
        } else {
            double d;
            double temp = (double)(mat.m00 + mat.m00) - trace;
            if (d >= 0.5) {
                x = Math.sqrt(1.0 + temp);
                w = (double)(mat.m21 - mat.m12) / x;
                y = (double)(mat.m10 + mat.m01) / x;
                z = (double)(mat.m20 + mat.m02) / x;
            } else {
                temp = (double)(mat.m11 + mat.m11) - trace;
                if (temp >= 0.5 || mat.m11 > mat.m22) {
                    y = Math.sqrt(1.0 + temp);
                    w = (double)(mat.m02 - mat.m20) / y;
                    x = (double)(mat.m10 + mat.m01) / y;
                    z = (double)(mat.m21 + mat.m12) / y;
                } else {
                    z = Math.sqrt(1.0 + (double)mat.m22 + (double)mat.m22 - trace);
                    w = (double)(mat.m10 - mat.m01) / z;
                    x = (double)(mat.m20 + mat.m02) / z;
                    y = (double)(mat.m21 + mat.m12) / z;
                }
            }
        }
        this.q0 = (float)(w * 0.5);
        this.q1 = (float)(x * 0.5);
        this.q2 = (float)(y * 0.5);
        this.q3 = (float)(z * 0.5);
    }

    public static final Quaternion getQuaternionFrame(Point3f center, Point3f x, Point3f xy) {
        Vector3f vA = new Vector3f(x);
        vA.sub(center);
        Vector3f vB = new Vector3f(xy);
        vB.sub(center);
        return Quaternion.getQuaternionFrame(vA, vB, null);
    }

    public static final Quaternion getQuaternionFrame(Vector3f vA, Vector3f vB, Vector3f vC) {
        if (vC == null) {
            vC = new Vector3f();
            vC.cross(vA, vB);
        }
        Vector3f vBprime = new Vector3f();
        vBprime.cross(vC, vA);
        vA.normalize();
        vBprime.normalize();
        vC.normalize();
        Matrix3f mat = new Matrix3f();
        mat.setColumn(0, vA);
        mat.setColumn(1, vBprime);
        mat.setColumn(2, vC);
        Quaternion q = new Quaternion(mat);
        return q;
    }

    public Matrix3f getMatrix() {
        if (this.mat == null) {
            this.setMatrix();
        }
        return this.mat;
    }

    private void setMatrix() {
        this.mat = new Matrix3f();
        this.mat.m00 = this.q0 * this.q0 + this.q1 * this.q1 - this.q2 * this.q2 - this.q3 * this.q3;
        this.mat.m01 = 2.0f * this.q1 * this.q2 - 2.0f * this.q0 * this.q3;
        this.mat.m02 = 2.0f * this.q1 * this.q3 + 2.0f * this.q0 * this.q2;
        this.mat.m10 = 2.0f * this.q1 * this.q2 + 2.0f * this.q0 * this.q3;
        this.mat.m11 = this.q0 * this.q0 - this.q1 * this.q1 + this.q2 * this.q2 - this.q3 * this.q3;
        this.mat.m12 = 2.0f * this.q2 * this.q3 - 2.0f * this.q0 * this.q1;
        this.mat.m20 = 2.0f * this.q1 * this.q3 - 2.0f * this.q0 * this.q2;
        this.mat.m21 = 2.0f * this.q2 * this.q3 + 2.0f * this.q0 * this.q1;
        this.mat.m22 = this.q0 * this.q0 - this.q1 * this.q1 - this.q2 * this.q2 + this.q3 * this.q3;
    }

    public Quaternion add(float x) {
        return new Quaternion(this.getNormal(), this.getTheta() + x);
    }

    public Quaternion mul(float x) {
        if (x == 1.0f) {
            return new Quaternion(this.q0, this.q1, this.q2, this.q3);
        }
        return new Quaternion(this.getNormal(), this.getTheta() * x);
    }

    public Quaternion mul(Quaternion p) {
        return new Quaternion(this.q0 * p.q0 - this.q1 * p.q1 - this.q2 * p.q2 - this.q3 * p.q3, this.q0 * p.q1 + this.q1 * p.q0 + this.q2 * p.q3 - this.q3 * p.q2, this.q0 * p.q2 + this.q2 * p.q0 + this.q3 * p.q1 - this.q1 * p.q3, this.q0 * p.q3 + this.q3 * p.q0 + this.q1 * p.q2 - this.q2 * p.q1);
    }

    public Quaternion div(Quaternion p) {
        return this.mul(p.inv());
    }

    public Quaternion divLeft(Quaternion p) {
        return this.inv().mul(p);
    }

    public float dot(Quaternion q) {
        return this.q0 * q.q0 + this.q1 * q.q1 + this.q2 * q.q2 + this.q3 * q.q3;
    }

    public Quaternion inv() {
        return new Quaternion(this.q0, -this.q1, -this.q2, -this.q3);
    }

    public Quaternion negate() {
        return new Quaternion(-this.q0, -this.q1, -this.q2, -this.q3);
    }

    private void fixQ(Quaternion qNew) {
        float f = this.q0 < 0.0f || this.q0 == 0.0f && (this.q1 < 0.0f || this.q1 == 0.0f && (this.q2 < 0.0f || this.q2 == 0.0f && this.q3 < 0.0f)) ? -1 : 1;
        qNew.q0 = this.q0 * f;
        qNew.q1 = this.q1 * f;
        qNew.q2 = this.q2 * f;
        qNew.q3 = this.q3 * f;
    }

    public String toString() {
        return "{" + this.q1 + " " + this.q2 + " " + this.q3 + " " + this.q0 + "}";
    }

    public Vector3f getVector(int i) {
        return this.getVector(i, 1.0f);
    }

    private Vector3f getVector(int i, float scale) {
        if (i == -1) {
            this.fixQ(qTemp);
            return new Vector3f(Quaternion.qTemp.q1 * scale, Quaternion.qTemp.q2 * scale, Quaternion.qTemp.q3 * scale);
        }
        if (this.mat == null) {
            this.setMatrix();
        }
        Vector3f v = new Vector3f();
        this.mat.getColumn(i, v);
        if (scale != 1.0f) {
            v.scale(scale);
        }
        return v;
    }

    public Vector3f getNormal() {
        this.fixQ(qTemp);
        Vector3f v = new Vector3f(Quaternion.qTemp.q1, Quaternion.qTemp.q2, Quaternion.qTemp.q3);
        v.normalize();
        return v;
    }

    public float getTheta() {
        this.fixQ(qTemp);
        return (float)(Math.acos(Quaternion.qTemp.q0) * 2.0 * 180.0 / Math.PI);
    }

    public float getThetaRadians() {
        this.fixQ(qTemp);
        return (float)(Math.acos(Quaternion.qTemp.q0) * 2.0);
    }

    public void getThetaDirected(Point4f axisAngle) {
        float theta = this.getTheta();
        Vector3f v = this.getNormal();
        if (axisAngle.x * this.q1 + axisAngle.y * this.q2 + axisAngle.z * this.q3 < 0.0f) {
            v.scale(-1.0f);
            theta = -theta;
        }
        axisAngle.set(v.x, v.y, v.z, theta);
    }

    public Point4f toPoint4f() {
        return new Point4f(this.q1, this.q2, this.q3, this.q0);
    }

    public AxisAngle4f toAxisAngle4f() {
        this.fixQ(qTemp);
        double theta = 2.0 * Math.acos(Quaternion.qTemp.q0);
        double sinTheta2 = Math.sin(theta / 2.0);
        Vector3f v = this.getNormal();
        if (sinTheta2 < 0.0) {
            v.scale(-1.0f);
            theta = Math.PI - theta;
        }
        return new AxisAngle4f(v, (float)theta);
    }

    public Point3f transform(Point3f pt) {
        if (this.mat == null) {
            this.setMatrix();
        }
        Point3f ptNew = new Point3f(pt);
        this.mat.transform(ptNew);
        return ptNew;
    }

    public void transform(Point3f pt, Point3f ptNew) {
        if (this.mat == null) {
            this.setMatrix();
        }
        this.mat.transform(pt, ptNew);
    }

    public Vector3f transform(Vector3f v) {
        if (this.mat == null) {
            this.setMatrix();
        }
        Vector3f vNew = new Vector3f(v);
        this.mat.transform(vNew);
        return vNew;
    }

    public Quaternion leftDifference(Quaternion q2) {
        Quaternion q2adjusted = this.dot(q2) < 0.0f ? q2.negate() : q2;
        return this.inv().mul(q2adjusted);
    }

    public Quaternion rightDifference(Quaternion q2) {
        Quaternion q2adjusted = this.dot(q2) < 0.0f ? q2.negate() : q2;
        return this.mul(q2adjusted.inv());
    }

    public String getInfo() {
        AxisAngle4f axis = this.toAxisAngle4f();
        return TextFormat.sprintf("%10.6f%10.6f%10.6f%10.6f  %6.2f  %10.5f %10.5f %10.5f", new Object[]{new float[]{this.q0, this.q1, this.q2, this.q3, (float)((double)(axis.angle * 180.0f) / Math.PI), axis.x, axis.y, axis.z}});
    }

    public String draw(String prefix, String id, Point3f ptCenter, float scale) {
        String strV = " VECTOR " + Escape.escape(ptCenter) + " ";
        if (scale == 0.0f) {
            scale = 1.0f;
        }
        return "draw " + prefix + "x" + id + strV + Escape.escape(this.getVector(0, scale)) + " color red\n" + "draw " + prefix + "y" + id + strV + Escape.escape(this.getVector(1, scale)) + " color green\n" + "draw " + prefix + "z" + id + strV + Escape.escape(this.getVector(2, scale)) + " color blue\n";
    }
}

