/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jmol.util.ArrayUtil;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;

public class ZipUtil {
    public static boolean isZipFile(String filePath) {
        try {
            URL url = new URL(filePath);
            URLConnection conn = url.openConnection();
            BufferedInputStream bis = new BufferedInputStream(conn.getInputStream(), 8192);
            boolean isOK = ZipUtil.isZipFile(bis);
            bis.close();
            return isOK;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isZipFile(InputStream is) throws Exception {
        byte[] abMagic = new byte[4];
        is.mark(5);
        int countRead = is.read(abMagic, 0, 4);
        is.reset();
        return countRead == 4 && abMagic[0] == 80 && abMagic[1] == 75 && abMagic[2] == 3 && abMagic[3] == 4;
    }

    public static boolean isZipFile(byte[] bytes) throws Exception {
        return bytes.length > 4 && bytes[0] == 80 && bytes[1] == 75 && bytes[2] == 3 && bytes[3] == 4;
    }

    public static ZipInputStream getStream(InputStream is) {
        return is instanceof ZipInputStream ? (ZipInputStream)is : (is instanceof BufferedInputStream ? new ZipInputStream(is) : new ZipInputStream(new BufferedInputStream(is)));
    }

    public static void getAllData(InputStream is, String[] subfileList, String name0, String binaryFileList, Hashtable fileData) {
        ZipInputStream zis = ZipUtil.getStream(is);
        StringBuffer listing = new StringBuffer();
        binaryFileList = "|" + binaryFileList + "|";
        String prefix = TextFormat.join(subfileList, '/', 1);
        String prefixd = null;
        if (prefix != null && (prefixd = prefix.substring(0, prefix.indexOf("/") + 1)).length() == 0) {
            prefixd = null;
        }
        try {
            ZipEntry ze;
            while ((ze = zis.getNextEntry()) != null) {
                String str;
                String name = ze.getName();
                if (prefix != null && prefixd != null && !name.equals(prefix) && !name.startsWith(prefixd)) continue;
                listing.append(name).append('\n');
                String sname = "|" + name.substring(name.lastIndexOf("/") + 1) + "|";
                boolean asBinaryString = binaryFileList.indexOf(sname) >= 0;
                byte[] bytes = ZipUtil.getZipEntryAsBytes(zis);
                if (asBinaryString) {
                    str = ZipUtil.getBinaryStringForBytes(bytes);
                    name = name + ":asBinaryString";
                } else {
                    str = new String(bytes);
                }
                str = "BEGIN Directory Entry " + name + "\n" + str + "\nEND Directory Entry " + name + "\n";
                fileData.put(name0 + "|" + name, str);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        fileData.put("#Directory_Listing", listing.toString());
    }

    public static String getBinaryStringForBytes(byte[] bytes) {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            ret.append(Integer.toHexString(bytes[i] & 0xFF)).append(' ');
        }
        return ret.toString();
    }

    public static Object getZipFileContents(InputStream is, String[] list, int listPtr, boolean asInputStream) {
        if (list == null || listPtr >= list.length) {
            return ZipUtil.getZipDirectoryAsStringAndClose(is);
        }
        String fileName = list[listPtr];
        ZipInputStream zis = new ZipInputStream(is);
        try {
            ZipEntry ze;
            boolean isAll = fileName.equals(".");
            if (isAll || fileName.lastIndexOf("/") == fileName.length() - 1) {
                ZipEntry ze2;
                StringBuffer ret = new StringBuffer();
                while ((ze2 = zis.getNextEntry()) != null) {
                    String name = ze2.getName();
                    if (!isAll && !name.startsWith(fileName)) continue;
                    ret.append(name).append('\n');
                }
                String str = ret.toString();
                if (asInputStream) {
                    return new StringBufferInputStream(str);
                }
                return str;
            }
            boolean asBinaryString = false;
            if (fileName.indexOf(":asBinaryString") > 0) {
                fileName = fileName.substring(0, fileName.indexOf(":asBinaryString"));
                asBinaryString = true;
            }
            while ((ze = zis.getNextEntry()) != null) {
                if (!fileName.equals(ze.getName())) continue;
                byte[] bytes = ZipUtil.getZipEntryAsBytes(zis);
                if (ZipUtil.isZipFile(bytes)) {
                    return ZipUtil.getZipFileContents(new BufferedInputStream(new ByteArrayInputStream(bytes)), list, ++listPtr, asInputStream);
                }
                if (asInputStream) {
                    return new ByteArrayInputStream(bytes);
                }
                if (asBinaryString) {
                    StringBuffer ret = new StringBuffer();
                    for (int i = 0; i < bytes.length; ++i) {
                        ret.append(Integer.toHexString(bytes[i] & 0xFF)).append(' ');
                    }
                    return ret.toString();
                }
                return new String(bytes);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return "";
    }

    public static byte[] getZipFileContentsAsBytes(InputStream is, String[] list, int listPtr) {
        byte[] ret = new byte[]{};
        String fileName = list[listPtr];
        if (fileName.lastIndexOf("/") == fileName.length() - 1) {
            return ret;
        }
        ZipInputStream zis = new ZipInputStream(is);
        try {
            ZipEntry ze;
            while ((ze = zis.getNextEntry()) != null) {
                if (!fileName.equals(ze.getName())) continue;
                byte[] bytes = ZipUtil.getZipEntryAsBytes(zis);
                if (ZipUtil.isZipFile(bytes) && list != null && ++listPtr < list.length) {
                    return ZipUtil.getZipFileContentsAsBytes(new BufferedInputStream(new ByteArrayInputStream(bytes)), list, listPtr);
                }
                return bytes;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return ret;
    }

    public static String getZipDirectoryAsStringAndClose(InputStream is) {
        StringBuffer sb = new StringBuffer();
        String[] s = new String[]{};
        try {
            s = ZipUtil.getZipDirectoryOrErrorAndClose(is, false);
            is.close();
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
        }
        for (int i = 0; i < s.length; ++i) {
            sb.append(s[i]).append('\n');
        }
        return sb.toString();
    }

    public static String[] getZipDirectoryAndClose(InputStream is, boolean addManifest) {
        String[] s = new String[]{};
        try {
            s = ZipUtil.getZipDirectoryOrErrorAndClose(is, addManifest);
            is.close();
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
        }
        return s;
    }

    private static String[] getZipDirectoryOrErrorAndClose(InputStream is, boolean addManifest) throws IOException {
        ZipEntry ze;
        Vector<String> v = new Vector<String>();
        ZipInputStream zis = new ZipInputStream(is);
        String manifest = null;
        while ((ze = zis.getNextEntry()) != null) {
            String fileName = ze.getName();
            if (addManifest && fileName.equals("JmolManifest")) {
                manifest = ZipUtil.getZipEntryAsString(zis);
                continue;
            }
            if (fileName.startsWith("__MACOS")) continue;
            v.addElement(fileName);
        }
        zis.close();
        if (addManifest) {
            v.add(0, manifest == null ? "" : manifest + "\n############\n");
        }
        int len = v.size();
        String[] dirList = new String[len];
        for (int i = 0; i < len; ++i) {
            dirList[i] = (String)v.elementAt(i);
        }
        return dirList;
    }

    public static String getZipEntryAsString(ZipInputStream zis) throws IOException {
        int len;
        StringBuffer sb = new StringBuffer();
        byte[] buf = new byte[1024];
        while (zis.available() == 1 && (len = zis.read(buf)) > 0) {
            sb.append(new String(buf, 0, len));
        }
        return sb.toString();
    }

    public static byte[] getZipEntryAsBytes(ZipInputStream zis) throws IOException {
        byte[] buf = new byte[1024];
        byte[] bytes = new byte[4096];
        int len = 0;
        int totalLen = 0;
        while (zis.available() == 1 && (len = zis.read(buf)) > 0) {
            if ((totalLen += len) >= bytes.length) {
                bytes = ArrayUtil.ensureLength(bytes, totalLen * 2);
            }
            System.arraycopy(buf, 0, bytes, totalLen - len, len);
        }
        buf = new byte[totalLen];
        System.arraycopy(bytes, 0, buf, 0, totalLen);
        return buf;
    }

    public static byte[] getStreamAsBytes(BufferedInputStream bis) throws IOException {
        byte[] buf = new byte[1024];
        byte[] bytes = new byte[4096];
        int len = 0;
        int totalLen = 0;
        while ((len = bis.read(buf)) > 0) {
            if ((totalLen += len) >= bytes.length) {
                bytes = ArrayUtil.ensureLength(bytes, totalLen * 2);
            }
            System.arraycopy(buf, 0, bytes, totalLen - len, len);
        }
        buf = new byte[totalLen];
        System.arraycopy(bytes, 0, buf, 0, totalLen);
        return buf;
    }
}

