/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import org.jmol.modelset.Atom;
import org.jmol.modelset.AtomCollection;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.Parser;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Token;
import org.jmol.viewer.Viewer;

class DataManager {
    private Hashtable dataValues = new Hashtable();
    int[] userVdwMars;
    float[] userVdws;
    int defaultVdw = 0;
    BitSet bsUserVdws;

    DataManager() {
    }

    void clear() {
        this.dataValues.clear();
    }

    void setData(Viewer viewer, String type, Object[] data, int atomCount, int matchField, int matchFieldColumnCount, int field, int fieldColumnCount) {
        if (type == null) {
            this.clear();
            return;
        }
        if (type.equals("element_vdw")) {
            String stringData = ((String)data[1]).trim();
            if (stringData.length() == 0) {
                this.userVdwMars = null;
                this.userVdws = null;
                this.bsUserVdws = null;
                return;
            }
            if (this.bsUserVdws == null) {
                this.setUserVdw(this.defaultVdw);
            }
            Parser.parseFloatArrayFromMatchAndField(stringData, this.bsUserVdws, 1, 0, (int[])data[2], 2, 0, this.userVdws, 1);
            int i = this.userVdws.length;
            while (--i >= 0) {
                this.userVdwMars[i] = (int)(this.userVdws[i] * 1000.0f);
            }
            return;
        }
        if (data[2] != null && atomCount > 0) {
            int tok;
            BitSet bs;
            String stringData = (String)data[1];
            boolean createNew = matchField != 0 || field != Integer.MIN_VALUE && field != Integer.MAX_VALUE;
            Object[] oldData = (Object[])this.dataValues.get(type);
            float[] f = oldData == null || createNew ? new float[atomCount] : ArrayUtil.ensureLength((float[])oldData[1], atomCount);
            String[] strData = null;
            if (field == Integer.MIN_VALUE && (strData = Parser.getTokens(stringData)).length > 1) {
                field = 0;
            }
            if (field == Integer.MIN_VALUE) {
                bs = (BitSet)data[2];
                Parser.setSelectedFloats(Parser.parseFloat(stringData), bs, f);
            } else if (field == 0 || field == Integer.MAX_VALUE) {
                bs = (BitSet)data[2];
                Parser.parseFloatArray(strData == null ? Parser.getTokens(stringData) : strData, bs, f);
            } else if (matchField <= 0) {
                bs = (BitSet)data[2];
                Parser.parseFloatArrayFromMatchAndField(stringData, bs, 0, 0, null, field, fieldColumnCount, f, 1);
            } else {
                int[] iData = (int[])data[2];
                Parser.parseFloatArrayFromMatchAndField(stringData, null, matchField, matchFieldColumnCount, iData, field, fieldColumnCount, f, 1);
                bs = new BitSet();
                int i = iData.length;
                while (--i >= 0) {
                    if (iData[i] < 0) continue;
                    bs.set(iData[i]);
                }
            }
            if (oldData != null && oldData[2] instanceof BitSet && !createNew) {
                bs.or((BitSet)oldData[2]);
            }
            data[2] = bs;
            data[1] = f;
            if (type.indexOf("property_") == 0 && (tok = Token.getSettableTokFromString(type.substring(9))) != 0) {
                int nValues = bs.cardinality();
                float[] fValues = new float[nValues];
                int n = 0;
                int i = 0;
                while (n < nValues) {
                    if (bs.get(i)) {
                        fValues[n++] = f[i];
                    }
                    ++i;
                }
                viewer.setAtomProperty(bs, tok, 0, 0.0f, null, fValues, null);
                return;
            }
        }
        this.dataValues.put(type, data);
    }

    Object[] getData(String type) {
        if (this.dataValues == null) {
            return null;
        }
        if (type.equalsIgnoreCase("types")) {
            Object[] info = new String[]{"types", ""};
            int n = 0;
            Enumeration e = this.dataValues.keys();
            while (e.hasMoreElements()) {
                info[1] = (String)info[1] + (n++ > 0 ? "\n" : "") + e.nextElement();
            }
            return info;
        }
        return (Object[])this.dataValues.get(type);
    }

    float[] getDataFloat(String label) {
        if (this.dataValues == null) {
            return null;
        }
        Object[] data = this.getData(label);
        if (data == null || !(data[1] instanceof float[])) {
            return null;
        }
        return (float[])data[1];
    }

    float getDataFloat(String label, int atomIndex) {
        float[] f;
        Object[] data;
        if (this.dataValues != null && (data = this.getData(label)) != null && data[1] instanceof float[] && atomIndex < (f = (float[])data[1]).length) {
            return f[atomIndex];
        }
        return Float.NaN;
    }

    float[][] getDataFloat2D(String label) {
        if (this.dataValues == null) {
            return null;
        }
        Object[] data = this.getData(label);
        if (data == null || !(data[1] instanceof float[][])) {
            return null;
        }
        return (float[][])data[1];
    }

    protected void deleteModelAtoms(int firstAtomIndex, int nAtoms, BitSet bsDeleted) {
        if (this.dataValues == null) {
            return;
        }
        Enumeration e = this.dataValues.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (name.indexOf("property_") != 0) continue;
            Object[] obj = (Object[])this.dataValues.get(name);
            BitSetUtil.deleteBits((BitSet)obj[2], bsDeleted);
            if (obj[1] instanceof float[]) {
                obj[1] = ArrayUtil.deleteElements((float[])obj[1], firstAtomIndex, nAtoms);
                continue;
            }
            if (!(obj[1] instanceof float[][])) continue;
            obj[1] = ArrayUtil.deleteElements((float[][])obj[1], firstAtomIndex, nAtoms);
        }
    }

    void getDataState(StringBuffer state, StringBuffer sfunc, Atom[] atoms, int atomCount, String atomProps) {
        String info;
        if (this.dataValues == null) {
            return;
        }
        Enumeration e = this.dataValues.keys();
        StringBuffer sb = new StringBuffer();
        int n = 0;
        if (atomProps.length() > 0) {
            n = 1;
            sb.append(atomProps);
        }
        while (e.hasMoreElements()) {
            Object data;
            String name = (String)e.nextElement();
            if (name.indexOf("property_") == 0) {
                ++n;
                Object[] obj = (Object[])this.dataValues.get(name);
                Object data2 = obj[1];
                if (data2 instanceof float[]) {
                    AtomCollection.getAtomicPropertyState(sb, atoms, atomCount, (byte)11, (BitSet)obj[2], name, (float[])data2);
                    sb.append("\n");
                    continue;
                }
                sb.append("\n").append(Escape.encapsulateData(name, data2));
                continue;
            }
            if (name.indexOf("data2d") != 0 || !((data = ((Object[])this.dataValues.get(name))[1]) instanceof float[][])) continue;
            ++n;
            sb.append("\n").append(Escape.encapsulateData(name, data));
        }
        if (this.userVdws != null && (info = this.getDefaultVdw(3, this.bsUserVdws)).length() > 0) {
            ++n;
            sb.append(info);
        }
        if (n == 0) {
            return;
        }
        if (sfunc != null) {
            state.append("function _setDataState() {\n");
        }
        state.append(sb);
        if (sfunc != null) {
            sfunc.append("  _setDataState;\n");
            state.append("}\n\n");
        }
    }

    public void setUserVdw(int iMode) {
        this.userVdwMars = new int[JmolConstants.elementNumberMax];
        this.userVdws = new float[JmolConstants.elementNumberMax];
        this.bsUserVdws = new BitSet();
        if (iMode == 3) {
            iMode = 0;
        }
        for (int i = 1; i < JmolConstants.elementNumberMax; ++i) {
            this.userVdwMars[i] = JmolConstants.getVanderwaalsMar(i, iMode);
            this.userVdws[i] = (float)this.userVdwMars[i] / 1000.0f;
        }
    }

    public void setDefaultVdw(String mode) {
        int iMode = JmolConstants.getVdwType(mode);
        if (iMode < 0) {
            iMode = 0;
        }
        if (iMode != this.defaultVdw && iMode == 3 && this.bsUserVdws == null) {
            this.setUserVdw(this.defaultVdw);
        }
        this.defaultVdw = iMode;
    }

    public String getDefaultVdw(int iMode, BitSet bs) {
        if (iMode == Integer.MIN_VALUE) {
            return JmolConstants.vdwLabels[this.defaultVdw];
        }
        if (iMode < 0) {
            iMode = this.defaultVdw;
        }
        if (iMode == Integer.MAX_VALUE) {
            bs = this.bsUserVdws;
            if (bs == null) {
                return "";
            }
            iMode = 3;
        }
        if (iMode == 3 && this.bsUserVdws == null) {
            this.setUserVdw(this.defaultVdw);
        }
        StringBuffer sb = new StringBuffer(JmolConstants.vdwLabels[iMode] + "\n");
        for (int i = 1; i < JmolConstants.elementNumberMax; ++i) {
            if (bs != null && !bs.get(i)) continue;
            sb.append(i).append('\t').append(iMode == 3 ? this.userVdws[i] : (float)JmolConstants.getVanderwaalsMar(i, iMode) / 1000.0f).append('\t').append(JmolConstants.elementSymbolFromNumber(i)).append('\n');
        }
        return bs == null ? sb.toString() : "\n  DATA \"element_vdw\"\n" + sb.append("  end \"element_vdw\";\n\n").toString();
    }
}

