/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;
import org.jmol.api.JmolFileReaderInterface;
import org.jmol.api.JmolViewer;
import org.jmol.util.BinaryDocument;
import org.jmol.util.CompoundDocument;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;
import org.jmol.util.ZipUtil;
import org.jmol.viewer.MonitorInputStream;
import org.jmol.viewer.Viewer;

public class FileManager {
    protected Viewer viewer;
    private String openErrorMessage;
    private URL appletDocumentBase = null;
    private URL appletCodeBase = null;
    private String appletProxy;
    private String nameAsGiven = "zapped";
    private String fullPathName;
    private String fileName;
    private String fileType;
    private String inlineData;
    private String loadScript;
    FileReaderThread fileReaderThread;
    FilesReaderThread filesReaderThread;
    private DOMReaderThread aDOMReaderThread;
    private static final int URL_LOCAL = 3;
    private static final String[] urlPrefixes = new String[]{"http:", "https:", "ftp:", "file:"};
    private static final String[] urlPrefixPairs = new String[]{"http:", "http://", "www.", "http://www.", "https:", "https://", "ftp:", "ftp://", "file:", "file:///"};

    String getInlineData(int iData) {
        return iData < 0 ? this.inlineData : "";
    }

    FileManager(Viewer viewer) {
        this.viewer = viewer;
        this.clear();
    }

    String getState(StringBuffer sfunc) {
        StringBuffer commands = new StringBuffer();
        if (sfunc != null) {
            sfunc.append("  _setFileState;\n");
            commands.append("function _setFileState() {\n\n");
        }
        commands.append(this.loadScript);
        if (this.viewer.getModelSetFileName().equals("zapped")) {
            commands.append("  zap;\n");
        }
        if (sfunc != null) {
            commands.append("\n}\n\n");
        }
        return commands.toString();
    }

    String getFileTypeName(String fileName) {
        int pt = fileName.indexOf("::");
        if (pt >= 0) {
            return fileName.substring(0, pt);
        }
        Object br = this.getUnzippedBufferedReaderOrErrorMessageFromName(fileName, true, false, true, true);
        if (br instanceof BufferedReader) {
            return this.viewer.getModelAdapter().getFileTypeName((BufferedReader)br);
        }
        if (br instanceof ZipInputStream) {
            String zipDirectory = this.getZipDirectoryAsString(fileName);
            return this.viewer.getModelAdapter().getFileTypeName(FileManager.getBufferedReaderForString(zipDirectory));
        }
        if (br instanceof String[]) {
            return ((String[])br)[0];
        }
        return null;
    }

    void clear() {
        this.setLoadScript("", false);
        this.nameAsGiven = "zapped";
        this.fileName = "zapped";
        this.fullPathName = "zapped";
    }

    String getLoadScript() {
        return this.loadScript;
    }

    private void setLoadScript(String script, boolean isAppend) {
        if (this.loadScript == null || !isAppend) {
            this.loadScript = "";
        }
        this.loadScript = this.loadScript + this.viewer.getLoadState();
        this.addLoadScript(script);
    }

    void addLoadScript(String script) {
        if (script == null) {
            return;
        }
        if (script.equals("-")) {
            this.loadScript = "";
            return;
        }
        this.loadScript = this.loadScript + "  " + script + ";\n";
    }

    void createAtomSetCollectionFromFile(String name, Hashtable htParams, String loadScript, boolean isAppend) {
        int pt;
        if (htParams.get("atomDataOnly") == null) {
            this.setLoadScript(loadScript, isAppend);
        }
        this.nameAsGiven = (pt = name.indexOf("::")) >= 0 ? name.substring(pt + 2) : name;
        this.fileType = pt >= 0 ? name.substring(0, pt) : null;
        Logger.info("\nFileManager.getAtomSetCollectionFromFile(" + this.nameAsGiven + ") //" + name);
        this.fileName = null;
        this.fullPathName = null;
        this.openErrorMessage = null;
        String[] names = this.classifyName(this.nameAsGiven, true);
        if (names == null) {
            return;
        }
        this.setNames(names);
        htParams.put("fullPathName", (this.fileType == null ? "" : this.fileType + "::") + this.fullPathName.replace('\\', '/'));
        if (this.openErrorMessage != null) {
            Logger.error("file ERROR: " + this.openErrorMessage);
            return;
        }
        if (this.viewer.getMessageStyleChime() && this.viewer.getDebugScript()) {
            this.viewer.scriptStatus("Requesting " + this.fullPathName);
        }
        this.fileReaderThread = new FileReaderThread(this.fullPathName, this.nameAsGiven, this.fileType, null, htParams);
        this.fileReaderThread.run();
    }

    void createAtomSetCollectionFromFiles(String modelName, String[] fileNames, String loadScript, boolean isAppend, Hashtable htParams) {
        this.setLoadScript(loadScript, isAppend);
        String[] fullPathNames = new String[fileNames.length];
        String[] namesAsGiven = new String[fileNames.length];
        String[] fileTypes = new String[fileNames.length];
        for (int i = 0; i < fileNames.length; ++i) {
            int pt = fileNames[i].indexOf("::");
            this.nameAsGiven = pt >= 0 ? fileNames[i].substring(pt + 2) : fileNames[i];
            this.fileType = pt >= 0 ? fileNames[i].substring(0, pt) : null;
            this.fileName = null;
            this.fullPathName = null;
            this.openErrorMessage = null;
            String[] thenames = this.classifyName(this.nameAsGiven, true);
            if (thenames == null) {
                return;
            }
            this.setNames(thenames);
            if (this.openErrorMessage != null) {
                Logger.error("file ERROR: " + this.openErrorMessage);
                return;
            }
            fullPathNames[i] = this.fullPathName;
            fileNames[i] = this.fullPathName.replace('\\', '/');
            fileTypes[i] = this.fileType;
            namesAsGiven[i] = this.nameAsGiven;
        }
        this.fileName = this.nameAsGiven = modelName;
        this.fullPathName = this.nameAsGiven;
        this.inlineData = "";
        this.filesReaderThread = new FilesReaderThread(fullPathNames, namesAsGiven, fileTypes, null, htParams);
        this.filesReaderThread.run();
    }

    void createAtomSetCollectionFromString(String strModel, Hashtable htParams, boolean isAppend) {
        String tag = isAppend ? "append" : "model";
        String script = "data \"" + tag + " inline\"\n" + strModel + "end \"" + tag + " inline\";";
        this.setLoadScript(script, isAppend);
        Logger.info("FileManager.getAtomSetCollectionFromString()");
        this.openErrorMessage = null;
        this.fileName = "string";
        this.fullPathName = "string";
        this.inlineData = strModel;
        this.fileReaderThread = new FileReaderThread("string", "string", null, FileManager.getBufferedReaderForString(strModel), htParams);
        this.fileReaderThread.run();
    }

    void createAtomSeCollectionFromStrings(String[] arrayModels, Hashtable htParams, boolean isAppend) {
        String oldSep = "\"" + this.viewer.getDataSeparator() + "\"";
        String tag = "\"" + (isAppend ? "append" : "model") + " inline\"";
        String script = "set dataSeparator \"~~~next file~~~\";\ndata " + tag;
        for (int i = 0; i < arrayModels.length; ++i) {
            if (i > 0) {
                script = script + "~~~next file~~~";
            }
            script = script + arrayModels[i];
        }
        script = script + "end " + tag + ";set dataSeparator " + oldSep;
        this.setLoadScript(script, isAppend);
        Logger.info("FileManager.getAtomSetCollectionFromStrings(string[])");
        this.openErrorMessage = null;
        this.fileName = "string[]";
        this.fullPathName = "string[]";
        this.inlineData = "";
        String[] fullPathNames = new String[arrayModels.length];
        Reader[] readers = new StringReader[arrayModels.length];
        for (int i = 0; i < arrayModels.length; ++i) {
            fullPathNames[i] = "string[" + i + "]";
            readers[i] = new StringReader(arrayModels[i]);
        }
        this.filesReaderThread = new FilesReaderThread(fullPathNames, fullPathNames, null, readers, null);
        this.filesReaderThread.run();
    }

    void createAtomSetCollectionFromDOM(Object DOMNode) {
        this.openErrorMessage = null;
        this.fileName = "JSNode";
        this.fullPathName = "JSNode";
        this.inlineData = "";
        this.aDOMReaderThread = new DOMReaderThread(DOMNode);
        this.aDOMReaderThread.run();
    }

    void createAtomSetCollectionFromReader(String fullPathName, String name, Reader reader) {
        this.openErrorMessage = null;
        this.fullPathName = fullPathName;
        this.fileName = name;
        this.fileType = null;
        this.fileReaderThread = new FileReaderThread(fullPathName, fullPathName, this.fileType, new BufferedReader(reader), null);
        this.fileReaderThread.run();
    }

    static boolean isGzip(InputStream is) throws Exception {
        byte[] abMagic = new byte[4];
        is.mark(5);
        int countRead = is.read(abMagic, 0, 4);
        is.reset();
        return countRead == 4 && abMagic[0] == 31 && abMagic[1] == -117;
    }

    public Object getFileAsBytes(String name) {
        Object t;
        if (name == null) {
            return null;
        }
        String[] subFileList = null;
        if (name.indexOf("|") >= 0) {
            subFileList = TextFormat.split(name, "|");
            name = subFileList[0];
        }
        if ((t = this.getInputStreamOrErrorMessageFromName(name, false)) instanceof String) {
            return "Error:" + t;
        }
        try {
            BufferedInputStream bis;
            BufferedInputStream is = bis = new BufferedInputStream((InputStream)t, 8192);
            byte[] bytes = ZipUtil.isZipFile(is) && subFileList != null && 1 < subFileList.length ? ZipUtil.getZipFileContentsAsBytes(is, subFileList, 1) : ZipUtil.getStreamAsBytes(bis);
            ((InputStream)is).close();
            return bytes;
        }
        catch (Exception ioe) {
            return ioe.getMessage();
        }
    }

    boolean getFileDataOrErrorAsString(String[] data, int nBytesMax, boolean doSpecialLoad) {
        data[1] = "";
        String name = data[0];
        if (name == null) {
            return false;
        }
        Object t = this.getBufferedReaderOrErrorMessageFromName(name, data, false, doSpecialLoad);
        if (t instanceof String) {
            data[1] = (String)t;
            return false;
        }
        try {
            BufferedReader br = (BufferedReader)t;
            StringBuffer sb = new StringBuffer(8192);
            if (nBytesMax == Integer.MAX_VALUE) {
                String line;
                while ((line = br.readLine()) != null) {
                    sb.append(line).append('\n');
                }
            } else {
                String line;
                int len;
                for (int n = 0; n < nBytesMax && (line = br.readLine()) != null; n += len + 1) {
                    len = line.length();
                    if (nBytesMax - n < len + 1) {
                        line = line.substring(0, nBytesMax - n - 1);
                    }
                    sb.append(line).append('\n');
                }
            }
            br.close();
            data[1] = sb.toString();
            return true;
        }
        catch (Exception ioe) {
            data[1] = ioe.getMessage();
            return false;
        }
    }

    Object getFileAsImage(String name, Hashtable htParams) {
        if (name == null) {
            return "";
        }
        String[] names = this.classifyName(name, true);
        if (names == null) {
            return "cannot read file name: " + name;
        }
        Image image = null;
        this.fullPathName = names[0].replace('\\', '/');
        if (FileManager.urlTypeIndex(this.fullPathName) >= 0) {
            try {
                image = Toolkit.getDefaultToolkit().createImage(new URL(this.fullPathName));
            }
            catch (Exception e) {
                return "bad URL: " + this.fullPathName;
            }
        } else {
            image = Toolkit.getDefaultToolkit().createImage(this.fullPathName);
        }
        try {
            MediaTracker mediaTracker = new MediaTracker(this.viewer.getDisplay());
            mediaTracker.addImage(image, 0);
            mediaTracker.waitForID(0);
        }
        catch (Exception e) {
            return e.getMessage() + " opening " + this.fullPathName;
        }
        if (image.getWidth(null) < 1) {
            return "invalid or missing image " + this.fullPathName;
        }
        htParams.put("fullPathName", this.fullPathName);
        return image;
    }

    private String getFileDataAsSections(String[] info, Hashtable fileData) {
        String header = info[1];
        StringBuffer sb = new StringBuffer();
        sb.append(fileData.get(fileData.get("OUTPUT")));
        for (int i = 2; i < info.length; ++i) {
            String name = info[i];
            name = this.getFileDataAsSections(name, header, fileData);
            Logger.info("reading " + name);
            String s = (String)fileData.get(name);
            sb.append(s);
        }
        return sb.toString();
    }

    private String getFileDataAsSections(String name, String header, Hashtable fileData) {
        if (name == null) {
            return null;
        }
        String[] subFileList = null;
        boolean asBinaryString = false;
        String name0 = name.replace('\\', '/');
        if (name.indexOf(":asBinaryString") >= 0) {
            asBinaryString = true;
            name = name.substring(0, name.indexOf(":asBinaryString"));
        }
        StringBuffer sb = null;
        if (fileData.containsKey(name0)) {
            return name0;
        }
        if (name.indexOf("#JMOL_MODEL ") >= 0) {
            fileData.put(name0, name0 + "\n");
            return name0;
        }
        if (name.indexOf("|") >= 0) {
            subFileList = TextFormat.split(name, "|");
            name = subFileList[0];
        }
        BufferedInputStream bis = null;
        try {
            Object t = this.getInputStreamOrErrorMessageFromName(name, false);
            if (t instanceof String) {
                fileData.put(name0, (String)t + "\n");
                return name0;
            }
            bis = new BufferedInputStream((InputStream)t, 8192);
            if (CompoundDocument.isCompoundDocument(bis)) {
                CompoundDocument doc = new CompoundDocument(bis);
                doc.getAllData(name.replace('\\', '/'), "Molecule", fileData);
            } else if (ZipUtil.isZipFile(bis)) {
                ZipUtil.getAllData(bis, subFileList, name.replace('\\', '/'), "Molecule", fileData);
            } else if (asBinaryString) {
                BinaryDocument bd = new BinaryDocument();
                bd.setStream(bis, false);
                sb = new StringBuffer();
                if (header != null) {
                    sb.append("BEGIN Directory Entry " + name0 + "\n");
                }
                try {
                    while (true) {
                        sb.append(Integer.toHexString(bd.readByte() & 0xFF)).append(' ');
                    }
                }
                catch (Exception e1) {
                    sb.append('\n');
                    if (header != null) {
                        sb.append("\nEND Directory Entry " + name0 + "\n");
                    }
                    fileData.put(name0, sb.toString());
                }
            } else {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(FileManager.isGzip(bis) ? new GZIPInputStream(bis) : bis));
                sb = new StringBuffer();
                if (header != null) {
                    sb.append("BEGIN Directory Entry " + name0 + "\n");
                }
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                    sb.append('\n');
                }
                br.close();
                if (header != null) {
                    sb.append("\nEND Directory Entry " + name0 + "\n");
                }
                fileData.put(name0, sb.toString());
            }
        }
        catch (Exception ioe) {
            fileData.put(name0, ioe.getMessage());
        }
        if (bis != null) {
            try {
                bis.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!fileData.containsKey(name0)) {
            fileData.put(name0, "FILE NOT FOUND: " + name0 + "\n");
        }
        return name0;
    }

    Object getAtomSetCollectionOrError() {
        Object atomSetCollection = null;
        if (this.fileReaderThread != null) {
            atomSetCollection = this.fileReaderThread.atomSetCollection;
            if (this.fileReaderThread.errorMessage != null) {
                this.openErrorMessage = this.fileReaderThread.errorMessage;
            }
        } else if (this.filesReaderThread != null) {
            atomSetCollection = this.filesReaderThread.atomSetCollection;
            if (this.filesReaderThread.errorMessage != null) {
                this.openErrorMessage = this.filesReaderThread.errorMessage;
            }
        } else if (this.aDOMReaderThread != null) {
            atomSetCollection = this.aDOMReaderThread.atomSetCollection;
            if (this.aDOMReaderThread.errorMessage != null) {
                this.openErrorMessage = this.aDOMReaderThread.errorMessage;
            }
        }
        if (this.openErrorMessage != null) {
            return this.openErrorMessage;
        }
        if (atomSetCollection == null) {
            return "Client file is null loading:" + this.nameAsGiven;
        }
        return atomSetCollection;
    }

    void deallocateReaderThreads() {
        this.fileReaderThread = null;
        this.filesReaderThread = null;
        this.aDOMReaderThread = null;
        this.openErrorMessage = null;
    }

    String getFullPathName() {
        return this.fullPathName != null ? this.fullPathName : this.nameAsGiven;
    }

    void setFileInfo(String[] fileInfo) {
        try {
            this.fullPathName = fileInfo[0];
            this.fileName = fileInfo[1];
            this.inlineData = fileInfo[2];
            this.loadScript = fileInfo[3];
        }
        catch (Exception e) {
            Logger.error("Exception saving file info: " + e.getMessage());
        }
    }

    String[] getFileInfo() {
        return new String[]{this.fullPathName, this.fileName, this.inlineData, this.loadScript};
    }

    String getFileName() {
        return this.fileName != null ? this.fileName : this.nameAsGiven;
    }

    String getAppletDocumentBase() {
        if (this.appletDocumentBase == null) {
            return "";
        }
        return this.appletDocumentBase.toString();
    }

    void setAppletContext(URL documentBase, URL codeBase, String jmolAppletProxy) {
        this.appletDocumentBase = documentBase;
        this.appletCodeBase = codeBase;
        Logger.info("appletDocumentBase=" + this.appletDocumentBase + "\nappletCodeBase=" + this.appletCodeBase);
        this.appletProxy = jmolAppletProxy;
    }

    void setAppletProxy(String appletProxy) {
        this.appletProxy = appletProxy == null || appletProxy.length() == 0 ? null : appletProxy;
    }

    private static int urlTypeIndex(String name) {
        for (int i = 0; i < urlPrefixes.length; ++i) {
            if (!name.startsWith(urlPrefixes[i])) continue;
            return i;
        }
        return -1;
    }

    private void setNames(String[] names) {
        if (names == null) {
            return;
        }
        this.fullPathName = names[0];
        this.fileName = names[1];
    }

    static String shortNameOf(String name) {
        name = TextFormat.trim(name.replace('\\', '/'), "/");
        return name.substring(name.lastIndexOf("/") + 1);
    }

    private String[] classifyName(String name, boolean isFullLoad) {
        String path;
        int pt;
        if (name == null) {
            return null;
        }
        if (name.startsWith("?") && (name = this.viewer.dialogAsk("load", name.substring(1))) == null) {
            if (isFullLoad) {
                this.openErrorMessage = "#CANCELED#";
            }
            return null;
        }
        File file = null;
        URL url = null;
        String[] names = null;
        if (name.indexOf("=") == 0) {
            name = TextFormat.formatString(this.viewer.getLoadFormat(), "FILE", name.substring(1));
        }
        if (name.indexOf(":") < 0 && name.indexOf("/") != 0) {
            name = FileManager.addDirectory(this.viewer.getDefaultDirectory(), name);
        }
        if (this.appletDocumentBase != null) {
            try {
                if (name.indexOf(":\\") == 1 || name.indexOf(":/") == 1) {
                    name = "file:/" + name;
                } else if (name.indexOf("/") == 0 && this.viewer.getBooleanProperty("_signedApplet")) {
                    name = "file:" + name;
                }
                url = new URL(this.appletDocumentBase, name);
            }
            catch (MalformedURLException e) {
                if (isFullLoad) {
                    this.openErrorMessage = e.getMessage();
                }
                return null;
            }
        } else if (FileManager.urlTypeIndex(name) >= 0) {
            try {
                url = new URL(name);
            }
            catch (MalformedURLException e) {
                if (isFullLoad) {
                    this.openErrorMessage = e.getMessage();
                }
                return null;
            }
        } else {
            file = new File(name);
            names = new String[]{file.getAbsolutePath(), file.getName(), "file:/" + file.getAbsolutePath().replace('\\', '/')};
        }
        if (url != null) {
            names = new String[3];
            names[0] = names[2] = url.toString();
            names[1] = names[0].substring(names[0].lastIndexOf(47) + 1);
        }
        if (isFullLoad && (file != null || FileManager.urlTypeIndex(names[0]) == 3) && (pt = (path = file == null ? TextFormat.trim(names[0].substring(5), "/") : names[0]).length() - names[1].length() - 1) > 0) {
            path = path.substring(0, pt);
            FileManager.setLocalPath(this.viewer, path, true);
        }
        return names;
    }

    String getDefaultDirectory(String name) {
        String[] names = this.classifyName(name, true);
        if (names == null) {
            return "";
        }
        name = this.fixPath(names[0]);
        return names == null ? "" : name.substring(0, name.lastIndexOf("/"));
    }

    private String fixPath(String path) {
        path = path.replace('\\', '/');
        int pt = (path = TextFormat.simpleReplace(path, "/./", "/")).lastIndexOf("//") + 1;
        if (pt < 1) {
            pt = path.indexOf(":/") + 1;
        }
        if (pt < 1) {
            pt = path.indexOf("/");
        }
        String protocol = path.substring(0, pt);
        path = path.substring(pt);
        while ((pt = path.lastIndexOf("/../")) >= 0) {
            int pt0 = path.substring(0, pt).lastIndexOf("/");
            if (pt0 < 0) {
                return TextFormat.simpleReplace(protocol + path, "/../", "/");
            }
            path = path.substring(0, pt0) + path.substring(pt + 3);
        }
        if (path.length() == 0) {
            path = "/";
        }
        return protocol + path;
    }

    public String getFullPath(String name, boolean addUrlPrefix) {
        String[] names = this.classifyName(name, false);
        return names == null ? "" : (addUrlPrefix ? names[2] : names[0].replace('\\', '/'));
    }

    public static String getLocalUrl(File file) {
        int i;
        if (file.getName().startsWith("=")) {
            return file.getName();
        }
        String path = file.getAbsolutePath().replace('\\', '/');
        for (i = 0; i < urlPrefixPairs.length; ++i) {
            if (path.indexOf(urlPrefixPairs[i]) != 0) continue;
            return null;
        }
        for (i = 0; i < urlPrefixPairs.length; i += 2) {
            if (path.indexOf(urlPrefixPairs[i]) <= 0) continue;
            return urlPrefixPairs[i + 1] + TextFormat.trim(path.substring(path.indexOf(urlPrefixPairs[i]) + urlPrefixPairs[i].length()), "/");
        }
        return null;
    }

    public static File getLocalDirectory(JmolViewer viewer, boolean forDialog) {
        File f;
        String localDir = (String)viewer.getParameter(forDialog ? "currentLocalPath" : "defaultDirectoryLocal");
        if (localDir.length() == 0 && forDialog) {
            localDir = (String)viewer.getParameter("defaultDirectoryLocal");
        }
        if (localDir.length() == 0) {
            return viewer.isApplet() ? null : new File(System.getProperty("user.dir"));
        }
        if (viewer.isApplet() && localDir.indexOf("file:/") == 0) {
            localDir = FileManager.setLocalPathForWritingFile(viewer, localDir);
        }
        return (f = new File(localDir)).isDirectory() ? f : f.getParentFile();
    }

    public static void setLocalPath(JmolViewer viewer, String path, boolean forDialog) {
        while (path.endsWith("/") || path.endsWith("\\")) {
            path = path.substring(0, path.length() - 1);
        }
        viewer.setStringProperty("currentLocalPath", path);
        if (!forDialog) {
            viewer.setStringProperty("defaultDirectoryLocal", path);
        }
    }

    public static String setLocalPathForWritingFile(JmolViewer viewer, String file) {
        if (file.indexOf("file:/") == 0) {
            return file.substring(6);
        }
        if (file.indexOf("/") == 0 || file.indexOf(":") >= 0) {
            return file;
        }
        File dir = FileManager.getLocalDirectory(viewer, false);
        return dir == null ? file : dir.toString().replace('\\', '/') + "/" + file;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String addDirectory(String defaultDirectory, String name) {
        String string;
        if (defaultDirectory.length() == 0) {
            return name;
        }
        int ch = name.length() > 0 ? (int)name.charAt(0) : 32;
        String s = defaultDirectory.toLowerCase();
        if ((s.endsWith(".zip") || s.endsWith(".tar")) && ch != 124 && ch != 47) {
            defaultDirectory = defaultDirectory + "|";
        }
        StringBuffer stringBuffer = new StringBuffer().append(defaultDirectory);
        if (ch != 47 && ch != 47) {
            char c = defaultDirectory.charAt(defaultDirectory.length() - 1);
            ch = c;
            if (c != '|' && ch != 47) {
                string = "/";
                return stringBuffer.append(string).append(name).toString();
            }
        }
        string = "";
        return stringBuffer.append(string).append(name).toString();
    }

    Object getInputStreamOrErrorMessageFromName(String name, boolean showMsg) {
        return FileManager.getInputStream(name, showMsg, this.appletDocumentBase, this.appletProxy);
    }

    public static Object getInputStream(String name, boolean showMsg, URL appletDocumentBase, String appletProxy) {
        String errorMessage = null;
        int iurlPrefix = urlPrefixes.length;
        while (--iurlPrefix >= 0 && !name.startsWith(urlPrefixes[iurlPrefix])) {
        }
        boolean isURL = iurlPrefix >= 0;
        boolean isApplet = appletDocumentBase != null;
        InputStream in = null;
        try {
            int length;
            if (isApplet || isURL) {
                if (isApplet && isURL && appletProxy != null) {
                    name = appletProxy + "?url=" + URLEncoder.encode(name, "utf-8");
                }
                URL url = isApplet ? new URL(appletDocumentBase, name) : new URL(name);
                name = url.toString();
                if (showMsg) {
                    Logger.info("FileManager opening " + url.toString());
                }
                URLConnection conn = url.openConnection();
                length = conn.getContentLength();
                in = conn.getInputStream();
            } else {
                if (showMsg) {
                    Logger.info("FileManager opening " + name);
                }
                File file = new File(name);
                length = (int)file.length();
                in = new FileInputStream(file);
            }
            return new MonitorInputStream(in, length);
        }
        catch (Exception e) {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e1) {
                // empty catch block
            }
            errorMessage = "" + e;
            return errorMessage;
        }
    }

    public static BufferedReader getBufferedReaderForString(String string) {
        return new BufferedReader(new StringReader(string));
    }

    Object getBufferedReaderOrErrorMessageFromName(String name, String[] fullPathNameReturn, boolean isBinary, boolean doSpecialLoad) {
        String[] names = this.classifyName(name, true);
        if (names == null) {
            return "cannot read file name: " + name;
        }
        if (fullPathNameReturn != null) {
            fullPathNameReturn[0] = names[0].replace('\\', '/');
        }
        return this.getUnzippedBufferedReaderOrErrorMessageFromName(names[0], false, isBinary, false, doSpecialLoad);
    }

    Object getUnzippedBufferedReaderOrErrorMessageFromName(String name, boolean allowZipStream, boolean asInputStream, boolean isTypeCheckOnly, boolean doSpecialLoad) {
        Object t;
        String[] info;
        String[] subFileList = null;
        String[] stringArray = info = doSpecialLoad ? this.viewer.getModelAdapter().specialLoad(name, "filesNeeded?") : null;
        if (info != null) {
            if (isTypeCheckOnly) {
                return info;
            }
            if (info[2] != null) {
                String header = info[1];
                Hashtable<String, String> fileData = new Hashtable<String, String>();
                if (info.length == 3) {
                    String name0 = this.getFileDataAsSections(info[2], header, fileData);
                    fileData.put("OUTPUT", name0);
                    info = this.viewer.getModelAdapter().specialLoad(name, (String)fileData.get(name0));
                    if (info.length == 3) {
                        name0 = this.getFileDataAsSections(info[2], header, fileData);
                        fileData.put("OUTPUT", name0);
                        info = this.viewer.getModelAdapter().specialLoad(info[1], (String)fileData.get(name0));
                    }
                }
                return FileManager.getBufferedReaderForString(this.getFileDataAsSections(info, fileData));
            }
        }
        if (name.indexOf("|") >= 0) {
            subFileList = TextFormat.split(name, "|");
            name = subFileList[0];
        }
        if ((t = this.getInputStreamOrErrorMessageFromName(name, true)) instanceof String) {
            return t;
        }
        try {
            BufferedInputStream bis;
            BufferedInputStream is = bis = new BufferedInputStream((InputStream)t, 8192);
            if (CompoundDocument.isCompoundDocument(is)) {
                CompoundDocument doc = new CompoundDocument(bis);
                return FileManager.getBufferedReaderForString(doc.getAllData("Molecule").toString());
            }
            if (FileManager.isGzip(is)) {
                while (FileManager.isGzip(is = new BufferedInputStream(new GZIPInputStream(is)))) {
                }
            } else if (ZipUtil.isZipFile(is)) {
                if (allowZipStream) {
                    return new ZipInputStream(bis);
                }
                if (asInputStream) {
                    return (InputStream)ZipUtil.getZipFileContents(is, subFileList, 1, true);
                }
                String s = (String)ZipUtil.getZipFileContents(is, subFileList, 1, false);
                ((InputStream)is).close();
                return FileManager.getBufferedReaderForString(s);
            }
            if (asInputStream) {
                return is;
            }
            return new BufferedReader(new InputStreamReader(is));
        }
        catch (Exception ioe) {
            return ioe.getMessage();
        }
    }

    String[] getZipDirectory(String fileName, boolean addManifest) {
        return ZipUtil.getZipDirectoryAndClose((InputStream)this.getInputStreamOrErrorMessageFromName(fileName, false), addManifest);
    }

    String getZipDirectoryAsString(String fileName) {
        return ZipUtil.getZipDirectoryAsStringAndClose((InputStream)this.getInputStreamOrErrorMessageFromName(fileName, false));
    }

    class FilesReaderThread
    implements Runnable,
    JmolFileReaderInterface {
        String errorMessage;
        private String[] fullPathNamesInThread;
        private String[] namesAsGivenInThread;
        private String[] fileTypesInThread;
        Object atomSetCollection;
        private Reader[] stringReaders;
        private Hashtable[] htParamsSet;
        private Hashtable htParams;

        FilesReaderThread(String[] name, String[] nameAsGiven, String[] types, Reader[] readers, Hashtable htParams) {
            this.fullPathNamesInThread = name;
            this.namesAsGivenInThread = nameAsGiven;
            this.fileTypesInThread = types;
            this.stringReaders = readers;
            this.htParams = htParams;
        }

        public void run() {
            if (this.stringReaders != null) {
                this.createAtomSetCollection();
                this.stringReaders = null;
            } else {
                this.htParamsSet = new Hashtable[this.fullPathNamesInThread.length];
                for (int i = 0; i < this.htParamsSet.length; ++i) {
                    this.htParamsSet[i] = this.htParams;
                }
                Object atomSetCollectionOrError = FileManager.this.viewer.getModelAdapter().getAtomSetCollectionFromReaders(this, this.fullPathNamesInThread, this.fileTypesInThread, this.htParamsSet);
                if (atomSetCollectionOrError instanceof String) {
                    this.errorMessage = (String)atomSetCollectionOrError;
                } else {
                    this.atomSetCollection = atomSetCollectionOrError;
                }
                if (this.errorMessage != null) {
                    Logger.error("file ERROR: " + this.errorMessage);
                }
            }
        }

        private void createAtomSetCollection() {
            Object atomSetCollectionOrError = FileManager.this.viewer.getModelAdapter().getAtomSetCollectionFromReaders(this, this.fullPathNamesInThread, this.fileTypesInThread, null);
            if (atomSetCollectionOrError == null) {
                return;
            }
            if (atomSetCollectionOrError instanceof String) {
                this.errorMessage = (String)atomSetCollectionOrError;
            } else {
                this.atomSetCollection = atomSetCollectionOrError;
            }
        }

        public BufferedReader getBufferedReader(int i) {
            Object t;
            if (this.stringReaders != null) {
                return new BufferedReader(this.stringReaders[i]);
            }
            String name = this.fullPathNamesInThread[i];
            String[] subFileList = null;
            Hashtable htParams = this.htParamsSet[0];
            htParams.remove("subFileList");
            if (name.indexOf("|") >= 0) {
                subFileList = TextFormat.split(name, "|");
                name = subFileList[0];
            }
            if ((t = FileManager.this.getUnzippedBufferedReaderOrErrorMessageFromName(name, true, false, false, true)) instanceof ZipInputStream) {
                if (subFileList != null) {
                    htParams.put("subFileList", subFileList);
                }
                String[] zipDirectory = FileManager.this.getZipDirectory(name, true);
                BufferedInputStream is = new BufferedInputStream((InputStream)FileManager.this.getInputStreamOrErrorMessageFromName(name, false), 8192);
                t = FileManager.this.viewer.getModelAdapter().getAtomSetCollectionOrBufferedReaderFromZip(is, name, zipDirectory, htParams, true);
            }
            if (t instanceof BufferedReader) {
                return (BufferedReader)t;
            }
            this.errorMessage = t == null ? "error opening:" + this.namesAsGivenInThread[i] : (String)t;
            return null;
        }
    }

    class FileReaderThread
    implements Runnable {
        String errorMessage;
        String fullPathNameInThread;
        String nameAsGivenInThread;
        String fileTypeInThread;
        Object atomSetCollection;
        BufferedReader reader;
        Hashtable htParams;

        FileReaderThread(String name, String nameAsGiven, String type, BufferedReader reader, Hashtable htParams) {
            this.fullPathNameInThread = name;
            this.nameAsGivenInThread = nameAsGiven;
            this.fileTypeInThread = type;
            this.reader = reader;
            this.htParams = htParams;
        }

        public void run() {
            if (this.reader != null) {
                this.createAtomSetCollection();
            } else {
                String name = this.fullPathNameInThread;
                String[] subFileList = null;
                Object t = FileManager.this.getUnzippedBufferedReaderOrErrorMessageFromName(name, true, false, false, true);
                if (name.indexOf("|") >= 0) {
                    subFileList = TextFormat.split(name, "|");
                    name = subFileList[0];
                }
                if (t instanceof BufferedReader) {
                    this.reader = (BufferedReader)t;
                    this.createAtomSetCollection();
                } else if (t instanceof ZipInputStream) {
                    if (subFileList != null) {
                        this.htParams.put("subFileList", subFileList);
                    }
                    this.createAtomSetCollection(name, (ZipInputStream)t);
                } else {
                    String string = this.errorMessage = t == null ? "error opening:" + this.nameAsGivenInThread : (String)t;
                }
            }
            if (this.errorMessage != null) {
                Logger.error("file ERROR: " + this.fullPathNameInThread + "\n" + this.errorMessage);
            }
        }

        private void createAtomSetCollection(String fileName, ZipInputStream zis) {
            String[] zipDirectory = FileManager.this.getZipDirectory(fileName, true);
            Object atomSetCollectionOrError = FileManager.this.viewer.getModelAdapter().getAtomSetCollectionOrBufferedReaderFromZip(zis, fileName, zipDirectory, this.htParams, false);
            if (atomSetCollectionOrError instanceof String) {
                this.errorMessage = (String)atomSetCollectionOrError;
            } else {
                this.atomSetCollection = atomSetCollectionOrError;
            }
            try {
                zis.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }

        private void createAtomSetCollection() {
            Object atomSetCollectionOrError = FileManager.this.viewer.getModelAdapter().getAtomSetCollectionFromReader(this.fullPathNameInThread, this.fileTypeInThread, this.reader, this.htParams);
            if (atomSetCollectionOrError instanceof String) {
                this.errorMessage = (String)atomSetCollectionOrError;
            } else {
                this.atomSetCollection = atomSetCollectionOrError;
            }
        }
    }

    class DOMReaderThread
    implements Runnable {
        String errorMessage;
        Object aDOMNode;
        Object atomSetCollection;

        DOMReaderThread(Object DOMNode) {
            this.aDOMNode = DOMNode;
        }

        public void run() {
            this.atomSetCollection = FileManager.this.viewer.getModelAdapter().getAtomSetCollectionFromDOM(this.aDOMNode);
            this.errorMessage = null;
        }
    }
}

