/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.io.BufferedReader;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolFileReaderInterface;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.ModelSet;
import org.jmol.viewer.Viewer;

public final class FrameExportJmolAdapter
extends JmolAdapter {
    Viewer viewer;
    ModelSet modelSet;

    FrameExportJmolAdapter(Viewer viewer, ModelSet modelSet) {
        super("FrameExportJmolAdapter");
        this.viewer = viewer;
        this.modelSet = modelSet;
    }

    public String getAtomSetCollectionName(Object clientFile) {
        return this.viewer.getModelSetName();
    }

    public int getEstimatedAtomCount(Object clientFile) {
        return this.modelSet.getAtomCount();
    }

    public float[] getNotionalUnitcell(Object clientFile) {
        return this.modelSet.getNotionalUnitcell();
    }

    public JmolAdapter.AtomIterator getAtomIterator(Object clientFile) {
        return new AtomIterator();
    }

    public JmolAdapter.BondIterator getBondIterator(Object clientFile) {
        return new BondIterator();
    }

    public JmolAdapter.StructureIterator getStructureIterator(Object atomSetCollection) {
        return null;
    }

    public Object getAtomSetCollectionFromReader(String name, String type, BufferedReader bufferedReader, Hashtable htParams) {
        return null;
    }

    public Object getAtomSetCollectionFromReaders(JmolFileReaderInterface fileReader, String[] names, String[] types, Hashtable[] htParams) {
        return null;
    }

    public Object getAtomSetCollectionOrBufferedReaderFromZip(InputStream is, String fileName, String[] zipDirectory, Hashtable htParams, boolean asBufferedReader) {
        return null;
    }

    public Object getAtomSetCollectionFromDOM(Object DOMNode) {
        return null;
    }

    public String getFileTypeName(Object atomSetCollection) {
        return null;
    }

    public Properties getAtomSetCollectionProperties(Object atomSetCollection) {
        return null;
    }

    public Hashtable getAtomSetCollectionAuxiliaryInfo(Object atomSetCollection) {
        return null;
    }

    public int getAtomSetCount(Object atomSetCollection) {
        return 0;
    }

    public int getAtomSetNumber(Object atomSetCollection, int atomSetIndex) {
        return 0;
    }

    public String getAtomSetName(Object atomSetCollection, int atomSetIndex) {
        return null;
    }

    public Properties getAtomSetProperties(Object atomSetCollection, int atomSetIndex) {
        return null;
    }

    public Hashtable getAtomSetAuxiliaryInfo(Object atomSetCollection, int atomSetIndex) {
        return null;
    }

    public boolean coordinatesAreFractional(Object atomSetCollection) {
        return false;
    }

    public float[] getPdbScaleMatrix(Object atomSetCollection) {
        return null;
    }

    public float[] getPdbScaleTranslate(Object atomSetCollection) {
        return null;
    }

    public String getClientAtomStringProperty(Object clientAtom, String propertyName) {
        return null;
    }

    class BondIterator
    extends JmolAdapter.BondIterator {
        int ibond;
        Bond bond;

        BondIterator() {
        }

        public boolean hasNext() {
            if (this.ibond >= FrameExportJmolAdapter.this.modelSet.getBondCount()) {
                return false;
            }
            this.bond = FrameExportJmolAdapter.this.modelSet.getBonds()[this.ibond++];
            return true;
        }

        public Object getAtomUniqueID1() {
            return new Integer(this.bond.getAtomIndex1());
        }

        public Object getAtomUniqueID2() {
            return new Integer(this.bond.getAtomIndex2());
        }

        public int getEncodedOrder() {
            return this.bond.getOrder();
        }
    }

    class AtomIterator
    extends JmolAdapter.AtomIterator {
        int iatom;
        Atom atom;

        AtomIterator() {
        }

        public boolean hasNext() {
            if (this.iatom == FrameExportJmolAdapter.this.modelSet.getAtomCount()) {
                return false;
            }
            this.atom = FrameExportJmolAdapter.this.modelSet.atoms[this.iatom++];
            return true;
        }

        public Object getUniqueID() {
            return new Integer(this.iatom);
        }

        public int getElementNumber() {
            return this.atom.getElementNumber();
        }

        public String getElementSymbol() {
            return this.atom.getElementSymbol();
        }

        public int getFormalCharge() {
            return this.atom.getFormalCharge();
        }

        public float getPartialCharge() {
            return this.atom.getPartialCharge();
        }

        public float getX() {
            return this.atom.x;
        }

        public float getY() {
            return this.atom.y;
        }

        public float getZ() {
            return this.atom.z;
        }
    }
}

