/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.awt.Component;
import java.awt.Event;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.vecmath.Point3f;
import org.jmol.modelset.MeasurementPending;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

public abstract class MouseManager
implements KeyListener {
    protected Viewer viewer;
    protected Thread hoverWatcherThread;
    private int previousDragX;
    private int previousDragY;
    protected int xCurrent = -1000;
    protected int yCurrent = -1000;
    protected long timeCurrent = -1L;
    private boolean drawMode = false;
    private boolean dragSelectedMode = false;
    private boolean measuresEnabled = true;
    private MeasurementPending measurementPending;
    private boolean hoverActive = false;
    private boolean rubberbandSelectionMode = false;
    private int xAnchor;
    private int yAnchor;
    private final Rectangle rectRubber = new Rectangle();
    private int previousClickX;
    private int previousClickY;
    private int previousClickModifiers;
    private int previousClickCount;
    private long previousClickTime;
    private int previousPressedX;
    private int previousPressedY;
    private int previousPressedModifiers;
    private long previousPressedTime;
    private int pressedCount;
    protected int mouseMovedX;
    protected int mouseMovedY;
    protected long mouseMovedTime;
    private String keyBuffer = "";
    boolean isAltKeyReleased = true;
    static final long MAX_DOUBLE_CLICK_MILLIS = 700L;
    static final int LEFT = 16;
    static final int MIDDLE = 8;
    static final int ALT = 8;
    static final int RIGHT = 4;
    static final int CTRL = 2;
    public static final int SHIFT = 1;
    static final int MIDDLE_RIGHT = 12;
    static final int LEFT_MIDDLE_RIGHT = 28;
    static final int CTRL_SHIFT = 3;
    static final int CTRL_ALT = 10;
    static final int CTRL_LEFT = 18;
    static final int CTRL_RIGHT = 6;
    static final int CTRL_MIDDLE = 10;
    static final int CTRL_ALT_LEFT = 26;
    static final int CTRL_ALT_RIGHT = 14;
    public static final int ALT_LEFT = 24;
    public static final int ALT_SHIFT_LEFT = 25;
    public static final int SHIFT_LEFT = 17;
    static final int CTRL_SHIFT_LEFT = 19;
    static final int CTRL_ALT_SHIFT_LEFT = 27;
    static final int SHIFT_MIDDLE = 9;
    static final int CTRL_SHIFT_MIDDLE = 11;
    static final int SHIFT_RIGHT = 5;
    static final int CTRL_SHIFT_RIGHT = 7;
    static final int CTRL_ALT_SHIFT_RIGHT = 15;
    private static final int BUTTON_MODIFIER_MASK = 31;
    static final float wheelClickFractionUp = 1.15f;
    static final float wheelClickFractionDown = 0.86956525f;

    abstract boolean handleOldJvm10Event(Event var1);

    MouseManager(Component display, Viewer viewer) {
        this.viewer = viewer;
        if (display != null) {
            display.addKeyListener(this);
        }
    }

    void clear() {
        this.startHoverWatcher(false);
    }

    synchronized void startHoverWatcher(boolean isStart) {
        if (this.viewer.isPreviewOnly()) {
            return;
        }
        try {
            if (isStart) {
                if (this.hoverWatcherThread != null) {
                    return;
                }
                this.timeCurrent = -1L;
                this.hoverWatcherThread = new Thread(new HoverWatcher());
                this.hoverWatcherThread.setName("HoverWatcher");
                this.hoverWatcherThread.start();
            } else {
                if (this.hoverWatcherThread == null) {
                    return;
                }
                this.timeCurrent = -1L;
                this.hoverWatcherThread.interrupt();
                this.hoverWatcherThread = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void removeMouseListeners11() {
    }

    void removeMouseListeners14() {
    }

    void setModeMouse(int modeMouse) {
        if (modeMouse == -1) {
            this.startHoverWatcher(false);
            Component display = this.viewer.getDisplay();
            if (display == null) {
                return;
            }
            this.removeMouseListeners11();
            this.removeMouseListeners14();
            display.removeKeyListener(this);
        }
    }

    private void clearKeyBuffer() {
        if (this.keyBuffer.length() == 0) {
            return;
        }
        this.keyBuffer = "";
        if (this.viewer.getBooleanProperty("showKeyStrokes", true)) {
            this.viewer.evalStringQuiet("!set echo _KEYSTROKES; set echo bottom left;echo \"\"");
        }
    }

    private void addKeyBuffer(char ch) {
        if (ch == '\n') {
            this.sendKeyBuffer();
            return;
        }
        if (ch == '\b') {
            if (this.keyBuffer.length() > 0) {
                this.keyBuffer = this.keyBuffer.substring(0, this.keyBuffer.length() - 1);
            }
        } else {
            this.keyBuffer = this.keyBuffer + ch;
        }
        if (this.viewer.getBooleanProperty("showKeyStrokes", true)) {
            this.viewer.evalStringQuiet("!set echo _KEYSTROKES; set echo bottom left;echo " + Escape.escape("\u0000" + this.keyBuffer));
        }
    }

    private void sendKeyBuffer() {
        String kb = this.keyBuffer;
        if (this.viewer.getBooleanProperty("showKeyStrokes", true)) {
            this.viewer.evalStringQuiet("!set echo _KEYSTROKES; set echo bottom left;echo " + Escape.escape(this.keyBuffer));
        }
        this.clearKeyBuffer();
        this.viewer.script(kb);
    }

    public void keyTyped(KeyEvent ke) {
        if (this.viewer.getDisablePopupMenu()) {
            return;
        }
        char ch = ke.getKeyChar();
        int modifiers = ke.getModifiers() & 0xA;
        if (modifiers != 0) {
            switch (ch) {
                case '\u000b': 
                case 'k': {
                    boolean isON = !this.viewer.getBooleanProperty("allowKeyStrokes");
                    switch (modifiers) {
                        case 2: {
                            this.viewer.setBooleanProperty("allowKeyStrokes", isON);
                            this.viewer.setBooleanProperty("showKeyStrokes", true);
                            break;
                        }
                        case 8: 
                        case 10: {
                            this.viewer.setBooleanProperty("allowKeyStrokes", isON);
                            this.viewer.setBooleanProperty("showKeyStrokes", false);
                        }
                    }
                    this.clearKeyBuffer();
                    this.viewer.refresh(3, "showkey");
                }
            }
            return;
        }
        if (!this.viewer.getBooleanProperty("allowKeyStrokes")) {
            return;
        }
        this.addKeyBuffer(ch);
    }

    public void keyPressed(KeyEvent ke) {
        int i = ke.getKeyCode();
        if (i == 18) {
            if (this.dragSelectedMode && this.isAltKeyReleased) {
                this.viewer.moveSelected(Integer.MIN_VALUE, 0, 0, 0, false);
            }
            this.isAltKeyReleased = false;
        }
        if (!this.viewer.getNavigationMode()) {
            return;
        }
        int m = ke.getModifiers();
        switch (i) {
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                this.viewer.navigate(i, m);
            }
        }
    }

    public void keyReleased(KeyEvent ke) {
        int i = ke.getKeyCode();
        if (i == 18) {
            if (this.dragSelectedMode) {
                this.viewer.moveSelected(Integer.MAX_VALUE, 0, 0, 0, false);
            }
            this.isAltKeyReleased = true;
        }
        if (!this.viewer.getNavigationMode()) {
            return;
        }
        switch (i) {
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                this.viewer.navigate(0, 0);
            }
        }
    }

    protected void processKeyEvent(KeyEvent ke) {
    }

    Rectangle getRubberBand() {
        if (!this.rubberbandSelectionMode || this.rectRubber.x == Integer.MAX_VALUE) {
            return null;
        }
        return this.rectRubber;
    }

    private void calcRectRubberBand() {
        if (this.xCurrent < this.xAnchor) {
            this.rectRubber.x = this.xCurrent;
            this.rectRubber.width = this.xAnchor - this.xCurrent;
        } else {
            this.rectRubber.x = this.xAnchor;
            this.rectRubber.width = this.xCurrent - this.xAnchor;
        }
        if (this.yCurrent < this.yAnchor) {
            this.rectRubber.y = this.yCurrent;
            this.rectRubber.height = this.yAnchor - this.yCurrent;
        } else {
            this.rectRubber.y = this.yAnchor;
            this.rectRubber.height = this.yCurrent - this.yAnchor;
        }
    }

    void mouseMoved(long time, int x, int y, int modifiers) {
        this.hoverOff();
        if (this.hoverWatcherThread == null) {
            this.startHoverWatcher(true);
        }
        this.timeCurrent = this.mouseMovedTime = time;
        this.mouseMovedX = this.xCurrent = x;
        this.mouseMovedY = this.yCurrent = y;
        if (this.measurementPending != null || this.hoverActive) {
            this.checkPointOrAtomClicked(x, y, 0, 0);
        }
    }

    void mouseWheel(long time, int rotation, int modifiers) {
        if (!this.viewer.getDisplay().hasFocus()) {
            return;
        }
        this.hoverOff();
        this.timeCurrent = time;
        if (rotation == 0) {
            return;
        }
        if ((modifiers & 0x1F) == 0) {
            float zoomFactor = 1.0f;
            if (rotation > 0) {
                while (--rotation >= 0) {
                    zoomFactor *= 1.15f;
                }
            } else {
                while (++rotation <= 0) {
                    zoomFactor *= 0.86956525f;
                }
            }
            this.viewer.zoomByFactor(zoomFactor);
        }
    }

    void mousePressed(long time, int x, int y, int modifiers, boolean isPopupTrigger) {
        this.pressedCount = this.previousPressedX == x && this.previousPressedY == y && this.previousPressedModifiers == modifiers && time - this.previousPressedTime < 700L ? ++this.pressedCount : 1;
        this.hoverOff();
        this.previousDragX = this.xCurrent = x;
        this.previousPressedX = this.xCurrent;
        this.xAnchor = this.xCurrent;
        this.previousDragY = this.yCurrent = y;
        this.previousPressedY = this.yCurrent;
        this.yAnchor = this.yCurrent;
        this.previousPressedModifiers = modifiers;
        this.previousPressedTime = this.timeCurrent = time;
        switch (modifiers &= 0x1F) {
            case 4: 
            case 18: {
                this.viewer.popupMenu(x, y);
                break;
            }
            case 14: 
            case 17: 
            case 24: 
            case 25: {
                if (!this.drawMode) break;
                this.viewer.checkObjectDragged(Integer.MIN_VALUE, 0, x, y, modifiers);
            }
        }
        if (this.dragSelectedMode) {
            this.viewer.moveSelected(Integer.MIN_VALUE, 0, 0, 0, false);
        }
    }

    void mouseEntered(long time, int x, int y) {
        this.hoverOff();
        this.timeCurrent = time;
        this.xCurrent = x;
        this.yCurrent = y;
    }

    void mouseExited(long time, int x, int y) {
        this.hoverOff();
        this.timeCurrent = time;
        this.xCurrent = x;
        this.yCurrent = y;
        this.exitMeasurementMode();
    }

    void mouseReleased(long time, int x, int y, int modifiers) {
        this.hoverOff();
        this.timeCurrent = time;
        this.xCurrent = x;
        this.yCurrent = y;
        this.viewer.setInMotion(false);
        this.viewer.setCursor(0);
        if (this.rubberbandSelectionMode && (modifiers &= 0x1F) == 17) {
            this.viewer.selectRectangle(this.rectRubber, modifiers);
            this.viewer.refresh(3, "mouseReleased");
        }
        this.rubberbandSelectionMode = false;
        this.rectRubber.x = Integer.MAX_VALUE;
        switch (modifiers) {
            case 14: 
            case 17: 
            case 24: 
            case 25: {
                if (!this.drawMode) break;
                this.viewer.checkObjectDragged(Integer.MAX_VALUE, 0, x, y, modifiers);
            }
        }
        if (this.dragSelectedMode) {
            this.viewer.moveSelected(Integer.MAX_VALUE, 0, 0, 0, false);
        }
    }

    void clearClickCount() {
        this.previousClickX = -1;
    }

    void mouseClicked(long time, int x, int y, int modifiers, int clickCount) {
        this.setMouseMode();
        clickCount = 1;
        if (this.previousClickX == x && this.previousClickY == y && this.previousClickModifiers == modifiers && time - this.previousClickTime < 700L) {
            clickCount = this.previousClickCount + 1;
        }
        if (!this.viewer.getDisplay().hasFocus()) {
            this.viewer.getDisplay().requestFocusInWindow();
        }
        this.hoverOff();
        this.xCurrent = this.previousClickX = x;
        this.yCurrent = this.previousClickY = y;
        this.previousClickModifiers = modifiers;
        this.previousClickCount = clickCount;
        this.timeCurrent = this.previousClickTime = time;
        modifiers &= 0x1F;
        if (this.viewer.haveModelSet()) {
            this.checkPointOrAtomClicked(x, y, modifiers, clickCount);
        }
    }

    void setMouseMode() {
        this.drawMode = false;
        this.dragSelectedMode = this.viewer.getBooleanProperty("dragSelected");
        this.rubberbandSelectionMode = this.viewer.getPickingStyle() == 3;
        this.measuresEnabled = !this.dragSelectedMode;
        this.clearKeyBuffer();
        if (!this.dragSelectedMode) {
            switch (this.viewer.getPickingMode()) {
                default: {
                    return;
                }
                case 4: {
                    this.drawMode = true;
                    this.measuresEnabled = false;
                    break;
                }
                case 2: 
                case 16: 
                case 17: 
                case 18: {
                    this.measuresEnabled = false;
                }
            }
        }
        this.exitMeasurementMode();
    }

    private void checkPointOrAtomClicked(int x, int y, int modifiers, int clickCount) {
        int nearestAtomIndex;
        Point3f nearestPoint = this.drawMode ? null : this.viewer.checkObjectClicked(x, y, modifiers);
        int n = nearestAtomIndex = this.drawMode || nearestPoint != null ? -1 : this.viewer.findNearestAtomIndex(x, y);
        if (!(nearestAtomIndex < 0 || clickCount <= 0 && this.measurementPending != null || this.viewer.isInSelectionSubset(nearestAtomIndex))) {
            nearestAtomIndex = -1;
        }
        switch (clickCount) {
            case 0: {
                if (this.measurementPending == null) {
                    return;
                }
                if (nearestPoint != null || this.measurementPending.getIndexOf(nearestAtomIndex) == 0) {
                    this.measurementPending.addPoint(nearestAtomIndex, nearestPoint, false);
                }
                if (this.measurementPending.haveModified()) {
                    this.viewer.setPendingMeasurement(this.measurementPending);
                }
                this.viewer.refresh(3, "measurementPending");
                return;
            }
            case 1: {
                this.setMouseMode();
                switch (modifiers) {
                    case 16: {
                        if (this.viewer.frankClicked(x, y)) {
                            this.viewer.popupMenu(-x, y);
                            return;
                        }
                        if (this.viewer.getPickingMode() == 19) {
                            if (this.viewer.getNavigationMode()) {
                                this.viewer.navTranslatePercent(0.0f, (float)x * 100.0f / (float)this.viewer.getScreenWidth() - 50.0f, (float)y * 100.0f / (float)this.viewer.getScreenHeight() - 50.0f);
                            }
                            return;
                        }
                        this.viewer.atomPicked(nearestAtomIndex, nearestPoint, modifiers, false);
                        if (this.measurementPending == null || this.addToMeasurement(nearestAtomIndex, nearestPoint, false) != 4) break;
                        this.previousClickCount = 0;
                        this.toggleMeasurement();
                        break;
                    }
                    case 14: 
                    case 17: 
                    case 24: 
                    case 25: {
                        if (this.drawMode) break;
                        this.viewer.atomPicked(nearestAtomIndex, nearestPoint, modifiers, false);
                    }
                }
                return;
            }
            case 2: {
                this.setMouseMode();
                switch (modifiers) {
                    case 16: {
                        if (this.measurementPending != null) {
                            this.addToMeasurement(nearestAtomIndex, nearestPoint, true);
                            this.toggleMeasurement();
                        } else if (!this.drawMode && !this.dragSelectedMode && this.measuresEnabled) {
                            this.enterMeasurementMode();
                            this.addToMeasurement(nearestAtomIndex, nearestPoint, true);
                        }
                        this.viewer.atomPicked(nearestAtomIndex, nearestPoint, modifiers, true);
                        break;
                    }
                    case 8: 
                    case 14: 
                    case 17: 
                    case 24: {
                        if (nearestAtomIndex >= 0) break;
                        this.viewer.script("!reset");
                    }
                }
                return;
            }
        }
    }

    void mouseDragged(long time, int x, int y, int modifiers) {
        this.setMouseMode();
        int deltaX = x - this.previousDragX;
        int deltaY = y - this.previousDragY;
        this.hoverOff();
        this.timeCurrent = time;
        this.xCurrent = this.previousDragX = x;
        this.yCurrent = this.previousDragY = y;
        modifiers &= 0x1F;
        switch (this.pressedCount) {
            case 2: {
                switch (modifiers) {
                    case 8: 
                    case 14: 
                    case 17: 
                    case 24: {
                        this.checkMotion();
                        this.viewer.translateXYBy(deltaX, deltaY);
                        return;
                    }
                    case 19: {
                        if (this.viewer.getSlabEnabled()) {
                            this.viewer.depthByPixels(deltaY);
                        }
                        return;
                    }
                }
                return;
            }
            case 1: {
                switch (modifiers) {
                    case 16: {
                        this.checkMotion();
                        this.viewer.rotateXYBy(deltaX, deltaY);
                        return;
                    }
                    case 14: 
                    case 24: {
                        if (this.dragSelectedMode) {
                            this.checkMotion();
                            this.viewer.moveSelected(deltaX, deltaY, x, y, false);
                            return;
                        }
                        if (this.viewer.allowRotateSelected()) {
                            this.checkMotion();
                            this.viewer.rotateMolecule(deltaX, deltaY);
                            return;
                        }
                    }
                    case 17: 
                    case 25: {
                        if (this.drawMode) {
                            this.checkMotion();
                            this.viewer.checkObjectDragged(this.previousDragX, this.previousDragY, x, y, modifiers);
                            return;
                        }
                        if (this.dragSelectedMode && modifiers == 25) {
                            this.checkMotion();
                            this.viewer.moveSelected(deltaX, deltaY, x, y, true);
                            return;
                        }
                        if (this.rubberbandSelectionMode) {
                            this.calcRectRubberBand();
                            this.viewer.refresh(3, "mouse-drag selection");
                            return;
                        }
                    }
                    case 8: {
                        if (Math.abs(deltaY) > 5 * Math.abs(deltaX)) {
                            this.checkMotion();
                        }
                        this.viewer.zoomBy(deltaY);
                        if (Math.abs(deltaX) > 5 * Math.abs(deltaY)) {
                            this.checkMotion();
                        }
                        this.viewer.rotateZBy(-deltaX);
                        return;
                    }
                    case 5: {
                        this.checkMotion();
                        this.viewer.rotateZBy((Math.abs(deltaY) > 5 * Math.abs(deltaX) ? (this.xCurrent < this.viewer.getScreenWidth() / 2 ? deltaY : -deltaY) : 0) + (this.yCurrent > this.viewer.getScreenHeight() / 2 ? deltaX : -deltaX));
                        return;
                    }
                    case 6: 
                    case 26: {
                        this.checkMotion();
                        this.viewer.translateXYBy(deltaX, deltaY);
                        return;
                    }
                    case 19: {
                        if (this.viewer.getSlabEnabled()) {
                            this.viewer.slabByPixels(deltaY);
                        }
                        return;
                    }
                    case 27: {
                        if (this.viewer.getSlabEnabled()) {
                            this.viewer.slabDepthByPixels(deltaY);
                        }
                        return;
                    }
                }
            }
        }
    }

    void checkMotion() {
        if (!this.viewer.getInMotion()) {
            this.viewer.setCursor(3);
        }
        this.viewer.setInMotion(true);
    }

    private int addToMeasurement(int atomIndex, Point3f nearestPoint, boolean dblClick) {
        if (atomIndex == -1 && nearestPoint == null) {
            this.exitMeasurementMode();
            return 0;
        }
        int measurementCount = this.measurementPending.getCount();
        return measurementCount == 4 && !dblClick ? measurementCount : this.measurementPending.addPoint(atomIndex, nearestPoint, true);
    }

    private void enterMeasurementMode() {
        this.viewer.setCursor(2);
        this.measurementPending = new MeasurementPending(this.viewer.getModelSet());
        this.viewer.setPendingMeasurement(this.measurementPending);
    }

    private void exitMeasurementMode() {
        if (this.measurementPending == null) {
            return;
        }
        this.measurementPending = null;
        this.viewer.setPendingMeasurement(null);
        this.viewer.setCursor(0);
    }

    private void toggleMeasurement() {
        if (this.measurementPending == null) {
            return;
        }
        int measurementCount = this.measurementPending.getCount();
        if (measurementCount >= 2 && measurementCount <= 4) {
            this.viewer.script("!measure " + this.measurementPending.getMeasurementScript(" "));
        }
        this.exitMeasurementMode();
    }

    void hoverOn(int atomIndex) {
        this.viewer.hoverOn(atomIndex);
    }

    void hoverOff() {
        this.viewer.hoverOff();
    }

    class HoverWatcher
    implements Runnable {
        HoverWatcher() {
        }

        public void run() {
            Thread.currentThread().setPriority(1);
            try {
                int hoverDelay;
                while (MouseManager.this.hoverWatcherThread != null && (hoverDelay = MouseManager.this.viewer.getHoverDelay()) > 0) {
                    int atomIndex;
                    long currentTime;
                    int howLong;
                    Thread.sleep(hoverDelay);
                    if (MouseManager.this.xCurrent != MouseManager.this.mouseMovedX || MouseManager.this.yCurrent != MouseManager.this.mouseMovedY || MouseManager.this.timeCurrent != MouseManager.this.mouseMovedTime || (howLong = (int)((currentTime = System.currentTimeMillis()) - MouseManager.this.mouseMovedTime)) <= hoverDelay || MouseManager.this.hoverWatcherThread == null || MouseManager.this.viewer.getInMotion() || MouseManager.this.viewer.getSpinOn() || MouseManager.this.viewer.checkObjectHovered(MouseManager.this.xCurrent, MouseManager.this.yCurrent) || (atomIndex = MouseManager.this.viewer.findNearestAtomIndex(MouseManager.this.xCurrent, MouseManager.this.yCurrent)) < 0) continue;
                    MouseManager.this.hoverOn(atomIndex);
                }
            }
            catch (InterruptedException ie) {
                Logger.debug("Hover InterruptedException!");
            }
            catch (Exception ie) {
                Logger.debug("Hover Exception: " + ie);
            }
            MouseManager.this.hoverWatcherThread = null;
        }
    }
}

