/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.awt.Rectangle;
import org.jmol.api.JmolExportInterface;
import org.jmol.api.JmolRendererInterface;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.ModelSet;
import org.jmol.shape.Shape;
import org.jmol.shape.ShapeRenderer;
import org.jmol.util.Logger;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Viewer;

class RepaintManager {
    private Viewer viewer;
    private int holdRepaint = 0;
    boolean repaintPending;
    private boolean logTime;
    private ShapeRenderer[] renderers;

    RepaintManager(Viewer viewer) {
        this.viewer = viewer;
    }

    void clear() {
        this.clear(-1);
    }

    void pushHoldRepaint() {
        ++this.holdRepaint;
    }

    void popHoldRepaint() {
        --this.holdRepaint;
        if (this.holdRepaint <= 0) {
            this.holdRepaint = 0;
            this.repaintPending = true;
            this.viewer.repaint();
        }
    }

    boolean refresh() {
        if (this.repaintPending) {
            return false;
        }
        this.repaintPending = true;
        if (this.holdRepaint == 0) {
            this.viewer.repaint();
        }
        return true;
    }

    synchronized void requestRepaintAndWait() {
        this.viewer.repaint();
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    synchronized void repaintDone() {
        this.repaintPending = false;
        this.notify();
    }

    void render(Graphics3D g3d, ModelSet modelSet) {
        if (!this.viewer.getRefreshing()) {
            return;
        }
        this.render1(g3d, modelSet);
        Rectangle band = this.viewer.getRubberBandSelection();
        if (band != null && g3d.setColix(this.viewer.getColixRubberband())) {
            g3d.drawRect(band.x, band.y, 0, 0, band.width, band.height);
        }
    }

    private void render1(Graphics3D g3d, ModelSet modelSet) {
        if (modelSet == null || !this.viewer.mustRenderFlag()) {
            return;
        }
        this.logTime = this.viewer.getTestFlag1();
        this.viewer.finalizeTransformParameters();
        if (this.logTime) {
            Logger.startTimer();
        }
        try {
            g3d.renderBackground(null);
            if (this.renderers == null) {
                this.renderers = new ShapeRenderer[32];
            }
            for (int i = 0; i < 32 && g3d.currentlyRendering(); ++i) {
                Shape shape = modelSet.getShape(i);
                if (shape == null) continue;
                this.getRenderer(i, g3d).render(g3d, modelSet, shape);
            }
        }
        catch (Exception e) {
            Logger.error("rendering error -- perhaps use \"set refreshing FALSE/TRUE\" ? ");
        }
        if (this.logTime) {
            Logger.checkTimer("render time");
        }
    }

    void clear(int iShape) {
        if (this.renderers == null) {
            return;
        }
        if (iShape >= 0) {
            this.renderers[iShape] = null;
        } else {
            for (int i = 0; i < 32; ++i) {
                this.renderers[i] = null;
            }
        }
    }

    private ShapeRenderer getRenderer(int shapeID, Graphics3D g3d) {
        if (this.renderers[shapeID] == null) {
            this.renderers[shapeID] = this.allocateRenderer(shapeID, g3d);
        }
        return this.renderers[shapeID];
    }

    private ShapeRenderer allocateRenderer(int shapeID, Graphics3D g3d) {
        String className = JmolConstants.getShapeClassName(shapeID) + "Renderer";
        try {
            Class<?> shapeClass = Class.forName(className);
            ShapeRenderer renderer = (ShapeRenderer)shapeClass.newInstance();
            renderer.setViewerG3dShapeID(this.viewer, g3d, shapeID);
            return renderer;
        }
        catch (Exception e) {
            Logger.error("Could not instantiate renderer:" + className, e);
            return null;
        }
    }

    String generateOutput(String type, Graphics3D g3d, ModelSet modelSet, String fileName) {
        this.viewer.finalizeTransformParameters();
        JmolExportInterface exporter = null;
        JmolRendererInterface g3dExport = null;
        CharSequence output = null;
        try {
            if (fileName == null) {
                output = new StringBuffer();
            } else {
                if (fileName.charAt(0) == '?') {
                    fileName = this.viewer.dialogAsk("save", fileName.substring(1));
                }
                if (fileName == null) {
                    return null;
                }
                output = fileName;
            }
            Class<?> exporterClass = Class.forName("org.jmol.export._" + type + "Exporter");
            exporter = (JmolExportInterface)exporterClass.newInstance();
            exporterClass = Class.forName("org.jmol.export.Export3D");
            g3dExport = (JmolRendererInterface)exporterClass.newInstance();
        }
        catch (Exception e) {
            Logger.error("Cannot export " + type);
            return null;
        }
        if (!exporter.initializeOutput(this.viewer, g3d, output)) {
            return null;
        }
        exporter.getHeader();
        g3dExport.setg3dExporter(g3d, exporter);
        exporter.renderBackground();
        for (int i = 0; i < 32; ++i) {
            ShapeRenderer generator;
            Shape shape = modelSet.getShape(i);
            if (shape == null || (generator = this.getGenerator(i, g3d)) == null) continue;
            generator.setGenerator(true);
            g3dExport.setRenderer(generator);
            generator.render(g3dExport, modelSet, shape);
        }
        exporter.getFooter();
        return exporter.finalizeOutput();
    }

    private ShapeRenderer getGenerator(int shapeID, Graphics3D g3d) {
        String className = "org.jmol.export." + JmolConstants.getShapeClassName(~shapeID) + "Generator";
        try {
            Class<?> shapeClass = Class.forName(className);
            ShapeRenderer renderer = (ShapeRenderer)shapeClass.newInstance();
            renderer.setViewerG3dShapeID(this.viewer, g3d, shapeID);
            return renderer;
        }
        catch (Exception e) {
            return null;
        }
    }
}

