/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Vector;
import javax.vecmath.Point3f;
import org.jmol.i18n.GT;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Token;

abstract class ScriptCompilationTokenParser {
    protected String script;
    protected short lineCurrent;
    protected int iCommand;
    protected int ichCurrentCommand;
    protected int ichComment;
    protected int ichEnd;
    protected int ichToken;
    protected Token theToken;
    protected Token lastFlowCommand;
    protected Token tokenCommand;
    protected Token lastToken;
    protected Token tokenAndEquals;
    protected int theTok;
    protected int nTokens;
    protected int tokCommand;
    protected int ptNewSetModifier;
    protected boolean isNewSet;
    protected boolean logMessages = false;
    protected Token[] atokenInfix;
    protected int itokenInfix;
    protected boolean isSetBrace;
    protected boolean isImplicitExpression;
    protected boolean isSetOrDefine;
    private Vector ltokenPostfix;
    protected boolean isEmbeddedExpression;
    protected boolean isCommaAsOrAllowed;
    private Object theValue;
    boolean haveString;
    private boolean residueSpecCodeGenerated;
    protected String errorMessage;
    protected String errorMessageUntranslated;
    protected String errorLine;
    protected String errorType;
    protected static final int ERROR_badArgumentCount = 0;
    protected static final int ERROR_badContext = 1;
    protected static final int ERROR_commandExpected = 2;
    protected static final int ERROR_endOfCommandUnexpected = 4;
    protected static final int ERROR_invalidExpressionToken = 9;
    protected static final int ERROR_missingEnd = 11;
    protected static final int ERROR_tokenExpected = 15;
    protected static final int ERROR_tokenUnexpected = 16;
    protected static final int ERROR_unrecognizedParameter = 18;
    protected static final int ERROR_unrecognizedToken = 19;
    private static final int ERROR_coordinateExpected = 3;
    private static final int ERROR_endOfExpressionExpected = 5;
    private static final int ERROR_identifierOrResidueSpecificationExpected = 6;
    private static final int ERROR_invalidAtomSpecification = 7;
    private static final int ERROR_invalidChainSpecification = 8;
    private static final int ERROR_invalidModelSpecification = 10;
    private static final int ERROR_numberExpected = 12;
    private static final int ERROR_numberOrVariableNameExpected = 13;
    private static final int ERROR_residueSpecificationExpected = 14;
    private static final int ERROR_unrecognizedExpressionToken = 17;

    ScriptCompilationTokenParser() {
    }

    protected boolean compileExpressions() {
        boolean checkExpression;
        this.isEmbeddedExpression = this.tokCommand != 0 && this.tokCommand != 135499780 && this.tokCommand != 233481 && !Token.tokAttrOr(this.tokCommand, 12288, 20480);
        boolean bl = checkExpression = this.isEmbeddedExpression || Token.tokAttr(this.tokCommand, 12288);
        if (this.tokAt(1) == 0x100007 && Token.tokAttr(this.tokCommand, 12288)) {
            checkExpression = false;
        }
        if (checkExpression && !this.compileExpression()) {
            return false;
        }
        int size = this.atokenInfix.length;
        int nDefined = 0;
        for (int i = 1; i < size; ++i) {
            if (this.tokAt(i) != 537931778) continue;
            ++nDefined;
        }
        if (this.isNewSet && (size -= nDefined) == 1) {
            this.atokenInfix[0] = new Token(135499780, 0, this.atokenInfix[0].value);
            this.isNewSet = false;
        }
        if ((this.isNewSet || this.isSetBrace) && size < this.ptNewSetModifier + 2) {
            return this.commandExpected();
        }
        return size == 1 || !Token.tokAttr(this.tokCommand, 262144) ? true : this.error(0);
    }

    protected boolean compileExpression() {
        int firstToken = this.isSetOrDefine && !this.isSetBrace ? 2 : 1;
        this.ltokenPostfix = new Vector();
        this.itokenInfix = 0;
        Token tokenBegin = null;
        for (int i = 0; i < firstToken && this.addNextToken(); ++i) {
        }
        while (this.moreTokens()) {
            if (this.isEmbeddedExpression) {
                while (!this.isExpressionNext() && this.addNextToken()) {
                }
                if (!this.moreTokens()) break;
            }
            if (this.lastToken.tok == 537931778) {
                if (this.clauseDefine()) continue;
                return false;
            }
            if (!this.isImplicitExpression) {
                tokenBegin = new Token(0x100001, "implicitExpressionBegin");
                this.addTokenToPostfix(tokenBegin);
            }
            if (!this.clauseOr(this.isCommaAsOrAllowed || !this.isImplicitExpression && this.tokPeek(0x10100010))) {
                return false;
            }
            if (!(this.isImplicitExpression || this.isEmbeddedExpression && this.lastToken == Token.tokenCoordinateEnd)) {
                this.addTokenToPostfix(Token.tokenExpressionEnd);
            }
            if (!this.moreTokens()) continue;
            if (this.tokCommand != 135280129 && !this.isEmbeddedExpression) {
                return this.error(5);
            }
            if (this.tokCommand != 135280129) continue;
            tokenBegin.intValue = 0;
            this.tokCommand = 0;
            this.isEmbeddedExpression = true;
            this.isImplicitExpression = true;
            this.isCommaAsOrAllowed = false;
        }
        this.atokenInfix = new Token[this.ltokenPostfix.size()];
        this.ltokenPostfix.copyInto(this.atokenInfix);
        return true;
    }

    private boolean isExpressionNext() {
        return this.tokPeek(0x10000A) || !this.isImplicitExpression && this.tokPeek(0x10100010);
    }

    protected static boolean tokenAttr(Token token, int tok) {
        return token != null && Token.tokAttr(token.tok, tok);
    }

    private boolean moreTokens() {
        return this.itokenInfix < this.atokenInfix.length;
    }

    private int tokAt(int i) {
        return i < this.atokenInfix.length ? this.atokenInfix[i].tok : 0;
    }

    private int tokPeek() {
        return this.itokenInfix >= this.atokenInfix.length ? 0 : this.atokenInfix[this.itokenInfix].tok;
    }

    private boolean tokPeek(int tok) {
        return this.itokenInfix < this.atokenInfix.length && this.atokenInfix[this.itokenInfix].tok == tok;
    }

    private int intPeek() {
        return this.itokenInfix >= this.atokenInfix.length ? Integer.MAX_VALUE : this.atokenInfix[this.itokenInfix].intValue;
    }

    private Object valuePeek() {
        return this.moreTokens() ? this.atokenInfix[this.itokenInfix].value : "";
    }

    private Token tokenNext() {
        return this.itokenInfix >= this.atokenInfix.length ? null : this.atokenInfix[this.itokenInfix++];
    }

    private boolean tokenNext(int tok) {
        Token token = this.tokenNext();
        return token != null && token.tok == tok;
    }

    private boolean returnToken() {
        --this.itokenInfix;
        return false;
    }

    private Token getToken() {
        this.theToken = this.tokenNext();
        this.theValue = this.theToken == null ? null : this.theToken.value;
        return this.theToken;
    }

    private boolean isToken(int tok) {
        return this.theToken != null && this.theToken.tok == tok;
    }

    private boolean getNumericalToken() {
        return this.getToken() != null && (this.isToken(2) || this.isToken(3));
    }

    private float floatValue() {
        switch (this.theToken.tok) {
            case 2: {
                return this.theToken.intValue;
            }
            case 3: {
                return ((Float)this.theValue).floatValue();
            }
        }
        return 0.0f;
    }

    private boolean addTokenToPostfix(int tok, Object value) {
        return this.addTokenToPostfix(new Token(tok, value));
    }

    private boolean addTokenToPostfix(int tok, int intValue, Object value) {
        return this.addTokenToPostfix(new Token(tok, intValue, value));
    }

    private boolean addTokenToPostfix(Token token) {
        if (token == null) {
            return false;
        }
        if (this.logMessages) {
            Logger.debug("addTokenToPostfix" + token);
        }
        this.ltokenPostfix.addElement(token);
        this.lastToken = token;
        return true;
    }

    private boolean addNextToken() {
        return this.addTokenToPostfix(this.tokenNext());
    }

    private boolean addNextTokenIf(int tok) {
        return this.tokPeek(tok) && this.addNextToken();
    }

    private boolean addSubstituteTokenIf(int tok, Token token) {
        if (!this.tokPeek(tok)) {
            return false;
        }
        ++this.itokenInfix;
        return this.addTokenToPostfix(token);
    }

    private boolean clauseOr(boolean allowComma) {
        int tok;
        this.haveString = false;
        if (!this.clauseAnd()) {
            return false;
        }
        if (this.isEmbeddedExpression && this.lastToken.tok == 0x100002) {
            return true;
        }
        while ((tok = this.tokPeek()) == 0x10100050 || tok == 0x10100051 || tok == 269484114 || allowComma && tok == 0x10100030) {
            if (tok == 0x10100030 && !this.haveString) {
                this.addSubstituteTokenIf(0x10100030, Token.tokenOr);
            } else {
                this.addNextToken();
            }
            if (this.clauseAnd()) continue;
            return false;
        }
        return true;
    }

    private boolean clauseAnd() {
        if (!this.clauseNot()) {
            return false;
        }
        if (this.isEmbeddedExpression && this.lastToken.tok == 0x100002) {
            return true;
        }
        while (this.tokPeek(0x10100060)) {
            this.addNextToken();
            if (this.clauseNot()) continue;
            return false;
        }
        return true;
    }

    private boolean clauseNot() {
        if (this.tokPeek(0x10100070)) {
            this.addNextToken();
            return this.clauseNot();
        }
        return this.clausePrimitive();
    }

    private boolean clausePrimitive() {
        int tok = this.tokPeek();
        switch (tok) {
            case 0: {
                return this.error(4);
            }
            case 0x100003: 
            case 0x100009: 
            case 0x10000B: 
            case 137364482: 
            case 0x101000A0: 
            case 0x40000007: {
                return this.addNextToken();
            }
            case 4: {
                this.haveString = true;
                return this.addNextToken();
            }
            case 3: {
                return this.addTokenToPostfix(1048611, this.getToken().intValue, this.theValue);
            }
            case 1: 
            case 2: 
            case 5: 
            case 0x10100022: 
            case 0x10100040: 
            case 0x101000A1: 
            case 269484194: {
                if (this.clauseResidueSpec()) {
                    return true;
                }
            }
            default: {
                if (Token.tokAttr(tok, 0x500000)) {
                    int itemp = this.itokenInfix;
                    boolean isOK = this.clauseComparator(Token.tokAttr(tok, 0x300000));
                    if (isOK || this.itokenInfix != itemp) {
                        return isOK;
                    }
                }
                if (tok != 2 && !Token.tokAttr(tok, 0x300000)) break;
                return this.addNextToken();
            }
            case 0x1500005: {
                return this.clauseCell();
            }
            case 135268866: {
                return this.clauseConnected();
            }
            case 135266818: {
                return this.clauseSubstructure();
            }
            case 135268865: {
                return this.clauseWithin();
            }
            case 537931778: {
                this.addNextToken();
                if (this.tokPeek() == 0) {
                    return this.error(4);
                }
                return this.clauseDefine();
            }
            case 538447907: 
            case 605028354: {
                this.addNextToken();
                if (this.tokPeek(0x40000007)) {
                    this.addNextToken();
                } else if (this.tokPeek(537931778)) {
                    this.addNextToken();
                    return this.clauseDefine();
                }
                return true;
            }
            case 0x10100010: {
                this.addNextToken();
                if (!this.clauseOr(true)) {
                    return false;
                }
                if (!this.addNextTokenIf(0x10100011)) {
                    return this.error(15, ")");
                }
                return this.checkForItemSelector();
            }
            case 0x10000A: {
                return this.checkForCoordinate(this.isImplicitExpression);
            }
        }
        return this.error(17, "" + this.valuePeek());
    }

    private boolean checkForCoordinate(boolean isImplicitExpression) {
        boolean isCoordinate = false;
        int pt = this.ltokenPostfix.size();
        if (isImplicitExpression) {
            this.addTokenToPostfix(Token.tokenExpressionBegin);
            this.tokenNext();
        } else if (this.isEmbeddedExpression) {
            this.tokenNext();
            --pt;
        } else {
            this.addNextToken();
        }
        if (!this.clauseOr(false)) {
            return false;
        }
        int n = 1;
        while (!this.tokPeek(0x10000E)) {
            boolean haveComma = this.addNextTokenIf(0x10100030);
            if (!this.clauseOr(false)) {
                return haveComma || n < 3 ? false : this.error(15, "}");
            }
            ++n;
        }
        boolean bl = isCoordinate = n >= 2;
        if (isCoordinate && (isImplicitExpression || this.isEmbeddedExpression)) {
            this.ltokenPostfix.set(pt, Token.tokenCoordinateBegin);
            this.addTokenToPostfix(Token.tokenCoordinateEnd);
            this.tokenNext();
        } else if (isImplicitExpression) {
            this.addTokenToPostfix(Token.tokenExpressionEnd);
            this.tokenNext();
        } else if (this.isEmbeddedExpression) {
            this.tokenNext();
        } else {
            this.addNextToken();
        }
        return this.checkForItemSelector();
    }

    private boolean checkForItemSelector() {
        for (int i = 0; i < 2 && this.addNextTokenIf(0x10100040); ++i) {
            if (!this.clauseItemSelector()) {
                return false;
            }
            if (this.addNextTokenIf(0x10100041)) continue;
            return this.error(15, "]");
        }
        return true;
    }

    private boolean clauseWithin() {
        this.addNextToken();
        if (!this.addNextTokenIf(0x10100010)) {
            return false;
        }
        if (this.getToken() == null) {
            return false;
        }
        float distance = Float.MAX_VALUE;
        String key = null;
        boolean allowComma = true;
        switch (this.theToken.tok) {
            case 0x10100090: {
                if (this.getToken() == null) {
                    return false;
                }
                if (this.theToken.tok != 2) {
                    return this.error(12);
                }
                distance = -this.theToken.intValue;
                break;
            }
            case 2: 
            case 3: {
                distance = this.floatValue();
                break;
            }
            case 0x100004: {
                allowComma = false;
            }
            case 4: 
            case 0x100006: 
            case 0xD00004: 
            case 0xD00006: 
            case 0xD00101: 
            case 13631746: 
            case 13631749: 
            case 22020109: 
            case 0x1500010: 
            case 22024203: 
            case 30412803: 
            case 135268355: 
            case 605556745: 
            case 1073741944: {
                key = (String)this.theValue;
                break;
            }
            case 1: {
                key = ((String)this.theValue).toLowerCase();
                break;
            }
            default: {
                return this.error(18, "WITHIN", ": " + this.theToken.value);
            }
        }
        if (key == null) {
            this.addTokenToPostfix(3, new Float(distance));
        } else {
            this.addTokenToPostfix(4, key);
        }
        while (this.addNextTokenIf(0x10100030)) {
            int tok = this.tokPeek();
            if (distance != Float.MAX_VALUE && (tok == 0x10000D || tok == 0x10000C)) {
                this.addTokenToPostfix(this.getToken());
                if (!this.addNextTokenIf(0x10100030)) break;
                tok = this.tokPeek();
            }
            boolean isCoordOrPlane = false;
            if (key == null) {
                if (tok == 1) {
                    this.getToken();
                    key = ((String)this.theValue).toLowerCase();
                    if (key.equals("hkl")) {
                        isCoordOrPlane = true;
                        this.addTokenToPostfix(4, key);
                    } else {
                        this.returnToken();
                    }
                } else if (tok == 0x100006 || tok == 135268355) {
                    isCoordOrPlane = true;
                    this.addNextToken();
                } else if (tok == 0x10000A) {
                    this.returnToken();
                    isCoordOrPlane = true;
                    this.addTokenToPostfix(Token.getTokenFromName(distance == Float.MAX_VALUE ? "plane" : "coord"));
                }
                this.addNextTokenIf(0x10100030);
            }
            tok = this.tokPeek();
            if (isCoordOrPlane) {
                block13: while (!this.tokPeek(0x10100011)) {
                    switch (this.tokPeek()) {
                        case 0: {
                            return this.error(4);
                        }
                        case 0x10100010: {
                            this.addTokenToPostfix(Token.tokenExpressionBegin);
                            this.addNextToken();
                            if (!this.clauseOr(false)) {
                                return this.error(18, "WITHIN", ": ?");
                            }
                            if (!this.addNextTokenIf(0x10100011)) {
                                return this.error(15, ", / )");
                            }
                            this.addTokenToPostfix(Token.tokenExpressionEnd);
                            continue block13;
                        }
                        case 537931778: {
                            this.addTokenToPostfix(this.getToken());
                            if (this.clauseDefine()) continue block13;
                            return false;
                        }
                    }
                    this.addTokenToPostfix(this.getToken());
                }
                continue;
            }
            if (this.clauseOr(allowComma)) continue;
            return this.error(0);
        }
        if (!this.addNextTokenIf(0x10100011)) {
            return this.error(15, ")");
        }
        return true;
    }

    private boolean clauseConnected() {
        block10: {
            block11: {
                String strOrder;
                block12: {
                    this.addNextToken();
                    if (!this.addNextTokenIf(0x10100010)) {
                        this.addTokenToPostfix(Token.tokenLeftParen);
                        this.addTokenToPostfix(Token.tokenRightParen);
                        return true;
                    }
                    if (this.addNextTokenIf(2) && !this.addNextTokenIf(0x10100030) || this.addNextTokenIf(2) && !this.addNextTokenIf(0x10100030) || this.addNextTokenIf(3) && !this.addNextTokenIf(0x10100030) || this.addNextTokenIf(3) && !this.addNextTokenIf(0x10100030)) break block10;
                    if (this.tokPeek() != 1 && this.tokPeek() != 538447897) break block11;
                    strOrder = (String)this.getToken().value;
                    short intType = JmolConstants.getBondOrderFromString(strOrder);
                    if (intType != Short.MAX_VALUE) break block12;
                    this.returnToken();
                    break block11;
                }
                this.addTokenToPostfix(4, strOrder);
                if (!this.addNextTokenIf(0x10100030)) break block10;
            }
            if (this.addNextTokenIf(0x10100011)) {
                return true;
            }
            if (!this.clauseOr(this.tokPeek(0x10100010))) {
                return false;
            }
            if (this.addNextTokenIf(0x10100011)) {
                return true;
            }
            if (!this.addNextTokenIf(0x10100030)) {
                return false;
            }
            if (!this.clauseOr(this.tokPeek(0x10100010))) {
                return false;
            }
        }
        if (!this.addNextTokenIf(0x10100011)) {
            return this.error(15, ")");
        }
        return true;
    }

    private boolean clauseSubstructure() {
        this.addNextToken();
        if (!this.addNextTokenIf(0x10100010)) {
            return false;
        }
        if (!this.addNextTokenIf(4)) {
            return this.error(15, "\"...\"");
        }
        if (!this.addNextTokenIf(0x10100011)) {
            return this.error(15, ")");
        }
        return true;
    }

    private boolean clauseItemSelector() {
        int tok;
        int nparen = 0;
        while ((tok = this.tokPeek()) != 0 && tok != 0x10100041) {
            this.addNextToken();
            if (tok == 0x10100040) {
                ++nparen;
            }
            if (this.tokPeek() != 0x10100041 || nparen-- <= 0) continue;
            this.addNextToken();
        }
        return true;
    }

    private boolean clauseComparator(boolean isOptional) {
        Token tokenAtomProperty = this.tokenNext();
        Token tokenComparator = this.tokenNext();
        if (!ScriptCompilationTokenParser.tokenAttr(tokenComparator, 0x10100100)) {
            if (!isOptional) {
                return this.error(15, "== != < > <= >=");
            }
            if (tokenComparator != null) {
                this.returnToken();
            }
            this.returnToken();
            return false;
        }
        if (ScriptCompilationTokenParser.tokenAttr(tokenAtomProperty, 0xD00000) && tokenComparator.tok != 269484420 && tokenComparator.tok != 269484421) {
            return this.error(15, "== !=");
        }
        if (this.getToken() == null) {
            return this.error(17, "" + this.valuePeek());
        }
        boolean isNegative = this.isToken(0x10100090);
        if (isNegative && this.getToken() == null) {
            return this.error(12);
        }
        switch (this.theToken.tok) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 0x10000A: 
            case 537931778: {
                break;
            }
            default: {
                return this.error(13);
            }
        }
        this.addTokenToPostfix(tokenComparator.tok, tokenAtomProperty.tok, tokenComparator.value + (isNegative ? " -" : ""));
        if (tokenAtomProperty.tok == 642777357) {
            this.addTokenToPostfix(tokenAtomProperty);
        }
        if (this.isToken(0x10000A)) {
            this.returnToken();
            return this.clausePrimitive();
        }
        this.addTokenToPostfix(this.theToken);
        if (this.theToken.tok == 537931778) {
            return this.clauseDefine();
        }
        return true;
    }

    private boolean clauseCell() {
        Point3f cell = new Point3f();
        this.tokenNext();
        if (!this.tokenNext(269484420)) {
            return this.error(15, "=");
        }
        if (this.getToken() == null) {
            return this.error(3);
        }
        if (this.isToken(2)) {
            int nnn = this.theToken.intValue;
            cell.x = nnn / 100 - 4;
            cell.y = nnn % 100 / 10 - 4;
            cell.z = nnn % 10 - 4;
            return this.addTokenToPostfix(0x1500005, cell);
        }
        if (!this.isToken(0x10000A) || !this.getNumericalToken()) {
            return this.error(3);
        }
        cell.x = this.floatValue();
        if (this.tokPeek(0x10100030)) {
            this.tokenNext();
        }
        if (!this.getNumericalToken()) {
            return this.error(3);
        }
        cell.y = this.floatValue();
        if (this.tokPeek(0x10100030)) {
            this.tokenNext();
        }
        if (!this.getNumericalToken() || !this.tokenNext(0x10000E)) {
            return this.error(3);
        }
        cell.z = this.floatValue();
        return this.addTokenToPostfix(0x1500005, cell);
    }

    private boolean clauseDefine() {
        if (!this.addSubstituteTokenIf(0x10000A, Token.tokenExpressionBegin)) {
            return this.addNextToken() && this.checkForItemSelector();
        }
        while (this.moreTokens() && !this.tokPeek(0x10000E)) {
            if (this.tokPeek(0x10000A)) {
                if (this.checkForCoordinate(true)) continue;
                return false;
            }
            this.addNextToken();
        }
        return this.addSubstituteTokenIf(0x10000E, Token.tokenExpressionEnd) && this.checkForItemSelector();
    }

    private boolean generateResidueSpecCode(Token token) {
        if (this.residueSpecCodeGenerated) {
            this.addTokenToPostfix(Token.tokenAnd);
        }
        this.addTokenToPostfix(token);
        this.residueSpecCodeGenerated = true;
        return true;
    }

    private boolean clauseResidueSpec() {
        boolean specSeen = false;
        this.residueSpecCodeGenerated = false;
        int tok = this.tokPeek();
        if (tok == 0x101000A1 || tok == 0x10100040 || tok == 1) {
            if (!this.clauseResNameSpec()) {
                return false;
            }
            specSeen = true;
            tok = this.tokPeek();
        }
        boolean wasInteger = false;
        if (tok == 0x101000A1 || tok == 2 || tok == 5) {
            boolean bl = wasInteger = tok == 2;
            if (this.tokPeek(0x101000A1)) {
                this.getToken();
            } else if (!this.clauseSequenceSpec()) {
                return false;
            }
            specSeen = true;
            tok = this.tokPeek();
        }
        if (tok == 0x10100022 || tok == 0x101000A1 || tok == 1 || tok == 2 && !wasInteger) {
            if (!this.clauseChainSpec(tok)) {
                return false;
            }
            specSeen = true;
            tok = this.tokPeek();
        }
        if (tok == 0x100008) {
            if (!this.clauseAtomSpec()) {
                return false;
            }
            specSeen = true;
            tok = this.tokPeek();
        }
        if (tok == 269484194) {
            if (!this.clauseAlternateSpec()) {
                return false;
            }
            specSeen = true;
            tok = this.tokPeek();
        }
        if (tok == 0x10100022 || tok == 0x101000A0) {
            if (!this.clauseModelSpec()) {
                return false;
            }
            specSeen = true;
            tok = this.tokPeek();
        }
        if (!specSeen) {
            return this.error(14);
        }
        if (!this.residueSpecCodeGenerated) {
            this.addTokenToPostfix(Token.tokenAll);
        }
        return true;
    }

    private boolean clauseResNameSpec() {
        this.getToken();
        if (this.isToken(0x101000A1) || this.isToken(0)) {
            return !this.isToken(0);
        }
        if (this.isToken(0x10100040)) {
            int pt;
            String strSpec = "";
            while (this.getToken() != null && !this.isToken(0x10100041)) {
                strSpec = strSpec + this.theValue;
            }
            if (!this.isToken(0x10100041)) {
                return false;
            }
            if (strSpec == "") {
                return true;
            }
            if (strSpec.length() > 0 && (pt = strSpec.indexOf("*")) >= 0 && pt != strSpec.length() - 1) {
                return this.error(14);
            }
            strSpec = strSpec.toUpperCase();
            return this.generateResidueSpecCode(new Token(1048612, strSpec));
        }
        if (!this.isToken(1)) {
            return this.error(6);
        }
        if (this.tokPeek(0x101000A1)) {
            String res = this.theValue + "*";
            this.getToken();
            return this.generateResidueSpecCode(new Token(1, res));
        }
        return this.generateResidueSpecCode(this.theToken);
    }

    private boolean clauseSequenceSpec() {
        Token seqToken = this.getSequenceCode(false);
        if (seqToken == null) {
            return false;
        }
        int tok = this.tokPeek();
        if (tok == 0x10100090 || tok == 2 && this.intPeek() < 0) {
            if (tok == 0x10100090) {
                this.tokenNext();
            } else {
                int i;
                this.tokenNext().intValue = i = -this.intPeek();
                this.returnToken();
            }
            seqToken.tok = 1048615;
            this.generateResidueSpecCode(seqToken);
            return this.addTokenToPostfix(this.getSequenceCode(true));
        }
        return this.generateResidueSpecCode(seqToken);
    }

    private Token getSequenceCode(boolean isSecond) {
        int seqcode = Integer.MAX_VALUE;
        int seqvalue = Integer.MAX_VALUE;
        int tokPeek = this.tokPeek();
        if (tokPeek == 5) {
            seqcode = this.tokenNext().intValue;
        } else if (tokPeek == 2) {
            seqvalue = this.tokenNext().intValue;
        } else if (!isSecond) {
            return null;
        }
        return new Token(1048614, seqvalue, new Integer(seqcode));
    }

    private boolean clauseChainSpec(int tok) {
        char chain;
        if (tok == 0x10100022) {
            this.tokenNext();
            tok = this.tokPeek();
            if (this.isSpecTerminator(tok)) {
                return this.generateResidueSpecCode(new Token(0x100021, 0, "spec_chain"));
            }
        }
        if (tok == 0x101000A1) {
            return this.getToken() != null;
        }
        switch (tok) {
            case 2: {
                this.getToken();
                int val = this.theToken.intValue;
                if (val < 0 || val > 9) {
                    return this.error(8);
                }
                chain = (char)(48 + val);
                break;
            }
            case 1: {
                String strChain = (String)this.getToken().value;
                if (strChain.length() != 1) {
                    return this.error(8);
                }
                chain = strChain.charAt(0);
                if (chain != '?') break;
                return true;
            }
            default: {
                return this.error(8);
            }
        }
        return this.generateResidueSpecCode(new Token(0x100021, chain, "spec_chain"));
    }

    private boolean isSpecTerminator(int tok) {
        switch (tok) {
            case 0: 
            case 0x10100011: 
            case 0x10100030: 
            case 0x10100050: 
            case 0x10100060: 
            case 0x10100070: 
            case 0x101000A0: 
            case 269484194: {
                return true;
            }
        }
        return false;
    }

    private boolean clauseAlternateSpec() {
        this.tokenNext();
        int tok = this.tokPeek();
        if (this.isSpecTerminator(tok)) {
            return this.generateResidueSpecCode(new Token(0x10001F, null));
        }
        String alternate = (String)this.getToken().value;
        switch (this.theToken.tok) {
            case 1: 
            case 2: 
            case 4: 
            case 0x101000A1: {
                break;
            }
            default: {
                return this.error(10);
            }
        }
        return this.generateResidueSpecCode(new Token(0x10001F, alternate));
    }

    private boolean clauseModelSpec() {
        this.getToken();
        if (this.tokPeek(0x101000A1)) {
            this.getToken();
            return true;
        }
        switch (this.tokPeek()) {
            case 2: {
                return this.generateResidueSpecCode(new Token(0x100022, new Integer(this.getToken().intValue)));
            }
            case 3: {
                return this.generateResidueSpecCode(new Token(0x100022, this.getToken().intValue, this.theValue));
            }
            case 0: 
            case 0x10000E: 
            case 0x10100030: {
                return this.generateResidueSpecCode(new Token(0x100022, new Integer(1)));
            }
        }
        return this.error(10);
    }

    private boolean clauseAtomSpec() {
        if (!this.tokenNext(0x100008)) {
            return this.error(7);
        }
        if (this.getToken() == null) {
            return true;
        }
        String atomSpec = "";
        if (this.isToken(2)) {
            atomSpec = atomSpec + "" + this.theToken.intValue;
            if (this.getToken() == null) {
                return this.error(7);
            }
        }
        switch (this.theToken.tok) {
            case 0x101000A1: {
                return true;
            }
            case 1: {
                break;
            }
            default: {
                return this.error(7);
            }
        }
        atomSpec = atomSpec + this.theValue;
        if (this.tokPeek(0x101000A1)) {
            this.tokenNext();
            atomSpec = atomSpec + "*";
        }
        return this.generateResidueSpecCode(new Token(0x100020, atomSpec));
    }

    static String errorString(int iError, String value, String more, boolean translated) {
        String msg;
        boolean doTranslate = false;
        if (!translated && (doTranslate = GT.getDoTranslate())) {
            GT.setDoTranslate(false);
        }
        switch (iError) {
            default: {
                msg = "Unknown compiler error message number: " + iError;
                break;
            }
            case 0: {
                msg = GT._("bad argument count");
                break;
            }
            case 1: {
                msg = GT._("invalid context for {0}");
                break;
            }
            case 2: {
                msg = GT._("command expected");
                break;
            }
            case 3: {
                msg = GT._("{ number number number } expected");
                break;
            }
            case 4: {
                msg = GT._("unexpected end of script command");
                break;
            }
            case 5: {
                msg = GT._("end of expression expected");
                break;
            }
            case 6: {
                msg = GT._("identifier or residue specification expected");
                break;
            }
            case 7: {
                msg = GT._("invalid atom specification");
                break;
            }
            case 8: {
                msg = GT._("invalid chain specification");
                break;
            }
            case 9: {
                msg = GT._("invalid expression token: {0}");
                break;
            }
            case 10: {
                msg = GT._("invalid model specification");
                break;
            }
            case 11: {
                msg = GT._("missing END for {0}");
                break;
            }
            case 12: {
                msg = GT._("number expected");
                break;
            }
            case 13: {
                msg = GT._("number or variable name expected");
                break;
            }
            case 14: {
                msg = GT._("residue specification (ALA, AL?, A*) expected");
                break;
            }
            case 15: {
                msg = GT._("{0} expected");
                break;
            }
            case 16: {
                msg = GT._("{0} unexpected");
                break;
            }
            case 17: {
                msg = GT._("unrecognized expression token: {0}");
                break;
            }
            case 18: {
                msg = GT._("unrecognized {0} parameter");
                break;
            }
            case 19: {
                msg = GT._("unrecognized token: {0}");
            }
        }
        if (msg.indexOf("{0}") < 0) {
            if (value != null) {
                msg = msg + ": " + value;
            }
        } else if ((msg = TextFormat.simpleReplace(msg, "{0}", value)).indexOf("{1}") >= 0) {
            msg = TextFormat.simpleReplace(msg, "{1}", more);
        } else if (more != null) {
            msg = msg + ": " + more;
        }
        if (!translated) {
            GT.setDoTranslate(doTranslate);
        }
        return msg;
    }

    protected boolean commandExpected() {
        this.ichToken = this.ichCurrentCommand;
        return this.error(2);
    }

    protected boolean error(int error) {
        return this.error(error, null, null);
    }

    protected boolean error(int error, String value) {
        return this.error(error, value, null);
    }

    protected boolean error(int iError, String value, String more) {
        String strError = ScriptCompilationTokenParser.errorString(iError, value, more, true);
        String strUntranslated = GT.getDoTranslate() ? ScriptCompilationTokenParser.errorString(iError, value, more, false) : null;
        return this.error(strError, strUntranslated);
    }

    protected boolean error(String errorMessage, String strUntranslated) {
        this.errorMessage = errorMessage;
        this.errorMessageUntranslated = strUntranslated;
        return false;
    }
}

