/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.awt.Image;
import java.io.Serializable;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.api.MinimizerInterface;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.i18n.GT;
import org.jmol.modelset.Atom;
import org.jmol.modelset.AtomCollection;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Group;
import org.jmol.modelset.LabelToken;
import org.jmol.modelset.ModelCollection;
import org.jmol.modelset.ModelSet;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.util.Quaternion;
import org.jmol.util.TextFormat;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.PropertyManager;
import org.jmol.viewer.ScriptCompiler;
import org.jmol.viewer.ScriptContext;
import org.jmol.viewer.ScriptFunction;
import org.jmol.viewer.ScriptMathProcessor;
import org.jmol.viewer.ScriptVariable;
import org.jmol.viewer.StateManager;
import org.jmol.viewer.Token;
import org.jmol.viewer.Viewer;

class ScriptEvaluator {
    private boolean tQuiet;
    protected boolean isSyntaxCheck;
    private boolean isCmdLine_C_Option;
    protected boolean isCmdLine_c_or_C_Option;
    private boolean historyDisabled;
    protected boolean logMessages;
    private boolean debugScript;
    private boolean interruptExecution;
    private boolean executionPaused;
    private boolean executionStepping;
    private boolean isExecuting;
    private long timeBeginExecution;
    private long timeEndExecution;
    private static final String EXPRESSION_KEY = "e_x_p_r_e_s_s_i_o_n";
    private static final int scriptLevelMax = 10;
    private Thread currentThread;
    protected Viewer viewer;
    protected ScriptCompiler compiler;
    private Hashtable definedAtomSets;
    private StringBuffer outputBuffer;
    private ScriptContext[] stack = new ScriptContext[10];
    private String contextPath = "";
    private String filename;
    private String functionName;
    private boolean isStateScript;
    private int scriptLevel;
    private int scriptReportingLevel = 0;
    private int commandHistoryLevelMax = 0;
    private Token[][] aatoken;
    private short[] lineNumbers;
    private int[][] lineIndices;
    private Hashtable contextVariables;
    private String script;
    protected int pc;
    private String thisCommand;
    private String fullCommand;
    private Token[] statement;
    private int statementLength;
    private int iToken;
    private int lineEnd;
    private int pcEnd;
    private String scriptExtensions;
    private boolean error;
    private String errorMessage;
    protected String errorMessageUntranslated;
    protected String errorType;
    protected int iCommandError;
    private boolean ignoreError;
    static final int ERROR_axisExpected = 0;
    static final int ERROR_backgroundModelError = 1;
    static final int ERROR_badArgumentCount = 2;
    static final int ERROR_badMillerIndices = 3;
    static final int ERROR_badRGBColor = 4;
    static final int ERROR_booleanExpected = 5;
    static final int ERROR_booleanOrNumberExpected = 6;
    static final int ERROR_booleanOrWhateverExpected = 7;
    static final int ERROR_colorExpected = 8;
    static final int ERROR_colorOrPaletteRequired = 9;
    static final int ERROR_commandExpected = 10;
    static final int ERROR_coordinateOrNameOrExpressionRequired = 11;
    static final int ERROR_drawObjectNotDefined = 12;
    static final int ERROR_endOfStatementUnexpected = 13;
    static final int ERROR_expressionExpected = 14;
    static final int ERROR_expressionOrIntegerExpected = 15;
    static final int ERROR_filenameExpected = 16;
    static final int ERROR_fileNotFoundException = 17;
    static final int ERROR_incompatibleArguments = 18;
    static final int ERROR_insufficientArguments = 19;
    static final int ERROR_integerExpected = 20;
    static final int ERROR_integerOutOfRange = 21;
    static final int ERROR_invalidArgument = 22;
    static final int ERROR_invalidParameterOrder = 23;
    static final int ERROR_keywordExpected = 24;
    static final int ERROR_moCoefficients = 25;
    static final int ERROR_moIndex = 26;
    static final int ERROR_moModelError = 27;
    static final int ERROR_moOccupancy = 28;
    static final int ERROR_moOnlyOne = 29;
    static final int ERROR_multipleModelsNotOK = 30;
    static final int ERROR_noData = 31;
    static final int ERROR_noPartialCharges = 32;
    static final int ERROR_noUnitCell = 33;
    static final int ERROR_numberExpected = 34;
    static final int ERROR_numberMustBe = 35;
    static final int ERROR_numberOutOfRange = 36;
    static final int ERROR_objectNameExpected = 37;
    static final int ERROR_planeExpected = 38;
    static final int ERROR_propertyNameExpected = 39;
    static final int ERROR_spaceGroupNotFound = 40;
    static final int ERROR_stringExpected = 41;
    static final int ERROR_stringOrIdentifierExpected = 42;
    static final int ERROR_tooManyPoints = 43;
    static final int ERROR_tooManyScriptLevels = 44;
    static final int ERROR_unrecognizedAtomProperty = 45;
    static final int ERROR_unrecognizedBondProperty = 46;
    static final int ERROR_unrecognizedCommand = 47;
    static final int ERROR_unrecognizedExpression = 48;
    static final int ERROR_unrecognizedObject = 49;
    static final int ERROR_unrecognizedParameter = 50;
    static final int ERROR_unrecognizedParameterWarning = 51;
    static final int ERROR_unrecognizedShowParameter = 52;
    static final int ERROR_what = 53;
    static final int ERROR_writeWhat = 54;
    private Token[] tempStatement;
    private boolean isBondSet;
    private Object expressionResult;
    private int theTok;
    private Token theToken;
    private boolean coordinatesAreFractional;
    private Object[] data;

    ScriptEvaluator(Viewer viewer) {
        this.viewer = viewer;
        this.compiler = viewer.compiler;
        this.definedAtomSets = viewer.definedAtomSets;
    }

    public boolean compileScriptString(String script, boolean tQuiet) {
        this.clearState(tQuiet);
        this.contextPath = "[script]";
        return this.compileScript(null, script, this.debugScript);
    }

    public boolean compileScriptFile(String filename, boolean tQuiet) {
        this.clearState(tQuiet);
        this.contextPath = filename;
        return this.compileScriptFileInternal(filename);
    }

    public void evaluateCompiledScript(boolean isCmdLine_c_or_C_Option, boolean isCmdLine_C_Option, boolean historyDisabled, boolean listCommands) {
        boolean tempOpen = this.isCmdLine_C_Option;
        this.isCmdLine_C_Option = isCmdLine_C_Option;
        this.viewer.pushHoldRepaint("runEval");
        this.executionPaused = false;
        this.interruptExecution = false;
        this.executionStepping = false;
        this.isExecuting = true;
        this.currentThread = Thread.currentThread();
        this.isSyntaxCheck = this.isCmdLine_c_or_C_Option = isCmdLine_c_or_C_Option;
        this.timeBeginExecution = System.currentTimeMillis();
        this.historyDisabled = historyDisabled;
        this.setErrorMessage(null);
        try {
            try {
                this.setScriptExtensions();
                this.instructionDispatchLoop(listCommands);
                String script = this.viewer.getInterruptScript();
                if (script != "") {
                    this.runScript(script, null);
                }
            }
            catch (Error er) {
                this.viewer.handleError(er, false);
                this.setErrorMessage("" + er + " " + this.viewer.getShapeErrorState());
                this.errorMessageUntranslated = "" + er;
                this.scriptStatusOrBuffer(this.errorMessage);
            }
        }
        catch (ScriptException e) {
            this.setErrorMessage(e.toString());
            this.errorMessageUntranslated = e.getErrorMessageUntranslated();
            this.scriptStatusOrBuffer(this.errorMessage);
            this.viewer.notifyError(this.errorMessage != null && this.errorMessage.indexOf("java.lang.OutOfMemoryError") >= 0 ? "Error" : "ScriptException", this.errorMessage, this.errorMessageUntranslated);
        }
        this.timeEndExecution = System.currentTimeMillis();
        this.isCmdLine_C_Option = tempOpen;
        if (this.errorMessage == null && this.interruptExecution) {
            this.setErrorMessage("execution interrupted");
        } else if (!this.tQuiet && !this.isSyntaxCheck) {
            this.viewer.scriptStatus("Script completed");
        }
        historyDisabled = false;
        isCmdLine_c_or_C_Option = false;
        this.isSyntaxCheck = false;
        this.isExecuting = false;
        this.viewer.setTainted(true);
        this.viewer.popHoldRepaint("runEval");
    }

    public void runScript(String script, StringBuffer outputBuffer) throws ScriptException {
        this.pushContext(null);
        this.contextPath = this.contextPath + " >> script() ";
        this.outputBuffer = outputBuffer;
        if (this.compileScript(null, script + "\u0000## EDITOR_IGNORE ##", false)) {
            this.instructionDispatchLoop(false);
        }
        this.popContext();
    }

    public ScriptContext checkScriptSilent(String script) {
        ScriptContext sc = this.compiler.compile(null, script, false, true, false, true);
        if (sc.errorType != null) {
            return sc;
        }
        this.getScriptContext(sc, false);
        this.isSyntaxCheck = true;
        this.isCmdLine_C_Option = false;
        this.isCmdLine_c_or_C_Option = false;
        this.pc = 0;
        try {
            this.instructionDispatchLoop(false);
        }
        catch (ScriptException e) {
            this.setErrorMessage(e.toString());
            sc = this.getScriptContext();
        }
        this.isSyntaxCheck = false;
        return sc;
    }

    void setDebugging() {
        this.debugScript = this.viewer.getDebugScript();
        this.logMessages = this.debugScript && Logger.debugging;
    }

    int getExecutionWalltime() {
        return (int)(this.timeEndExecution - this.timeBeginExecution);
    }

    void haltExecution() {
        this.resumePausedExecution();
        this.interruptExecution = true;
    }

    void pauseExecution() {
        if (this.isSyntaxCheck) {
            return;
        }
        this.delay(-100L);
        this.viewer.popHoldRepaint("pauseExecution");
        this.executionStepping = false;
        this.executionPaused = true;
    }

    void stepPausedExecution() {
        this.executionStepping = true;
        this.executionPaused = false;
    }

    void resumePausedExecution() {
        this.executionPaused = false;
        this.executionStepping = false;
    }

    boolean isScriptExecuting() {
        return this.isExecuting && !this.interruptExecution;
    }

    boolean isExecutionPaused() {
        return this.executionPaused;
    }

    boolean isExecutionStepping() {
        return this.executionStepping;
    }

    String getNextStatement() {
        return this.pc < this.aatoken.length ? ScriptEvaluator.setErrorLineMessage(this.functionName, this.filename, this.getLinenumber(null), this.pc, this.statementAsString(this.aatoken[this.pc], -9999)) : "";
    }

    private String getCommand(int pc, boolean allThisLine, boolean addSemi) {
        if (pc >= this.lineIndices.length) {
            return "";
        }
        if (allThisLine) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this.lineNumbers.length; ++i) {
                if (this.lineNumbers[i] == this.lineNumbers[pc]) {
                    sb.append(this.getCommand(i, false, false));
                    continue;
                }
                if (this.lineNumbers[i] == 0 || this.lineNumbers[i] > this.lineNumbers[pc]) break;
            }
            return sb.toString();
        }
        int ichBegin = this.lineIndices[pc][0];
        int ichEnd = this.lineIndices[pc][1];
        String s = "";
        if (ichBegin < 0 || ichEnd <= ichBegin || ichEnd > this.script.length()) {
            return "";
        }
        try {
            s = this.script.substring(ichBegin, ichEnd);
            if (s.indexOf("\\\n") >= 0) {
                s = TextFormat.simpleReplace(s, "\\\n", "  ");
            }
            if (s.indexOf("\\\r") >= 0) {
                s = TextFormat.simpleReplace(s, "\\\r", "  ");
            }
            if (!(s.length() <= 0 || s.endsWith(";") || s.endsWith("{") || s.endsWith("}"))) {
                s = s + ";";
            }
        }
        catch (Exception e) {
            Logger.error("darn problem in Eval getCommand: ichBegin=" + ichBegin + " ichEnd=" + ichEnd + " len = " + this.script.length() + "\n" + e);
        }
        return s;
    }

    private void logDebugScript(int ifLevel) {
        if (this.logMessages) {
            if (this.statement.length > 0) {
                Logger.debug(this.statement[0].toString());
            }
            for (int i = 1; i < this.statementLength; ++i) {
                Logger.debug(this.statement[i].toString());
            }
        }
        this.iToken = -9999;
        if (this.logMessages) {
            StringBuffer strbufLog = new StringBuffer(80);
            String s = ifLevel > 0 ? "                          ".substring(0, ifLevel * 2) : "";
            strbufLog.append(s).append(this.statementAsString(this.statement, this.iToken));
            this.viewer.scriptStatus(strbufLog.toString());
        } else {
            String cmd = this.getCommand(this.pc, false, false);
            this.viewer.scriptStatus(cmd);
        }
    }

    static Object evaluateExpression(Viewer viewer, Object expr) {
        ScriptEvaluator e = new ScriptEvaluator(viewer);
        try {
            if (expr instanceof String) {
                if (e.compileScript(null, "e_x_p_r_e_s_s_i_o_n = " + expr, false)) {
                    e.contextVariables = viewer.eval.contextVariables;
                    e.setStatement(0);
                    return e.parameterExpression(2, 0, "", false);
                }
            } else if (expr instanceof Token[]) {
                e.contextVariables = viewer.eval.contextVariables;
                return e.expression((Token[])expr, 0, 0, true, false, true, false);
            }
        }
        catch (Exception ex) {
            Logger.error("Error evaluating: " + expr + "\n" + ex);
        }
        return "ERROR";
    }

    static BitSet getAtomBitSet(ScriptEvaluator e, Object atomExpression) {
        if (atomExpression instanceof BitSet) {
            return (BitSet)atomExpression;
        }
        BitSet bs = new BitSet();
        try {
            e.pushContext(null);
            String scr = "select (" + atomExpression + ")";
            scr = TextFormat.replaceAllCharacters(scr, "\n\r", "),(");
            scr = TextFormat.simpleReplace(scr, "()", "(none)");
            if (e.compileScript(null, scr, false)) {
                e.statement = e.aatoken[0];
                bs = e.expression(e.statement, 1, 0, false, false, true, true);
            }
            e.popContext();
        }
        catch (Exception ex) {
            Logger.error("getAtomBitSet " + atomExpression + "\n" + ex);
        }
        return bs;
    }

    static Vector getAtomBitSetVector(ScriptEvaluator e, int atomCount, Object atomExpression) {
        Vector<Integer> V = new Vector<Integer>();
        BitSet bs = ScriptEvaluator.getAtomBitSet(e, atomExpression);
        for (int i = 0; i < atomCount; ++i) {
            if (!bs.get(i)) continue;
            V.addElement(new Integer(i));
        }
        return V;
    }

    private Object parameterExpression(int pt, int ptMax, String key, boolean asVector) throws ScriptException {
        return this.parameterExpression(pt, ptMax, key, asVector, -1, false, null, null);
    }

    private Object parameterExpression(int pt, int ptMax, String key, boolean asVector, int ptAtom, boolean isArrayItem, Hashtable localVars, String localVar) throws ScriptException {
        ScriptVariable result;
        boolean returnString;
        boolean isImplicitAtomProperty = localVar != null;
        boolean isOneExpressionOnly = pt < 0;
        boolean returnBoolean = key == null;
        boolean bl = returnString = key != null && key.length() == 0;
        if (isOneExpressionOnly) {
            pt = -pt;
        }
        int nParen = 0;
        ScriptMathProcessor rpn = new ScriptMathProcessor(this, isArrayItem, asVector);
        if (pt == 0 && ptMax == 0) {
            pt = 2;
        }
        if (ptMax < pt) {
            ptMax = this.statementLength;
        }
        block24: for (int i = pt; i < ptMax; ++i) {
            Object v = null;
            int tok = this.getToken((int)i).tok;
            if (isImplicitAtomProperty && this.tokAt(i + 1) != 0x100008) {
                ScriptVariable token;
                ScriptVariable scriptVariable = token = localVars != null && localVars.containsKey(this.theToken.value) ? null : this.getBitsetPropertySelector(i, false);
                if (token != null) {
                    rpn.addX((ScriptVariable)localVars.get(localVar));
                    if (!rpn.addOp(token)) {
                        this.error(22);
                    }
                    if (token.intValue == 135499780 && this.tokAt(this.iToken + 1) != 0x10100010) {
                        rpn.addOp(Token.tokenLeftParen);
                        rpn.addOp(Token.tokenRightParen);
                    }
                    i = this.iToken;
                    continue;
                }
            }
            switch (tok) {
                case 135369225: {
                    if (this.getToken((int)(++i)).tok != 0x10100010) {
                        this.error(22);
                    }
                    if (localVars == null) {
                        localVars = new Hashtable<String, ScriptVariable>();
                    }
                    Object res = this.parameterExpression(++i, -1, null, false, -1, false, localVars, localVar);
                    boolean TF = (Boolean)res;
                    int iT = this.iToken;
                    if (this.getToken((int)iT++).tok != 0x10000F) {
                        this.error(22);
                    }
                    this.parameterExpression(iT, -1, null, false);
                    int iF = this.iToken;
                    if (this.tokAt(iF++) != 0x10000F) {
                        this.error(22);
                    }
                    this.parameterExpression(-iF, -1, null, false, 1, false, localVars, localVar);
                    int iEnd = this.iToken;
                    if (this.tokAt(iEnd) != 0x10100011) {
                        this.error(22);
                    }
                    v = this.parameterExpression(TF ? iT : iF, TF ? iF : iEnd, "XXX", false, 1, false, localVars, localVar);
                    i = iEnd;
                    break;
                }
                case 135280129: 
                case 135369224: {
                    int atomCount;
                    String dummy;
                    boolean isFor;
                    Object res;
                    boolean isFunctionOfX = pt > 0;
                    boolean bl2 = isFor = isFunctionOfX && tok == 135369224;
                    if (isFunctionOfX) {
                        if (this.getToken((int)(++i)).tok != 0x10100010 || this.getToken((int)(++i)).tok != 1) {
                            this.error(22);
                        }
                        dummy = this.parameterAsString(i);
                        if (this.getToken((int)(++i)).tok != 0x10000F) {
                            this.error(22);
                        }
                    } else {
                        dummy = "_x";
                    }
                    if (!((v = this.tokenSetting((int)(-(++i))).value) instanceof BitSet)) {
                        this.error(22);
                    }
                    BitSet bsAtoms = (BitSet)v;
                    i = this.iToken;
                    if (isFunctionOfX && this.getToken((int)i++).tok != 0x10000F) {
                        this.error(22);
                    }
                    BitSet bsSelect = new BitSet();
                    BitSet bsX = new BitSet();
                    String[] sout = isFor ? new String[BitSetUtil.cardinalityOf(bsAtoms)] : null;
                    ScriptVariable t = null;
                    int n = atomCount = this.isSyntaxCheck ? 0 : this.viewer.getAtomCount();
                    if (localVars == null) {
                        localVars = new Hashtable();
                    }
                    bsX.set(0);
                    t = ScriptVariable.getVariableSelected(0, bsX).setName(dummy);
                    localVars.put(dummy, t);
                    int pt2 = -1;
                    if (isFunctionOfX) {
                        pt2 = i - 1;
                        int np = 0;
                        while (np >= 0 && ++pt2 < ptMax) {
                            int tok2 = this.tokAt(pt2);
                            if (tok2 == 0x10100011) {
                                --np;
                                continue;
                            }
                            if (tok2 != 0x10100010) continue;
                            ++np;
                        }
                    }
                    int p = 0;
                    int jlast = 0;
                    if (BitSetUtil.firstSetBit(bsAtoms) < 0) {
                        this.iToken = pt2 - 1;
                    } else {
                        for (int j = 0; j < atomCount; ++j) {
                            if (!bsAtoms.get(j)) continue;
                            if (jlast >= 0) {
                                bsX.clear(jlast);
                            }
                            jlast = j;
                            bsX.set(j);
                            t.index = j;
                            res = this.parameterExpression(i, pt2, isFor ? "XXX" : null, isFor, j, false, localVars, isFunctionOfX ? null : dummy);
                            if (isFor) {
                                if (res == null || ((Vector)res).size() == 0) {
                                    this.error(22);
                                }
                                sout[p++] = ScriptVariable.sValue((ScriptVariable)((Vector)res).elementAt(0));
                                continue;
                            }
                            if (!((Boolean)res).booleanValue()) continue;
                            bsSelect.set(j);
                        }
                    }
                    if (isFor) {
                        v = sout;
                    } else if (isFunctionOfX) {
                        v = bsSelect;
                    } else {
                        return this.bitsetVariableVector(bsSelect);
                    }
                    i = this.iToken + 1;
                    break;
                }
                case 0x10000F: {
                    break block24;
                }
                case 2: 
                case 1048614: {
                    rpn.addXNum(ScriptVariable.intVariable(this.theToken.intValue));
                    break;
                }
                case 135268355: {
                    if (this.tokAt(this.iToken + 1) == 0x10100010) {
                        if (rpn.addOp(this.theToken, true)) break;
                        this.error(22);
                        break;
                    }
                    rpn.addX(new ScriptVariable(this.theToken));
                    break;
                }
                case 3: 
                case 4: 
                case 7: 
                case 8: 
                case 0x100004: 
                case 0x100006: 
                case 0x10000C: 
                case 0x10000D: 
                case 0xD00004: 
                case 0xD00006: 
                case 0xD00101: 
                case 13631746: 
                case 13631749: 
                case 22020109: 
                case 0x1500010: 
                case 22024203: 
                case 30412803: 
                case 605556745: 
                case 0x40000007: 
                case 1073741944: {
                    rpn.addX(new ScriptVariable(this.theToken));
                    break;
                }
                case 0x100007: {
                    rpn.addX(new ScriptVariable(7, this.centerParameter(i)));
                    i = this.iToken;
                    break;
                }
                case 0x10000A: {
                    v = this.getPointOrPlane(i, false, true, true, false, 3, 4);
                    i = this.iToken;
                    break;
                }
                case 0x100001: {
                    if (this.tokAt(i + 1) == 0x100003 && this.tokAt(i + 2) == 0x100002) {
                        tok = 0x100003;
                        this.iToken += 2;
                    }
                }
                case 0x100003: {
                    v = tok == 0x100003 ? this.viewer.getModelAtomBitSet(-1, true) : this.expression(this.statement, i, 0, true, true, true, true);
                    i = this.iToken++;
                    if (nParen != 0 || !isOneExpressionOnly) break;
                    return this.bitsetVariableVector(v);
                }
                case 0x100002: {
                    ++i;
                    break block24;
                }
                case 0x10000E: {
                    this.error(22);
                    break;
                }
                case 0x10100030: {
                    if (rpn.addOp(this.theToken)) break;
                    this.error(22);
                    break;
                }
                case 0x100008: {
                    ScriptVariable token = this.getBitsetPropertySelector(i + 1, false);
                    if (token == null) {
                        this.error(22);
                    }
                    boolean isUserFunction = token.intValue == 135499780;
                    boolean allowMathFunc = true;
                    int tok2 = this.tokAt(this.iToken + 2);
                    if (this.tokAt(this.iToken + 1) == 0x100008) {
                        switch (tok2) {
                            case 0x100003: {
                                tok2 = 224;
                            }
                            case 32: 
                            case 64: 
                            case 96: 
                            case 128: {
                                allowMathFunc = isUserFunction || tok2 == 224;
                                token.intValue |= tok2;
                                this.getToken(this.iToken + 2);
                            }
                        }
                    }
                    if (!rpn.addOp(token, allowMathFunc &= this.tokAt(this.iToken + 1) == 0x10100010 || isUserFunction)) {
                        this.error(22);
                    }
                    i = this.iToken;
                    if (token.intValue != 135499780 || this.tokAt(i + 1) == 0x10100010) break;
                    rpn.addOp(Token.tokenLeftParen);
                    rpn.addOp(Token.tokenRightParen);
                    break;
                }
                default: {
                    if (this.theTok == 1 && this.viewer.isFunction((String)this.theToken.value)) {
                        if (!rpn.addOp(new ScriptVariable(135499780, this.theToken.value))) {
                            this.error(22);
                        }
                        if (this.tokAt(i + 1) == 0x10100010) break;
                        rpn.addOp(Token.tokenLeftParen);
                        rpn.addOp(Token.tokenRightParen);
                        break;
                    }
                    if (Token.tokAttr(this.theTok, 0x10100000) || Token.tokAttr(this.theTok, 0x8100000)) {
                        if (!rpn.addOp(this.theToken)) {
                            if (ptAtom >= 0) break block24;
                            this.error(22);
                        }
                        if (this.theTok == 0x10100010) {
                            ++nParen;
                            break;
                        }
                        if (this.theTok != 0x10100011 || --nParen != 0 || !isOneExpressionOnly) break;
                        ++this.iToken;
                        break block24;
                    }
                    String name = this.parameterAsString(i).toLowerCase();
                    if (this.isSyntaxCheck) {
                        v = name;
                        break;
                    }
                    if (localVars != null && (v = localVars.get(name)) != null || (v = this.getContextVariableAsVariable(name)) != null) break;
                    rpn.addX(this.viewer.getOrSetNewVariable(name, false));
                    break;
                }
            }
            if (v == null) continue;
            rpn.addX(v);
        }
        if ((result = rpn.getResult(false, key)) == null) {
            if (!this.isSyntaxCheck) {
                rpn.dumpStacks("null result");
            }
            this.error(13);
        }
        if (result.tok == 4161) {
            return result.value;
        }
        if (returnBoolean) {
            return ScriptVariable.bValue(result);
        }
        if (returnString) {
            if (result.tok == 4) {
                result.intValue = Integer.MAX_VALUE;
            }
            return ScriptVariable.sValue(result);
        }
        switch (result.tok) {
            case 0x10000C: 
            case 0x10000D: {
                return result.intValue == 1;
            }
            case 2: {
                return new Integer(result.intValue);
            }
        }
        return result.value;
    }

    Object bitsetVariableVector(Object v) {
        Vector<ScriptVariable> resx = new Vector<ScriptVariable>();
        if (v instanceof BitSet) {
            resx.addElement(new ScriptVariable(0x40000007, v));
        }
        return resx;
    }

    Object getBitsetIdent(BitSet bs, String label, Object tokenValue, boolean useAtomMap, int index, boolean isExplicitlyAll) {
        int j;
        Hashtable htValues;
        int[] indices;
        boolean haveIndex;
        boolean isAtoms;
        boolean bl = isAtoms = !(tokenValue instanceof Bond.BondSet);
        if (isAtoms) {
            if (label == null) {
                label = this.viewer.getStandardLabelFormat();
            } else if (label.length() == 0) {
                label = "%[label]";
            }
        }
        int pt = label == null ? -1 : label.indexOf("%");
        boolean bl2 = haveIndex = index != Integer.MAX_VALUE;
        if (bs == null || this.isSyntaxCheck || isAtoms && pt < 0) {
            String[] stringArray;
            if (label == null) {
                label = "";
            }
            if (isExplicitlyAll) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = label;
            } else {
                stringArray = label;
            }
            return stringArray;
        }
        int len = haveIndex ? index + 1 : bs.size();
        int nmax = haveIndex ? 1 : BitSetUtil.cardinalityOf(bs);
        String[] sout = new String[nmax];
        ModelSet modelSet = this.viewer.getModelSet();
        int n = 0;
        int[] nArray = indices = isAtoms || !useAtomMap ? null : ((Bond.BondSet)tokenValue).getAssociatedAtoms();
        if (indices == null && label != null && label.indexOf("%D") > 0) {
            indices = this.viewer.getAtomIndices(bs);
        }
        boolean asIdentity = label == null || label.length() == 0;
        Hashtable hashtable = htValues = isAtoms || asIdentity ? null : LabelToken.getBondLabelValues();
        LabelToken[] tokens = asIdentity ? null : (isAtoms ? LabelToken.compile(this.viewer, (String)label, '\u0000', null) : LabelToken.compile(this.viewer, (String)label, '\u0001', htValues));
        int n2 = j = haveIndex ? index : 0;
        while (j < len) {
            if (index == j || bs.get(j)) {
                String str;
                if (isAtoms) {
                    str = asIdentity ? modelSet.getAtomAt(j).getInfo() : LabelToken.formatLabel(modelSet.getAtomAt(j), null, tokens, '\u0000', indices);
                } else {
                    Bond bond = modelSet.getBondAt(j);
                    str = asIdentity ? bond.getIdentity() : LabelToken.formatLabel(bond, tokens, htValues, indices);
                }
                str = TextFormat.formatString(str, "#", n + 1);
                sout[n++] = str;
                if (haveIndex) break;
            }
            ++j;
        }
        return nmax == 1 && !isExplicitlyAll ? sout[0] : sout;
    }

    private ScriptVariable getBitsetPropertySelector(int i, boolean mustBeSettable) throws ScriptException {
        int tok = this.getToken((int)i).tok;
        String s = null;
        block0 : switch (tok) {
            default: {
                if (Token.tokAttrOr(tok, 0x500000, 0x4100000)) break;
                return null;
            }
            case 32: 
            case 64: 
            case 96: 
            case 128: 
            case 642777357: {
                break;
            }
            case 1: {
                String name = this.parameterAsString(i);
                tok = Token.getSettableTokFromString(name);
                switch (tok) {
                    case 38797571: 
                    case 38797572: 
                    case 38797573: 
                    case 0x40000043: {
                        break block0;
                    }
                }
                if (!mustBeSettable && this.viewer.isFunction(name)) {
                    tok = 135499780;
                    break;
                }
                return null;
            }
        }
        if (mustBeSettable && !Token.tokAttr(tok, 256)) {
            return null;
        }
        if (s == null) {
            s = this.parameterAsString(i).toLowerCase();
        }
        return new ScriptVariable(0x101000C1, tok, s);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Object getBitsetProperty(BitSet bs, int tok, Point3f ptRef, Point4f planeRef, Object tokenValue, Object opValue, boolean useAtomMap, int index) throws ScriptException {
        int i;
        int len;
        Point3f pt;
        boolean isExplicitlyAll;
        boolean haveIndex = index != Integer.MAX_VALUE;
        boolean isAtoms = haveIndex || !(tokenValue instanceof Bond.BondSet);
        int minmaxtype = tok & 0xE0;
        boolean bl = isExplicitlyAll = minmaxtype == 224;
        if ((tok &= 0xFFFFFF1F) == 0) {
            tok = isAtoms ? 0x4100001 : 605028354;
        }
        boolean isPt = false;
        boolean isInt = false;
        boolean isString = false;
        switch (tok) {
            case 72351756: 
            case 72352010: 
            case 72352011: 
            case 72352013: 
            case 558895366: {
                isPt = true;
                break;
            }
            case 135499780: 
            case 202376194: {
                break;
            }
            default: {
                if (!isAtoms) break;
                isInt = Token.tokAttr(tok, 0x1500000) && !Token.tokAttr(tok, 0x2500000);
                isString = !isInt && Token.tokAttr(tok, 0xD00000);
            }
        }
        Point3f point3f = pt = isPt || !isAtoms ? new Point3f() : null;
        if (isString || isExplicitlyAll) {
            minmaxtype = 0x100003;
        }
        Vector<Object> vout = minmaxtype == 0x100003 ? new Vector<Object>() : null;
        BitSet bsNew = null;
        String userFunction = null;
        Vector params = null;
        BitSet bsAtom = null;
        ScriptVariable tokenAtom = null;
        Point3f ptT = null;
        float[] data = null;
        switch (tok) {
            case 0x4100001: 
            case 605028354: {
                int i2;
                if (this.isSyntaxCheck) {
                    return bs;
                }
                bsNew = tok == 0x4100001 ? (isAtoms ? bs : this.viewer.getAtomBits(605028354, bs)) : (isAtoms ? new Bond.BondSet(this.viewer.getBondsForSelectedAtoms(bs)) : bs);
                switch (minmaxtype) {
                    case 32: {
                        i2 = BitSetUtil.firstSetBit(bsNew);
                        break;
                    }
                    case 64: {
                        i2 = BitSetUtil.length(bsNew) - 1;
                        break;
                    }
                    case 128: {
                        return new Float(Float.NaN);
                    }
                    default: {
                        return bsNew;
                    }
                }
                bsNew.clear();
                if (i2 < 0) return bsNew;
                bsNew.set(i2);
                return bsNew;
            }
            case 0xD00009: {
                switch (minmaxtype) {
                    case 0: 
                    case 0x100003: {
                        return this.getBitsetIdent(bs, null, tokenValue, useAtomMap, index, isExplicitlyAll);
                    }
                }
                return "";
            }
            case 135499780: {
                userFunction = (String)((Object[])opValue)[0];
                params = (Vector)((Object[])opValue)[1];
                bsAtom = new BitSet();
                tokenAtom = new ScriptVariable(0x40000007, bsAtom);
                break;
            }
            case 38797327: 
            case 38797328: {
                this.viewer.autoCalculate(tok);
                break;
            }
            case 202376194: {
                if (ptRef != null || planeRef != null) break;
                return new Point3f();
            }
            case 558895366: {
                ptT = new Point3f();
                break;
            }
            case 642777357: {
                data = this.viewer.getDataFloat((String)opValue);
                break;
            }
        }
        int n = 0;
        int ivvMinMax = 0;
        int ivMinMax = 0;
        float fvMinMax = 0.0f;
        double sum = 0.0;
        double sum2 = 0.0;
        switch (minmaxtype) {
            case 32: {
                ivMinMax = Integer.MAX_VALUE;
                fvMinMax = Float.MAX_VALUE;
                break;
            }
            case 64: {
                ivMinMax = Integer.MIN_VALUE;
                fvMinMax = -3.4028235E38f;
                break;
            }
        }
        ModelSet modelSet = this.viewer.getModelSet();
        int count = 0;
        if (isAtoms) {
            int iModel = -1;
            int nOps = 0;
            int n2 = count = this.isSyntaxCheck ? 0 : this.viewer.getAtomCount();
            int mode = isPt ? 3 : (isString ? 2 : (isInt ? 1 : 0));
            block87: for (int i3 = haveIndex ? index : 0; i3 < count; ++i3) {
                if (!haveIndex && bs != null && !bs.get(i3)) continue;
                ++n;
                Atom atom = modelSet.getAtomAt(i3);
                switch (mode) {
                    case 0: {
                        float fv = Float.MAX_VALUE;
                        switch (tok) {
                            case 135499780: {
                                bsAtom.set(i3);
                                fv = ScriptVariable.fValue(this.getFunctionReturn(userFunction, params, tokenAtom));
                                bsAtom.clear(i3);
                                break;
                            }
                            case 642777357: {
                                fv = data == null ? 0.0f : data[i3];
                                break;
                            }
                            case 202376194: {
                                if (planeRef != null) {
                                    fv = Graphics3D.distanceToPlane(planeRef, atom);
                                    break;
                                }
                                fv = atom.distance(ptRef);
                                break;
                            }
                            default: {
                                fv = Atom.atomPropertyFloat(atom, tok);
                            }
                        }
                        if (fv == Float.MAX_VALUE || Float.isNaN(fv) && minmaxtype != 0x100003) {
                            --n;
                            continue block87;
                        }
                        switch (minmaxtype) {
                            case 32: {
                                if (!(fv < fvMinMax)) break;
                                fvMinMax = fv;
                                break;
                            }
                            case 64: {
                                if (!(fv > fvMinMax)) break;
                                fvMinMax = fv;
                                break;
                            }
                            case 0x100003: {
                                vout.add(new Float(fv));
                                break;
                            }
                            case 128: {
                                sum2 += (double)fv * (double)fv;
                            }
                            default: {
                                sum += (double)fv;
                                break;
                            }
                        }
                        break;
                    }
                    case 1: {
                        int iv = 0;
                        switch (tok) {
                            case 22020115: {
                                if (atom.getModelIndex() != iModel) {
                                    iModel = atom.getModelIndex();
                                    nOps = modelSet.getModelSymmetryCount(iModel);
                                }
                                BitSet bsSym = atom.getAtomSymmetry();
                                int len2 = nOps;
                                int p = 0;
                                switch (minmaxtype) {
                                    case 32: {
                                        ivvMinMax = Integer.MAX_VALUE;
                                        break;
                                    }
                                    case 64: {
                                        ivvMinMax = Integer.MIN_VALUE;
                                        break;
                                    }
                                }
                                for (int k = 0; k < len2; ++k) {
                                    if (!bsSym.get(k)) continue;
                                    iv += k + 1;
                                    switch (minmaxtype) {
                                        case 32: {
                                            ivvMinMax = Math.min(ivvMinMax, k + 1);
                                            break;
                                        }
                                        case 64: {
                                            ivvMinMax = Math.max(ivvMinMax, k + 1);
                                            break;
                                        }
                                    }
                                    ++p;
                                }
                                switch (minmaxtype) {
                                    case 32: 
                                    case 64: {
                                        iv = ivvMinMax;
                                        break;
                                    }
                                }
                                n += p - 1;
                                break;
                            }
                            case 0x1500005: {
                                this.error(45, Token.nameOf(tok));
                            }
                            default: {
                                iv = Atom.atomPropertyInt(atom, tok);
                            }
                        }
                        switch (minmaxtype) {
                            case 32: {
                                if (iv >= ivMinMax) break;
                                ivMinMax = iv;
                                break;
                            }
                            case 64: {
                                if (iv <= ivMinMax) break;
                                ivMinMax = iv;
                                break;
                            }
                            case 0x100003: {
                                vout.add(new Integer(iv));
                                break;
                            }
                            case 128: {
                                sum2 += (double)iv * (double)iv;
                            }
                            default: {
                                sum += (double)iv;
                                break;
                            }
                        }
                        break;
                    }
                    case 2: {
                        vout.add(Atom.atomPropertyString(atom, tok));
                        break;
                    }
                    case 3: {
                        Tuple3f t = Atom.atomPropertyTuple(atom, tok);
                        if (t == null) {
                            this.error(45, Token.nameOf(tok));
                        }
                        pt.add(t);
                        if (minmaxtype != 0x100003) break;
                        vout.add(new Point3f(pt));
                        pt.set(0.0f, 0.0f, 0.0f);
                    }
                }
                if (!haveIndex) {
                    continue;
                }
                break;
            }
        } else {
            count = this.viewer.getBondCount();
            block89: for (int i4 = 0; i4 < count; ++i4) {
                if (bs != null && !bs.get(i4)) continue;
                ++n;
                Bond bond = modelSet.getBondAt(i4);
                switch (tok) {
                    case 68157443: {
                        float fv = bond.getAtom1().distance(bond.getAtom2());
                        switch (minmaxtype) {
                            case 32: {
                                if (!(fv < fvMinMax)) break;
                                fvMinMax = fv;
                                break;
                            }
                            case 64: {
                                if (!(fv > fvMinMax)) break;
                                fvMinMax = fv;
                                break;
                            }
                            case 0x100003: {
                                vout.add(new Float(fv));
                                break;
                            }
                            case 128: {
                                sum2 += (double)fv * (double)fv;
                            }
                            default: {
                                sum += (double)fv;
                                break;
                            }
                        }
                        continue block89;
                    }
                    case 72352010: {
                        switch (minmaxtype) {
                            case 0x100003: {
                                pt.set(bond.getAtom1());
                                pt.add(bond.getAtom2());
                                pt.scale(0.5f);
                                vout.add(new Point3f(pt));
                                continue block89;
                            }
                        }
                        pt.add(bond.getAtom1());
                        pt.add(bond.getAtom2());
                        ++n;
                        continue block89;
                    }
                    case 558895366: {
                        Graphics3D.colorPointFromInt(this.viewer.getColixArgb(bond.getColix()), ptT);
                        switch (minmaxtype) {
                            case 0x100003: {
                                vout.add(new Point3f(ptT));
                                continue block89;
                            }
                        }
                        pt.add(ptT);
                        continue block89;
                    }
                    default: {
                        this.error(46, Token.nameOf(tok));
                    }
                }
            }
        }
        if (minmaxtype == 0x100003) {
            len = vout.size();
            if (isString && !isExplicitlyAll && len == 1) {
                return vout.get(0);
            }
            if (tok == 0xD00008) {
                StringBuffer sb = new StringBuffer();
                i = 0;
                while (i < len) {
                    sb.append((String)vout.get(i));
                    ++i;
                }
                return sb.toString();
            }
        } else {
            if (isPt) {
                Point3f point3f2;
                if (n == 0) {
                    point3f2 = pt;
                    return point3f2;
                }
                point3f2 = new Point3f(pt.x / (float)n, pt.y / (float)n, pt.z / (float)n);
                return point3f2;
            }
            if (n == 0) return new Float(Float.NaN);
            if (n == 1 && minmaxtype == 128) {
                return new Float(Float.NaN);
            }
            if (isInt) {
                switch (minmaxtype) {
                    case 32: 
                    case 64: {
                        return new Integer(ivMinMax);
                    }
                }
            }
            switch (minmaxtype) {
                case 32: 
                case 64: {
                    return new Float(fvMinMax);
                }
                case 128: {
                    sum = Math.sqrt((sum2 - sum * sum / (double)n) / (double)(n - 1));
                    return new Float(sum);
                }
            }
            sum /= (double)n;
            return new Float(sum);
        }
        String[] sout = new String[len];
        i = len;
        while (--i >= 0) {
            Object v = vout.get(i);
            if (v instanceof Point3f) {
                sout[i] = Escape.escape((Point3f)v);
                continue;
            }
            sout[i] = "" + vout.get(i);
        }
        return sout;
    }

    private void setBitsetProperty(BitSet bs, int tok, int iValue, float fValue, Token tokenValue) throws ScriptException {
        if (this.isSyntaxCheck || BitSetUtil.cardinalityOf(bs) == 0) {
            return;
        }
        String[] list = null;
        String sValue = null;
        float[] fvalues = null;
        switch (tok) {
            case 72352010: 
            case 72352011: 
            case 72352013: {
                if (tokenValue.tok == 7) {
                    this.viewer.setAtomCoord(bs, tok, tokenValue.value);
                } else if (tokenValue.tok == 6) {
                    list = (String[])tokenValue.value;
                    int nValues = list.length;
                    if (nValues == 0) {
                        return;
                    }
                    Point3f[] values = new Point3f[nValues];
                    int i = nValues;
                    while (--i >= 0) {
                        Object o = Escape.unescapePoint(list[i]);
                        if (!(o instanceof Point3f)) {
                            this.error(50, "ARRAY", list[i]);
                        }
                        values[i] = (Point3f)o;
                    }
                    this.viewer.setAtomCoord(bs, tok, values);
                }
                return;
            }
            case 558895366: {
                if (tokenValue.tok == 7) {
                    iValue = ScriptEvaluator.colorPtToInt((Point3f)tokenValue.value);
                } else if (tokenValue.tok == 6) {
                    list = (String[])tokenValue.value;
                    int nValues = list.length;
                    if (nValues == 0) {
                        return;
                    }
                    int[] values = new int[nValues];
                    int i = nValues;
                    while (--i >= 0) {
                        Object pt = Escape.unescapePoint(list[i]);
                        values[i] = pt instanceof Point3f ? ScriptEvaluator.colorPtToInt((Point3f)pt) : Graphics3D.getArgbFromString(list[i]);
                        if (values[i] != 0 || (values[i] = Parser.parseInt(list[i])) != Integer.MIN_VALUE) continue;
                        this.error(50, "ARRAY", list[i]);
                    }
                    this.viewer.setShapeProperty(0, "colorValues", values, bs);
                    return;
                }
                this.viewer.setShapeProperty(0, "color", tokenValue.tok == 4 ? tokenValue.value : new Integer(iValue), bs);
                return;
            }
            case 214958338: 
            case 752374019: {
                if (tokenValue.tok == 6) {
                    list = (String[])tokenValue.value;
                } else {
                    sValue = ScriptVariable.sValue(tokenValue);
                }
                this.viewer.setAtomProperty(bs, tok, iValue, fValue, sValue, fvalues, list);
                return;
            }
            case 13631749: 
            case 22020359: {
                this.clearDefinedVariableAtomSets();
            }
        }
        if (tokenValue.tok == 6 || tokenValue.tok == 4) {
            list = tokenValue.tok == 6 ? (String[])tokenValue.value : Parser.getTokens(ScriptVariable.sValue(tokenValue));
            int nValues = list.length;
            if (nValues == 0) {
                return;
            }
            fvalues = new float[nValues];
            int i = nValues;
            while (--i >= 0) {
                fvalues[i] = tok == 13631749 ? (float)JmolConstants.elementNumberFromSymbol(list[i]) : Parser.parseFloat(list[i]);
            }
            if (tokenValue.tok == 4 && nValues == 1) {
                fValue = fvalues[0];
                iValue = (int)fValue;
                sValue = list[0];
                list = null;
                fvalues = null;
            }
        }
        this.viewer.setAtomProperty(bs, tok, iValue, fValue, sValue, fvalues, list);
    }

    String getScript() {
        return this.script;
    }

    String getState() {
        return this.getFunctionCalls("");
    }

    private boolean compileScript(String filename, String strScript, boolean debugCompiler) {
        this.filename = filename;
        this.getScriptContext(this.compiler.compile(filename, strScript, false, false, debugCompiler, false), false);
        this.isStateScript = this.script.indexOf("# Jmol state version ") >= 0;
        String s = this.script;
        this.pc = this.setScriptExtensions();
        if (!this.isSyntaxCheck && this.viewer.isScriptEditorVisible() && strScript.indexOf("\u0000## EDITOR_IGNORE ##") < 0) {
            this.viewer.scriptStatus("");
        }
        this.script = s;
        return !this.error;
    }

    private int setScriptExtensions() {
        String extensions = this.scriptExtensions;
        if (extensions == null) {
            return 0;
        }
        int pt = extensions.indexOf("##SCRIPT_STEP");
        if (pt >= 0) {
            this.executionStepping = true;
        }
        if ((pt = extensions.indexOf("##SCRIPT_START=")) < 0) {
            return 0;
        }
        if ((pt = Parser.parseInt(extensions.substring(pt + 15))) == Integer.MIN_VALUE) {
            return 0;
        }
        this.pc = 0;
        while (this.pc < this.lineIndices.length && this.lineIndices[this.pc][0] <= pt && this.lineIndices[this.pc][1] < pt) {
            ++this.pc;
        }
        if (this.pc > 0 && this.pc < this.lineIndices.length && this.lineIndices[this.pc][0] > pt) {
            --this.pc;
        }
        return this.pc;
    }

    private void runScript(String script) throws ScriptException {
        this.runScript(script, this.outputBuffer);
    }

    private boolean compileScriptFileInternal(String filename) {
        if (filename.toLowerCase().indexOf("javascript:") == 0) {
            return this.compileScript(filename, this.viewer.jsEval(filename.substring(11)), this.debugScript);
        }
        String[] data = new String[2];
        data[0] = filename;
        if (!this.viewer.getFileAsString(data, Integer.MAX_VALUE, false)) {
            this.setErrorMessage("io error reading " + data[0] + ": " + data[1]);
            return false;
        }
        this.filename = filename;
        return this.compileScript(filename, data[1], this.debugScript);
    }

    private Object getParameter(String key, boolean asToken) {
        Object v = this.getContextVariableAsVariable(key);
        if (v == null) {
            v = this.viewer.getParameter(key);
        }
        if (asToken) {
            return v instanceof ScriptVariable ? (ScriptVariable)v : ScriptVariable.getVariable(v);
        }
        return v instanceof ScriptVariable ? ScriptVariable.oValue((ScriptVariable)v) : v;
    }

    private String getParameterEscaped(String var) {
        ScriptVariable v = this.getContextVariableAsVariable(var);
        return v == null ? "" + this.viewer.getParameterEscaped(var) : Escape.escape(v.value);
    }

    private String getStringParameter(String var, boolean orReturnName) {
        ScriptVariable v = this.getContextVariableAsVariable(var);
        if (v != null) {
            return ScriptVariable.sValue(v);
        }
        String val = "" + this.viewer.getParameter(var);
        return val.length() == 0 && orReturnName ? var : val;
    }

    private Object getNumericParameter(String var) {
        if (var.equalsIgnoreCase("_modelNumber")) {
            int modelIndex = this.viewer.getCurrentModelIndex();
            return new Integer(modelIndex < 0 ? 0 : this.viewer.getModelFileNumber(modelIndex));
        }
        ScriptVariable v = this.getContextVariableAsVariable(var);
        if (v == null) {
            Object val = this.viewer.getParameter(var);
            if (!(val instanceof String)) {
                return val;
            }
            v = new ScriptVariable(4, val);
        }
        return ScriptVariable.nValue(v);
    }

    private ScriptVariable getContextVariableAsVariable(String var) {
        if (var.equals("expressionBegin")) {
            return null;
        }
        var = var.toLowerCase();
        if (this.contextVariables != null && this.contextVariables.containsKey(var)) {
            return (ScriptVariable)this.contextVariables.get(var);
        }
        int i = this.scriptLevel;
        while (--i >= 0) {
            if (this.stack[i].contextVariables == null || !this.stack[i].contextVariables.containsKey(var)) continue;
            return (ScriptVariable)this.stack[i].contextVariables.get(var);
        }
        return null;
    }

    private Object getStringObjectAsVariable(String s, String key) {
        if (s == null || s.length() == 0) {
            return s;
        }
        Object v = ScriptVariable.unescapePointOrBitsetAsVariable(s);
        if (v instanceof String && key != null) {
            v = this.viewer.setUserVariable(key, new ScriptVariable(4, (String)v));
        }
        return v;
    }

    private boolean loadFunction(String name, Vector params) {
        ScriptFunction function = this.viewer.getFunction(name);
        if (function == null) {
            return false;
        }
        this.aatoken = function.aatoken;
        this.lineNumbers = function.lineNumbers;
        this.lineIndices = function.lineIndices;
        this.script = function.script;
        this.pc = 0;
        if (function.names != null) {
            this.contextVariables = new Hashtable();
            function.setVariables(this.contextVariables, params);
        }
        this.functionName = name;
        return true;
    }

    protected ScriptVariable getFunctionReturn(String name, Vector params, ScriptVariable tokenAtom) throws ScriptException {
        this.pushContext(null);
        this.contextPath = this.contextPath + " >> function " + name;
        this.loadFunction(name, params);
        if (tokenAtom != null) {
            this.contextVariables.put("_x", tokenAtom);
        }
        this.instructionDispatchLoop(false);
        ScriptVariable v = this.getContextVariableAsVariable("_retval");
        this.popContext();
        return v;
    }

    private void clearDefinedVariableAtomSets() {
        this.definedAtomSets.remove("# variable");
    }

    private void defineSets() {
        String definition;
        int i;
        if (!this.definedAtomSets.containsKey("# static")) {
            for (i = 0; i < JmolConstants.predefinedStatic.length; ++i) {
                this.defineAtomSet(JmolConstants.predefinedStatic[i]);
            }
            this.defineAtomSet("# static");
        }
        if (this.definedAtomSets.containsKey("# variable")) {
            return;
        }
        for (i = 0; i < JmolConstants.predefinedVariable.length; ++i) {
            this.defineAtomSet(JmolConstants.predefinedVariable[i]);
        }
        int firstIsotope = 4;
        int i2 = JmolConstants.elementNumberMax;
        while (--i2 >= 0) {
            definition = "@" + JmolConstants.elementNameFromNumber(i2) + " _e=" + i2;
            this.defineAtomSet(definition);
        }
        i2 = JmolConstants.elementNumberMax;
        while (--i2 >= 0) {
            definition = "@_" + JmolConstants.elementSymbolFromNumber(i2) + " " + JmolConstants.elementNameFromNumber(i2);
            this.defineAtomSet(definition);
        }
        i2 = firstIsotope;
        while (--i2 >= 0) {
            definition = "@" + JmolConstants.altElementNameFromIndex(i2) + " _e=" + JmolConstants.altElementNumberFromIndex(i2);
            this.defineAtomSet(definition);
        }
        i2 = JmolConstants.altElementMax;
        while (--i2 >= firstIsotope) {
            String def = " element=" + JmolConstants.altElementNumberFromIndex(i2);
            String definition2 = "@_" + JmolConstants.altElementSymbolFromIndex(i2);
            this.defineAtomSet(definition2 + def);
            definition2 = "@_" + JmolConstants.altIsotopeSymbolFromIndex(i2);
            this.defineAtomSet(definition2 + def);
            definition2 = "@" + JmolConstants.altElementNameFromIndex(i2);
            if (definition2.length() <= 1) continue;
            this.defineAtomSet(definition2 + def);
        }
        this.defineAtomSet("# variable");
    }

    private void defineAtomSet(String script) {
        if (script.indexOf("#") == 0) {
            this.definedAtomSets.put(script, Boolean.TRUE);
            return;
        }
        ScriptContext sc = this.compiler.compile("#predefine", script, true, false, false, false);
        if (sc.errorType != null) {
            this.viewer.scriptStatus("JmolConstants.java ERROR: predefined set compile error:" + script + "\ncompile error:" + sc.errorMessageUntranslated);
            return;
        }
        if (sc.aatoken.length != 1) {
            this.viewer.scriptStatus("JmolConstants.java ERROR: predefinition does not have exactly 1 command:" + script);
            return;
        }
        Token[] statement = sc.aatoken[0];
        if (statement.length <= 2) {
            this.viewer.scriptStatus("JmolConstants.java ERROR: bad predefinition length:" + script);
            return;
        }
        this.iToken = 1;
        int tok = statement[1].tok;
        if (tok != 1 && !Token.tokAttr(tok, 0x300000)) {
            this.viewer.scriptStatus("JmolConstants.java ERROR: invalid variable name:" + script);
            return;
        }
        this.definedAtomSets.put(statement[1].value, statement);
    }

    private BitSet lookupIdentifierValue(String identifier) throws ScriptException {
        BitSet bs = this.lookupValue(identifier, false);
        if (bs != null) {
            return BitSetUtil.copy(bs);
        }
        bs = this.getAtomBits(1, identifier);
        return bs == null ? new BitSet() : bs;
    }

    private BitSet lookupValue(String setName, boolean plurals) throws ScriptException {
        if (this.isSyntaxCheck) {
            return new BitSet();
        }
        this.defineSets();
        Object value = this.definedAtomSets.get(setName);
        boolean isDynamic = false;
        if (value == null) {
            value = this.definedAtomSets.get("!" + setName);
            boolean bl = isDynamic = value != null;
        }
        if (value instanceof BitSet) {
            return (BitSet)value;
        }
        if (value instanceof Token[]) {
            this.pushContext(null);
            BitSet bs = this.expression((Token[])value, -2, 0, true, false, true, true);
            this.popContext();
            if (!isDynamic) {
                this.definedAtomSets.put(setName, bs);
            }
            return bs;
        }
        if (plurals) {
            return null;
        }
        int len = setName.length();
        if (len < 5) {
            return null;
        }
        if (setName.charAt(len - 1) != 's') {
            return null;
        }
        setName = setName.endsWith("ies") ? setName.substring(0, len - 3) + 'y' : setName.substring(0, len - 1);
        return this.lookupValue(setName, true);
    }

    void deleteAtomsInVariables(BitSet bsDeleted) {
        Enumeration e = this.definedAtomSets.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Object value = this.definedAtomSets.get(key);
            if (!(value instanceof BitSet)) continue;
            BitSetUtil.deleteBits((BitSet)value, bsDeleted);
        }
    }

    private boolean setStatement(int pc) throws ScriptException {
        int i;
        this.statement = this.aatoken[pc];
        this.statementLength = this.statement.length;
        if (this.statementLength == 0) {
            return true;
        }
        for (i = 1; i < this.statementLength && this.statement[i].tok != 537931778; ++i) {
        }
        if (i == this.statementLength) {
            return i == this.statementLength;
        }
        Token[] fixed = new Token[this.statementLength];
        fixed[0] = this.statement[0];
        boolean isExpression = false;
        int j = 1;
        for (i = 1; i < this.statementLength; ++i) {
            int tok = this.statement[i].tok;
            switch (tok) {
                case 537931778: {
                    boolean forceString;
                    Object v;
                    boolean isClauseDefine;
                    String var = this.parameterAsString(++i);
                    boolean bl = isClauseDefine = this.tokAt(i) == 0x100001;
                    if (isClauseDefine) {
                        Vector val;
                        if ((val = (Vector)this.parameterExpression(++i, 0, "_var", true)) == null || val.size() == 0) {
                            this.error(22);
                        }
                        i = this.iToken;
                        ScriptVariable vt = (ScriptVariable)val.elementAt(0);
                        v = vt.tok == 6 ? vt : ScriptVariable.oValue(vt);
                    } else {
                        v = this.getParameter(var, false);
                    }
                    tok = this.tokAt(0);
                    boolean bl2 = forceString = Token.tokAttr(tok, 20480) || tok == 135271427 || tok == 135271429;
                    if (v instanceof ScriptVariable) {
                        fixed[j] = (Token)v;
                        if (isExpression && fixed[j].tok == 6) {
                            fixed[j] = new ScriptVariable(0x40000007, ScriptEvaluator.getAtomBitSet(this, ScriptVariable.sValue((ScriptVariable)fixed[j])));
                        }
                    } else if (v instanceof Boolean) {
                        fixed[j] = (Boolean)v != false ? Token.tokenOn : Token.tokenOff;
                    } else if (v instanceof Integer) {
                        fixed[j] = new Token(2, (Integer)v, v);
                    } else if (v instanceof Float) {
                        fixed[j] = new Token(3, JmolConstants.modelValue("" + v), v);
                    } else if (v instanceof String) {
                        if ((v = this.getStringObjectAsVariable((String)v, null)) instanceof ScriptVariable) {
                            fixed[j] = (Token)v;
                        } else {
                            String s = (String)v;
                            if (isExpression) {
                                fixed[j] = new Token(0x40000007, ScriptEvaluator.getAtomBitSet(this, s));
                            } else {
                                tok = isClauseDefine || forceString || s.indexOf(".") >= 0 || s.indexOf(" ") >= 0 || s.indexOf("=") >= 0 || s.indexOf(";") >= 0 || s.indexOf("[") >= 0 || s.indexOf("{") >= 0 ? 4 : 1;
                                fixed[j] = new Token(tok, v);
                            }
                        }
                    } else if (v instanceof BitSet) {
                        fixed[j] = new Token(0x40000007, v);
                    } else if (v instanceof Point3f) {
                        fixed[j] = new Token(7, v);
                    } else if (v instanceof Point4f) {
                        fixed[j] = new Token(8, v);
                    } else if (v instanceof String[]) {
                        fixed[j] = new Token(4, Escape.escape((String[])v));
                    } else {
                        Point3f center = this.getObjectCenter(var, Integer.MIN_VALUE);
                        if (center == null) {
                            this.error(22);
                        }
                        fixed[j] = new Token(7, center);
                    }
                    if (j != 1 || this.statement[0].tok != 36867 || fixed[j].tok == 1) break;
                    this.error(22);
                    break;
                }
                case 0x100001: 
                case 0x100002: {
                    isExpression = tok == 0x100001;
                    fixed[j] = this.statement[i];
                    break;
                }
                default: {
                    fixed[j] = this.statement[i];
                }
            }
            ++j;
        }
        this.statement = fixed;
        for (i = j; i < this.statement.length; ++i) {
            this.statement[i] = null;
        }
        this.statementLength = j;
        return true;
    }

    private void clearState(boolean tQuiet) {
        int i = 10;
        while (--i >= 0) {
            this.stack[i] = null;
        }
        this.scriptLevel = 0;
        this.setErrorMessage(null);
        this.contextPath = "";
        this.tQuiet = tQuiet;
    }

    private void pushContext(ScriptFunction function) throws ScriptException {
        if (this.scriptLevel == 10) {
            this.error(44);
        }
        ScriptContext context = this.getScriptContext();
        this.stack[this.scriptLevel++] = context;
        if (this.isCmdLine_c_or_C_Option) {
            Logger.info("-->>-------------".substring(0, this.scriptLevel + 5) + this.filename);
        }
    }

    ScriptContext getScriptContext() {
        ScriptContext context = new ScriptContext();
        context.contextPath = this.contextPath;
        context.filename = this.filename;
        context.functionName = this.functionName;
        context.script = this.script;
        context.lineNumbers = this.lineNumbers;
        context.lineIndices = this.lineIndices;
        context.aatoken = this.aatoken;
        context.statement = this.statement;
        context.statementLength = this.statementLength;
        context.pc = this.pc;
        context.lineEnd = this.lineEnd;
        context.pcEnd = this.pcEnd;
        context.iToken = this.iToken;
        context.outputBuffer = this.outputBuffer;
        context.contextVariables = this.contextVariables;
        context.isStateScript = this.isStateScript;
        context.errorMessage = this.errorMessage;
        context.errorType = this.errorType;
        context.iCommandError = this.iCommandError;
        context.stack = this.stack;
        context.scriptLevel = this.scriptLevel;
        context.isSyntaxCheck = this.isSyntaxCheck;
        context.executionStepping = this.executionStepping;
        context.executionPaused = this.executionPaused;
        context.scriptExtensions = this.scriptExtensions;
        return context;
    }

    private void getScriptContext(ScriptContext context, boolean isFull) {
        this.script = context.script;
        this.lineNumbers = context.lineNumbers;
        this.lineIndices = context.lineIndices;
        this.aatoken = context.aatoken;
        this.contextVariables = context.contextVariables;
        this.scriptExtensions = context.scriptExtensions;
        if (!isFull) {
            this.error = context.errorType != null;
            this.errorMessage = context.errorMessage;
            this.errorMessageUntranslated = context.errorMessageUntranslated;
            this.iCommandError = context.iCommandError;
            this.errorType = context.errorType;
            return;
        }
        this.contextPath = context.contextPath;
        this.filename = context.filename;
        this.functionName = context.functionName;
        this.statement = context.statement;
        this.statementLength = context.statementLength;
        this.pc = context.pc;
        this.lineEnd = context.lineEnd;
        this.pcEnd = context.pcEnd;
        this.iToken = context.iToken;
        this.outputBuffer = context.outputBuffer;
        this.isStateScript = context.isStateScript;
    }

    private void popContext() {
        if (this.isCmdLine_c_or_C_Option) {
            Logger.info("--<<-------------".substring(0, this.scriptLevel + 5) + this.filename);
        }
        if (this.scriptLevel == 0) {
            return;
        }
        ScriptContext context = this.stack[--this.scriptLevel];
        this.stack[this.scriptLevel] = null;
        this.getScriptContext(context, true);
    }

    private String getContext(boolean withVariables) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.scriptLevel; ++i) {
            if (withVariables) {
                if (this.stack[i].contextVariables == null) continue;
                sb.append(this.getScriptID(this.stack[i]));
                sb.append(StateManager.getVariableList(this.stack[i].contextVariables, 80));
                continue;
            }
            sb.append(ScriptEvaluator.setErrorLineMessage(this.stack[i].functionName, this.stack[i].filename, this.getLinenumber(this.stack[i]), this.stack[i].pc, this.statementAsString(this.stack[i].statement, -9999)));
        }
        if (withVariables) {
            if (this.contextVariables != null) {
                sb.append(this.getScriptID(null));
                sb.append(StateManager.getVariableList(this.contextVariables, 80));
            }
        } else {
            sb.append(ScriptEvaluator.setErrorLineMessage(this.functionName, this.filename, this.getLinenumber(null), this.pc, this.statementAsString(this.statement, -9999)));
        }
        return sb.toString();
    }

    private int getLinenumber(ScriptContext c) {
        return c == null ? this.lineNumbers[this.pc] : c.lineNumbers[c.pc];
    }

    private String getScriptID(ScriptContext context) {
        String fuName = context == null ? this.functionName : "function " + context.functionName;
        String fiName = context == null ? this.filename : context.filename;
        return "\n# " + fuName + " (file " + fiName + ")\n";
    }

    String getErrorMessage() {
        return this.errorMessage;
    }

    String getErrorMessageUntranslated() {
        return this.errorMessageUntranslated == null ? this.errorMessage : this.errorMessageUntranslated;
    }

    private void setErrorMessage(String err) {
        this.errorMessageUntranslated = null;
        if (err == null) {
            this.error = false;
            this.errorType = null;
            this.errorMessage = null;
            this.iCommandError = -1;
            return;
        }
        this.error = true;
        if (this.errorMessage == null) {
            this.errorMessage = GT._("script ERROR: ");
        }
        this.errorMessage = this.errorMessage + err;
    }

    private void planeExpected() throws ScriptException {
        this.error(38, "{a b c d}", "\"xy\" \"xz\" \"yz\" \"x=...\" \"y=...\" \"z=...\"", "$xxxxx");
    }

    private void integerOutOfRange(int min, int max) throws ScriptException {
        this.error(21, "" + min, "" + max);
    }

    private void numberOutOfRange(float min, float max) throws ScriptException {
        this.error(36, "" + min, "" + max);
    }

    void error(int iError) throws ScriptException {
        this.error(iError, null, null, null, false);
    }

    void error(int iError, String value) throws ScriptException {
        this.error(iError, value, null, null, false);
    }

    void error(int iError, String value, String more) throws ScriptException {
        this.error(iError, value, more, null, false);
    }

    void error(int iError, String value, String more, String more2) throws ScriptException {
        this.error(iError, value, more, more2, false);
    }

    private void warning(int iError, String value, String more) throws ScriptException {
        this.error(iError, value, more, null, true);
    }

    void error(int iError, String value, String more, String more2, boolean warningOnly) throws ScriptException {
        String strUntranslated;
        String strError = this.ignoreError ? null : ScriptEvaluator.errorString(iError, value, more, more2, true);
        String string = strUntranslated = !this.ignoreError && GT.getDoTranslate() ? ScriptEvaluator.errorString(iError, value, more, more2, false) : null;
        if (!warningOnly) {
            this.evalError(strError, strUntranslated);
        }
        this.showString(strError);
    }

    void evalError(String message, String strUntranslated) throws ScriptException {
        if (this.ignoreError) {
            throw new NullPointerException();
        }
        if (!this.isSyntaxCheck) {
            this.viewer.setCursor(0);
            this.viewer.setRefreshing(true);
        }
        throw new ScriptException(message, strUntranslated);
    }

    static String errorString(int iError, String value, String more, String more2, boolean translated) {
        String msg;
        boolean doTranslate = false;
        if (!translated && (doTranslate = GT.getDoTranslate())) {
            GT.setDoTranslate(false);
        }
        switch (iError) {
            default: {
                msg = "Unknown error message number: " + iError;
                break;
            }
            case 0: {
                msg = GT._("x y z axis expected");
                break;
            }
            case 1: {
                msg = GT._("{0} not allowed with background model displayed");
                break;
            }
            case 2: {
                msg = GT._("bad argument count");
                break;
            }
            case 3: {
                msg = GT._("Miller indices cannot all be zero.");
                break;
            }
            case 4: {
                msg = GT._("bad [R,G,B] color");
                break;
            }
            case 5: {
                msg = GT._("boolean expected");
                break;
            }
            case 6: {
                msg = GT._("boolean or number expected");
                break;
            }
            case 7: {
                msg = GT._("boolean, number, or {0} expected");
                break;
            }
            case 8: {
                msg = GT._("color expected");
                break;
            }
            case 9: {
                msg = GT._("a color or palette name (Jmol, Rasmol) is required");
                break;
            }
            case 10: {
                msg = GT._("command expected");
                break;
            }
            case 11: {
                msg = GT._("{x y z} or $name or (atom expression) required");
                break;
            }
            case 12: {
                msg = GT._("draw object not defined");
                break;
            }
            case 13: {
                msg = GT._("unexpected end of script command");
                break;
            }
            case 14: {
                msg = GT._("valid (atom expression) expected");
                break;
            }
            case 15: {
                msg = GT._("(atom expression) or integer expected");
                break;
            }
            case 16: {
                msg = GT._("filename expected");
                break;
            }
            case 17: {
                msg = GT._("file not found");
                break;
            }
            case 18: {
                msg = GT._("incompatible arguments");
                break;
            }
            case 19: {
                msg = GT._("insufficient arguments");
                break;
            }
            case 20: {
                msg = GT._("integer expected");
                break;
            }
            case 21: {
                msg = GT._("integer out of range ({0} - {1})");
                break;
            }
            case 22: {
                msg = GT._("invalid argument");
                break;
            }
            case 23: {
                msg = GT._("invalid parameter order");
                break;
            }
            case 24: {
                msg = GT._("keyword expected");
                break;
            }
            case 25: {
                msg = GT._("no MO coefficient data available");
                break;
            }
            case 26: {
                msg = GT._("An MO index from 1 to {0} is required");
                break;
            }
            case 27: {
                msg = GT._("no MO basis/coefficient data available for this frame");
                break;
            }
            case 28: {
                msg = GT._("no MO occupancy data available");
                break;
            }
            case 29: {
                msg = GT._("Only one molecular orbital is available in this file");
                break;
            }
            case 30: {
                msg = GT._("{0} require that only one model be displayed");
                break;
            }
            case 31: {
                msg = GT._("No data available");
                break;
            }
            case 32: {
                msg = GT._("No partial charges were read from the file; Jmol needs these to render the MEP data.");
                break;
            }
            case 33: {
                msg = GT._("No unit cell");
                break;
            }
            case 34: {
                msg = GT._("number expected");
                break;
            }
            case 35: {
                msg = GT._("number must be ({0} or {1})");
                break;
            }
            case 36: {
                msg = GT._("decimal number out of range ({0} - {1})");
                break;
            }
            case 37: {
                msg = GT._("object name expected after '$'");
                break;
            }
            case 38: {
                msg = GT._("plane expected -- either three points or atom expressions or {0} or {1} or {2}");
                break;
            }
            case 39: {
                msg = GT._("property name expected");
                break;
            }
            case 40: {
                msg = GT._("space group {0} was not found.");
                break;
            }
            case 41: {
                msg = GT._("quoted string expected");
                break;
            }
            case 42: {
                msg = GT._("quoted string or identifier expected");
                break;
            }
            case 43: {
                msg = GT._("too many rotation points were specified");
                break;
            }
            case 44: {
                msg = GT._("too many script levels");
                break;
            }
            case 45: {
                msg = GT._("unrecognized atom property");
                break;
            }
            case 46: {
                msg = GT._("unrecognized bond property");
                break;
            }
            case 47: {
                msg = GT._("unrecognized command");
                break;
            }
            case 48: {
                msg = GT._("runtime unrecognized expression");
                break;
            }
            case 49: {
                msg = GT._("unrecognized object");
                break;
            }
            case 50: {
                msg = GT._("unrecognized {0} parameter");
                break;
            }
            case 51: {
                msg = GT._("unrecognized {0} parameter in Jmol state script (set anyway)");
                break;
            }
            case 52: {
                msg = GT._("unrecognized SHOW parameter --  use {0}");
                break;
            }
            case 53: {
                msg = "{0}";
                break;
            }
            case 54: {
                msg = GT._("write what? {0} or {1} \"filename\"");
            }
        }
        if (msg.indexOf("{0}") < 0) {
            if (value != null) {
                msg = msg + ": " + value;
            }
        } else {
            if ((msg = TextFormat.simpleReplace(msg, "{0}", value)).indexOf("{1}") >= 0) {
                msg = TextFormat.simpleReplace(msg, "{1}", more);
            } else if (more != null) {
                msg = msg + ": " + more;
            }
            if (msg.indexOf("{2}") >= 0) {
                msg = TextFormat.simpleReplace(msg, "{2}", more);
            }
        }
        if (doTranslate) {
            GT.setDoTranslate(true);
        }
        return msg;
    }

    String contextTrace() {
        StringBuffer sb = new StringBuffer();
        while (true) {
            sb.append(ScriptEvaluator.setErrorLineMessage(this.functionName, this.filename, this.getLinenumber(null), this.pc, this.statementAsString(this.statement, this.iToken)));
            if (this.scriptLevel <= 0) break;
            this.popContext();
        }
        return sb.toString();
    }

    static String setErrorLineMessage(String functionName, String filename, int lineCurrent, int pcCurrent, String lineInfo) {
        String err = "\n----";
        if (filename != null || functionName != null) {
            err = err + "line " + lineCurrent + " command " + (pcCurrent + 1) + " of " + (functionName == null ? filename : "function " + functionName) + ":";
        }
        err = err + "\n         " + lineInfo;
        return err;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("Eval\n pc:");
        str.append(this.pc);
        str.append("\n");
        str.append(this.aatoken.length);
        str.append(" statements\n");
        for (int i = 0; i < this.aatoken.length; ++i) {
            str.append("----\n");
            Token[] atoken = this.aatoken[i];
            for (int j = 0; j < atoken.length; ++j) {
                str.append(atoken[j]);
                str.append('\n');
            }
            str.append('\n');
        }
        str.append("END\n");
        return str.toString();
    }

    private String statementAsString(Token[] statement, int iTok) {
        if (statement.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int tok = statement[0].tok;
        switch (tok) {
            case 0: {
                String s = (String)statement[0].value;
                return (s.startsWith("/") ? "/" : "#") + s;
            }
            case 233481: {
                if (statement.length != 2 || statement[1].tok != 135499780) break;
                return ((ScriptFunction)statement[1].value).toString();
            }
        }
        boolean useBraces = true;
        boolean inBrace = false;
        boolean inClauseDefine = false;
        boolean setEquals = tok == 36867 && (String)statement[0].value == "" && statement[0].intValue == 61 && this.tokAt(1) != 0x100001;
        int len = statement.length;
        block30: for (int i = 0; i < len; ++i) {
            Token token = statement[i];
            if (token == null) {
                len = i;
                break;
            }
            if (iTok == i - 1) {
                sb.append(" <<");
            }
            if (i != 0) {
                sb.append(' ');
            }
            if (i == 2 && setEquals) {
                setEquals = false;
                if (token.tok != 269484420) {
                    sb.append("= ");
                }
            }
            if (iTok == i && token.tok != 0x100002) {
                sb.append(">> ");
            }
            switch (token.tok) {
                case 0x100001: {
                    if (!useBraces) continue block30;
                    sb.append("{");
                    continue block30;
                }
                case 0x100002: {
                    if (inClauseDefine && i == this.statementLength - 1) {
                        useBraces = false;
                    }
                    if (!useBraces) continue block30;
                    sb.append("}");
                    continue block30;
                }
                case 0x10100040: 
                case 0x10100041: {
                    break;
                }
                case 0x10000A: 
                case 0x10000E: {
                    inBrace = token.tok == 0x10000A;
                    break;
                }
                case 537931778: {
                    if (i <= 0 || !((String)token.value).equals("define")) break;
                    sb.append("@");
                    if (this.tokAt(i + 1) != 0x100001) continue block30;
                    if (!useBraces) {
                        inClauseDefine = true;
                    }
                    useBraces = true;
                    continue block30;
                }
                case 0x10000D: {
                    sb.append("true");
                    continue block30;
                }
                case 0x10000C: {
                    sb.append("false");
                    continue block30;
                }
                case 135280129: {
                    break;
                }
                case 2: {
                    sb.append(token.intValue);
                    continue block30;
                }
                case 7: 
                case 8: 
                case 0x40000007: {
                    sb.append(ScriptVariable.sValue(token));
                    continue block30;
                }
                case 5: {
                    sb.append('^');
                    continue block30;
                }
                case 1048615: {
                    if (token.intValue != Integer.MAX_VALUE) {
                        sb.append(token.intValue);
                    } else {
                        sb.append(Group.getSeqcodeString(ScriptEvaluator.getSeqCode(token)));
                    }
                    token = statement[++i];
                    sb.append(' ');
                    sb.append(inBrace ? "-" : "- ");
                }
                case 1048614: {
                    if (token.intValue != Integer.MAX_VALUE) {
                        sb.append(token.intValue);
                        continue block30;
                    }
                    sb.append(Group.getSeqcodeString(ScriptEvaluator.getSeqCode(token)));
                    continue block30;
                }
                case 0x100021: {
                    sb.append("*:");
                    sb.append((char)token.intValue);
                    continue block30;
                }
                case 0x10001F: {
                    sb.append("*%");
                    if (token.value == null) continue block30;
                    sb.append(token.value.toString());
                    continue block30;
                }
                case 0x100022: {
                    sb.append("*/");
                }
                case 3: 
                case 1048611: {
                    if (token.intValue < Integer.MAX_VALUE) {
                        sb.append(Escape.escapeModelFileNumber(token.intValue));
                        continue block30;
                    }
                    sb.append("" + token.value);
                    continue block30;
                }
                case 1048613: {
                    sb.append('[');
                    sb.append(Group.getGroup3((short)token.intValue));
                    sb.append(']');
                    continue block30;
                }
                case 1048612: {
                    sb.append('[');
                    sb.append(token.value);
                    sb.append(']');
                    continue block30;
                }
                case 0x100020: {
                    sb.append("*.");
                    break;
                }
                case 0x1500005: {
                    if (!(token.value instanceof Point3f)) break;
                    Point3f pt = (Point3f)token.value;
                    sb.append("cell={").append(pt.x).append(" ").append(pt.y).append(" ").append(pt.z).append("}");
                    continue block30;
                }
                case 4: {
                    sb.append("\"").append(token.value).append("\"");
                    continue block30;
                }
                case 0x10100180: 
                case 0x10100181: 
                case 269484418: 
                case 269484419: 
                case 269484420: 
                case 269484421: {
                    if (token.intValue == 642777357) {
                        sb.append((String)statement[++i].value).append(" ");
                        break;
                    }
                    if (token.intValue == Integer.MAX_VALUE) break;
                    sb.append(Token.nameOf(token.intValue)).append(" ");
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    if (!this.logMessages) break;
                    sb.append('\n').append(token.toString()).append('\n');
                    continue block30;
                }
            }
            if (token.value == null) continue;
            sb.append(token.value.toString());
        }
        if (iTok >= len - 1) {
            sb.append(" <<");
        }
        return sb.toString();
    }

    private void setShapeProperty(int shapeType, String propertyName, Object propertyValue) {
        if (!this.isSyntaxCheck) {
            this.viewer.setShapeProperty(shapeType, propertyName, propertyValue);
        }
    }

    private void setShapeSize(int shapeType, int size) {
        this.setShapeSize(shapeType, size, Float.NaN);
    }

    private void setShapeSize(int shapeType, int size, float fsize) {
        if (!this.isSyntaxCheck) {
            this.viewer.setShapeSize(shapeType, size, fsize);
        }
    }

    private void setBooleanProperty(String key, boolean value) {
        if (!this.isSyntaxCheck) {
            this.viewer.setBooleanProperty(key, value);
        }
    }

    private boolean setIntProperty(String key, int value) {
        if (!this.isSyntaxCheck) {
            this.viewer.setIntProperty(key, value);
        }
        return true;
    }

    private boolean setFloatProperty(String key, float value) {
        if (!this.isSyntaxCheck) {
            this.viewer.setFloatProperty(key, value);
        }
        return true;
    }

    private void setStringProperty(String key, String value) {
        if (!this.isSyntaxCheck) {
            this.viewer.setStringProperty(key, value);
        }
    }

    private void showString(String str) {
        if (this.isSyntaxCheck) {
            return;
        }
        if (this.outputBuffer != null) {
            this.outputBuffer.append(str).append('\n');
        } else {
            this.viewer.showString(str, false);
        }
    }

    private void scriptStatusOrBuffer(String s) {
        if (this.outputBuffer != null) {
            this.outputBuffer.append(s).append('\n');
            return;
        }
        this.viewer.scriptStatus(s);
    }

    private BitSet expression(int index) throws ScriptException {
        if (!this.checkToken(index)) {
            this.error(2);
        }
        return this.expression(this.statement, index, 0, true, false, true, true);
    }

    private BitSet expression(Token[] code, int pcStart, int pcStop, boolean allowRefresh, boolean allowUnderflow, boolean mustBeBitSet, boolean andNotDeleted) throws ScriptException {
        this.isBondSet = false;
        if (code != this.statement) {
            this.tempStatement = this.statement;
            this.statement = code;
        }
        ScriptMathProcessor rpn = new ScriptMathProcessor(this, false, false);
        int comparisonValue = Integer.MAX_VALUE;
        boolean refreshed = false;
        this.iToken = 1000;
        boolean ignoreSubset = pcStart < 0;
        boolean isInMath = false;
        int nExpress = 0;
        int atomCount = this.viewer.getAtomCount();
        if (ignoreSubset) {
            pcStart = -pcStart;
        }
        ignoreSubset |= this.isSyntaxCheck;
        if (pcStop == 0 && code.length > pcStart) {
            pcStop = pcStart + 1;
        }
        block34: for (int pc = pcStart; pc < pcStop; ++pc) {
            this.iToken = pc;
            Token instruction = code[pc];
            if (instruction == null) break;
            Object value = instruction.value;
            switch (instruction.tok) {
                case 0x100001: {
                    pcStart = pc;
                    pcStop = code.length;
                    ++nExpress;
                    continue block34;
                }
                case 0x100002: {
                    if (--nExpress <= 0) break block34;
                    continue block34;
                }
                case 0x10000A: {
                    Point3f pt;
                    if (!this.isPoint3f(pc) || (pt = this.getPoint3f(pc, true)) == null) continue block34;
                    rpn.addX(pt);
                    pc = this.iToken;
                    continue block34;
                }
                case 0x10000E: {
                    continue block34;
                }
                case 0x10100040: {
                    isInMath = true;
                    rpn.addOp(instruction);
                    continue block34;
                }
                case 0x10100041: {
                    isInMath = false;
                    rpn.addOp(instruction);
                    continue block34;
                }
                case 1: {
                    Object val = this.getParameter((String)value, false);
                    if (val instanceof String) {
                        val = this.getStringObjectAsVariable((String)val, null);
                    }
                    if (val instanceof String) {
                        val = this.lookupIdentifierValue((String)value);
                    }
                    rpn.addX(val);
                    continue block34;
                }
                case 537931778: {
                    rpn.addX(ScriptEvaluator.getAtomBitSet(this, (String)value));
                    continue block34;
                }
                case 135268355: {
                    rpn.addX(new ScriptVariable(instruction));
                    rpn.addX(new ScriptVariable(8, this.planeParameter(pc + 2)));
                    pc = this.iToken;
                    continue block34;
                }
                case 0x100006: {
                    rpn.addX(new ScriptVariable(instruction));
                    rpn.addX(this.getPoint3f(pc + 2, true));
                    pc = this.iToken;
                    continue block34;
                }
                case 4: {
                    rpn.addX(new ScriptVariable(instruction));
                    if (!((String)value).equals("hkl")) continue block34;
                    rpn.addX(new ScriptVariable(8, this.hklParameter(pc + 2)));
                    pc = this.iToken;
                    continue block34;
                }
                case 135266818: 
                case 135268865: 
                case 135268866: 
                case 0x10100030: {
                    rpn.addOp(instruction);
                    continue block34;
                }
                case 0x100003: {
                    rpn.addX(this.viewer.getModelAtomBitSet(-1, true));
                    continue block34;
                }
                case 0x10000B: {
                    rpn.addX(new BitSet());
                    continue block34;
                }
                case 0x10000C: 
                case 0x10000D: {
                    rpn.addX(new ScriptVariable(instruction));
                    continue block34;
                }
                case 0x30000A: {
                    rpn.addX(BitSetUtil.copy(this.viewer.getSelectionSet()));
                    continue block34;
                }
                case 0x303007: {
                    BitSet bsSubset = this.viewer.getSelectionSubset();
                    rpn.addX(bsSubset == null ? this.viewer.getModelAtomBitSet(-1, true) : BitSetUtil.copy(bsSubset));
                    continue block34;
                }
                case 3145752: {
                    rpn.addX(BitSetUtil.copy(this.viewer.getHiddenSet()));
                    continue block34;
                }
                case 3145751: {
                    rpn.addX(BitSetUtil.copyInvert(this.viewer.getHiddenSet(), atomCount));
                    continue block34;
                }
                case 3145755: {
                    if (!this.isSyntaxCheck && !refreshed) {
                        this.viewer.setModelVisibility();
                    }
                    refreshed = true;
                    rpn.addX(this.viewer.getVisibleSet());
                    continue block34;
                }
                case 3145750: {
                    if (!this.isSyntaxCheck && allowRefresh) {
                        this.refresh();
                    }
                    rpn.addX(this.viewer.getClickableSet());
                    continue block34;
                }
                case 0x100009: 
                case 0x10001F: 
                case 0x100020: 
                case 1048612: 
                case 0x300002: 
                case 0x300005: 
                case 0x300006: 
                case 0x300007: 
                case 0x300008: 
                case 0x300009: 
                case 3145749: 
                case 3145753: 
                case 0xF0000C: 
                case 0x20300003: 
                case 540545088: {
                    rpn.addX(this.getAtomBits(instruction.tok, (String)value));
                    continue block34;
                }
                case 0x100022: 
                case 1048611: {
                    int iModel = instruction.intValue;
                    if (iModel == Integer.MAX_VALUE && value instanceof Integer) {
                        iModel = (Integer)value;
                        if (!this.viewer.haveFileSet()) {
                            rpn.addX(this.getAtomBits(0x100022, new Integer(iModel)));
                            continue block34;
                        }
                        iModel = iModel < 1000 ? (iModel *= 1000000) : iModel / 1000 * 1000000 + iModel % 1000;
                    }
                    rpn.addX(this.bitSetForModelFileNumber(iModel));
                    continue block34;
                }
                case 0x100021: 
                case 1048613: {
                    rpn.addX(this.getAtomBits(instruction.tok, new Integer(instruction.intValue)));
                    continue block34;
                }
                case 1048614: {
                    if (isInMath) {
                        rpn.addXNum(ScriptVariable.intVariable(instruction.intValue));
                        continue block34;
                    }
                    rpn.addX(this.getAtomBits(1048614, new Integer(ScriptEvaluator.getSeqCode(instruction))));
                    continue block34;
                }
                case 1048615: {
                    if (isInMath) {
                        rpn.addXNum(ScriptVariable.intVariable(instruction.intValue));
                        rpn.addX(Token.tokenMinus);
                        rpn.addXNum(ScriptVariable.intVariable(code[++pc].intValue));
                        continue block34;
                    }
                    int chainID = pc + 3 < code.length && code[pc + 2].tok == 0x10100060 && code[pc + 3].tok == 0x100021 ? code[pc + 3].intValue : 9;
                    rpn.addX(this.getAtomBits(1048615, new int[]{ScriptEvaluator.getSeqCode(instruction), ScriptEvaluator.getSeqCode(code[++pc]), chainID}));
                    if (chainID == 9) continue block34;
                    pc += 2;
                    continue block34;
                }
                case 0x1500005: {
                    Point3f pt = (Point3f)value;
                    rpn.addX(this.getAtomBits(0x1500005, new int[]{(int)(pt.x * 1000.0f), (int)(pt.y * 1000.0f), (int)(pt.z * 1000.0f)}));
                    continue block34;
                }
                case 0x30000E: {
                    rpn.addX(this.viewer.getModelAtomBitSet(this.viewer.getCurrentModelIndex(), true));
                    continue block34;
                }
                case 0x300001: 
                case 0x30000C: 
                case 0x30000D: 
                case 3674115: 
                case 137364482: 
                case 540016644: 
                case 540016651: {
                    rpn.addX(this.lookupIdentifierValue((String)value));
                    continue block34;
                }
                case 0x10100180: 
                case 0x10100181: 
                case 269484418: 
                case 269484419: 
                case 269484420: 
                case 269484421: {
                    float[] data;
                    boolean isStringProperty;
                    String property;
                    Object val = code[++pc].value;
                    int tokOperator = instruction.tok;
                    int tokWhat = instruction.intValue;
                    String string = property = tokWhat == 642777357 ? (String)val : null;
                    if (property != null) {
                        val = code[++pc].value;
                    }
                    if (this.isSyntaxCheck) {
                        rpn.addX(new BitSet());
                        continue block34;
                    }
                    boolean isModel = tokWhat == 22024203;
                    boolean isIntProperty = Token.tokAttr(tokWhat, 0x1500000);
                    boolean isFloatProperty = Token.tokAttr(tokWhat, 0x2500000);
                    boolean isIntOrFloat = isIntProperty && isFloatProperty;
                    boolean bl = isStringProperty = !isIntProperty && Token.tokAttr(tokWhat, 0xD00000);
                    if (tokWhat == 13631749) {
                        isStringProperty = false;
                        isIntProperty = !false;
                    }
                    int tokValue = code[pc].tok;
                    comparisonValue = code[pc].intValue;
                    float comparisonFloat = Float.NaN;
                    if (val instanceof String) {
                        if (tokWhat == 558895366) {
                            comparisonValue = Graphics3D.getArgbFromString((String)val);
                            if (comparisonValue == 0 && tokValue == 1) {
                                val = this.getStringParameter((String)val, true);
                                comparisonValue = Graphics3D.getArgbFromString((String)val);
                            }
                            tokValue = 2;
                            isIntProperty = true;
                        } else if (isStringProperty) {
                            if (tokValue == 1) {
                                val = this.getStringParameter((String)val, true);
                            }
                        } else {
                            if (tokValue == 1) {
                                val = this.getNumericParameter((String)val);
                            }
                            if (val instanceof String) {
                                if (tokWhat == 30412803 || tokWhat == 13631749) {
                                    isIntProperty = comparisonValue != Integer.MAX_VALUE;
                                    isStringProperty = !isIntProperty;
                                } else {
                                    val = ScriptVariable.nValue(code[pc]);
                                }
                            }
                            if (val instanceof Integer) {
                                comparisonValue = (Integer)val;
                                comparisonFloat = comparisonValue;
                            } else if (val instanceof Float && isModel) {
                                comparisonValue = ModelCollection.modelFileNumberFromFloat(((Float)val).floatValue());
                            }
                        }
                    }
                    if (isStringProperty && !(val instanceof String)) {
                        val = "" + val;
                    }
                    if (val instanceof Integer || tokValue == 2) {
                        if (isModel) {
                            if (comparisonValue >= 1000000) {
                                tokWhat = -22024203;
                            }
                        } else if (isIntOrFloat) {
                            isFloatProperty = false;
                        } else if (isFloatProperty) {
                            comparisonFloat = comparisonValue;
                        }
                    } else if (val instanceof Float) {
                        if (isModel) {
                            tokWhat = -22024203;
                        } else {
                            comparisonFloat = ((Float)val).floatValue();
                            if (isIntOrFloat) {
                                isIntProperty = false;
                            } else if (isIntProperty) {
                                comparisonValue = (int)comparisonFloat;
                            }
                        }
                    } else if (!isStringProperty) {
                        ++this.iToken;
                        this.error(22);
                    }
                    if (isModel && comparisonValue >= 1000000 && comparisonValue % 1000000 == 0) {
                        comparisonValue /= 1000000;
                        tokWhat = 156242439;
                        isModel = false;
                    }
                    if (tokWhat == -22024203 && tokOperator == 269484420) {
                        rpn.addX(this.bitSetForModelFileNumber(comparisonValue));
                        continue block34;
                    }
                    if (value != null && ((String)value).indexOf("-") >= 0) {
                        if (isIntProperty) {
                            comparisonValue = -comparisonValue;
                        } else if (!Float.isNaN(comparisonFloat)) {
                            comparisonFloat = -comparisonFloat;
                        }
                    }
                    float[] fArray = data = tokWhat == 642777357 ? this.viewer.getDataFloat(property) : null;
                    rpn.addX(isIntProperty ? this.compareInt(tokWhat, data, tokOperator, comparisonValue) : (isStringProperty ? this.compareString(tokWhat, tokOperator, (String)val) : this.compareFloat(tokWhat, data, tokOperator, comparisonFloat)));
                    continue block34;
                }
                case 7: 
                case 8: 
                case 0x40000007: {
                    rpn.addX(value);
                    continue block34;
                }
                case 2: 
                case 3: {
                    rpn.addXNum(new ScriptVariable(instruction));
                    continue block34;
                }
                default: {
                    if (Token.tokAttr(instruction.tok, 0x10100000)) {
                        rpn.addOp(instruction);
                        continue block34;
                    }
                    this.error(48);
                }
            }
        }
        this.expressionResult = rpn.getResult(allowUnderflow, null);
        if (this.expressionResult == null) {
            if (allowUnderflow) {
                return null;
            }
            if (!this.isSyntaxCheck) {
                rpn.dumpStacks("after getResult");
            }
            this.error(13);
        }
        this.expressionResult = ((ScriptVariable)this.expressionResult).value;
        if (this.expressionResult instanceof String && (mustBeBitSet || ((String)this.expressionResult).startsWith("({"))) {
            Object object = this.expressionResult = this.isSyntaxCheck ? new BitSet() : ScriptEvaluator.getAtomBitSet(this, (String)this.expressionResult);
        }
        if (!mustBeBitSet && !(this.expressionResult instanceof BitSet)) {
            return null;
        }
        BitSet bs = this.expressionResult instanceof BitSet ? (BitSet)this.expressionResult : new BitSet();
        this.isBondSet = this.expressionResult instanceof Bond.BondSet;
        BitSet bsDeleted = this.viewer.getDeletedAtoms();
        if (!this.isBondSet && bsDeleted != null) {
            BitSetUtil.andNot(bs, bsDeleted);
        }
        BitSet bsSubset = this.viewer.getSelectionSubset();
        if (!ignoreSubset && bsSubset != null && !this.isBondSet) {
            bs.and(bsSubset);
        }
        if (this.tempStatement != null) {
            this.statement = this.tempStatement;
            this.tempStatement = null;
        }
        return bs;
    }

    private BitSet compareFloat(int tokWhat, float[] data, int tokOperator, float comparisonFloat) {
        BitSet bs = new BitSet();
        int atomCount = this.viewer.getAtomCount();
        ModelSet modelSet = this.viewer.getModelSet();
        Atom[] atoms = modelSet.atoms;
        float propertyFloat = 0.0f;
        this.viewer.autoCalculate(tokWhat);
        block3: for (int i = 0; i < atomCount; ++i) {
            boolean match = false;
            Atom atom = atoms[i];
            switch (tokWhat) {
                default: {
                    propertyFloat = Atom.atomPropertyFloat(atom, tokWhat);
                    break;
                }
                case 642777357: {
                    if (data == null || data.length <= i) continue block3;
                    propertyFloat = data[i];
                }
            }
            match = ScriptEvaluator.compareFloat(tokOperator, propertyFloat, comparisonFloat);
            if (!match) continue;
            bs.set(i);
        }
        return bs;
    }

    private BitSet compareString(int tokWhat, int tokOperator, String comparisonString) throws ScriptException {
        boolean isCaseSensitive;
        BitSet bs = new BitSet();
        Atom[] atoms = this.viewer.getModelSet().atoms;
        int atomCount = this.viewer.getAtomCount();
        boolean bl = isCaseSensitive = tokWhat == 0xD00004 && this.viewer.getChainCaseSensitive();
        if (!isCaseSensitive) {
            comparisonString = comparisonString.toLowerCase();
        }
        for (int i = 0; i < atomCount; ++i) {
            String propertyString = Atom.atomPropertyString(atoms[i], tokWhat);
            if (!isCaseSensitive) {
                propertyString = propertyString.toLowerCase();
            }
            if (!this.compareString(tokOperator, propertyString, comparisonString)) continue;
            bs.set(i);
        }
        return bs;
    }

    protected BitSet compareInt(int tokWhat, float[] data, int tokOperator, int comparisonValue) {
        BitSet bs = new BitSet();
        int propertyValue = Integer.MAX_VALUE;
        BitSet propertyBitSet = null;
        int bitsetComparator = tokOperator;
        int bitsetBaseValue = comparisonValue;
        int atomCount = this.viewer.getAtomCount();
        ModelSet modelSet = this.viewer.getModelSet();
        Atom[] atoms = modelSet.atoms;
        int imax = -1;
        int imin = 0;
        int iModel = -1;
        int[] cellRange = null;
        int nOps = 0;
        block11: for (int i = 0; i < atomCount; ++i) {
            boolean match = false;
            Atom atom = atoms[i];
            switch (tokWhat) {
                default: {
                    propertyValue = Atom.atomPropertyInt(atom, tokWhat);
                    break;
                }
                case 22020115: {
                    propertyBitSet = atom.getAtomSymmetry();
                    if (atom.getModelIndex() != iModel) {
                        iModel = atom.getModelIndex();
                        cellRange = modelSet.getModelCellRange(iModel);
                        imax = nOps = modelSet.getModelSymmetryCount(iModel);
                    }
                    if (bitsetBaseValue >= 200) {
                        if (cellRange == null) continue block11;
                        comparisonValue = bitsetBaseValue % 1000;
                        int symop = bitsetBaseValue / 1000 - 1;
                        if (symop < 0) {
                            match = true;
                        } else if (nOps == 0 || symop >= 0 && !(match = propertyBitSet.get(symop))) continue block11;
                        bitsetComparator = 0x10000B;
                        propertyValue = symop < 0 ? atom.getCellTranslation(comparisonValue, cellRange, nOps) : atom.getSymmetryTranslation(symop, cellRange, nOps);
                    } else if (nOps > 0) {
                        if (comparisonValue > nOps && bitsetComparator != 269484419 && bitsetComparator != 269484418) continue block11;
                        if (bitsetComparator == 269484421) {
                            if (comparisonValue <= 0 || comparisonValue > nOps || propertyBitSet.get(comparisonValue)) continue block11;
                            bs.set(i);
                            continue block11;
                        }
                    }
                    switch (bitsetComparator) {
                        case 269484419: {
                            imax = comparisonValue - 1;
                            imin = 0;
                            break;
                        }
                        case 269484418: {
                            imax = comparisonValue;
                            imin = 0;
                            break;
                        }
                        case 0x10100181: {
                            if (imax < 0) {
                                imax = propertyBitSet.size();
                            }
                            imin = comparisonValue - 1;
                            break;
                        }
                        case 0x10100180: {
                            if (imax < 0) {
                                imax = propertyBitSet.size();
                            }
                            imin = comparisonValue;
                            break;
                        }
                        case 269484420: {
                            imax = comparisonValue;
                            imin = comparisonValue - 1;
                            break;
                        }
                        case 269484421: {
                            boolean bl = match = !propertyBitSet.get(comparisonValue);
                        }
                    }
                    if (imin < 0) {
                        imin = 0;
                    }
                    if (imax > propertyBitSet.size()) {
                        imax = propertyBitSet.size();
                    }
                    for (int iBit = imin; iBit < imax; ++iBit) {
                        if (!propertyBitSet.get(iBit)) continue;
                        match = true;
                        break;
                    }
                    if (match && propertyValue != Integer.MAX_VALUE) break;
                    tokOperator = 0x10000B;
                }
            }
            if (tokOperator != 0x10000B) {
                match = ScriptEvaluator.compareInt(tokOperator, propertyValue, comparisonValue);
            }
            if (!match) continue;
            bs.set(i);
        }
        return bs;
    }

    private boolean compareString(int tokOperator, String propertyValue, String comparisonValue) throws ScriptException {
        switch (tokOperator) {
            case 269484420: 
            case 269484421: {
                return TextFormat.isMatch(propertyValue, comparisonValue, true, true) == (tokOperator == 269484420);
            }
        }
        this.error(22);
        return false;
    }

    private static boolean compareInt(int tokOperator, int propertyValue, int comparisonValue) {
        switch (tokOperator) {
            case 269484419: {
                return propertyValue < comparisonValue;
            }
            case 269484418: {
                return propertyValue <= comparisonValue;
            }
            case 0x10100181: {
                return propertyValue >= comparisonValue;
            }
            case 0x10100180: {
                return propertyValue > comparisonValue;
            }
            case 269484420: {
                return propertyValue == comparisonValue;
            }
            case 269484421: {
                return propertyValue != comparisonValue;
            }
        }
        return false;
    }

    private static boolean compareFloat(int tokOperator, float propertyFloat, float comparisonFloat) {
        switch (tokOperator) {
            case 269484419: {
                return propertyFloat < comparisonFloat;
            }
            case 269484418: {
                return propertyFloat <= comparisonFloat;
            }
            case 0x10100181: {
                return propertyFloat >= comparisonFloat;
            }
            case 0x10100180: {
                return propertyFloat > comparisonFloat;
            }
            case 269484420: {
                return propertyFloat == comparisonFloat;
            }
            case 269484421: {
                return propertyFloat != comparisonFloat;
            }
        }
        return false;
    }

    private BitSet getAtomBits(int tokType, Object specInfo) {
        return this.isSyntaxCheck ? new BitSet() : this.viewer.getAtomBits(tokType, specInfo);
    }

    private static int getSeqCode(Token instruction) {
        return instruction.intValue != Integer.MAX_VALUE ? Group.getSeqcode(instruction.intValue, ' ') : (Integer)instruction.value;
    }

    private void checkLength(int length) throws ScriptException {
        if (length >= 0) {
            this.checkLength(length, 0);
            return;
        }
        if (this.statementLength <= -length) {
            return;
        }
        this.iToken = -length;
        this.error(2);
    }

    private void checkLength(int length, int errorPt) throws ScriptException {
        if (this.statementLength == length) {
            return;
        }
        this.iToken = errorPt > 0 ? errorPt : this.statementLength;
        this.error(errorPt > 0 ? 22 : 2);
    }

    private int checkLength23() throws ScriptException {
        this.iToken = this.statementLength;
        if (this.statementLength < 2 || this.statementLength > 3) {
            this.error(2);
        }
        return this.statementLength;
    }

    private void checkLength34() throws ScriptException {
        this.iToken = this.statementLength;
        if (this.statementLength < 3 || this.statementLength > 4) {
            this.error(2);
        }
    }

    private Token getToken(int i) throws ScriptException {
        if (!this.checkToken(i)) {
            this.error(13);
        }
        this.theToken = this.statement[i];
        this.theTok = this.theToken.tok;
        return this.theToken;
    }

    private int tokAt(int i) {
        return i < this.statementLength ? this.statement[i].tok : 0;
    }

    private int tokAt(int i, Token[] args) {
        return i < args.length ? args[i].tok : 0;
    }

    private Token tokenAt(int i, Token[] args) {
        return i < args.length ? args[i] : null;
    }

    private boolean checkToken(int i) {
        this.iToken = i;
        return this.iToken < this.statementLength;
    }

    private int modelNumberParameter(int index) throws ScriptException {
        int iFrame = 0;
        boolean useModelNumber = false;
        switch (this.tokAt(index)) {
            case 2: {
                useModelNumber = true;
            }
            case 3: {
                iFrame = this.getToken((int)index).intValue;
                break;
            }
            default: {
                this.error(22);
            }
        }
        return this.viewer.getModelNumberIndex(iFrame, useModelNumber, true);
    }

    private String optParameterAsString(int i) throws ScriptException {
        if (i >= this.statementLength) {
            return "";
        }
        return this.parameterAsString(i);
    }

    private String parameterAsString(int i) throws ScriptException {
        this.getToken(i);
        if (this.theToken == null) {
            this.error(13);
        }
        return this.theTok == 2 ? "" + this.theToken.intValue : "" + this.theToken.value;
    }

    private int intParameter(int index) throws ScriptException {
        if (this.checkToken(index) && this.getToken((int)index).tok == 2) {
            return this.theToken.intValue;
        }
        this.error(20);
        return 0;
    }

    private int intParameter(int i, int min, int max) throws ScriptException {
        int val = this.intParameter(i);
        if (val < min || val > max) {
            this.integerOutOfRange(min, max);
        }
        return val;
    }

    private boolean isFloatParameter(int index) {
        switch (this.tokAt(index)) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    private float floatParameter(int i, float min, float max) throws ScriptException {
        float val = this.floatParameter(i);
        if (val < min || val > max) {
            this.numberOutOfRange(min, max);
        }
        return val;
    }

    private float floatParameter(int index) throws ScriptException {
        if (this.checkToken(index)) {
            this.getToken(index);
            switch (this.theTok) {
                case 2: 
                case 1048614: {
                    return this.theToken.intValue;
                }
                case 3: 
                case 1048611: {
                    return ((Float)this.theToken.value).floatValue();
                }
            }
        }
        this.error(34);
        return 0.0f;
    }

    private int floatParameterSet(int i, float[] fparams) throws ScriptException {
        if (this.tokAt(i) == 0x10000A) {
            ++i;
        }
        for (int j = 0; j < fparams.length; ++j) {
            fparams[j] = this.floatParameter(i++);
        }
        if (this.tokAt(i) == 0x10000E) {
            ++i;
        }
        return i;
    }

    private String stringParameter(int index) throws ScriptException {
        if (!this.checkToken(index) || this.getToken((int)index).tok != 4) {
            this.error(41);
        }
        return (String)this.theToken.value;
    }

    private String objectNameParameter(int index) throws ScriptException {
        if (!this.checkToken(index)) {
            this.error(37);
        }
        return this.parameterAsString(index);
    }

    private float radiusParameter(int index, float defaultValue) throws ScriptException {
        boolean isOffset;
        if (!this.checkToken(index)) {
            if (Float.isNaN(defaultValue)) {
                this.error(34);
            }
            return defaultValue;
        }
        this.getToken(index);
        float v = Float.NaN;
        boolean bl = isOffset = this.theTok == 0x10100091;
        if (isOffset) {
            ++index;
        }
        boolean isPercent = this.tokAt(index + 1) == 269484194;
        switch (this.tokAt(index)) {
            case 2: {
                v = this.intParameter(index);
            }
            case 3: {
                if (Float.isNaN(v)) {
                    v = this.floatParameter(index);
                }
                if (!(v < 0.0f)) break;
                isOffset = true;
                break;
            }
            default: {
                v = defaultValue;
                --index;
            }
        }
        this.iToken = index + (isPercent ? 1 : 0);
        if (Float.isNaN(v)) {
            this.error(34);
        }
        if (v == 0.0f) {
            return 0.0f;
        }
        if (isPercent) {
            if (v <= -100.0f) {
                this.error(22);
            }
            v += (float)(isOffset ? 200 : 100);
        } else if (!isOffset) {
            if (v < 0.0f || v > 10.0f) {
                this.numberOutOfRange(0.0f, 10.0f);
            }
            v += 10.0f;
        }
        return v;
    }

    private boolean booleanParameter(int i) throws ScriptException {
        if (this.statementLength == i) {
            return true;
        }
        this.checkLength(i + 1);
        switch (this.getToken((int)i).tok) {
            case 0x10000D: {
                return true;
            }
            case 0x10000C: {
                return false;
            }
        }
        this.error(5);
        return false;
    }

    private Point3f atomCenterOrCoordinateParameter(int i) throws ScriptException {
        switch (this.getToken((int)i).tok) {
            case 0x100001: 
            case 0x40000007: {
                BitSet bs = this.expression(this.statement, i, 0, true, false, false, true);
                if (bs != null) {
                    return this.viewer.getAtomSetCenter(bs);
                }
                if (this.expressionResult instanceof Point3f) {
                    return (Point3f)this.expressionResult;
                }
                this.error(22);
                break;
            }
            case 7: 
            case 0x10000A: {
                return this.getPoint3f(i, true);
            }
        }
        this.error(22);
        return null;
    }

    private boolean isCenterParameter(int i) {
        int tok = this.tokAt(i);
        return tok == 0x100007 || tok == 0x10000A || tok == 0x100001 || tok == 7 || tok == 0x40000007;
    }

    private Point3f centerParameter(int i) throws ScriptException {
        Point3f center = null;
        if (this.checkToken(i)) {
            switch (this.getToken((int)i).tok) {
                case 0x100007: {
                    int index = Integer.MIN_VALUE;
                    String id = this.objectNameParameter(++i);
                    if (this.tokAt(i + 1) == 0x10100040) {
                        index = this.intParameter(i + 2);
                        if (this.getToken((int)(i + 3)).tok != 0x10100041) {
                            this.error(22);
                        }
                    }
                    if (this.isSyntaxCheck) {
                        return new Point3f();
                    }
                    center = this.getObjectCenter(id, index);
                    if (center != null) break;
                    this.error(12, id);
                    break;
                }
                case 7: 
                case 0x100001: 
                case 0x10000A: 
                case 0x40000007: {
                    center = this.atomCenterOrCoordinateParameter(i);
                }
            }
        }
        if (center == null) {
            this.error(11);
        }
        return center;
    }

    private Point4f planeParameter(int i) throws ScriptException {
        block26: {
            Vector3f vAB = new Vector3f();
            Vector3f vAC = new Vector3f();
            if (i >= this.statementLength) break block26;
            switch (this.getToken((int)i).tok) {
                case 8: {
                    return (Point4f)this.theToken.value;
                }
                case 0x100007: {
                    String id = this.objectNameParameter(++i);
                    if (this.isSyntaxCheck) {
                        return new Point4f();
                    }
                    int shapeType = this.viewer.getShapeIdFromObjectName(id);
                    switch (shapeType) {
                        case 21: {
                            this.setShapeProperty(21, "thisID", id);
                            Point3f[] points = (Point3f[])this.viewer.getShapeProperty(21, "vertices");
                            if (points != null) {
                                if (points.length < 3) break;
                                Vector3f pv = new Vector3f();
                                float w = Graphics3D.getNormalThroughPoints(points[0], points[1], points[2], pv, vAB, vAC);
                                return new Point4f(pv.x, pv.y, pv.z, w);
                            }
                            break block26;
                        }
                        case 22: {
                            this.setShapeProperty(22, "thisID", id);
                            Point4f plane = (Point4f)this.viewer.getShapeProperty(22, "plane");
                            if (plane != null) {
                                return plane;
                            } else {
                                break;
                            }
                        }
                    }
                    break;
                }
                case 1: 
                case 4: {
                    String str = this.parameterAsString(i);
                    if (str.equalsIgnoreCase("xy")) {
                        return new Point4f(0.0f, 0.0f, 1.0f, 0.0f);
                    }
                    if (str.equalsIgnoreCase("xz")) {
                        return new Point4f(0.0f, 1.0f, 0.0f, 0.0f);
                    }
                    if (str.equalsIgnoreCase("yz")) {
                        return new Point4f(1.0f, 0.0f, 0.0f, 0.0f);
                    }
                    this.iToken += 2;
                    if (str.equalsIgnoreCase("x")) {
                        if (!this.checkToken(++i) || this.getToken((int)i++).tok != 269484420) {
                            this.evalError("x=?", null);
                        }
                        return new Point4f(1.0f, 0.0f, 0.0f, -this.floatParameter(i));
                    }
                    if (str.equalsIgnoreCase("y")) {
                        if (!this.checkToken(++i) || this.getToken((int)i++).tok != 269484420) {
                            this.evalError("y=?", null);
                        }
                        return new Point4f(0.0f, 1.0f, 0.0f, -this.floatParameter(i));
                    }
                    if (!str.equalsIgnoreCase("z")) break;
                    if (!this.checkToken(++i) || this.getToken((int)i++).tok != 269484420) {
                        this.evalError("z=?", null);
                    }
                    return new Point4f(0.0f, 0.0f, 1.0f, -this.floatParameter(i));
                }
                case 0x10000A: {
                    if (!this.isPoint3f(i)) {
                        return this.getPoint4f(i);
                    }
                }
                case 0x100001: 
                case 0x40000007: {
                    Point3f pt1 = this.atomCenterOrCoordinateParameter(i);
                    if (this.getToken((int)(++this.iToken)).tok == 0x10100030) {
                        ++this.iToken;
                    }
                    Point3f pt2 = this.atomCenterOrCoordinateParameter(this.iToken);
                    if (this.getToken((int)(++this.iToken)).tok == 0x10100030) {
                        ++this.iToken;
                    }
                    Point3f pt3 = this.atomCenterOrCoordinateParameter(this.iToken);
                    i = this.iToken;
                    Vector3f plane = new Vector3f();
                    float w = Graphics3D.getNormalThroughPoints(pt1, pt2, pt3, plane, vAB, vAC);
                    Point4f p = new Point4f(plane.x, plane.y, plane.z, w);
                    if (!this.isSyntaxCheck && Logger.debugging) {
                        Logger.debug("points: " + pt1 + pt2 + pt3 + " defined plane: " + p);
                    }
                    return p;
                }
            }
        }
        this.planeExpected();
        return null;
    }

    private Point4f hklParameter(int i) throws ScriptException {
        if (!this.isSyntaxCheck && this.viewer.getCurrentUnitCell() == null) {
            this.error(33);
        }
        Vector3f vAB = new Vector3f();
        Vector3f vAC = new Vector3f();
        Point3f pt = (Point3f)this.getPointOrPlane(i, false, true, false, true, 3, 3);
        Point3f pt1 = new Point3f(pt.x == 0.0f ? 1.0f : 1.0f / pt.x, 0.0f, 0.0f);
        Point3f pt2 = new Point3f(0.0f, pt.y == 0.0f ? 1.0f : 1.0f / pt.y, 0.0f);
        Point3f pt3 = new Point3f(0.0f, 0.0f, pt.z == 0.0f ? 1.0f : 1.0f / pt.z);
        if (pt.x == 0.0f && pt.y == 0.0f && pt.z == 0.0f) {
            this.error(3);
        } else if (pt.x == 0.0f && pt.y == 0.0f) {
            pt1.set(1.0f, 0.0f, pt3.z);
            pt2.set(0.0f, 1.0f, pt3.z);
        } else if (pt.y == 0.0f && pt.z == 0.0f) {
            pt2.set(pt1.x, 0.0f, 1.0f);
            pt3.set(pt1.x, 1.0f, 0.0f);
        } else if (pt.z == 0.0f && pt.x == 0.0f) {
            pt3.set(0.0f, pt2.y, 1.0f);
            pt1.set(1.0f, pt2.y, 0.0f);
        } else if (pt.x == 0.0f) {
            pt1.set(1.0f, pt2.y, 0.0f);
        } else if (pt.y == 0.0f) {
            pt2.set(0.0f, 1.0f, pt3.z);
        } else if (pt.z == 0.0f) {
            pt3.set(pt1.x, 0.0f, 1.0f);
        }
        this.viewer.toCartesian(pt1);
        this.viewer.toCartesian(pt2);
        this.viewer.toCartesian(pt3);
        Vector3f plane = new Vector3f();
        float w = Graphics3D.getNormalThroughPoints(pt1, pt2, pt3, plane, vAB, vAC);
        Point4f p = new Point4f(plane.x, plane.y, plane.z, w);
        if (!this.isSyntaxCheck && Logger.debugging) {
            Logger.info("defined plane: " + p);
        }
        return p;
    }

    private int getMadParameter() throws ScriptException {
        int mad = 1;
        switch (this.getToken((int)1).tok) {
            case 0x40000088: {
                this.restrictSelected(false);
                break;
            }
            case 0x10000D: {
                break;
            }
            case 0x10000C: {
                mad = 0;
                break;
            }
            case 2: {
                int radiusRasMol = this.intParameter(1, 0, 750);
                mad = radiusRasMol * 4 * 2;
                break;
            }
            case 3: {
                mad = (int)(this.floatParameter(1, 0.0f, 3.0f) * 1000.0f * 2.0f);
                break;
            }
            default: {
                this.error(6);
            }
        }
        return mad;
    }

    private int getSetAxesTypeMad(int index) throws ScriptException {
        if (index == this.statementLength) {
            return 1;
        }
        this.checkLength(index + 1);
        switch (this.getToken((int)index).tok) {
            case 0x10000D: {
                return 1;
            }
            case 0x10000C: {
                return 0;
            }
            case 0x4000000F: {
                return -1;
            }
            case 2: {
                return this.intParameter(index, -1, 19);
            }
            case 3: {
                float angstroms = this.floatParameter(index, 0.0f, 2.0f);
                return (int)(angstroms * 1000.0f * 2.0f);
            }
        }
        this.error(7, "\"DOTTED\"");
        return 0;
    }

    private boolean isColorParam(int i) {
        int tok = this.tokAt(i);
        return tok == 0x10100040 || tok == 7 || this.isPoint3f(i) || (tok == 4 || tok == 1) && Graphics3D.getArgbFromString((String)this.statement[i].value) != 0;
    }

    private int getArgbParam(int index) throws ScriptException {
        return this.getArgbParam(index, false);
    }

    private int getArgbParamLast(int index, boolean allowNone) throws ScriptException {
        int icolor = this.getArgbParam(index, allowNone);
        this.checkLength(this.iToken + 1);
        return icolor;
    }

    private int getArgbParam(int index, boolean allowNone) throws ScriptException {
        Point3f pt = null;
        if (this.checkToken(index)) {
            switch (this.getToken((int)index).tok) {
                case 1: 
                case 4: {
                    return Graphics3D.getArgbFromString(this.parameterAsString(index));
                }
                case 0x10100040: {
                    return this.getColorTriad(++index);
                }
                case 7: {
                    pt = (Point3f)this.theToken.value;
                    break;
                }
                case 0x10000A: {
                    pt = this.getPoint3f(index, false);
                    break;
                }
                case 0x10000B: {
                    if (!allowNone) break;
                    return 0;
                }
            }
        }
        if (pt == null) {
            this.error(8);
        }
        return ScriptEvaluator.colorPtToInt(pt);
    }

    static int colorPtToInt(Point3f pt) {
        return 0xFF000000 | ((int)pt.x & 0xFF) << 16 | ((int)pt.y & 0xFF) << 8 | (int)pt.z & 0xFF;
    }

    private int getColorTriad(int i) throws ScriptException {
        int[] colors = new int[3];
        int n = 0;
        String hex = "";
        this.getToken(i);
        Point3f pt = null;
        block0 : switch (this.theTok) {
            case 2: 
            case 1048614: {
                while (i < this.statementLength) {
                    this.getToken(i);
                    switch (this.theTok) {
                        case 0x10100030: {
                            break;
                        }
                        case 1: {
                            if (n != 1 || colors[0] != 0) {
                                this.error(4);
                            }
                            hex = "0" + this.parameterAsString(i);
                            break block0;
                        }
                        case 2: {
                            if (n > 2) {
                                this.error(4);
                            }
                            colors[n++] = this.theToken.intValue;
                            break;
                        }
                        case 1048614: {
                            if (n > 2) {
                                this.error(4);
                            }
                            colors[n++] = (Integer)this.theToken.value % 256;
                            break;
                        }
                        case 0x10100041: {
                            if (n == 3) {
                                return ScriptEvaluator.colorPtToInt(new Point3f(colors[0], colors[1], colors[2]));
                            }
                        }
                        default: {
                            this.error(4);
                        }
                    }
                    ++i;
                }
                this.error(4);
                break;
            }
            case 7: {
                pt = (Point3f)this.theToken.value;
                break;
            }
            case 1: {
                hex = this.parameterAsString(i);
                break;
            }
            default: {
                this.error(4);
            }
        }
        if (this.getToken((int)(++i)).tok != 0x10100041) {
            this.error(4);
        }
        if (pt != null) {
            return ScriptEvaluator.colorPtToInt(pt);
        }
        n = Graphics3D.getArgbFromString("[" + hex + "]");
        if (n == 0) {
            this.error(4);
        }
        return n;
    }

    private boolean isPoint3f(int i) {
        boolean isOK = this.tokAt(i) == 7;
        if (isOK || this.tokAt(i) == 8 || this.isFloatParameter(i + 1) && this.isFloatParameter(i + 2) && this.isFloatParameter(i + 3) && this.isFloatParameter(i + 4)) {
            return isOK;
        }
        this.ignoreError = true;
        int t = this.iToken;
        isOK = true;
        try {
            this.getPoint3f(i, true);
        }
        catch (Exception e) {
            isOK = false;
        }
        this.ignoreError = false;
        this.iToken = t;
        return isOK;
    }

    private Point3f getPoint3f(int i, boolean allowFractional) throws ScriptException {
        return (Point3f)this.getPointOrPlane(i, false, allowFractional, true, false, 3, 3);
    }

    private Point4f getPoint4f(int i) throws ScriptException {
        return (Point4f)this.getPointOrPlane(i, false, false, false, false, 4, 4);
    }

    private Object getPointOrPlane(int index, boolean integerOnly, boolean allowFractional, boolean doConvert, boolean implicitFractional, int minDim, int maxDim) throws ScriptException {
        float[] coord = new float[6];
        int n = 0;
        this.coordinatesAreFractional = implicitFractional;
        if (this.tokAt(index) == 7) {
            if (minDim <= 3 && maxDim >= 3) {
                return (Point3f)this.getToken((int)index).value;
            }
            this.error(22);
        }
        if (this.tokAt(index) == 8) {
            if (minDim <= 4 && maxDim >= 4) {
                return (Point4f)this.getToken((int)index).value;
            }
            this.error(22);
        }
        int multiplier = 1;
        block10: for (int i = index; i < this.statement.length; ++i) {
            switch (this.getToken((int)i).tok) {
                case 0x10000A: 
                case 0x10100030: 
                case 0x10100060: {
                    continue block10;
                }
                case 0x10000E: {
                    break block10;
                }
                case 0x10100090: {
                    multiplier = -1;
                    continue block10;
                }
                case 1048615: {
                    if (n == 6) {
                        this.error(22);
                    }
                    coord[n++] = this.theToken.intValue;
                    multiplier = -1;
                    continue block10;
                }
                case 2: 
                case 1048614: {
                    if (n == 6) {
                        this.error(22);
                    }
                    coord[n++] = this.theToken.intValue * multiplier;
                    multiplier = 1;
                    continue block10;
                }
                case 0x101000A0: {
                    this.getToken(++i);
                }
                case 0x100022: {
                    if (--n < 0 || integerOnly) {
                        this.error(22);
                    }
                    if (this.theToken.value instanceof Integer || this.theTok == 2) {
                        int n2 = n++;
                        coord[n2] = coord[n2] / (float)(this.theToken.intValue == Integer.MAX_VALUE ? (Integer)this.theToken.value : this.theToken.intValue);
                    } else if (this.theToken.value instanceof Float) {
                        int n3 = n++;
                        coord[n3] = coord[n3] / ((Float)this.theToken.value).floatValue();
                    }
                    this.coordinatesAreFractional = true;
                    continue block10;
                }
                case 3: 
                case 1048611: {
                    if (integerOnly) {
                        this.error(22);
                    }
                    if (n == 6) {
                        this.error(22);
                    }
                    coord[n++] = ((Float)this.theToken.value).floatValue();
                    continue block10;
                }
                default: {
                    this.error(22);
                }
            }
        }
        if (n < minDim || n > maxDim) {
            this.error(22);
        }
        if (n == 3) {
            Point3f pt = new Point3f(coord[0], coord[1], coord[2]);
            if (this.coordinatesAreFractional && doConvert && !this.isSyntaxCheck) {
                this.viewer.toCartesian(pt);
            }
            return pt;
        }
        if (n == 4) {
            if (this.coordinatesAreFractional) {
                this.error(22);
            }
            Point4f plane = new Point4f(coord[0], coord[1], coord[2], coord[3]);
            return plane;
        }
        return coord;
    }

    private Point3f xypParameter(int index) throws ScriptException {
        boolean isPercent;
        if (this.tokAt(index) != 0x10100040 || !this.isFloatParameter(++index)) {
            return null;
        }
        Point3f pt = new Point3f();
        pt.x = this.floatParameter(index);
        if (this.tokAt(++index) == 0x10100030) {
            ++index;
        }
        if (!this.isFloatParameter(index)) {
            return null;
        }
        pt.y = this.floatParameter(index);
        boolean bl = isPercent = this.tokAt(++index) == 269484194;
        if (isPercent) {
            ++index;
        }
        if (this.tokAt(index) != 0x10100041) {
            return null;
        }
        this.iToken = index;
        pt.z = (float)(isPercent ? -1 : 1) * Float.MAX_VALUE;
        return pt;
    }

    private int intSetting(int pt, int val, int min, int max) throws ScriptException {
        if (val == Integer.MAX_VALUE) {
            val = this.intSetting(pt);
        }
        if (val < min || val > max) {
            this.integerOutOfRange(min, max);
        }
        return val;
    }

    private int intSetting(int pt) throws ScriptException {
        Vector v = (Vector)this.parameterExpression(pt, -1, "XXX", true);
        if (v == null || v.size() == 0) {
            this.error(22);
        }
        return ScriptVariable.iValue((ScriptVariable)v.elementAt(0));
    }

    private float floatSetting(int pt, float min, float max) throws ScriptException {
        float val = this.floatSetting(pt);
        if (val < min || val > max) {
            this.numberOutOfRange(min, max);
        }
        return val;
    }

    private float floatSetting(int pt) throws ScriptException {
        Vector v = (Vector)this.parameterExpression(pt, -1, "XXX", true);
        if (v == null || v.size() == 0) {
            this.error(22);
        }
        return ScriptVariable.fValue((ScriptVariable)v.elementAt(0));
    }

    private String stringSetting(int pt, boolean isJmolSet) throws ScriptException {
        if (isJmolSet && this.statementLength == pt + 1) {
            return this.parameterAsString(pt);
        }
        Vector v = (Vector)this.parameterExpression(pt, -1, "XXX", true);
        if (v == null || v.size() == 0) {
            this.error(22);
        }
        return ScriptVariable.sValue((ScriptVariable)v.elementAt(0));
    }

    private ScriptVariable tokenSetting(int pt) throws ScriptException {
        Vector v = (Vector)this.parameterExpression(pt, -1, "XXX", true);
        if (v == null || v.size() == 0) {
            this.error(22);
        }
        return (ScriptVariable)v.elementAt(0);
    }

    private boolean isCommandDisplayable(int i) {
        if (i >= this.aatoken.length || i >= this.pcEnd || this.aatoken[i] == null) {
            return false;
        }
        return this.lineIndices[i][1] > this.lineIndices[i][0];
    }

    private boolean checkContinue() {
        if (this.interruptExecution) {
            return false;
        }
        if (this.executionStepping && this.isCommandDisplayable(this.pc)) {
            this.viewer.scriptStatus("Next: " + this.getNextStatement(), "stepping -- type RESUME to continue", 0, null);
            this.executionPaused = true;
        } else if (!this.executionPaused) {
            return true;
        }
        Logger.info("script execution paused at this command: " + this.pc + " level " + this.scriptLevel + " " + this.thisCommand);
        try {
            while (this.executionPaused) {
                this.viewer.popHoldRepaint("pause");
                Thread.sleep(100L);
                this.refresh();
                String script = this.viewer.getInterruptScript();
                if (script != "") {
                    this.resumePausedExecution();
                    this.setErrorMessage(null);
                    --this.pc;
                    try {
                        this.runScript(script);
                    }
                    catch (Exception e) {
                        this.setErrorMessage("" + e);
                    }
                    catch (Error er) {
                        this.setErrorMessage("" + er);
                    }
                    if (this.error) {
                        this.popContext();
                        this.scriptStatusOrBuffer(this.errorMessage);
                        this.setErrorMessage(null);
                    }
                    ++this.pc;
                    this.pauseExecution();
                }
                this.viewer.pushHoldRepaint("pause");
            }
            if (!(this.isSyntaxCheck || this.interruptExecution || this.executionStepping)) {
                this.viewer.scriptStatus("script execution " + (this.error || this.interruptExecution ? "interrupted" : "resumed"));
            }
        }
        catch (Exception e) {
            this.viewer.pushHoldRepaint("pause");
        }
        Logger.debug("script execution resumed");
        return !this.error && !this.interruptExecution;
    }

    private void instructionDispatchLoop(boolean doList) throws ScriptException {
        long timeBegin = 0L;
        boolean isForCheck = false;
        this.logMessages = false;
        this.debugScript = false;
        if (!this.isSyntaxCheck) {
            this.setDebugging();
        }
        if (this.logMessages) {
            timeBegin = System.currentTimeMillis();
            this.viewer.scriptStatus("Eval.instructionDispatchLoop():" + timeBegin);
            this.viewer.scriptStatus(this.script);
        }
        if (this.pcEnd == 0) {
            this.pcEnd = Integer.MAX_VALUE;
        }
        if (this.lineEnd == 0) {
            this.lineEnd = Integer.MAX_VALUE;
        }
        String lastCommand = "";
        while (this.pc < this.aatoken.length && this.pc < this.pcEnd && (this.isSyntaxCheck || this.checkContinue()) && this.lineNumbers[this.pc] <= this.lineEnd) {
            block124: {
                Token token;
                block126: {
                    block125: {
                        block123: {
                            Token token2 = token = this.aatoken[this.pc].length == 0 ? null : this.aatoken[this.pc][0];
                            if (!(this.historyDisabled || this.isSyntaxCheck || this.scriptLevel > this.commandHistoryLevelMax || this.tQuiet)) {
                                this.thisCommand = this.getCommand(this.pc, true, true);
                                if (!(token == null || this.thisCommand.equals(lastCommand) || token.tok != 135499780 && Token.tokAttr(token.tok, 102400) || this.thisCommand.length() <= 0)) {
                                    lastCommand = this.thisCommand;
                                    this.viewer.addCommand(lastCommand);
                                }
                            }
                            if (this.setStatement(this.pc)) break block123;
                            Logger.info(this.getCommand(this.pc, true, false) + " -- STATEMENT CONTAINING @{} SKIPPED");
                            break block124;
                        }
                        this.thisCommand = this.getCommand(this.pc, false, true);
                        this.fullCommand = this.thisCommand + this.getNextComment();
                        this.iToken = 0;
                        String script = this.viewer.getInterruptScript();
                        if (script != "") {
                            this.runScript(script);
                        }
                        if (doList || !this.isSyntaxCheck) {
                            int milliSecDelay = this.viewer.getScriptDelay();
                            if (doList || milliSecDelay > 0 && this.scriptLevel > 0) {
                                if (milliSecDelay > 0) {
                                    this.delay(-((long)milliSecDelay));
                                }
                                this.viewer.scriptEcho("$[" + this.scriptLevel + "." + this.lineNumbers[this.pc] + "." + (this.pc + 1) + "] " + this.thisCommand);
                            }
                        }
                        if (!this.isSyntaxCheck) break block125;
                        if (this.isCmdLine_c_or_C_Option) {
                            Logger.info(this.thisCommand);
                        }
                        if (this.statementLength != 1 || this.statement[0].tok == 135499780) break block126;
                        break block124;
                    }
                    if (this.debugScript) {
                        this.logDebugScript(0);
                    }
                    if (this.logMessages && token != null) {
                        Logger.debug(token.toString());
                    }
                }
                if (token != null) {
                    switch (token.tok) {
                        case 0: {
                            break;
                        }
                        case 102402: 
                        case 102406: 
                        case 102407: 
                        case 102408: 
                        case 233481: 
                        case 364547: 
                        case 364548: 
                        case 135369224: 
                        case 135369225: {
                            isForCheck = this.flowControl(token.tok, isForCheck);
                            break;
                        }
                        case 3674115: {
                            this.proteinShape(9);
                            break;
                        }
                        case 536875012: {
                            this.background(1);
                            break;
                        }
                        case 12289: {
                            this.center(1);
                            break;
                        }
                        case 558895366: {
                            this.color();
                            break;
                        }
                        case 20487: {
                            this.cd();
                            break;
                        }
                        case 135272450: {
                            this.data();
                            break;
                        }
                        case 537931778: {
                            this.define();
                            break;
                        }
                        case 536891393: {
                            this.echo(1, false);
                            break;
                        }
                        case 20484: {
                            this.message();
                            break;
                        }
                        case 266258: {
                            if (!this.isSyntaxCheck && this.pc > 0) {
                                this.viewer.clearScriptQueue();
                            }
                        }
                        case 266281: {
                            if (this.isSyntaxCheck) break;
                            this.interruptExecution = this.pc > 0 || !this.viewer.usingScriptQueue();
                            break;
                        }
                        case 752374019: {
                            this.label(1);
                            break;
                        }
                        case 544771: {
                            this.hover();
                            break;
                        }
                        case 135271427: {
                            this.load();
                            break;
                        }
                        case 538447907: {
                            this.monitor();
                            break;
                        }
                        case 266283: {
                            this.refresh();
                            break;
                        }
                        case 266267: {
                            this.viewer.initialize();
                            break;
                        }
                        case 4140: {
                            this.reset();
                            break;
                        }
                        case 528432: {
                            this.rotate(false, false);
                            break;
                        }
                        case 135271429: 
                        case 135287299: {
                            this.script(token.tok);
                            break;
                        }
                        case 135499780: {
                            this.function();
                            break;
                        }
                        case 4156: {
                            this.sync();
                            break;
                        }
                        case 536875034: {
                            this.history(1);
                            break;
                        }
                        case 12291: {
                            this.delete();
                            break;
                        }
                        case 4129: {
                            this.minimize();
                            break;
                        }
                        case 135280129: {
                            this.select();
                            break;
                        }
                        case 4158: {
                            this.translate();
                            break;
                        }
                        case 4124: {
                            this.invertSelected();
                            break;
                        }
                        case 4145: {
                            this.rotate(false, true);
                            break;
                        }
                        case 4159: {
                            this.translateSelected();
                            break;
                        }
                        case 12296: {
                            this.zap(true);
                            break;
                        }
                        case 4164: {
                            this.zoom(false);
                            break;
                        }
                        case 4165: {
                            this.zoom(true);
                            break;
                        }
                        case 528396: {
                            this.delay();
                            break;
                        }
                        case 528415: {
                            this.delay();
                            if (this.isSyntaxCheck) break;
                            this.pc = -1;
                            break;
                        }
                        case 20503: {
                            this.gotocmd();
                            break;
                        }
                        case 4132: {
                            this.move();
                            break;
                        }
                        case 536883204: {
                            this.display(true);
                            break;
                        }
                        case 12293: {
                            this.display(false);
                            break;
                        }
                        case 12294: {
                            this.restrict();
                            break;
                        }
                        case 0x303007: {
                            this.subset();
                            break;
                        }
                        case 537399347: {
                            this.selectionHalo(1);
                            break;
                        }
                        case 36867: {
                            this.set();
                            break;
                        }
                        case 528437: {
                            this.slab(false);
                            break;
                        }
                        case 528397: {
                            this.slab(true);
                            break;
                        }
                        case 528401: {
                            this.ellipsoid();
                            break;
                        }
                        case 528441: {
                            this.setAtomShapeSize(7, -100);
                            break;
                        }
                        case 528408: {
                            this.setAtomShapeSize(8, -20);
                            break;
                        }
                        case 39325966: {
                            this.setAtomShapeSize(0, -100);
                            break;
                        }
                        case 30412803: {
                            this.structure();
                            break;
                        }
                        case 528451: {
                            this.wireframe();
                            break;
                        }
                        case 4161: {
                            this.vector();
                            break;
                        }
                        case 4110: {
                            this.dipole();
                            break;
                        }
                        case 4097: {
                            this.animation();
                            break;
                        }
                        case 4162: {
                            this.vibration();
                            break;
                        }
                        case 4102: {
                            this.calculate();
                            break;
                        }
                        case 528399: {
                            this.dots(6);
                            break;
                        }
                        case 537399355: {
                            this.proteinShape(12);
                            break;
                        }
                        case 528416: {
                            this.proteinShape(13);
                            break;
                        }
                        case 528430: {
                            this.proteinShape(14);
                            break;
                        }
                        case 528445: {
                            this.proteinShape(10);
                            break;
                        }
                        case 528391: {
                            this.proteinShape(11);
                            break;
                        }
                        case 528431: {
                            this.proteinShape(15);
                            break;
                        }
                        case 537399351: {
                            this.rotate(true, false);
                            break;
                        }
                        case 537399352: {
                            this.ssbond();
                            break;
                        }
                        case 538447897: {
                            this.hbond(true);
                            break;
                        }
                        case 4148: {
                            this.show();
                            break;
                        }
                        case 156242439: {
                            this.file();
                            break;
                        }
                        case 4116: 
                        case 22024203: {
                            this.frame(1);
                            break;
                        }
                        case 4115: {
                            this.font(-1, 0.0f);
                            break;
                        }
                        case 4133: {
                            this.moveto();
                            break;
                        }
                        case 4134: {
                            this.navigate();
                            break;
                        }
                        case 4101: {
                            this.bondorder();
                            break;
                        }
                        case 528395: {
                            this.console();
                            break;
                        }
                        case 4135: {
                            this.isosurface(25);
                            break;
                        }
                        case 4112: {
                            this.draw();
                            break;
                        }
                        case 4136: {
                            this.polyhedra();
                            break;
                        }
                        case 528406: {
                            this.dots(18);
                            break;
                        }
                        case 4104: {
                            this.centerAt();
                            break;
                        }
                        case 4125: {
                            this.isosurface(22);
                            break;
                        }
                        case 4126: {
                            this.lcaoCartoon();
                            break;
                        }
                        case 4130: {
                            this.mo(false);
                            break;
                        }
                        case 528442: {
                            this.stereo();
                            break;
                        }
                        case 4106: {
                            this.connect(1);
                            break;
                        }
                        case 135270405: {
                            this.getProperty();
                            break;
                        }
                        case 4105: {
                            this.configuration();
                            break;
                        }
                        case 537399298: {
                            this.axes(1);
                            break;
                        }
                        case 605556745: {
                            this.boundbox(1);
                            break;
                        }
                        case 540545088: {
                            this.unitcell(1);
                            break;
                        }
                        case 537399317: {
                            this.frank(1);
                            break;
                        }
                        case 20482: {
                            this.help();
                            break;
                        }
                        case 4146: {
                            this.save();
                            break;
                        }
                        case 4141: {
                            this.restore();
                            break;
                        }
                        case 1052714: {
                            this.dataFrame(0);
                            break;
                        }
                        case 135272453: {
                            this.dataFrame(1);
                            break;
                        }
                        case 135270406: {
                            this.write(null);
                            break;
                        }
                        case 36865: {
                            this.print();
                            break;
                        }
                        case 36866: {
                            this.returnCmd();
                            break;
                        }
                        case 20485: {
                            this.pause();
                            break;
                        }
                        case 266297: {
                            if (!this.pause()) break;
                            this.stepPausedExecution();
                            break;
                        }
                        case 266286: {
                            if (this.isSyntaxCheck) break;
                            this.resumePausedExecution();
                            break;
                        }
                        default: {
                            this.error(47);
                        }
                    }
                    if (!this.isSyntaxCheck) {
                        this.viewer.setCursor(0);
                    }
                    if (this.executionStepping) {
                        this.executionPaused = this.isCommandDisplayable(this.pc + 1);
                    }
                }
            }
            ++this.pc;
        }
    }

    private boolean flowControl(int tok, boolean isForCheck) throws ScriptException {
        int pt = this.statement[0].intValue;
        boolean isDone = pt < 0 && !this.isSyntaxCheck;
        boolean isOK = true;
        int ptNext = 0;
        switch (tok) {
            case 102402: 
            case 135369225: {
                boolean bl = isOK = !isDone && this.ifCmd();
                if (this.isSyntaxCheck) break;
                ptNext = Math.abs(this.aatoken[Math.abs((int)pt)][0].intValue);
                this.aatoken[Math.abs((int)pt)][0].intValue = ptNext = isDone || isOK ? -ptNext : ptNext;
                break;
            }
            case 364547: {
                this.checkLength(1);
                if (pt >= 0 || this.isSyntaxCheck) break;
                this.pc = -pt - 1;
                break;
            }
            case 364548: {
                this.checkLength(1);
                break;
            }
            case 233481: {
                this.checkLength(2);
                if (this.getToken((int)1).tok == 135499780) {
                    this.viewer.addFunction((ScriptFunction)this.theToken.value);
                    return isForCheck;
                }
                isForCheck = this.theTok == 135369224;
                isOK = this.theTok == 135369225;
                break;
            }
            case 102406: {
                isForCheck = false;
                if (this.ifCmd() || this.isSyntaxCheck) break;
                this.pc = pt;
                break;
            }
            case 102407: {
                if (!this.isSyntaxCheck) {
                    this.pc = this.aatoken[pt][0].intValue;
                }
                if (this.statementLength <= 1) break;
                this.checkLength(2);
                this.intParameter(1);
                break;
            }
            case 102408: {
                isForCheck = true;
                if (!this.isSyntaxCheck) {
                    this.pc = pt - 1;
                }
                if (this.statementLength <= 1) break;
                this.checkLength(2);
                this.intParameter(1);
                break;
            }
            case 135369224: {
                int[] pts = new int[2];
                int j = 0;
                int nSkip = 0;
                block14: for (int i = 1; i < this.statementLength && j < 2; ++i) {
                    switch (this.tokAt(i)) {
                        case 0x10000F: {
                            if (nSkip > 0) {
                                --nSkip;
                                continue block14;
                            }
                            pts[j++] = i;
                            continue block14;
                        }
                        case 135280129: {
                            nSkip += 2;
                        }
                    }
                }
                if (isForCheck) {
                    j = pts[1] + 1;
                    isForCheck = false;
                } else {
                    j = 2;
                    if (this.tokAt(j) == 537038852) {
                        ++j;
                    }
                }
                if (this.tokAt(j) == 1) {
                    String key = this.parameterAsString(j);
                    if (this.getToken((int)(++j)).tok != 269484420) {
                        this.error(22);
                    }
                    this.setVariable(++j, this.statementLength - 1, key, false, 0);
                }
                isOK = (Boolean)this.parameterExpression(pts[0] + 1, pts[1], null, false);
                ++pt;
            }
        }
        if (!isOK && !this.isSyntaxCheck) {
            this.pc = Math.abs(pt) - 1;
        }
        return isForCheck;
    }

    private boolean ifCmd() throws ScriptException {
        return (Boolean)this.parameterExpression(1, 0, null, false);
    }

    private void returnCmd() throws ScriptException {
        Vector v;
        ScriptVariable t = this.getContextVariableAsVariable("_retval");
        if (t == null) {
            if (!this.isSyntaxCheck) {
                this.interruptExecution = true;
            }
            return;
        }
        Vector vector = v = this.statementLength == 1 ? null : (Vector)this.parameterExpression(1, 0, null, true);
        if (this.isSyntaxCheck) {
            return;
        }
        ScriptVariable tv = v == null || v.size() == 0 ? ScriptVariable.intVariable(0) : (ScriptVariable)v.get(0);
        t.value = tv.value;
        t.intValue = tv.intValue;
        t.tok = tv.tok;
        this.pcEnd = this.pc;
    }

    private void help() throws ScriptException {
        if (this.isSyntaxCheck) {
            return;
        }
        String what = this.statementLength == 1 ? "" : this.parameterAsString(1);
        Token t = Token.getTokenFromName(what);
        if (t != null && (t.tok & 0x1000) != 0) {
            what = "?command=" + what;
        }
        this.viewer.getHelp(what);
    }

    private void move() throws ScriptException {
        int fps;
        if (this.statementLength > 11) {
            this.error(2);
        }
        Vector3f dRot = new Vector3f(this.floatParameter(1), this.floatParameter(2), this.floatParameter(3));
        float dZoom = this.floatParameter(4);
        Vector3f dTrans = new Vector3f(this.intParameter(5), this.intParameter(6), this.intParameter(7));
        float dSlab = this.floatParameter(8);
        float floatSecondsTotal = this.floatParameter(9);
        int n = fps = this.statementLength == 11 ? this.intParameter(10) : 30;
        if (this.isSyntaxCheck) {
            return;
        }
        this.refresh();
        this.viewer.move(dRot, dZoom, dTrans, dSlab, floatSecondsTotal, fps);
    }

    private void moveto() throws ScriptException {
        if (this.statementLength == 2 && this.isFloatParameter(1)) {
            float f = this.floatParameter(1);
            if (this.isSyntaxCheck) {
                return;
            }
            if (f > 0.0f) {
                this.refresh();
            }
            this.viewer.moveTo(f, null, new Point3f(0.0f, 0.0f, 1.0f), 0.0f, 100.0f, 0.0f, 0.0f, 0.0f, null, Float.NaN, Float.NaN, Float.NaN);
            return;
        }
        Point3f pt = new Point3f();
        Point3f center = null;
        int i = 1;
        float floatSecondsTotal = this.isFloatParameter(i) ? this.floatParameter(i++) : 2.0f;
        float zoom = Float.NaN;
        float xTrans = 0.0f;
        float yTrans = 0.0f;
        float degrees = 90.0f;
        switch (this.getToken((int)i).tok) {
            case 7: 
            case 0x10000A: {
                if (this.isPoint3f(i)) {
                    pt = this.getPoint3f(i, true);
                    i = this.iToken + 1;
                    degrees = this.floatParameter(i++);
                    break;
                }
                Point4f pt4 = this.getPoint4f(i);
                i = this.iToken + 1;
                pt.set(pt4.x, pt4.y, pt4.z);
                degrees = pt4.w;
                break;
            }
            case 1073741842: {
                pt.set(1.0f, 0.0f, 0.0f);
                degrees = 0.0f;
                ++i;
                break;
            }
            case 0x40000005: {
                pt.set(0.0f, 1.0f, 0.0f);
                degrees = 180.0f;
                ++i;
                break;
            }
            case 1073741849: {
                pt.set(0.0f, 1.0f, 0.0f);
                ++i;
                break;
            }
            case 1073741873: {
                pt.set(0.0f, -1.0f, 0.0f);
                this.checkLength(++i);
                break;
            }
            case 1073741883: {
                pt.set(1.0f, 0.0f, 0.0f);
                this.checkLength(++i);
                break;
            }
            case 0x40000009: {
                pt.set(-1.0f, 0.0f, 0.0f);
                this.checkLength(++i);
                break;
            }
            default: {
                pt = new Point3f(this.floatParameter(i++), this.floatParameter(i++), this.floatParameter(i++));
                degrees = this.floatParameter(i++);
            }
        }
        boolean isChange = !this.viewer.isInPosition(pt, degrees);
        float zoom0 = this.viewer.getZoomSetting();
        if (i != this.statementLength && !this.isCenterParameter(i)) {
            zoom = this.floatParameter(i++);
        }
        if (i != this.statementLength && !this.isCenterParameter(i)) {
            xTrans = this.floatParameter(i++);
            yTrans = this.floatParameter(i++);
            if (!isChange && Math.abs(xTrans - this.viewer.getTranslationXPercent()) >= 1.0f) {
                isChange = true;
            }
            if (!isChange && Math.abs(yTrans - this.viewer.getTranslationYPercent()) >= 1.0f) {
                isChange = true;
            }
        }
        float rotationRadius = Float.NaN;
        if (i != this.statementLength) {
            int ptCenter = i;
            center = this.centerParameter(i);
            if (!isChange && (double)center.distance(this.viewer.getRotationCenter()) >= 0.1) {
                isChange = true;
            }
            if (this.isFloatParameter(i = this.iToken + 1)) {
                rotationRadius = this.floatParameter(i++);
            }
            float radius = this.viewer.getRotationRadius();
            if (!this.isCenterParameter(i)) {
                if ((rotationRadius == 0.0f || Float.isNaN(rotationRadius)) && (zoom == 0.0f || Float.isNaN(zoom))) {
                    float factor = Math.abs(this.getZoomFactor(i, ptCenter, radius, zoom0));
                    i = this.iToken + 1;
                    if (Float.isNaN(factor)) {
                        this.error(22);
                    }
                    zoom = factor;
                } else if (!isChange && (double)Math.abs(rotationRadius - this.viewer.getRotationRadius()) >= 0.1) {
                    isChange = true;
                }
            }
        }
        if (zoom == 0.0f || Float.isNaN(zoom)) {
            zoom = 100.0f;
        }
        if (Float.isNaN(rotationRadius)) {
            rotationRadius = 0.0f;
        }
        if (!isChange && Math.abs(zoom - zoom0) >= 1.0f) {
            isChange = true;
        }
        Point3f navCenter = null;
        float xNav = Float.NaN;
        float yNav = Float.NaN;
        float navDepth = Float.NaN;
        if (i != this.statementLength) {
            navCenter = this.centerParameter(i);
            i = this.iToken + 1;
            if (i != this.statementLength) {
                xNav = this.floatParameter(i++);
                yNav = this.floatParameter(i++);
            }
            if (i != this.statementLength) {
                navDepth = this.floatParameter(i++);
            }
        }
        if (i != this.statementLength) {
            this.error(2);
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (!isChange) {
            floatSecondsTotal = 0.0f;
        }
        if (floatSecondsTotal > 0.0f) {
            this.refresh();
        }
        this.viewer.moveTo(floatSecondsTotal, center, pt, degrees, zoom, xTrans, yTrans, rotationRadius, navCenter, xNav, yNav, navDepth);
    }

    private void navigate() throws ScriptException {
        if (this.statementLength == 1) {
            this.setBooleanProperty("navigationMode", true);
            return;
        }
        Vector3f rotAxis = new Vector3f(0.0f, 1.0f, 0.0f);
        if (this.statementLength == 2) {
            switch (this.getToken((int)1).tok) {
                case 0x10000C: 
                case 0x10000D: {
                    this.setBooleanProperty("navigationMode", this.theTok == 0x10000D);
                }
            }
            this.error(22);
            return;
        }
        if (!this.viewer.getNavigationMode()) {
            this.setBooleanProperty("navigationMode", true);
        }
        block16: for (int i = 1; i < this.statementLength; ++i) {
            float timeSec;
            float f = timeSec = this.isFloatParameter(i) ? this.floatParameter(i++) : 2.0f;
            if (timeSec < 0.0f) {
                this.error(22);
            }
            if (!this.isSyntaxCheck && timeSec > 0.0f) {
                this.refresh();
            }
            switch (this.getToken((int)i).tok) {
                case 528397: {
                    float depth = this.floatParameter(++i);
                    if (this.isSyntaxCheck) continue block16;
                    this.viewer.setNavigationDepthPercent(timeSec, depth);
                    continue block16;
                }
                case 12289: {
                    Point3f pt = this.centerParameter(++i);
                    i = this.iToken;
                    if (this.isSyntaxCheck) continue block16;
                    this.viewer.navigate(timeSec, pt);
                    continue block16;
                }
                case 528432: {
                    switch (this.getToken((int)(++i)).tok) {
                        case 1: {
                            String str = this.parameterAsString(i++);
                            if (str.equalsIgnoreCase("x")) {
                                rotAxis.set(1.0f, 0.0f, 0.0f);
                                break;
                            }
                            if (str.equalsIgnoreCase("y")) {
                                rotAxis.set(0.0f, 1.0f, 0.0f);
                                break;
                            }
                            if (str.equalsIgnoreCase("z")) {
                                rotAxis.set(0.0f, 0.0f, 1.0f);
                                break;
                            }
                            this.error(22);
                            break;
                        }
                        case 7: 
                        case 0x10000A: {
                            rotAxis.set(this.getPoint3f(i, true));
                            i = this.iToken + 1;
                        }
                    }
                    float degrees = this.floatParameter(i);
                    if (this.isSyntaxCheck) continue block16;
                    this.viewer.navigate(timeSec, rotAxis, degrees);
                    continue block16;
                }
                case 4158: {
                    Point3f pt;
                    float x = Float.NaN;
                    float y = Float.NaN;
                    if (this.isFloatParameter(++i)) {
                        x = this.floatParameter(i);
                        y = this.floatParameter(++i);
                    } else if (this.getToken((int)i).tok == 1) {
                        String str = this.parameterAsString(i);
                        if (str.equalsIgnoreCase("x")) {
                            x = this.floatParameter(++i);
                        } else if (str.equalsIgnoreCase("y")) {
                            y = this.floatParameter(++i);
                        } else {
                            this.error(22);
                        }
                    } else {
                        pt = this.centerParameter(i);
                        i = this.iToken;
                        if (this.isSyntaxCheck) continue block16;
                        this.viewer.navTranslate(timeSec, pt);
                        continue block16;
                    }
                    if (this.isSyntaxCheck) continue block16;
                    this.viewer.navTranslatePercent(timeSec, x, y);
                    continue block16;
                }
                case 0x101000A0: {
                    continue block16;
                }
                case 528445: {
                    Vector vp = new Vector();
                    BitSet bs = this.expression(++i);
                    i = this.iToken;
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    this.viewer.getPolymerPointsAndVectors(bs, vp);
                    int n = vp.size();
                    if (n <= 0) continue block16;
                    Point3f[][] pathGuide = new Point3f[n][];
                    for (int j = 0; j < n; ++j) {
                        pathGuide[j] = (Point3f[])vp.get(j);
                    }
                    this.viewer.navigate(timeSec, pathGuide);
                    continue block16;
                }
                case 1: {
                    float[] theta = null;
                    String str = this.parameterAsString(i);
                    if (str.equalsIgnoreCase("path")) {
                        if (this.getToken((int)(i + 1)).tok == 0x100007) {
                            ++i;
                            String pathID = this.objectNameParameter(++i);
                            if (this.isSyntaxCheck) {
                                return;
                            }
                            this.setShapeProperty(21, "thisID", pathID);
                            Point3f[] path = (Point3f[])this.viewer.getShapeProperty(21, "vertices");
                            this.refresh();
                            if (path == null) {
                                this.error(22);
                            }
                            int indexStart = (int)(this.isFloatParameter(i + 1) ? this.floatParameter(++i) : 0.0f);
                            int indexEnd = (int)(this.isFloatParameter(i + 1) ? this.floatParameter(++i) : 2.1474836E9f);
                            if (this.isSyntaxCheck) continue block16;
                            this.viewer.navigate(timeSec, path, theta, indexStart, indexEnd);
                            continue block16;
                        }
                        Vector<Point3f> v = new Vector<Point3f>();
                        while (this.isCenterParameter(i + 1)) {
                            v.addElement(this.centerParameter(++i));
                            i = this.iToken;
                        }
                        if (v.size() > 0) {
                            Point3f[] path = new Point3f[v.size()];
                            for (int j = 0; j < v.size(); ++j) {
                                path[j] = (Point3f)v.get(j);
                            }
                            if (this.isSyntaxCheck) continue block16;
                            this.viewer.navigate(timeSec, path, theta, 0, Integer.MAX_VALUE);
                            continue block16;
                        }
                    }
                }
                default: {
                    this.error(22);
                }
            }
        }
    }

    private void bondorder() throws ScriptException {
        this.checkLength(-3);
        short order = 0;
        switch (this.getToken((int)1).tok) {
            case 2: 
            case 3: {
                order = JmolConstants.getBondOrderFromFloat(this.floatParameter(1));
                if (order != Short.MAX_VALUE) break;
                this.error(22);
                break;
            }
            default: {
                order = JmolConstants.getBondOrderFromString(this.parameterAsString(1));
                if (order == Short.MAX_VALUE) {
                    this.error(22);
                }
                if (order != 33 || this.tokAt(2) != 3) break;
                order = JmolConstants.getPartialBondOrderFromInteger(this.statement[2].intValue);
            }
        }
        this.setShapeProperty(1, "bondOrder", new Short(order));
    }

    private void console() throws ScriptException {
        switch (this.getToken((int)1).tok) {
            case 0x10000C: {
                if (this.isSyntaxCheck) break;
                this.viewer.showConsole(false);
                break;
            }
            case 0x10000D: {
                if (this.isSyntaxCheck) break;
                this.viewer.showConsole(true);
                this.viewer.clearConsole();
                break;
            }
            default: {
                this.error(22);
            }
        }
    }

    private void centerAt() throws ScriptException {
        String relativeTo = null;
        switch (this.getToken((int)1).tok) {
            case 0x40000001: {
                relativeTo = "absolute";
                break;
            }
            case 96: {
                relativeTo = "average";
                break;
            }
            case 605556745: {
                relativeTo = "boundbox";
                break;
            }
            default: {
                this.error(22);
            }
        }
        Point3f pt = new Point3f(0.0f, 0.0f, 0.0f);
        if (this.statementLength == 5) {
            pt.x = this.floatParameter(2);
            pt.y = this.floatParameter(3);
            pt.z = this.floatParameter(4);
        } else if (this.isCenterParameter(2)) {
            pt = this.centerParameter(2);
            this.checkLength(this.iToken + 1);
        } else {
            this.checkLength(2);
        }
        if (!this.isSyntaxCheck) {
            this.viewer.setCenterAt(relativeTo, pt);
        }
    }

    private void stereo() throws ScriptException {
        int stereoMode = 1;
        float degrees = -5.0f;
        boolean degreesSeen = false;
        int[] colors = null;
        int colorpt = 0;
        block6: for (int i = 1; i < this.statementLength; ++i) {
            if (this.isColorParam(i)) {
                if (colorpt > 1) {
                    this.error(2);
                }
                if (colorpt == 0) {
                    colors = new int[2];
                }
                if (!degreesSeen) {
                    degrees = 3.0f;
                }
                colors[colorpt] = this.getArgbParam(i);
                if (colorpt++ == 0) {
                    colors[1] = ~colors[0];
                }
                i = this.iToken;
                continue;
            }
            switch (this.getToken((int)i).tok) {
                case 0x10000D: {
                    this.checkLength(2);
                    this.iToken = 1;
                    continue block6;
                }
                case 0x10000C: {
                    this.checkLength(2);
                    this.iToken = 1;
                    stereoMode = 0;
                    continue block6;
                }
                case 2: 
                case 3: {
                    degrees = this.floatParameter(i);
                    degreesSeen = true;
                    continue block6;
                }
                case 1: {
                    if (!degreesSeen) {
                        degrees = 3.0f;
                    }
                    if ((stereoMode = JmolConstants.getStereoMode(this.parameterAsString(i))) != -1) continue block6;
                }
                default: {
                    this.error(22);
                }
            }
        }
        if (this.isSyntaxCheck) {
            return;
        }
        this.viewer.setStereoMode(colors, stereoMode, degrees);
    }

    private void connect(int index) throws ScriptException {
        float[] distances = new float[2];
        BitSet[] atomSets = new BitSet[2];
        atomSets[0] = atomSets[1] = this.viewer.getSelectionSet();
        float radius = Float.NaN;
        int color = Integer.MIN_VALUE;
        int distanceCount = 0;
        short bondOrder = Short.MAX_VALUE;
        int operation = 3;
        boolean isDelete = false;
        boolean haveType = false;
        boolean haveOperation = false;
        String translucency = null;
        float translucentLevel = Float.MAX_VALUE;
        boolean isColorOrRadius = false;
        int nAtomSets = 0;
        int nDistances = 0;
        BitSet bsBonds = new BitSet();
        boolean isBonds = false;
        int expression2 = 0;
        if (this.statementLength == 1) {
            this.viewer.rebond();
            return;
        }
        block13: for (int i = index; i < this.statementLength; ++i) {
            if (this.isColorParam(i)) {
                color = this.getArgbParam(i);
                i = this.iToken;
                isColorOrRadius = true;
                continue;
            }
            switch (this.getToken((int)i).tok) {
                case 0x10000C: 
                case 0x10000D: {
                    this.checkLength(2);
                    if (!this.isSyntaxCheck) {
                        this.viewer.rebond();
                    }
                    return;
                }
                case 2: 
                case 3: {
                    short bo;
                    if (nAtomSets > 0) {
                        if (haveType || isColorOrRadius) {
                            this.error(23);
                        }
                        if ((bo = JmolConstants.getBondOrderFromFloat(this.floatParameter(i))) == Short.MAX_VALUE) {
                            this.error(22);
                        }
                        bondOrder = bo;
                        haveType = true;
                        continue block13;
                    }
                    if (++nDistances > 2) {
                        this.error(2);
                    }
                    distances[distanceCount++] = this.floatParameter(i);
                    continue block13;
                }
                case 0x100001: 
                case 0x40000007: {
                    if (nAtomSets > 2 || isBonds && nAtomSets > 0) {
                        this.error(2);
                    }
                    if (haveType || isColorOrRadius) {
                        this.error(23);
                    }
                    atomSets[nAtomSets++] = this.expression(i);
                    isBonds = this.isBondSet;
                    if (nAtomSets == 2) {
                        int pt = this.iToken;
                        for (int j = i; j < pt; ++j) {
                            if (this.tokAt(j) != 1 || !this.parameterAsString(j).equals("_1")) continue;
                            expression2 = i;
                            break;
                        }
                        this.iToken = pt;
                    }
                    i = this.iToken;
                    continue block13;
                }
                case 1: 
                case 538447897: {
                    String cmd = this.parameterAsString(i);
                    if (cmd.equalsIgnoreCase("pdb")) {
                        boolean isAuto = this.optParameterAsString(2).equalsIgnoreCase("auto");
                        if (isAuto) {
                            this.checkLength(3);
                        } else {
                            this.checkLength(2);
                        }
                        if (this.isSyntaxCheck) {
                            return;
                        }
                        this.viewer.setPdbConectBonding(isAuto);
                        return;
                    }
                    short bo = JmolConstants.getBondOrderFromString(cmd);
                    if (bo == Short.MAX_VALUE) {
                        haveOperation = true;
                        if (++i != this.statementLength) {
                            this.error(23);
                        }
                        if ((operation = JmolConstants.connectOperationFromString(cmd)) < 0) {
                            this.error(22);
                        }
                        if (operation != 4 || bondOrder == Short.MAX_VALUE || bondOrder == 2048 || bondOrder == 515) continue block13;
                        this.error(22);
                        continue block13;
                    }
                    if (haveType) {
                        this.error(18);
                    }
                    haveType = true;
                    if (bo == 33) {
                        switch (this.tokAt(i + 1)) {
                            case 3: {
                                bo = JmolConstants.getPartialBondOrderFromInteger(this.statement[++i].intValue);
                                break;
                            }
                            case 2: {
                                bo = (short)this.intParameter(++i);
                            }
                        }
                    }
                    bondOrder = bo;
                    continue block13;
                }
                case 1073741861: 
                case 1073741887: {
                    if (translucency != null) {
                        this.error(22);
                    }
                    isColorOrRadius = true;
                    translucency = this.parameterAsString(i);
                    if (this.theTok != 1073741887 || !this.isFloatParameter(i + 1)) continue block13;
                    translucentLevel = this.getTranslucentLevel(++i);
                    continue block13;
                }
                case 592445697: {
                    radius = this.floatParameter(++i);
                    isColorOrRadius = true;
                    continue block13;
                }
                case 12291: 
                case 0x10000B: {
                    if (++i != this.statementLength) {
                        this.error(23);
                    }
                    operation = 0;
                    if (isColorOrRadius) {
                        this.error(22);
                    }
                    isDelete = true;
                    continue block13;
                }
                default: {
                    this.error(22);
                }
            }
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (distanceCount < 2) {
            if (distanceCount == 0) {
                distances[0] = 1.0E8f;
            }
            distances[1] = distances[0];
            distances[0] = 0.1f;
        }
        if (translucency != null || !Float.isNaN(radius) || color != Integer.MIN_VALUE) {
            if (!haveType) {
                bondOrder = 16383;
            }
            if (!haveOperation) {
                operation = 1;
            }
        }
        int nNew = 0;
        int nModified = 0;
        if (expression2 > 0) {
            BitSet bs = new BitSet();
            this.definedAtomSets.put("_1", bs);
            for (int atom1 = atomSets[0].size(); atom1 >= 0; --atom1) {
                if (!atomSets[0].get(atom1)) continue;
                bs.set(atom1);
                int[] result = this.viewer.makeConnections(distances[0], distances[1], bondOrder, operation, bs, this.expression(expression2), bsBonds, isBonds);
                nNew += result[0];
                nModified += result[1];
                bs.clear(atom1);
            }
        } else {
            int[] result = this.viewer.makeConnections(distances[0], distances[1], bondOrder, operation, atomSets[0], atomSets[1], bsBonds, isBonds);
            nNew += result[0];
            nModified += result[1];
        }
        if (isDelete) {
            if (!this.tQuiet && this.scriptLevel <= this.scriptReportingLevel) {
                this.scriptStatusOrBuffer(GT._("{0} connections deleted", nModified));
            }
            return;
        }
        if (isColorOrRadius) {
            this.viewer.selectBonds(bsBonds);
            if (!Float.isNaN(radius)) {
                this.viewer.setShapeSize(1, (int)(radius * 2000.0f), Float.NaN, bsBonds);
            }
            if (color != Integer.MIN_VALUE) {
                this.viewer.setShapeProperty(1, "color", new Integer(color), bsBonds);
            }
            if (translucency != null) {
                if (translucentLevel == Float.MAX_VALUE) {
                    translucentLevel = this.viewer.getDefaultTranslucent();
                }
                this.viewer.setShapeProperty(1, "translucentLevel", new Float(translucentLevel));
                this.viewer.setShapeProperty(1, "translucency", translucency, bsBonds);
            }
        }
        if (!this.tQuiet && this.scriptLevel <= this.scriptReportingLevel) {
            this.scriptStatusOrBuffer(GT._("{0} new bonds; {1} modified", new Object[]{new Integer(nNew), new Integer(nModified)}));
        }
    }

    private float getTranslucentLevel(int i) throws ScriptException {
        float f = this.floatParameter(i);
        return this.theTok == 2 && f > 0.0f && f < 9.0f ? f + 1.0f : f;
    }

    private void getProperty() throws ScriptException {
        if (this.isSyntaxCheck) {
            return;
        }
        String retValue = "";
        String property = this.optParameterAsString(1);
        String param = this.optParameterAsString(2);
        int tok = this.tokAt(2);
        BitSet bs = tok == 0x100001 || tok == 0x40000007 ? this.expression(2) : null;
        int propertyID = PropertyManager.getPropertyNumber(property);
        if (property.length() > 0 && propertyID < 0) {
            property = "";
            param = "";
        } else if (propertyID >= 0 && this.statementLength < 3) {
            param = PropertyManager.getDefaultParam(propertyID);
            if (param.equals("(visible)")) {
                this.viewer.setModelVisibility();
                bs = this.viewer.getVisibleSet();
            }
        } else if (propertyID == 3) {
            for (int i = 3; i < this.statementLength; ++i) {
                param = param + this.parameterAsString(i);
            }
        }
        retValue = (String)this.viewer.getProperty("readable", property, bs == null ? param : bs);
        this.showString(retValue);
    }

    private void background(int i) throws ScriptException {
        this.getToken(i);
        if (this.theTok == 1073741945) {
            this.checkLength(3);
            if (this.isSyntaxCheck) {
                return;
            }
            Hashtable htParams = new Hashtable();
            String file = this.parameterAsString(++i);
            Object image = null;
            if (!file.equalsIgnoreCase("none") && file.length() > 0) {
                image = this.viewer.getFileAsImage(file, htParams);
            }
            if (image instanceof String) {
                this.evalError((String)image, null);
            }
            this.viewer.setBackgroundImage((String)htParams.get("fullPathName"), (Image)image);
            return;
        }
        if (this.isColorParam(i) || this.theTok == 0x10000B) {
            int argb = this.getArgbParamLast(i, true);
            if (!this.isSyntaxCheck) {
                this.viewer.setObjectArgb("background", argb);
            }
            return;
        }
        int iShape = this.getShapeType(this.theTok);
        this.colorShape(iShape, i + 1, true);
    }

    private void center(int i) throws ScriptException {
        if (this.statementLength == 1) {
            this.viewer.setNewRotationCenter(null);
            return;
        }
        Point3f center = this.centerParameter(i);
        if (center == null) {
            this.error(22);
        }
        if (!this.isSyntaxCheck) {
            this.viewer.setNewRotationCenter(center);
        }
    }

    private String setObjectProperty() throws ScriptException {
        String s = "";
        String id = this.getShapeNameParameter(2);
        if (this.isSyntaxCheck) {
            return "";
        }
        int iTok = this.iToken;
        int tokCommand = this.tokAt(0);
        boolean isWild = TextFormat.isWild(id);
        int iShape = 16;
        do {
            if (iShape != 24 && this.viewer.getShapeProperty(iShape, "checkID:" + id) != null) {
                this.setShapeProperty(iShape, "thisID", id);
                switch (tokCommand) {
                    case 12291: {
                        this.setShapeProperty(iShape, "delete", null);
                        break;
                    }
                    case 12293: 
                    case 536883204: {
                        this.setShapeProperty(iShape, "hidden", tokCommand == 536883204 ? Boolean.FALSE : Boolean.TRUE);
                        break;
                    }
                    case 4148: {
                        if (iShape == 22 && !isWild) {
                            return this.getIsosurfaceJvxl();
                        }
                        s = s + (String)this.viewer.getShapeProperty(iShape, "command") + "\n";
                    }
                    case 558895366: {
                        this.colorShape(iShape, iTok + 1, false);
                    }
                }
                if (!isWild) break;
            }
            if (iShape != 16) continue;
            iShape = 27;
        } while (--iShape >= 21);
        return s;
    }

    private void color() throws ScriptException {
        int argb = 0;
        if (this.isColorParam(1)) {
            this.colorObject(0x4100001, 1);
            return;
        }
        switch (this.getToken((int)1).tok) {
            case 0x100007: {
                this.setObjectProperty();
                return;
            }
            case 0x10000B: 
            case 0x300001: 
            case 0xD00003: 
            case 0xD00004: 
            case 0xD00006: 
            case 0xD0000A: 
            case 22020109: 
            case 22020115: 
            case 30412803: 
            case 38797327: 
            case 38797328: 
            case 38797578: 
            case 38797585: 
            case 38797589: 
            case 39325966: 
            case 558891272: 
            case 642777357: 
            case 0x40000011: 
            case 1073741847: 
            case 1073741853: 
            case 1073741861: 
            case 1073741869: 
            case 1073741879: 
            case 1073741887: 
            case 0x40000042: {
                this.colorObject(0x4100001, 1);
                return;
            }
            case 4: {
                String strColor = this.stringParameter(1);
                this.setStringProperty("propertyColorSchemeOverLoad", strColor);
                if (this.tokAt(2) == 1073741868 || this.tokAt(2) == 0x40000001) {
                    float min = this.floatParameter(3);
                    float max = this.floatParameter(4);
                    if (!this.isSyntaxCheck) {
                        this.viewer.setCurrentColorRange(min, max);
                    }
                }
                return;
            }
            case 0x40000001: 
            case 1073741868: {
                this.checkLength(4);
                float min = this.floatParameter(2);
                float max = this.floatParameter(3);
                if (!this.isSyntaxCheck) {
                    this.viewer.setCurrentColorRange(min, max);
                }
                return;
            }
            case 536875012: {
                argb = this.getArgbParamLast(2, true);
                if (!this.isSyntaxCheck) {
                    this.viewer.setObjectArgb("background", argb);
                }
                return;
            }
            case 0x100001: 
            case 0x40000007: {
                this.colorObject(0x4100001, -1);
                return;
            }
            case 0x40000033: {
                argb = this.getArgbParamLast(2, false);
                if (!this.isSyntaxCheck) {
                    this.viewer.setRubberbandArgb(argb);
                }
                return;
            }
            case 537399347: {
                int i = 2;
                if (this.tokAt(2) == 1073741861) {
                    ++i;
                }
                argb = this.getArgbParamLast(i, true);
                if (this.isSyntaxCheck) {
                    return;
                }
                this.viewer.loadShape(8);
                this.setShapeProperty(8, "argbSelection", new Integer(argb));
                return;
            }
            case 1: 
            case 537399298: 
            case 540016644: 
            case 540545088: 
            case 605556745: {
                String str = this.parameterAsString(1);
                if (this.checkToken(2)) {
                    switch (this.getToken((int)2).tok) {
                        case 1073741869: {
                            argb = 1073741869;
                            break;
                        }
                        case 0x10000B: 
                        case 1073741847: {
                            argb = 1073741847;
                            break;
                        }
                        default: {
                            argb = this.getArgbParam(2);
                        }
                    }
                }
                if (argb == 0) {
                    this.error(9);
                }
                this.checkLength(this.iToken + 1);
                if (str.equalsIgnoreCase("axes")) {
                    this.setStringProperty("axesColor", Escape.escapeColor(argb));
                    return;
                }
                if (StateManager.getObjectIdFromName(str) >= 0) {
                    if (!this.isSyntaxCheck) {
                        this.viewer.setObjectArgb(str, argb);
                    }
                    return;
                }
                if (this.changeElementColor(str, argb)) {
                    return;
                }
                this.error(22);
                break;
            }
            case 4125: {
                this.setShapeProperty(22, "thisID", "+PREVIOUS_MESH+");
            }
            default: {
                this.colorObject(this.theTok, 2);
            }
        }
    }

    private boolean changeElementColor(String str, int argb) {
        int i = JmolConstants.elementNumberMax;
        while (--i >= 0) {
            if (!str.equalsIgnoreCase(JmolConstants.elementNameFromNumber(i))) continue;
            if (!this.isSyntaxCheck) {
                this.viewer.setElementArgb(i, argb);
            }
            return true;
        }
        i = JmolConstants.altElementMax;
        while (--i >= 0) {
            if (!str.equalsIgnoreCase(JmolConstants.altElementNameFromIndex(i))) continue;
            if (!this.isSyntaxCheck) {
                this.viewer.setElementArgb(JmolConstants.altElementNumberFromIndex(i), argb);
            }
            return true;
        }
        if (str.charAt(0) != '_') {
            return false;
        }
        i = JmolConstants.elementNumberMax;
        while (--i >= 0) {
            if (!str.equalsIgnoreCase("_" + JmolConstants.elementSymbolFromNumber(i))) continue;
            if (!this.isSyntaxCheck) {
                this.viewer.setElementArgb(i, argb);
            }
            return true;
        }
        i = JmolConstants.altElementMax;
        while (--i >= 4) {
            if (str.equalsIgnoreCase("_" + JmolConstants.altElementSymbolFromIndex(i))) {
                if (!this.isSyntaxCheck) {
                    this.viewer.setElementArgb(JmolConstants.altElementNumberFromIndex(i), argb);
                }
                return true;
            }
            if (!str.equalsIgnoreCase("_" + JmolConstants.altIsotopeSymbolFromIndex(i))) continue;
            if (!this.isSyntaxCheck) {
                this.viewer.setElementArgb(JmolConstants.altElementNumberFromIndex(i), argb);
            }
            return true;
        }
        return false;
    }

    private void colorObject(int tokObject, int index) throws ScriptException {
        this.colorShape(this.getShapeType(tokObject), index, false);
    }

    private void colorShape(int shapeType, int index, boolean isBackground) throws ScriptException {
        String translucency = null;
        Number colorvalue = null;
        BitSet bs = null;
        String prefix = "";
        boolean isColor = false;
        int typeMask = 0;
        float translucentLevel = Float.MAX_VALUE;
        if (index < 0) {
            bs = this.expression(-index);
            index = this.iToken + 1;
            if (this.isBondSet) {
                shapeType = 1;
            }
        }
        if (isBackground) {
            this.getToken(index);
        } else {
            isBackground = this.getToken((int)index).tok == 536875012;
            if (isBackground) {
                this.getToken(++index);
            }
        }
        if (isBackground) {
            prefix = "bg";
        }
        if (!this.isSyntaxCheck && shapeType == 24 && !this.mo(true)) {
            return;
        }
        if (this.theTok == 1073741887 || this.theTok == 1073741861) {
            translucency = this.parameterAsString(index++);
            if (this.theTok == 1073741887 && this.isFloatParameter(index)) {
                translucentLevel = this.getTranslucentLevel(index++);
            }
        }
        int tok = 0;
        if (index < this.statementLength && this.tokAt(index) != 0x10000D && this.tokAt(index) != 0x10000C) {
            isColor = true;
            tok = this.getToken((int)index).tok;
            if (this.isColorParam(index)) {
                int argb = this.getArgbParam(index, false);
                Integer n = colorvalue = argb == 0 ? null : new Integer(argb);
                if (translucency == null && this.tokAt(index = this.iToken + 1) != 0) {
                    this.getToken(index);
                    if (translucency == null && (this.theTok == 1073741887 || this.theTok == 1073741861)) {
                        translucency = this.parameterAsString(index);
                        if (this.theTok == 1073741887 && this.isFloatParameter(index + 1)) {
                            translucentLevel = this.getTranslucentLevel(++index);
                        }
                    }
                }
            } else if (shapeType == 23) {
                --this.iToken;
            } else {
                int pid;
                boolean isColorIndex;
                String name = this.parameterAsString(index).toLowerCase();
                boolean isByElement = name.indexOf("byelement") == 0;
                boolean bl = isColorIndex = isByElement || name.indexOf("byresidue") == 0;
                int n = isColorIndex || shapeType == 22 ? 84 : (pid = tok == 39325966 ? 1 : (int)JmolConstants.getPaletteID(name));
                if (pid == -1 || (pid == 18 || pid == 19) && shapeType != 2) {
                    this.error(22);
                }
                Object data = null;
                if (pid == 84) {
                    if (isColorIndex) {
                        if (!this.isSyntaxCheck) {
                            data = this.getBitsetProperty(null, (isByElement ? 22020359 : 22020105) | 0xE0, null, null, null, null, false, Integer.MAX_VALUE);
                        }
                    } else {
                        if (!isColorIndex && shapeType != 22) {
                            ++index;
                        }
                        if (name.equals("property") && Token.tokAttr(tok = this.getToken((int)index).tok, 0x500000) && !Token.tokAttr(tok, 0xD00000) && !this.isSyntaxCheck) {
                            data = this.getBitsetProperty(null, this.getToken((int)index++).tok | 0xE0, null, null, null, null, false, Integer.MAX_VALUE);
                        }
                    }
                    if (data != null && !(data instanceof float[])) {
                        if (data instanceof String[]) {
                            float[] fdata = new float[((String[])data).length];
                            Parser.parseFloatArray((String[])data, null, fdata);
                            data = fdata;
                        } else {
                            this.error(22);
                        }
                    }
                } else if (pid == 85) {
                    int n2 = ++index;
                    ++index;
                    name = this.parameterAsString(n2);
                    data = new float[this.viewer.getAtomCount()];
                    Parser.parseFloatArray("" + this.getParameter(name, false), null, data);
                    pid = 84;
                }
                if (pid == 84) {
                    String scheme;
                    String string = scheme = this.tokAt(index) == 4 ? this.parameterAsString(index++).toLowerCase() : null;
                    if (scheme != null) {
                        this.setStringProperty("propertyColorScheme", scheme);
                        isColorIndex = scheme.indexOf("byelement") == 0 || scheme.indexOf("byresidue") == 0;
                    }
                    float min = 0.0f;
                    float max = Float.MAX_VALUE;
                    if (!(isColorIndex || this.tokAt(index) != 0x40000001 && this.tokAt(index) != 1073741868)) {
                        min = this.floatParameter(index + 1);
                        max = this.floatParameter(index + 2);
                        index += 3;
                        if (min == max && shapeType == 22) {
                            float[] range = (float[])this.viewer.getShapeProperty(shapeType, "dataRange");
                            if (range != null) {
                                min = range[0];
                                max = range[1];
                            }
                        } else if (min == max) {
                            max = Float.MAX_VALUE;
                        }
                    }
                    if (!this.isSyntaxCheck) {
                        if (shapeType != 22 && max != -3.4028235E38f) {
                            if (data == null) {
                                this.viewer.setCurrentColorRange(name);
                            } else {
                                this.viewer.setCurrentColorRange((float[])data, null);
                            }
                        }
                        if (max != Float.MAX_VALUE) {
                            this.viewer.setCurrentColorRange(min, max);
                        }
                    }
                    if (shapeType == 22) {
                        prefix = "remap";
                    }
                } else {
                    ++index;
                }
                colorvalue = new Byte((byte)pid);
                this.checkLength(index);
            }
        }
        if (this.isSyntaxCheck || shapeType < 0) {
            return;
        }
        int n = shapeType == 2 ? 30720 : (shapeType == 3 ? 256 : (typeMask = shapeType == 1 ? 1023 : 0));
        if (typeMask == 0) {
            this.viewer.loadShape(shapeType);
            if (shapeType == 4) {
                this.setShapeProperty(4, "setDefaults", this.viewer.getNoneSelected());
            }
        } else {
            if (bs != null) {
                this.viewer.selectBonds(bs);
                bs = null;
            }
            shapeType = 1;
            this.setShapeProperty(shapeType, "type", new Integer(typeMask));
        }
        if (isColor) {
            switch (tok) {
                case 38797327: 
                case 38797328: {
                    this.viewer.autoCalculate(tok);
                    break;
                }
                case 38797585: {
                    if (!this.viewer.isRangeSelected()) break;
                    this.viewer.clearBfactorRange();
                    break;
                }
                case 0xD00006: {
                    this.viewer.calcSelectedGroupsCount();
                    break;
                }
                case 1073741853: {
                    this.viewer.calcSelectedMonomersCount();
                    break;
                }
                case 22020109: {
                    this.viewer.calcSelectedMoleculesCount();
                }
            }
            if (bs == null) {
                this.viewer.setShapeProperty(shapeType, prefix + "color", colorvalue);
            } else {
                this.viewer.setShapeProperty(shapeType, prefix + "color", colorvalue, bs);
            }
        }
        if (translucency != null) {
            this.setShapeTranslucency(shapeType, prefix, translucency, translucentLevel, bs);
        }
        if (typeMask != 0) {
            this.viewer.setShapeProperty(1, "type", new Integer(1023));
        }
    }

    private void setShapeTranslucency(int shapeType, String prefix, String translucency, float translucentLevel, BitSet bs) {
        if (translucentLevel == Float.MAX_VALUE) {
            translucentLevel = this.viewer.getDefaultTranslucent();
        }
        this.setShapeProperty(shapeType, "translucentLevel", new Float(translucentLevel));
        if (prefix == null) {
            return;
        }
        if (bs == null) {
            this.setShapeProperty(shapeType, prefix + "translucency", translucency);
        } else if (!this.isSyntaxCheck) {
            this.viewer.setShapeProperty(shapeType, prefix + "translucency", translucency, bs);
        }
    }

    private void cd() throws ScriptException {
        if (this.isSyntaxCheck) {
            return;
        }
        String dir = this.statementLength == 1 ? null : this.parameterAsString(1);
        this.showString(this.viewer.cd(dir));
    }

    private void data() throws ScriptException {
        boolean processModel;
        String dataString = null;
        String dataLabel = null;
        boolean isOneValue = false;
        this.iToken = this.statementLength;
        switch (this.iToken) {
            case 5: {
                dataString = this.parameterAsString(2);
            }
            case 2: 
            case 4: {
                dataLabel = this.parameterAsString(1);
                if (dataLabel.equalsIgnoreCase("clear")) {
                    if (!this.isSyntaxCheck) {
                        this.viewer.setData(null, null, 0, 0, 0, 0, 0);
                    }
                    return;
                }
                int i = dataLabel.indexOf("@");
                if (i >= 0) {
                    dataString = "" + this.getParameter(dataLabel.substring(i + 1), false);
                    dataLabel = dataLabel.substring(0, i).trim();
                    break;
                }
                if (dataString != null || (i = dataLabel.indexOf(" ")) < 0) break;
                dataString = dataLabel.substring(i + 1).trim();
                dataLabel = dataLabel.substring(0, i).trim();
                isOneValue = true;
                break;
            }
            default: {
                this.error(2);
            }
        }
        dataLabel = dataLabel.toLowerCase();
        String dataType = dataLabel + " ";
        dataType = dataType.substring(0, dataType.indexOf(" "));
        boolean isModel = dataType.equals("model");
        boolean isAppend = dataType.equals("append");
        boolean bl = processModel = !(!isModel && !isAppend || this.isSyntaxCheck && !this.isCmdLine_C_Option);
        if ((isModel || isAppend) && dataString == null) {
            this.error(22);
        }
        int userType = -1;
        if (processModel) {
            char newLine = this.viewer.getInlineChar();
            if (dataString.length() > 0 && dataString.charAt(0) != newLine) {
                newLine = '\u0000';
            }
            int modelCount = this.viewer.getModelCount() - (this.viewer.getFileName().equals("zapped") ? 1 : 0);
            boolean appendNew = this.viewer.getAppendNew();
            this.viewer.loadInline(dataString, newLine, isAppend);
            if (isAppend && appendNew) {
                this.viewer.setAnimationRange(-1, -1);
                this.viewer.setCurrentModelIndex(modelCount);
            }
        }
        if (this.isSyntaxCheck && !processModel) {
            return;
        }
        this.data = new Object[3];
        if (dataType.equals("element_vdw")) {
            this.data[0] = dataType;
            this.data[1] = dataString.replace(';', '\n');
            int n = JmolConstants.elementNumberMax;
            int[] eArray = new int[n + 1];
            for (int ie = 1; ie <= n; ++ie) {
                eArray[ie] = ie;
            }
            this.data[2] = eArray;
            this.viewer.setData("element_vdw", this.data, n, 0, 0, 0, 0);
            return;
        }
        if (dataType.indexOf("data2d_") == 0) {
            this.data[0] = dataLabel;
            this.data[1] = Parser.parseFloatArray2d(dataString);
            this.viewer.setData(dataLabel, this.data, 0, 0, 0, 0, 0);
            return;
        }
        String[] tokens = Parser.getTokens(dataLabel);
        if (!(dataType.indexOf("property_") != 0 || tokens.length == 2 && tokens[1].equals("set"))) {
            int propertyFieldColumnCount;
            BitSet bs = this.viewer.getSelectionSet();
            this.data[0] = dataType;
            int atomNumberField = isOneValue ? 0 : (Integer)this.viewer.getParameter("propertyAtomNumberField");
            int atomNumberFieldColumnCount = isOneValue ? 0 : (Integer)this.viewer.getParameter("propertyAtomNumberColumnCount");
            int propertyField = isOneValue ? Integer.MIN_VALUE : (Integer)this.viewer.getParameter("propertyDataField");
            int n = propertyFieldColumnCount = isOneValue ? 0 : (Integer)this.viewer.getParameter("propertyDataColumnCount");
            if (!isOneValue && dataLabel.indexOf(" ") >= 0) {
                if (tokens.length == 3) {
                    dataLabel = tokens[0];
                    atomNumberField = Parser.parseInt(tokens[1]);
                    propertyField = Parser.parseInt(tokens[2]);
                }
                if (tokens.length == 5) {
                    dataLabel = tokens[0];
                    atomNumberField = Parser.parseInt(tokens[1]);
                    atomNumberFieldColumnCount = Parser.parseInt(tokens[2]);
                    propertyField = Parser.parseInt(tokens[3]);
                    propertyFieldColumnCount = Parser.parseInt(tokens[4]);
                }
            }
            if (atomNumberField < 0) {
                atomNumberField = 0;
            }
            if (propertyField < 0) {
                propertyField = 0;
            }
            int atomCount = this.viewer.getAtomCount();
            int[] atomMap = null;
            BitSet bsAtoms = new BitSet(atomCount);
            if (atomNumberField > 0) {
                int j;
                atomMap = new int[atomCount + 2];
                for (j = 0; j <= atomCount; ++j) {
                    atomMap[j] = -1;
                }
                for (j = 0; j < atomCount; ++j) {
                    int atomNo;
                    if (!bs.get(j) || (atomNo = this.viewer.getAtomNumber(j)) > atomCount + 1 || atomNo < 0 || bsAtoms.get(atomNo)) continue;
                    bsAtoms.set(atomNo);
                    atomMap[atomNo] = j;
                }
                this.data[2] = atomMap;
            } else {
                this.data[2] = bs;
            }
            this.data[1] = dataString;
            this.viewer.setData(dataType, this.data, atomCount, atomNumberField, atomNumberFieldColumnCount, propertyField, propertyFieldColumnCount);
            return;
        }
        userType = AtomCollection.getUserSettableType(dataType);
        if (userType >= 0) {
            this.viewer.setAtomData(userType, dataType, dataString);
            return;
        }
        this.data[0] = dataLabel;
        this.data[1] = dataString;
        this.viewer.setData(dataType, this.data, 0, 0, 0, 0, 0);
    }

    private void define() throws ScriptException {
        boolean isDynamic;
        String setName = (String)this.getToken((int)1).value;
        BitSet bs = this.expression(2);
        if (this.isSyntaxCheck) {
            return;
        }
        boolean bl = isDynamic = setName.indexOf("dynamic_") == 0;
        if (isDynamic) {
            Token[] code = new Token[this.statementLength];
            int i = this.statementLength;
            while (--i >= 0) {
                code[i] = this.statement[i];
            }
            this.definedAtomSets.put("!" + setName.substring(8), code);
            this.viewer.addStateScript(this.thisCommand, false, true);
        } else {
            this.definedAtomSets.put(setName, bs);
            this.setStringProperty("@" + setName, Escape.escape(bs));
        }
    }

    private void echo(int index, boolean isImage) throws ScriptException {
        if (this.isSyntaxCheck) {
            return;
        }
        String text = this.optParameterAsString(index);
        if (this.viewer.getEchoStateActive()) {
            if (isImage) {
                Hashtable htParams = new Hashtable();
                Object image = this.viewer.getFileAsImage(text, htParams);
                if (image instanceof String) {
                    text = (String)image;
                } else {
                    this.setShapeProperty(26, "text", htParams.get("fullPathName"));
                    this.setShapeProperty(26, "image", image);
                    text = null;
                }
            } else if (text.startsWith("\u0000")) {
                text = text.substring(1);
                isImage = true;
            }
            if (text != null) {
                this.setShapeProperty(26, "text", text);
            }
        }
        if (!isImage && this.viewer.getRefreshing()) {
            this.showString(this.viewer.formatText(text));
        }
    }

    private void message() throws ScriptException {
        this.checkLength(2);
        String text = this.parameterAsString(1);
        if (this.isSyntaxCheck) {
            return;
        }
        String s = this.viewer.formatText(text);
        if (this.outputBuffer == null) {
            this.viewer.showMessage(s);
        }
        if (!s.startsWith("_")) {
            this.scriptStatusOrBuffer(s);
        }
    }

    private void print() throws ScriptException {
        if (this.statementLength == 1) {
            this.error(2);
        }
        String s = (String)this.parameterExpression(1, 0, "", false);
        if (this.isSyntaxCheck) {
            return;
        }
        if (this.outputBuffer != null) {
            this.outputBuffer.append(s).append('\n');
        } else {
            this.viewer.showString(s, true);
        }
    }

    private boolean pause() throws ScriptException {
        if (this.isSyntaxCheck) {
            return false;
        }
        String msg = this.optParameterAsString(1);
        if (!this.viewer.getBooleanProperty("_useCommandThread")) {
            // empty if block
        }
        if (this.viewer.autoExit || !this.viewer.haveDisplay) {
            return false;
        }
        if (this.scriptLevel == 0 && this.pc == this.aatoken.length - 1) {
            this.viewer.scriptStatus("nothing to pause: " + msg);
            return false;
        }
        msg = msg.length() == 0 ? ": RESUME to continue." : ": " + this.viewer.formatText(msg);
        this.pauseExecution();
        this.viewer.scriptStatus("script execution paused" + msg, "script paused for RESUME");
        return true;
    }

    private void label(int index) throws ScriptException {
        String strLabel;
        if (this.isSyntaxCheck) {
            return;
        }
        if ((strLabel = this.parameterAsString(index++)).equalsIgnoreCase("on")) {
            strLabel = this.viewer.getStandardLabelFormat();
        } else if (strLabel.equalsIgnoreCase("off")) {
            strLabel = null;
        }
        this.viewer.loadShape(4);
        this.viewer.setLabel(strLabel);
    }

    private void hover() throws ScriptException {
        if (this.isSyntaxCheck) {
            return;
        }
        String strLabel = this.parameterAsString(1);
        if (strLabel.equalsIgnoreCase("on")) {
            strLabel = "%U";
        } else if (strLabel.equalsIgnoreCase("off")) {
            strLabel = null;
        }
        this.viewer.loadShape(30);
        this.setShapeProperty(30, "label", strLabel);
    }

    private void load() throws ScriptException {
        String script;
        Point3f pt;
        String filename;
        boolean isAppend = false;
        Vector<Object> firstLastSteps = null;
        int modelCount = this.viewer.getModelCount() - (this.viewer.getFileName().equals("zapped") ? 1 : 0);
        boolean appendNew = this.viewer.getAppendNew();
        boolean atomDataOnly = false;
        StringBuffer loadScript = new StringBuffer("load");
        int nFiles = 1;
        Hashtable<String, Object> htParams = new Hashtable<String, Object>();
        int i = 1;
        String modelName = null;
        int tokType = 0;
        boolean needToLoad = true;
        String sOptions = "";
        if (this.statementLength == 1) {
            i = 0;
        } else {
            modelName = this.parameterAsString(1);
            if (this.tokAt(1) == 1 || modelName.equals("fileset")) {
                if (modelName.equals("menu")) {
                    this.checkLength(3);
                    if (!this.isSyntaxCheck) {
                        this.viewer.setMenu(this.parameterAsString(2), true);
                    }
                    return;
                }
                i = 2;
                loadScript.append(" " + modelName);
                isAppend = modelName.equalsIgnoreCase("append");
                atomDataOnly = Parser.isOneOf(modelName.toLowerCase(), "xyz;vxyz;vibration;temperature;occupancy;partialcharge");
                if (atomDataOnly) {
                    htParams.put("atomDataOnly", Boolean.TRUE);
                    htParams.put("modelNumber", new Integer(1));
                    isAppend = true;
                    tokType = Token.getTokenFromName((String)modelName.toLowerCase()).tok;
                    if (tokType == 4162) {
                        tokType = 72352013;
                    }
                }
                if (isAppend && ((filename = this.optParameterAsString(2)).equalsIgnoreCase("trajectory") || filename.equalsIgnoreCase("models"))) {
                    modelName = filename;
                    loadScript.append(" " + modelName);
                    ++i;
                }
                if (modelName.equalsIgnoreCase("trajectory") || modelName.equalsIgnoreCase("models")) {
                    if (modelName.equalsIgnoreCase("trajectory")) {
                        htParams.put("isTrajectory", Boolean.TRUE);
                    }
                    if (this.isPoint3f(i)) {
                        pt = this.getPoint3f(i, false);
                        i = this.iToken + 1;
                        htParams.put("firstLastStep", new int[]{(int)pt.x, (int)pt.y, (int)pt.z});
                        loadScript.append(" " + Escape.escape(pt));
                    } else if (this.tokAt(i) == 0x40000007) {
                        htParams.put("bsModels", (BitSet)this.getToken((int)i++).value);
                    } else {
                        htParams.put("firstLastStep", new int[]{0, -1, 1});
                    }
                }
            } else {
                modelName = "fileset";
            }
            if (this.getToken((int)i).tok != 4) {
                this.error(16);
            }
        }
        if (this.statementLength == i + 1) {
            if (i == 0 || (filename = this.parameterAsString(i)).length() == 0) {
                filename = this.viewer.getFullPathName();
            }
            if (filename == null) {
                this.zap(false);
                return;
            }
            if (filename.equals("string[]")) {
                return;
            }
        } else if (this.getToken((int)(i + 1)).tok == 0x10000A || this.theTok == 7 || this.theTok == 2 || this.theTok == 1 && this.tokAt(i + 3) != 0x100006) {
            if ((filename = this.parameterAsString(i++)).length() == 0) {
                filename = this.viewer.getFullPathName();
            }
            if (filename == null) {
                this.zap(false);
                return;
            }
            if (filename.equals("string[]")) {
                return;
            }
            int tok = this.tokAt(i);
            if (tok == 1 && this.parameterAsString(i).equalsIgnoreCase("manifest")) {
                String manifest = this.stringParameter(++i);
                htParams.put("manifest", manifest);
                sOptions = sOptions + " MANIFEST " + Escape.escape(manifest);
                tok = this.tokAt(++i);
            }
            if (tok == 2) {
                int modelNumber = this.intParameter(i);
                sOptions = sOptions + " " + modelNumber;
                htParams.put("modelNumber", new Integer(modelNumber));
                tok = this.tokAt(++i);
            }
            Point3f lattice = null;
            if (tok == 0x10000A || tok == 7) {
                lattice = this.getPoint3f(i, false);
                i = this.iToken + 1;
                tok = this.tokAt(i);
                sOptions = sOptions + " " + Escape.escape(lattice);
            }
            if (tok == 1 && this.parameterAsString(i).equalsIgnoreCase("packed")) {
                if (lattice == null) {
                    lattice = new Point3f(555.0f, 555.0f, -1.0f);
                }
                htParams.put("packed", Boolean.TRUE);
                sOptions = sOptions + " PACKED";
            }
            if (lattice != null) {
                i = this.iToken + 1;
                htParams.put("lattice", lattice);
                sOptions = sOptions + " {" + (int)lattice.x + " " + (int)lattice.y + " " + (int)lattice.z + "}";
                int iGroup = -1;
                float distance = 0.0f;
                if (this.tokAt(i) == 1073741868) {
                    int n = ++i;
                    ++i;
                    distance = this.floatParameter(n);
                    sOptions = sOptions + " range " + distance;
                }
                htParams.put("symmetryRange", new Float(distance));
                if (this.tokAt(i) == 1073741881) {
                    int n = ++i;
                    ++i;
                    String spacegroup = TextFormat.simpleReplace(this.parameterAsString(n), "''", "\"");
                    sOptions = sOptions + " spacegroup " + Escape.escape(spacegroup);
                    if (spacegroup.equalsIgnoreCase("ignoreOperators")) {
                        iGroup = -999;
                    } else {
                        if (spacegroup.indexOf(",") >= 0 && lattice.x < 9.0f && lattice.y < 9.0f && lattice.z == 0.0f) {
                            spacegroup = spacegroup + "#doNormalize=0";
                        }
                        if ((iGroup = this.viewer.getSymmetry().determineSpaceGroupIndex(spacegroup)) == -1) {
                            iGroup = -2;
                        }
                        htParams.put("spaceGroupName", spacegroup);
                    }
                    htParams.put("spaceGroupIndex", new Integer(iGroup));
                }
                if (this.tokAt(i) == 540545088) {
                    ++i;
                    htParams.put("spaceGroupIndex", new Integer(iGroup));
                    float[] fparams = new float[6];
                    i = this.floatParameterSet(i, fparams);
                    sOptions = sOptions + " unitcell {";
                    for (int j = 0; j < 6; ++j) {
                        sOptions = sOptions + (j == 0 ? "" : " ") + fparams[j];
                    }
                    sOptions = sOptions + "}";
                    htParams.put("unitcell", fparams);
                }
            }
            if (this.tokAt(i) == 1 && this.parameterAsString(i).equalsIgnoreCase("filter")) {
                String filter = this.stringParameter(++i);
                htParams.put("filter", filter);
                sOptions = sOptions + " FILTER " + Escape.escape(filter);
            }
        } else {
            if (i != 2) {
                modelName = this.parameterAsString(i++);
                loadScript.append(" ").append(Escape.escape(modelName));
            }
            pt = null;
            BitSet bs = null;
            Vector<String> fNames = new Vector<String>();
            block5: while (i < this.statementLength) {
                switch (this.tokAt(i)) {
                    case 1: {
                        String s = this.parameterAsString(i);
                        if (s.equalsIgnoreCase("filter")) {
                            String filter = this.stringParameter(++i);
                            htParams.put("filter", filter);
                            loadScript.append(" FILTER ").append(Escape.escape(filter));
                            ++i;
                            continue block5;
                        }
                        this.error(22);
                        break;
                    }
                    case 0x100006: {
                        htParams.remove("isTrajectory");
                        if (firstLastSteps == null) {
                            firstLastSteps = new Vector<Object>();
                            pt = new Point3f(0.0f, -1.0f, 1.0f);
                        }
                        if (this.isPoint3f(++i)) {
                            pt = this.getPoint3f(i, false);
                            i = this.iToken + 1;
                            break;
                        }
                        if (this.tokAt(i) != 0x40000007) break;
                        bs = (BitSet)this.getToken((int)i).value;
                        pt = null;
                        i = this.iToken + 1;
                    }
                }
                filename = this.parameterAsString(i++);
                fNames.add(filename);
                if (pt != null) {
                    firstLastSteps.addElement(new int[]{(int)pt.x, (int)pt.y, (int)pt.z});
                    loadScript.append(" COORD " + Escape.escape(pt));
                } else if (bs != null) {
                    firstLastSteps.addElement(bs);
                    loadScript.append(" COORD " + Escape.escape(bs));
                }
                loadScript.append(" /*file*/").append(Escape.escape(filename));
            }
            if (firstLastSteps != null) {
                htParams.put("firstLastSteps", firstLastSteps);
            }
            nFiles = fNames.size();
            filename = "";
            String[] filenames = new String[nFiles];
            for (int j = 0; j < nFiles; ++j) {
                filenames[j] = (String)fNames.get(j);
                filename = filename + (j == 0 ? "" : "; ") + filenames[j];
            }
            if (!this.isSyntaxCheck || this.isCmdLine_C_Option) {
                this.viewer.openFiles(modelName, filenames, null, isAppend, htParams);
            }
            needToLoad = false;
        }
        if (needToLoad && (!this.isSyntaxCheck || this.isCmdLine_C_Option)) {
            if (filename.startsWith("@") && filename.length() > 1) {
                htParams.put("fileData", this.getStringParameter(filename.substring(1), false));
                filename = "string";
            }
            this.viewer.openFile(filename, htParams, null, isAppend);
            loadScript.append(" ");
            if (!filename.equals("string") && !filename.equals("string[]")) {
                loadScript.append("/*file*/");
            }
            modelName = (String)htParams.get("fullPathName");
            loadScript.append(Escape.escape(modelName));
            loadScript.append(sOptions);
        }
        if (this.isSyntaxCheck && !this.isCmdLine_C_Option) {
            this.viewer.deallocateReaderThreads();
            return;
        }
        String errMsg = null;
        if (atomDataOnly) {
            errMsg = this.viewer.loadAtomDataAndReturnError(tokType);
        } else {
            this.viewer.addLoadScript(loadScript.toString());
            errMsg = this.viewer.createModelSetAndReturnError(isAppend);
        }
        if (errMsg != null && !this.isCmdLine_c_or_C_Option) {
            if (errMsg.indexOf("file recognized as a script file:") >= 0) {
                this.viewer.addLoadScript("-");
                this.script(135271429);
                return;
            }
            this.evalError(errMsg, null);
        }
        if (isAppend && (appendNew || nFiles > 1)) {
            this.viewer.setAnimationRange(-1, -1);
            this.viewer.setCurrentModelIndex(modelCount);
        }
        if (this.logMessages) {
            this.scriptStatusOrBuffer("Successfully loaded:" + modelName);
        }
        String defaultScript = this.viewer.getDefaultLoadScript();
        String msg = "";
        if (defaultScript.length() > 0) {
            msg = msg + "\nUsing defaultLoadScript: " + defaultScript;
        }
        if ((script = (String)this.viewer.getModelSetAuxiliaryInfo("jmolscript")) != null && this.viewer.getAllowEmbeddedScripts()) {
            msg = msg + "\nAdding embedded #jmolscript: " + script;
            defaultScript = defaultScript + ";" + script;
            defaultScript = "allowEmbeddedScripts = false;" + defaultScript + ";allowEmbeddedScripts = true;";
        }
        if (msg.length() > 0) {
            Logger.info(msg);
        }
        if (defaultScript.length() > 0 && !this.isCmdLine_c_or_C_Option) {
            this.runScript(defaultScript);
        }
    }

    private String getFullPathName() throws ScriptException {
        String filename;
        String string = filename = !this.isSyntaxCheck || this.isCmdLine_C_Option ? this.viewer.getFullPathName() : "test.xyz";
        if (filename == null) {
            this.error(22);
        }
        return filename;
    }

    private void dataFrame(int datatype) throws ScriptException {
        String script;
        boolean isQuaternion = false;
        boolean isDraw = this.tokAt(0) == 4112;
        int pt0 = isDraw ? 1 : 0;
        boolean isDerivative = false;
        boolean isSecondDerivative = false;
        boolean isRamachandranRelative = false;
        int pt = this.statementLength - 1;
        String type = this.optParameterAsString(pt).toLowerCase();
        switch (datatype) {
            case 0: {
                if (type.equalsIgnoreCase("draw")) {
                    isDraw = true;
                    type = this.optParameterAsString(--pt).toLowerCase();
                }
                isRamachandranRelative = pt > pt0 && type.startsWith("r");
                type = "ramachandran" + (isRamachandranRelative ? " r" : "") + (isDraw ? " draw" : "");
                break;
            }
            case 1: {
                isQuaternion = true;
                if (type.equalsIgnoreCase("draw")) {
                    isDraw = true;
                    type = this.optParameterAsString(--pt).toLowerCase();
                }
                isDerivative = type.startsWith("deriv") || type.startsWith("diff");
                boolean bl = isSecondDerivative = isDerivative && type.indexOf("2") > 0;
                if (isDerivative) {
                    --pt;
                }
                if ((type = ((pt <= pt0 ? "" : this.optParameterAsString(pt)) + "w").substring(0, 1)) == "a" || type == "r") {
                    isDerivative = true;
                }
                if (!Parser.isOneOf(type, "w;x;y;z;r;a")) {
                    this.evalError("QUATERNION [w,x,y,z,a,r] [difference][2]", null);
                }
                type = "quaternion " + type + (isDerivative ? " difference" : "") + (isSecondDerivative ? "2" : "") + (isDraw ? " draw" : "");
            }
        }
        if (this.isSyntaxCheck) {
            return;
        }
        int modelIndex = this.viewer.getCurrentModelIndex();
        if (modelIndex < 0) {
            this.error(30, type);
        }
        modelIndex = this.viewer.getJmolDataSourceFrame(modelIndex);
        if (isDraw) {
            this.runScript(this.viewer.getPdbData(modelIndex, type));
            return;
        }
        int ptDataFrame = this.viewer.getJmolDataFrameIndex(modelIndex, type);
        if (isQuaternion && ptDataFrame < 0 && this.statementLength == 1) {
            ptDataFrame = this.viewer.getJmolDataFrameIndex(modelIndex, "quaternion");
        }
        if (ptDataFrame > 0) {
            this.viewer.setCurrentModelIndex(ptDataFrame, true);
            return;
        }
        this.viewer.addStateScript(type, true, false);
        String[] savedFileInfo = this.viewer.getFileInfo();
        boolean oldAppendNew = this.viewer.getAppendNew();
        this.viewer.setAppendNew(true);
        String data = this.viewer.getPdbData(modelIndex, type);
        boolean isOK = data != null && this.viewer.loadInline(data, '\n', true) == null;
        this.viewer.setAppendNew(oldAppendNew);
        this.viewer.setFileInfo(savedFileInfo);
        if (!isOK) {
            return;
        }
        int modelCount = this.viewer.getModelCount();
        this.viewer.setJmolDataFrame(type, modelIndex, modelCount - 1);
        switch (datatype) {
            default: {
                this.viewer.setFrameTitle(modelCount - 1, type + " plot for model " + this.viewer.getModelNumberDotted(modelIndex));
                script = "frame 0.0; frame last; reset;select visible; color structure; spacefill 3.0; wireframe 0;draw ramaAxisX" + modelCount + " {200 0 0} {-200 0 0} \"phi\";" + "draw ramaAxisY" + modelCount + " {0 200 0} {0 -200 0} \"psi\";";
                break;
            }
            case 1: {
                this.viewer.setFrameTitle(modelCount - 1, type + " for model " + this.viewer.getModelNumberDotted(modelIndex));
                script = "frame 0.0; frame last; reset;select visible; wireframe 0; isosurface quatSphere" + modelCount + " resolution 1.0 sphere 10.0 mesh nofill translucent 0.8;" + "draw quatAxis" + modelCount + "X {10 0 0} {-10 0 0} color red \"x\";" + "draw quatAxis" + modelCount + "Y {0 10 0} {0 -10 0} color green \"y\";" + "draw quatAxis" + modelCount + "Z {0 0 10} {0 0 -10} color blue \"z\";" + "color structure";
            }
        }
        this.runScript(script);
        this.viewer.setRotationRadius(isQuaternion ? 12.5f : 260.0f, true);
        this.viewer.loadShape(26);
        this.showString("frame " + this.viewer.getModelNumberDotted(modelCount - 1) + " created: " + type);
    }

    private void monitor() throws ScriptException {
        if (this.statementLength == 1) {
            this.viewer.hideMeasurements(false);
            return;
        }
        switch (this.statementLength) {
            case 2: {
                switch (this.getToken((int)1).tok) {
                    case 0x10000D: {
                        if (!this.isSyntaxCheck) {
                            this.viewer.hideMeasurements(false);
                        }
                        return;
                    }
                    case 0x10000C: {
                        if (!this.isSyntaxCheck) {
                            this.viewer.hideMeasurements(true);
                        }
                        return;
                    }
                    case 12291: {
                        if (!this.isSyntaxCheck) {
                            this.viewer.clearAllMeasurements();
                        }
                        return;
                    }
                    case 4: {
                        if (!this.isSyntaxCheck) {
                            this.viewer.setMeasurementFormats(this.stringParameter(1));
                        }
                        return;
                    }
                }
                this.error(24, "ON, OFF, DELETE");
                break;
            }
            case 3: {
                if (this.getToken((int)1).tok != 12291) break;
                if (this.getToken((int)2).tok == 0x100003) {
                    if (!this.isSyntaxCheck) {
                        this.viewer.clearAllMeasurements();
                    }
                } else {
                    int i = this.intParameter(2) - 1;
                    if (!this.isSyntaxCheck) {
                        this.viewer.deleteMeasurement(i);
                    }
                }
                return;
            }
        }
        int nAtoms = 0;
        int expressionCount = 0;
        int atomIndex = -1;
        int ptFloat = -1;
        int[] countPlusIndexes = new int[5];
        float[] rangeMinMax = new float[]{Float.MAX_VALUE, Float.MAX_VALUE};
        boolean isAll = false;
        boolean isAllConnected = false;
        boolean isDelete = false;
        boolean isRange = true;
        boolean isON = false;
        boolean isOFF = false;
        String strFormat = null;
        Vector<Point3f> monitorExpressions = new Vector<Point3f>();
        BitSet bs = new BitSet();
        Serializable value = null;
        block22: for (int i = 1; i < this.statementLength; ++i) {
            switch (this.getToken((int)i).tok) {
                default: {
                    this.error(15);
                }
                case 0x10000D: {
                    if (isON || isOFF || isDelete) {
                        this.error(22);
                    }
                    isON = true;
                    continue block22;
                }
                case 0x10000C: {
                    if (isON || isOFF || isDelete) {
                        this.error(22);
                    }
                    isOFF = true;
                    continue block22;
                }
                case 12291: {
                    if (isON || isOFF || isDelete) {
                        this.error(22);
                    }
                    isDelete = true;
                    continue block22;
                }
                case 1073741868: {
                    isAll = true;
                    isRange = true;
                    atomIndex = -1;
                    continue block22;
                }
                case 1: {
                    if (!this.parameterAsString(i).equalsIgnoreCase("ALLCONNECTED")) {
                        this.error(24, "ALL, ALLCONNECTED, DELETE");
                    }
                    isAllConnected = true;
                }
                case 0x100003: {
                    atomIndex = -1;
                    isAll = true;
                    continue block22;
                }
                case 4: {
                    strFormat = this.stringParameter(i);
                    continue block22;
                }
                case 3: {
                    isAll = true;
                    isRange = true;
                    ptFloat = (ptFloat + 1) % 2;
                    rangeMinMax[ptFloat] = this.floatParameter(i);
                    continue block22;
                }
                case 2: {
                    int iParam = this.intParameter(i);
                    if (isAll) {
                        isRange = true;
                        ptFloat = (ptFloat + 1) % 2;
                        rangeMinMax[ptFloat] = iParam;
                        continue block22;
                    }
                    atomIndex = this.viewer.getAtomIndexFromAtomNumber(iParam);
                    if (!this.isSyntaxCheck && atomIndex < 0) {
                        return;
                    }
                    if (value != null) {
                        this.error(22);
                    }
                    if ((countPlusIndexes[0] = ++nAtoms) > 4) {
                        this.error(2);
                    }
                    countPlusIndexes[nAtoms] = atomIndex;
                    continue block22;
                }
                case 7: 
                case 0x100001: 
                case 0x100007: 
                case 0x10000A: 
                case 0x40000007: {
                    if (atomIndex >= 0) {
                        this.error(22);
                    }
                    this.expressionResult = Boolean.FALSE;
                    value = this.centerParameter(i);
                    if (this.expressionResult instanceof BitSet) {
                        bs = (BitSet)this.expressionResult;
                        value = bs;
                        if (!this.isSyntaxCheck && BitSetUtil.firstSetBit(bs) < 0) {
                            return;
                        }
                    }
                    if ((nAtoms = ++expressionCount) > 4) {
                        this.error(2);
                    }
                    monitorExpressions.addElement((Point3f)value);
                    i = this.iToken;
                    continue block22;
                }
            }
        }
        if (nAtoms < 2) {
            this.error(2);
        }
        if (strFormat != null && strFormat.indexOf(nAtoms + ":") != 0) {
            strFormat = nAtoms + ":" + strFormat;
        }
        if (isRange && rangeMinMax[1] < rangeMinMax[0]) {
            rangeMinMax[1] = rangeMinMax[0];
            float f = rangeMinMax[0] = rangeMinMax[1] == Float.MAX_VALUE ? Float.MAX_VALUE : -200.0f;
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (value != null) {
            this.viewer.defineMeasurement(monitorExpressions, rangeMinMax, isDelete, isAll, isAllConnected, isON, isOFF, strFormat);
            return;
        }
        if (isDelete) {
            this.viewer.deleteMeasurement(countPlusIndexes);
        } else if (isON) {
            this.viewer.showMeasurement(countPlusIndexes, true);
        } else if (isOFF) {
            this.viewer.showMeasurement(countPlusIndexes, false);
        } else {
            this.viewer.toggleMeasurement(countPlusIndexes, strFormat);
        }
    }

    private void refresh() {
        if (this.isSyntaxCheck) {
            return;
        }
        this.viewer.setTainted(true);
        this.viewer.requestRepaintAndWait();
    }

    private void reset() throws ScriptException {
        this.checkLength(-2);
        if (this.isSyntaxCheck) {
            return;
        }
        if (this.statementLength == 1) {
            this.viewer.reset();
            return;
        }
        if (this.tokAt(1) == 135499780) {
            this.viewer.clearFunctions();
            return;
        }
        if (this.tokAt(1) == 38797589) {
            this.viewer.setData("element_vdw", new Object[]{null, ""}, 0, 0, 0, 0, 0);
            return;
        }
        String var = this.parameterAsString(1);
        if (var.charAt(0) == '_') {
            this.error(22);
        }
        if (var.equalsIgnoreCase("aromatic")) {
            this.viewer.resetAromatic();
        } else {
            this.viewer.unsetProperty(var);
        }
    }

    private void restrict() throws ScriptException {
        this.select();
        if (this.isSyntaxCheck) {
            return;
        }
        this.restrictSelected(true);
    }

    private void restrictSelected(boolean doInvert) {
        BitSet bsSelected = BitSetUtil.copy(this.viewer.getSelectionSet());
        if (doInvert) {
            this.viewer.invertSelection();
        }
        BitSet bsSubset = this.viewer.getSelectionSubset();
        if (doInvert && bsSubset != null) {
            bsSelected = BitSetUtil.copy(this.viewer.getSelectionSet());
            bsSelected.and(bsSubset);
            this.viewer.setSelectionSet(bsSelected);
            BitSetUtil.invertInPlace(bsSelected, this.viewer.getAtomCount());
            bsSelected.and(bsSubset);
        }
        BitSetUtil.andNot(bsSelected, this.viewer.getDeletedAtoms());
        boolean bondmode = this.viewer.getBondSelectionModeOr();
        this.setBooleanProperty("bondModeOr", true);
        this.setShapeSize(1, 0);
        int shapeType = 20;
        while (--shapeType >= 0) {
            if (shapeType == 5) continue;
            this.setShapeSize(shapeType, 0);
        }
        this.setShapeProperty(20, "delete", null);
        this.viewer.setLabel(null);
        this.setBooleanProperty("bondModeOr", bondmode);
        this.viewer.setSelectionSet(bsSelected);
    }

    private void rotate(boolean isSpin, boolean isSelected) throws ScriptException {
        if (this.statementLength == 2) {
            switch (this.getToken((int)1).tok) {
                case 0x10000D: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.setSpinOn(true);
                    }
                    return;
                }
                case 0x10000C: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.setSpinOn(false);
                    }
                    return;
                }
            }
        }
        BitSet bsAtoms = null;
        float degrees = Float.MIN_VALUE;
        int nPoints = 0;
        float endDegrees = Float.MAX_VALUE;
        boolean isMolecular = false;
        Point3f[] points = new Point3f[2];
        Vector3f rotAxis = new Vector3f(0.0f, 1.0f, 0.0f);
        int direction = 1;
        boolean axesOrientationRasmol = this.viewer.getAxesOrientationRasmol();
        block16: for (int i = 1; i < this.statementLength; ++i) {
            int tok = this.getToken((int)i).tok;
            switch (tok) {
                case 537399351: {
                    isSpin = true;
                    continue block16;
                }
                case 0x10100090: {
                    direction = -1;
                    continue block16;
                }
                case 135272453: {
                    ++i;
                }
                case 8: {
                    Quaternion q = new Quaternion(this.getPoint4f(i));
                    rotAxis.set(q.getNormal());
                    degrees = q.getTheta();
                    break;
                }
                case 135268358: {
                    if (this.isPoint3f(++i)) {
                        rotAxis.set(this.centerParameter(i));
                        break;
                    }
                    Point4f p4 = this.getPoint4f(i);
                    rotAxis.set(p4.x, p4.y, p4.z);
                    degrees = p4.w;
                    break;
                }
                case 1: {
                    String str = this.parameterAsString(i);
                    if (str.equalsIgnoreCase("x")) {
                        rotAxis.set(direction, 0.0f, 0.0f);
                        continue block16;
                    }
                    if (str.equalsIgnoreCase("y")) {
                        rotAxis.set(0.0f, axesOrientationRasmol && !isMolecular ? -direction : direction, 0.0f);
                        continue block16;
                    }
                    if (str.equalsIgnoreCase("z")) {
                        rotAxis.set(0.0f, 0.0f, direction);
                        continue block16;
                    }
                    if (str.equalsIgnoreCase("internal") || str.equalsIgnoreCase("molecular")) {
                        isMolecular = true;
                        continue block16;
                    }
                    this.error(22);
                }
                case 0x100004: {
                    int iAtom1 = BitSetUtil.firstSetBit(this.expression(++i));
                    int iAtom2 = BitSetUtil.firstSetBit(this.expression(++this.iToken));
                    if (iAtom1 < 0 || iAtom2 < 0) {
                        return;
                    }
                    bsAtoms = this.viewer.getBranchBitSet(iAtom2, iAtom1);
                    isMolecular = true;
                    points[0] = this.viewer.getAtomPoint3f(iAtom2);
                    points[1] = this.viewer.getAtomPoint3f(iAtom1);
                    nPoints = 2;
                    i = this.iToken;
                    break;
                }
                case 7: 
                case 0x100001: 
                case 0x100007: 
                case 0x10000A: 
                case 0x40000007: {
                    if (nPoints == 2) {
                        this.error(43);
                    }
                    Point3f pt1 = this.centerParameter(i);
                    if (!this.isSyntaxCheck && tok == 0x100007 && this.tokAt(i + 2) != 0x10100040) {
                        rotAxis = this.getDrawObjectAxis(this.objectNameParameter(++i));
                    }
                    points[nPoints++] = pt1;
                    break;
                }
                case 0x10100030: {
                    continue block16;
                }
                case 2: 
                case 3: {
                    if (degrees == Float.MIN_VALUE) {
                        degrees = this.floatParameter(i);
                        continue block16;
                    }
                    endDegrees = degrees;
                    if (endDegrees * (degrees = this.floatParameter(i)) < 0.0f) {
                        degrees = -degrees;
                    }
                    isSpin = true;
                    continue block16;
                }
                default: {
                    this.error(22);
                }
            }
            i = this.iToken;
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (degrees == Float.MIN_VALUE) {
            degrees = 10.0f;
        }
        if (isSelected && bsAtoms == null) {
            bsAtoms = this.viewer.getSelectionSet();
        }
        if (nPoints < 2) {
            if (!isMolecular) {
                this.viewer.rotateAxisAngleAtCenter(points[0], rotAxis, degrees, endDegrees, isSpin, bsAtoms);
                return;
            }
            if (nPoints == 0) {
                points[0] = new Point3f();
            }
            points[1] = new Point3f(points[0]);
            points[1].sub(rotAxis);
        }
        if (points[0].distance(points[1]) == 0.0f) {
            points[1] = new Point3f(points[0]);
            points[1].y = (float)((double)points[1].y - 1.0);
        }
        this.viewer.rotateAboutPointsInternal(points[0], points[1], degrees, endDegrees, isSpin, bsAtoms);
    }

    private Point3f getObjectCenter(String axisID, int index) {
        Point3f pt = (Point3f)this.viewer.getShapeProperty(21, "getCenter:" + axisID, index);
        if (pt == null) {
            pt = (Point3f)this.viewer.getShapeProperty(22, "getCenter:" + axisID, index);
        }
        return pt;
    }

    private Vector3f getDrawObjectAxis(String axisID) {
        return (Vector3f)this.viewer.getShapeProperty(21, "getSpinAxis:" + axisID);
    }

    private void script(int tok) throws ScriptException {
        boolean loadCheck = true;
        boolean isCheck = false;
        boolean doStep = false;
        int lineNumber = 0;
        int pc = 0;
        int lineEnd = 0;
        int pcEnd = 0;
        int i = 2;
        String filename = null;
        String theScript = this.parameterAsString(1);
        if (tok == 135287299) {
            this.checkLength(2);
            if (!this.isSyntaxCheck) {
                this.viewer.jsEval(theScript);
            }
            return;
        }
        if (theScript.equalsIgnoreCase("applet")) {
            String appID = this.parameterAsString(2);
            theScript = this.parameterExpression(3, 0, "_script", false).toString();
            this.checkLength(this.iToken + 1);
            if (this.isSyntaxCheck) {
                return;
            }
            if (appID.length() == 0 || appID.equals("all")) {
                appID = "*";
            }
            if (!appID.equals(".")) {
                this.viewer.jsEval(appID + "\u0001" + theScript);
                if (!appID.equals("*")) {
                    return;
                }
            }
        } else {
            if (this.getToken((int)1).tok != 4) {
                this.error(16);
            }
            filename = theScript;
            theScript = null;
            String option = this.optParameterAsString(this.statementLength - 1);
            doStep = option.equalsIgnoreCase("step");
            if (filename.equalsIgnoreCase("inline")) {
                theScript = this.parameterExpression(2, doStep ? this.statementLength - 1 : 0, "_script", false).toString();
                i = this.iToken + 1;
            }
            if ((option = this.optParameterAsString(i)).equalsIgnoreCase("check")) {
                isCheck = true;
                option = this.optParameterAsString(++i);
            }
            if (option.equalsIgnoreCase("noload")) {
                loadCheck = false;
                option = this.optParameterAsString(++i);
            }
            if (option.equalsIgnoreCase("line") || option.equalsIgnoreCase("lines")) {
                int n = ++i;
                lineEnd = lineNumber = Math.max(this.intParameter(n), 0);
                if (this.checkToken(++i)) {
                    if (this.getToken((int)i++).tok == 0x10100090) {
                        lineEnd = this.checkToken(i) ? this.intParameter(i++) : 0;
                    } else {
                        this.error(22);
                    }
                }
            } else if (option.equalsIgnoreCase("command") || option.equalsIgnoreCase("commands")) {
                int n = ++i;
                pc = Math.max(this.intParameter(n) - 1, 0);
                pcEnd = pc + 1;
                if (this.checkToken(++i)) {
                    if (this.getToken((int)i++).tok == 0x10100090) {
                        pcEnd = this.checkToken(i) ? this.intParameter(i++) : 0;
                    } else {
                        this.error(22);
                    }
                }
            }
            this.checkLength(doStep ? i + 1 : i);
        }
        if (this.isSyntaxCheck && !this.isCmdLine_c_or_C_Option) {
            return;
        }
        if (this.isCmdLine_c_or_C_Option) {
            isCheck = true;
        }
        boolean wasSyntaxCheck = this.isSyntaxCheck;
        boolean wasScriptCheck = this.isCmdLine_c_or_C_Option;
        if (isCheck) {
            this.isCmdLine_c_or_C_Option = true;
            this.isSyntaxCheck = true;
        }
        this.pushContext(null);
        this.contextPath = this.contextPath + " >> " + filename;
        if (theScript == null ? this.compileScriptFileInternal(filename) : this.compileScript(null, theScript, false)) {
            this.pcEnd = pcEnd;
            this.lineEnd = lineEnd;
            while (pc < this.lineNumbers.length && this.lineNumbers[pc] < lineNumber) {
                ++pc;
            }
            this.pc = pc;
            boolean saveLoadCheck = this.isCmdLine_C_Option;
            this.isCmdLine_C_Option &= loadCheck;
            this.executionStepping |= doStep;
            this.instructionDispatchLoop(isCheck);
            if (this.debugScript && this.viewer.getMessageStyleChime()) {
                this.viewer.scriptStatus("script <exiting>");
            }
            this.isCmdLine_C_Option = saveLoadCheck;
            this.popContext();
        } else {
            Logger.error(GT._("script ERROR: ") + this.errorMessage);
            this.popContext();
            if (wasScriptCheck) {
                this.setErrorMessage(null);
            } else {
                this.evalError(null, null);
            }
        }
        this.isSyntaxCheck = wasSyntaxCheck;
        this.isCmdLine_c_or_C_Option = wasScriptCheck;
    }

    private void function() throws ScriptException {
        Vector params;
        if (this.isSyntaxCheck && !this.isCmdLine_c_or_C_Option) {
            return;
        }
        String name = (String)this.getToken((int)0).value;
        if (!this.viewer.isFunction(name)) {
            if (name.equalsIgnoreCase("exitjmol")) {
                if (this.isSyntaxCheck || this.viewer.isApplet()) {
                    return;
                }
                this.viewer.exitJmol();
            }
            this.error(10);
        }
        Vector vector = params = this.statementLength == 1 || this.statementLength == 3 && this.tokAt(1) == 0x10100010 && this.tokAt(2) == 0x10100011 ? null : (Vector)this.parameterExpression(1, 0, null, true);
        if (this.isSyntaxCheck) {
            return;
        }
        this.pushContext(null);
        this.contextPath = this.contextPath + " >> function " + name;
        this.loadFunction(name, params);
        this.instructionDispatchLoop(false);
        this.popContext();
    }

    private void sync() throws ScriptException {
        this.checkLength(-3);
        String text = "";
        String applet = "";
        switch (this.statementLength) {
            case 1: {
                applet = "*";
                text = "ON";
                break;
            }
            case 2: {
                applet = this.parameterAsString(1);
                if (applet.indexOf("jmolApplet") == 0 || Parser.isOneOf(applet, "*;.;^")) {
                    text = "ON";
                    if (!this.isSyntaxCheck) {
                        this.viewer.syncScript(text, applet);
                    }
                    applet = ".";
                    break;
                }
                text = applet;
                applet = "*";
                break;
            }
            case 3: {
                applet = this.parameterAsString(1);
                String string = text = this.tokAt(2) == 528442 ? "GET_GRAPHICS" : this.parameterAsString(2);
            }
        }
        if (this.isSyntaxCheck) {
            return;
        }
        this.viewer.syncScript(text, applet);
    }

    private void history(int pt) throws ScriptException {
        if (this.statementLength == 1) {
            this.showString(this.viewer.getSetHistory(Integer.MAX_VALUE));
            return;
        }
        if (pt == 2) {
            this.checkLength(3);
            int n = this.intParameter(2);
            if (n < 0) {
                this.error(22);
            }
            if (!this.isSyntaxCheck) {
                this.viewer.getSetHistory(n == 0 ? 0 : -2 - n);
            }
            return;
        }
        this.checkLength(2);
        switch (this.getToken((int)1).tok) {
            case 0x10000D: 
            case 0x4000000A: {
                if (!this.isSyntaxCheck) {
                    this.viewer.getSetHistory(Integer.MIN_VALUE);
                }
                return;
            }
            case 0x10000C: {
                if (this.isSyntaxCheck) break;
                this.viewer.getSetHistory(0);
                break;
            }
            default: {
                this.error(24, "ON, OFF, CLEAR");
            }
        }
    }

    private void display(boolean isDisplay) throws ScriptException {
        BitSet bs;
        if (this.tokAt(1) == 0x100007) {
            this.setObjectProperty();
            return;
        }
        BitSet bitSet = bs = this.statementLength == 1 ? null : this.expression(1);
        if (this.isSyntaxCheck) {
            return;
        }
        if (isDisplay) {
            this.viewer.display(bs, this.tQuiet);
        } else {
            this.viewer.hide(bs, this.tQuiet);
        }
    }

    private void delete() throws ScriptException {
        if (this.statementLength == 1) {
            this.zap(true);
            return;
        }
        if (this.tokAt(1) == 0x100007) {
            this.setObjectProperty();
            return;
        }
        BitSet bs = this.expression(this.statement, 1, 0, true, false, true, false);
        if (this.isSyntaxCheck) {
            return;
        }
        int nDeleted = this.viewer.deleteAtoms(bs, false);
        if (!this.tQuiet && this.scriptLevel <= this.scriptReportingLevel) {
            this.scriptStatusOrBuffer(GT._("{0} atoms deleted", nDeleted));
        }
    }

    private void minimize() throws ScriptException {
        int i;
        BitSet bsSelected = null;
        int steps = Integer.MAX_VALUE;
        float crit = 0.0f;
        MinimizerInterface minimizer = this.viewer.getMinimizer(false);
        block8: for (i = 1; i < this.statementLength; ++i) {
            switch (this.tokAt(i)) {
                case 0x4000000A: {
                    this.checkLength(2);
                    if (this.isSyntaxCheck || minimizer == null) {
                        return;
                    }
                    minimizer.setProperty("clear", null);
                    return;
                }
                case 0x4000000C: {
                    if (i != 1) {
                        this.error(22);
                    }
                    int n = 0;
                    float targetValue = 0.0f;
                    int[] aList = new int[5];
                    if (this.tokAt(++i) == 0x4000000A) {
                        this.checkLength(2);
                    } else {
                        while (n < 4 && !this.isFloatParameter(i)) {
                            aList[++n] = BitSetUtil.firstSetBit(this.expression(i));
                            i = this.iToken + 1;
                        }
                        aList[0] = n;
                        targetValue = this.floatParameter(i++);
                        this.checkLength(i);
                    }
                    if (!this.isSyntaxCheck) {
                        this.viewer.getMinimizer(true).setProperty("constraint", new Object[]{aList, new int[n], new Float(targetValue)});
                    }
                    return;
                }
                case 1: 
                case 4: {
                    String cmd = this.parameterAsString(i).toLowerCase();
                    if (cmd.equals("stop") || cmd.equals("cancel")) {
                        this.checkLength(2);
                        if (this.isSyntaxCheck || minimizer == null) {
                            return;
                        }
                        minimizer.setProperty(cmd, null);
                        return;
                    }
                    if (cmd.equals("fix")) {
                        BitSet bsFixed;
                        if (i != 1) {
                            this.error(22);
                        }
                        if (BitSetUtil.firstSetBit(bsFixed = this.expression(++i)) < 0) {
                            bsFixed = null;
                        }
                        this.checkLength(this.iToken + 1, 1);
                        if (!this.isSyntaxCheck) {
                            this.viewer.getMinimizer(true).setProperty("fixed", bsFixed);
                        }
                        return;
                    }
                    if (cmd.equals("energy")) {
                        steps = 0;
                        continue block8;
                    }
                    if (cmd.equals("criterion")) {
                        crit = this.floatParameter(++i);
                        continue block8;
                    }
                    if (cmd.equals("steps")) {
                        steps = this.intParameter(++i);
                        continue block8;
                    }
                    this.error(22);
                    continue block8;
                }
                case 135280129: {
                    bsSelected = this.expression(++i);
                    i = this.iToken;
                    continue block8;
                }
            }
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (bsSelected == null) {
            i = BitSetUtil.firstSetBit(this.viewer.getVisibleFramesBitSet());
            bsSelected = this.viewer.getModelAtomBitSet(i, false);
        }
        try {
            this.viewer.getMinimizer(true).minimize(steps, crit, bsSelected);
        }
        catch (Exception e) {
            this.evalError(e.getMessage(), null);
        }
    }

    private void select() throws ScriptException {
        if (this.statementLength == 1) {
            this.viewer.select(null, this.tQuiet || this.scriptLevel > this.scriptReportingLevel);
            return;
        }
        if (this.statementLength == 2 && this.tokAt(1) == 0x40000088) {
            return;
        }
        this.viewer.setNoneSelected(this.statementLength == 4 && this.tokAt(2) == 0x10000B);
        if (this.tokAt(2) == 0x40000007 && this.getToken((int)2).value instanceof Bond.BondSet || this.getToken((int)2).tok == 605028354 && this.getToken((int)3).tok == 0x40000007) {
            if (this.statementLength == this.iToken + 2) {
                if (!this.isSyntaxCheck) {
                    this.viewer.selectBonds((BitSet)this.theToken.value);
                }
                return;
            }
            this.error(22);
        }
        if (this.getToken((int)2).tok == 538447907) {
            if (this.statementLength == 5 && this.getToken((int)3).tok == 0x40000007) {
                if (!this.isSyntaxCheck) {
                    this.setShapeProperty(5, "select", this.theToken.value);
                }
                return;
            }
            this.error(22);
        }
        BitSet bs = null;
        if (this.getToken((int)1).intValue == 0) {
            Object v = this.tokenSetting((int)0).value;
            if (!(v instanceof BitSet)) {
                this.error(22);
            }
            this.checkLength(++this.iToken);
            bs = (BitSet)v;
        } else {
            bs = this.expression(1);
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (this.isBondSet) {
            this.viewer.selectBonds(bs);
        } else {
            this.viewer.select(bs, this.tQuiet || this.scriptLevel > this.scriptReportingLevel);
        }
    }

    private void subset() throws ScriptException {
        BitSet bs;
        BitSet bitSet = bs = this.statementLength == 1 ? null : this.expression(-1);
        if (this.isSyntaxCheck) {
            return;
        }
        this.viewer.setSelectionSubset(bs);
    }

    private void invertSelected() throws ScriptException {
        Point3f pt = null;
        Point4f plane = null;
        if (this.statementLength == 1) {
            if (this.isSyntaxCheck) {
                return;
            }
            BitSet bs = this.viewer.getSelectionSet();
            pt = this.viewer.getAtomSetCenter(bs);
            this.viewer.invertSelected(pt, bs);
            return;
        }
        String type = this.parameterAsString(1);
        if (type.equalsIgnoreCase("point")) {
            pt = this.centerParameter(2);
        } else if (type.equalsIgnoreCase("plane")) {
            plane = this.planeParameter(2);
        } else if (type.equalsIgnoreCase("hkl")) {
            plane = this.hklParameter(2);
        }
        this.checkLength(this.iToken + 1, 1);
        if (plane == null && pt == null) {
            this.error(22);
        }
        if (this.isSyntaxCheck) {
            return;
        }
        this.viewer.invertSelected(pt, plane);
    }

    private void translateSelected() throws ScriptException {
        Point3f pt = this.getPoint3f(1, true);
        if (!this.isSyntaxCheck) {
            this.viewer.setAtomCoordRelative(pt);
        }
    }

    private void translate() throws ScriptException {
        char type = (this.optParameterAsString(3).toLowerCase() + '\u0000').charAt(0);
        this.checkLength(type == '\u0000' ? 3 : 4);
        float percent = this.floatParameter(2);
        if (this.getToken((int)1).tok == 1) {
            char xyz = this.parameterAsString(1).toLowerCase().charAt(0);
            switch (xyz) {
                case 'x': 
                case 'y': 
                case 'z': {
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    this.viewer.translate(xyz, percent, type);
                    return;
                }
            }
        }
        this.error(0);
    }

    private void zap(boolean isZapCommand) throws ScriptException {
        boolean isQuiet;
        if (this.statementLength == 1 || !isZapCommand) {
            this.viewer.zap(true, isZapCommand && !this.isStateScript);
            this.refresh();
            return;
        }
        BitSet bs = this.expression(1);
        if (this.isSyntaxCheck) {
            return;
        }
        int nDeleted = this.viewer.deleteAtoms(bs, true);
        boolean bl = isQuiet = this.tQuiet || this.scriptLevel > this.scriptReportingLevel;
        if (!isQuiet) {
            this.scriptStatusOrBuffer(GT._("{0} atoms deleted", nDeleted));
        }
        this.viewer.select(null, isQuiet);
    }

    private void zoom(boolean isZoomTo) throws ScriptException {
        float time;
        if (!isZoomTo) {
            int tok = this.statementLength > 1 ? this.getToken((int)1).tok : 0x10000D;
            switch (tok) {
                case 0x10000C: 
                case 0x10000D: {
                    if (this.statementLength > 2) {
                        this.error(2);
                    }
                    if (!this.isSyntaxCheck) {
                        this.setBooleanProperty("zoomEnabled", tok == 0x10000D);
                    }
                    return;
                }
            }
        }
        float zoom = this.viewer.getZoomSetting();
        float radius = this.viewer.getRotationRadius();
        Point3f center = null;
        Point3f currentCenter = this.viewer.getRotationCenter();
        int i = 1;
        float f = isZoomTo ? (this.isFloatParameter(i) ? this.floatParameter(i++) : 2.0f) : (time = 0.0f);
        if (time < 0.0f) {
            this.error(22);
        }
        int ptCenter = 0;
        if (this.isCenterParameter(i)) {
            ptCenter = i;
            center = this.centerParameter(i);
            i = this.iToken + 1;
        }
        boolean isSameAtom = false;
        float factor = this.getZoomFactor(i, ptCenter, radius, zoom);
        if (factor < 0.0f) {
            factor = -factor;
            if (isZoomTo) {
                if (this.statementLength == 1 || isSameAtom) {
                    factor *= 2.0f;
                } else if (center == null) {
                    factor /= 2.0f;
                }
            }
        }
        float xTrans = 0.0f;
        float yTrans = 0.0f;
        float max = this.viewer.getMaxZoomPercent();
        if (factor < 5.0f || factor > max) {
            this.numberOutOfRange(5.0f, max);
        }
        if (!this.viewer.isWindowCentered()) {
            if (center != null) {
                BitSet bs = this.expression(ptCenter);
                if (!this.isSyntaxCheck) {
                    this.viewer.setCenterBitSet(bs, false);
                }
            }
            center = this.viewer.getRotationCenter();
            xTrans = this.viewer.getTranslationXPercent();
            yTrans = this.viewer.getTranslationYPercent();
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (isSameAtom && Math.abs(zoom - factor) < 1.0f) {
            time = 0.0f;
        }
        this.viewer.moveTo(time, center, new Point3f(0.0f, 0.0f, 0.0f), Float.NaN, factor, xTrans, yTrans, radius, null, Float.NaN, Float.NaN, Float.NaN);
    }

    private float getZoomFactor(int i, int ptCenter, float radius, float factor0) throws ScriptException {
        float factor;
        BitSet bs = null;
        float f = factor = this.isFloatParameter(i) ? this.floatParameter(i) : Float.NaN;
        if (factor == 0.0f) {
            switch (this.statement[ptCenter].tok) {
                case 0x100001: 
                case 0x40000007: {
                    bs = this.expression(this.statement, ptCenter, 0, true, false, false, true);
                }
            }
            if (bs == null) {
                this.error(22);
            }
            float r = this.viewer.calcRotationRadius(bs);
            factor0 = radius / r * 100.0f;
            factor = Float.NaN;
            ++i;
        }
        if (factor < 0.0f) {
            factor += factor0;
        } else if (Float.isNaN(factor)) {
            factor = factor0;
            if (this.isFloatParameter(i + 1)) {
                float value = this.floatParameter(i + 1);
                switch (this.getToken((int)i++).tok) {
                    case 0x101000A0: {
                        factor /= value;
                        break;
                    }
                    case 0x101000A1: {
                        factor *= value;
                        break;
                    }
                    case 0x10100091: {
                        factor += value;
                        break;
                    }
                    default: {
                        this.error(22);
                        break;
                    }
                }
            } else {
                if (bs == null) {
                    factor = -factor;
                }
                --i;
            }
        }
        this.iToken = i;
        return factor;
    }

    private void gotocmd() throws ScriptException {
        this.checkLength(2);
        String strTo = null;
        strTo = this.parameterAsString(1);
        int pcTo = -1;
        for (int i = 0; i < this.aatoken.length; ++i) {
            Token[] tokens = this.aatoken[i];
            if (tokens[0].tok != 20484 && tokens[0].tok != 0 || !tokens[tokens.length - 1].value.toString().equalsIgnoreCase(strTo)) continue;
            pcTo = i;
            break;
        }
        if (pcTo < 0) {
            this.error(22);
        }
        if (!this.isSyntaxCheck) {
            this.pc = pcTo - 1;
        }
    }

    private void delay() throws ScriptException {
        long millis = 0L;
        switch (this.getToken((int)1).tok) {
            case 0x10000D: {
                millis = 1L;
                break;
            }
            case 2: {
                millis = this.intParameter(1) * 1000;
                break;
            }
            case 3: {
                millis = (long)(this.floatParameter(1) * 1000.0f);
                break;
            }
            default: {
                this.error(34);
            }
        }
        if (!this.isSyntaxCheck) {
            this.delay(millis);
        }
    }

    private void delay(long millis) {
        long timeBegin = System.currentTimeMillis();
        this.refresh();
        if (millis < 0L) {
            millis = -millis;
        } else {
            int delayMax = this.viewer.getDelayMaximum();
            if (delayMax > 0 && millis > (long)delayMax) {
                millis = delayMax;
            }
        }
        int seconds = (int)(millis -= System.currentTimeMillis() - timeBegin) / 1000;
        if ((millis -= (long)(seconds * 1000)) <= 0L) {
            millis = 1L;
        }
        while (seconds >= 0 && millis > 0L && !this.interruptExecution && this.currentThread == Thread.currentThread()) {
            this.viewer.popHoldRepaint("delay");
            try {
                Thread.sleep(seconds-- > 0 ? 1000L : millis);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.viewer.pushHoldRepaint("delay");
        }
    }

    private void slab(boolean isDepth) throws ScriptException {
        boolean TF = false;
        Point4f plane = null;
        if (this.isCenterParameter(1) || this.tokAt(1) == 8) {
            plane = this.planeParameter(1);
        } else {
            block0 : switch (this.getToken((int)1).tok) {
                case 2: {
                    this.checkLength(2);
                    int percent = this.intParameter(1);
                    if (!this.isSyntaxCheck) {
                        if (isDepth) {
                            this.viewer.depthToPercent(percent);
                        } else {
                            this.viewer.slabToPercent(percent);
                        }
                    }
                    return;
                }
                case 0x10000D: {
                    this.checkLength(2);
                    TF = true;
                }
                case 0x10000C: {
                    this.checkLength(2);
                    this.setBooleanProperty("slabEnabled", TF);
                    return;
                }
                case 4140: {
                    this.checkLength(2);
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    this.viewer.slabReset();
                    this.setBooleanProperty("slabEnabled", true);
                    return;
                }
                case 36867: {
                    this.checkLength(2);
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    this.viewer.setSlabDepthInternal(isDepth);
                    this.setBooleanProperty("slabEnabled", true);
                    return;
                }
                case 0x10100090: {
                    String str = this.parameterAsString(2);
                    if (str.equalsIgnoreCase("hkl")) {
                        plane = this.hklParameter(3);
                    } else if (str.equalsIgnoreCase("plane")) {
                        plane = this.planeParameter(3);
                    }
                    if (plane == null) {
                        this.error(22);
                    }
                    plane.scale(-1.0f);
                    break;
                }
                case 135268355: {
                    switch (this.getToken((int)2).tok) {
                        case 0x10000B: {
                            break block0;
                        }
                    }
                    plane = this.planeParameter(2);
                    break;
                }
                case 1073741944: {
                    plane = this.getToken((int)2).tok == 0x10000B ? null : this.hklParameter(2);
                    break;
                }
                case 1: {
                    String str = this.parameterAsString(1);
                    if (str.equalsIgnoreCase("reference")) {
                        return;
                    }
                }
                default: {
                    this.error(22);
                }
            }
        }
        if (!this.isSyntaxCheck) {
            this.viewer.slabInternal(plane, isDepth);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void ellipsoid() throws ScriptException {
        mad = 0;
        i = 1;
        switch (this.getToken((int)1).tok) {
            case 0x10000D: {
                mad = 50;
                break;
            }
            case 0x10000C: {
                break;
            }
            case 2: {
                mad = this.intParameter(1);
                break;
            }
            case 1: 
            case 0x101000A1: {
                this.viewer.loadShape(19);
                if (this.parameterAsString(i).equalsIgnoreCase("ID")) {
                    ++i;
                }
                this.setShapeId(19, i, false);
                i = this.iToken;
                ++i;
                while (i < this.statementLength) {
                    key = this.parameterAsString(i);
                    value /* !! */  = null;
                    if (!key.equalsIgnoreCase("modelIndex")) ** GOTO lbl26
                    value /* !! */  = new Integer(this.intParameter(++i));
                    key = "modelindex";
                    ** GOTO lbl69
lbl26:
                    // 1 sources

                    if (!key.equalsIgnoreCase("axes")) ** GOTO lbl35
                    axes = new Vector3f[3];
                    for (j = 0; j < 3; ++j) {
                        axes[j] = new Vector3f();
                        axes[j].set(this.centerParameter(++i));
                        i = this.iToken;
                    }
                    value /* !! */  = axes;
                    ** GOTO lbl69
lbl35:
                    // 1 sources

                    if (!key.equalsIgnoreCase("on")) ** GOTO lbl38
                    value /* !! */  = Boolean.TRUE;
                    ** GOTO lbl69
lbl38:
                    // 1 sources

                    if (!key.equalsIgnoreCase("off")) ** GOTO lbl42
                    key = "on";
                    value /* !! */  = Boolean.FALSE;
                    ** GOTO lbl69
lbl42:
                    // 1 sources

                    if (!key.equalsIgnoreCase("delete")) ** GOTO lbl46
                    value /* !! */  = Boolean.TRUE;
                    this.checkLength(3);
                    ** GOTO lbl69
lbl46:
                    // 1 sources

                    if (!key.equalsIgnoreCase("center")) ** GOTO lbl50
                    value /* !! */  = this.centerParameter(++i);
                    i = this.iToken;
                    ** GOTO lbl69
lbl50:
                    // 1 sources

                    if (!key.equalsIgnoreCase("scale")) ** GOTO lbl53
                    value /* !! */  = new Float(this.floatParameter(++i));
                    ** GOTO lbl69
lbl53:
                    // 1 sources

                    if (!key.equalsIgnoreCase("color")) ** GOTO lbl69
                    translucentLevel = NaNf;
                    if ((this.theTok = this.tokAt(++i)) == 1073741887) {
                        value /* !! */  = "translucent";
                        translucentLevel = this.isFloatParameter(++i) ? this.getTranslucentLevel(i++) : this.viewer.getDefaultTranslucent();
                    } else if (this.theTok == 1073741861) {
                        value /* !! */  = "opaque";
                        ++i;
                    }
                    if (this.isColorParam(i)) {
                        this.setShapeProperty(19, "color", new Integer(this.getArgbParam(i)));
                        i = this.iToken;
                    }
                    if (value /* !! */  == null) ** GOTO lbl72
                    if (!Float.isNaN(translucentLevel)) {
                        this.setShapeProperty(19, "translucentLevel", new Float(translucentLevel));
                    }
                    key = "translucency";
lbl69:
                    // 9 sources

                    if (value /* !! */  == null) {
                        this.error(22);
                    }
                    this.setShapeProperty(19, key.toLowerCase(), value /* !! */ );
lbl72:
                    // 2 sources

                    ++i;
                }
                this.setShapeProperty(19, "thisID", null);
                return;
            }
            default: {
                this.error(22);
            }
        }
        this.setShapeSize(19, mad);
    }

    private String getShapeNameParameter(int i) throws ScriptException {
        String id = this.parameterAsString(i);
        boolean isWild = id.equals("*");
        if (id.length() == 0) {
            this.error(22);
        }
        if (isWild) {
            switch (this.tokAt(i + 1)) {
                case 0: 
                case 12291: 
                case 0x10000C: 
                case 0x10000D: 
                case 3145751: 
                case 3145752: 
                case 558895366: {
                    break;
                }
                default: {
                    id = id + this.optParameterAsString(++i);
                }
            }
        }
        if (this.tokAt(i + 1) == 0x101000A1) {
            id = id + this.parameterAsString(++i);
        }
        this.iToken = i;
        return id;
    }

    private void setShapeId(int iShape, int i, boolean idSeen) throws ScriptException {
        if (idSeen) {
            this.error(22);
        }
        this.setShapeProperty(iShape, "thisID", this.getShapeNameParameter(i).toLowerCase());
    }

    private void setAtomShapeSize(int shape, int defOn) throws ScriptException {
        int code = 0;
        float fsize = Float.NaN;
        int tok = this.tokAt(1);
        switch (tok) {
            case 0x40000088: {
                this.restrictSelected(false);
                code = defOn;
                break;
            }
            case 0x10000D: {
                code = defOn;
                break;
            }
            case 38797589: {
                code = -100;
                break;
            }
            case 0x10000C: {
                break;
            }
            case 3: 
            case 0x10100091: {
                int i = tok == 0x10100091 ? 2 : 1;
                code = i == 2 ? 1 : -1;
                fsize = this.floatParameter(i, 0.0f, 16.0f);
                break;
            }
            case 2: {
                int intVal = this.intParameter(1);
                if (this.tokAt(2) == 269484194) {
                    int iMode;
                    if (intVal < 0 || intVal > 200) {
                        this.integerOutOfRange(0, 200);
                    }
                    if ((iMode = JmolConstants.getVdwType(this.optParameterAsString(3))) >= 0) {
                        code = -(iMode + 1) * 2000 - intVal;
                        break;
                    }
                    code = -intVal;
                    break;
                }
                if (intVal > 749 || intVal < -200) {
                    this.integerOutOfRange(-200, 749);
                }
                code = intVal <= 0 ? intVal : intVal * 8;
                break;
            }
            case 38797585: {
                code = -1000;
                break;
            }
            case 38797321: {
                code = -1001;
                break;
            }
            case 38797313: {
                code = Short.MAX_VALUE;
                if (this.tokAt(2) != 2) break;
                code += this.intParameter(2);
                break;
            }
            case 0x2500002: {
                code = Short.MIN_VALUE;
                if (this.tokAt(2) != 2) break;
                code -= this.intParameter(2);
                break;
            }
            default: {
                this.error(22);
            }
        }
        this.setShapeSize(shape, code, fsize);
    }

    private void structure() throws ScriptException {
        String type = this.parameterAsString(1).toLowerCase();
        byte iType = 0;
        BitSet bs = null;
        if (type.equals("helix")) {
            iType = 3;
        } else if (type.equals("sheet")) {
            iType = 2;
        } else if (type.equals("turn")) {
            iType = 1;
        } else if (type.equals("none")) {
            iType = 0;
        } else {
            this.error(22);
        }
        switch (this.tokAt(2)) {
            case 0x100001: 
            case 0x40000007: {
                bs = this.expression(2);
                this.checkLength(this.iToken + 1);
                break;
            }
            default: {
                this.checkLength(2);
            }
        }
        if (this.isSyntaxCheck) {
            return;
        }
        this.clearDefinedVariableAtomSets();
        this.viewer.setProteinType(iType, bs);
    }

    private void wireframe() throws ScriptException {
        int mad = this.getMadParameter();
        if (this.isSyntaxCheck) {
            return;
        }
        this.setShapeProperty(1, "type", new Integer(1023));
        this.setShapeSize(1, mad);
    }

    private void ssbond() throws ScriptException {
        this.setShapeProperty(1, "type", new Integer(256));
        this.setShapeSize(1, this.getMadParameter());
        this.setShapeProperty(1, "type", new Integer(1023));
    }

    private void hbond(boolean isCommand) throws ScriptException {
        if (this.statementLength == 2 && this.getToken((int)1).tok == 4102) {
            if (this.isSyntaxCheck) {
                return;
            }
            int n = this.viewer.autoHbond(null);
            this.scriptStatusOrBuffer(GT._("{0} hydrogen bonds", n));
            return;
        }
        if (this.statementLength == 2 && this.getToken((int)1).tok == 12291) {
            if (this.isSyntaxCheck) {
                return;
            }
            this.connect(0);
            return;
        }
        this.setShapeProperty(1, "type", new Integer(30720));
        this.setShapeSize(1, this.getMadParameter());
        this.setShapeProperty(1, "type", new Integer(1023));
    }

    private void configuration() throws ScriptException {
        BitSet bsConfigurations;
        if (!this.isSyntaxCheck && this.viewer.getDisplayModelIndex() <= -2) {
            this.error(1, "\"CONFIGURATION\"");
        }
        if (this.statementLength == 1) {
            bsConfigurations = this.viewer.setConformation();
            this.viewer.addStateScript("select", null, this.viewer.getSelectionSet(), null, "configuration", true, false);
        } else {
            this.checkLength(2);
            if (this.isSyntaxCheck) {
                return;
            }
            int n = this.intParameter(1);
            bsConfigurations = this.viewer.setConformation(n - 1);
            this.viewer.addStateScript("configuration " + n + ";", true, false);
        }
        if (this.isSyntaxCheck) {
            return;
        }
        boolean addHbonds = this.viewer.hasCalculatedHBonds(bsConfigurations);
        this.setShapeProperty(1, "type", new Integer(30720));
        this.viewer.setShapeSize(1, 0, Float.NaN, bsConfigurations);
        if (addHbonds) {
            this.viewer.autoHbond(bsConfigurations, bsConfigurations, null, 0.0f, 0.0f);
        }
        this.viewer.select(bsConfigurations, this.tQuiet);
    }

    private void vector() throws ScriptException {
        int code = 1;
        float fsize = Float.NaN;
        this.checkLength(-3);
        this.iToken = this.statementLength;
        block0 : switch (this.iToken) {
            case 1: {
                break;
            }
            case 2: {
                switch (this.getToken((int)1).tok) {
                    case 0x10000D: {
                        break block0;
                    }
                    case 0x10000C: {
                        code = 0;
                        break block0;
                    }
                    case 2: {
                        code = this.intParameter(1, 0, 19);
                        break block0;
                    }
                    case 3: {
                        code = -1;
                        fsize = this.floatParameter(1, 0.0f, 3.0f);
                        break block0;
                    }
                }
                this.error(6);
                break;
            }
            case 3: {
                if (this.tokAt(1) != 1073741877) break;
                this.setFloatProperty("vectorScale", this.floatParameter(2, -10.0f, 10.0f));
                return;
            }
        }
        this.setShapeSize(17, code, fsize);
    }

    private void dipole() throws ScriptException {
        String propertyName = null;
        Serializable propertyValue = null;
        boolean iHaveAtoms = false;
        boolean iHaveCoord = false;
        boolean idSeen = false;
        this.viewer.loadShape(16);
        if (this.tokAt(1) == 6 && this.listIsosurface(16)) {
            return;
        }
        this.setShapeProperty(16, "init", null);
        if (this.statementLength == 1) {
            this.setShapeProperty(16, "thisID", null);
            return;
        }
        for (int i = 1; i < this.statementLength; ++i) {
            propertyName = null;
            propertyValue = null;
            switch (this.getToken((int)i).tok) {
                case 0x10000D: {
                    propertyName = "on";
                    break;
                }
                case 0x10000C: {
                    propertyName = "off";
                    break;
                }
                case 12291: {
                    propertyName = "delete";
                    break;
                }
                case 2: 
                case 3: {
                    propertyName = "value";
                    propertyValue = new Float(this.floatParameter(i));
                    break;
                }
                case 0x40000007: {
                    propertyName = "atomBitset";
                }
                case 0x100001: {
                    if (propertyName == null) {
                        propertyName = iHaveAtoms || iHaveCoord ? "endSet" : "startSet";
                    }
                    propertyValue = this.expression(i);
                    i = this.iToken;
                    iHaveAtoms = true;
                    break;
                }
                case 7: 
                case 0x10000A: {
                    Point3f pt = this.getPoint3f(i, true);
                    i = this.iToken;
                    propertyName = iHaveAtoms || iHaveCoord ? "endCoord" : "startCoord";
                    propertyValue = pt;
                    iHaveCoord = true;
                    break;
                }
                case 605028354: {
                    propertyName = "bonds";
                    break;
                }
                case 4102: {
                    propertyName = "calculate";
                    break;
                }
                case 1: 
                case 0x101000A1: {
                    String cmd = this.parameterAsString(i);
                    if (cmd.equalsIgnoreCase("id")) {
                        this.setShapeId(16, ++i, idSeen);
                        i = this.iToken;
                        break;
                    }
                    if (cmd.equalsIgnoreCase("cross")) {
                        propertyName = "cross";
                        propertyValue = Boolean.TRUE;
                        break;
                    }
                    if (cmd.equalsIgnoreCase("noCross")) {
                        propertyName = "cross";
                        propertyValue = Boolean.FALSE;
                        break;
                    }
                    if (cmd.equalsIgnoreCase("offset")) {
                        float v = this.floatParameter(++i);
                        if (this.theTok == 2) {
                            propertyName = "offsetPercent";
                            propertyValue = new Integer((int)v);
                            break;
                        }
                        propertyName = "offset";
                        propertyValue = new Float(v);
                        break;
                    }
                    if (cmd.equalsIgnoreCase("value")) {
                        propertyName = "value";
                        propertyValue = new Float(this.floatParameter(++i));
                        break;
                    }
                    if (cmd.equalsIgnoreCase("offsetSide")) {
                        propertyName = "offsetSide";
                        propertyValue = new Float(this.floatParameter(++i));
                        break;
                    }
                    if (cmd.equalsIgnoreCase("width")) {
                        propertyName = "width";
                        propertyValue = new Float(this.floatParameter(++i));
                        break;
                    }
                    this.setShapeId(16, i, idSeen);
                    i = this.iToken;
                    break;
                }
                default: {
                    this.error(22);
                }
            }
            boolean bl = idSeen = this.theTok != 12291 && this.theTok != 4102;
            if (propertyName == null) continue;
            this.setShapeProperty(16, propertyName, propertyValue);
        }
        if (iHaveCoord || iHaveAtoms) {
            this.setShapeProperty(16, "set", null);
        }
    }

    private void animationMode() throws ScriptException {
        float startDelay = 1.0f;
        float endDelay = 1.0f;
        if (this.statementLength > 5) {
            this.error(2);
        }
        int animationMode = 0;
        switch (this.getToken((int)2).tok) {
            case 528415: {
                animationMode = 1;
                break;
            }
            case 1: {
                String cmd = this.parameterAsString(2);
                if (cmd.equalsIgnoreCase("once")) {
                    endDelay = 0.0f;
                    startDelay = 0.0f;
                    break;
                }
                if (cmd.equalsIgnoreCase("palindrome")) {
                    animationMode = 2;
                    break;
                }
                this.error(22);
            }
        }
        if (this.statementLength >= 4) {
            startDelay = endDelay = this.floatParameter(3);
            if (this.statementLength == 5) {
                endDelay = this.floatParameter(4);
            }
        }
        if (!this.isSyntaxCheck) {
            this.viewer.setAnimationReplayMode(animationMode, startDelay, endDelay);
        }
    }

    private void vibration() throws ScriptException {
        this.checkLength(-3);
        float period = 0.0f;
        switch (this.getToken((int)1).tok) {
            case 0x10000D: {
                this.checkLength(2);
                period = this.viewer.getVibrationPeriod();
                break;
            }
            case 0x10000C: {
                this.checkLength(2);
                period = 0.0f;
                break;
            }
            case 2: 
            case 3: {
                this.checkLength(2);
                period = this.floatParameter(1);
                break;
            }
            case 1073741877: {
                this.setFloatProperty("vibrationScale", this.floatParameter(2, -10.0f, 10.0f));
                return;
            }
            case 1: {
                String cmd = this.optParameterAsString(1);
                if (cmd.equalsIgnoreCase("period")) {
                    this.setFloatProperty("vibrationPeriod", this.floatParameter(2));
                    return;
                }
                this.error(22);
            }
            default: {
                period = -1.0f;
            }
        }
        if (period < 0.0f) {
            this.error(22);
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (period == 0.0f) {
            this.viewer.setVibrationOff();
            return;
        }
        this.viewer.setVibrationPeriod(-period);
    }

    private void animationDirection() throws ScriptException {
        this.checkLength(4);
        boolean negative = false;
        this.getToken(2);
        if (this.theTok == 0x10100090) {
            negative = true;
        } else if (this.theTok != 0x10100091) {
            this.error(22);
        }
        int direction = this.intParameter(3);
        if (direction != 1) {
            this.error(35, "-1", "1");
        }
        if (negative) {
            direction = -direction;
        }
        if (!this.isSyntaxCheck) {
            this.viewer.setAnimationDirection(direction);
        }
    }

    private void calculate() throws ScriptException {
        boolean isSurface = false;
        this.iToken = this.statementLength;
        if (this.iToken >= 2) {
            this.clearDefinedVariableAtomSets();
            switch (this.getToken((int)1).tok) {
                case 38797327: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.calculateStraightness();
                        this.viewer.addStateScript(this.thisCommand, false, true);
                    }
                    return;
                }
                case 1073742235: {
                    this.pointGroup();
                    return;
                }
                case 0x30000D: {
                    isSurface = true;
                }
                case 38797328: {
                    String type = this.optParameterAsString(2);
                    boolean isFrom = false;
                    if (!type.equalsIgnoreCase("within")) {
                        if (type.equalsIgnoreCase("from")) {
                            isFrom = true;
                        } else if (type.length() > 0) {
                            isFrom = true;
                            --this.iToken;
                        } else if (!isSurface) {
                            isFrom = true;
                        }
                    }
                    BitSet bs = this.iToken + 1 < this.statementLength ? this.expression(++this.iToken) : this.viewer.getSelectionSet();
                    this.checkLength(++this.iToken);
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    this.viewer.calculateSurface(bs, isFrom ? Float.MAX_VALUE : -1.0f);
                    return;
                }
                case 1: {
                    if (!this.parameterAsString(1).equalsIgnoreCase("AROMATIC")) break;
                    this.checkLength(2);
                    if (!this.isSyntaxCheck) {
                        this.viewer.assignAromaticBonds();
                    }
                    return;
                }
                case 538447897: {
                    if (this.statementLength == 2) {
                        if (!this.isSyntaxCheck) {
                            this.viewer.autoHbond(null);
                        }
                        return;
                    }
                    BitSet bs1 = this.expression(2);
                    BitSet bs2 = this.expression(this.iToken + 1);
                    if (!this.isSyntaxCheck) {
                        int nBonds = this.viewer.autoHbond(bs1, bs2, null, -1.0f, -1.0f);
                        this.showString(nBonds + " hydrogen bonds created");
                    }
                    return;
                }
                case 30412803: {
                    BitSet bs;
                    BitSet bitSet = bs = this.statementLength == 2 ? null : this.expression(2);
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    if (bs == null) {
                        bs = this.viewer.getAtomBitSet(null);
                    }
                    this.viewer.calculateStructures(bs);
                    this.viewer.addStateScript(this.thisCommand, false, true);
                    return;
                }
            }
        }
        this.error(53, "CALCULATE", "aromatic? hbonds? polymers? straightness? structure? surfaceDistance FROM? surfaceDistance WITHIN?");
    }

    private void pointGroup() throws ScriptException {
        switch (this.tokAt(0)) {
            case 4102: {
                if (!this.isSyntaxCheck) {
                    this.showString(this.viewer.calculatePointGroup());
                }
                return;
            }
            case 4148: {
                if (!this.isSyntaxCheck) {
                    this.showString(this.viewer.getPointGroupAsString(false, null, 0, 0.0f));
                }
                return;
            }
        }
        int pt = 2;
        String type = this.tokAt(pt) == 1073741877 ? "" : this.optParameterAsString(pt);
        float scale = 1.0f;
        int index = 0;
        if (type.length() > 0 && this.isFloatParameter(++pt)) {
            index = this.intParameter(pt++);
        }
        if (this.tokAt(pt) == 1073741877) {
            scale = this.floatParameter(++pt);
        }
        if (!this.isSyntaxCheck) {
            this.runScript(this.viewer.getPointGroupAsString(true, type, index, scale));
        }
    }

    private void dots(int iShape) throws ScriptException {
        if (!this.isSyntaxCheck) {
            this.viewer.loadShape(iShape);
        }
        this.setShapeProperty(iShape, "init", null);
        int code = 0;
        float fsize = Float.NaN;
        int ipt = 1;
        switch (this.getToken((int)1).tok) {
            case 0x40000088: {
                this.restrictSelected(false);
                code = 1;
                break;
            }
            case 0x10000D: 
            case 38797589: {
                code = 1;
                break;
            }
            case 38797321: {
                code = -1;
                break;
            }
            case 0x10000C: {
                break;
            }
            case 0x10100091: {
                fsize = this.floatParameter(++ipt, 0.0f, 16.0f);
                code = 1;
                break;
            }
            case 3: {
                fsize = this.floatParameter(ipt, 0.0f, 16.0f);
                code = -1;
                break;
            }
            case 2: {
                int dotsParam = this.intParameter(ipt++);
                if (this.statementLength > ipt && this.statement[ipt].tok == 592445697) {
                    this.setShapeProperty(iShape, "atom", new Integer(dotsParam));
                    this.setShapeProperty(iShape, "radius", new Float(this.floatParameter(++ipt)));
                    if (this.statementLength > ipt + 1 && this.statement[++ipt].tok == 558895366) {
                        this.setShapeProperty(iShape, "colorRGB", new Integer(this.getArgbParam(++ipt)));
                    }
                    if (this.getToken((int)ipt).tok != 0x40000007) {
                        this.error(22);
                    }
                    this.setShapeProperty(iShape, "dots", this.statement[ipt].value);
                    return;
                }
                if (dotsParam < 0 || dotsParam > 1000) {
                    this.integerOutOfRange(0, 1000);
                }
                code = dotsParam == 0 ? 0 : dotsParam + 1;
                break;
            }
            case 38797313: {
                code = Short.MAX_VALUE;
                if (this.tokAt(2) != 2) break;
                code += this.intParameter(2);
                break;
            }
            case 0x2500002: {
                code = Short.MIN_VALUE;
                if (this.tokAt(2) != 2) break;
                code -= this.intParameter(2);
                break;
            }
            default: {
                this.error(6);
            }
        }
        this.setShapeSize(iShape, code, fsize);
    }

    private void proteinShape(int shapeType) throws ScriptException {
        int mad = 0;
        switch (this.getToken((int)1).tok) {
            case 0x40000088: {
                if (this.isSyntaxCheck) {
                    return;
                }
                this.restrictSelected(false);
                mad = -1;
                break;
            }
            case 0x10000D: {
                mad = -1;
                break;
            }
            case 0x10000C: {
                break;
            }
            case 30412803: {
                mad = -2;
                break;
            }
            case 38797585: 
            case 0x4000000E: {
                mad = -4;
                break;
            }
            case 2: {
                mad = this.intParameter(1, 0, 499) * 8;
                break;
            }
            case 3: {
                mad = (int)(this.floatParameter(1, 0.0f, 4.0f) * 2000.0f);
                break;
            }
            case 0x40000007: {
                if (!this.isSyntaxCheck) {
                    this.viewer.loadShape(shapeType);
                }
                this.setShapeProperty(shapeType, "bitset", this.theToken.value);
                return;
            }
            default: {
                this.error(6);
            }
        }
        this.setShapeSize(shapeType, mad);
    }

    private void animation() throws ScriptException {
        boolean animate = false;
        switch (this.getToken((int)1).tok) {
            case 0x10000D: {
                animate = true;
            }
            case 0x10000C: {
                if (this.isSyntaxCheck) break;
                this.viewer.setAnimationOn(animate);
                break;
            }
            case 4116: {
                this.frame(2);
                break;
            }
            case 1073741852: {
                this.animationMode();
                break;
            }
            case 0x4000000D: {
                this.animationDirection();
                break;
            }
            case 1: {
                String str = this.parameterAsString(1);
                if (str.equalsIgnoreCase("fps")) {
                    this.checkLength(3);
                    this.setIntProperty("animationFps", this.intParameter(2));
                    break;
                }
            }
            default: {
                this.frameControl(1, true);
            }
        }
    }

    private void file() throws ScriptException {
        this.checkLength(2);
        int file = this.intParameter(1);
        if (this.isSyntaxCheck) {
            return;
        }
        int modelIndex = this.viewer.getModelNumberIndex(file * 1000000 + 1, false, false);
        int modelIndex2 = -1;
        if (modelIndex >= 0) {
            modelIndex2 = this.viewer.getModelNumberIndex((file + 1) * 1000000 + 1, false, false);
            if (modelIndex2 < 0) {
                modelIndex2 = this.viewer.getModelCount();
            }
            --modelIndex2;
        }
        this.viewer.setAnimationOn(false);
        this.viewer.setAnimationDirection(1);
        this.viewer.setAnimationRange(modelIndex, modelIndex2);
        this.viewer.setCurrentModelIndex(-1);
    }

    private void frame(int offset) throws ScriptException {
        boolean useModelNumber = true;
        if (this.statementLength == 1 && offset == 1) {
            int modelIndex = this.viewer.getCurrentModelIndex();
            if (!this.isSyntaxCheck && modelIndex >= 0 && (modelIndex = this.viewer.getJmolDataSourceFrame(modelIndex)) >= 0) {
                this.viewer.setCurrentModelIndex(Integer.MIN_VALUE);
            }
            return;
        }
        String p1 = this.optParameterAsString(1);
        if (this.statementLength == 3 && p1.equalsIgnoreCase("Title")) {
            if (!this.isSyntaxCheck) {
                this.viewer.setFrameTitle(this.parameterAsString(2));
            }
            return;
        }
        if (p1.equalsIgnoreCase("ALIGN")) {
            BitSet bs;
            BitSet bitSet = bs = this.statementLength == 2 || this.tokAt(2) == 0x10000B ? null : this.expression(2);
            if (!this.isSyntaxCheck) {
                this.viewer.setFrameOffsets(bs);
            }
            return;
        }
        if (this.getToken((int)offset).tok == 0x10100090) {
            this.checkLength(++offset + 1);
            if (this.getToken((int)offset).tok != 2 || this.intParameter(offset) != 1) {
                this.error(22);
            }
            if (!this.isSyntaxCheck) {
                this.viewer.setAnimationPrevious();
            }
            return;
        }
        boolean isPlay = false;
        boolean isRange = false;
        boolean isAll = false;
        boolean isHyphen = false;
        int[] frameList = new int[]{-1, -1};
        int nFrames = 0;
        block9: for (int i = offset; i < this.statementLength; ++i) {
            switch (this.getToken((int)i).tok) {
                case 0x100003: 
                case 0x101000A1: {
                    this.checkLength(offset + (isRange ? 2 : 1));
                    isAll = true;
                    continue block9;
                }
                case 0x10100090: {
                    if (nFrames != 1) {
                        this.error(22);
                    }
                    isHyphen = true;
                    continue block9;
                }
                case 0x10000B: {
                    this.checkLength(offset + 1);
                    continue block9;
                }
                case 3: {
                    useModelNumber = false;
                    if (this.floatParameter(i) < 0.0f) {
                        isHyphen = true;
                    }
                }
                case 2: {
                    int iFrame;
                    if (nFrames == 2) {
                        this.error(22);
                    }
                    if ((iFrame = this.statement[i].intValue) >= 1000 && iFrame < 1000000 && this.viewer.haveFileSet()) {
                        iFrame = iFrame / 1000 * 1000000 + iFrame % 1000;
                    }
                    if (!useModelNumber && iFrame == 0) {
                        isAll = true;
                    }
                    if (iFrame >= 1000000) {
                        useModelNumber = false;
                    }
                    frameList[nFrames++] = iFrame;
                    continue block9;
                }
                case 1073741864: {
                    isPlay = true;
                    continue block9;
                }
                case 1073741868: {
                    isRange = true;
                    continue block9;
                }
                default: {
                    this.checkLength(offset + 1);
                    this.frameControl(i, false);
                    return;
                }
            }
        }
        boolean haveFileSet = this.viewer.haveFileSet();
        if (isRange && nFrames == 0) {
            isAll = true;
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (isAll) {
            this.viewer.setAnimationOn(false);
            this.viewer.setAnimationRange(-1, -1);
            if (!isRange) {
                this.viewer.setCurrentModelIndex(-1);
            }
            return;
        }
        if (nFrames == 2 && !isRange) {
            isHyphen = true;
        }
        if (haveFileSet) {
            useModelNumber = false;
        } else if (useModelNumber) {
            for (int i = 0; i < nFrames; ++i) {
                if (frameList[i] < 0) continue;
                int n = i;
                frameList[n] = frameList[n] % 1000000;
            }
        }
        int modelIndex = this.viewer.getModelNumberIndex(frameList[0], useModelNumber, false);
        int modelIndex2 = -1;
        if (haveFileSet && nFrames == 1 && modelIndex < 0 && frameList[0] != 0) {
            if (frameList[0] < 1000000) {
                frameList[0] = frameList[0] * 1000000;
            }
            if (frameList[0] % 1000000 == 0) {
                frameList[0] = frameList[0] + 1;
                modelIndex = this.viewer.getModelNumberIndex(frameList[0], false, false);
                if (modelIndex >= 0) {
                    modelIndex2 = this.viewer.getModelNumberIndex(frameList[0] + 1000000, false, false);
                    if (modelIndex2 < 0) {
                        modelIndex2 = this.viewer.getModelCount();
                    }
                    --modelIndex2;
                    if (isRange) {
                        nFrames = 2;
                    } else if (!isHyphen && modelIndex2 != modelIndex) {
                        isHyphen = true;
                    }
                    isRange = isRange || modelIndex == modelIndex2;
                }
            } else {
                return;
            }
        }
        if (!isPlay && !isRange || modelIndex >= 0) {
            this.viewer.setCurrentModelIndex(modelIndex, false);
        }
        if (isPlay && nFrames == 2 || isRange || isHyphen) {
            if (modelIndex2 < 0) {
                modelIndex2 = this.viewer.getModelNumberIndex(frameList[1], useModelNumber, false);
            }
            this.viewer.setAnimationOn(false);
            this.viewer.setAnimationDirection(1);
            this.viewer.setAnimationRange(modelIndex, modelIndex2);
            this.viewer.setCurrentModelIndex(isHyphen && !isRange ? -1 : (modelIndex >= 0 ? modelIndex : 0), false);
        }
        if (isPlay) {
            this.viewer.resumeAnimation();
        }
    }

    BitSet bitSetForModelFileNumber(int m) {
        int pt;
        BitSet bs = new BitSet();
        if (this.isSyntaxCheck) {
            return bs;
        }
        int modelCount = this.viewer.getModelCount();
        boolean haveFileSet = this.viewer.haveFileSet();
        if (m < 1000000 && haveFileSet) {
            m *= 1000000;
        }
        if ((pt = m % 1000000) == 0) {
            int model2;
            int model1 = this.viewer.getModelNumberIndex(m + 1, false, false);
            if (model1 < 0) {
                return bs;
            }
            int n = model2 = m == 0 ? modelCount : this.viewer.getModelNumberIndex(m + 1000001, false, false);
            if (model1 < 0) {
                model1 = 0;
            }
            if (model2 < 0) {
                model2 = modelCount;
            }
            if (this.viewer.isTrajectory(model1)) {
                model2 = model1 + 1;
            }
            for (int j = model1; j < model2; ++j) {
                bs.or(this.viewer.getModelAtomBitSet(j, false));
            }
        } else {
            int modelIndex = this.viewer.getModelNumberIndex(m, false, true);
            if (modelIndex >= 0) {
                bs.or(this.viewer.getModelAtomBitSet(modelIndex, false));
            }
        }
        return bs;
    }

    private void frameControl(int i, boolean isSubCmd) throws ScriptException {
        this.checkLength(i + 1);
        int tok = this.getToken((int)i).tok;
        if (this.isSyntaxCheck) {
            switch (tok) {
                case 20485: 
                case 266286: 
                case 1073741848: 
                case 1073741854: 
                case 1073741864: 
                case 1073741865: 
                case 1073741867: 
                case 0x40000030: {
                    return;
                }
            }
        } else {
            switch (tok) {
                case 1073741865: {
                    this.viewer.reverseAnimation();
                }
                case 266286: 
                case 1073741864: {
                    this.viewer.resumeAnimation();
                    return;
                }
                case 20485: {
                    this.viewer.pauseAnimation();
                    return;
                }
                case 1073741854: {
                    this.viewer.setAnimationNext();
                    return;
                }
                case 1073741867: {
                    this.viewer.setAnimationPrevious();
                    return;
                }
                case 0x40000030: {
                    this.viewer.rewindAnimation();
                    return;
                }
                case 1073741848: {
                    this.viewer.setAnimationLast();
                    return;
                }
            }
        }
        this.error(22);
    }

    private int getShapeType(int tok) throws ScriptException {
        int iShape = JmolConstants.shapeTokenIndex(tok);
        if (iShape < 0) {
            this.error(49);
        }
        return iShape;
    }

    private void font(int shapeType, float fontsize) throws ScriptException {
        String fontface = "SansSerif";
        String fontstyle = "Plain";
        int sizeAdjust = 0;
        float scaleAngstromsPerPixel = -1.0f;
        this.iToken = this.statementLength;
        switch (this.iToken) {
            case 6: {
                scaleAngstromsPerPixel = this.floatParameter(5);
                if (scaleAngstromsPerPixel >= 5.0f) {
                    scaleAngstromsPerPixel = this.viewer.getZoomSetting() / scaleAngstromsPerPixel / this.viewer.getScalePixelsPerAngstrom(false);
                }
            }
            case 5: {
                if (this.getToken((int)4).tok != 1) {
                    this.error(22);
                }
                fontstyle = this.parameterAsString(4);
            }
            case 4: {
                if (this.getToken((int)3).tok != 1) {
                    this.error(22);
                }
                fontface = this.parameterAsString(3);
                if (!this.isFloatParameter(2)) {
                    this.error(34);
                }
                fontsize = this.floatParameter(2);
                shapeType = this.getShapeType(this.getToken((int)1).tok);
                break;
            }
            case 3: {
                if (!this.isFloatParameter(2)) {
                    this.error(34);
                }
                if (shapeType == -1) {
                    shapeType = this.getShapeType(this.getToken((int)1).tok);
                    fontsize = this.floatParameter(2);
                    break;
                }
                if (!(fontsize >= 1.0f)) break;
                sizeAdjust = 5;
                fontsize += (float)5;
                break;
            }
            default: {
                if (shapeType == 4) {
                    fontsize = 13.0f;
                    break;
                }
                this.error(2);
            }
        }
        if (shapeType == 4) {
            if (fontsize < 0.0f || fontsize >= 1.0f && (fontsize < 6.0f || fontsize > 63.0f)) {
                this.integerOutOfRange(6 - sizeAdjust, 63 - sizeAdjust);
            }
            this.setShapeProperty(4, "setDefaults", this.viewer.getNoneSelected());
        }
        if (this.isSyntaxCheck) {
            return;
        }
        Font3D font3d = this.viewer.getFont3D(fontface, fontstyle, fontsize);
        this.viewer.loadShape(shapeType);
        this.setShapeProperty(shapeType, "font", font3d);
        if (scaleAngstromsPerPixel >= 0.0f) {
            this.setShapeProperty(shapeType, "scalereference", new Float(scaleAngstromsPerPixel));
        }
    }

    private void set() throws ScriptException {
        String key;
        if (this.statementLength == 1) {
            this.showString(this.viewer.getAllSettings(null));
            return;
        }
        boolean isJmolSet = this.parameterAsString(0).equals("set");
        if (isJmolSet && this.statementLength == 2 && (key = this.parameterAsString(1)).indexOf("?") >= 0) {
            this.showString(this.viewer.getAllSettings(key.substring(0, key.indexOf("?"))));
            return;
        }
        boolean showing = !this.isSyntaxCheck && !this.tQuiet && this.scriptLevel <= this.scriptReportingLevel && !((String)this.statement[0].value).equals("var");
        int val = Integer.MAX_VALUE;
        int n = 0;
        switch (this.getToken((int)1).tok) {
            case 537399298: {
                this.axes(2);
                return;
            }
            case 536875012: {
                this.background(2);
                return;
            }
            case 605556745: {
                this.boundbox(2);
                return;
            }
            case 537399317: {
                this.frank(2);
                return;
            }
            case 536875034: {
                this.history(2);
                return;
            }
            case 752374019: {
                this.label(2);
                return;
            }
            case 540545088: {
                this.unitcell(2);
                return;
            }
            case 536883204: 
            case 537399347: {
                this.selectionHalo(2);
                return;
            }
            case 0x20000002: {
                this.setBondmode();
                return;
            }
            case 536891393: {
                this.setEcho();
                return;
            }
            case 0x20000003: {
                this.checkLength23();
                this.font(4, this.statementLength == 2 ? 0.0f : this.floatParameter(2));
                return;
            }
            case 538447897: {
                this.setHbond();
                return;
            }
            case 538447907: {
                this.setMonitor();
                return;
            }
            case 642777357: {
                key = this.parameterAsString(1).toLowerCase();
                if (key.startsWith("property_")) break;
                this.setProperty();
                return;
            }
            case 0x20000004: {
                this.setPicking();
                return;
            }
            case 0x2000000D: {
                this.setPickingStyle();
                return;
            }
            case 537399351: {
                this.checkLength(4);
                this.setSpin(this.parameterAsString(2), (int)this.floatParameter(3));
                return;
            }
            case 537399352: {
                this.setSsbond();
                return;
            }
            case 0x2000000B: {
                this.setFloatProperty("scaleAngstromsPerInch", this.floatSetting(2));
                return;
            }
            case 558891272: {
                n = this.intSetting(2);
                if (!this.isSyntaxCheck) {
                    this.viewer.setFormalCharges(n);
                }
                return;
            }
            case 0x20000005: {
                if (this.statementLength == 2 || this.statement[2].tok != 2) {
                    key = "specular";
                    break;
                }
            }
            case 0x20000006: {
                key = "specularPercent";
                break;
            }
            case 0x20000001: {
                key = "ambientPercent";
                break;
            }
            case 0x2000000C: {
                key = "diffusePercent";
                break;
            }
            case 0x20000007: {
                val = this.intSetting(2);
                if (val >= 0) {
                    key = "specularPower";
                    break;
                }
                if (val < -10 || val > -1) {
                    this.integerOutOfRange(-10, -1);
                }
                val = -val;
                key = "specularExponent";
                break;
            }
            case 0x20000008: {
                key = "specularExponent";
                break;
            }
            case 605028354: {
                key = "showMultipleBonds";
                break;
            }
            case 537399355: {
                key = "strandCount";
                break;
            }
            case 0x20300003: {
                key = "selectHetero";
                break;
            }
            case 540016644: {
                key = "selectHydrogen";
                break;
            }
            case 592445697: {
                key = "solventProbeRadius";
                break;
            }
            case 540016651: {
                key = "solventProbe";
                break;
            }
            case 0x2000000A: 
            case 558895366: {
                key = "defaultColorScheme";
                break;
            }
            default: {
                key = this.parameterAsString(1);
                if (key.charAt(0) == '_') {
                    this.error(22);
                }
                if (key.equalsIgnoreCase("toggleLabel") && this.setLabel("toggle")) {
                    return;
                }
                if (key.toLowerCase().indexOf("label") == 0 && Parser.isOneOf(key.substring(5).toLowerCase(), "front;group;atom;offset;pointer;alignment;toggle;scalereference") && this.setLabel(key.substring(5))) {
                    return;
                }
                if (key.equalsIgnoreCase("userColorScheme")) {
                    this.setUserColors();
                    return;
                }
                if (key.equalsIgnoreCase("defaultLattice")) {
                    int ijk;
                    Vector v = (Vector)this.parameterExpression(2, 0, "XXX", true);
                    if (v == null || v.size() == 0) {
                        this.error(22);
                    }
                    ScriptVariable token = (ScriptVariable)v.elementAt(0);
                    Point3f pt = token.tok == 7 ? (Point3f)token.value : ((ijk = ScriptVariable.iValue(token)) < 555 ? new Point3f() : this.viewer.getSymmetry().ijkToPoint3f(ijk + 111));
                    if (!this.isSyntaxCheck) {
                        this.viewer.setDefaultLattice(pt);
                    }
                    return;
                }
                if (key.equalsIgnoreCase("defaultDrawArrowScale")) {
                    this.setFloatProperty(key, this.floatSetting(2));
                    return;
                }
                if (key.equalsIgnoreCase("logLevel")) {
                    int ilevel = this.intSetting(2);
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    this.setIntProperty("logLevel", ilevel);
                    return;
                }
                if (key.equalsIgnoreCase("backgroundModel")) {
                    int modelNumber;
                    String modelDotted = this.stringSetting(2, false);
                    boolean useModelNumber = false;
                    if (modelDotted.indexOf(".") < 0) {
                        modelNumber = Parser.parseInt(modelDotted);
                        useModelNumber = true;
                    } else {
                        modelNumber = JmolConstants.modelValue(modelDotted);
                    }
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    int modelIndex = this.viewer.getModelNumberIndex(modelNumber, useModelNumber, true);
                    this.viewer.setBackgroundModelIndex(modelIndex);
                    return;
                }
                if (key.equalsIgnoreCase("language")) {
                    String lang = this.stringSetting(2, isJmolSet);
                    this.setStringProperty(key, lang);
                    return;
                }
                if (key.equalsIgnoreCase("trajectory") || key.equalsIgnoreCase("trajectories")) {
                    ScriptVariable token = this.tokenSetting(2);
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    if (token.tok == 3) {
                        this.viewer.getModelNumberIndex(token.intValue, false, true);
                    }
                    return;
                }
                if (key.equalsIgnoreCase("showSelections")) {
                    key = "selectionHalos";
                    break;
                }
                if (!key.equalsIgnoreCase("measurementNumbers")) break;
                key = "measurementLabels";
            }
        }
        if (this.getContextVariableAsVariable(key) != null || !this.setParameter(key, val, isJmolSet, showing)) {
            int tok2 = this.tokAt(1) == 0x100001 ? 0 : this.tokAt(2);
            int setType = this.statement[0].intValue;
            int pt = tok2 == 269484420 ? 3 : (setType == 61 && !key.equals("return") && tok2 != 269484420 ? 0 : 2);
            this.setVariable(pt, 0, key, showing, setType);
            if (!isJmolSet) {
                return;
            }
        }
        if (showing) {
            this.viewer.showParameter(key, true, 80);
        }
    }

    private void setVariable(int pt, int ptMax, String key, boolean showing, int setType) throws ScriptException {
        boolean needVariable;
        Object v;
        boolean isUserVariable;
        BitSet bs = null;
        String propertyName = "";
        int tokProperty = 0;
        boolean isArrayItem = this.statement[0].intValue == 91;
        boolean settingProperty = false;
        boolean isExpression = false;
        boolean settingData = key.startsWith("property_");
        ScriptVariable t = settingData ? null : this.getContextVariableAsVariable(key);
        boolean bl = isUserVariable = t != null;
        if (pt > 0 && this.tokAt(pt - 1) == 0x100001) {
            bs = this.expression(pt - 1);
            pt = this.iToken + 1;
            isExpression = true;
        }
        if (this.tokAt(pt) == 0x100008) {
            ScriptVariable token;
            settingProperty = true;
            if ((token = this.getBitsetPropertySelector(++pt, true)) == null) {
                this.error(22);
            }
            if (this.tokAt(++pt) != 269484420) {
                this.error(22);
            }
            ++pt;
            tokProperty = token.intValue;
            propertyName = (String)token.value;
        }
        if (isExpression && !settingProperty) {
            this.error(22);
        }
        if ((v = this.parameterExpression(pt, ptMax, key, true, -1, isArrayItem, null, null)) == null) {
            return;
        }
        int nv = ((Vector)v).size();
        if (nv == 0 || !isArrayItem && nv > 1 || isArrayItem && nv != 3) {
            this.error(22);
        }
        if (this.isSyntaxCheck) {
            return;
        }
        ScriptVariable tv = (ScriptVariable)((Vector)v).get(isArrayItem ? 2 : 0);
        boolean bl2 = needVariable = !isUserVariable && !isExpression && !settingData && (isArrayItem || settingProperty || !(tv.value instanceof String) && tv.tok != 2 && !(tv.value instanceof Integer) && !(tv.value instanceof Float) && !(tv.value instanceof Boolean));
        if (needVariable) {
            t = this.viewer.getOrSetNewVariable(key, true);
            if (t == null) {
                this.error(22);
            }
            isUserVariable = true;
        }
        if (isArrayItem) {
            int index = ScriptVariable.iValue((ScriptVariable)((Vector)v).get(0));
            t.setSelectedValue(index, tv);
            return;
        }
        if (settingProperty) {
            if (!isExpression) {
                if (!(t.value instanceof BitSet)) {
                    this.error(22);
                }
                bs = (BitSet)t.value;
            }
            if (propertyName.startsWith("property_")) {
                this.viewer.setData(propertyName, new Object[]{propertyName, ScriptVariable.sValue(tv), bs}, this.viewer.getAtomCount(), 0, 0, tv.tok == 6 ? Integer.MAX_VALUE : Integer.MIN_VALUE, 0);
                return;
            }
            this.setBitsetProperty(bs, tokProperty, ScriptVariable.iValue(tv), ScriptVariable.fValue(tv), tv);
            return;
        }
        if (isUserVariable) {
            t.set(tv);
            return;
        }
        v = ScriptVariable.oValue(tv);
        if (key.startsWith("property_")) {
            int n = this.viewer.getAtomCount();
            if (v instanceof String[]) {
                v = TextFormat.join((String[])v, '\n', 0);
            }
            this.viewer.setData(key, new Object[]{key, "" + v, this.viewer.getSelectionSet()}, n, 0, 0, Integer.MIN_VALUE, 0);
            return;
        }
        if (v instanceof Boolean) {
            this.setBooleanProperty(key, (Boolean)v);
        } else if (v instanceof Integer) {
            this.setIntProperty(key, (Integer)v);
        } else if (v instanceof Float) {
            this.setFloatProperty(key, ((Float)v).floatValue());
        } else if (v instanceof String) {
            this.setStringProperty(key, (String)v);
        } else if (v instanceof Bond.BondSet) {
            this.setStringProperty(key, Escape.escape((BitSet)v, false));
        } else if (v instanceof BitSet) {
            this.setStringProperty(key, Escape.escape((BitSet)v));
        } else if (v instanceof Point3f) {
            String str = Escape.escape((Point3f)v);
            this.setStringProperty(key, str);
        } else if (v instanceof Point4f) {
            String str = Escape.escape((Point4f)v);
            this.setStringProperty(key, str);
        } else {
            System.out.println("ERROR -- return from propertyExpression was " + v);
        }
    }

    private boolean setParameter(String key, int intVal, boolean isJmolSet, boolean showing) throws ScriptException {
        String lcKey = key.toLowerCase();
        if (key.equalsIgnoreCase("scriptReportingLevel")) {
            intVal = this.intSetting(2);
            if (!this.isSyntaxCheck) {
                this.scriptReportingLevel = intVal;
                this.setIntProperty(key, intVal);
            }
            return true;
        }
        if (key.equalsIgnoreCase("historyLevel")) {
            intVal = this.intSetting(2);
            if (!this.isSyntaxCheck) {
                this.commandHistoryLevelMax = intVal;
                this.setIntProperty(key, intVal);
            }
            return true;
        }
        if (key.equalsIgnoreCase("dipoleScale")) {
            return this.setFloatProperty("dipoleScale", this.floatSetting(2, -10.0f, 10.0f));
        }
        if (key.equalsIgnoreCase("axesScale")) {
            return this.setFloatProperty("axesScale", this.floatSetting(2, -100.0f, 100.0f));
        }
        if (key.equalsIgnoreCase("measurementUnits")) {
            return this.setMeasurementUnits(this.stringSetting(2, isJmolSet));
        }
        if (key.equalsIgnoreCase("defaultVDW")) {
            String val;
            String string = val = this.statementLength == 3 && JmolConstants.getVdwType(this.parameterAsString(2)) >= 0 ? this.parameterAsString(2) : this.stringSetting(2, false);
            if (JmolConstants.getVdwType(val) < 0) {
                this.error(22);
            }
            this.setStringProperty(key, val);
            return true;
        }
        if (Parser.isOneOf(lcKey, "defaults;defaultcolorscheme")) {
            String val;
            this.theTok = this.tokAt(2);
            if (this.theTok == 1073741847 || this.theTok == 1073741869) {
                val = this.parameterAsString(2).toLowerCase();
                this.checkLength(3);
            } else {
                val = this.stringSetting(2, false).toLowerCase();
            }
            if (!val.equals("jmol") && !val.equals("rasmol")) {
                this.error(22);
            }
            this.setStringProperty(key.equalsIgnoreCase("defaults") ? key : "defaultColorScheme", val);
            return true;
        }
        if (Parser.isOneOf(lcKey, "strandcount;strandcountformeshribbon;strandcountforstrands")) {
            return this.setIntProperty(key, this.intSetting(2, Integer.MAX_VALUE, 0, 20));
        }
        if (Parser.isOneOf(lcKey, "specularpercent;ambientpercent;diffusepercent;specularPower")) {
            return this.setIntProperty(key, this.intSetting(2, intVal, 0, 100));
        }
        if (key.equalsIgnoreCase("specularExponent")) {
            return this.setIntProperty(key, this.intSetting(2, intVal, 1, 10));
        }
        boolean isJmolParameter = this.viewer.isJmolVariable(key);
        if (isJmolSet && !isJmolParameter) {
            this.iToken = 1;
            if (!this.isStateScript) {
                this.error(50, "SET", key);
            }
            this.warning(51, "SET", key);
        }
        switch (this.statementLength) {
            case 2: {
                this.setBooleanProperty(key, true);
                return true;
            }
            case 3: {
                if (intVal != Integer.MAX_VALUE) {
                    this.setIntProperty(key, intVal);
                    return true;
                }
                this.getToken(2);
                if (this.theTok == 0x10000B) {
                    if (!this.isSyntaxCheck) {
                        this.viewer.removeUserVariable(key);
                    }
                } else if (!isJmolSet || this.theTok != 1) {
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private void axes(int index) throws ScriptException {
        String type = this.optParameterAsString(index).toLowerCase();
        if (this.statementLength == index + 1 && Parser.isOneOf(type, "window;unitcell;molecular")) {
            this.setBooleanProperty("axes" + type, true);
            return;
        }
        if (this.statementLength == index + 2 && type.equals("scale")) {
            this.setFloatProperty("axesScale", this.floatParameter(++index));
            return;
        }
        if (type.equals("position")) {
            Point3f xyp;
            if (this.tokAt(++index) == 0x10000C) {
                xyp = new Point3f();
            } else {
                xyp = this.xypParameter(index);
                if (xyp == null) {
                    this.error(22);
                }
                index = this.iToken;
            }
            this.setShapeProperty(27, "position", xyp);
            return;
        }
        int mad = this.getSetAxesTypeMad(index);
        if (!this.isSyntaxCheck) {
            this.viewer.setObjectMad(27, "axes", mad);
        }
    }

    private void boundbox(int index) throws ScriptException {
        boolean byCorner = false;
        if (this.tokAt(index) == 1) {
            byCorner = this.parameterAsString(index).equalsIgnoreCase("corners");
        }
        if (byCorner) {
            ++index;
        }
        if (this.isCenterParameter(index)) {
            this.expressionResult = null;
            Point3f pt1 = this.centerParameter(index);
            index = this.iToken + 1;
            if (byCorner || this.isCenterParameter(index)) {
                Point3f pt2 = byCorner ? this.centerParameter(index) : this.getPoint3f(index, true);
                index = this.iToken + 1;
                if (!this.isSyntaxCheck) {
                    this.viewer.setBoundBox(pt1, pt2, byCorner);
                }
            } else if (this.expressionResult != null && this.expressionResult instanceof BitSet) {
                if (!this.isSyntaxCheck) {
                    this.viewer.calcBoundBoxDimensions((BitSet)this.expressionResult);
                }
            } else {
                this.error(22);
            }
            if (index == this.statementLength) {
                return;
            }
        }
        int mad = this.getSetAxesTypeMad(index);
        if (!this.isSyntaxCheck) {
            this.viewer.setObjectMad(28, "boundbox", mad);
        }
    }

    private void unitcell(int index) throws ScriptException {
        if (this.statementLength == index + 1) {
            if (this.getToken((int)index).tok == 2 && this.intParameter(index) >= 111) {
                if (!this.isSyntaxCheck) {
                    this.viewer.setCurrentUnitCellOffset(this.intParameter(index));
                }
            } else {
                int mad = this.getSetAxesTypeMad(index);
                if (!this.isSyntaxCheck) {
                    this.viewer.setObjectMad(29, "unitCell", mad);
                }
            }
            return;
        }
        Point3f pt = (Point3f)this.getPointOrPlane(2, false, true, false, true, 3, 3);
        if (!this.isSyntaxCheck) {
            this.viewer.setCurrentUnitCellOffset(pt);
        }
    }

    private void frank(int index) throws ScriptException {
        this.setBooleanProperty("frank", this.booleanParameter(index));
    }

    private void setUserColors() throws ScriptException {
        Vector<Integer> v = new Vector<Integer>();
        for (int i = 2; i < this.statementLength; ++i) {
            int argb = this.getArgbParam(i);
            v.addElement(new Integer(argb));
            i = this.iToken;
        }
        if (this.isSyntaxCheck) {
            return;
        }
        int n = v.size();
        int[] scale = new int[n];
        int i = n;
        while (--i >= 0) {
            scale[i] = (Integer)v.elementAt(i);
        }
        Viewer.setUserScale(scale);
    }

    private void setBondmode() throws ScriptException {
        this.checkLength(3);
        boolean bondmodeOr = false;
        switch (this.getToken((int)2).tok) {
            case 0x10100060: {
                break;
            }
            case 0x10100050: {
                bondmodeOr = true;
                break;
            }
            default: {
                this.error(22);
            }
        }
        this.setBooleanProperty("bondModeOr", bondmodeOr);
    }

    private void selectionHalo(int pt) throws ScriptException {
        boolean showHalo = false;
        switch (pt == this.statementLength ? 0x10000D : this.getToken((int)pt).tok) {
            case 0x10000D: 
            case 0x30000A: {
                showHalo = true;
            }
            case 0x10000B: 
            case 0x10000C: 
            case 0x40000022: {
                this.setBooleanProperty("selectionHalos", showHalo);
                break;
            }
            default: {
                this.error(22);
            }
        }
    }

    private void setEcho() throws ScriptException {
        int modelIndex;
        String propertyName = "target";
        Object propertyValue = null;
        boolean echoShapeActive = true;
        int len = 3;
        switch (this.getToken((int)2).tok) {
            case 0x10000C: {
                this.checkLength(3);
                echoShapeActive = false;
                propertyName = "allOff";
                break;
            }
            case 12293: 
            case 3145752: {
                propertyName = "hidden";
                propertyValue = Boolean.TRUE;
                break;
            }
            case 0x10000D: 
            case 3145751: 
            case 536883204: {
                propertyName = "hidden";
                propertyValue = Boolean.FALSE;
                break;
            }
            case 0x10000B: {
                echoShapeActive = false;
            }
            case 0x100003: {
                this.checkLength(3);
            }
            case 1: 
            case 12289: 
            case 0x40000009: 
            case 1073741849: 
            case 1073741873: 
            case 1073741883: {
                propertyValue = this.parameterAsString(2);
                break;
            }
            case 22024203: {
                modelIndex = this.modelNumberParameter(3);
                if (this.isSyntaxCheck) {
                    return;
                }
                if (modelIndex >= this.viewer.getModelCount()) {
                    this.error(22);
                }
                propertyName = "model";
                propertyValue = new Integer(modelIndex);
                len = 4;
                break;
            }
            case 1073741945: {
                this.echo(3, true);
                return;
            }
            case 528397: {
                propertyName = "%zpos";
                propertyValue = new Integer((int)this.floatParameter(3));
                len = 4;
                break;
            }
            case 4: {
                this.echo(2, false);
                return;
            }
            default: {
                this.error(22);
            }
        }
        if (!this.isSyntaxCheck) {
            this.viewer.setEchoStateActive(echoShapeActive);
            this.viewer.loadShape(26);
            this.setShapeProperty(26, propertyName, propertyValue);
        }
        if (this.statementLength == len) {
            return;
        }
        propertyName = "align";
        propertyValue = null;
        if (this.statementLength == 4) {
            if (this.isCenterParameter(3)) {
                this.setShapeProperty(26, "xyz", this.centerParameter(3));
                return;
            }
            switch (this.getToken((int)3).tok) {
                case 0x10000C: {
                    propertyName = "off";
                    break;
                }
                case 3145752: {
                    propertyName = "hidden";
                    propertyValue = Boolean.TRUE;
                    break;
                }
                case 0x10000D: 
                case 3145751: {
                    propertyName = "hidden";
                    propertyValue = Boolean.FALSE;
                    break;
                }
                case 22024203: {
                    modelIndex = this.modelNumberParameter(4);
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    if (modelIndex >= this.viewer.getModelCount()) {
                        this.error(22);
                    }
                    propertyName = "model";
                    propertyValue = new Integer(modelIndex);
                    break;
                }
                case 1: 
                case 12289: 
                case 0x40000009: 
                case 1073741849: 
                case 1073741873: 
                case 1073741883: {
                    propertyValue = this.parameterAsString(3);
                    break;
                }
                default: {
                    this.error(22);
                }
            }
            this.setShapeProperty(26, propertyName, propertyValue);
            return;
        }
        if (this.statementLength == 5) {
            switch (this.tokAt(3)) {
                case 135271429: {
                    propertyName = "script";
                    propertyValue = this.parameterAsString(4);
                    break;
                }
                case 22024203: {
                    modelIndex = this.modelNumberParameter(4);
                    if (!this.isSyntaxCheck && modelIndex >= this.viewer.getModelCount()) {
                        this.error(22);
                    }
                    propertyName = "model";
                    propertyValue = new Integer(modelIndex);
                    break;
                }
                case 1073741945: {
                    this.echo(4, true);
                    return;
                }
                case 528397: {
                    propertyName = "%zpos";
                    propertyValue = new Integer((int)this.floatParameter(4));
                }
            }
            if (propertyValue != null) {
                this.setShapeProperty(26, propertyName, propertyValue);
                return;
            }
        }
        this.getToken(4);
        int i = 3;
        if (this.isCenterParameter(i)) {
            if (!this.isSyntaxCheck) {
                this.setShapeProperty(26, "xyz", this.centerParameter(i));
            }
            return;
        }
        String type = "xypos";
        propertyValue = this.xypParameter(i);
        if (propertyValue == null) {
            int pos = this.intParameter(i++);
            propertyValue = new Integer(pos);
            type = this.tokAt(i) == 269484194 ? "%xpos" : "xpos";
            this.setShapeProperty(26, type, propertyValue);
            int n = ++i;
            pos = this.intParameter(n);
            propertyValue = new Integer(pos);
            if (this.tokAt(++i) == 269484194) {
                type = "%ypos";
                ++i;
            } else {
                type = "ypos";
            }
        }
        this.setShapeProperty(26, type, propertyValue);
    }

    private boolean setLabel(String str) throws ScriptException {
        this.viewer.loadShape(4);
        Object propertyValue = null;
        this.setShapeProperty(4, "setDefaults", this.viewer.getNoneSelected());
        if (str.equals("scalereference")) {
            float scaleAngstromsPerPixel = this.floatParameter(2);
            if (scaleAngstromsPerPixel >= 5.0f) {
                scaleAngstromsPerPixel = this.viewer.getZoomSetting() / scaleAngstromsPerPixel / this.viewer.getScalePixelsPerAngstrom(false);
            }
            propertyValue = new Float(scaleAngstromsPerPixel);
        } else if (str.equals("offset")) {
            int xOffset = this.intParameter(2, -100, 100);
            int yOffset = this.intParameter(3, -100, 100);
            propertyValue = new Integer((xOffset & 0xFF) << 8 | yOffset & 0xFF);
        } else if (str.equals("alignment")) {
            switch (this.getToken((int)2).tok) {
                case 12289: 
                case 1073741849: 
                case 1073741873: {
                    str = "align";
                    propertyValue = this.theToken.value;
                    break;
                }
                default: {
                    this.error(22);
                    break;
                }
            }
        } else if (str.equals("pointer")) {
            int flags = 0;
            switch (this.getToken((int)2).tok) {
                case 0x10000B: 
                case 0x10000C: {
                    break;
                }
                case 536875012: {
                    flags |= 2;
                }
                case 0x10000D: {
                    flags |= 1;
                    break;
                }
                default: {
                    this.error(22);
                }
            }
            propertyValue = new Integer(flags);
        } else {
            boolean TF;
            if (str.equals("toggle")) {
                this.iToken = 1;
                BitSet bs = this.statementLength == 2 ? null : this.expression(2);
                this.checkLength(this.iToken + 1);
                if (!this.isSyntaxCheck) {
                    this.viewer.togglePickingLabel(bs);
                }
                return true;
            }
            this.iToken = 1;
            boolean bl = TF = this.statementLength == 2 || this.getToken((int)2).tok == 0x10000D;
            if (str.equals("front") || str.equals("group")) {
                if (!TF && this.tokAt(2) != 0x10000C) {
                    this.error(22);
                }
                if (!TF) {
                    str = "front";
                }
                propertyValue = TF ? Boolean.TRUE : Boolean.FALSE;
            } else if (str.equals("atom")) {
                if (!TF && this.tokAt(2) != 0x10000C) {
                    this.error(22);
                }
                str = "front";
                propertyValue = TF ? Boolean.FALSE : Boolean.TRUE;
            } else {
                return false;
            }
        }
        BitSet bs = this.iToken + 1 < this.statementLength ? this.expression(++this.iToken) : null;
        this.checkLength(this.iToken + 1);
        if (this.isSyntaxCheck) {
            return true;
        }
        if (bs == null) {
            this.setShapeProperty(4, str, propertyValue);
        } else {
            this.viewer.setShapeProperty(4, str, propertyValue, bs);
        }
        return true;
    }

    private void setMonitor() throws ScriptException {
        boolean showMeasurementNumbers = false;
        this.checkLength(3);
        switch (this.tokAt(2)) {
            case 0x10000D: {
                showMeasurementNumbers = true;
            }
            case 0x10000C: {
                this.setShapeProperty(5, "showMeasurementNumbers", showMeasurementNumbers ? Boolean.TRUE : Boolean.FALSE);
                return;
            }
            case 1: {
                this.setMeasurementUnits(this.parameterAsString(2));
                return;
            }
        }
        this.setShapeSize(5, this.getSetAxesTypeMad(2));
    }

    private boolean setMeasurementUnits(String units) throws ScriptException {
        if (!StateManager.isMeasurementUnit(units)) {
            this.error(50, "set measurementUnits ", units);
        }
        if (!this.isSyntaxCheck) {
            this.viewer.setMeasureDistanceUnits(units);
        }
        return true;
    }

    private void setProperty() throws ScriptException {
        this.checkLength(4);
        if (this.getToken((int)2).tok != 1) {
            this.error(39);
        }
        String propertyName = this.parameterAsString(2);
        switch (this.getToken((int)3).tok) {
            case 0x10000D: {
                this.setBooleanProperty(propertyName, true);
                break;
            }
            case 0x10000C: {
                this.setBooleanProperty(propertyName, false);
                break;
            }
            case 2: {
                this.setIntProperty(propertyName, this.intParameter(3));
                break;
            }
            case 3: {
                this.setFloatProperty(propertyName, this.floatParameter(3));
                break;
            }
            case 4: {
                this.setStringProperty(propertyName, this.stringParameter(3));
                break;
            }
            default: {
                this.error(50, "SET " + propertyName.toUpperCase(), this.parameterAsString(3));
            }
        }
    }

    private void setSpin(String key, int value) throws ScriptException {
        if (Parser.isOneOf(key = key.toLowerCase(), "x;y;z;fps")) {
            if (!this.isSyntaxCheck) {
                this.viewer.setSpin(key, value);
            }
            return;
        }
        this.error(50, "set SPIN ", this.parameterAsString(2));
    }

    private void setSsbond() throws ScriptException {
        this.checkLength(3);
        boolean ssbondsBackbone = false;
        switch (this.tokAt(2)) {
            case 3674115: {
                ssbondsBackbone = true;
                break;
            }
            case 0x30000C: {
                break;
            }
            default: {
                this.error(22);
            }
        }
        this.setBooleanProperty("ssbondsBackbone", ssbondsBackbone);
    }

    private void setHbond() throws ScriptException {
        this.checkLength(3);
        boolean bool = false;
        switch (this.tokAt(2)) {
            case 3674115: {
                bool = true;
            }
            case 0x30000C: {
                this.setBooleanProperty("hbondsBackbone", bool);
                break;
            }
            case 1073741880: {
                bool = true;
            }
            case 0x4000000F: {
                this.setBooleanProperty("hbondsSolid", bool);
                break;
            }
            default: {
                this.error(22);
            }
        }
    }

    private void setPicking() throws ScriptException {
        if (this.statementLength == 2) {
            this.setStringProperty("picking", "identify");
            return;
        }
        if (this.statementLength > 4 || this.tokAt(2) == 4) {
            this.setStringProperty("picking", this.stringSetting(2, false));
            return;
        }
        int i = 2;
        String type = "SELECT";
        switch (this.getToken((int)2).tok) {
            case 135280129: 
            case 537399351: 
            case 538447907: {
                this.checkLength34();
                if (this.statementLength != 4) break;
                type = this.parameterAsString(2).toUpperCase();
                if (type.equals("SPIN")) {
                    this.setIntProperty("pickingSpinRate", this.intParameter(3));
                    break;
                }
                i = 3;
                break;
            }
            default: {
                this.checkLength(3);
            }
        }
        String str = this.parameterAsString(i);
        switch (this.getToken((int)i).tok) {
            case 0x10000D: 
            case 0x40000022: {
                str = "identify";
                break;
            }
            case 0x10000B: {
                str = "off";
                break;
            }
            case 135280129: {
                str = "atom";
                break;
            }
            case 605028354: {
                str = "bond";
            }
        }
        int mode = JmolConstants.getPickingMode(str);
        if (mode < 0) {
            this.error(50, "SET PICKING " + type, str);
        }
        this.setStringProperty("picking", str);
    }

    private void setPickingStyle() throws ScriptException {
        if (this.statementLength > 4 || this.tokAt(2) == 4) {
            this.setStringProperty("pickingStyle", this.stringSetting(2, false));
            return;
        }
        int i = 2;
        boolean isMeasure = false;
        String type = "SELECT";
        switch (this.getToken((int)2).tok) {
            case 538447907: {
                isMeasure = true;
                type = "MEASURE";
            }
            case 135280129: {
                this.checkLength34();
                if (this.statementLength != 4) break;
                i = 3;
                break;
            }
            default: {
                this.checkLength(3);
            }
        }
        String str = this.parameterAsString(i);
        switch (this.getToken((int)i).tok) {
            case 0x10000B: 
            case 0x10000C: {
                str = isMeasure ? "measureoff" : "toggle";
                break;
            }
            case 0x10000D: {
                if (!isMeasure) break;
                str = "measure";
            }
        }
        if (JmolConstants.getPickingStyle(str) < 0) {
            this.error(50, "SET PICKINGSTYLE " + type, str);
        }
        this.setStringProperty("pickingStyle", str);
    }

    private void save() throws ScriptException {
        if (this.statementLength > 1) {
            String saveName = this.optParameterAsString(2);
            switch (this.tokAt(1)) {
                case 1073741874: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.saveOrientation(saveName);
                    }
                    return;
                }
                case 1073741862: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.saveOrientation(saveName);
                    }
                    return;
                }
                case 605028354: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.saveBonds(saveName);
                    }
                    return;
                }
                case 1073741882: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.saveState(saveName);
                    }
                    return;
                }
                case 30412803: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.saveStructure(saveName);
                    }
                    return;
                }
                case 0x100006: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.saveCoordinates(saveName, this.viewer.getSelectionSet());
                    }
                    return;
                }
                case 1: {
                    if (!this.parameterAsString(1).equalsIgnoreCase("selection")) break;
                    if (!this.isSyntaxCheck) {
                        this.viewer.saveSelection(saveName);
                    }
                    return;
                }
            }
        }
        this.error(53, "SAVE", "bonds? coordinates? orientation? selection? state? structure?");
    }

    private void restore() throws ScriptException {
        if (this.statementLength > 1) {
            String saveName = this.optParameterAsString(2);
            if (this.getToken((int)1).tok != 1073741862) {
                this.checkLength23();
            }
            switch (this.getToken((int)1).tok) {
                case 1073741874: {
                    float timeSeconds;
                    float f = timeSeconds = this.statementLength > 3 ? this.floatParameter(3) : 0.0f;
                    if (timeSeconds < 0.0f) {
                        this.error(22);
                    }
                    if (!this.isSyntaxCheck) {
                        this.viewer.restoreRotation(saveName, timeSeconds);
                    }
                    return;
                }
                case 1073741862: {
                    float timeSeconds;
                    float f = timeSeconds = this.statementLength > 3 ? this.floatParameter(3) : 0.0f;
                    if (timeSeconds < 0.0f) {
                        this.error(22);
                    }
                    if (!this.isSyntaxCheck) {
                        this.viewer.restoreOrientation(saveName, timeSeconds);
                    }
                    return;
                }
                case 605028354: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.restoreBonds(saveName);
                    }
                    return;
                }
                case 0x100006: {
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    String script = this.viewer.getSavedCoordinates(saveName);
                    if (script == null) {
                        this.error(22);
                    }
                    this.runScript(script);
                    return;
                }
                case 1073741882: {
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    String state = this.viewer.getSavedState(saveName);
                    if (state == null) {
                        this.error(22);
                    }
                    this.runScript(state);
                    return;
                }
                case 30412803: {
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    String shape = this.viewer.getSavedStructure(saveName);
                    if (shape == null) {
                        this.error(22);
                    }
                    this.runScript(shape);
                    return;
                }
                case 1: {
                    if (!this.parameterAsString(1).equalsIgnoreCase("selection")) break;
                    if (!this.isSyntaxCheck) {
                        this.viewer.restoreSelection(saveName);
                    }
                    return;
                }
            }
        }
        this.error(53, "RESTORE", "bonds? coords? orientation? selection? state? structure?");
    }

    String write(Token[] args) throws ScriptException {
        boolean isImage;
        Token t;
        int pt = 0;
        boolean isApplet = this.viewer.isApplet();
        boolean isCommand = false;
        String driverList = this.viewer.getExportDriverList();
        if (args == null) {
            args = this.statement;
            isCommand = true;
            ++pt;
        }
        int argCount = isCommand ? this.statementLength : args.length;
        int tok = isCommand && args.length == 1 ? 0x4000000B : this.tokAt(pt, args);
        int len = 0;
        int width = -1;
        int height = -1;
        String type = "SPT";
        String data = "";
        String type2 = "";
        String fileName = null;
        boolean isCoord = false;
        boolean isShow = false;
        boolean isExport = false;
        BitSet bsFrames = null;
        int quality = Integer.MIN_VALUE;
        if (tok == 4 && (t = Token.getTokenFromName(ScriptVariable.sValue(args[pt]))) != null) {
            tok = t.tok;
        }
        switch (tok) {
            case 1073742235: {
                type = "PGRP";
                type2 = ScriptVariable.sValue(this.tokenAt(++pt, args)).toLowerCase();
                if (!type2.equals("draw")) break;
                ++pt;
                break;
            }
            case 135272453: {
                boolean isDerivative;
                type2 = ScriptVariable.sValue(this.tokenAt(++pt, args)).toLowerCase();
                if (Parser.isOneOf(type2, "w;x;y;z;a;r")) {
                    ++pt;
                } else {
                    type2 = "w";
                }
                type = ScriptVariable.sValue(this.tokenAt(pt, args)).toLowerCase();
                boolean bl = isDerivative = type.indexOf("deriv") == 0 || type.indexOf("diff") == 0;
                if (isDerivative || type2.equals("a") || type2.equals("r")) {
                    type2 = type2 + " difference" + (type.indexOf("2") >= 0 ? "2" : "");
                    if (isDerivative) {
                        type = ScriptVariable.sValue(this.tokenAt(++pt, args)).toLowerCase();
                    }
                }
                if (type.equals("draw")) {
                    type2 = type2 + " draw";
                    ++pt;
                }
                type2 = "quaternion " + type2;
                type = "QUAT";
                break;
            }
            case 1052714: {
                type2 = ScriptVariable.sValue(this.tokenAt(++pt, args)).toLowerCase();
                if (Parser.isOneOf(type2, "r")) {
                    ++pt;
                } else {
                    type2 = "";
                }
                type = ScriptVariable.sValue(this.tokenAt(pt, args)).toLowerCase();
                if (type.equals("draw")) {
                    type2 = type2 + " draw";
                    ++pt;
                }
                type2 = "ramachandran " + type2;
                type = "RAMA";
                break;
            }
            case 135499780: {
                type = "FUNCS";
                ++pt;
                break;
            }
            case 0x100006: 
            case 135272450: {
                type = ScriptVariable.sValue(this.tokenAt(++pt, args)).toLowerCase();
                type = "data";
                isCoord = true;
                break;
            }
            case 135271429: 
            case 1073741882: {
                ++pt;
                break;
            }
            case 4130: {
                type = "MO";
                ++pt;
                break;
            }
            case 4125: {
                type = "ISO";
                ++pt;
                break;
            }
            case 536875034: {
                type = "HIS";
                ++pt;
                break;
            }
            case 537038852: {
                pt += 2;
                type = "VAR";
                break;
            }
            case 156242439: {
                type = "FILE";
                ++pt;
                break;
            }
            case 1: 
            case 4: 
            case 4116: 
            case 1073741945: {
                type = ScriptVariable.sValue(this.tokenAt(pt, args)).toLowerCase();
                if (tok == 1073741945) {
                    ++pt;
                } else if (tok == 4116) {
                    if (args[++pt].tok == 0x100001 || args[pt].tok == 0x40000007) {
                        bsFrames = this.expression(args, pt, 0, true, false, true, true);
                        pt = this.iToken + 1;
                    } else {
                        bsFrames = this.viewer.getModelAtomBitSet(-1, false);
                    }
                    if (!this.isSyntaxCheck) {
                        bsFrames = this.viewer.getModelBitSet(bsFrames, true);
                    }
                } else if (Parser.isOneOf(type, driverList.toLowerCase())) {
                    ++pt;
                    type = type.substring(0, 1).toUpperCase() + type.substring(1);
                    isExport = true;
                    fileName = "Jmol." + type;
                } else if (type.equals("menu")) {
                    ++pt;
                    type = "MENU";
                } else {
                    type = "(image)";
                }
                if (this.tokAt(pt, args) != 2) break;
                width = ScriptVariable.iValue(this.tokenAt(pt++, args));
                height = ScriptVariable.iValue(this.tokenAt(pt++, args));
            }
        }
        String val = ScriptVariable.sValue(this.tokenAt(pt, args));
        if (val.equalsIgnoreCase("clipboard")) {
            if (this.isSyntaxCheck) {
                return "";
            }
        } else if (Parser.isOneOf(val.toLowerCase(), "png;jpg;jpeg;jpg64;jpeg64") && this.tokAt(pt + 1, args) == 2) {
            quality = ScriptVariable.iValue(this.tokenAt(++pt, args));
        } else if (Parser.isOneOf(val.toLowerCase(), "xyz;mol;pdb")) {
            type = val.toUpperCase();
            if (pt + 1 == argCount) {
                ++pt;
            }
        }
        if (type.equals("(image)") && Parser.isOneOf(val.toUpperCase(), "GIF;JPG;JPG64;JPEG;JPEG64;PNG;PPM")) {
            type = val.toUpperCase();
            ++pt;
        }
        if (pt + 2 == argCount && (data = ScriptVariable.sValue(this.tokenAt(++pt, args))).charAt(0) != '.') {
            type = val.toUpperCase();
        }
        switch (this.tokAt(pt, args)) {
            case 0: {
                isShow = true;
                break;
            }
            case 1: 
            case 4: {
                fileName = ScriptVariable.sValue(this.tokenAt(pt, args));
                if (pt == argCount - 3 && this.tokAt(pt + 1, args) == 0x100008) {
                    fileName = fileName + "." + ScriptVariable.sValue(this.tokenAt(pt + 2, args));
                }
                if (type != "VAR" && pt == 1) {
                    type = "image";
                } else if (fileName.length() > 0 && fileName.charAt(0) == '.' && (pt == 2 || pt == 3)) {
                    fileName = ScriptVariable.sValue(this.tokenAt(pt - 1, args)) + fileName;
                    if (type != "VAR" && pt == 2) {
                        type = "image";
                    }
                }
                if (!fileName.equalsIgnoreCase("clipboard")) break;
                fileName = null;
                break;
            }
            case 0x4000000B: {
                break;
            }
            default: {
                this.error(22);
            }
        }
        if ((type.equals("image") || type.equals("frame")) && (type = fileName != null && fileName.indexOf(".") >= 0 ? fileName.substring(fileName.lastIndexOf(".") + 1).toUpperCase() : "JPG").equals("MNU")) {
            type = "MENU";
        }
        if (type.equals("data")) {
            type = fileName != null && fileName.indexOf(".") >= 0 ? fileName.substring(fileName.lastIndexOf(".") + 1).toUpperCase() : "XYZ";
        }
        if ((isImage = Parser.isOneOf(type, "GIF;JPEG64;JPEG;JPG64;JPG;PPM;PNG")) && (isApplet && !this.viewer.isSignedApplet() || isShow)) {
            type = "JPG64";
        }
        if (!(isImage || isExport || Parser.isOneOf(type, "SPT;HIS;MO;ISO;VAR;FILE;XYZ;MENU;MOL;PDB;PGRP;QUAT;RAMA;FUNCS;"))) {
            this.error(54, "COORDS|FILE|FUNCTIONS|HISTORY|IMAGE|ISOSURFACE|MENU|MO|POINTGROUP|QUATERNION [w,x,y,z] [derivative]|RAMACHANDRAN|STATE|VAR x  CLIPBOARD", "JPG|JPG64|PNG|GIF|PPM|SPT|JVXL|XYZ|MOL|PDB|" + driverList.toUpperCase().replace(';', '|'));
        }
        if (this.isSyntaxCheck) {
            return "";
        }
        data = type.intern();
        Object bytes = null;
        if (isExport) {
            boolean isPovRay = type.equals("Povray");
            if ((data = this.viewer.generateOutput(data, isPovRay ? fileName : null, width, height)) == null) {
                return "";
            }
            if (isPovRay) {
                if (!isCommand) {
                    return data;
                }
                fileName = data.substring(data.indexOf("File created: ") + 14);
                fileName = fileName.substring(0, fileName.indexOf("\n"));
                String msg = this.viewer.createImage((fileName = fileName.substring(0, fileName.lastIndexOf(" ("))) + ".ini", "ini", data, Integer.MIN_VALUE, 0, 0, null);
                if (msg != null) {
                    if (!msg.startsWith("OK")) {
                        this.evalError(msg, null);
                    }
                    this.scriptStatusOrBuffer("Created " + fileName + ".ini:\n\n" + data);
                }
                return "";
            }
        } else if (data == "MENU") {
            data = this.viewer.getMenu("");
        } else if (data == "PGRP") {
            data = this.viewer.getPointGroupAsString(type2.equals("draw"), null, 0, 1.0f);
        } else if (data == "PDB") {
            data = this.viewer.getPdbData(null);
        } else if (data == "XYZ" || data == "MOL") {
            data = this.viewer.getData("selected", data);
        } else if (data == "QUAT" || data == "RAMA") {
            int modelIndex = this.viewer.getCurrentModelIndex();
            if (modelIndex < 0) {
                this.error(30, "write " + type2);
            }
            data = this.viewer.getPdbData(modelIndex, type2);
            type = "PDB";
        } else if (data == "FUNCS") {
            data = this.getFunctionCalls("");
            type = "TXT";
        } else if (data == "FILE") {
            if (isShow) {
                data = this.viewer.getCurrentFileAsString();
            } else {
                bytes = this.viewer.getCurrentFileAsBytes();
            }
            if ("?".equals(fileName)) {
                fileName = "?Jmol." + this.viewer.getParameter("_fileType");
            }
            quality = Integer.MIN_VALUE;
        } else if (data == "VAR") {
            data = "" + this.getParameter(ScriptVariable.sValue(this.tokenAt(isCommand ? 2 : 1, args)), false);
            type = "TXT";
        } else if (data == "SPT") {
            if (isCoord) {
                BitSet tainted = this.viewer.getTaintedAtoms((byte)2);
                this.viewer.setAtomCoordRelative(new Point3f(0.0f, 0.0f, 0.0f));
                data = (String)this.viewer.getProperty("string", "stateInfo", null);
                this.viewer.setTaintedAtoms(tainted, (byte)2);
            } else {
                data = (String)this.viewer.getProperty("string", "stateInfo", null);
            }
        } else if (data == "HIS") {
            data = this.viewer.getSetHistory(Integer.MAX_VALUE);
            type = "SPT";
        } else if (data == "MO") {
            data = this.getMoJvxl(Integer.MAX_VALUE);
            type = "JVXL";
        } else if (data == "ISO") {
            data = this.getIsosurfaceJvxl();
            if (data == null) {
                this.error(31);
            }
            if (!isShow) {
                this.showString((String)this.viewer.getShapeProperty(22, "jvxlFileInfo"));
            }
            type = "JVXL";
        } else {
            len = -1;
            if (quality < 0) {
                quality = -1;
            }
        }
        if (data == null) {
            data = "";
        }
        if (len == 0) {
            int n = bytes == null ? data.length() : (len = bytes instanceof String ? ((String)bytes).length() : ((byte[])bytes).length);
        }
        if (isImage) {
            this.refresh();
            if (width < 0) {
                width = this.viewer.getScreenWidth();
            }
            if (height < 0) {
                height = this.viewer.getScreenHeight();
            }
        }
        if (!isCommand) {
            return data;
        }
        if (isShow) {
            this.showString(data);
        } else if (bytes != null && bytes instanceof String) {
            this.scriptStatusOrBuffer((String)bytes);
        } else {
            String msg;
            if (!(bytes != null || isImage && fileName == null)) {
                bytes = data;
            }
            if ((msg = this.viewer.createImage(fileName, type, bytes, quality, width, height, bsFrames)) != null) {
                if (!msg.startsWith("OK")) {
                    this.evalError(msg, null);
                }
                this.scriptStatusOrBuffer(msg + (isImage ? "; width=" + width + "; height=" + height : ""));
            }
        }
        return "";
    }

    private void show() throws ScriptException {
        String value = null;
        String str = this.parameterAsString(1);
        String msg = null;
        this.checkLength(-3);
        int len = 2;
        if (this.statementLength == 2 && str.indexOf("?") >= 0) {
            this.showString(this.viewer.getAllSettings(str.substring(0, str.indexOf("?"))));
            return;
        }
        int tok = this.getToken((int)1).tok;
        block0 : switch (tok) {
            case 38797589: {
                if (this.statementLength == 2) {
                    if (!this.isSyntaxCheck) {
                        this.showString(this.viewer.getDefaultVdw(-1));
                    }
                    return;
                }
                int iMode = JmolConstants.getVdwType(this.parameterAsString(2));
                if (iMode < 0) {
                    this.error(22);
                }
                if (!this.isSyntaxCheck) {
                    this.showString(this.viewer.getDefaultVdw(iMode));
                }
                return;
            }
            case 135499780: {
                this.checkLength23();
                if (!this.isSyntaxCheck) {
                    this.showString(this.getFunctionCalls(this.optParameterAsString(2)));
                }
                return;
            }
            case 36867: {
                this.checkLength(2);
                if (!this.isSyntaxCheck) {
                    this.showString(this.viewer.getAllSettings(null));
                }
                return;
            }
            case 0x40000041: {
                len = this.statementLength;
                if (len == 2) {
                    if (!this.isSyntaxCheck) {
                        this.viewer.showUrl(this.getFullPathName());
                    }
                    return;
                }
                String fileName = this.parameterAsString(2);
                if (!this.isSyntaxCheck) {
                    this.viewer.showUrl(fileName);
                }
                return;
            }
            case 0x2000000A: 
            case 558895366: {
                str = "defaultColorScheme";
                break;
            }
            case 0x2000000B: {
                str = "scaleAngstromsPerInch";
                break;
            }
            case 1052714: 
            case 135272453: {
                if (this.isSyntaxCheck) {
                    return;
                }
                int modelIndex = this.viewer.getCurrentModelIndex();
                if (modelIndex < 0) {
                    this.error(30, "show " + this.theToken.value);
                }
                msg = this.viewer.getPdbData(modelIndex, this.theTok == 135272453 ? "quaternion w" : "ramachandran");
                break;
            }
            case 528445: {
                if (this.isSyntaxCheck) break;
                msg = this.getContext(false);
                break;
            }
            case 1: {
                if (str.equalsIgnoreCase("variables")) {
                    if (this.isSyntaxCheck) break;
                    msg = this.viewer.getVariableList() + this.getContext(true);
                    break;
                }
                if (str.equalsIgnoreCase("historyLevel")) {
                    value = "" + this.commandHistoryLevelMax;
                    break;
                }
                if (str.equalsIgnoreCase("defaultLattice")) {
                    value = Escape.escape(this.viewer.getDefaultLattice());
                    break;
                }
                if (str.equalsIgnoreCase("logLevel")) {
                    value = "" + Viewer.getLogLevel();
                    break;
                }
                if (str.equalsIgnoreCase("fileHeader")) {
                    if (this.isSyntaxCheck) break;
                    msg = this.viewer.getPDBHeader();
                    break;
                }
                if (str.equalsIgnoreCase("debugScript")) {
                    value = "" + this.viewer.getDebugScript();
                    break;
                }
                if (str.equalsIgnoreCase("colorScheme")) {
                    String name = this.optParameterAsString(2);
                    if (name.length() > 0) {
                        len = 3;
                    }
                    if (this.isSyntaxCheck) break;
                    value = this.viewer.getColorSchemeList(name, true);
                    break;
                }
                if (str.equalsIgnoreCase("menu")) {
                    if (this.isSyntaxCheck) break;
                    value = this.viewer.getMenu("");
                    break;
                }
                if (str.equalsIgnoreCase("strandCount")) {
                    msg = "set strandCountForStrands " + this.viewer.getStrandCount(12) + "; set strandCountForMeshRibbon " + this.viewer.getStrandCount(13);
                    break;
                }
                if (!str.equalsIgnoreCase("trajectory") && !str.equalsIgnoreCase("trajectories")) break;
                msg = this.viewer.getTrajectoryInfo();
                break;
            }
            case 4129: {
                msg = this.viewer.getMinimizationInfo();
                break;
            }
            case 537399298: {
                switch (this.viewer.getAxesMode()) {
                    case 2: {
                        msg = "set axesUnitcell";
                        break block0;
                    }
                    case 0: {
                        msg = "set axesWindow";
                        break block0;
                    }
                }
                msg = "set axesMolecular";
                break;
            }
            case 0x20000002: {
                msg = "set bondMode " + (this.viewer.getBondSelectionModeOr() ? "OR" : "AND");
                break;
            }
            case 537399355: {
                msg = "set strandCountForStrands " + this.viewer.getStrandCount(12) + "; set strandCountForMeshRibbon " + this.viewer.getStrandCount(13);
                break;
            }
            case 538447897: {
                msg = "set hbondsBackbone " + this.viewer.getHbondsBackbone() + ";set hbondsSolid " + this.viewer.getHbondsSolid();
                break;
            }
            case 537399351: {
                msg = this.viewer.getSpinState();
                break;
            }
            case 537399352: {
                msg = "set ssbondsBackbone " + this.viewer.getSsbondsBackbone();
                break;
            }
            case 536883204: 
            case 537399347: {
                msg = "selectionHalos " + (this.viewer.getSelectionHaloEnabled() ? "ON" : "OFF");
                break;
            }
            case 0x20300003: {
                msg = "set selectHetero " + this.viewer.getRasmolHeteroSetting();
                break;
            }
            case 540016644: {
                msg = "set selectHydrogens " + this.viewer.getRasmolHydrogenSetting();
                break;
            }
            case 0x20000001: 
            case 0x20000005: 
            case 0x20000007: 
            case 0x20000008: 
            case 0x2000000C: {
                msg = this.viewer.getSpecularState();
                break;
            }
            case 4146: {
                if (this.isSyntaxCheck) break;
                msg = this.viewer.listSavedStates();
                break;
            }
            case 540545088: {
                if (this.isSyntaxCheck) break;
                msg = this.viewer.getUnitCellInfoText();
                break;
            }
            case 0x100006: {
                len = this.statementLength;
                if (len == 2) {
                    if (this.isSyntaxCheck) break;
                    msg = this.viewer.getCoordinateState(this.viewer.getSelectionSet());
                    break;
                }
                String nameC = this.parameterAsString(2);
                if (this.isSyntaxCheck) break;
                msg = this.viewer.getSavedCoordinates(nameC);
                break;
            }
            case 1073741882: {
                len = this.statementLength;
                if (len == 2) {
                    if (this.isSyntaxCheck) break;
                    msg = this.viewer.getStateInfo();
                    break;
                }
                String name = this.parameterAsString(2);
                if (this.isSyntaxCheck) break;
                msg = this.viewer.getSavedState(name);
                break;
            }
            case 30412803: {
                len = this.statementLength;
                if (len == 2) {
                    if (this.isSyntaxCheck) break;
                    msg = this.viewer.getProteinStructureState();
                    break;
                }
                String shape = this.parameterAsString(2);
                if (this.isSyntaxCheck) break;
                msg = this.viewer.getSavedStructure(shape);
                break;
            }
            case 135272450: {
                String type;
                len = this.statementLength;
                String string = type = len == 3 ? this.parameterAsString(2) : null;
                if (this.isSyntaxCheck) break;
                Object[] data = type == null ? this.data : this.viewer.getData(type);
                msg = (data == null ? "no data" : "data \"" + data[0] + "\"\n" + (data[1] instanceof float[] ? Escape.escape((float[])data[1], true) : (data[1] instanceof float[][] ? Escape.escape((float[][])data[1], false) : "" + data[1]))) + "\nend \"" + data[0] + "\";";
                break;
            }
            case 1073741881: {
                len = this.statementLength;
                if (len == 2) {
                    if (this.isSyntaxCheck) break;
                    msg = this.viewer.getSpaceGroupInfoText(null);
                    break;
                }
                String sg = this.parameterAsString(2);
                if (this.isSyntaxCheck) break;
                msg = this.viewer.getSpaceGroupInfoText(TextFormat.simpleReplace(sg, "''", "\""));
                break;
            }
            case 0x100007: {
                len = 3;
                msg = this.setObjectProperty();
                break;
            }
            case 605556745: {
                if (this.isSyntaxCheck) break;
                msg = this.viewer.getBoundBoxCommand(true);
                break;
            }
            case 12289: {
                if (this.isSyntaxCheck) break;
                msg = "center " + Escape.escape(this.viewer.getRotationCenter());
                break;
            }
            case 4112: {
                if (this.isSyntaxCheck) break;
                msg = (String)this.viewer.getShapeProperty(21, "command");
                break;
            }
            case 156242439: {
                if (this.statementLength == 2) {
                    if (this.isSyntaxCheck) break;
                    msg = this.viewer.getCurrentFileAsString();
                    break;
                }
                len = 3;
                value = this.parameterAsString(2);
                if (this.isSyntaxCheck) break;
                msg = this.viewer.getFileAsString(value);
                break;
            }
            case 4116: {
                if (this.tokAt(2) == 0x100003) {
                    len = 3;
                    if (3 > 0) {
                        msg = this.viewer.getModelFileInfoAll();
                        break;
                    }
                }
                msg = this.viewer.getModelFileInfo();
                break;
            }
            case 536875034: {
                int n;
                len = this.statementLength;
                int n2 = n = len == 2 ? Integer.MAX_VALUE : this.intParameter(2);
                if (n < 1) {
                    this.error(22);
                }
                if (this.isSyntaxCheck) break;
                this.viewer.removeCommand();
                msg = this.viewer.getSetHistory(n);
                break;
            }
            case 4125: {
                if (this.isSyntaxCheck) break;
                msg = (String)this.viewer.getShapeProperty(22, "jvxlFileData");
                break;
            }
            case 4130: {
                int ptMO;
                if (this.optParameterAsString(2).equalsIgnoreCase("list")) {
                    msg = this.viewer.getMoInfo(-1);
                    len = 3;
                    break;
                }
                len = this.statementLength;
                int n = ptMO = len == 2 ? Integer.MAX_VALUE : this.intParameter(2);
                if (this.isSyntaxCheck) break;
                msg = this.getMoJvxl(ptMO);
                break;
            }
            case 22024203: {
                if (this.isSyntaxCheck) break;
                msg = this.viewer.getModelInfoAsString();
                break;
            }
            case 538447907: {
                if (this.isSyntaxCheck) break;
                msg = this.viewer.getMeasurementInfoAsString();
                break;
            }
            case 4133: 
            case 1073741874: 
            case 1073741886: {
                if (this.isSyntaxCheck) break;
                msg = this.viewer.getOrientationText(tok);
                break;
            }
            case 1073741862: {
                if (!this.isSyntaxCheck) {
                    msg = this.viewer.getOrientationText(this.tokAt(2));
                }
                len = this.statementLength == 3 ? 3 : 2;
                break;
            }
            case 1073741863: {
                if (this.isSyntaxCheck) break;
                msg = this.viewer.getPDBHeader();
                break;
            }
            case 1073742235: {
                this.pointGroup();
                return;
            }
            case 0xF0000C: {
                if (this.isSyntaxCheck) break;
                msg = this.viewer.getSymmetryInfoAsString();
                break;
            }
            case 1073741885: {
                if (this.isSyntaxCheck) break;
                msg = "transform:\n" + this.viewer.getTransformText();
                break;
            }
            case 4164: {
                msg = "zoom " + (this.viewer.getZoomEnabled() ? "" + this.viewer.getZoomSetting() : "off");
                break;
            }
            case 537399317: {
                msg = this.viewer.getShowFrank() ? "frank ON" : "frank OFF";
                break;
            }
            case 592445697: {
                str = "solventProbeRadius";
                break;
            }
            case 0x30000A: 
            case 0xD00004: 
            case 0xD00006: 
            case 0xD00008: 
            case 0x4100001: 
            case 605028354: 
            case 1073741870: 
            case 1073741946: {
                msg = this.viewer.getChimeInfo(tok);
                break;
            }
            case 20482: 
            case 0x20000003: 
            case 536891393: 
            case 540016651: 
            case 642777357: {
                value = "?";
            }
        }
        this.checkLength(len);
        if (this.isSyntaxCheck) {
            return;
        }
        if (msg != null) {
            this.showString(msg);
        } else if (value != null) {
            this.showString(str + " = " + value);
        } else if (str != null) {
            this.showString(str + " = " + this.getParameterEscaped(str));
        }
    }

    private String getFunctionCalls(String selectedFunction) {
        boolean isLocal;
        StringBuffer s = new StringBuffer();
        int pt = selectedFunction.indexOf("*");
        boolean isGeneric = pt >= 0;
        boolean bl = isLocal = selectedFunction.indexOf("_") == 0;
        if (isGeneric) {
            selectedFunction = selectedFunction.substring(0, pt);
        }
        selectedFunction = selectedFunction.toLowerCase();
        Hashtable ht = this.viewer.getFunctions(isLocal);
        Object[] names = new String[ht.size()];
        Enumeration e = ht.keys();
        int n = 0;
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (selectedFunction.length() != 0 && !name.equalsIgnoreCase(selectedFunction) && (!isGeneric || name.toLowerCase().indexOf(selectedFunction) != 0)) continue;
            names[n++] = name;
        }
        Arrays.sort(names, 0, n);
        for (int i = 0; i < n; ++i) {
            s.append(((ScriptFunction)ht.get(names[i])).toString());
        }
        return s.toString();
    }

    private String getIsosurfaceJvxl() {
        if (this.isSyntaxCheck) {
            return "";
        }
        return (String)this.viewer.getShapeProperty(22, "jvxlFileData");
    }

    private String getMoJvxl(int ptMO) throws ScriptException {
        Hashtable moData;
        this.viewer.loadShape(24);
        int modelIndex = this.viewer.getDisplayModelIndex();
        if (modelIndex < 0) {
            this.error(30, "MO isosurfaces");
        }
        if ((moData = (Hashtable)this.viewer.getModelAuxiliaryInfo(modelIndex, "moData")) == null) {
            this.error(27);
        }
        this.setShapeProperty(24, "init", new Integer(modelIndex));
        this.setShapeProperty(24, "moData", moData);
        return (String)this.viewer.getShapeProperty(24, "showMO", ptMO);
    }

    private String extractCommandOption(String name) {
        int i = this.fullCommand.indexOf(name + "=");
        return i < 0 ? null : Parser.getNextQuotedString(this.fullCommand, i);
    }

    private void draw() throws ScriptException {
        this.viewer.loadShape(21);
        switch (this.tokAt(1)) {
            case 6: {
                if (!this.listIsosurface(21)) break;
                return;
            }
            case 1073742235: {
                this.pointGroup();
                return;
            }
            case 135272453: {
                this.dataFrame(1);
                return;
            }
            case 1052714: {
                this.dataFrame(0);
                return;
            }
        }
        boolean havePoints = false;
        boolean isInitialized = false;
        boolean isSavedState = false;
        boolean isTranslucent = false;
        boolean isFrame = false;
        float translucentLevel = Float.MAX_VALUE;
        int colorArgb = Integer.MIN_VALUE;
        int intScale = 0;
        String swidth = "";
        int iptDisplayProperty = 0;
        Point3f center = null;
        Object thisId = null;
        boolean idSeen = this.initIsosurface(21);
        boolean isWild = idSeen && this.viewer.getShapeProperty(21, "ID") == null;
        block31: for (int i = this.iToken; i < this.statementLength; ++i) {
            String propertyName = null;
            Object propertyValue = null;
            int tok = this.getToken((int)i).tok;
            switch (tok) {
                case 4116: {
                    isFrame = true;
                    continue block31;
                }
                case 7: 
                case 8: 
                case 0x10000A: {
                    if (tok == 8 || !this.isPoint3f(i)) {
                        propertyValue = this.getPoint4f(i);
                        if (isFrame) {
                            this.checkLength(this.iToken + 1);
                            if (!this.isSyntaxCheck) {
                                this.runScript(new Quaternion((Point4f)propertyValue).draw(thisId == null ? "frame" : thisId, " " + swidth, center == null ? new Point3f() : center, (float)intScale / 100.0f));
                            }
                            return;
                        }
                        propertyName = "planedef";
                    } else {
                        center = this.getPoint3f(i, true);
                        propertyValue = center;
                        propertyName = "coord";
                    }
                    i = this.iToken;
                    havePoints = true;
                    break;
                }
                case 135268355: {
                    if (havePoints) {
                        propertyValue = this.planeParameter(++i);
                        i = this.iToken;
                        propertyName = "planedef";
                        break;
                    }
                    propertyName = "plane";
                    break;
                }
                case 0x100001: 
                case 0x40000007: {
                    propertyName = "atomSet";
                    propertyValue = this.expression(i);
                    if (isFrame) {
                        center = this.centerParameter(i);
                    }
                    i = this.iToken;
                    havePoints = true;
                    break;
                }
                case 6: {
                    propertyName = "modelBasedPoints";
                    propertyValue = this.theToken.value;
                    havePoints = true;
                    break;
                }
                case 0x10100030: {
                    break;
                }
                case 0x10100040: {
                    propertyValue = this.xypParameter(i);
                    if (propertyValue != null) {
                        i = this.iToken;
                        propertyName = "coord";
                        havePoints = true;
                        break;
                    }
                }
                case 68157445: {
                    propertyName = "reverse";
                    break;
                }
                case 0x10100041: {
                    isSavedState = !isSavedState;
                    if (isSavedState != (this.theTok == 0x10100041)) break;
                    this.error(22);
                    break;
                }
                case 4: {
                    propertyValue = this.stringParameter(i);
                    propertyName = "title";
                    break;
                }
                case 4161: {
                    propertyName = "vector";
                    break;
                }
                case 68157443: {
                    propertyValue = new Float(this.floatParameter(++i));
                    propertyName = "length";
                    break;
                }
                case 3: {
                    propertyValue = new Float(this.floatParameter(i));
                    propertyName = "length";
                    break;
                }
                case 2: {
                    if (isSavedState) {
                        propertyName = "modelIndex";
                        propertyValue = new Integer(this.intParameter(i));
                        break;
                    }
                    intScale = this.intParameter(i);
                    break;
                }
                case 1073741877: {
                    if (++i >= this.statementLength) {
                        this.error(34);
                    }
                    switch (this.getToken((int)i).tok) {
                        case 2: {
                            intScale = this.intParameter(i);
                            continue block31;
                        }
                        case 3: {
                            intScale = (int)(this.floatParameter(i) * 100.0f);
                            continue block31;
                        }
                        default: {
                            this.error(34);
                            break;
                        }
                    }
                    break;
                }
                case 1: 
                case 0x101000A1: {
                    String str = this.parameterAsString(i);
                    if (str.equalsIgnoreCase("id")) {
                        this.setShapeId(21, ++i, idSeen);
                        isWild = this.viewer.getShapeProperty(21, "ID") == null;
                        i = this.iToken;
                        break;
                    }
                    if (str.equalsIgnoreCase("LINE")) {
                        propertyName = "line";
                        propertyValue = Boolean.TRUE;
                        break;
                    }
                    if (str.equalsIgnoreCase("FIXED")) {
                        propertyName = "fixed";
                        propertyValue = Boolean.TRUE;
                        break;
                    }
                    if (str.equalsIgnoreCase("MODELBASED")) {
                        propertyName = "fixed";
                        propertyValue = Boolean.FALSE;
                        break;
                    }
                    if (str.equalsIgnoreCase("CROSSED")) {
                        propertyName = "crossed";
                        break;
                    }
                    if (str.equalsIgnoreCase("CURVE")) {
                        propertyName = "curve";
                        break;
                    }
                    if (str.equalsIgnoreCase("ARROW")) {
                        propertyName = "arrow";
                        break;
                    }
                    if (str.equalsIgnoreCase("ARC")) {
                        propertyName = "arc";
                        break;
                    }
                    if (str.equalsIgnoreCase("CIRCLE")) {
                        propertyName = "circle";
                        break;
                    }
                    if (str.equalsIgnoreCase("CYLINDER")) {
                        propertyName = "cylinder";
                        break;
                    }
                    if (str.equalsIgnoreCase("VERTICES")) {
                        propertyName = "vertices";
                        break;
                    }
                    if (str.equalsIgnoreCase("NOHEAD")) {
                        propertyName = "nohead";
                        break;
                    }
                    if (str.equalsIgnoreCase("ROTATE45")) {
                        propertyName = "rotate45";
                        break;
                    }
                    if (str.equalsIgnoreCase("PERP") || str.equalsIgnoreCase("PERPENDICULAR")) {
                        propertyName = "perp";
                        break;
                    }
                    if (str.equalsIgnoreCase("OFFSET")) {
                        Point3f pt = this.getPoint3f(++i, true);
                        i = this.iToken;
                        propertyName = "offset";
                        propertyValue = pt;
                        break;
                    }
                    if (str.equalsIgnoreCase("DIAMETER")) {
                        float f = this.floatParameter(++i);
                        propertyValue = new Float(f);
                        propertyName = this.tokAt(i) == 3 ? "width" : "diameter";
                        swidth = propertyName + (this.tokAt(i) == 3 ? " " + f : " " + (int)f);
                        break;
                    }
                    if (str.equalsIgnoreCase("WIDTH")) {
                        propertyValue = new Float(this.floatParameter(++i));
                        propertyName = "width";
                        swidth = propertyName + " " + propertyValue;
                        break;
                    }
                    this.setShapeId(21, i, idSeen);
                    i = this.iToken;
                    break;
                }
                case 0x100007: {
                    if (this.tokAt(i + 2) == 0x10100040 || isFrame) {
                        Point3f pt = center = this.centerParameter(i);
                        i = this.iToken;
                        propertyName = "coord";
                        propertyValue = pt;
                        havePoints = true;
                        break;
                    }
                    propertyValue = this.objectNameParameter(++i);
                    propertyName = "identifier";
                    havePoints = true;
                    break;
                }
                case 558895366: {
                    ++i;
                }
                case 1073741861: 
                case 1073741887: {
                    isTranslucent = false;
                    boolean isColor = false;
                    if (this.tokAt(i) == 1073741887) {
                        isTranslucent = true;
                        if (this.isFloatParameter(++i)) {
                            translucentLevel = this.getTranslucentLevel(i++);
                        }
                        isColor = true;
                    } else if (this.tokAt(i) == 1073741861) {
                        ++i;
                        isColor = true;
                    }
                    if (this.isColorParam(i)) {
                        colorArgb = this.getArgbParam(i);
                        i = this.iToken;
                        isColor = true;
                    }
                    if (!isColor) {
                        this.error(22);
                    }
                    idSeen = true;
                    continue block31;
                }
                default: {
                    if (iptDisplayProperty == 0) {
                        iptDisplayProperty = i;
                    }
                    if (this.setMeshDisplayProperty(21, 0, this.theTok)) continue block31;
                    this.error(22);
                    continue block31;
                }
            }
            boolean bl = idSeen = this.theTok != 12291;
            if (havePoints && !isInitialized && !isFrame) {
                this.setShapeProperty(21, "points", new Integer(intScale));
                isInitialized = true;
                intScale = 0;
            }
            if (havePoints && isWild) {
                this.error(22);
            }
            if (propertyName == null) continue;
            this.setShapeProperty(21, propertyName, propertyValue);
        }
        if (havePoints) {
            this.setShapeProperty(21, "set", null);
        }
        if (colorArgb != Integer.MIN_VALUE) {
            this.setShapeProperty(21, "color", new Integer(colorArgb));
        }
        if (isTranslucent) {
            this.setShapeTranslucency(21, "", "translucent", translucentLevel, null);
        }
        if (intScale != 0) {
            this.setShapeProperty(21, "scale", new Integer(intScale));
        }
        if (iptDisplayProperty > 0 && !this.setMeshDisplayProperty(21, iptDisplayProperty, this.getToken((int)iptDisplayProperty).tok)) {
            this.error(22);
        }
    }

    private void polyhedra() throws ScriptException {
        boolean needsGenerating = false;
        boolean onOffDelete = false;
        boolean typeSeen = false;
        boolean edgeParameterSeen = false;
        boolean isDesignParameter = false;
        int nAtomSets = 0;
        this.viewer.loadShape(20);
        this.setShapeProperty(20, "init", null);
        String setPropertyName = "centers";
        String decimalPropertyName = "radius_";
        boolean isTranslucent = false;
        float translucentLevel = Float.MAX_VALUE;
        int color = Integer.MIN_VALUE;
        block12: for (int i = 1; i < this.statementLength; ++i) {
            if (this.isColorParam(i)) {
                color = this.getArgbParam(i);
                i = this.iToken;
                continue;
            }
            String propertyName = null;
            Object propertyValue = null;
            switch (this.getToken((int)i).tok) {
                case 0x10100030: 
                case 269484420: {
                    continue block12;
                }
                case 605028354: {
                    if (nAtomSets > 0) {
                        this.error(23);
                    }
                    needsGenerating = true;
                    propertyName = "bonds";
                    break;
                }
                case 592445697: {
                    decimalPropertyName = "radius";
                    continue block12;
                }
                case 558895366: {
                    ++i;
                }
                case 1073741861: 
                case 1073741887: {
                    isTranslucent = false;
                    boolean isColor = false;
                    if (this.tokAt(i) == 1073741887) {
                        isTranslucent = true;
                        if (this.isFloatParameter(++i)) {
                            translucentLevel = this.getTranslucentLevel(i++);
                        }
                        isColor = true;
                    } else if (this.tokAt(i) == 1073741861) {
                        ++i;
                        isColor = true;
                    }
                    if (this.isColorParam(i)) {
                        color = this.getArgbParam(i);
                        i = this.iToken;
                        isColor = true;
                    }
                    if (isColor) continue block12;
                    this.error(22);
                    continue block12;
                }
                case 1: {
                    String str = this.parameterAsString(i);
                    if ("collapsed".equalsIgnoreCase(str)) {
                        propertyName = "collapsed";
                        propertyValue = Boolean.TRUE;
                        if (typeSeen) {
                            this.error(18);
                        }
                        typeSeen = true;
                        break;
                    }
                    if ("flat".equalsIgnoreCase(str)) {
                        propertyName = "collapsed";
                        propertyValue = Boolean.FALSE;
                        if (typeSeen) {
                            this.error(18);
                        }
                        typeSeen = true;
                        break;
                    }
                    if ("edges".equalsIgnoreCase(str) || "noedges".equalsIgnoreCase(str) || "frontedges".equalsIgnoreCase(str)) {
                        if (edgeParameterSeen) {
                            this.error(18);
                        }
                        propertyName = str;
                        edgeParameterSeen = true;
                        break;
                    }
                    if (!needsGenerating) {
                        this.error(19);
                    }
                    if ("to".equalsIgnoreCase(str)) {
                        if (nAtomSets > 1) {
                            this.error(23);
                        }
                        if (this.getToken((int)(i + 1)).tok == 0x40000007) {
                            propertyName = "toBitSet";
                            propertyValue = this.getToken((int)(++i)).value;
                            needsGenerating = true;
                            break;
                        }
                        setPropertyName = "to";
                        continue block12;
                    }
                    if ("faceCenterOffset".equalsIgnoreCase(str)) {
                        decimalPropertyName = "faceCenterOffset";
                        isDesignParameter = true;
                        continue block12;
                    }
                    if ("distanceFactor".equalsIgnoreCase(str)) {
                        decimalPropertyName = "distanceFactor";
                        isDesignParameter = true;
                        continue block12;
                    }
                    this.error(22);
                }
                case 2: {
                    if (nAtomSets > 0 && !isDesignParameter) {
                        this.error(23);
                    }
                    if (decimalPropertyName == "radius_") {
                        propertyName = "nVertices";
                        propertyValue = new Integer(this.intParameter(i));
                        needsGenerating = true;
                        break;
                    }
                }
                case 3: {
                    if (nAtomSets > 0 && !isDesignParameter) {
                        this.error(23);
                    }
                    propertyName = decimalPropertyName == "radius_" ? "radius" : decimalPropertyName;
                    propertyValue = new Float(this.floatParameter(i));
                    decimalPropertyName = "radius_";
                    isDesignParameter = false;
                    needsGenerating = true;
                    break;
                }
                case 12291: 
                case 0x10000C: 
                case 0x10000D: {
                    if (i + 1 != this.statementLength || needsGenerating || nAtomSets > 1 || nAtomSets == 0 && setPropertyName == "to") {
                        this.error(18);
                    }
                    propertyName = this.parameterAsString(i);
                    onOffDelete = true;
                    break;
                }
                case 0x100001: 
                case 0x40000007: {
                    if (typeSeen) {
                        this.error(23);
                    }
                    if (++nAtomSets > 2) {
                        this.error(2);
                    }
                    if (setPropertyName == "to") {
                        needsGenerating = true;
                    }
                    propertyName = setPropertyName;
                    setPropertyName = "to";
                    propertyValue = this.expression(i);
                    i = this.iToken;
                    break;
                }
                default: {
                    this.error(22);
                }
            }
            this.setShapeProperty(20, propertyName, propertyValue);
            if (!onOffDelete) continue;
            return;
        }
        if (!(needsGenerating || typeSeen || edgeParameterSeen)) {
            this.error(19);
        }
        if (needsGenerating) {
            this.setShapeProperty(20, "generate", null);
        }
        if (color != Integer.MIN_VALUE) {
            this.setShapeProperty(20, "colorThis", new Integer(color));
        }
        if (isTranslucent) {
            this.setShapeTranslucency(20, "", "translucent", translucentLevel, null);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void lcaoCartoon() throws ScriptException {
        this.viewer.loadShape(23);
        if (this.tokAt(1) == 6 && this.listIsosurface(23)) {
            return;
        }
        this.setShapeProperty(23, "init", null);
        if (this.statementLength == 1) {
            this.setShapeProperty(23, "lcaoID", null);
            return;
        }
        boolean idSeen = false;
        String translucency = null;
        int i = 1;
        while (true) {
            block35: {
                if (i >= this.statementLength) {
                    this.setShapeProperty(23, "clear", null);
                    return;
                }
                String propertyName = null;
                Object propertyValue = null;
                switch (this.getToken((int)i).tok) {
                    case 12289: {
                        this.isosurface(23);
                        return;
                    }
                    case 528432: {
                        String str;
                        Vector3f rotAxis = new Vector3f();
                        switch (this.getToken((int)(++i)).tok) {
                            case 1: {
                                str = this.parameterAsString(i);
                                float radians = this.floatParameter(++i) * ((float)Math.PI / 180);
                                if (str.equalsIgnoreCase("x")) {
                                    rotAxis.set(radians, 0.0f, 0.0f);
                                    break;
                                }
                                if (str.equalsIgnoreCase("y")) {
                                    rotAxis.set(0.0f, radians, 0.0f);
                                    break;
                                }
                                if (str.equalsIgnoreCase("z")) {
                                    rotAxis.set(0.0f, 0.0f, radians);
                                    break;
                                }
                                this.error(22);
                            }
                            default: {
                                this.error(22);
                            }
                        }
                        propertyName = "rotationAxis";
                        propertyValue = rotAxis;
                        break;
                    }
                    case 0x10000D: 
                    case 3145751: 
                    case 536883204: {
                        propertyName = "on";
                        break;
                    }
                    case 12293: 
                    case 0x10000C: 
                    case 3145752: {
                        propertyName = "off";
                        break;
                    }
                    case 12291: {
                        propertyName = "delete";
                        break;
                    }
                    case 2: 
                    case 3: {
                        propertyName = "scale";
                        propertyValue = new Float(this.floatParameter(++i));
                        break;
                    }
                    case 0x100001: 
                    case 0x40000007: {
                        propertyName = "select";
                        propertyValue = this.expression(i);
                        i = this.iToken;
                        break;
                    }
                    case 558895366: {
                        translucency = this.setColorOptions(i + 1, 23, -2);
                        if (translucency != null) {
                            this.setShapeProperty(23, "settranslucency", translucency);
                        }
                        i = this.iToken;
                        idSeen = true;
                        break block35;
                    }
                    case 1073741861: 
                    case 1073741887: {
                        this.setMeshDisplayProperty(23, i, this.theTok);
                        i = this.iToken;
                        idSeen = true;
                        break block35;
                    }
                    case 4: {
                        propertyValue = this.stringParameter(i);
                        propertyName = "create";
                        if (!this.optParameterAsString(i + 1).equalsIgnoreCase("molecular")) break;
                        ++i;
                        propertyName = "molecular";
                        break;
                    }
                    case 135280129: {
                        if (this.tokAt(i + 1) == 0x40000007 || this.tokAt(i + 1) == 0x100001) {
                            propertyName = "select";
                            propertyValue = this.expression(i + 1);
                            i = this.iToken;
                            break;
                        }
                        propertyName = "selectType";
                        propertyValue = this.parameterAsString(++i);
                        break;
                    }
                    case 1073741877: {
                        propertyName = "scale";
                        propertyValue = new Float(this.floatParameter(++i));
                        break;
                    }
                    case 1: {
                        String str = this.parameterAsString(i);
                        if (str.equalsIgnoreCase("ID")) {
                            str = this.getShapeNameParameter(++i);
                            i = this.iToken;
                        } else {
                            if (str.equalsIgnoreCase("MOLECULAR")) {
                                propertyName = "molecular";
                                break;
                            }
                            if (str.equalsIgnoreCase("CREATE")) {
                                propertyValue = this.parameterAsString(++i);
                                propertyName = "create";
                                if (!this.optParameterAsString(i + 1).equalsIgnoreCase("molecular")) break;
                                ++i;
                                propertyName = "molecular";
                                break;
                            }
                        }
                        propertyValue = str;
                    }
                    case 0x100003: {
                        if (idSeen) {
                            this.error(22);
                        }
                        propertyName = "lcaoID";
                    }
                }
                if (this.theTok != 12291) {
                    idSeen = true;
                }
                if (propertyName == null) {
                    this.error(22);
                }
                this.setShapeProperty(23, propertyName, propertyValue);
            }
            ++i;
        }
    }

    private boolean mo(boolean isInitOnly) throws ScriptException {
        int offset = Integer.MAX_VALUE;
        BitSet bsModels = this.viewer.getVisibleFramesBitSet();
        int modelCount = this.viewer.getModelCount();
        for (int modelIndex = 0; modelIndex < modelCount; ++modelIndex) {
            if (!bsModels.get(modelIndex)) continue;
            this.viewer.loadShape(24);
            if (this.tokAt(1) == 6 && this.listIsosurface(24)) {
                return true;
            }
            this.setShapeProperty(24, "init", new Integer(modelIndex));
            String title = null;
            int moNumber = (Integer)this.viewer.getShapeProperty(24, "moNumber");
            if (isInitOnly) {
                return true;
            }
            if (moNumber == 0) {
                moNumber = Integer.MAX_VALUE;
            }
            String propertyName = null;
            Object propertyValue = null;
            switch (this.getToken((int)1).tok) {
                case 2: {
                    moNumber = this.intParameter(1);
                    break;
                }
                case 1073741854: {
                    moNumber = 1073741854;
                    break;
                }
                case 1073741867: {
                    moNumber = 1073741867;
                    break;
                }
                case 558895366: {
                    this.setColorOptions(2, 24, 2);
                    break;
                }
                case 135268355: {
                    propertyName = "plane";
                    propertyValue = this.planeParameter(2);
                    break;
                }
                case 1073741877: {
                    propertyName = "scale";
                    propertyValue = new Float(this.floatParameter(2));
                    break;
                }
                case 1: {
                    String str = this.parameterAsString(1);
                    offset = this.moOffset(1);
                    if (offset != Integer.MAX_VALUE) {
                        moNumber = 0;
                        break;
                    }
                    if (str.equalsIgnoreCase("CUTOFF")) {
                        if (this.tokAt(2) == 0x10100091) {
                            propertyName = "cutoffPositive";
                            propertyValue = new Float(this.floatParameter(3));
                            break;
                        }
                        propertyName = "cutoff";
                        propertyValue = new Float(this.floatParameter(2));
                        break;
                    }
                    if (str.equalsIgnoreCase("RESOLUTION") || str.equalsIgnoreCase("POINTSPERANGSTROM")) {
                        propertyName = "resolution";
                        propertyValue = new Float(this.floatParameter(2));
                        break;
                    }
                    if (str.equalsIgnoreCase("SQUARED")) {
                        propertyName = "squareData";
                        propertyValue = Boolean.TRUE;
                        break;
                    }
                    if (str.equalsIgnoreCase("TITLEFORMAT")) {
                        if (2 >= this.statementLength || this.tokAt(2) != 4) break;
                        propertyName = "titleFormat";
                        propertyValue = this.parameterAsString(2);
                        break;
                    }
                    if (str.equalsIgnoreCase("DEBUG")) {
                        propertyName = "debug";
                        break;
                    }
                    if (str.equalsIgnoreCase("noplane")) {
                        propertyName = "plane";
                        break;
                    }
                    this.error(22);
                }
                default: {
                    if (!this.setMeshDisplayProperty(24, 1, this.theTok)) {
                        this.error(22);
                    }
                    return true;
                }
            }
            if (propertyName != null) {
                this.setShapeProperty(24, propertyName, propertyValue);
            }
            if (moNumber == Integer.MAX_VALUE) continue;
            if (this.tokAt(2) == 4) {
                title = this.parameterAsString(2);
            }
            if (!this.isSyntaxCheck) {
                this.viewer.setCursor(4);
            }
            this.setMoData(24, moNumber, offset, modelIndex, title);
            this.setShapeProperty(24, "finalize", null);
        }
        return true;
    }

    private String setColorOptions(int index, int iShape, int nAllowed) throws ScriptException {
        this.getToken(index);
        String translucency = "opaque";
        if (this.theTok == 1073741887) {
            translucency = "translucent";
            if (nAllowed < 0) {
                float value = this.isFloatParameter(index + 1) ? this.floatParameter(++index) : Float.MAX_VALUE;
                this.setShapeTranslucency(iShape, null, "translucent", value, null);
            } else {
                this.setMeshDisplayProperty(iShape, index, this.theTok);
            }
        } else if (this.theTok == 1073741861) {
            if (nAllowed >= 0) {
                this.setMeshDisplayProperty(iShape, index, this.theTok);
            }
        } else {
            --this.iToken;
        }
        nAllowed = Math.abs(nAllowed);
        for (int i = 0; i < nAllowed; ++i) {
            if (this.isColorParam(this.iToken + 1)) {
                this.setShapeProperty(iShape, "colorRGB", new Integer(this.getArgbParam(++this.iToken)));
                continue;
            }
            if (this.iToken >= index) break;
            this.error(22);
        }
        return translucency;
    }

    private int moOffset(int index) throws ScriptException {
        String str = this.parameterAsString(index++);
        boolean isHomo = false;
        int offset = Integer.MAX_VALUE;
        isHomo = str.equalsIgnoreCase("HOMO");
        if (isHomo || str.equalsIgnoreCase("LUMO")) {
            int n = offset = isHomo ? 0 : 1;
            if (this.tokAt(index) == 2 && this.intParameter(index) < 0) {
                offset += this.intParameter(index);
            } else if (this.tokAt(index) == 0x10100091) {
                offset += this.intParameter(index + 1);
            } else if (this.tokAt(index) == 0x10100090) {
                offset -= this.intParameter(index + 1);
            }
        }
        return offset;
    }

    private void setMoData(int shape, int moNumber, int offset, int modelIndex, String title) throws ScriptException {
        if (this.isSyntaxCheck) {
            return;
        }
        if (modelIndex < 0 && (modelIndex = this.viewer.getDisplayModelIndex()) < 0) {
            this.error(30, "MO isosurfaces");
        }
        Hashtable moData = (Hashtable)this.viewer.getModelAuxiliaryInfo(modelIndex, "jmolSurfaceInfo");
        int firstMoNumber = moNumber;
        if (moData == null || !((String)moData.get("surfaceDataType")).equals("mo")) {
            int nOrb;
            int lastMoNumber;
            moData = (Hashtable)this.viewer.getModelAuxiliaryInfo(modelIndex, "moData");
            if (moData == null) {
                this.error(27);
            }
            int n = lastMoNumber = moData.containsKey("lastMoNumber") ? (Integer)moData.get("lastMoNumber") : 0;
            if (moNumber == 1073741867) {
                moNumber = lastMoNumber - 1;
            } else if (moNumber == 1073741854) {
                moNumber = lastMoNumber + 1;
            }
            Vector mos = (Vector)moData.get("mos");
            int n2 = nOrb = mos == null ? 0 : mos.size();
            if (nOrb == 0) {
                this.error(25);
            }
            if (nOrb == 1 && moNumber > 1) {
                this.error(29);
            }
            if (offset != Integer.MAX_VALUE) {
                if (moData.containsKey("HOMO")) {
                    moNumber = (Integer)moData.get("HOMO") + offset;
                } else {
                    for (int i = 0; i < nOrb; ++i) {
                        Hashtable mo = (Hashtable)mos.get(i);
                        if (!mo.containsKey("occupancy")) {
                            this.error(28);
                        }
                        if (((Float)mo.get("occupancy")).floatValue() != 0.0f) continue;
                        moNumber = i + offset;
                        break;
                    }
                }
                Logger.info("MO " + moNumber);
            }
            if (moNumber < 1 || moNumber > nOrb) {
                this.error(26, "" + nOrb);
            }
        }
        moData.put("lastMoNumber", new Integer(moNumber));
        this.setShapeProperty(shape, "moData", moData);
        if (title != null) {
            this.setShapeProperty(shape, "title", title);
        }
        if (firstMoNumber < 0) {
            this.setShapeProperty(shape, "charges", this.viewer.getAtomicCharges());
        }
        this.setShapeProperty(shape, "molecularOrbital", new Integer(firstMoNumber < 0 ? -moNumber : moNumber));
        this.setShapeProperty(shape, "clear", null);
    }

    private boolean initIsosurface(int iShape) throws ScriptException {
        this.setShapeProperty(iShape, "init", this.fullCommand);
        this.iToken = 0;
        if (this.tokAt(1) == 12291 || this.tokAt(2) == 12291 && this.tokAt(++this.iToken) == 0x100003) {
            this.setShapeProperty(iShape, "delete", null);
            this.iToken += 2;
            if (this.statementLength > this.iToken) {
                this.setShapeProperty(iShape, "init", this.fullCommand);
                this.setShapeProperty(iShape, "thisID", "+PREVIOUS_MESH+");
            }
            return false;
        }
        this.iToken = 1;
        if (!this.setMeshDisplayProperty(iShape, 0, this.tokAt(1))) {
            this.setShapeProperty(iShape, "thisID", "+PREVIOUS_MESH+");
            if (iShape != 21) {
                this.setShapeProperty(iShape, "title", new String[]{this.thisCommand});
            }
            if (this.tokAt(2) == 0x101000A1 && !this.parameterAsString(1).equalsIgnoreCase("id")) {
                this.setShapeId(iShape, 1, false);
                ++this.iToken;
                return true;
            }
        }
        return false;
    }

    private String getNextComment() {
        String nextCommand = this.getCommand(this.pc + 1, false, true);
        return nextCommand.startsWith("#") ? nextCommand : "";
    }

    private boolean listIsosurface(int iShape) throws ScriptException {
        if (this.getToken((int)1).value instanceof String[]) {
            return false;
        }
        this.checkLength(2);
        if (!this.isSyntaxCheck) {
            this.showString((String)this.viewer.getShapeProperty(iShape, "list"));
        }
        return true;
    }

    private void isosurface(int iShape) throws ScriptException {
        float volume;
        float area;
        boolean idSeen;
        int modelIndex;
        this.viewer.loadShape(iShape);
        if (this.tokAt(1) == 6 && this.listIsosurface(iShape)) {
            return;
        }
        int colorRangeStage = 0;
        int signPt = 0;
        boolean isIsosurface = iShape == 22;
        boolean isPmesh = iShape == 25;
        boolean surfaceObjectSeen = false;
        boolean planeSeen = false;
        boolean doCalcArea = false;
        boolean doCalcVolume = false;
        boolean isCavity = false;
        boolean isFxy = false;
        float[] nlmZ = new float[5];
        float[] data = null;
        int nFiles = 0;
        String str = null;
        int n = modelIndex = this.isSyntaxCheck ? 0 : this.viewer.getDisplayModelIndex();
        if (!this.isSyntaxCheck) {
            this.viewer.setCursor(4);
        }
        boolean isWild = (idSeen = this.initIsosurface(iShape)) && this.viewer.getShapeProperty(iShape, "ID") == null;
        String translucency = null;
        String colorScheme = null;
        if (isPmesh) {
            this.setShapeProperty(iShape, "fileType", "Pmesh");
        }
        block37: for (int i = this.iToken; i < this.statementLength; ++i) {
            if (this.isColorParam(i)) {
                if (i != signPt) {
                    this.error(23);
                }
                this.setShapeProperty(iShape, "colorRGB", new Integer(this.getArgbParam(i)));
                i = this.iToken;
                signPt = i + 1;
                idSeen = true;
                continue;
            }
            String propertyName = null;
            Object propertyValue = null;
            int tok = this.getToken((int)i).tok;
            if (tok == 1 && (str = this.parameterAsString(i)).equalsIgnoreCase("inline")) {
                tok = 4;
            }
            block3 : switch (tok) {
                case 4135: {
                    this.setShapeProperty(iShape, "fileType", "Pmesh");
                    continue block37;
                }
                case 135268865: {
                    float distance = this.floatParameter(++i);
                    propertyValue = this.centerParameter(++i);
                    i = this.iToken;
                    propertyName = "withinPoint";
                    this.setShapeProperty(iShape, "withinDistance", new Float(distance));
                    break;
                }
                case 642777357: {
                    this.setShapeProperty(iShape, "propertySmoothing", this.viewer.getIsosurfacePropertySmoothing() ? Boolean.TRUE : Boolean.FALSE);
                    str = this.parameterAsString(i);
                    propertyName = "property";
                    if (!isCavity && str.toLowerCase().indexOf("property_") == 0) {
                        data = new float[this.viewer.getAtomCount()];
                        if (this.isSyntaxCheck) continue block37;
                        data = this.viewer.getDataFloat(str);
                        if (data == null) {
                            this.error(22);
                        }
                        propertyValue = data;
                        break;
                    }
                    int tokProperty = this.getToken((int)(++i)).tok;
                    int atomCount = this.viewer.getAtomCount();
                    float[] fArray = data = isCavity ? new float[]{} : new float[atomCount];
                    if (isCavity) {
                        this.error(22);
                    }
                    if (!this.isSyntaxCheck && !isCavity) {
                        Atom[] atoms = this.viewer.getModelSet().atoms;
                        this.viewer.autoCalculate(tokProperty);
                        int iAtom = atomCount;
                        while (--iAtom >= 0) {
                            data[iAtom] = Atom.atomPropertyFloat(atoms[iAtom], tokProperty);
                        }
                    }
                    if (tokProperty == 558895366) {
                        colorScheme = "colorRGB";
                    }
                    propertyValue = data;
                    break;
                }
                case 22024203: {
                    if (surfaceObjectSeen) {
                        this.error(22);
                    }
                    if ((modelIndex = this.modelNumberParameter(++i)) < 0) {
                        propertyName = "fixed";
                        propertyValue = Boolean.TRUE;
                        break;
                    }
                    propertyName = "modelIndex";
                    propertyValue = new Integer(modelIndex);
                    break;
                }
                case 135280129: {
                    propertyName = "select";
                    propertyValue = this.expression(++i);
                    i = this.iToken;
                    break;
                }
                case 12289: {
                    propertyName = "center";
                    propertyValue = this.centerParameter(++i);
                    i = this.iToken;
                    break;
                }
                case 558895366: {
                    colorRangeStage = 0;
                    if (this.getToken((int)(i + 1)).tok == 4) {
                        colorScheme = this.parameterAsString(++i);
                    }
                    if ((this.theTok = this.tokAt(i + 1)) == 1073741887 || this.tokAt(i + 1) == 1073741861) {
                        translucency = this.setColorOptions(i + 1, 22, -2);
                        i = this.iToken;
                    }
                    switch (this.tokAt(i + 1)) {
                        case 0x40000001: 
                        case 1073741868: {
                            this.getToken(++i);
                            colorRangeStage = 1;
                            propertyName = "rangeAll";
                            if (this.tokAt(i + 1) != 0x100003) break block3;
                            this.getToken(++i);
                            break block3;
                        }
                        default: {
                            signPt = i + 1;
                            break;
                        }
                    }
                    continue block37;
                }
                case 156242439: {
                    continue block37;
                }
                case 0x10100091: {
                    if (colorRangeStage != 0) break;
                    propertyName = "cutoffPositive";
                    propertyValue = new Float(this.floatParameter(++i));
                    break;
                }
                case 2: 
                case 3: {
                    propertyName = colorRangeStage == 1 ? "red" : (colorRangeStage == 2 ? "blue" : "cutoff");
                    propertyValue = new Float(this.floatParameter(i));
                    if (colorRangeStage <= 0) break;
                    ++colorRangeStage;
                    break;
                }
                case 38797321: {
                    propertyName = "ionicRadius";
                    propertyValue = new Float(this.radiusParameter(++i, 0.0f));
                    i = this.iToken;
                    break;
                }
                case 38797589: {
                    propertyName = "vdwRadius";
                    propertyValue = new Float(this.radiusParameter(++i, 0.0f));
                    i = this.iToken;
                    break;
                }
                case 135268355: {
                    planeSeen = true;
                    propertyName = "plane";
                    propertyValue = this.planeParameter(++i);
                    i = this.iToken;
                    break;
                }
                case 1073741877: {
                    propertyName = "scale";
                    propertyValue = new Float(this.floatParameter(++i));
                    break;
                }
                case 0x100003: {
                    if (idSeen) {
                        this.error(22);
                    }
                    propertyName = "thisID";
                    break;
                }
                case 528401: {
                    BitSet bs;
                    surfaceObjectSeen = true;
                    ++i;
                    try {
                        propertyValue = this.getPoint4f(i);
                        propertyName = "ellipsoid";
                        i = this.iToken;
                    }
                    catch (ScriptException e) {
                        try {
                            float[] fparams = new float[6];
                            i = this.floatParameterSet(i, fparams);
                            propertyValue = fparams;
                            propertyName = "ellipsoid";
                        }
                        catch (ScriptException e2) {
                            bs = this.expression(i);
                            int iAtom = BitSetUtil.firstSetBit(bs);
                            Atom[] atoms = this.viewer.getModelSet().atoms;
                            if (iAtom >= 0) {
                                propertyValue = atoms[iAtom].getEllipsoid();
                            }
                            if (propertyValue == null) {
                                return;
                            }
                            i = this.iToken;
                            propertyName = "ellipsoid";
                            if (this.isSyntaxCheck) break;
                            this.setShapeProperty(iShape, "center", this.viewer.getAtomPoint3f(iAtom));
                        }
                    }
                    break;
                }
                case 1073741944: {
                    planeSeen = true;
                    propertyName = "plane";
                    propertyValue = this.hklParameter(++i);
                    i = this.iToken;
                    break;
                }
                case 4126: {
                    BitSet bs;
                    surfaceObjectSeen = true;
                    String lcaoType = this.parameterAsString(++i);
                    this.setShapeProperty(iShape, "lcaoType", lcaoType);
                    switch (this.getToken((int)(++i)).tok) {
                        case 0x100001: 
                        case 0x40000007: {
                            Point3f pt;
                            propertyName = "lcaoCartoon";
                            bs = this.expression(i);
                            i = this.iToken;
                            int atomIndex = BitSetUtil.firstSetBit(bs);
                            modelIndex = 0;
                            if (atomIndex < 0) {
                                if (!this.isSyntaxCheck) {
                                    this.error(14);
                                }
                                pt = new Point3f();
                            } else {
                                modelIndex = this.viewer.getAtomModelIndex(atomIndex);
                                pt = this.viewer.getAtomPoint3f(atomIndex);
                            }
                            this.setShapeProperty(iShape, "modelIndex", new Integer(modelIndex));
                            Vector3f[] axes = new Vector3f[]{new Vector3f(), new Vector3f(), new Vector3f(pt), new Vector3f()};
                            if (!this.isSyntaxCheck) {
                                this.viewer.getHybridizationAndAxes(atomIndex, axes[0], axes[1], lcaoType, false);
                            }
                            propertyValue = axes;
                            break block3;
                        }
                    }
                    this.error(14);
                    break;
                }
                case 4130: {
                    if (++i == this.statementLength) {
                        this.error(2);
                    }
                    int moNumber = Integer.MAX_VALUE;
                    int offset = Integer.MAX_VALUE;
                    if (this.tokAt(i) == 2) {
                        moNumber = this.intParameter(i);
                    } else {
                        offset = this.moOffset(i);
                        if (offset != Integer.MAX_VALUE) {
                            moNumber = 0;
                            i = this.iToken;
                        }
                    }
                    this.setMoData(iShape, moNumber, offset, modelIndex, null);
                    surfaceObjectSeen = true;
                    continue block37;
                }
                case 1073741850: {
                    float[] partialCharges = null;
                    try {
                        partialCharges = this.viewer.getPartialCharges();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (!this.isSyntaxCheck && partialCharges == null) {
                        this.error(32);
                    }
                    surfaceObjectSeen = true;
                    propertyName = "mep";
                    propertyValue = partialCharges;
                    break;
                }
                case 540016651: 
                case 0x40000034: {
                    surfaceObjectSeen = true;
                    this.setShapeProperty(iShape, "bsSolvent", this.lookupIdentifierValue("solvent"));
                    propertyName = this.theTok == 0x40000034 ? "sasurface" : "solvent";
                    float radius = this.isFloatParameter(i + 1) ? this.floatParameter(++i) : this.viewer.getSolventProbeRadius();
                    propertyValue = new Float(radius);
                    break;
                }
                case 1: {
                    int ptY;
                    int ptX;
                    String dataName;
                    if (str.equalsIgnoreCase("ADDHYDROGENS")) {
                        propertyName = "addHydrogens";
                        propertyValue = Boolean.TRUE;
                        break;
                    }
                    if (str.equalsIgnoreCase("ANGSTROMS")) {
                        propertyName = "angstroms";
                        break;
                    }
                    if (str.equalsIgnoreCase("ANISOTROPY")) {
                        propertyName = "anisotropy";
                        propertyValue = this.getPoint3f(++i, false);
                        i = this.iToken;
                        break;
                    }
                    if (str.equalsIgnoreCase("AREA")) {
                        doCalcArea = true;
                        i = this.iToken;
                        break;
                    }
                    if (str.equalsIgnoreCase("VOLUME")) {
                        doCalcVolume = true;
                        i = this.iToken;
                        break;
                    }
                    if (str.equalsIgnoreCase("ATOMICORBITAL") || str.equalsIgnoreCase("ORBITAL")) {
                        surfaceObjectSeen = true;
                        nlmZ[0] = this.intParameter(++i);
                        nlmZ[1] = this.intParameter(++i);
                        nlmZ[2] = this.intParameter(++i);
                        nlmZ[3] = this.isFloatParameter(i + 1) ? this.floatParameter(++i) : 6.0f;
                        propertyName = "hydrogenOrbital";
                        propertyValue = nlmZ;
                        break;
                    }
                    if (str.equalsIgnoreCase("BINARY")) continue block37;
                    if (str.equalsIgnoreCase("BLOCKDATA")) {
                        propertyName = "blockData";
                        propertyValue = Boolean.TRUE;
                        break;
                    }
                    if (str.equalsIgnoreCase("CAP")) {
                        propertyName = "cappingPlane";
                        propertyValue = this.planeParameter(++i);
                        i = this.iToken;
                        break;
                    }
                    if (str.equalsIgnoreCase("CAVITY")) {
                        float envelopeRadius;
                        if (!isIsosurface) {
                            this.error(22);
                        }
                        isCavity = true;
                        if (this.isSyntaxCheck) continue block37;
                        float cavityRadius = this.isFloatParameter(i + 1) ? this.floatParameter(++i) : 1.2f;
                        float f = envelopeRadius = this.isFloatParameter(i + 1) ? this.floatParameter(++i) : 10.0f;
                        if (envelopeRadius > 10.0f) {
                            this.integerOutOfRange(0, 10);
                        }
                        this.setShapeProperty(iShape, "envelopeRadius", new Float(envelopeRadius));
                        this.setShapeProperty(iShape, "cavityRadius", new Float(cavityRadius));
                        propertyName = "cavity";
                        break;
                    }
                    if (str.equalsIgnoreCase("COLORSCHEME")) {
                        colorScheme = this.parameterAsString(++i);
                        break;
                    }
                    if (str.equalsIgnoreCase("CONTOUR")) {
                        propertyName = "contour";
                        propertyValue = new Integer(this.tokAt(i + 1) == 2 ? this.intParameter(++i) : 0);
                        break;
                    }
                    if (str.equalsIgnoreCase("CUTOFF")) {
                        if (++i < this.statementLength && this.getToken((int)i).tok == 0x10100091) {
                            propertyName = "cutoffPositive";
                            propertyValue = new Float(this.floatParameter(++i));
                            break;
                        }
                        propertyName = "cutoff";
                        propertyValue = new Float(this.floatParameter(i));
                        break;
                    }
                    if (str.equalsIgnoreCase("DOWNSAMPLE")) {
                        propertyName = "downsample";
                        propertyValue = new Integer(this.intParameter(++i));
                        break;
                    }
                    if (str.equalsIgnoreCase("ECCENTRICITY")) {
                        propertyName = "eccentricity";
                        propertyValue = this.getPoint4f(++i);
                        i = this.iToken;
                        break;
                    }
                    if (str.equalsIgnoreCase("ED")) {
                        this.setMoData(iShape, -1, 0, modelIndex, null);
                        surfaceObjectSeen = true;
                        continue block37;
                    }
                    if (str.equalsIgnoreCase("DEBUG") || str.equalsIgnoreCase("NODEBUG")) {
                        propertyName = "debug";
                        propertyValue = str.equalsIgnoreCase("DEBUG") ? Boolean.TRUE : Boolean.FALSE;
                        break;
                    }
                    if (str.equalsIgnoreCase("FIXED")) {
                        propertyName = "fixed";
                        propertyValue = Boolean.TRUE;
                        break;
                    }
                    if (str.equalsIgnoreCase("FUNCTIONXY")) {
                        Vector<Object> v = new Vector<Object>();
                        if (this.getToken((int)(++i)).tok != 4) {
                            this.error(53, "functionXY must be followed by a function name in quotes.");
                        }
                        String fName = this.parameterAsString(i++);
                        dataName = this.extractCommandOption("# DATA" + (isFxy ? "2" : ""));
                        if (dataName != null) {
                            fName = dataName;
                        }
                        boolean isXYZ = fName.indexOf("data2d_xyz") == 0;
                        v.addElement(fName);
                        v.addElement(this.getPoint3f(i, false));
                        ptX = ++this.iToken;
                        Point4f pt = this.getPoint4f(ptX);
                        v.addElement(pt);
                        int nX = (int)pt.x;
                        ptY = ++this.iToken;
                        pt = this.getPoint4f(ptY);
                        v.addElement(pt);
                        int nY = (int)pt.x;
                        v.addElement(this.getPoint4f(++this.iToken));
                        if (nX == 0 || nY == 0) {
                            this.error(22);
                        }
                        if (!this.isSyntaxCheck) {
                            float[][] fdata;
                            float[][] fArray = fdata = isXYZ ? this.viewer.getDataFloat2D(fName) : this.viewer.functionXY(fName, nX, nY);
                            if (isXYZ) {
                                nX = fdata == null ? 0 : fdata.length;
                                nY = 3;
                            } else {
                                nX = Math.abs(nX);
                                nY = Math.abs(nY);
                            }
                            if (fdata == null) {
                                this.iToken = ptX;
                                this.error(53, "fdata is null.");
                            }
                            if (fdata.length != nX && !isXYZ) {
                                this.iToken = ptX;
                                this.error(53, "fdata length is not correct: " + fdata.length + " " + nX + ".");
                            }
                            for (int j = 0; j < nX; ++j) {
                                if (fdata[j] == null) {
                                    this.iToken = ptY;
                                    this.error(53, "fdata[" + j + "] is null.");
                                }
                                if (fdata[j].length == nY) continue;
                                this.iToken = ptY;
                                this.error(53, "fdata[" + j + "] is not the right length: " + fdata[j].length + " " + nY + ".");
                            }
                            v.addElement(fdata);
                        }
                        i = this.iToken;
                        propertyName = "functionXY";
                        propertyValue = v;
                        surfaceObjectSeen = true;
                        isFxy = true;
                        break;
                    }
                    if (str.equalsIgnoreCase("FUNCTIONXYZ")) {
                        Vector<Object> v = new Vector<Object>();
                        if (this.getToken((int)(++i)).tok != 4) {
                            this.error(53, "functionXYZ must be followed by a function name in quotes.");
                        }
                        String fName = this.parameterAsString(i++);
                        dataName = this.extractCommandOption("# DATA");
                        if (dataName != null) {
                            fName = dataName;
                        }
                        v.addElement(fName);
                        v.addElement(this.getPoint3f(i, false));
                        ptX = ++this.iToken;
                        Point4f pt = this.getPoint4f(ptX);
                        v.addElement(pt);
                        int nX = (int)pt.x;
                        ptY = ++this.iToken;
                        pt = this.getPoint4f(ptY);
                        v.addElement(pt);
                        int nY = (int)pt.x;
                        pt = this.getPoint4f(++this.iToken);
                        v.addElement(pt);
                        int nZ = (int)pt.x;
                        if (nX == 0 || nY == 0) {
                            this.error(22);
                        }
                        if (!this.isSyntaxCheck) {
                            float[][][] xyzdata = this.viewer.functionXYZ(fName, nX, nY, nZ);
                            nX = Math.abs(nX);
                            nY = Math.abs(nY);
                            if (xyzdata == null) {
                                this.iToken = ptX;
                                this.error(53, "xyzdata is null.");
                            }
                            v.addElement(xyzdata);
                        }
                        i = this.iToken;
                        propertyName = "functionXYZ";
                        propertyValue = v;
                        surfaceObjectSeen = true;
                        isFxy = true;
                        break;
                    }
                    if (str.equalsIgnoreCase("GRIDPOINTS")) {
                        propertyName = "gridPoints";
                        break;
                    }
                    if (str.equalsIgnoreCase("ID")) {
                        this.setShapeId(iShape, ++i, idSeen);
                        isWild = this.viewer.getShapeProperty(21, "ID") == null;
                        i = this.iToken;
                        break;
                    }
                    if (str.equalsIgnoreCase("IGNORE")) {
                        propertyName = "ignore";
                        propertyValue = this.expression(++i);
                        i = this.iToken;
                        break;
                    }
                    if (str.equalsIgnoreCase("INSIDEOUT")) {
                        propertyName = "insideOut";
                        break;
                    }
                    if (str.equalsIgnoreCase("INTERIOR")) {
                        propertyName = "pocket";
                        propertyValue = Boolean.FALSE;
                        break;
                    }
                    if (str.equalsIgnoreCase("LINK")) {
                        propertyName = "link";
                        break;
                    }
                    if (str.equalsIgnoreCase("LOBE")) {
                        surfaceObjectSeen = true;
                        propertyName = "lobe";
                        propertyValue = this.getPoint4f(++i);
                        i = this.iToken;
                        break;
                    }
                    if (str.equalsIgnoreCase("MAP")) {
                        surfaceObjectSeen = !isCavity;
                        propertyName = "map";
                        break;
                    }
                    if (str.equalsIgnoreCase("MAXSET")) {
                        propertyName = "maxset";
                        propertyValue = new Integer(this.intParameter(++i));
                        break;
                    }
                    if (str.equalsIgnoreCase("MINSET")) {
                        propertyName = "minset";
                        propertyValue = new Integer(this.intParameter(++i));
                        break;
                    }
                    if (str.equalsIgnoreCase("MODELBASED")) {
                        propertyName = "fixed";
                        propertyValue = Boolean.FALSE;
                        break;
                    }
                    if (str.equalsIgnoreCase("MOLECULAR")) {
                        surfaceObjectSeen = true;
                        propertyName = "molecular";
                        propertyValue = new Float(1.4);
                        break;
                    }
                    if (str.equalsIgnoreCase("OBJ")) {
                        this.setShapeProperty(iShape, "fileType", "Obj");
                        continue block37;
                    }
                    if (str.equalsIgnoreCase("PHASE")) {
                        if (surfaceObjectSeen) {
                            this.error(22);
                        }
                        propertyName = "phase";
                        propertyValue = this.tokAt(i + 1) == 4 ? this.stringParameter(++i) : "_orb";
                        break;
                    }
                    if (str.equalsIgnoreCase("POCKET")) {
                        propertyName = "pocket";
                        propertyValue = Boolean.TRUE;
                        break;
                    }
                    if (str.equalsIgnoreCase("REMAPPABLE")) {
                        propertyName = "remappable";
                        break;
                    }
                    if (str.equalsIgnoreCase("RESOLUTION") || str.equalsIgnoreCase("POINTSPERANGSTROM")) {
                        propertyName = "resolution";
                        propertyValue = new Float(this.floatParameter(++i));
                        break;
                    }
                    if (str.equalsIgnoreCase("REVERSECOLOR")) {
                        propertyName = "reverseColor";
                        propertyValue = Boolean.TRUE;
                        break;
                    }
                    if (str.equalsIgnoreCase("SIGN")) {
                        signPt = i + 1;
                        propertyName = "sign";
                        propertyValue = Boolean.TRUE;
                        colorRangeStage = 1;
                        break;
                    }
                    if (str.equalsIgnoreCase("SPHERE")) {
                        surfaceObjectSeen = true;
                        propertyName = "sphere";
                        propertyValue = new Float(this.floatParameter(++i));
                        break;
                    }
                    if (str.equalsIgnoreCase("SQUARED")) {
                        propertyName = "squareData";
                        propertyValue = Boolean.TRUE;
                        break;
                    }
                    if (str.equalsIgnoreCase("VARIABLE")) {
                        propertyName = "property";
                        data = new float[this.viewer.getAtomCount()];
                        if (!this.isSyntaxCheck) {
                            Parser.parseFloatArray("" + this.getParameter(this.parameterAsString(++i), false), null, data);
                        }
                        propertyValue = data;
                        break;
                    }
                    this.setShapeId(iShape, i, idSeen);
                    i = this.iToken;
                    break;
                }
                case 4: {
                    Object t;
                    propertyName = surfaceObjectSeen || planeSeen ? "mapColor" : "readFile";
                    String filename = this.parameterAsString(i);
                    if (filename.equals("TESTDATA") && Viewer.testData != null) {
                        propertyValue = Viewer.testData;
                        break;
                    }
                    if (filename.equals("TESTDATA2") && Viewer.testData2 != null) {
                        propertyValue = Viewer.testData2;
                        break;
                    }
                    if (filename.length() == 0) {
                        if (surfaceObjectSeen || planeSeen) {
                            propertyValue = this.viewer.getModelAuxiliaryInfo(modelIndex, "jmolMappedDataInfo");
                        }
                        if (propertyValue == null) {
                            propertyValue = this.viewer.getModelAuxiliaryInfo(modelIndex, "jmolSurfaceInfo");
                        }
                        surfaceObjectSeen = true;
                        if (propertyValue != null) break;
                        filename = this.getFullPathName();
                    }
                    surfaceObjectSeen = true;
                    if (this.tokAt(i + 1) == 2) {
                        this.setShapeProperty(iShape, "fileIndex", new Integer(this.intParameter(++i)));
                    }
                    String[] fullPathNameReturn = new String[1];
                    if (filename.equalsIgnoreCase("INLINE")) {
                        if (this.tokAt(i + 1) != 4) {
                            this.error(41);
                        }
                        this.setShapeProperty(iShape, "fileType", "Pmesh");
                        String sdata = this.parameterAsString(++i);
                        sdata = TextFormat.replaceAllCharacters(sdata, "{,}|", ' ');
                        if (this.logMessages) {
                            Logger.debug("pmesh inline data:\n" + sdata);
                        }
                        t = this.isSyntaxCheck ? null : FileManager.getBufferedReaderForString(sdata);
                    } else {
                        if (this.thisCommand.indexOf("# FILE" + nFiles + "=") >= 0) {
                            filename = this.extractCommandOption("# FILE" + nFiles);
                        }
                        Object object = t = this.isSyntaxCheck ? null : this.viewer.getBufferedReaderOrErrorMessageFromName(filename, fullPathNameReturn, false);
                        if (t instanceof String) {
                            this.error(17, filename + ":" + t);
                        }
                        if (!this.isSyntaxCheck) {
                            Logger.info("reading isosurface data from " + fullPathNameReturn[0]);
                        }
                        this.setShapeProperty(iShape, "commandOption", "FILE" + nFiles++ + "=" + Escape.escape(fullPathNameReturn[0]));
                        this.setShapeProperty(iShape, "fileName", fullPathNameReturn[0]);
                    }
                    propertyValue = t;
                    break;
                }
                default: {
                    if (planeSeen && !surfaceObjectSeen) {
                        this.setShapeProperty(iShape, "nomap", new Float(0.0f));
                        surfaceObjectSeen = true;
                    }
                    if (!this.setMeshDisplayProperty(iShape, i, this.theTok)) {
                        this.error(22);
                    }
                    i = this.iToken;
                }
            }
            boolean bl = idSeen = this.theTok != 12291;
            if (propertyName == "property" && !surfaceObjectSeen) {
                surfaceObjectSeen = true;
                this.setShapeProperty(iShape, "bsSolvent", this.lookupIdentifierValue("solvent"));
                propertyName = "sasurface";
                propertyValue = new Float(0.0f);
            }
            if (isWild && surfaceObjectSeen) {
                this.error(22);
            }
            if (propertyName == null) continue;
            this.setShapeProperty(iShape, propertyName, propertyValue);
        }
        if (isCavity && !surfaceObjectSeen) {
            surfaceObjectSeen = true;
            this.setShapeProperty(iShape, "bsSolvent", this.lookupIdentifierValue("solvent"));
            this.setShapeProperty(iShape, "sasurface", new Float(0.0f));
        }
        if (planeSeen && !surfaceObjectSeen) {
            this.setShapeProperty(iShape, "nomap", new Float(0.0f));
            surfaceObjectSeen = true;
        }
        if (colorScheme != null) {
            this.setShapeProperty(iShape, "setColorScheme", colorScheme);
        }
        float f = area = doCalcArea ? ((Float)this.viewer.getShapeProperty(iShape, "area")).floatValue() : Float.NaN;
        if (doCalcArea) {
            this.viewer.setFloatProperty("isosurfaceArea", area);
        }
        float f2 = volume = doCalcVolume ? ((Float)this.viewer.getShapeProperty(iShape, "volume")).floatValue() : Float.NaN;
        if (doCalcVolume) {
            this.viewer.setFloatProperty("isosurfaceVolume", volume);
        }
        if (surfaceObjectSeen && isIsosurface && !this.isSyntaxCheck) {
            this.setShapeProperty(iShape, "finalize", null);
            Integer n2 = (Integer)this.viewer.getShapeProperty(iShape, "count");
            float[] dataRange = (float[])this.viewer.getShapeProperty(iShape, "dataRange");
            String s = (String)this.viewer.getShapeProperty(iShape, "ID");
            if (s != null) {
                s = s + " created with cutoff = " + this.viewer.getShapeProperty(iShape, "cutoff") + " ; number of isosurfaces = " + n2;
                if (dataRange != null && dataRange[0] != dataRange[1]) {
                    s = s + "\ncolor range " + dataRange[2] + " " + dataRange[3] + "; mapped data range " + dataRange[0] + " to " + dataRange[1];
                }
                if (doCalcArea) {
                    s = s + "\nisosurfaceArea = " + area;
                }
                if (doCalcVolume) {
                    s = s + "\nisosurfaceVolume = " + volume;
                }
                this.showString(s);
            }
        } else if (doCalcArea || doCalcVolume) {
            if (doCalcArea) {
                this.showString("isosurfaceArea = " + area);
            }
            if (doCalcVolume) {
                this.showString("isosurfaceVolume = " + volume);
            }
        }
        if (translucency != null) {
            this.setShapeProperty(iShape, "translucency", translucency);
        }
        this.setShapeProperty(iShape, "clear", null);
    }

    /*
     * Unable to fully structure code
     */
    private boolean setMeshDisplayProperty(int shape, int i, int tok) throws ScriptException {
        propertyName = null;
        propertyValue = null;
        checkOnly = i == 0;
        switch (tok) {
            case 1073741861: 
            case 1073741887: {
                if (checkOnly) {
                    return true;
                }
                this.colorShape(shape, this.iToken, false);
                return true;
            }
            case 0: 
            case 12291: 
            case 12293: 
            case 0x10000C: 
            case 0x10000D: 
            case 3145751: 
            case 3145752: 
            case 536883204: {
                if (this.iToken == 1) {
                    this.setShapeProperty(shape, "thisID", null);
                }
                if (tok == 0) {
                    return this.iToken == 1;
                }
                if (checkOnly) {
                    return true;
                }
                if (tok == 12291) {
                    this.setShapeProperty(shape, "delete", null);
                    return true;
                }
                if (tok != 3145752 && tok != 12293) ** GOTO lbl23
                tok = 0x10000C;
                ** GOTO lbl25
lbl23:
                // 1 sources

                if (tok == 3145751 || tok == 536883204) {
                    tok = 0x10000D;
                }
            }
lbl25:
            // 5 sources

            case 528399: 
            case 0x40000006: 
            case 0x40000010: 
            case 1073741843: 
            case 0x40000014: 
            case 1073741845: 
            case 1073741851: 
            case 1073741855: 
            case 0x40000020: 
            case 1073741857: 
            case 1073741859: 
            case 0x40000024: 
            case 0x40000040: 
            case 0x40000070: 
            case 1073741954: {
                propertyName = "token";
                propertyValue = new Integer(tok);
            }
        }
        if (propertyName == null) {
            return false;
        }
        if (checkOnly) {
            return true;
        }
        this.setShapeProperty(shape, propertyName, propertyValue);
        tok = this.tokAt(this.iToken + 1);
        if (tok != 0 && !this.setMeshDisplayProperty(shape, ++this.iToken, tok)) {
            --this.iToken;
        }
        return true;
    }

    class ScriptException
    extends Exception {
        private String message;
        private String untranslated;

        ScriptException(String msg, String untranslated) {
            ScriptEvaluator.this.errorType = this.message = msg;
            ScriptEvaluator.this.iCommandError = ScriptEvaluator.this.pc;
            String string = this.untranslated = untranslated == null ? msg : untranslated;
            if (this.message == null) {
                this.message = "";
                return;
            }
            String s = ScriptEvaluator.this.contextTrace();
            this.message = this.message + s;
            this.untranslated = this.untranslated + s;
            if (ScriptEvaluator.this.isSyntaxCheck || msg.indexOf("file recognized as a script file:") >= 0) {
                return;
            }
            Logger.error("eval ERROR: " + this.toString());
            if (ScriptEvaluator.this.viewer.autoExit) {
                ScriptEvaluator.this.viewer.exitJmol();
            }
        }

        protected String getErrorMessageUntranslated() {
            return this.untranslated;
        }

        public String toString() {
            return this.message;
        }
    }
}

