/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Bond;
import org.jmol.modelset.BoxInfo;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Measure;
import org.jmol.util.Parser;
import org.jmol.util.Quaternion;
import org.jmol.util.TextFormat;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.PropertyManager;
import org.jmol.viewer.ScriptEvaluator;
import org.jmol.viewer.ScriptVariable;
import org.jmol.viewer.Token;
import org.jmol.viewer.Viewer;

class ScriptMathProcessor {
    private boolean isSyntaxCheck;
    private boolean logMessages;
    private ScriptEvaluator eval;
    private Viewer viewer;
    private Token[] oStack = new Token[8];
    private ScriptVariable[] xStack = new ScriptVariable[8];
    private char[] ifStack = new char[8];
    private int ifPt = -1;
    private int oPt = -1;
    private int xPt = -1;
    private int parenCount;
    private int squareCount;
    private int braceCount;
    private boolean wasX;
    private int incrementX;
    private boolean isArrayItem;
    private boolean asVector;
    private int ptid = 0;
    private int ptx = Integer.MAX_VALUE;
    private boolean skipping;

    ScriptMathProcessor(ScriptEvaluator eval, boolean isArrayItem, boolean asVector) {
        this.eval = eval;
        this.viewer = eval.viewer;
        this.logMessages = eval.logMessages;
        this.isSyntaxCheck = eval.isSyntaxCheck;
        this.isArrayItem = isArrayItem;
        this.asVector = asVector || isArrayItem;
        this.wasX = isArrayItem;
        if (this.logMessages) {
            Logger.info("initialize RPN");
        }
    }

    ScriptVariable getResult(boolean allowUnderflow, String key) throws ScriptEvaluator.ScriptException {
        boolean isOK = true;
        ScriptVariable x = null;
        while (isOK && this.oPt >= 0) {
            isOK = this.operate();
        }
        if (isOK) {
            if (this.isArrayItem && this.xPt == 2 && this.xStack[1].tok == 0x10100040) {
                x = this.xStack[2];
            }
            if (this.asVector) {
                Vector<ScriptVariable> result = new Vector<ScriptVariable>();
                for (int i = 0; i <= this.xPt; ++i) {
                    result.addElement(ScriptVariable.selectItem(this.xStack[i]));
                }
                return new ScriptVariable(4161, result);
            }
            if (this.xPt == 0) {
                if (x == null) {
                    x = this.xStack[0];
                }
                if (x.tok == 0x40000007 || x.tok == 6 || x.tok == 4) {
                    x = ScriptVariable.selectItem(x);
                }
                return x;
            }
        }
        if (!(allowUnderflow || this.xPt < 0 && this.oPt < 0)) {
            this.eval.error(22);
        }
        return null;
    }

    private void putX(ScriptVariable x) {
        if (this.skipping) {
            return;
        }
        if (++this.xPt == this.xStack.length) {
            this.xStack = (ScriptVariable[])ArrayUtil.doubleLength(this.xStack);
        }
        if (this.logMessages) {
            Logger.info("\nputX: " + x);
        }
        this.xStack[this.xPt] = x;
        this.ptx = ++this.ptid;
    }

    private void putOp(Token op) {
        if (++this.oPt >= this.oStack.length) {
            this.oStack = (Token[])ArrayUtil.doubleLength(this.oStack);
        }
        this.oStack[this.oPt] = op;
        ++this.ptid;
    }

    private void putIf(char c) {
        if (++this.ifPt >= this.ifStack.length) {
            this.ifStack = (char[])ArrayUtil.doubleLength((Object)this.ifStack);
        }
        this.ifStack[this.ifPt] = c;
    }

    boolean addX(ScriptVariable x) {
        this.putX(x);
        this.wasX = true;
        return true;
    }

    boolean addX(Object x) {
        ScriptVariable v = ScriptVariable.getVariable(x);
        if (v == null) {
            return false;
        }
        this.putX(v);
        this.wasX = true;
        return true;
    }

    boolean addXNum(ScriptVariable x) throws ScriptEvaluator.ScriptException {
        if (this.wasX) {
            switch (x.tok) {
                case 2: {
                    if (x.intValue >= 0) break;
                    this.addOp(Token.tokenMinus);
                    x = ScriptVariable.intVariable(-x.intValue);
                    break;
                }
                case 3: {
                    float f = ((Float)x.value).floatValue();
                    if (!(f < 0.0f)) break;
                    this.addOp(Token.tokenMinus);
                    x = new ScriptVariable(3, new Float(-f));
                }
            }
        }
        this.putX(x);
        this.wasX = true;
        return true;
    }

    private boolean addX(boolean x) {
        this.putX(ScriptVariable.getVariable(x ? Boolean.TRUE : Boolean.FALSE));
        this.wasX = true;
        return true;
    }

    private boolean addX(int x) {
        this.putX(ScriptVariable.intVariable(x));
        this.wasX = true;
        return true;
    }

    private boolean addX(float x) {
        return this.addX(new Float(x));
    }

    private static boolean isOpFunc(Token op) {
        return Token.tokAttr(op.tok, 0x8100000) || op.tok == 0x101000C1 && Token.tokAttr(op.intValue, 0x8100000);
    }

    boolean addOp(Token op) throws ScriptEvaluator.ScriptException {
        return this.addOp(op, true);
    }

    boolean addOp(Token op, boolean allowMathFunc) throws ScriptEvaluator.ScriptException {
        boolean isMathFunc;
        boolean isDotSelector;
        if (this.logMessages) {
            this.dumpStacks("addOp entry\naddOp: " + op + " oPt=" + this.oPt + " ifPt = " + this.ifPt + " skipping=" + this.skipping + " wasX=" + this.wasX);
        }
        int tok0 = this.oPt >= 0 ? this.oStack[this.oPt].tok : 0;
        boolean bl = this.skipping = this.ifPt >= 0 && (this.ifStack[this.ifPt] == 'F' || this.ifStack[this.ifPt] == 'X');
        if (this.skipping) {
            switch (op.tok) {
                case 0x10100010: {
                    this.putOp(op);
                    return true;
                }
                case 0x10100022: {
                    if (tok0 != 0x10100022 || this.ifStack[this.ifPt] == 'X') {
                        return true;
                    }
                    this.ifStack[this.ifPt] = 84;
                    this.wasX = false;
                    this.skipping = false;
                    return true;
                }
                case 0x10100011: {
                    if (tok0 == 0x10100010) {
                        --this.oPt;
                        return true;
                    }
                    if (tok0 != 0x10100022) {
                        this.putOp(op);
                        return true;
                    }
                    this.wasX = true;
                    --this.ifPt;
                    this.oPt -= 2;
                    this.skipping = false;
                    return true;
                }
            }
            return true;
        }
        Token newOp = null;
        boolean isLeftOp = false;
        boolean bl2 = isDotSelector = op.tok == 0x101000C1;
        if (isDotSelector && !this.wasX) {
            return false;
        }
        boolean bl3 = isMathFunc = allowMathFunc && ScriptMathProcessor.isOpFunc(op);
        if (this.oPt >= 1 && op.tok != 0x10100010 && tok0 == 135268355) {
            tok0 = this.oStack[--this.oPt].tok;
        }
        boolean isArgument = this.oPt >= 1 && tok0 == 0x10100010;
        switch (op.tok) {
            case 0x10100030: {
                if (this.wasX) break;
                return false;
            }
            case 32: 
            case 64: 
            case 96: 
            case 128: 
            case 224: {
                int tok;
                int n = tok = this.oPt < 0 ? 0 : tok0;
                if (!this.wasX || tok != 0x101000C1 && tok != 605028354 && tok != 0x4100001) {
                    return false;
                }
                this.oStack[this.oPt].intValue |= op.tok;
                return true;
            }
            case 0x10100040: {
                isLeftOp = true;
                if (this.wasX) break;
                ++this.squareCount;
                op = newOp = Token.tokenArray;
                break;
            }
            case 0x10100041: {
                break;
            }
            case 0x101000B1: 
            case 269484210: {
                int n = this.incrementX = op.tok == 269484210 ? 1 : -1;
                if (this.ptid != this.ptx) break;
                if (this.isSyntaxCheck) {
                    return true;
                }
                ScriptVariable x = this.xStack[this.xPt];
                this.xStack[this.xPt] = new ScriptVariable().set(x);
                return x.increment(this.incrementX);
            }
            case 0x10100090: {
                if (this.wasX) break;
                this.addX(0);
                op = new ScriptVariable(0x101000B0, "-");
                break;
            }
            case 0x10100011: {
                if (this.wasX || this.oPt < 1 || tok0 != 0x10100010 || ScriptMathProcessor.isOpFunc(this.oStack[this.oPt - 1])) break;
                return false;
            }
            case 0x10100010: 
            case 0x10100070: {
                isLeftOp = true;
            }
            default: {
                if (isMathFunc) {
                    if (!isDotSelector && this.wasX && !isArgument) {
                        return false;
                    }
                    newOp = op;
                    isLeftOp = true;
                    break;
                }
                if (this.wasX != isLeftOp || tok0 == 0x101000C1) break;
                return false;
            }
        }
        while (!(this.oPt < 0 || tok0 == 0x10100022 || isLeftOp && (tok0 != 0x101000C1 || op.tok != 0x101000C1 && op.tok != 0x10100040) || Token.getPrecedence(tok0) < Token.getPrecedence(op.tok))) {
            if (this.logMessages) {
                Logger.info("\noperating, oPt=" + this.oPt + " isLeftOp=" + isLeftOp + " oStack[oPt]=" + Token.nameOf(tok0) + "        prec=" + Token.getPrecedence(tok0) + " pending op=\"" + Token.nameOf(op.tok) + "\" prec=" + Token.getPrecedence(op.tok));
                this.dumpStacks("operating");
            }
            if (op.tok == 0x10100011 && tok0 == 0x10100010) {
                if (this.xPt < 0) break;
                this.xStack[this.xPt] = ScriptVariable.selectItem(this.xStack[this.xPt]);
                break;
            }
            if (op.tok == 0x10100041 && tok0 == 0x8100001) break;
            if (op.tok == 0x10100041 && tok0 == 0x10100040) {
                if (this.xPt == 0 && this.isArrayItem) {
                    this.addX(new ScriptVariable(Token.tokenArraySelector));
                    break;
                }
                if (this.doBitsetSelect()) break;
                return false;
            }
            if (!this.operate()) {
                return false;
            }
            tok0 = this.oPt >= 0 ? this.oStack[this.oPt].tok : 0;
        }
        if (newOp != null) {
            this.addX(new ScriptVariable(269484420, newOp));
        }
        switch (op.tok) {
            case 0x10100010: {
                ++this.parenCount;
                this.wasX = false;
                break;
            }
            case 806354977: {
                boolean isFirst = ScriptVariable.bValue(this.getX());
                if (tok0 == 0x10100022) {
                    --this.ifPt;
                } else {
                    this.putOp(Token.tokenColon);
                }
                this.putIf(isFirst ? (char)'T' : 'F');
                this.skipping = !isFirst;
                this.wasX = false;
                return true;
            }
            case 0x10100022: {
                if (tok0 != 0x10100022) {
                    return false;
                }
                if (this.ifPt < 0) {
                    return false;
                }
                this.ifStack[this.ifPt] = 88;
                this.wasX = false;
                this.skipping = true;
                return true;
            }
            case 0x10100011: {
                this.wasX = true;
                if (this.parenCount-- <= 0) {
                    return false;
                }
                if (tok0 == 0x10100022) {
                    --this.ifPt;
                    --this.oPt;
                }
                --this.oPt;
                if (this.oPt < 0) {
                    return true;
                }
                if (ScriptMathProcessor.isOpFunc(this.oStack[this.oPt]) && !this.evaluateFunction()) {
                    return false;
                }
                this.skipping = this.ifPt >= 0 && this.ifStack[this.ifPt] == 'X';
                return true;
            }
            case 0x10100030: {
                this.wasX = false;
                return true;
            }
            case 0x10100040: {
                ++this.squareCount;
                this.wasX = false;
                break;
            }
            case 0x10100041: {
                this.wasX = true;
                if (this.squareCount-- <= 0) {
                    return false;
                }
                if (this.oStack[this.oPt].tok == 0x8100001) {
                    return this.evaluateFunction();
                }
                --this.oPt;
                return true;
            }
            case 0x101000C1: {
                this.wasX = !allowMathFunc || !Token.tokAttr(op.intValue, 0x8100000);
                break;
            }
            case 0x10000A: {
                ++this.braceCount;
                this.wasX = false;
                break;
            }
            case 0x10000E: {
                if (this.braceCount-- <= 0) {
                    return false;
                }
            }
            default: {
                this.wasX = false;
            }
        }
        this.putOp(op);
        if (op.tok == 0x101000C1 && (op.intValue & 0xFFFFFF1F) == 135499780 && op.intValue != 135499780) {
            return this.evaluateFunction();
        }
        return true;
    }

    private boolean doBitsetSelect() {
        if (this.xPt < 0 || this.xPt == 0 && !this.isArrayItem) {
            return false;
        }
        int i = ScriptVariable.iValue(this.xStack[this.xPt--]);
        ScriptVariable var = this.xStack[this.xPt];
        switch (var.tok) {
            default: {
                var = new ScriptVariable(4, ScriptVariable.sValue(var));
            }
            case 4: 
            case 6: 
            case 0x40000007: 
        }
        this.xStack[this.xPt] = ScriptVariable.selectItem(var, i);
        return true;
    }

    void dumpStacks(String message) {
        int i;
        Logger.info("\n\nRPN stacks: " + message + "\n");
        for (i = 0; i <= this.xPt; ++i) {
            Logger.info("x[" + i + "]: " + this.xStack[i]);
        }
        Logger.info("\n");
        for (i = 0; i <= this.oPt; ++i) {
            Logger.info("o[" + i + "]: " + this.oStack[i] + " prec=" + Token.getPrecedence(this.oStack[i].tok));
        }
        Logger.info(" ifStack = " + new String(this.ifStack).substring(0, this.ifPt + 1));
        System.out.flush();
    }

    private ScriptVariable getX() throws ScriptEvaluator.ScriptException {
        if (this.xPt < 0) {
            this.eval.error(13);
        }
        ScriptVariable v = ScriptVariable.selectItem(this.xStack[this.xPt]);
        this.xStack[this.xPt--] = null;
        return v;
    }

    private boolean evaluateFunction() throws ScriptEvaluator.ScriptException {
        Token op = this.oStack[this.oPt--];
        int tok = op.tok == 0x101000C1 ? op.intValue & 0xFFFFFF1F : op.tok;
        int nParamMax = Token.getMaxMathParams(tok);
        int nParam = 0;
        int pt = this.xPt;
        while (pt >= 0 && this.xStack[pt--].value != op) {
            ++nParam;
        }
        if (nParamMax > 0 && nParam > nParamMax) {
            return false;
        }
        ScriptVariable[] args = new ScriptVariable[nParam];
        int i = nParam;
        while (--i >= 0) {
            args[i] = this.getX();
        }
        --this.xPt;
        if (this.isSyntaxCheck) {
            return op.tok == 0x101000C1 ? true : this.addX(true);
        }
        switch (tok) {
            case 202376194: {
                if (op.tok == 0x101000C1) {
                    return this.evaluateDistance(args);
                }
            }
            case 0x8100801: {
                return this.evaluateMeasure(args, op.tok == 0x8100801);
            }
            case 135499780: {
                return this.evaluateUserFunction((String)op.value, args, op.intValue, op.tok == 0x101000C1);
            }
            case 202376196: {
                return this.evaluateFind(args);
            }
            case 202376195: {
                return this.evaluateReplace(args);
            }
            case 0x8100001: {
                return this.evaluateArray(args);
            }
            case 135266820: 
            case 135266821: 
            case 135266822: 
            case 135268358: 
            case 135272453: {
                return this.evaluateMath(args, tok);
            }
            case 135267329: {
                return this.evaluateCross(args);
            }
            case 135267332: {
                return this.evaluateRandom(args);
            }
            case 202375681: 
            case 202375684: 
            case 202375686: {
                return this.evaluateString(op.intValue, args);
            }
            case 202375680: 
            case 202375683: 
            case 202375685: 
            case 202376193: {
                return this.evaluateList(op.intValue, args);
            }
            case 137364482: {
                return this.evaluateHelix(args);
            }
            case 214958338: 
            case 752374019: {
                return this.evaluateLabel(op.intValue, args);
            }
            case 135272450: {
                return this.evaluateData(args);
            }
            case 135271427: 
            case 156242439: {
                return this.evaluateLoad(args, tok);
            }
            case 135270406: {
                return this.evaluateWrite(args);
            }
            case 135271429: 
            case 135287299: {
                return this.evaluateScript(args, tok);
            }
            case 135268865: {
                return this.evaluateWithin(args);
            }
            case 135270405: {
                return this.evaluateGetProperty(args);
            }
            case 135268356: {
                return this.evaluatePoint(args);
            }
            case 135268355: {
                return this.evaluatePlane(args);
            }
            case 135268866: {
                return this.evaluateConnected(args);
            }
            case 135266818: {
                return this.evaluateSubstructure(args);
            }
        }
        return false;
    }

    private boolean evaluateHelix(ScriptVariable[] args) {
        if (args.length < 1) {
            return false;
        }
        BitSet bs = args[0].value instanceof BitSet ? (BitSet)args[0].value : this.eval.compareInt(22020111, null, 269484420, ScriptVariable.iValue(args[0]));
        String type = (args.length == 1 ? "array" : ScriptVariable.sValue(args[1])).toLowerCase();
        if (type.equals("point")) {
            return this.addX(this.isSyntaxCheck ? new Point3f() : (Point3f)this.viewer.getHelixData(bs, 135268356));
        }
        if (type.equals("axis")) {
            return this.addX(this.isSyntaxCheck ? new Vector3f() : (Vector3f)this.viewer.getHelixData(bs, 0x40000003));
        }
        if (type.equals("radius")) {
            return this.addX(this.isSyntaxCheck ? new Vector3f() : (Vector3f)this.viewer.getHelixData(bs, 592445697));
        }
        if (type.equals("angle")) {
            return this.addX(this.isSyntaxCheck ? 0.0f : ((Float)this.viewer.getHelixData(bs, 0x8100801)).floatValue());
        }
        if (type.equals("draw")) {
            return this.addX(this.isSyntaxCheck ? "" : (String)this.viewer.getHelixData(bs, 4112));
        }
        if (type.equals("array")) {
            String[] data = (String[])this.viewer.getHelixData(bs, 0x8100001);
            if (data == null) {
                return false;
            }
            return this.addX(data);
        }
        return false;
    }

    private boolean evaluateDistance(ScriptVariable[] args) throws ScriptEvaluator.ScriptException {
        ScriptVariable x1 = this.getX();
        if (args.length != 1) {
            return false;
        }
        if (this.isSyntaxCheck) {
            return this.addX(1.0f);
        }
        ScriptVariable x2 = args[0];
        Point3f pt2 = this.ptValue(x2);
        Point4f plane2 = this.planeValue(x2);
        if (x1.tok == 0x40000007) {
            return this.addX(this.eval.getBitsetProperty(ScriptVariable.bsSelect(x1), 202376194, pt2, plane2, x1.value, null, false, x1.index));
        }
        Point3f pt1 = this.ptValue(x1);
        Point4f plane1 = this.planeValue(x1);
        if (plane1 == null) {
            return this.addX(plane2 == null ? pt2.distance(pt1) : Graphics3D.distanceToPlane(plane2, pt1));
        }
        return this.addX(Graphics3D.distanceToPlane(plane1, pt2));
    }

    private Point3f ptValue(ScriptVariable x) throws ScriptEvaluator.ScriptException {
        if (this.isSyntaxCheck) {
            return new Point3f();
        }
        switch (x.tok) {
            case 7: {
                return (Point3f)x.value;
            }
            case 0x40000007: {
                return (Point3f)this.eval.getBitsetProperty(ScriptVariable.bsSelect(x), 72352010, null, null, x.value, null, false, Integer.MAX_VALUE);
            }
            case 4: 
            case 6: {
                Object pt = Escape.unescapePoint(ScriptVariable.sValue(x));
                if (!(pt instanceof Point3f)) break;
                return (Point3f)pt;
            }
        }
        float f = ScriptVariable.fValue(x);
        return new Point3f(f, f, f);
    }

    private Point4f planeValue(Token x) {
        if (this.isSyntaxCheck) {
            return new Point4f();
        }
        switch (x.tok) {
            case 8: {
                return (Point4f)x.value;
            }
            case 4: 
            case 6: {
                Object pt = Escape.unescapePoint(ScriptVariable.sValue(x));
                return pt instanceof Point4f ? (Point4f)pt : null;
            }
        }
        return null;
    }

    private boolean evaluateMeasure(ScriptVariable[] args, boolean isAngle) throws ScriptEvaluator.ScriptException {
        int nPoints = args.length;
        if (nPoints < (isAngle ? 3 : 2) || nPoints > (isAngle ? 4 : 2)) {
            return false;
        }
        if (this.isSyntaxCheck) {
            return this.addX(1.0f);
        }
        Point3f[] pts = new Point3f[nPoints];
        for (int i = 0; i < nPoints; ++i) {
            pts[i] = this.ptValue(args[i]);
        }
        switch (nPoints) {
            case 2: {
                return this.addX(pts[0].distance(pts[1]));
            }
            case 3: {
                return this.addX(Measure.computeAngle(pts[0], pts[1], pts[2], true));
            }
            case 4: {
                return this.addX(Measure.computeTorsion(pts[0], pts[1], pts[2], pts[3], true));
            }
        }
        return false;
    }

    private boolean evaluateUserFunction(String name, ScriptVariable[] args, int tok, boolean isSelector) throws ScriptEvaluator.ScriptException {
        ScriptVariable x1 = null;
        if (isSelector) {
            x1 = this.getX();
            if (x1.tok != 0x40000007) {
                return false;
            }
        }
        this.wasX = false;
        if (this.isSyntaxCheck) {
            return this.addX(1);
        }
        Vector<ScriptVariable> params = new Vector<ScriptVariable>();
        for (int i = 0; i < args.length; ++i) {
            params.addElement(args[i]);
        }
        if (isSelector) {
            return this.addX(this.eval.getBitsetProperty(ScriptVariable.bsSelect(x1), tok, null, null, x1.value, new Object[]{name, params}, false, x1.index));
        }
        ScriptVariable var = this.eval.getFunctionReturn(name, params, null);
        return var == null ? false : this.addX(var);
    }

    private boolean evaluateFind(ScriptVariable[] args) throws ScriptEvaluator.ScriptException {
        boolean isList;
        if (args.length != 1 && args.length != 2) {
            return false;
        }
        if (this.isSyntaxCheck) {
            return this.addX(1);
        }
        ScriptVariable x1 = this.getX();
        String sFind = ScriptVariable.sValue(args[0]);
        boolean isPattern = args.length == 2;
        String flags = isPattern ? ScriptVariable.sValue(args[1]) : "";
        boolean isReverse = flags.indexOf("v") >= 0;
        boolean isCaseInsensitive = flags.indexOf("i") >= 0;
        boolean asMatch = flags.indexOf("m") >= 0;
        boolean bl = isList = x1.tok == 6;
        if (isList || isPattern) {
            String[] stringArray;
            Pattern pattern = null;
            try {
                pattern = Pattern.compile(sFind, isCaseInsensitive ? 2 : 0);
            }
            catch (Exception e) {
                this.eval.evalError(e.getMessage(), null);
            }
            if (isList) {
                stringArray = (String[])x1.value;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = ScriptVariable.sValue(x1);
            }
            String[] list = stringArray;
            if (Logger.debugging) {
                Logger.debug("finding " + sFind);
            }
            BitSet bs = new BitSet();
            int ipt = 0;
            int n = 0;
            Matcher matcher = null;
            Vector<String> v = asMatch ? new Vector<String>() : null;
            for (int i = 0; i < list.length; ++i) {
                String what = list[i];
                matcher = pattern.matcher(what);
                boolean isMatch = matcher.find();
                if ((!asMatch || !isMatch) && (asMatch || isMatch != !isReverse)) continue;
                ++n;
                ipt = i;
                bs.set(i);
                if (!asMatch) continue;
                v.add(isReverse ? what.substring(0, matcher.start()) + what.substring(matcher.end()) : matcher.group());
            }
            if (!isList) {
                return asMatch ? this.addX(v.size() == 1 ? (String)v.get(0) : "") : (isReverse ? this.addX(n == 1) : (asMatch ? this.addX(n == 0 ? "" : matcher.group()) : this.addX(n == 0 ? 0 : matcher.start() + 1)));
            }
            if (n == 1) {
                return this.addX(asMatch ? (String)v.get(0) : list[ipt]);
            }
            String[] listNew = new String[n];
            if (n > 0) {
                int i = list.length;
                while (--i >= 0) {
                    if (!bs.get(i)) continue;
                    String string = asMatch ? (String)v.get(--n) : list[i];
                    listNew[n] = string;
                }
            }
            return this.addX(listNew);
        }
        return this.addX(ScriptVariable.sValue(x1).indexOf(sFind) + 1);
    }

    private boolean evaluateGetProperty(ScriptVariable[] args) {
        String propertyValue;
        String propertyName;
        if (this.isSyntaxCheck) {
            return this.addX("");
        }
        int pt = 0;
        String string = propertyName = args.length > pt ? ScriptVariable.sValue(args[pt++]).toLowerCase() : "";
        if (propertyName.equalsIgnoreCase("fileContents") && args.length > 2) {
            String s = ScriptVariable.sValue(args[1]);
            for (int i = 2; i < args.length; ++i) {
                s = s + "|" + ScriptVariable.sValue(args[i]);
            }
            propertyValue = s;
            pt = args.length;
        } else {
            Object object = args.length > pt && args[pt].tok == 0x40000007 ? ScriptVariable.bsSelect(args[pt++]) : (propertyValue = args.length > pt && args[pt].tok == 4 && PropertyManager.acceptsStringParameter(propertyName) ? args[pt++].value : "");
        }
        if (args.length == pt && propertyName.indexOf(".") >= 0 || propertyName.indexOf("[") >= 0) {
            propertyName = propertyName.replace(']', ' ').replace('[', ' ').replace('.', ' ');
            String[] names = TextFormat.split(TextFormat.trim(propertyName = TextFormat.simpleReplace(propertyName, "  ", " "), " "), " ");
            if (names.length > 0) {
                args = new ScriptVariable[names.length];
                propertyName = names[0];
                for (int i = 1; i < names.length; ++i) {
                    int n = Parser.parseInt(names[i]);
                    args[i] = n != Integer.MIN_VALUE ? new ScriptVariable(2, n) : new ScriptVariable(4, names[i]);
                }
                pt = 1;
            }
        }
        Object property = this.viewer.getProperty(null, propertyName, (Object)propertyValue);
        if (pt < args.length) {
            property = PropertyManager.extractProperty(property, args, pt);
        }
        if (property instanceof String) {
            return this.addX(property);
        }
        if (property instanceof Integer) {
            return this.addX(property);
        }
        if (property instanceof Float) {
            return this.addX(property);
        }
        if (property instanceof Point3f) {
            return this.addX(property);
        }
        if (property instanceof Vector3f) {
            return this.addX(new Point3f((Vector3f)property));
        }
        if (property instanceof Vector) {
            Vector v = (Vector)property;
            int len = v.size();
            String[] list = new String[len];
            for (int i = 0; i < len; ++i) {
                Object o = v.elementAt(i);
                list[i] = o instanceof String ? (String)o : Escape.toReadable(o);
            }
            return this.addX(list);
        }
        return this.addX(Escape.toReadable(property));
    }

    private boolean evaluatePoint(ScriptVariable[] args) {
        if (args.length != 1 && args.length != 3 && args.length != 4) {
            return false;
        }
        if (this.isSyntaxCheck) {
            return this.addX(args.length == 4 ? new Point4f() : new Point3f());
        }
        switch (args.length) {
            case 1: {
                Object pt = Escape.unescapePoint(ScriptVariable.sValue(args[0]));
                if (pt instanceof Point3f) {
                    return this.addX((Point3f)pt);
                }
                return this.addX("" + pt);
            }
            case 3: {
                return this.addX(new Point3f(ScriptVariable.fValue(args[0]), ScriptVariable.fValue(args[1]), ScriptVariable.fValue(args[2])));
            }
            case 4: {
                return this.addX(new Point4f(ScriptVariable.fValue(args[0]), ScriptVariable.fValue(args[1]), ScriptVariable.fValue(args[2]), ScriptVariable.fValue(args[3])));
            }
        }
        return false;
    }

    private boolean evaluatePlane(ScriptVariable[] args) throws ScriptEvaluator.ScriptException {
        if (args.length != 1 && args.length != 3 && args.length != 4) {
            return false;
        }
        if (this.isSyntaxCheck) {
            return this.addX(new Point4f(0.0f, 0.0f, 1.0f, 0.0f));
        }
        switch (args.length) {
            case 1: {
                Object pt = Escape.unescapePoint(ScriptVariable.sValue(args[0]));
                if (pt instanceof Point4f) {
                    return this.addX((Point4f)pt);
                }
                return this.addX("" + pt);
            }
            case 3: 
            case 4: {
                switch (args[0].tok) {
                    case 7: 
                    case 0x40000007: {
                        Point3f pt1 = this.ptValue(args[0]);
                        Point3f pt2 = this.ptValue(args[1]);
                        Point3f pt3 = this.ptValue(args[2]);
                        Vector3f vAB = new Vector3f();
                        Vector3f vAC = new Vector3f();
                        Vector3f norm = new Vector3f();
                        float nd = Graphics3D.getDirectedNormalThroughPoints(pt1, pt2, pt3, args.length == 4 ? this.ptValue(args[3]) : null, norm, vAB, vAC);
                        return this.addX(new Point4f(norm.x, norm.y, norm.z, nd));
                    }
                }
                if (args.length != 4) {
                    return false;
                }
                float x = ScriptVariable.fValue(args[0]);
                float y = ScriptVariable.fValue(args[1]);
                float z = ScriptVariable.fValue(args[2]);
                float w = ScriptVariable.fValue(args[3]);
                return this.addX(new Point4f(x, y, z, w));
            }
        }
        return false;
    }

    private boolean evaluateReplace(ScriptVariable[] args) throws ScriptEvaluator.ScriptException {
        String s;
        if (args.length != 2) {
            return false;
        }
        ScriptVariable x = this.getX();
        if (this.isSyntaxCheck) {
            return this.addX("");
        }
        String sFind = ScriptVariable.sValue(args[0]);
        String sReplace = ScriptVariable.sValue(args[1]);
        String string = s = x.tok == 6 ? null : ScriptVariable.sValue(x);
        if (s != null) {
            return this.addX(TextFormat.simpleReplace(s, sFind, sReplace));
        }
        String[] list = (String[])x.value;
        int i = list.length;
        while (--i >= 0) {
            list[i] = TextFormat.simpleReplace(list[i], sFind, sReplace);
        }
        return this.addX(list);
    }

    private boolean evaluateString(int tok, ScriptVariable[] args) throws ScriptEvaluator.ScriptException {
        String s;
        if (args.length > 1) {
            return false;
        }
        ScriptVariable x = this.getX();
        if (this.isSyntaxCheck) {
            return this.addX(ScriptVariable.sValue(x));
        }
        String string = s = tok == 202375684 && x.tok == 0x40000007 || tok == 202375686 && x.tok == 6 ? null : ScriptVariable.sValue(x);
        String sArg = args.length == 1 ? ScriptVariable.sValue(args[0]) : (tok == 202375686 ? "" : "\n");
        switch (tok) {
            case 202375684: {
                if (x.tok == 0x40000007) {
                    BitSet bsSelected = ScriptVariable.bsSelect(x);
                    sArg = "\n";
                    int modelCount = this.viewer.getModelCount();
                    s = "";
                    for (int i = 0; i < modelCount; ++i) {
                        s = s + (i == 0 ? "" : "\n");
                        BitSet bs = this.viewer.getModelAtomBitSet(i, true);
                        bs.and(bsSelected);
                        s = s + Escape.escape(bs);
                    }
                }
                return this.addX(TextFormat.split(s, sArg));
            }
            case 202375681: {
                if (s.length() > 0 && s.charAt(s.length() - 1) == '\n') {
                    s = s.substring(0, s.length() - 1);
                }
                return this.addX(TextFormat.simpleReplace(s, "\n", sArg));
            }
            case 202375686: {
                if (s != null) {
                    return this.addX(TextFormat.trim(s, sArg));
                }
                String[] list = (String[])x.value;
                int i = list.length;
                while (--i >= 0) {
                    list[i] = TextFormat.trim(list[i], sArg);
                }
                return this.addX(list);
            }
        }
        return this.addX("");
    }

    private boolean evaluateList(int tok, ScriptVariable[] args) throws ScriptEvaluator.ScriptException {
        String[] sList1;
        String sValue;
        boolean isAll;
        ScriptVariable x2;
        if (args.length != 1 && (tok != 202376193 || args.length != 0 && args.length != 2)) {
            return false;
        }
        ScriptVariable x1 = this.getX();
        ScriptVariable scriptVariable = x2 = args.length == 0 ? ScriptVariable.vAll : args[0];
        if (args.length == 2) {
            String tab = ScriptVariable.sValue(args[1]);
            String[] sList12 = x1.tok == 6 ? (String[])x1.value : TextFormat.split(ScriptVariable.sValue(x1), '\n');
            String[] sList2 = x2.tok == 6 ? (String[])x2.value : TextFormat.split(ScriptVariable.sValue(x2), '\n');
            int len = Math.max(sList12.length, sList2.length);
            String[] sList3 = new String[len];
            for (int i = 0; i < len; ++i) {
                sList3[i] = (i >= sList12.length ? "" : sList12[i]) + tab + (i >= sList2.length ? "" : sList2[i]);
            }
            return this.addX(sList3);
        }
        boolean bl = isAll = x2.tok == 0x100003;
        if (x1.tok != 6 && x1.tok != 4) {
            this.wasX = false;
            this.addOp(Token.tokenLeftParen);
            this.addX(x1);
            switch (tok) {
                case 202376193: {
                    this.addOp(Token.tokenPlus);
                    break;
                }
                case 202375685: {
                    this.addOp(Token.tokenMinus);
                    break;
                }
                case 202375683: {
                    this.addOp(Token.tokenTimes);
                    break;
                }
                case 202375680: {
                    this.addOp(Token.tokenDivide);
                }
            }
            this.addX(x2);
            return this.addOp(Token.tokenRightParen);
        }
        if (this.isSyntaxCheck) {
            return this.addX("");
        }
        boolean isScalar = x2.tok != 6 && ScriptVariable.sValue(x2).indexOf("\n") < 0;
        String string = sValue = isScalar ? ScriptVariable.sValue(x2) : "";
        float factor = sValue.indexOf("{") >= 0 ? Float.NaN : (isScalar ? ScriptVariable.fValue(x2) : 0.0f);
        String[] stringArray = sList1 = x1.value instanceof String ? TextFormat.split((String)x1.value, "\n") : (String[])x1.value;
        String[] sList2 = isScalar ? null : (x2.value instanceof String ? TextFormat.split((String)x2.value, "\n") : (String[])x2.value);
        int len = isScalar ? sList1.length : Math.min(sList1.length, sList2.length);
        float[] list1 = new float[sList1.length];
        Parser.parseFloatArray(sList1, list1);
        if (isAll) {
            float sum = 0.0f;
            int i = len;
            while (--i >= 0) {
                sum += list1[i];
            }
            return this.addX(sum);
        }
        String[] sList3 = new String[len];
        float[] list2 = new float[isScalar ? sList1.length : sList2.length];
        if (isScalar) {
            int i = len;
            while (--i >= 0) {
                list2[i] = factor;
            }
        } else {
            Parser.parseFloatArray(sList2, list2);
        }
        Token token = null;
        switch (tok) {
            case 202376193: {
                token = Token.tokenPlus;
                break;
            }
            case 202375685: {
                token = Token.tokenMinus;
                break;
            }
            case 202375683: {
                token = Token.tokenTimes;
                break;
            }
            case 202375680: {
                token = Token.tokenDivide;
            }
        }
        for (int i = 0; i < len; ++i) {
            if (Float.isNaN(list1[i])) {
                this.addX(ScriptVariable.unescapePointOrBitsetAsVariable(sList1[i]));
            } else {
                this.addX(list1[i]);
            }
            if (!Float.isNaN(list2[i])) {
                this.addX(list2[i]);
            } else if (isScalar) {
                this.addX(ScriptVariable.unescapePointOrBitsetAsVariable(sValue));
            } else {
                this.addX(ScriptVariable.unescapePointOrBitsetAsVariable(sList2[i]));
            }
            if (!this.addOp(token) || !this.operate()) {
                return false;
            }
            sList3[i] = ScriptVariable.sValue(this.xStack[this.xPt--]);
        }
        return this.addX(sList3);
    }

    private boolean evaluateArray(ScriptVariable[] args) {
        if (this.isSyntaxCheck) {
            return this.addX("");
        }
        int len = args.length;
        String[] array = new String[len];
        for (int i = 0; i < args.length; ++i) {
            array[i] = ScriptVariable.sValue(args[i]);
        }
        return this.addX(array);
    }

    private boolean evaluateMath(ScriptVariable[] args, int tok) {
        if (tok == 135272453 || tok == 135268358) {
            switch (args.length) {
                case 1: 
                case 4: {
                    break;
                }
                case 2: {
                    if (args[0].tok == 7 && (tok == 135272453 || args[1].tok != 7)) break;
                    return false;
                }
                case 3: {
                    if (tok != 135272453) {
                        return false;
                    }
                    if (args[0].tok == 8) {
                        if (args[2].tok == 7 || args[2].tok == 0x40000007) break;
                        return false;
                    }
                    for (int i = 0; i < 3; ++i) {
                        if (args[i].tok == 7 || args[i].tok == 0x40000007) continue;
                        return false;
                    }
                    break;
                }
                default: {
                    return false;
                }
            }
            if (this.isSyntaxCheck) {
                return this.addX(new Point4f(0.0f, 0.0f, 0.0f, 1.0f));
            }
            Quaternion q = null;
            Point4f p4 = null;
            switch (args.length) {
                case 2: {
                    if (args[1].tok == 7) {
                        q = Quaternion.getQuaternionFrame(new Point3f(0.0f, 0.0f, 0.0f), (Point3f)args[0].value, (Point3f)args[1].value);
                        break;
                    }
                    q = new Quaternion((Point3f)args[0].value, ScriptVariable.fValue(args[1]));
                    break;
                }
                case 3: {
                    if (args[0].tok == 8) {
                        Point3f pt = args[2].tok == 7 ? (Point3f)args[2].value : this.viewer.getAtomSetCenter((BitSet)args[2].value);
                        return this.addX(new Quaternion((Point4f)args[0].value).draw("q", ScriptVariable.sValue(args[1]), pt, 1.0f));
                    }
                    Point3f[] pts = new Point3f[3];
                    for (int i = 0; i < 3; ++i) {
                        pts[i] = args[i].tok == 7 ? (Point3f)args[i].value : this.viewer.getAtomSetCenter((BitSet)args[i].value);
                    }
                    q = Quaternion.getQuaternionFrame(pts[0], pts[1], pts[2]);
                    break;
                }
                case 4: {
                    if (tok == 135272453) {
                        p4 = new Point4f(ScriptVariable.fValue(args[1]), ScriptVariable.fValue(args[2]), ScriptVariable.fValue(args[3]), ScriptVariable.fValue(args[0]));
                        break;
                    }
                    q = new Quaternion(new Point3f(ScriptVariable.fValue(args[0]), ScriptVariable.fValue(args[1]), ScriptVariable.fValue(args[2])), ScriptVariable.fValue(args[3]));
                    break;
                }
                default: {
                    if (args[0].tok == 8) {
                        p4 = (Point4f)args[0].value;
                    } else if (args[0].tok == 0x40000007 && tok == 135272453) {
                        int i = BitSetUtil.firstSetBit((BitSet)args[0].value);
                        if (i < 0 || (q = this.viewer.getModelSet().getAtomAt(i).getQuaternion(this.viewer.getQuaternionFrame())) == null) {
                            return this.addX(0);
                        }
                    } else {
                        Object v = Escape.unescapePoint(ScriptVariable.sValue(args[0]));
                        if (!(v instanceof Point4f)) {
                            return false;
                        }
                        p4 = (Point4f)v;
                    }
                    if (tok != 135268358) break;
                    q = new Quaternion(new Point3f(p4.x, p4.y, p4.z), p4.w);
                }
            }
            if (q == null) {
                q = new Quaternion(p4);
            }
            return this.addX(q.toPoint4f());
        }
        if (args.length != 1) {
            return false;
        }
        if (this.isSyntaxCheck) {
            return this.addX(1);
        }
        double x = ScriptVariable.fValue(args[0]);
        switch (tok) {
            case 135266821: {
                return this.addX((float)Math.cos(x * Math.PI / 180.0));
            }
            case 135266820: {
                return this.addX((float)Math.sin(x * Math.PI / 180.0));
            }
            case 135266822: {
                return this.addX((float)Math.sqrt(x));
            }
        }
        return false;
    }

    private boolean evaluateRandom(ScriptVariable[] args) {
        if (args.length > 2) {
            return false;
        }
        if (this.isSyntaxCheck) {
            return this.addX(1);
        }
        float lower = args.length < 2 ? 0.0f : ScriptVariable.fValue(args[0]);
        float range = args.length == 0 ? 1.0f : ScriptVariable.fValue(args[args.length - 1]);
        return this.addX((float)(Math.random() * (double)(range -= lower)) + lower);
    }

    private boolean evaluateCross(ScriptVariable[] args) {
        if (args.length != 2) {
            return false;
        }
        ScriptVariable x1 = args[0];
        ScriptVariable x2 = args[1];
        if (x1.tok != 7 || x2.tok != 7) {
            return false;
        }
        if (this.isSyntaxCheck) {
            return this.addX(new Point3f());
        }
        Vector3f a = new Vector3f((Point3f)x1.value);
        Vector3f b = new Vector3f((Point3f)x2.value);
        a.cross(a, b);
        return this.addX(new Point3f(a));
    }

    private boolean evaluateLoad(ScriptVariable[] args, int tok) {
        if (args.length > 2 || args.length < 1) {
            return false;
        }
        if (this.isSyntaxCheck) {
            return this.addX("");
        }
        String file = ScriptVariable.sValue(args[0]);
        int nBytesMax = args.length == 2 ? ScriptVariable.iValue(args[1]) : Integer.MAX_VALUE;
        return this.addX(tok == 135271427 ? this.viewer.getFileAsString(file, nBytesMax, false) : this.viewer.getFullPath(file));
    }

    private boolean evaluateWrite(ScriptVariable[] args) throws ScriptEvaluator.ScriptException {
        if (args.length == 0) {
            return false;
        }
        if (this.isSyntaxCheck) {
            return this.addX("");
        }
        return this.addX(this.eval.write(args));
    }

    private boolean evaluateScript(ScriptVariable[] args, int tok) throws ScriptEvaluator.ScriptException {
        if (tok == 135287299 && args.length != 1 || args.length == 0 || args.length > 2) {
            return false;
        }
        if (this.isSyntaxCheck) {
            return this.addX("");
        }
        String s = ScriptVariable.sValue(args[0]);
        StringBuffer sb = new StringBuffer();
        switch (tok) {
            case 135271429: {
                String appID;
                String string = appID = args.length == 2 ? ScriptVariable.sValue(args[1]) : ".";
                if (!appID.equals(".")) {
                    sb.append(this.viewer.jsEval(appID + "\u0001" + s));
                }
                if (!appID.equals(".") && !appID.equals("*")) break;
                this.eval.runScript(s, sb);
                break;
            }
            case 135287299: {
                sb.append(this.viewer.jsEval(s));
            }
        }
        s = sb.toString();
        float f = Parser.parseFloatStrict(s);
        return Float.isNaN(f) ? this.addX(s) : (s.indexOf(".") >= 0 ? this.addX(f) : this.addX(Parser.parseInt(s)));
    }

    private boolean evaluateData(ScriptVariable[] args) {
        String type;
        if (args.length != 1 && args.length != 2 && args.length != 4) {
            return false;
        }
        if (this.isSyntaxCheck) {
            return this.addX("");
        }
        String selected = ScriptVariable.sValue(args[0]);
        String string = type = args.length == 2 ? ScriptVariable.sValue(args[1]) : "";
        if (args.length == 4) {
            int iField = ScriptVariable.iValue(args[1]);
            int nBytes = ScriptVariable.iValue(args[2]);
            int firstLine = ScriptVariable.iValue(args[3]);
            float[] f = Parser.extractData(selected, iField, nBytes, firstLine);
            return this.addX(Escape.escape(f, false));
        }
        if (selected.indexOf("data2d_") == 0) {
            float[][] f1 = this.viewer.getDataFloat2D(selected);
            if (f1 == null) {
                return this.addX("");
            }
            if (args.length == 2 && args[1].tok == 2) {
                int pt = args[1].intValue;
                if (pt < 0) {
                    pt += f1.length;
                }
                if (pt >= 0 && pt < f1.length) {
                    return this.addX(Escape.escape(f1[pt], false));
                }
                return this.addX("");
            }
            return this.addX(Escape.escape(f1, false));
        }
        if (selected.indexOf("property_") == 0) {
            float[] f2;
            float[] f1 = this.viewer.getDataFloat(selected);
            if (f1 == null) {
                return this.addX("");
            }
            float[] fArray = f2 = type.indexOf("property_") == 0 ? this.viewer.getDataFloat(type) : null;
            if (f2 != null) {
                f1 = (float[])f1.clone();
                int i = Math.min(f1.length, f2.length);
                while (--i >= 0) {
                    int n = i;
                    f1[n] = f1[n] + f2[i];
                }
            }
            return this.addX(Escape.escape(f1, false));
        }
        if (args.length == 1) {
            Object[] data = this.viewer.getData(selected);
            return this.addX(data == null ? "" : "" + data[1]);
        }
        return this.addX(this.viewer.getData(selected, type));
    }

    private boolean evaluateLabel(int intValue, ScriptVariable[] args) throws ScriptEvaluator.ScriptException {
        ScriptVariable x1;
        ScriptVariable scriptVariable = x1 = args.length < 2 ? this.getX() : null;
        if (this.isSyntaxCheck) {
            return this.addX("");
        }
        String format = args.length == 0 ? "%U" : ScriptVariable.sValue(args[0]);
        boolean asArray = Token.tokAttr(intValue, 224);
        if (x1 == null) {
            return this.addX(ScriptVariable.sprintf(args));
        }
        if (x1.tok == 0x40000007) {
            return this.addX(this.eval.getBitsetIdent(ScriptVariable.bsSelect(x1), format, x1.value, true, x1.index, asArray));
        }
        return this.addX(ScriptVariable.sprintf(TextFormat.formatCheck(format), x1));
    }

    private boolean evaluateWithin(ScriptVariable[] args) {
        boolean isDistance;
        if (args.length < 1) {
            return false;
        }
        int i = args.length;
        Object withinSpec = args[0].value;
        int tok = args[0].tok;
        String withinStr = "" + withinSpec;
        BitSet bs = new BitSet();
        float distance = 0.0f;
        boolean isSequence = false;
        boolean isWithinModelSet = false;
        boolean bl = isDistance = tok == 3 || tok == 2;
        if (withinStr.equals("branch")) {
            if (i != 3 || !(args[1].value instanceof BitSet) || !(args[2].value instanceof BitSet)) {
                return false;
            }
            return this.addX(this.viewer.getBranchBitSet(BitSetUtil.firstSetBit((BitSet)args[2].value), BitSetUtil.firstSetBit((BitSet)args[1].value)));
        }
        if (withinSpec instanceof String) {
            isSequence = !Parser.isOneOf(withinStr.toLowerCase(), "atomname;atomtype;element;site;group;chain;structure;molecule;model;boundbox");
        } else if (isDistance) {
            distance = ScriptVariable.fValue(args[0]);
            if (i < 2) {
                return false;
            }
            if (args[1].tok == 0x10000D || args[1].tok == 0x10000C) {
                isWithinModelSet = ScriptVariable.bValue(args[1]);
                i = 0;
            }
        } else {
            return false;
        }
        switch (i) {
            case 1: {
                return !withinStr.equalsIgnoreCase("boundbox") ? false : this.addX(this.isSyntaxCheck ? bs : this.viewer.getAtomBits(605556745, null));
            }
            case 2: {
                if (withinStr.equalsIgnoreCase("atomName")) {
                    return this.addX(this.isSyntaxCheck ? bs : this.viewer.getAtomBits(13631746, ScriptVariable.sValue(args[1])));
                }
                if (!withinStr.equalsIgnoreCase("atomType")) break;
                return this.addX(this.isSyntaxCheck ? bs : this.viewer.getAtomBits(0xD00101, ScriptVariable.sValue(args[1])));
            }
            case 3: {
                withinStr = ScriptVariable.sValue(args[1]);
                if (Parser.isOneOf(withinStr.toLowerCase(), "on;off;plane;hkl;coord")) break;
                return false;
            }
        }
        Point3f pt = null;
        Point4f plane = null;
        i = args.length - 1;
        if (args[i].value instanceof Point4f) {
            plane = (Point4f)args[i].value;
        } else if (args[i].value instanceof Point3f) {
            pt = (Point3f)args[i].value;
        }
        if (i > 0 && plane == null && pt == null && !(args[i].value instanceof BitSet)) {
            return false;
        }
        if (this.isSyntaxCheck) {
            return this.addX(bs);
        }
        if (plane != null) {
            return this.addX(this.viewer.getAtomsWithin(distance, plane));
        }
        if (pt != null) {
            return this.addX(this.viewer.getAtomsWithin(distance, pt));
        }
        bs = ScriptVariable.bsSelect(args[i]);
        if (isDistance) {
            return this.addX(this.viewer.getAtomsWithin(distance, bs, isWithinModelSet));
        }
        if (isSequence) {
            return this.addX(this.viewer.getSequenceBits(withinStr, bs));
        }
        return this.addX(this.viewer.getAtomBits(Token.getTokenFromName((String)withinStr).tok, bs));
    }

    private boolean evaluateConnected(ScriptVariable[] args) {
        float min = -2.1474836E9f;
        float max = 2.1474836E9f;
        float fmin = 0.0f;
        float fmax = Float.MAX_VALUE;
        short order = 16383;
        BitSet atoms1 = null;
        BitSet atoms2 = null;
        boolean haveDecimal = false;
        boolean isBonds = false;
        block5: for (int i = 0; i < args.length; ++i) {
            ScriptVariable var = args[i];
            switch (var.tok) {
                case 0x40000007: {
                    isBonds = var.value instanceof Bond.BondSet;
                    if (isBonds && atoms1 != null) {
                        return false;
                    }
                    if (atoms1 == null) {
                        atoms1 = ScriptVariable.bsSelect(var);
                        continue block5;
                    }
                    if (atoms2 == null) {
                        atoms2 = ScriptVariable.bsSelect(var);
                        continue block5;
                    }
                    return false;
                }
                case 4: {
                    String type = ScriptVariable.sValue(var);
                    order = type.equalsIgnoreCase("hbond") ? (short)30720 : (short)JmolConstants.getBondOrderFromString(type);
                    if (order != Short.MAX_VALUE) continue block5;
                    return false;
                }
                case 3: {
                    haveDecimal = true;
                }
                default: {
                    int n = ScriptVariable.iValue(var);
                    float f = ScriptVariable.fValue(var);
                    if (max != 2.1474836E9f) {
                        return false;
                    }
                    if (min == -2.1474836E9f) {
                        min = Math.max(n, 1);
                        fmin = f;
                        continue block5;
                    }
                    max = n;
                    fmax = f;
                }
            }
        }
        if (min == -2.1474836E9f) {
            min = 1.0f;
            max = 100.0f;
            fmin = 0.1f;
            fmax = 1.0E8f;
        } else if (max == 2.1474836E9f) {
            max = min;
            fmax = fmin;
            fmin = 0.1f;
        }
        if (atoms1 == null) {
            atoms1 = this.viewer.getModelAtomBitSet(-1, true);
        }
        if (haveDecimal && atoms2 == null) {
            atoms2 = atoms1;
        }
        if (atoms2 != null) {
            BitSet bsBonds = new BitSet();
            if (this.isSyntaxCheck) {
                return this.addX(new ScriptVariable(0x40000007, new Bond.BondSet(bsBonds)));
            }
            this.viewer.makeConnections(fmin, fmax, order, 5, atoms1, atoms2, bsBonds, isBonds);
            return this.addX(new ScriptVariable(0x40000007, new Bond.BondSet(bsBonds, this.viewer.getAtomIndices(this.viewer.getAtomBits(605028354, bsBonds)))));
        }
        if (this.isSyntaxCheck) {
            return this.addX(atoms1);
        }
        return this.addX(this.viewer.getAtomsConnected(min, max, order, atoms1));
    }

    private boolean evaluateSubstructure(ScriptVariable[] args) throws ScriptEvaluator.ScriptException {
        String smiles;
        if (args.length != 1) {
            return false;
        }
        BitSet bs = new BitSet();
        String string = smiles = this.isSyntaxCheck ? "" : ScriptVariable.sValue(args[0]);
        if (smiles.length() > 0) {
            try {
                bs = this.viewer.getSmilesMatcher().getSubstructureSet(smiles);
            }
            catch (Exception e) {
                this.eval.evalError(e.getMessage(), null);
            }
        }
        return this.addX(bs);
    }

    private boolean operate() throws ScriptEvaluator.ScriptException {
        Token op = this.oStack[this.oPt--];
        if (this.logMessages) {
            this.dumpStacks("operate: " + op);
        }
        if (this.oPt < 0 && op.tok == 269484420 && this.isArrayItem) {
            return this.xPt == 2;
        }
        ScriptVariable x2 = this.getX();
        if (x2 == Token.tokenArraySelector) {
            return false;
        }
        if (x2.tok == 6) {
            x2 = ScriptVariable.selectItem(x2);
        }
        if (op.tok == 0x101000B1 || op.tok == 269484210) {
            if (!this.isSyntaxCheck && !x2.increment(this.incrementX)) {
                return false;
            }
            this.wasX = true;
            this.putX(x2);
            return true;
        }
        if (op.tok == 0x10100070) {
            return this.isSyntaxCheck ? this.addX(true) : (x2.tok == 8 ? this.addX(new Quaternion((Point4f)x2.value).inv().toPoint4f()) : (x2.tok == 0x40000007 ? this.addX(BitSetUtil.copyInvert(ScriptVariable.bsSelect(x2), x2.value instanceof Bond.BondSet ? this.viewer.getBondCount() : this.viewer.getAtomCount())) : this.addX(!ScriptVariable.bValue(x2))));
        }
        int iv = op.intValue & 0xFFFFFF1F;
        if (op.tok == 0x101000C1) {
            switch (iv) {
                case 68157443: {
                    if (x2.value instanceof Bond.BondSet) break;
                    return this.addX(ScriptVariable.sizeOf(x2));
                }
                case 68157446: {
                    return this.addX(ScriptVariable.sizeOf(x2));
                }
                case 68157448: {
                    return this.addX(ScriptVariable.typeOf(x2));
                }
                case 0x4100004: {
                    String s = x2.tok == 4 ? (String)x2.value : ScriptVariable.sValue(x2);
                    s = TextFormat.simpleReplace(s, "\n\r", "\n").replace('\r', '\n');
                    return this.addX(TextFormat.split(s, '\n'));
                }
                case 558895366: {
                    switch (x2.tok) {
                        case 4: 
                        case 6: {
                            Point3f pt = new Point3f();
                            return this.addX(Graphics3D.colorPointFromString(ScriptVariable.sValue(x2), pt));
                        }
                        case 2: 
                        case 3: {
                            return this.addX(this.viewer.getColorPointForPropertyValue(ScriptVariable.fValue(x2)));
                        }
                        case 7: {
                            return this.addX(Escape.escapeColor(ScriptEvaluator.colorPtToInt((Point3f)x2.value)));
                        }
                    }
                    break;
                }
                case 605556745: {
                    return this.isSyntaxCheck ? this.addX("x") : this.evaluateBoundBox(x2);
                }
            }
            if (this.isSyntaxCheck) {
                return this.addX(ScriptVariable.sValue(x2));
            }
            if (x2.tok == 4) {
                Object v = ScriptVariable.unescapePointOrBitsetAsVariable(ScriptVariable.sValue(x2));
                if (!(v instanceof ScriptVariable)) {
                    return false;
                }
                x2 = (ScriptVariable)v;
            }
            if (op.tok == x2.tok) {
                x2 = this.getX();
            }
            return this.evaluatePointOrBitsetOperation(op, x2);
        }
        ScriptVariable x1 = this.getX();
        if (this.isSyntaxCheck) {
            return this.addX(new ScriptVariable(x1));
        }
        switch (op.tok) {
            case 0x10100060: {
                if (x1.tok == 0x40000007 && x2.tok == 0x40000007) {
                    BitSet bs = BitSetUtil.copy(ScriptVariable.bsSelect(x1));
                    bs.and(ScriptVariable.bsSelect(x2));
                    return this.addX(bs);
                }
                return this.addX(ScriptVariable.bValue(x1) && ScriptVariable.bValue(x2));
            }
            case 0x10100050: {
                if (x1.tok == 0x40000007 && x2.tok == 0x40000007) {
                    BitSet bs = BitSetUtil.copy(ScriptVariable.bsSelect(x1));
                    bs.or(ScriptVariable.bsSelect(x2));
                    return this.addX(bs);
                }
                return this.addX(ScriptVariable.bValue(x1) || ScriptVariable.bValue(x2));
            }
            case 0x10100051: {
                if (x1.tok == 0x40000007 && x2.tok == 0x40000007) {
                    BitSet bs = BitSetUtil.copy(ScriptVariable.bsSelect(x1));
                    bs.xor(ScriptVariable.bsSelect(x2));
                    return this.addX(bs);
                }
                boolean a = ScriptVariable.bValue(x1);
                boolean b = ScriptVariable.bValue(x2);
                return this.addX(a && !b || b && !a);
            }
            case 269484114: {
                if (x1.tok != 0x40000007 || x2.tok != 0x40000007) {
                    return false;
                }
                return this.addX(BitSetUtil.toggleInPlace(BitSetUtil.copy(ScriptVariable.bsSelect(x1)), ScriptVariable.bsSelect(x2), this.viewer.getAtomCount()));
            }
            case 269484418: {
                return this.addX(ScriptVariable.fValue(x1) <= ScriptVariable.fValue(x2));
            }
            case 0x10100181: {
                return this.addX(ScriptVariable.fValue(x1) >= ScriptVariable.fValue(x2));
            }
            case 0x10100180: {
                return this.addX(ScriptVariable.fValue(x1) > ScriptVariable.fValue(x2));
            }
            case 269484419: {
                return this.addX(ScriptVariable.fValue(x1) < ScriptVariable.fValue(x2));
            }
            case 269484420: {
                if (x1.tok == 4 && x2.tok == 4) {
                    return this.addX(ScriptVariable.sValue(x1).equalsIgnoreCase(ScriptVariable.sValue(x2)));
                }
                if (x1.tok == 7 && x2.tok == 7) {
                    return this.addX((double)((Point3f)x1.value).distance((Point3f)x2.value) < 1.0E-6);
                }
                if (x1.tok == 8 && x2.tok == 8) {
                    return this.addX((double)((Point4f)x1.value).distance((Point4f)x2.value) < 1.0E-6);
                }
                return this.addX((double)Math.abs(ScriptVariable.fValue(x1) - ScriptVariable.fValue(x2)) < 1.0E-6);
            }
            case 269484421: {
                if (x1.tok == 4 && x2.tok == 4) {
                    return this.addX(!ScriptVariable.sValue(x1).equalsIgnoreCase(ScriptVariable.sValue(x2)));
                }
                if (x1.tok == 7 && x2.tok == 7) {
                    return this.addX((double)((Point3f)x1.value).distance((Point3f)x2.value) >= 1.0E-6);
                }
                if (x1.tok == 8 && x2.tok == 8) {
                    return this.addX((double)((Point4f)x1.value).distance((Point4f)x2.value) >= 1.0E-6);
                }
                float f1 = ScriptVariable.fValue(x1);
                float f2 = ScriptVariable.fValue(x2);
                return this.addX(Float.isNaN(f1) || Float.isNaN(f2) || (double)Math.abs(f1 - f2) >= 1.0E-6);
            }
            case 0x10100091: {
                String s;
                if (x1.tok == 6 || x2.tok == 6) {
                    return this.addX(ScriptVariable.concatList(x1, x2));
                }
                if (x1.tok == 2 && (x2.tok == 4 ? (s = ScriptVariable.sValue(x2).trim()).indexOf(".") < 0 && s.indexOf("+") <= 0 && s.lastIndexOf("-") <= 0 : x2.tok != 3)) {
                    return this.addX(x1.intValue + ScriptVariable.iValue(x2));
                }
                switch (x1.tok) {
                    default: {
                        return this.addX(ScriptVariable.fValue(x1) + ScriptVariable.fValue(x2));
                    }
                    case 4: {
                        return this.addX(new ScriptVariable(4, ScriptVariable.sValue(x1) + ScriptVariable.sValue(x2)));
                    }
                    case 8: {
                        Quaternion q1 = new Quaternion((Point4f)x1.value);
                        switch (x2.tok) {
                            default: {
                                return this.addX(q1.add(ScriptVariable.fValue(x2)).toPoint4f());
                            }
                            case 8: 
                        }
                        return this.addX(q1.mul(new Quaternion((Point4f)x2.value)).toPoint4f());
                    }
                    case 7: 
                }
                Point3f pt = new Point3f((Point3f)x1.value);
                switch (x2.tok) {
                    case 7: {
                        pt.add((Point3f)x2.value);
                        return this.addX(pt);
                    }
                    case 8: {
                        Point4f pt4 = (Point4f)x2.value;
                        pt.add(new Point3f(pt4.x, pt4.y, pt4.z));
                        return this.addX(pt);
                    }
                }
                float f = ScriptVariable.fValue(x2);
                return this.addX(new Point3f(pt.x + f, pt.y + f, pt.z + f));
            }
            case 0x10100090: {
                String s;
                if (x1.tok == 2 && (x2.tok == 4 ? (s = ScriptVariable.sValue(x2).trim()).indexOf(".") < 0 && s.indexOf("+") <= 0 && s.lastIndexOf("-") <= 0 : x2.tok != 3)) {
                    return this.addX(x1.intValue - ScriptVariable.iValue(x2));
                }
                if (x1.tok == 4 && x2.tok == 2 && (s = ScriptVariable.sValue(x1).trim()).indexOf(".") < 0 && s.indexOf("+") <= 0 && s.lastIndexOf("-") <= 0) {
                    return this.addX(ScriptVariable.iValue(x1) - x2.intValue);
                }
                switch (x1.tok) {
                    default: {
                        return this.addX(ScriptVariable.fValue(x1) - ScriptVariable.fValue(x2));
                    }
                    case 7: {
                        Point3f pt = new Point3f((Point3f)x1.value);
                        switch (x2.tok) {
                            default: {
                                float f = ScriptVariable.fValue(x2);
                                return this.addX(new Point3f(pt.x - f, pt.y - f, pt.z - f));
                            }
                            case 7: {
                                pt.sub((Point3f)x2.value);
                                return this.addX(pt);
                            }
                            case 8: 
                        }
                        Point4f pt4 = (Point4f)x2.value;
                        pt.sub(new Point3f(pt4.x, pt4.y, pt4.z));
                        return this.addX(pt);
                    }
                    case 8: 
                }
                Quaternion q1 = new Quaternion((Point4f)x1.value);
                switch (x2.tok) {
                    default: {
                        return this.addX(q1.add(-ScriptVariable.fValue(x2)).toPoint4f());
                    }
                    case 8: 
                }
                Quaternion q2 = new Quaternion((Point4f)x2.value);
                return this.addX(q2.mul(q1.inv()).toPoint4f());
            }
            case 0x101000B0: {
                switch (x2.tok) {
                    default: {
                        return this.addX(-ScriptVariable.fValue(x2));
                    }
                    case 2: {
                        return this.addX(-ScriptVariable.iValue(x2));
                    }
                    case 7: {
                        Point3f pt = new Point3f((Point3f)x2.value);
                        pt.scale(-1.0f);
                        return this.addX(pt);
                    }
                    case 8: {
                        Point4f plane = new Point4f((Point4f)x2.value);
                        plane.scale(-1.0f);
                        return this.addX(plane);
                    }
                    case 0x40000007: 
                }
                return this.addX(BitSetUtil.copyInvert(ScriptVariable.bsSelect(x2), x2.value instanceof Bond.BondSet ? this.viewer.getBondCount() : this.viewer.getAtomCount()));
            }
            case 0x101000A1: {
                if (x1.tok == 2 && x2.tok != 3) {
                    return this.addX(x1.intValue * ScriptVariable.iValue(x2));
                }
                switch (x1.tok) {
                    default: {
                        return this.addX(ScriptVariable.fValue(x1) * ScriptVariable.fValue(x2));
                    }
                    case 7: {
                        Point3f pt = new Point3f((Point3f)x1.value);
                        switch (x2.tok) {
                            case 7: {
                                Point3f pt2 = (Point3f)x2.value;
                                return this.addX(pt.x * pt2.x + pt.y * pt2.y + pt.z * pt2.z);
                            }
                        }
                        float f = ScriptVariable.fValue(x2);
                        return this.addX(new Point3f(pt.x * f, pt.y * f, pt.z * f));
                    }
                    case 8: 
                }
                if (x2.tok == 8) {
                    Quaternion q1 = new Quaternion((Point4f)x1.value);
                    Quaternion q = new Quaternion((Point4f)x2.value);
                    q = q1.mul(q);
                    return this.addX(new Point4f(q.q1, q.q2, q.q3, q.q0));
                }
                return this.addX(new Quaternion((Point4f)x1.value).mul(ScriptVariable.fValue(x2)).toPoint4f());
            }
            case 269484194: {
                String s = null;
                int n = ScriptVariable.iValue(x2);
                switch (x1.tok) {
                    default: {
                        if (n == 0) {
                            return this.addX(0);
                        }
                        return this.addX(ScriptVariable.iValue(x1) % n);
                    }
                    case 3: {
                        float f = ScriptVariable.fValue(x1);
                        if (n == 0) {
                            return this.addX((int)(f + 0.5f * (float)(f < 0.0f ? -1 : 1)));
                        }
                        s = TextFormat.formatDecimal(f, n);
                        return this.addX(s);
                    }
                    case 4: {
                        s = (String)x1.value;
                        if (n == 0) {
                            return this.addX(TextFormat.trim(s, "\n\t "));
                        }
                        if (n > 0) {
                            return this.addX(TextFormat.format(s, n, n, false, false));
                        }
                        return this.addX(TextFormat.format(s, -n, n, true, false));
                    }
                    case 6: {
                        String[] list = (String[])x1.value;
                        String[] listout = new String[list.length];
                        for (int i = 0; i < list.length; ++i) {
                            listout[i] = n == 0 ? list[i].trim() : (n > 0 ? TextFormat.format(list[i], n, n, true, false) : TextFormat.format(s, -n, n, false, false));
                        }
                        return this.addX(listout);
                    }
                    case 7: {
                        Point3f pt = new Point3f((Point3f)x1.value);
                        this.viewer.toUnitCell(pt, new Point3f(n, n, n));
                        return this.addX(pt);
                    }
                    case 8: {
                        Point4f q = (Point4f)x1.value;
                        if (x2.tok == 7) {
                            return this.addX(new Quaternion(q).transform((Point3f)x2.value));
                        }
                        if (x2.tok == 8) {
                            Point4f v4 = new Point4f((Point4f)x2.value);
                            new Quaternion(q).getThetaDirected(v4);
                            return this.addX(v4);
                        }
                        switch (n) {
                            case 0: {
                                return this.addX(q.w);
                            }
                            case 1: {
                                return this.addX(q.x);
                            }
                            case 2: {
                                return this.addX(q.y);
                            }
                            case 3: {
                                return this.addX(q.z);
                            }
                            case 4: {
                                return this.addX(new Quaternion(q).getNormal());
                            }
                            case -1: {
                                return this.addX(new Quaternion(q).getVector(-1));
                            }
                            case -2: {
                                return this.addX(new Quaternion(q).getTheta());
                            }
                            case -3: {
                                return this.addX(new Quaternion(q).getVector(0));
                            }
                            case -4: {
                                return this.addX(new Quaternion(q).getVector(1));
                            }
                            case -5: {
                                return this.addX(new Quaternion(q).getVector(2));
                            }
                        }
                        return this.addX(q);
                    }
                    case 0x40000007: 
                }
                return this.addX(ScriptVariable.bsSelect(x1, n));
            }
            case 0x101000A0: {
                if (x1.tok == 2 && x2.tok == 2 && x2.intValue != 0) {
                    return this.addX(x1.intValue / x2.intValue);
                }
                float f2 = ScriptVariable.fValue(x2);
                switch (x1.tok) {
                    default: {
                        float f1 = ScriptVariable.fValue(x1);
                        if (f2 == 0.0f) {
                            return this.addX(f1 == 0.0f ? 0.0f : (f1 < 0.0f ? Float.POSITIVE_INFINITY : Float.POSITIVE_INFINITY));
                        }
                        return this.addX(f1 / f2);
                    }
                    case 7: {
                        Point3f pt = new Point3f((Point3f)x1.value);
                        if (f2 == 0.0f) {
                            return this.addX(new Point3f(Float.NaN, Float.NaN, Float.NaN));
                        }
                        return this.addX(new Point3f(pt.x / f2, pt.y / f2, pt.z / f2));
                    }
                    case 8: 
                }
                if (f2 == 0.0f) {
                    return this.addX(new Point4f(Float.NaN, Float.NaN, Float.NaN, Float.NaN));
                }
                if (x2.tok == 8) {
                    return this.addX(new Quaternion((Point4f)x1.value).div(new Quaternion((Point4f)x2.value)).toPoint4f());
                }
                return this.addX(new Quaternion((Point4f)x1.value).mul(1.0f / f2).toPoint4f());
            }
            case 269484195: {
                float f = ScriptVariable.fValue(x2);
                switch (x1.tok) {
                    default: {
                        return this.addX(f == 0.0f ? 0 : (int)(ScriptVariable.fValue(x1) / ScriptVariable.fValue(x2)));
                    }
                    case 8: 
                }
                if (f == 0.0f) {
                    return this.addX(new Point4f(Float.NaN, Float.NaN, Float.NaN, Float.NaN));
                }
                if (x2.tok == 8) {
                    return this.addX(new Quaternion((Point4f)x1.value).divLeft(new Quaternion((Point4f)x2.value)).toPoint4f());
                }
                return this.addX(new Quaternion((Point4f)x1.value).mul(1.0f / f).toPoint4f());
            }
        }
        return true;
    }

    private boolean evaluateBoundBox(ScriptVariable x2) {
        if (x2.tok != 0x40000007) {
            return false;
        }
        if (this.isSyntaxCheck) {
            return this.addX("");
        }
        BoxInfo b = this.viewer.getBoxInfo(ScriptVariable.bsSelect(x2));
        Point3f[] pts = b.getBoundBoxPoints();
        return this.addX(new String[]{Escape.escape(pts[0]), Escape.escape(pts[1]), Escape.escape(pts[2]), Escape.escape(pts[3])});
    }

    private boolean evaluatePointOrBitsetOperation(Token op, ScriptVariable x2) throws ScriptEvaluator.ScriptException {
        switch (x2.tok) {
            case 6: {
                String[] list = (String[])x2.value;
                if (op.intValue == 32 || op.intValue == 64 || op.intValue == 96 || op.intValue == 128) {
                    return this.addX(ArrayUtil.getMinMax(list, op.intValue));
                }
                if (op.intValue == 68157447 || op.intValue == 68157445) {
                    return this.addX(ArrayUtil.sortOrReverse(x2.value, op.intValue, true));
                }
                String[] list2 = new String[list.length];
                for (int i = 0; i < list.length; ++i) {
                    Object v = ScriptVariable.unescapePointOrBitsetAsVariable(list[i]);
                    if (!(v instanceof ScriptVariable) || !this.evaluatePointOrBitsetOperation(op, (ScriptVariable)v)) {
                        return false;
                    }
                    list2[i] = ScriptVariable.sValue(this.xStack[this.xPt--]);
                }
                return this.addX(list2);
            }
            case 7: {
                switch (op.intValue) {
                    case 38797571: {
                        return this.addX(((Point3f)x2.value).x);
                    }
                    case 38797572: {
                        return this.addX(((Point3f)x2.value).y);
                    }
                    case 38797573: {
                        return this.addX(((Point3f)x2.value).z);
                    }
                    case 72352010: {
                        Point3f pt = new Point3f((Point3f)x2.value);
                        this.viewer.toCartesian(pt);
                        return this.addX(pt);
                    }
                    case 38797574: 
                    case 38797575: 
                    case 38797576: 
                    case 72352011: {
                        Point3f ptf = new Point3f((Point3f)x2.value);
                        this.viewer.toFractional(ptf);
                        return op.intValue == 72352011 ? this.addX(ptf) : this.addX(op.intValue == 38797574 ? ptf.x : (op.intValue == 38797575 ? ptf.y : ptf.z));
                    }
                    case 38797330: 
                    case 38797331: 
                    case 38797332: 
                    case 72351756: {
                        Point3f ptu = new Point3f((Point3f)x2.value);
                        this.viewer.toUnitCell(ptu, null);
                        this.viewer.toFractional(ptu);
                        return op.intValue == 72351756 ? this.addX(ptu) : this.addX(op.intValue == 38797574 ? ptu.x : (op.intValue == 38797575 ? ptu.y : ptu.z));
                    }
                }
                break;
            }
            case 8: {
                switch (op.intValue) {
                    case 38797571: {
                        return this.addX(((Point4f)x2.value).x);
                    }
                    case 38797572: {
                        return this.addX(((Point4f)x2.value).y);
                    }
                    case 38797573: {
                        return this.addX(((Point4f)x2.value).z);
                    }
                    case 0x40000043: {
                        return this.addX(((Point4f)x2.value).w);
                    }
                }
                break;
            }
            case 0x40000007: {
                if (op.intValue == 605028354 && x2.value instanceof Bond.BondSet) {
                    return this.addX(x2);
                }
                BitSet bs = ScriptVariable.bsSelect(x2);
                Object val = this.eval.getBitsetProperty(bs, op.intValue, null, null, x2.value, op.value, false, x2.index);
                if (op.intValue == 605028354) {
                    val = new ScriptVariable(0x40000007, new Bond.BondSet((BitSet)val, this.viewer.getAtomIndices(bs)));
                }
                return this.addX(val);
            }
        }
        return false;
    }
}

