/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import java.util.Hashtable;
import org.jmol.api.JmolSelectionListener;
import org.jmol.i18n.GT;
import org.jmol.modelset.ModelSet;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.viewer.StateManager;
import org.jmol.viewer.Viewer;

class SelectionManager {
    private Viewer viewer;
    private JmolSelectionListener[] listeners = new JmolSelectionListener[0];
    final BitSet bsSelection = new BitSet();
    BitSet bsSubset;
    BitSet bsDeleted;
    private static final int TRUE = 1;
    private static final int FALSE = 0;
    private static final int UNKNOWN = -1;
    private int empty = 1;
    private boolean hideNotSelected;
    private final BitSet bsHidden = new BitSet();

    SelectionManager(Viewer viewer) {
        this.viewer = viewer;
    }

    void clear() {
        this.clearSelection(true);
        this.hide(null, true);
        this.setSelectionSubset(null);
        this.bsDeleted = null;
    }

    void hide(BitSet bs, boolean isQuiet) {
        ModelSet modelSet;
        BitSetUtil.clear(this.bsHidden);
        if (bs != null) {
            this.bsHidden.or(bs);
        }
        if ((modelSet = this.viewer.getModelSet()) != null) {
            modelSet.setBsHidden(this.bsHidden);
        }
        if (!isQuiet) {
            this.viewer.reportSelection(GT._("{0} atoms hidden", "" + BitSetUtil.cardinalityOf(this.bsHidden)));
        }
    }

    void display(BitSet bsAll, BitSet bs, boolean isQuiet) {
        if (bs == null) {
            BitSetUtil.clear(this.bsHidden);
        } else {
            this.bsHidden.or(bsAll);
            BitSetUtil.andNot(this.bsHidden, bs);
        }
        BitSetUtil.andNot(this.bsHidden, this.bsDeleted);
        ModelSet modelSet = this.viewer.getModelSet();
        if (modelSet != null) {
            modelSet.setBsHidden(this.bsHidden);
        }
        if (!isQuiet) {
            this.viewer.reportSelection(GT._("{0} atoms hidden", "" + BitSetUtil.cardinalityOf(this.bsHidden)));
        }
    }

    BitSet getHiddenSet() {
        return this.bsHidden;
    }

    boolean getHideNotSelected() {
        return this.hideNotSelected;
    }

    void setHideNotSelected(boolean TF) {
        this.hideNotSelected = TF;
        if (TF) {
            this.selectionChanged(false);
        }
    }

    boolean isSelected(int atomIndex) {
        return atomIndex >= 0 && this.bsSelection.get(atomIndex);
    }

    void select(BitSet bs, boolean isQuiet) {
        if (bs == null) {
            this.selectAll(true);
            if (!this.viewer.getRasmolHydrogenSetting()) {
                this.excludeSelectionSet(this.viewer.getAtomBits(540016644, null));
            }
            if (!this.viewer.getRasmolHeteroSetting()) {
                this.excludeSelectionSet(this.viewer.getAtomBits(0x20300003, null));
            }
            this.selectionChanged(false);
        } else {
            this.setSelectionSet(bs);
        }
        int n = this.getSelectionCount();
        if (this.viewer.getMessageStyleChime()) {
            this.viewer.reportSelection((n == 0 ? "No atoms" : (n == 1 ? "1 atom" : n + " atoms")) + " selected!");
        } else if (!isQuiet) {
            this.viewer.reportSelection(GT._("{0} atoms selected", n));
        }
    }

    void selectAll(boolean isQuiet) {
        int count = this.viewer.getAtomCount();
        this.empty = count == 0 ? 1 : 0;
        int i = count;
        while (--i >= 0) {
            this.bsSelection.set(i);
        }
        BitSetUtil.andNot(this.bsSelection, this.bsDeleted);
        this.selectionChanged(isQuiet);
    }

    void clearSelection(boolean isQuiet) {
        this.hideNotSelected = false;
        BitSetUtil.clear(this.bsSelection);
        this.empty = 1;
        this.selectionChanged(isQuiet);
    }

    void setSelectionSet(BitSet set) {
        BitSetUtil.clear(this.bsSelection);
        if (set != null) {
            this.bsSelection.or(set);
        }
        this.empty = -1;
        this.selectionChanged(false);
    }

    void setSelectionSubset(BitSet bs) {
        this.bsSubset = bs;
    }

    boolean isInSelectionSubset(int atomIndex) {
        return atomIndex < 0 || this.bsSubset == null || this.bsSubset.get(atomIndex);
    }

    void invertSelection() {
        this.empty = 1;
        int i = this.viewer.getAtomCount();
        while (--i >= 0) {
            if (this.bsSelection.get(i)) {
                this.bsSelection.clear(i);
                continue;
            }
            this.bsSelection.set(i);
            this.empty = 0;
        }
        this.selectionChanged(false);
    }

    private void excludeSelectionSet(BitSet setExclude) {
        if (setExclude == null || this.empty == 1) {
            return;
        }
        int i = this.viewer.getAtomCount();
        while (--i >= 0) {
            if (!setExclude.get(i)) continue;
            this.bsSelection.clear(i);
        }
        this.empty = -1;
    }

    int getSelectionCount() {
        if (this.empty == 1) {
            return 0;
        }
        int count = 0;
        this.empty = 1;
        int i = this.viewer.getAtomCount();
        while (--i >= 0) {
            if (!this.bsSelection.get(i) || this.bsSubset != null && !this.bsSubset.get(i)) continue;
            ++count;
        }
        if (count > 0) {
            this.empty = 0;
        }
        return count;
    }

    void addListener(JmolSelectionListener listener) {
        int len;
        int i = this.listeners.length;
        while (--i >= 0) {
            if (this.listeners[i] != listener) continue;
            this.listeners[i] = null;
            break;
        }
        int i2 = len = this.listeners.length;
        while (--i2 >= 0) {
            if (this.listeners[i2] != null) continue;
            this.listeners[i2] = listener;
            return;
        }
        this.listeners = this.listeners.length == 0 ? new JmolSelectionListener[1] : (JmolSelectionListener[])ArrayUtil.doubleLength(this.listeners);
        this.listeners[len] = listener;
    }

    private void selectionChanged(boolean isQuiet) {
        if (this.hideNotSelected) {
            this.hide(BitSetUtil.copyInvert(this.bsSelection, this.viewer.getAtomCount()), false);
        }
        if (isQuiet || this.listeners.length == 0) {
            return;
        }
        int i = this.listeners.length;
        while (--i >= 0) {
            if (this.listeners[i] == null) continue;
            this.listeners[i].selectionChanged(this.bsSelection);
        }
    }

    String getState(StringBuffer sfunc) {
        StringBuffer commands = new StringBuffer();
        if (sfunc != null) {
            sfunc.append("  _setSelectionState;\n");
            commands.append("function _setSelectionState() {\n");
        }
        StateManager.appendCmd(commands, this.viewer.getTrajectoryInfo());
        if (BitSetUtil.firstSetBit(this.bsHidden) >= 0) {
            StateManager.appendCmd(commands, "hide " + Escape.escape(this.bsHidden));
        }
        if (BitSetUtil.firstSetBit(this.bsSubset) >= 0) {
            StateManager.appendCmd(commands, "subset " + Escape.escape(this.bsSubset));
        }
        if (this.bsDeleted != null && BitSetUtil.firstSetBit(this.bsDeleted) >= 0) {
            StateManager.appendCmd(commands, "delete " + Escape.escape(this.bsDeleted));
        }
        String cmd = null;
        Hashtable<String, BitSet> temp = new Hashtable<String, BitSet>();
        temp.put("-", this.bsSelection);
        cmd = StateManager.getCommands(temp, null, this.viewer.getAtomCount());
        if (cmd == null) {
            StateManager.appendCmd(commands, "select none");
        } else {
            commands.append(cmd);
        }
        StateManager.appendCmd(commands, "set hideNotSelected " + this.viewer.getBooleanProperty("hideNotSelected"));
        commands.append(this.viewer.getShapeProperty(1, "selectionState"));
        if (this.viewer.getSelectionHaloEnabled()) {
            StateManager.appendCmd(commands, "SelectionHalos ON");
        }
        if (sfunc != null) {
            commands.append("}\n\n");
        }
        return commands.toString();
    }

    public int deleteAtoms(BitSet bs) {
        if (this.bsDeleted == null) {
            this.bsDeleted = BitSetUtil.copy(bs);
            return BitSetUtil.cardinalityOf(bs);
        }
        BitSet bsNew = BitSetUtil.copy(bs);
        BitSetUtil.andNot(bsNew, this.bsDeleted);
        this.bsDeleted.or(bs);
        BitSetUtil.andNot(this.bsHidden, this.bsDeleted);
        BitSetUtil.andNot(this.bsSelection, this.bsDeleted);
        return BitSetUtil.cardinalityOf(bsNew);
    }

    BitSet getDeletedAtoms() {
        return this.bsDeleted;
    }
}

