/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.TransformManager;
import org.jmol.viewer.Viewer;

class TransformManager11
extends TransformManager {
    private float navigationSlabOffset;
    private float zoomFactor = Float.MAX_VALUE;
    private float prevZoomSetting;
    private float previousX;
    private float previousY;
    boolean isNavigationCentered;
    private int nHits;
    private int multiplier = 1;
    private static final int NAV_MODE_ZOOMED = -1;
    private static final int NAV_MODE_NONE = 0;
    private static final int NAV_MODE_RESET = 1;
    private static final int NAV_MODE_NEWXY = 2;
    private static final int NAV_MODE_NEWXYZ = 3;
    private static final int NAV_MODE_NEWZ = 4;
    private int navMode = 1;

    TransformManager11() {
    }

    TransformManager11(Viewer viewer) {
        super(viewer);
    }

    TransformManager11(Viewer viewer, int width, int height) {
        super(viewer, width, height);
    }

    protected void calcCameraFactors() {
        if (Float.isNaN(this.cameraDepth)) {
            this.cameraDepth = this.cameraDepthSetting;
            this.zoomFactor = Float.MAX_VALUE;
        }
        this.cameraDistance = this.cameraDepth * (float)this.screenPixelCount;
        this.referencePlaneOffset = this.cameraDistance + (float)this.screenPixelCount / 2.0f;
        this.scalePixelsPerAngstrom = this.scale3D && !this.perspectiveDepth && !this.isNavigationMode ? 72.0f / this.scale3DAngstromsPerInch : (float)this.screenPixelCount / this.visualRange;
        this.modelRadiusPixels = this.modelRadius * this.scalePixelsPerAngstrom;
        float offset100 = 2.0f * this.modelRadius / this.visualRange * this.referencePlaneOffset;
        if (!this.isNavigationMode) {
            this.zoomFactor = Float.MAX_VALUE;
            this.modelCenterOffset = this.referencePlaneOffset;
            if (!this.scale3D || this.perspectiveDepth) {
                this.scalePixelsPerAngstrom *= this.modelCenterOffset / offset100 * this.zoomPercent / 100.0f;
            }
            this.modelRadiusPixels = this.modelRadius * this.scalePixelsPerAngstrom;
            return;
        }
        if (this.zoomFactor == Float.MAX_VALUE) {
            if (this.zoomPercent > 10000.0f) {
                this.zoomPercent = 10000.0f;
            }
            this.modelCenterOffset = offset100 * 100.0f / this.zoomPercent;
        } else if (this.prevZoomSetting != this.zoomPercentSetting) {
            this.modelCenterOffset = this.zoomRatio == 0.0f ? offset100 * 100.0f / this.zoomPercentSetting : (this.modelCenterOffset += (1.0f - this.zoomRatio) * this.referencePlaneOffset);
            this.navMode = -1;
        }
        this.prevZoomSetting = this.zoomPercentSetting;
        this.zoomFactor = this.modelCenterOffset / this.referencePlaneOffset;
        this.zoomPercent = this.zoomFactor == 0.0f ? 10000.0f : offset100 / this.modelCenterOffset * 100.0f;
    }

    protected float getPerspectiveFactor(float z) {
        return z <= 0.0f ? this.referencePlaneOffset : this.referencePlaneOffset / z;
    }

    protected void adjustTemporaryScreenPoint() {
        float z = this.point3fScreenTemp.z;
        if (Float.isNaN(z)) {
            if (!this.haveNotifiedNaN) {
                Logger.debug("NaN seen in TransformPoint");
            }
            this.haveNotifiedNaN = true;
            z = 1.0f;
        } else if (z <= 0.0f) {
            z = 1.0f;
        }
        this.point3fScreenTemp.z = z;
        if (this.perspectiveDepth) {
            if (this.isNavigationMode) {
                this.point3fScreenTemp.x -= this.navigationShiftXY.x;
                this.point3fScreenTemp.y -= this.navigationShiftXY.y;
            }
            float factor = this.getPerspectiveFactor(z);
            this.point3fScreenTemp.x *= factor;
            this.point3fScreenTemp.y *= factor;
        }
        if (this.isNavigationMode) {
            this.point3fScreenTemp.x += this.navigationOffset.x;
            this.point3fScreenTemp.y += this.navigationOffset.y;
        } else {
            this.point3fScreenTemp.x += this.fixedRotationOffset.x;
            this.point3fScreenTemp.y += this.fixedRotationOffset.y;
        }
        if (Float.isNaN(this.point3fScreenTemp.x) && !this.haveNotifiedNaN) {
            Logger.debug("NaN found in transformPoint ");
            this.haveNotifiedNaN = true;
        }
        this.point3iScreenTemp.set((int)this.point3fScreenTemp.x, (int)this.point3fScreenTemp.y, (int)this.point3fScreenTemp.z);
    }

    protected void calcNavigationPoint() {
        float depth = this.getNavigationDepthPercent();
        boolean bl = this.isNavigationCentered = depth < 100.0f && depth > 0.0f;
        if (!this.navigating && this.navMode != 1) {
            this.navMode = this.isNavigationCentered && this.previousX == this.fixedTranslation.x && this.previousY == this.fixedTranslation.y && this.navMode != -1 ? 3 : 0;
        }
        switch (this.navMode) {
            case 1: {
                this.navigationOffset.set((float)this.width / 2.0f, (float)this.height / 2.0f, this.referencePlaneOffset);
                this.zoomFactor = Float.MAX_VALUE;
                this.calcCameraFactors();
                this.calcTransformMatrix();
                this.newNavigationCenter();
                break;
            }
            case -1: 
            case 0: {
                this.fixedRotationOffset.set(this.fixedTranslation);
                this.newNavigationCenter();
                break;
            }
            case 2: {
                this.newNavigationCenter();
                break;
            }
            case 3: {
                this.matrixTransform.transform(this.navigationCenter, this.pointT);
                float z = this.pointT.z;
                this.matrixTransform.transform(this.fixedRotationCenter, this.pointT);
                this.modelCenterOffset = this.referencePlaneOffset + (this.pointT.z - z);
                this.calcCameraFactors();
                this.calcTransformMatrix();
                break;
            }
            case 4: {
                this.navigationOffset.z = this.referencePlaneOffset;
                this.unTransformPoint(this.navigationOffset, this.navigationCenter);
            }
        }
        this.matrixTransform.transform(this.navigationCenter, this.navigationShiftXY);
        if (this.viewer.getNavigationPeriodic()) {
            this.viewer.toUnitCell(this.navigationCenter, null);
            if ((double)this.pointT.distance(this.navigationCenter) > 0.01) {
                this.matrixTransform.transform(this.navigationCenter, this.pointT);
                float dz = this.navigationShiftXY.z - this.pointT.z;
                this.modelCenterOffset += dz;
                this.calcCameraFactors();
                this.calcTransformMatrix();
                this.matrixTransform.transform(this.navigationCenter, this.navigationShiftXY);
            }
        }
        this.transformPoint(this.fixedRotationCenter, this.fixedTranslation);
        this.fixedRotationOffset.set(this.fixedTranslation);
        this.previousX = this.fixedTranslation.x;
        this.previousY = this.fixedTranslation.y;
        this.transformPoint(this.navigationCenter, this.navigationOffset);
        this.navigationOffset.z = this.referencePlaneOffset;
        this.navMode = 0;
        this.calcNavigationSlabAndDepth();
    }

    protected void calcNavigationSlabAndDepth() {
        this.slabValue = 0;
        this.depthValue = Integer.MAX_VALUE;
        if (!this.slabEnabled) {
            return;
        }
        this.slabValue = (int)(this.referencePlaneOffset - this.navigationSlabOffset);
        this.depthValue = this.zValueFromPercent(this.depthPercentSetting);
        this.viewer.getGlobalSettings().setParameterValue("navigationDepth", this.getNavigationDepthPercent());
        this.viewer.getGlobalSettings().setParameterValue("navigationSlab", this.getNavigationSlabOffsetPercent());
        if (Logger.debugging) {
            Logger.debug("\n\nperspectiveScale: " + this.referencePlaneOffset + " screenPixelCount: " + this.screenPixelCount + "\nmodelTrailingEdge: " + (this.modelCenterOffset + this.modelRadiusPixels) + " depthValue: " + this.depthValue + "\nmodelCenterOffset: " + this.modelCenterOffset + " modelRadiusPixels: " + this.modelRadiusPixels + "\nmodelLeadingEdge: " + (this.modelCenterOffset - this.modelRadiusPixels) + " slabValue: " + this.slabValue + "\nzoom: " + this.zoomPercent + " navDepth: " + (float)((int)(100.0f * this.getNavigationDepthPercent())) / 100.0f + " visualRange: " + this.visualRange + "\nnavX/Y/Z/modelCenterOffset: " + this.navigationOffset.x + "/" + this.navigationOffset.y + "/" + this.navigationOffset.z + "/" + this.modelCenterOffset + " navCenter:" + this.navigationCenter);
        }
    }

    private void newNavigationCenter() {
        this.isNavigationMode = false;
        this.transformPoint(this.fixedRotationCenter, this.pointT);
        this.pointT.x -= this.navigationOffset.x;
        this.pointT.y -= this.navigationOffset.y;
        float f = -this.getPerspectiveFactor(this.pointT.z);
        this.pointT.x /= f;
        this.pointT.y /= f;
        this.pointT.z = this.referencePlaneOffset;
        this.matrixUnTransform(this.pointT, this.navigationCenter);
        this.isNavigationMode = true;
    }

    boolean canNavigate() {
        return true;
    }

    protected void resetNavigationPoint(boolean doResetSlab) {
        if (this.zoomPercent < 5.0f && !this.isNavigationMode) {
            this.perspectiveDepth = true;
            this.isNavigationMode = true;
            return;
        }
        if (this.isNavigationMode) {
            this.navMode = 1;
            this.slabPercentSetting = 0;
            this.perspectiveDepth = true;
        } else if (doResetSlab) {
            this.slabPercentSetting = 100;
        }
        if (doResetSlab) {
            this.slabEnabled = this.isNavigationMode;
        }
        this.zoomFactor = Float.MAX_VALUE;
        this.zoomPercentSetting = this.zoomPercent;
    }

    synchronized void navigate(int keyCode, int modifiers) {
        if (!this.isNavigationMode) {
            return;
        }
        if (keyCode == 0) {
            this.nHits = 0;
            this.multiplier = 1;
            if (!this.navigating) {
                return;
            }
            this.navigating = false;
            return;
        }
        ++this.nHits;
        if (this.nHits % 10 == 0) {
            this.multiplier *= this.multiplier == 4 ? 1 : 2;
        }
        boolean isOffsetShifted = (modifiers & 1) > 0;
        boolean isAltKey = (modifiers & 8) > 0;
        switch (keyCode) {
            case 38: {
                if (isOffsetShifted) {
                    this.navigationOffset.y -= (float)(2 * this.multiplier);
                    this.navMode = 2;
                    break;
                }
                if (isAltKey) {
                    this.rotateXRadians(-0.0034906585f * (float)this.multiplier, null);
                    this.navMode = 3;
                    break;
                }
                this.modelCenterOffset -= this.viewer.getNavigationSpeed() * (float)(this.viewer.getNavigationPeriodic() ? 1 : this.multiplier);
                this.navMode = 4;
                break;
            }
            case 40: {
                if (isOffsetShifted) {
                    this.navigationOffset.y += (float)(2 * this.multiplier);
                    this.navMode = 2;
                    break;
                }
                if (isAltKey) {
                    this.rotateXRadians(0.0034906585f * (float)this.multiplier, null);
                    this.navMode = 3;
                    break;
                }
                this.modelCenterOffset += this.viewer.getNavigationSpeed() * (float)(this.viewer.getNavigationPeriodic() ? 1 : this.multiplier);
                this.navMode = 4;
                break;
            }
            case 37: {
                if (isOffsetShifted) {
                    this.navigationOffset.x -= (float)(2 * this.multiplier);
                    this.navMode = 2;
                    break;
                }
                this.rotateYRadians(-0.010471976f * (float)this.multiplier, null);
                this.navMode = 3;
                break;
            }
            case 39: {
                if (isOffsetShifted) {
                    this.navigationOffset.x += (float)(2 * this.multiplier);
                    this.navMode = 2;
                    break;
                }
                this.rotateYRadians(0.010471976f * (float)this.multiplier, null);
                this.navMode = 3;
                break;
            }
            default: {
                this.navigating = false;
                this.navMode = 0;
                return;
            }
        }
        this.navigating = true;
        this.finalizeTransformParameters();
    }

    void navigate(float seconds, Point3f pt) {
        if (seconds > 0.0f) {
            this.navigateTo(seconds, null, Float.NaN, pt, Float.NaN, Float.NaN, Float.NaN);
            return;
        }
        this.navigationCenter.set(pt);
        this.navMode = 3;
        this.navigating = true;
        this.finalizeTransformParameters();
        this.navigating = false;
    }

    void navigate(float seconds, Vector3f rotAxis, float degrees) {
        if (seconds > 0.0f) {
            this.navigateTo(seconds, rotAxis, degrees, null, Float.NaN, Float.NaN, Float.NaN);
            return;
        }
        this.rotateAxisAngle(rotAxis, degrees / 57.29578f);
        this.navMode = 3;
        this.navigating = true;
        this.finalizeTransformParameters();
        this.navigating = false;
    }

    void setNavigationDepthPercent(float timeSec, float percent) {
        if (timeSec > 0.0f) {
            this.navigateTo(timeSec, null, Float.NaN, null, percent, Float.NaN, Float.NaN);
            return;
        }
        this.setNavigationDepthPercent(percent);
    }

    void navTranslate(float seconds, Point3f pt) {
        this.transformPoint(pt, this.pointT);
        if (seconds > 0.0f) {
            this.navigateTo(seconds, null, Float.NaN, null, Float.NaN, this.pointT.x, this.pointT.y);
            return;
        }
        this.navTranslatePercent(-1.0f, this.pointT.x, this.pointT.y);
    }

    void navTranslatePercent(float seconds, float x, float y) {
        this.transformPoint(this.navigationCenter, this.navigationOffset);
        if (seconds >= 0.0f) {
            if (!Float.isNaN(x)) {
                x = (float)this.width * x / 100.0f + (Float.isNaN(y) ? this.navigationOffset.x : (float)this.width / 2.0f);
            }
            if (!Float.isNaN(y)) {
                y = (float)this.height * y / 100.0f + (Float.isNaN(x) ? this.navigationOffset.y : (float)this.height / 2.0f);
            }
        }
        if (seconds > 0.0f) {
            this.navigateTo(seconds, null, Float.NaN, null, Float.NaN, x, y);
            return;
        }
        if (!Float.isNaN(x)) {
            this.navigationOffset.x = x;
        }
        if (!Float.isNaN(y)) {
            this.navigationOffset.y = y;
        }
        this.navMode = 2;
        this.navigating = true;
        this.finalizeTransformParameters();
        this.navigating = false;
    }

    private void navigateTo(float floatSecondsTotal, Vector3f axis, float degrees, Point3f center, float depthPercent, float xTrans, float yTrans) {
        this.ptMoveToCenter = center == null ? this.navigationCenter : center;
        int fps = 30;
        int totalSteps = (int)(floatSecondsTotal * (float)fps);
        if (floatSecondsTotal > 0.0f) {
            this.viewer.setInMotion(true);
        }
        if (degrees == 0.0f) {
            degrees = Float.NaN;
        }
        if (totalSteps > 1) {
            int frameTimeMillis = 1000 / fps;
            long targetTime = System.currentTimeMillis();
            float depthStart = this.getNavigationDepthPercent();
            float depthDelta = depthPercent - depthStart;
            float xTransStart = this.navigationOffset.x;
            float xTransDelta = xTrans - xTransStart;
            float yTransStart = this.navigationOffset.y;
            float yTransDelta = yTrans - yTransStart;
            float degreeStep = degrees / (float)totalSteps;
            this.aaStepCenter.set(this.ptMoveToCenter);
            this.aaStepCenter.sub(this.navigationCenter);
            this.aaStepCenter.scale(1.0f / (float)totalSteps);
            Point3f centerStart = new Point3f(this.navigationCenter);
            for (int iStep = 1; iStep < totalSteps; ++iStep) {
                this.navigating = true;
                float fStep = (float)iStep / ((float)totalSteps - 1.0f);
                if (!Float.isNaN(degrees)) {
                    this.navigate(0.0f, axis, degreeStep);
                }
                if (center != null) {
                    centerStart.add(this.aaStepCenter);
                    this.navigate(0.0f, centerStart);
                }
                if (!Float.isNaN(xTrans) || !Float.isNaN(yTrans)) {
                    float x = Float.NaN;
                    float y = Float.NaN;
                    if (!Float.isNaN(xTrans)) {
                        x = xTransStart + xTransDelta * fStep;
                    }
                    if (!Float.isNaN(yTrans)) {
                        y = yTransStart + yTransDelta * fStep;
                    }
                    this.navTranslatePercent(-1.0f, x, y);
                }
                if (!Float.isNaN(depthPercent)) {
                    this.setNavigationDepthPercent(depthStart + depthDelta * fStep);
                }
                this.navigating = false;
                if (System.currentTimeMillis() >= (targetTime += (long)frameTimeMillis)) continue;
                this.viewer.requestRepaintAndWait();
                if (this.viewer.isScriptExecuting()) {
                    int sleepTime = (int)(targetTime - System.currentTimeMillis());
                    if (sleepTime <= 0) continue;
                    try {
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    continue;
                }
                break;
            }
        } else {
            int sleepTime = (int)(floatSecondsTotal * 1000.0f) - 30;
            if (sleepTime > 0) {
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
        }
        if (!Float.isNaN(xTrans) || !Float.isNaN(yTrans)) {
            this.navTranslatePercent(-1.0f, xTrans, yTrans);
        }
        if (!Float.isNaN(depthPercent)) {
            this.setNavigationDepthPercent(depthPercent);
        }
        this.viewer.setInMotion(false);
    }

    void navigate(float seconds, Point3f[][] pathGuide) {
        this.navigate(seconds, pathGuide, null, null, 0, Integer.MAX_VALUE);
    }

    void navigate(float seconds, Point3f[] path, float[] theta, int indexStart, int indexEnd) {
        this.navigate(seconds, null, path, theta, indexStart, indexEnd);
    }

    private void navigate(float seconds, Point3f[][] pathGuide, Point3f[] path, float[] theta, int indexStart, int indexEnd) {
        int nSegments;
        if (seconds <= 0.0f) {
            seconds = 2.0f;
        }
        boolean isPathGuide = pathGuide != null;
        if (!isPathGuide) {
            for (nSegments = Math.min((isPathGuide ? pathGuide.length : path.length) - 1, indexEnd); nSegments > 0 && path[nSegments] == null; --nSegments) {
            }
        }
        if ((nSegments -= indexStart) < 1) {
            return;
        }
        int nPer = (int)(10.0f * seconds);
        int nSteps = nSegments * nPer + 1;
        Tuple3f[] points = new Point3f[nSteps + 2];
        Tuple3f[] pointGuides = new Point3f[isPathGuide ? nSteps + 2 : 0];
        for (int i = 0; i < nSegments; ++i) {
            int iPrev = Math.max(i - 1, 0) + indexStart;
            int pt = i + indexStart;
            int iNext = Math.min(i + 1, nSegments) + indexStart;
            int iNext2 = Math.min(i + 2, nSegments) + indexStart;
            int iNext3 = Math.min(i + 3, nSegments) + indexStart;
            if (isPathGuide) {
                Graphics3D.getHermiteList(7, pathGuide[iPrev][0], pathGuide[pt][0], pathGuide[iNext][0], pathGuide[iNext2][0], pathGuide[iNext3][0], points, i * nPer, nPer + 1);
                Graphics3D.getHermiteList(7, pathGuide[iPrev][1], pathGuide[pt][1], pathGuide[iNext][1], pathGuide[iNext2][1], pathGuide[iNext3][1], pointGuides, i * nPer, nPer + 1);
                continue;
            }
            Graphics3D.getHermiteList(7, path[iPrev], path[pt], path[iNext], path[iNext2], path[iNext3], points, i * nPer, nPer + 1);
        }
        int fps = 10;
        int totalSteps = nSteps;
        this.viewer.setInMotion(true);
        int frameTimeMillis = 1000 / fps;
        long targetTime = System.currentTimeMillis();
        for (int iStep = 0; iStep < totalSteps; ++iStep) {
            this.navigate(0.0f, points[iStep]);
            if (isPathGuide) {
                this.alignZX(points[iStep], points[iStep + 1], pointGuides[iStep]);
            }
            if (System.currentTimeMillis() >= (targetTime += (long)frameTimeMillis)) continue;
            this.viewer.requestRepaintAndWait();
            if (!this.viewer.isScriptExecuting()) break;
            int sleepTime = (int)(targetTime - System.currentTimeMillis());
            if (sleepTime <= 0) continue;
            try {
                Thread.sleep(sleepTime);
                continue;
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
    }

    private void alignZX(Point3f pt0, Point3f pt1, Point3f ptVectorWing) {
        Point3f pt0s = new Point3f();
        Point3f pt1s = new Point3f();
        this.matrixRotate.transform(pt0, pt0s);
        this.matrixRotate.transform(pt1, pt1s);
        Vector3f vPath = new Vector3f(pt0s);
        vPath.sub(pt1s);
        Vector3f v = new Vector3f(0.0f, 0.0f, 1.0f);
        float angle = vPath.angle(v);
        v.cross(vPath, v);
        if (angle != 0.0f) {
            this.navigate(0.0f, v, angle * 57.29578f);
        }
        this.matrixRotate.transform(pt0, pt0s);
        Point3f pt2 = new Point3f(ptVectorWing);
        pt2.add(pt0);
        Point3f pt2s = new Point3f();
        this.matrixRotate.transform(pt2, pt2s);
        vPath.set(pt2s);
        vPath.sub(pt0s);
        vPath.z = 0.0f;
        v.set(-1.0f, 0.0f, 0.0f);
        angle = vPath.angle(v);
        if (vPath.y < 0.0f) {
            angle = -angle;
        }
        v.set(0.0f, 0.0f, 1.0f);
        if (angle != 0.0f) {
            this.navigate(0.0f, v, angle * 57.29578f);
        }
        this.matrixRotate.transform(pt0, pt0s);
        this.matrixRotate.transform(pt1, pt1s);
        this.matrixRotate.transform(ptVectorWing, pt2s);
    }

    Point3f getNavigationCenter() {
        return this.navigationCenter;
    }

    boolean isNavigationCentered() {
        return this.isNavigationCentered;
    }

    void setNavigationSlabOffsetPercent(float percent) {
        this.viewer.getGlobalSettings().setParameterValue("navigationSlab", percent);
        this.calcCameraFactors();
        this.navigationSlabOffset = percent / 50.0f * this.modelRadiusPixels;
    }

    private float getNavigationSlabOffsetPercent() {
        this.calcCameraFactors();
        return 50.0f * this.navigationSlabOffset / this.modelRadiusPixels;
    }

    Point3f getNavigationOffset() {
        this.transformPoint(this.navigationCenter, this.navigationOffset);
        return this.navigationOffset;
    }

    private void setNavigationDepthPercent(float percent) {
        this.viewer.getGlobalSettings().setParameterValue("navigationDepth", percent);
        this.calcCameraFactors();
        this.modelCenterOffset = this.referencePlaneOffset - (1.0f - percent / 50.0f) * this.modelRadiusPixels;
        this.calcCameraFactors();
        this.navMode = -1;
    }

    float getNavigationDepthPercent() {
        this.calcCameraFactors();
        return this.modelRadiusPixels == 0.0f ? 50.0f : 50.0f * (1.0f + (this.modelCenterOffset - this.referencePlaneOffset) / this.modelRadiusPixels);
    }

    float getNavigationOffsetPercent(char XorY) {
        this.transformPoint(this.navigationCenter, this.navigationOffset);
        if (this.width == 0 || this.height == 0) {
            return 0.0f;
        }
        return XorY == 'X' ? (this.navigationOffset.x - (float)this.width / 2.0f) * 100.0f / (float)this.width : (this.navigationOffset.y - (float)this.height / 2.0f) * 100.0f / (float)this.height;
    }

    protected String getNavigationText(boolean addComments) {
        this.transformPoint(this.navigationCenter, this.navigationOffset);
        return (addComments ? " /* navigation center, translation, depth */ " : " ") + Escape.escape(this.navigationCenter) + " " + this.getNavigationOffsetPercent('X') + " " + this.getNavigationOffsetPercent('Y') + " " + this.getNavigationDepthPercent();
    }

    protected String getNavigationState() {
        if (!this.isNavigationMode) {
            return "";
        }
        return "# navigation state;\nnavigate 0 center " + Escape.escape(this.getNavigationCenter()) + ";\nnavigate 0 translate " + this.getNavigationOffsetPercent('X') + " " + this.getNavigationOffsetPercent('Y') + ";\nset navigationDepth " + this.getNavigationDepthPercent() + ";\nset navigationSlab " + this.getNavigationSlabOffsetPercent() + ";\n\n";
    }
}

