/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app;

import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.util.Scanner;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolViewer;
import org.jmol.export.history.HistoryFile;
import org.jmol.i18n.GT;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.openscience.jmol.app.SplashInterface;

public class JmolApp {
    public int startupWidth;
    public int startupHeight;
    public Point border;
    public boolean haveBorder;
    public File userPropsFile;
    public HistoryFile historyFile;
    public String menuStructure;
    public String menuFile;
    public boolean splashEnabled = true;
    public boolean useIndependentCommandThread;
    public boolean transparentBackground;
    public boolean checkScriptNoFiles;
    public boolean checkScriptAndOpenFiles;
    public boolean exitUponCompletion;
    public boolean haveConsole = true;
    public boolean haveDisplay = true;
    public boolean isDataOnly;
    public boolean isPrintOnly;
    public boolean isSilent;
    public boolean listCommands;
    public String commandOptions = "";
    public String modelFilename;
    public String scriptFilename;
    public String script1 = "";
    public String script;
    public String script2 = "";
    public Point jmolPosition;
    public JmolViewer viewer;
    public JmolAdapter modelAdapter;
    public String language;

    public JmolApp() {
    }

    public JmolApp(String[] args) {
        if (System.getProperty("javawebstart.version") != null) {
            System.setSecurityManager(null);
        }
        if (System.getProperty("user.home") == null) {
            System.err.println(GT._("Error starting Jmol: the property 'user.home' is not defined."));
            System.exit(1);
        }
        File ujmoldir = new File(new File(System.getProperty("user.home")), ".jmol");
        ujmoldir.mkdirs();
        this.userPropsFile = new File(ujmoldir, "properties");
        this.historyFile = new HistoryFile(new File(ujmoldir, "history"), "Jmol's persistent values");
        this.parseCommandLine(args);
    }

    public void parseCommandLine(String[] args) {
        Options options = this.getOptions(args);
        CommandLine line = null;
        try {
            PosixParser parser = new PosixParser();
            line = parser.parse(options, args);
        }
        catch (ParseException exception) {
            System.err.println("Unexpected exception: " + exception.toString());
        }
        args = line.getArgs();
        if (args.length > 0) {
            this.modelFilename = args[0];
        }
        this.checkOptions(line, options);
    }

    private Options getOptions(String[] args) {
        Options options = new Options();
        options.addOption("b", "backgroundtransparent", false, GT._("transparent background"));
        options.addOption("h", "help", false, GT._("give this help page"));
        options.addOption("n", "nodisplay", false, GT._("no display (and also exit when done)"));
        options.addOption("c", "check", false, GT._("check script syntax only - no file loading"));
        options.addOption("C", "checkload", false, GT._("check script syntax only - with file loading"));
        options.addOption("d", "debug", false, GT._("debug"));
        options.addOption("i", "silent", false, GT._("silent startup operation"));
        options.addOption("l", "list", false, GT._("list commands during script execution"));
        options.addOption("L", "nosplash", false, GT._("start with no splash screen"));
        options.addOption("o", "noconsole", false, GT._("no console -- all output to sysout"));
        options.addOption("p", "printOnly", false, GT._("send only output from print messages to console (implies -i)"));
        options.addOption("t", "threaded", false, GT._("independent commmand thread"));
        options.addOption("x", "exit", false, GT._("exit after script (implicit with -n)"));
        OptionBuilder.withLongOpt("script");
        OptionBuilder.withDescription(GT._("script file to execute or '-' for System.in"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create("s"));
        OptionBuilder.withLongOpt("jmolscript1");
        OptionBuilder.withDescription(GT._("Jmol script to execute BEFORE -s option"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create("J"));
        OptionBuilder.withLongOpt("jmolscript2");
        OptionBuilder.withDescription(GT._("Jmol script to execute AFTER -s option"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create("j"));
        OptionBuilder.withLongOpt("menu");
        OptionBuilder.withDescription("menu file to use");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create("m"));
        OptionBuilder.withArgName(GT._("property=value"));
        OptionBuilder.hasArg();
        OptionBuilder.withValueSeparator();
        OptionBuilder.withDescription(GT._("supported options are given below"));
        options.addOption(OptionBuilder.create("D"));
        OptionBuilder.withLongOpt("geometry");
        OptionBuilder.withDescription(GT._("window width x height, e.g. {0}", "-g500x500"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create("g"));
        OptionBuilder.withLongOpt("quality");
        OptionBuilder.withDescription(GT._("JPG image quality (1-100; default 75) or PNG image compression (0-9; default 2, maximum compression 9)"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create("q"));
        OptionBuilder.withLongOpt("write");
        OptionBuilder.withDescription(GT._("{0} or {1}:filename", new Object[]{"CLIP", "GIF|JPG|JPG64|PNG|PPM"}));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create("w"));
        return options;
    }

    private void checkOptions(CommandLine line, Options options) {
        if (line.hasOption("h")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("Jmol", options);
            System.out.println();
            System.out.println(GT._("For example:"));
            System.out.println();
            System.out.println("Jmol -ions myscript.spt -w JPEG:myfile.jpg > output.txt");
            System.out.println();
            System.out.println(GT._("The -D options are as follows (defaults in parenthesis):"));
            System.out.println();
            System.out.println("  cdk.debugging=[true|false] (false)");
            System.out.println("  cdk.debug.stdout=[true|false] (false)");
            System.out.println("  display.speed=[fps|ms] (ms)");
            System.out.println("  JmolConsole=[true|false] (true)");
            System.out.println("  logger.debug=[true|false] (false)");
            System.out.println("  logger.error=[true|false] (true)");
            System.out.println("  logger.fatal=[true|false] (true)");
            System.out.println("  logger.info=[true|false] (true)");
            System.out.println("  logger.logLevel=[true|false] (false)");
            System.out.println("  logger.warn=[true|false] (true)");
            System.out.println("  plugin.dir (unset)");
            System.out.println("  user.language=[CA|CS|DE|EN|ES|FR|NL|PT|TR] (EN)");
            System.exit(0);
        }
        if (line.hasOption("d")) {
            Logger.setLogLevel(5);
        }
        String string = this.commandOptions = this.isDataOnly ? "JmolData " : "Jmol ";
        if (line.hasOption("p")) {
            this.isPrintOnly = true;
        }
        if (this.isPrintOnly) {
            this.commandOptions = this.commandOptions + "-p";
            this.isSilent = true;
        }
        if (line.hasOption("i")) {
            this.isSilent = true;
        }
        if (this.isSilent) {
            this.commandOptions = this.commandOptions + "-i";
        }
        if (line.hasOption("o")) {
            this.haveConsole = false;
        }
        if (!this.haveConsole) {
            this.commandOptions = this.commandOptions + "-o";
        }
        if (line.hasOption("b")) {
            this.transparentBackground = true;
        }
        if (this.transparentBackground) {
            this.commandOptions = this.commandOptions + "-b";
        }
        if (line.hasOption("t")) {
            this.useIndependentCommandThread = true;
        }
        if (this.useIndependentCommandThread) {
            this.commandOptions = this.commandOptions + "-t";
        }
        if (line.hasOption("l")) {
            this.listCommands = true;
        }
        if (this.listCommands) {
            this.commandOptions = this.commandOptions + "-l";
        }
        if (line.hasOption("L")) {
            this.splashEnabled = false;
        }
        if (!this.splashEnabled) {
            this.commandOptions = this.commandOptions + "-L";
        }
        if (line.hasOption("c")) {
            this.checkScriptNoFiles = true;
        } else if (line.hasOption("C")) {
            this.checkScriptAndOpenFiles = true;
        }
        if (this.checkScriptNoFiles) {
            this.commandOptions = this.commandOptions + "-c";
        } else if (this.checkScriptAndOpenFiles) {
            this.commandOptions = this.commandOptions + "-c";
        }
        if (line.hasOption("m")) {
            this.menuFile = line.getOptionValue("m");
        }
        if (line.hasOption("J")) {
            this.commandOptions = this.commandOptions + "-J";
            this.script1 = line.getOptionValue("J");
        }
        if (line.hasOption("s")) {
            this.commandOptions = this.commandOptions + "-s";
            this.scriptFilename = line.getOptionValue("s");
        }
        if (line.hasOption("j")) {
            this.commandOptions = this.commandOptions + "-j";
            this.script2 = line.getOptionValue("j");
        }
        Object b = null;
        if (this.haveDisplay) {
            Dimension size;
            String vers = System.getProperty("java.version");
            if (vers.compareTo("1.1.2") < 0) {
                System.out.println("!!!WARNING: Swing components require a 1.1.2 or higher version VM!!!");
            }
            if ((size = this.historyFile.getWindowSize("Jmol")) != null) {
                this.startupWidth = size.width;
                this.startupHeight = size.height;
            }
            this.historyFile.getWindowBorder("Jmol");
            this.border = b == null || b.x > 50 ? new Point(12, 116) : new Point(b.x, b.y);
        }
        int width = 500;
        int height = 500;
        if (line.hasOption("g")) {
            String geometry = line.getOptionValue("g");
            int indexX = geometry.indexOf(120);
            if (indexX > 0) {
                width = Parser.parseInt(geometry.substring(0, indexX));
                height = Parser.parseInt(geometry.substring(indexX + 1));
            } else {
                width = height = Parser.parseInt(geometry);
            }
            this.startupWidth = -1;
        }
        if (this.startupWidth <= 0 || this.startupHeight <= 0) {
            if (this.haveDisplay) {
                this.startupWidth = width + this.border.x;
                this.startupHeight = height + this.border.y;
            } else {
                this.startupWidth = width;
                this.startupHeight = height;
            }
        }
        if (line.hasOption("w")) {
            String type_name;
            int quality = -1;
            if (line.hasOption("q")) {
                quality = Parser.parseInt(line.getOptionValue("q"));
            }
            if ((type_name = line.getOptionValue("w")) != null) {
                if (type_name.length() == 0) {
                    type_name = "JPG:jpg";
                }
                if (type_name.indexOf(":") < 0) {
                    type_name = type_name + ":jpg";
                }
                int i = type_name.indexOf(":");
                String type = type_name.substring(0, i).toUpperCase();
                type_name = " \"" + type_name.substring(i + 1) + "\"";
                if (type.indexOf(" ") < 0) {
                    type = type + " " + quality;
                }
                this.script2 = this.script2 + ";write image " + width + " " + height + " " + type + type_name;
            }
        }
        if (line.hasOption("n")) {
            this.haveDisplay = false;
            this.exitUponCompletion = true;
        }
        if (line.hasOption("x")) {
            this.exitUponCompletion = true;
        }
        if (!this.haveDisplay) {
            this.commandOptions = this.commandOptions + "-n";
        }
        if (this.exitUponCompletion) {
            this.commandOptions = this.commandOptions + "-x";
            this.script2 = this.script2 + ";exitJmol // " + this.commandOptions;
        }
    }

    public void startViewer(JmolViewer viewer, SplashInterface splash) {
        this.viewer = viewer;
        if (this.modelFilename != null) {
            viewer.openFileAsynchronously(this.modelFilename);
        }
        if (this.script1 != null && this.script1.length() > 0) {
            if (!this.isSilent) {
                Logger.info("Executing script: " + this.script1);
            }
            if (splash != null) {
                splash.showStatus(GT._("Executing script 1..."));
            }
            viewer.script(this.script1);
        }
        if (this.scriptFilename != null) {
            if (!this.isSilent) {
                Logger.info("Executing script from file: " + this.scriptFilename);
            }
            if (splash != null) {
                splash.showStatus(GT._("Executing script file..."));
            }
            if (this.scriptFilename.equals("-")) {
                Scanner scan = new Scanner(System.in);
                String linein = "";
                StringBuffer script = new StringBuffer();
                while (scan.hasNextLine() && (linein = scan.nextLine()) != null && !linein.equals("!quit")) {
                    script.append(linein).append("\n");
                }
                viewer.script(script.toString());
            } else {
                viewer.evalFile(this.scriptFilename);
            }
        }
        if (this.script2 != null && this.script2.length() > 0) {
            if (!this.isSilent) {
                Logger.info("Executing script: " + this.script2);
            }
            if (splash != null) {
                splash.showStatus(GT._("Executing script 2..."));
            }
            viewer.script(this.script2);
        }
    }
}

