/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jmolpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jmol.api.JmolViewer;
import org.jmol.i18n.GT;
import org.jmol.viewer.Viewer;

public class GaussianDialog
extends JDialog
implements ActionListener,
ChangeListener {
    JmolViewer viewer;
    private JPanel container;
    private JTextField checkField;
    private JTextField optsField;
    private JTextField fileField;
    private JTextField selectField;
    private JComboBox memBox;
    private JComboBox methBox;
    private JComboBox basisBox;
    private JComboBox dfBox;
    private JSpinner procSpinner;
    private JSpinner chargeSpinner;
    private JSpinner multSpinner;
    private JButton fileButton;
    private JButton saveButton;
    private JButton cancelButton;
    private JFileChooser fileChooser;
    private JTextArea editArea;
    private JTabbedPane inputTabs;
    private String check;
    private String mem;
    private String proc;
    private String file;
    private String meth;
    private String route;
    private String charge;
    private String mult;
    private String select;
    private static final String DEFAULT_METHOD = "HF";
    private static final String DEFAULT_BASIS = "3-21G**";
    private static final String DEFAULT_CHARGE = "0";
    private static final String DEFAULT_MULT = "1";
    private static final String[] BASIS_LIST = new String[]{"Gen", "3-21G", "3-21G*", "3-21G**", "6-21G", "4-31G", "6-31G", "6-311G", "D95V", "D95", "SHC", "CEP-4G", "CEP-31G", "CEP-121G", "LanL2MB", "LanL2DZ", "SDD", "SDDAll", "cc-pVDZ", "cc-pVTZ", "cc-pVQZ", "cc-pV5Z", "cc-pV6Z", "aug-cc-pVDZ", "aug-cc-pVTZ", "aug-cc-pVQZ", "aug-cc-pV5Z", "aug-cc-pV6Z", "SV", "SVP", "TZV", "TZVP", "MidiX", "EPR-II", "EPR-III", "UGBS", "UGBS1P", "UGBS2P", "UGBS3P", "MTSmall", "DGDZVP", "DGDZVP2", "DGTZVP"};
    private static final String[] METHOD_LIST = new String[]{"HF", "MP2", "MP3", "MP4", "CCSD(T)", "CIS", "CISD", "LSDA", "BLYP", "BP86", "BPW91", "OLYP", "OP86", "OPW91", "PBEPBE", "VSXC", "HCTH93", "HCTH147", "HCTH407", "TPSSTPSS", "B3LYP", "B3PW91", "AM1", "PM3", "CNDO", "INDO", "MNDO", "MINDO3", "ZINDO", "UFF", "AMBER", "DREIDING", "Huckel"};
    private static final String[] DF_LIST = new String[]{"None", "Auto", "DGA1", "DGA2"};
    private static final String[] MEMORY_LIST = new String[]{"Default", "100MB", "500MB", "1GB", "2GB", "4GB", "7GB", "15GB"};
    private static final String NOBASIS_LIST = "AM1 PM3 CNDO INDO MNDO MINDO3 ZINDO UFF AMBER DREIDING Huckel";
    private static final String DFT_LIST = "LSDA BLYP BP86 BPW91 OLYP OP86 OPW91 PBEPBE VSXC HCTH93 NCTH147 HCTH407 TPSSTPSS B3LYP B3PW91";

    public GaussianDialog(JFrame f, JmolViewer viewer) {
        super((Frame)f, false);
        this.viewer = viewer;
        this.setTitle(GT._("Export Gaussian Input File"));
        this.container = new JPanel();
        this.container.setLayout(new BorderLayout());
        this.inputTabs = new JTabbedPane();
        JPanel basicPanel = this.buildBasicPanel();
        this.inputTabs.addTab(GT._("Basic"), null, basicPanel);
        JPanel advancedPanel = this.buildAdvancedPanel();
        this.inputTabs.addTab(GT._("Advanced"), null, advancedPanel);
        this.inputTabs.addChangeListener(this);
        JPanel filePanel = this.buildFilePanel();
        JPanel buttonPanel = this.buildButtonPanel();
        this.container.add((Component)this.inputTabs, "North");
        this.container.add((Component)filePanel, "Center");
        this.container.add((Component)buttonPanel, "South");
        this.getContentPane().add(this.container);
        this.pack();
        this.centerDialog();
        this.updateUI();
    }

    private JPanel buildBasicPanel() {
        JPanel showPanel = new JPanel(new BorderLayout());
        JPanel linkPanel = new JPanel(new BorderLayout());
        TitledBorder linkTitle = BorderFactory.createTitledBorder("link0 Section");
        linkPanel.setBorder(linkTitle);
        JPanel linkLabels = new JPanel(new GridLayout(3, 1));
        JPanel linkControls = new JPanel(new GridLayout(3, 1));
        JLabel checkLabel = new JLabel(GT._("Checkpoint File: "));
        linkLabels.add(checkLabel);
        this.checkField = new JTextField(20);
        linkControls.add(this.checkField);
        JLabel memLabel = new JLabel(GT._("Amount of Memory:"));
        linkLabels.add(memLabel);
        this.memBox = new JComboBox<String>(MEMORY_LIST);
        linkControls.add(this.memBox);
        this.memBox.setSelectedIndex(0);
        JLabel procLabel = new JLabel(GT._("Number of Processors:"));
        linkLabels.add(procLabel);
        SpinnerNumberModel procModel = new SpinnerNumberModel(1, 1, 16, 1);
        this.procSpinner = new JSpinner(procModel);
        this.procSpinner.setEditor(new JSpinner.NumberEditor(this.procSpinner, "#"));
        linkControls.add(this.procSpinner);
        linkPanel.add((Component)linkLabels, "Before");
        linkPanel.add((Component)linkControls, "Center");
        showPanel.add((Component)linkPanel, "North");
        JPanel routePanel = new JPanel(new BorderLayout());
        TitledBorder routeTitle = BorderFactory.createTitledBorder(GT._("Route"));
        routePanel.setBorder(routeTitle);
        JPanel routeLabels = new JPanel(new GridLayout(4, 1));
        JPanel routeControls = new JPanel(new GridLayout(4, 1));
        JLabel methLabel = new JLabel(GT._("Method: "));
        routeLabels.add(methLabel);
        this.methBox = new JComboBox<String>(METHOD_LIST);
        routeControls.add(this.methBox);
        this.methBox.setSelectedIndex(0);
        this.methBox.addActionListener(this);
        JLabel basisLabel = new JLabel(GT._("Basis Set: "));
        routeLabels.add(basisLabel);
        this.basisBox = new JComboBox<String>(BASIS_LIST);
        routeControls.add(this.basisBox);
        this.basisBox.setSelectedIndex(3);
        JLabel dfLabel = new JLabel(GT._("Density Fitting Basis Set (DFT Only): "));
        routeLabels.add(dfLabel);
        this.dfBox = new JComboBox<String>(DF_LIST);
        routeControls.add(this.dfBox);
        this.dfBox.setSelectedIndex(0);
        JLabel optsLabel = new JLabel(GT._("Job Options: "));
        routeLabels.add(optsLabel);
        this.optsField = new JTextField(20);
        routeControls.add(this.optsField);
        this.optsField.setText("opt");
        routePanel.add((Component)routeLabels, "Before");
        routePanel.add((Component)routeControls, "Center");
        showPanel.add((Component)routePanel, "Center");
        JPanel molPanel = new JPanel(new BorderLayout());
        TitledBorder molTitle = BorderFactory.createTitledBorder(GT._("Molecular Properties"));
        molPanel.setBorder(molTitle);
        JPanel molLabels = new JPanel(new GridLayout(3, 1));
        JPanel molControls = new JPanel(new GridLayout(3, 1));
        JLabel chargeLabel = new JLabel(GT._("Total Charge: "));
        molLabels.add(chargeLabel);
        SpinnerNumberModel chargeModel = new SpinnerNumberModel(0, -10, 10, 1);
        this.chargeSpinner = new JSpinner(chargeModel);
        this.chargeSpinner.setEditor(new JSpinner.NumberEditor(this.chargeSpinner, "#"));
        molControls.add(this.chargeSpinner);
        JLabel multLabel = new JLabel(GT._("Multiplicity: "));
        molLabels.add(multLabel);
        SpinnerNumberModel multModel = new SpinnerNumberModel(1, 0, 10, 1);
        this.multSpinner = new JSpinner(multModel);
        this.multSpinner.setEditor(new JSpinner.NumberEditor(this.multSpinner, "#"));
        molControls.add(this.multSpinner);
        JLabel selectLabel = new JLabel(GT._("Selection: "));
        molLabels.add(selectLabel);
        this.selectField = new JTextField(20);
        this.selectField.setText("visible");
        molControls.add(this.selectField);
        molPanel.add((Component)molLabels, "Before");
        molPanel.add((Component)molControls, "Center");
        showPanel.add((Component)molPanel, "South");
        return showPanel;
    }

    private JPanel buildAdvancedPanel() {
        JPanel editPanel = new JPanel(new BorderLayout());
        TitledBorder editTitle = BorderFactory.createTitledBorder("Edit Gaussian Input File");
        editPanel.setBorder(editTitle);
        this.editArea = new JTextArea();
        JScrollPane editPane = new JScrollPane(this.editArea);
        editPane.setPreferredSize(new Dimension(150, 100));
        editPanel.add((Component)editPane, "Center");
        return editPanel;
    }

    private JPanel buildFilePanel() {
        JPanel showPanel = new JPanel(new FlowLayout(2));
        TitledBorder fileTitle = BorderFactory.createTitledBorder(GT._("Gaussian Input File Name"));
        showPanel.setBorder(fileTitle);
        this.fileField = new JTextField(30);
        showPanel.add(this.fileField);
        this.fileField.setText(new File("my_input.com").getAbsolutePath());
        this.fileButton = new JButton(GT._("File..."));
        this.fileButton.addActionListener(this);
        showPanel.add(this.fileButton);
        return showPanel;
    }

    private JPanel buildButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        this.saveButton = new JButton(GT._("Save"));
        this.saveButton.addActionListener(this);
        buttonPanel.add(this.saveButton);
        this.cancelButton = new JButton(GT._("Cancel"));
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.cancelButton);
        this.getRootPane().setDefaultButton(this.saveButton);
        return buttonPanel;
    }

    protected void centerDialog() {
        Dimension screenSize = this.getToolkit().getScreenSize();
        Dimension size = this.getSize();
        screenSize.height /= 2;
        screenSize.width /= 2;
        size.height /= 2;
        size.width /= 2;
        int y = screenSize.height - size.height;
        int x = screenSize.width - size.width;
        this.setLocation(x, y);
    }

    private void updateVars() {
        String basis;
        this.check = this.checkField.getText();
        this.mem = this.memBox.getSelectedItem().toString();
        this.proc = this.procSpinner.getValue().toString();
        this.select = this.selectField.getText();
        if (this.select.length() == 0) {
            this.select = "visible";
            this.selectField.setText(this.select);
        }
        this.charge = this.chargeSpinner.getValue().toString();
        if (this.charge.equals("")) {
            this.charge = DEFAULT_CHARGE;
        }
        this.mult = this.multSpinner.getValue().toString();
        if (this.mult.equals("")) {
            this.mult = DEFAULT_MULT;
        }
        if ((basis = this.basisBox.getSelectedItem().toString()).equals("")) {
            basis = DEFAULT_BASIS;
        }
        this.meth = this.methBox.getSelectedItem().toString();
        if (this.meth.equals("")) {
            this.meth = DEFAULT_METHOD;
        }
        if (NOBASIS_LIST.lastIndexOf(this.meth, NOBASIS_LIST.length()) >= 0) {
            basis = "";
        }
        if (!basis.equals("")) {
            basis = "/" + basis;
        }
        String df = this.dfBox.getSelectedItem().toString();
        if (DFT_LIST.lastIndexOf(this.meth, DFT_LIST.length()) < 0) {
            df = "None";
        }
        df = df.equals("None") ? "" : "/" + df;
        this.file = this.fileField.getText();
        if (this.file.equals("")) {
            this.file = "my_input.com";
        }
        String opts = this.optsField.getText();
        this.route = "# " + this.meth + basis + df + " " + opts;
    }

    private void updateUI() {
        this.updateVars();
        if (NOBASIS_LIST.lastIndexOf(this.meth, NOBASIS_LIST.length()) >= 0) {
            this.basisBox.setEnabled(false);
        } else {
            this.basisBox.setEnabled(true);
        }
        if (DFT_LIST.lastIndexOf(this.meth, DFT_LIST.length()) >= 0) {
            this.dfBox.setEnabled(true);
        } else {
            this.dfBox.setEnabled(false);
        }
    }

    private void save() {
        if (this.inputTabs.getSelectedIndex() == 0) {
            this.getCommand();
        }
        BufferedWriter output = null;
        try {
            File outputFile = new File(this.fileField.getText());
            this.fileField.setText(outputFile.getAbsolutePath());
            output = new BufferedWriter(new FileWriter(outputFile));
            output.write(this.editArea.getText());
            ((Writer)output).close();
        }
        catch (IOException err) {
            return;
        }
        this.dispose();
    }

    private void cancel() {
        this.dispose();
    }

    private void setFile() {
        this.fileChooser = new JFileChooser();
        String fname = this.fileField.getText();
        this.fileChooser.setSelectedFile(new File(fname));
        int ierr = this.fileChooser.showDialog(this, "Set");
        if (ierr == 0) {
            File file = this.fileChooser.getSelectedFile();
            this.fileField.setText(file.getAbsolutePath());
        }
    }

    private void tabSwitched() {
        if (this.inputTabs.getSelectedIndex() == 1) {
            this.getCommand();
        }
    }

    protected void getCommand() {
        String m;
        this.updateVars();
        String c = this.check;
        if (!c.equals("")) {
            c = "%chk=" + c + "\n";
        }
        m = !(m = this.mem).equals("Default") ? "%mem=" + m + "\n" : "";
        String p = this.proc;
        p = !p.equals(DEFAULT_MULT) ? "%nproc=" + p + "\n" : "";
        String data = this.viewer.getData(this.select, "USER:%-2e %10.5x %10.5y %10.5z");
        this.editArea.setText(c + m + p + this.route + "\n\n" + "Title: Created by Jmol version " + Viewer.getJmolVersion() + "\n\n" + this.charge + " " + this.mult + "\n" + data + "\n");
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.saveButton) {
            this.save();
        } else if (event.getSource() == this.cancelButton) {
            this.cancel();
        } else if (event.getSource() == this.fileButton) {
            this.setFile();
        } else if (event.getSource() == this.methBox) {
            this.updateUI();
        }
    }

    public void stateChanged(ChangeEvent event) {
        if (event.getSource() == this.inputTabs) {
            this.tabSwitched();
        }
    }
}

