/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jmolpanel;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolStatusListener;
import org.jmol.api.JmolViewer;
import org.jmol.console.ScriptEditor;
import org.jmol.export.dialog.Dialog;
import org.jmol.export.history.HistoryFile;
import org.jmol.export.image.ImageCreator;
import org.jmol.i18n.GT;
import org.jmol.popup.JmolPopup;
import org.jmol.util.Logger;
import org.jmol.viewer.ScriptContext;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.Jmol;
import org.openscience.jmol.app.JmolApp;
import org.openscience.jmol.app.SplashInterface;
import org.openscience.jmol.app.jmolpanel.AboutDialog;
import org.openscience.jmol.app.jmolpanel.AppConsole;
import org.openscience.jmol.app.jmolpanel.AtomSetChooser;
import org.openscience.jmol.app.jmolpanel.ConsoleTextArea;
import org.openscience.jmol.app.jmolpanel.DisplayPanel;
import org.openscience.jmol.app.jmolpanel.FileDropper;
import org.openscience.jmol.app.jmolpanel.GaussianDialog;
import org.openscience.jmol.app.jmolpanel.GuiMap;
import org.openscience.jmol.app.jmolpanel.HelpDialog;
import org.openscience.jmol.app.jmolpanel.JmolResourceHandler;
import org.openscience.jmol.app.jmolpanel.MeasurementTable;
import org.openscience.jmol.app.jmolpanel.PovrayDialog;
import org.openscience.jmol.app.jmolpanel.PreferencesDialog;
import org.openscience.jmol.app.jmolpanel.RecentFilesDialog;
import org.openscience.jmol.app.jmolpanel.Splash;
import org.openscience.jmol.app.jmolpanel.StatusBar;
import org.openscience.jmol.app.jmolpanel.WhatsNewDialog;
import org.openscience.jmol.app.webexport.WebExport;

public class JmolPanel
extends JPanel
implements SplashInterface {
    public JmolViewer viewer;
    JmolAdapter modelAdapter;
    JmolApp jmolApp;
    DisplayPanel display;
    StatusBar status;
    protected GaussianDialog gaussianDialog;
    private PreferencesDialog preferencesDialog;
    MeasurementTable measurementTable;
    RecentFilesDialog recentFiles;
    public AppConsole appConsole;
    public ScriptEditor scriptEditor;
    public AtomSetChooser atomSetChooser;
    private ExecuteScriptAction executeScriptAction;
    protected JFrame frame;
    JmolPopup jmolpopup;
    String language;
    GuiMap guimap = new GuiMap();
    private static int numWindows = 0;
    private static Dimension screenSize = null;
    int startupWidth;
    int startupHeight;
    PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private static final String CONSOLE_WINDOW_NAME = "Console";
    private static final String EDITOR_WINDOW_NAME = "ScriptEditor";
    private static final String SCRIPT_WINDOW_NAME = "ScriptWindow";
    private static final String FILE_OPEN_WINDOW_NAME = "FileOpen";
    private static final String WEB_MAKER_WINDOW_NAME = "JmolWebPageMaker";
    protected SplashInterface splash;
    protected JFrame consoleframe;
    String appletContext;
    String menuStructure;
    String menuFile;
    static HistoryFile historyFile;
    private Hashtable commands;
    private Hashtable menuItems;
    private JMenuBar menubar;
    private JToolBar toolbar;
    private static final String newwinAction = "newwin";
    private static final String openAction = "open";
    private static final String openurlAction = "openurl";
    private static final String newAction = "new";
    private static final String exportActionProperty = "export";
    private static final String closeAction = "close";
    private static final String exitAction = "exit";
    private static final String aboutAction = "about";
    private static final String whatsnewAction = "whatsnew";
    private static final String uguideAction = "uguide";
    private static final String printActionProperty = "print";
    private static final String recentFilesAction = "recentFiles";
    private static final String povrayActionProperty = "povray";
    private static final String writeActionProperty = "write";
    private static final String editorAction = "editor";
    private static final String consoleAction = "console";
    private static final String toWebActionProperty = "toweb";
    private static final String atomsetchooserAction = "atomsetchooser";
    private static final String copyImageActionProperty = "copyImage";
    private static final String copyScriptActionProperty = "copyScript";
    private static final String pasteClipboardActionProperty = "pasteClipboard";
    private static final String gaussianAction = "gauss";
    private ExportAction exportAction = new ExportAction();
    private PovrayAction povrayAction = new PovrayAction();
    private ToWebAction toWebAction = new ToWebAction();
    private WriteAction writeAction = new WriteAction();
    private PrintAction printAction = new PrintAction();
    private CopyImageAction copyImageAction = new CopyImageAction();
    private CopyScriptAction copyScriptAction = new CopyScriptAction();
    private PasteClipboardAction pasteClipboardAction = new PasteClipboardAction();
    private ViewMeasurementTableAction viewMeasurementTableAction = new ViewMeasurementTableAction();
    int qualityJPG = -1;
    int qualityPNG = -1;
    String imageType;
    private Action[] defaultActions = new Action[]{new NewAction(), new NewwinAction(), new OpenAction(), new OpenUrlAction(), this.printAction, this.exportAction, new CloseAction(), new ExitAction(), this.copyImageAction, this.copyScriptAction, this.pasteClipboardAction, new AboutAction(), new WhatsNewAction(), new UguideAction(), new ConsoleAction(), new RecentFilesAction(), this.povrayAction, this.writeAction, this.toWebAction, new ScriptWindowAction(), new ScriptEditorAction(), new AtomSetChooserAction(), this.viewMeasurementTableAction, new GaussianAction()};
    static final String[] imageChoices;
    static final String[] imageExtensions;
    WebExport webExport;
    public static final String chemFileProperty = "chemFile";
    static /* synthetic */ Class class$java$net$URI;

    public JmolPanel(JmolApp jmolApp, Splash splash, JFrame frame, JmolPanel parent, int startupWidth, int startupHeight, String commandOptions, Point loc) {
        super(true);
        this.jmolApp = jmolApp;
        this.frame = frame;
        this.startupWidth = startupWidth;
        this.startupHeight = startupHeight;
        historyFile = jmolApp.historyFile;
        ++numWindows;
        try {
            this.say("history file is " + historyFile.getFile().getAbsolutePath());
        }
        catch (Exception e) {
            // empty catch block
        }
        frame.setTitle("Jmol");
        frame.getContentPane().setBackground(Color.lightGray);
        frame.getContentPane().setLayout(new BorderLayout());
        this.splash = splash;
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new BorderLayout());
        this.language = GT.getLanguage();
        this.status = (StatusBar)this.createStatusBar();
        this.say(GT._("Initializing 3D display..."));
        this.display = new DisplayPanel(this);
        this.appletContext = commandOptions;
        this.viewer = JmolViewer.allocateViewer(this.display, this.modelAdapter, null, null, null, this.appletContext, new MyStatusListener());
        this.display.setViewer(this.viewer);
        if (!jmolApp.haveDisplay) {
            return;
        }
        this.say(GT._("Initializing Preferences..."));
        this.preferencesDialog = new PreferencesDialog(this, frame, this.guimap, this.viewer);
        this.say(GT._("Initializing Recent Files..."));
        this.recentFiles = new RecentFilesDialog(frame);
        this.say(GT._("Initializing Script Window..."));
        this.appConsole = new AppConsole(this.viewer, frame);
        this.say(GT._("Initializing Script Editor..."));
        this.scriptEditor = new ScriptEditor(this.viewer, frame, this.appConsole);
        this.appConsole.setScriptEditor(this.scriptEditor);
        this.say(GT._("Initializing Measurements..."));
        this.measurementTable = new MeasurementTable(this.viewer, frame);
        this.say(GT._("Building Command Hooks..."));
        this.commands = new Hashtable();
        if (this.display != null) {
            Action[] actions = this.getActions();
            for (int i = 0; i < actions.length; ++i) {
                Action a = actions[i];
                this.commands.put(a.getValue("Name"), a);
            }
        }
        this.menuItems = new Hashtable();
        this.say(GT._("Building Menubar..."));
        this.executeScriptAction = new ExecuteScriptAction();
        this.menubar = this.createMenubar();
        this.add("North", this.menubar);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add("North", this.createToolbar());
        JPanel ip = new JPanel();
        ip.setLayout(new BorderLayout());
        ip.add("Center", this.display);
        panel.add("Center", ip);
        this.add("Center", panel);
        this.add("South", this.status);
        this.say(GT._("Starting display..."));
        this.display.start();
        if (this.menuFile != null) {
            this.menuStructure = this.viewer.getFileAsString(this.menuFile);
        }
        this.jmolpopup = JmolPopup.newJmolPopup(this.viewer, true, this.menuStructure, true);
        if (loc != null) {
            frame.setLocation(loc);
        } else if (parent != null) {
            Point location = parent.frame.getLocationOnScreen();
            int maxX = JmolPanel.screenSize.width - 50;
            int maxY = JmolPanel.screenSize.height - 50;
            location.x += 40;
            location.y += 40;
            if (location.x > maxX || location.y > maxY) {
                location.setLocation(0, 0);
            }
            frame.setLocation(location);
        }
        frame.getContentPane().add("Center", this);
        frame.addWindowListener(new AppCloser());
        frame.pack();
        frame.setSize(startupWidth, startupHeight);
        ImageIcon jmolIcon = JmolResourceHandler.getIconX("icon");
        Image iconImage = jmolIcon.getImage();
        frame.setIconImage(iconImage);
        if (this.appConsole != null) {
            historyFile.repositionWindow(SCRIPT_WINDOW_NAME, this.appConsole, 200, 100);
        }
        if (this.scriptEditor != null) {
            historyFile.repositionWindow(EDITOR_WINDOW_NAME, this.scriptEditor, 150, 50);
        }
        this.say(GT._("Setting up Drag-and-Drop..."));
        FileDropper dropper = new FileDropper();
        final JFrame f = frame;
        dropper.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                f.setCursor(Cursor.getPredefinedCursor(3));
                if (evt.getPropertyName().equals("filename")) {
                    String filename = evt.getNewValue().toString();
                    JmolPanel.this.viewer.openFileAsynchronously(filename);
                } else if (evt.getPropertyName().equals("inline")) {
                    String inline = evt.getNewValue().toString();
                    JmolPanel.this.viewer.openStringInline(inline);
                }
                f.setCursor(Cursor.getDefaultCursor());
            }
        });
        this.setDropTarget(new DropTarget(this, dropper));
        this.setEnabled(true);
        this.say(GT._("Launching main frame..."));
    }

    protected static void startJmol(JmolApp jmolApp) {
        Dialog.setupUIManager();
        JFrame jmolFrame = new JFrame();
        Jmol jmol = null;
        try {
            if (jmolApp.jmolPosition != null) {
                jmolFrame.setLocation(jmolApp.jmolPosition);
            }
            jmol = JmolPanel.getJmol(jmolApp, jmolFrame);
            jmolApp.startViewer(jmol.viewer, jmol.splash);
        }
        catch (Throwable t) {
            System.out.println("uncaught exception: " + t);
            t.printStackTrace();
        }
        if (jmolApp.haveConsole) {
            jmol.consoleframe = new JFrame(GT._("Jmol Console"));
            jmol.consoleframe.setIconImage(jmol.frame.getIconImage());
            try {
                final ConsoleTextArea consoleTextArea = new ConsoleTextArea(true);
                consoleTextArea.setFont(Font.decode("monospaced"));
                jmol.consoleframe.getContentPane().add((Component)new JScrollPane(consoleTextArea), "Center");
                if (Boolean.getBoolean("clearConsoleButton")) {
                    JButton buttonClear = new JButton(GT._("Clear"));
                    buttonClear.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            consoleTextArea.setText("");
                        }
                    });
                    jmol.consoleframe.getContentPane().add((Component)buttonClear, "South");
                }
            }
            catch (IOException e) {
                JTextArea errorTextArea = new JTextArea();
                errorTextArea.setFont(Font.decode("monospaced"));
                jmol.consoleframe.getContentPane().add((Component)new JScrollPane(errorTextArea), "Center");
                errorTextArea.append(GT._("Could not create ConsoleTextArea: ") + e);
            }
            JmolPanel.setWindow(CONSOLE_WINDOW_NAME, jmol.consoleframe, jmol);
        }
    }

    public static Jmol getJmol(JmolApp jmolApp, JFrame frame) {
        String commandOptions = jmolApp.commandOptions;
        Splash splash = null;
        if (jmolApp.haveDisplay && jmolApp.splashEnabled) {
            ImageIcon splash_image = JmolResourceHandler.getIconX("splash");
            if (!jmolApp.isSilent) {
                Logger.info("splash_image=" + splash_image);
            }
            splash = new Splash((Frame)(commandOptions != null && commandOptions.indexOf("-L") >= 0 ? null : frame), splash_image);
            splash.setCursor(new Cursor(3));
            splash.showStatus(GT._("Creating main window..."));
            splash.showStatus(GT._("Initializing Swing..."));
        }
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exc) {
            System.err.println("Error loading L&F: " + exc);
        }
        screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (splash != null) {
            splash.showStatus(GT._("Initializing Jmol..."));
        }
        Jmol window = new Jmol(jmolApp, splash, frame, null, jmolApp.startupWidth, jmolApp.startupHeight, commandOptions, null);
        if (jmolApp.haveDisplay) {
            frame.setVisible(true);
        }
        return window;
    }

    private static void setWindow(String name, JFrame frame, JmolPanel jmol) {
        Point location = jmol.frame.getLocation();
        Dimension size = jmol.frame.getSize();
        Dimension consoleSize = historyFile.getWindowSize(name);
        Point consolePosition = historyFile.getWindowPosition(name);
        if (consoleSize != null && consolePosition != null) {
            frame.setBounds(consolePosition.x, consolePosition.y, consoleSize.width, consoleSize.height);
        } else {
            frame.setBounds(location.x, location.y + size.height, size.width, 200);
        }
        Boolean consoleVisible = historyFile.getWindowVisibility(name);
        if (consoleVisible != null && consoleVisible.equals(Boolean.TRUE)) {
            frame.setVisible(true);
        }
    }

    public void showStatus(String message) {
        this.splash.showStatus(message);
    }

    void report(String str) {
        if (this.jmolApp.isSilent) {
            return;
        }
        Logger.info(str);
    }

    private void say(String message) {
        if (this.jmolApp.haveDisplay) {
            if (this.splash == null) {
                this.report(message);
            } else {
                this.splash.showStatus(message);
            }
        }
    }

    public Action[] getActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.addAll(Arrays.asList(this.defaultActions));
        actions.addAll(Arrays.asList(this.display.getActions()));
        actions.addAll(Arrays.asList(this.preferencesDialog.getActions()));
        return actions.toArray(new Action[0]);
    }

    void doClose() {
        if (historyFile != null && this.display != null) {
            this.jmolApp.border.x = this.getFrame().getWidth() - this.display.dimSize.width;
            this.jmolApp.border.y = this.getFrame().getHeight() - this.display.dimSize.height;
            historyFile.addWindowInfo("Jmol", this.frame, this.jmolApp.border);
        }
        this.dispose(this.frame);
    }

    private void dispose(JFrame f) {
        if (historyFile != null && this.appConsole != null) {
            historyFile.addWindowInfo(SCRIPT_WINDOW_NAME, this.appConsole, null);
        }
        if (historyFile != null && this.scriptEditor != null) {
            historyFile.addWindowInfo(EDITOR_WINDOW_NAME, this.scriptEditor, null);
        }
        if (historyFile != null && this.webExport != null) {
            WebExport.saveHistory();
            WebExport.cleanUp();
        }
        if (numWindows <= 1) {
            this.report(GT._("Closing Jmol..."));
            System.exit(0);
        } else {
            --numWindows;
            this.viewer.setModeMouse(-1);
            try {
                f.dispose();
                if (this.appConsole != null) {
                    this.appConsole.dispose();
                }
                if (this.scriptEditor != null) {
                    this.scriptEditor.dispose();
                }
            }
            catch (Exception e) {
                System.out.println("frame disposal exception");
            }
        }
    }

    protected void setupNewFrame(String state) {
        JFrame newFrame = new JFrame();
        JFrame f = this.frame;
        Jmol j = new Jmol(this.jmolApp, null, newFrame, (Jmol)this, this.startupWidth, this.startupHeight, "", state == null ? null : f.getLocationOnScreen());
        newFrame.setVisible(true);
        if (state != null) {
            this.dispose(f);
            j.viewer.evalStringQuiet(state);
        }
    }

    protected Frame getFrame() {
        for (Container p = this.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof Frame)) continue;
            return (Frame)p;
        }
        return null;
    }

    protected JMenuItem createMenuItem(String cmd) {
        JMenuItem mi = cmd.endsWith("Check") ? this.guimap.newJCheckBoxMenuItem(cmd, false) : this.guimap.newJMenuItem(cmd);
        ImageIcon f = JmolResourceHandler.getIconX(cmd + "Image");
        if (f != null) {
            mi.setHorizontalTextPosition(4);
            mi.setIcon(f);
        }
        if (cmd.endsWith("Script")) {
            mi.setActionCommand(JmolResourceHandler.getStringX(cmd));
            mi.addActionListener(this.executeScriptAction);
        } else {
            mi.setActionCommand(cmd);
            Action a = this.getAction(cmd);
            if (a != null) {
                mi.addActionListener(a);
                a.addPropertyChangeListener(new ActionChangedListener(mi));
                mi.setEnabled(a.isEnabled());
            } else {
                mi.setEnabled(false);
            }
        }
        this.menuItems.put(cmd, mi);
        return mi;
    }

    protected JMenuItem getMenuItem(String cmd) {
        return (JMenuItem)this.menuItems.get(cmd);
    }

    protected Action getAction(String cmd) {
        return (Action)this.commands.get(cmd);
    }

    private Component createToolbar() {
        this.toolbar = new JToolBar();
        String[] tool1Keys = this.tokenize(JmolResourceHandler.getStringX("toolbar"));
        for (int i = 0; i < tool1Keys.length; ++i) {
            if (tool1Keys[i].equals("-")) {
                this.toolbar.addSeparator();
                continue;
            }
            this.toolbar.add(this.createTool(tool1Keys[i]));
        }
        this.toolbar.add(Box.createHorizontalGlue());
        return this.toolbar;
    }

    protected Component createTool(String key) {
        return this.createToolbarButton(key);
    }

    protected AbstractButton createToolbarButton(String key) {
        boolean isToggle;
        ImageIcon ii = JmolResourceHandler.getIconX(key + "Image");
        AbstractButton b = new JButton(ii);
        String isToggleString = JmolResourceHandler.getStringX(key + "Toggle");
        if (isToggleString != null && (isToggle = Boolean.valueOf(isToggleString).booleanValue())) {
            b = new JToggleButton(ii);
            if (key.equals("rotate")) {
                this.display.buttonRotate = (JToggleButton)b;
            }
            this.display.toolbarButtonGroup.add(b);
            String isSelectedString = JmolResourceHandler.getStringX(key + "ToggleSelected");
            if (isSelectedString != null) {
                boolean isSelected = Boolean.valueOf(isSelectedString);
                b.setSelected(isSelected);
            }
        }
        b.setRequestFocusEnabled(false);
        b.setMargin(new Insets(1, 1, 1, 1));
        Action a = null;
        String actionCommand = null;
        if (key.endsWith("Script")) {
            actionCommand = JmolResourceHandler.getStringX(key);
            a = this.executeScriptAction;
        } else {
            actionCommand = key;
            a = this.getAction(key);
        }
        if (a != null) {
            b.setActionCommand(actionCommand);
            b.addActionListener(a);
            a.addPropertyChangeListener(new ActionChangedListener(b));
            b.setEnabled(a.isEnabled());
        } else {
            b.setEnabled(false);
        }
        String tip = this.guimap.getLabel(key + "Tip");
        if (tip != null) {
            b.setToolTipText(tip);
        }
        return b;
    }

    protected String[] tokenize(String input) {
        Vector<String> v = new Vector<String>();
        StringTokenizer t = new StringTokenizer(input);
        while (t.hasMoreTokens()) {
            v.addElement(t.nextToken());
        }
        String[] cmd = new String[v.size()];
        for (int i = 0; i < cmd.length; ++i) {
            cmd[i] = (String)v.elementAt(i);
        }
        return cmd;
    }

    protected Component createStatusBar() {
        return new StatusBar();
    }

    protected JMenuBar createMenubar() {
        JMenuBar mb = new JMenuBar();
        this.addNormalMenuBar(mb);
        this.addMacrosMenuBar(mb);
        mb.add(Box.createHorizontalGlue());
        this.addHelpMenuBar(mb);
        return mb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addMacrosMenuBar(JMenuBar menuBar) {
        JMenu macroMenu = this.guimap.newJMenu("macros");
        File macroDir = new File(System.getProperty("user.home") + System.getProperty("file.separator") + ".jmol" + System.getProperty("file.separator") + "macros");
        this.report("User macros dir: " + macroDir);
        this.report("       exists: " + macroDir.exists());
        this.report("  isDirectory: " + macroDir.isDirectory());
        if (macroDir.exists() && macroDir.isDirectory()) {
            File[] macros = macroDir.listFiles();
            for (int i = 0; i < macros.length; ++i) {
                String macroName = macros[i].getName();
                if (!macroName.endsWith(".macro")) continue;
                if (Logger.debugging) {
                    Logger.debug("Possible macro found: " + macroName);
                }
                FileInputStream macro = null;
                try {
                    macro = new FileInputStream(macros[i]);
                    Properties macroProps = new Properties();
                    macroProps.load(macro);
                    String macroTitle = macroProps.getProperty("Title");
                    String macroScript = macroProps.getProperty("Script");
                    JMenuItem mi = new JMenuItem(macroTitle);
                    mi.setActionCommand(macroScript);
                    mi.addActionListener(this.executeScriptAction);
                    macroMenu.add(mi);
                    continue;
                }
                catch (IOException exception) {
                    System.err.println("Could not load macro file: ");
                    System.err.println(exception);
                    continue;
                }
                finally {
                    if (macro != null) {
                        try {
                            macro.close();
                        }
                        catch (IOException e) {}
                        macro = null;
                    }
                }
            }
        }
        menuBar.add(macroMenu);
    }

    protected void addNormalMenuBar(JMenuBar menuBar) {
        String[] menuKeys = this.tokenize(JmolResourceHandler.getStringX("menubar"));
        for (int i = 0; i < menuKeys.length; ++i) {
            if (menuKeys[i].equals("-")) {
                menuBar.add(Box.createHorizontalGlue());
                continue;
            }
            JMenu m = this.createMenu(menuKeys[i]);
            if (m == null) continue;
            menuBar.add(m);
        }
    }

    protected void addHelpMenuBar(JMenuBar menuBar) {
        String menuKey = "help";
        JMenu m = this.createMenu(menuKey);
        if (m != null) {
            menuBar.add(m);
        }
    }

    protected JMenu createMenu(String key) {
        String[] itemKeys = this.tokenize(JmolResourceHandler.getStringX(key));
        JMenu menu = this.guimap.newJMenu(key);
        ImageIcon f = JmolResourceHandler.getIconX(key + "Image");
        if (f != null) {
            menu.setHorizontalTextPosition(4);
            menu.setIcon(f);
        }
        for (int i = 0; i < itemKeys.length; ++i) {
            String item = itemKeys[i];
            if (item.equals("-")) {
                menu.addSeparator();
                continue;
            }
            if (item.endsWith("Menu")) {
                JMenu pm = "recentFilesMenu".equals(item) ? this.createMenu(item) : this.createMenu(item);
                menu.add(pm);
                continue;
            }
            JMenuItem mi = this.createMenuItem(item);
            menu.add(mi);
        }
        menu.addMenuListener(this.display.getMenuListener());
        return menu;
    }

    public void print() {
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintable(this.display);
        if (job.printDialog()) {
            try {
                job.print();
            }
            catch (PrinterException e) {
                Logger.error("Error while printing", e);
            }
        }
    }

    String createImageStatus(String fileName, String type, Object text_or_bytes, int quality) {
        String msg = (String)new ImageCreator(this.viewer).createImage(fileName, type, text_or_bytes, quality);
        if (msg == null || msg.startsWith("OK")) {
            return msg;
        }
        if (this.status != null) {
            this.status.setStatus(1, GT._("IO Exception:"));
            this.status.setStatus(2, msg);
        }
        return msg;
    }

    public static File getUserDirectory() {
        String dir = System.getProperty("user.dir");
        return dir == null ? null : new File(System.getProperty("user.dir"));
    }

    String getOpenFileNameFromDialog(String fileName) {
        return new Dialog().getOpenFileNameFromDialog(this.appletContext, this.viewer, fileName, historyFile, FILE_OPEN_WINDOW_NAME, fileName == null);
    }

    void showEditor(boolean showEditor, String text) {
        if (this.scriptEditor == null) {
            return;
        }
        if (showEditor) {
            this.scriptEditor.setVisible(true);
            if (text != null) {
                this.scriptEditor.output(text);
            }
        } else {
            this.scriptEditor.setVisible(false);
        }
    }

    static {
        imageChoices = new String[]{"JPEG", "PNG", "GIF", "PPM", "PDF"};
        imageExtensions = new String[]{"jpg", "png", "gif", "ppm", "pdf"};
    }

    class ExecuteScriptAction
    extends AbstractAction {
        public ExecuteScriptAction() {
            super("executeScriptAction");
        }

        public void actionPerformed(ActionEvent e) {
            String script = e.getActionCommand();
            if (script.indexOf("#showMeasurementTable") >= 0) {
                JmolPanel.this.measurementTable.activate();
            }
            JmolPanel.this.viewer.evalStringQuiet(script);
        }
    }

    class MyStatusListener
    implements JmolStatusListener {
        MyStatusListener() {
        }

        public boolean notifyEnabled(int type) {
            switch (type) {
                case 0: 
                case 1: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 11: 
                case 14: {
                    return true;
                }
            }
            return false;
        }

        public void notifyCallback(int type, Object[] data) {
            String strInfo = data == null || data[1] == null ? null : data[1].toString();
            switch (type) {
                case 14: {
                    JmolPanel.this.showEditor(true, strInfo);
                    return;
                }
                case 5: {
                    this.notifyFileLoaded(strInfo, (String)data[2], (String)data[3], (String)data[4]);
                    break;
                }
                case 0: {
                    int[] iData = (int[])data[1];
                    this.notifyFrameChanged(iData[0], iData[1], iData[2]);
                    break;
                }
                case 1: {
                    this.sendConsoleEcho(strInfo);
                    break;
                }
                case 6: {
                    String status = (String)data[3];
                    if (status.indexOf("Picked") >= 0) {
                        this.notifyAtomPicked(strInfo);
                    } else if (status.indexOf("Completed") >= 0) {
                        this.sendConsoleEcho(strInfo.substring(strInfo.lastIndexOf(",") + 2, strInfo.length() - 1));
                    }
                    if (status.indexOf("Pending") >= 0) break;
                    JmolPanel.this.measurementTable.updateTables();
                    break;
                }
                case 7: {
                    this.sendConsoleMessage(data == null ? null : strInfo);
                    break;
                }
                case 9: {
                    this.notifyAtomPicked(strInfo);
                    break;
                }
                case 11: {
                    int msWalltime = (Integer)data[3];
                    if (JmolPanel.this.appConsole != null && msWalltime == 0) {
                        JmolPanel.this.appConsole.sendConsoleMessage(strInfo);
                        if (data[2] != null && JmolPanel.this.display != null) {
                            JmolPanel.this.display.status.setStatus(1, (String)data[2]);
                        }
                    }
                    if (JmolPanel.this.scriptEditor == null) break;
                    if (msWalltime > 0) {
                        JmolPanel.this.scriptEditor.notifyScriptTermination();
                        break;
                    }
                    if (msWalltime < 0) {
                        if (msWalltime != -2) break;
                        JmolPanel.this.scriptEditor.notifyScriptStart();
                        break;
                    }
                    if ((!JmolPanel.this.scriptEditor.isVisible() || ((String)data[2]).length() <= 0) && data[4] == null) break;
                    System.out.println("Jmol notifyContext " + data[1]);
                    JmolPanel.this.scriptEditor.notifyContext((ScriptContext)JmolPanel.this.viewer.getProperty("DATA_API", "scriptContext", null), data);
                    break;
                }
            }
        }

        public void setCallbackFunction(String callbackType, String callbackFunction) {
            if (callbackType.equalsIgnoreCase("menu")) {
                JmolPanel.this.menuStructure = callbackFunction;
                JmolPanel.this.menuFile = null;
                JmolPanel.this.setupNewFrame(JmolPanel.this.viewer.getStateInfo());
                return;
            }
            if (callbackType.equalsIgnoreCase("language")) {
                new GT(callbackFunction);
                JmolPanel.this.language = GT.getLanguage();
                Dialog.setupUIManager();
                if (JmolPanel.this.webExport != null) {
                    WebExport.saveHistory();
                    WebExport.dispose();
                    JmolPanel.this.webExport = WebExport.createAndShowGUI(JmolPanel.this.viewer, historyFile, JmolPanel.WEB_MAKER_WINDOW_NAME);
                }
                JmolPanel.this.setupNewFrame(JmolPanel.this.viewer.getStateInfo());
            }
        }

        public String eval(String strEval) {
            if (strEval.startsWith("_GET_MENU")) {
                return JmolPanel.this.jmolpopup == null ? "" : JmolPanel.this.jmolpopup.getMenu("Jmol version " + Viewer.getJmolVersion() + "|" + strEval);
            }
            this.sendConsoleMessage("javascript: " + strEval);
            return "# 'eval' is implemented only for the applet.";
        }

        public String createImage(String fileName, String type, Object text_or_bytes, int quality) {
            return JmolPanel.this.createImageStatus(fileName, type, text_or_bytes, quality);
        }

        private void notifyAtomPicked(String info) {
            if (JmolPanel.this.appConsole != null) {
                JmolPanel.this.appConsole.sendConsoleMessage(info);
                JmolPanel.this.appConsole.sendConsoleMessage("\n");
            }
        }

        private void notifyFileLoaded(String fullPathName, String fileName, String modelName, String errorMsg) {
            if (errorMsg != null) {
                return;
            }
            if (!JmolPanel.this.jmolApp.haveDisplay) {
                return;
            }
            String title = "Jmol";
            if (fullPathName == null) {
                if (fileName != null && JmolPanel.this.appConsole != null) {
                    JmolPanel.this.appConsole.undoClear();
                }
            } else {
                if (modelName != null && fileName != null) {
                    title = fileName + " - " + modelName;
                } else if (fileName != null) {
                    title = fileName;
                } else if (modelName != null) {
                    title = modelName;
                }
                JmolPanel.this.recentFiles.notifyFileOpen(fullPathName);
            }
            JmolPanel.this.frame.setTitle(title);
            if (JmolPanel.this.atomSetChooser == null) {
                JmolPanel.this.atomSetChooser = new AtomSetChooser(JmolPanel.this.viewer, JmolPanel.this.frame);
                JmolPanel.this.pcs.addPropertyChangeListener(JmolPanel.chemFileProperty, JmolPanel.this.atomSetChooser);
            }
            JmolPanel.this.pcs.firePropertyChange(JmolPanel.chemFileProperty, null, null);
        }

        private void notifyFrameChanged(int frameNo, int file, int model) {
            boolean isAnimationRunning;
            boolean bl = isAnimationRunning = frameNo <= -2;
            if (JmolPanel.this.display != null) {
                JmolPanel.this.display.status.setStatus(1, file + "." + model);
            }
            if (JmolPanel.this.jmolpopup == null || isAnimationRunning) {
                return;
            }
            JmolPanel.this.jmolpopup.updateComputedMenus();
        }

        private void sendConsoleEcho(String strEcho) {
            if (JmolPanel.this.appConsole != null) {
                JmolPanel.this.appConsole.sendConsoleEcho(strEcho);
            }
        }

        private void sendConsoleMessage(String strStatus) {
            if (JmolPanel.this.appConsole != null) {
                JmolPanel.this.appConsole.sendConsoleMessage(strStatus);
            }
        }

        public void handlePopupMenu(int x, int y) {
            if (!JmolPanel.this.language.equals(GT.getLanguage())) {
                JmolPanel.this.jmolpopup = JmolPopup.newJmolPopup(JmolPanel.this.viewer, true, JmolPanel.this.menuStructure, true);
                JmolPanel.this.language = GT.getLanguage();
            }
            JmolPanel.this.jmolpopup.show(x, y);
        }

        public void showUrl(String url) {
            try {
                Class<?> c = Class.forName("java.awt.Desktop");
                Method getDesktop = c.getMethod("getDesktop", new Class[0]);
                Object deskTop = getDesktop.invoke(null, (Object[])new Class[0]);
                Method browse = c.getMethod("browse", class$java$net$URI == null ? (class$java$net$URI = JmolPanel.class$("java.net.URI")) : class$java$net$URI);
                Object[] arguments = new Object[]{new URI(url)};
                browse.invoke(deskTop, arguments);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                if (JmolPanel.this.appConsole != null) {
                    JmolPanel.this.appConsole.sendConsoleMessage("Java 6 Desktop.browse() capability unavailable. Could not open " + url);
                }
                Logger.error("Java 6 Desktop.browse() capability unavailable. Could not open " + url);
            }
        }

        public void showConsole(boolean showConsole) {
            if (JmolPanel.this.appConsole == null) {
                return;
            }
            if (showConsole) {
                JmolPanel.this.appConsole.setVisible(true);
            } else {
                JmolPanel.this.appConsole.setVisible(false);
            }
        }

        public float[][] functionXY(String functionName, int nX, int nY) {
            nX = Math.abs(nX);
            nY = Math.abs(nY);
            float[][] f = new float[nX][nY];
            int i = nX;
            while (--i >= 0) {
                int j = nY;
                while (--j >= 0) {
                    float x = (float)i / 15.0f - 1.0f;
                    float y = (float)j / 15.0f - 1.0f;
                    f[i][j] = (float)Math.sqrt(x * x + y);
                    if (Float.isNaN(f[i][j])) {
                        f[i][j] = -((float)Math.sqrt(-x * x - y));
                    }
                    System.out.println(" functionXY " + i + " " + j + " " + f[i][j]);
                }
            }
            return f;
        }

        public float[][][] functionXYZ(String functionName, int nX, int nY, int nZ) {
            nX = Math.abs(nX);
            nY = Math.abs(nY);
            nZ = Math.abs(nZ);
            float[][][] f = new float[nX][nY][nZ];
            int i = nX;
            while (--i >= 0) {
                int j = nY;
                while (--j >= 0) {
                    int k = nZ;
                    while (--k >= 0) {
                        float x = (float)i / ((float)(nX - 1) / 2.0f) - 1.0f;
                        float y = (float)j / ((float)(nY - 1) / 2.0f) - 1.0f;
                        float z = (float)k / ((float)(nZ - 1) / 2.0f) - 1.0f;
                        f[i][j][k] = x * x + y - z * z;
                    }
                }
            }
            return f;
        }

        public Hashtable getRegistryInfo() {
            return null;
        }

        public String dialogAsk(String type, String fileName) {
            if (type.equals("load")) {
                return JmolPanel.this.getOpenFileNameFromDialog(fileName);
            }
            if (type.equals("save")) {
                return new Dialog().getSaveFileNameFromDialog(JmolPanel.this.viewer, fileName, null);
            }
            if (type.equals("saveImage")) {
                Dialog sd = new Dialog();
                fileName = sd.getImageFileNameFromDialog(JmolPanel.this.viewer, fileName, JmolPanel.this.imageType, imageChoices, imageExtensions, JmolPanel.this.qualityJPG, JmolPanel.this.qualityPNG);
                JmolPanel.this.imageType = sd.getType();
                JmolPanel.this.qualityJPG = sd.getQuality("JPG");
                JmolPanel.this.qualityPNG = sd.getQuality("PNG");
                return fileName;
            }
            return null;
        }
    }

    class ViewMeasurementTableAction
    extends AbstractAction {
        public ViewMeasurementTableAction() {
            super("viewMeasurementTable");
        }

        public void actionPerformed(ActionEvent e) {
            JmolPanel.this.measurementTable.activate();
        }
    }

    class ToWebAction
    extends AbstractAction {
        public ToWebAction() {
            super(JmolPanel.toWebActionProperty);
        }

        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ((ToWebAction)ToWebAction.this).JmolPanel.this.webExport = WebExport.createAndShowGUI(((ToWebAction)ToWebAction.this).JmolPanel.this.viewer, historyFile, JmolPanel.WEB_MAKER_WINDOW_NAME);
                }
            });
        }
    }

    class WriteAction
    extends AbstractAction {
        public WriteAction() {
            super(JmolPanel.writeActionProperty);
        }

        public void actionPerformed(ActionEvent e) {
            String fileName = new Dialog().getSaveFileNameFromDialog(JmolPanel.this.viewer, null, "SPT");
            if (fileName != null) {
                Logger.info(JmolPanel.this.createImageStatus(fileName, "SPT", JmolPanel.this.viewer.getStateInfo(), Integer.MIN_VALUE));
            }
        }
    }

    class PovrayAction
    extends AbstractAction {
        public PovrayAction() {
            super(JmolPanel.povrayActionProperty);
        }

        public void actionPerformed(ActionEvent e) {
            new PovrayDialog(JmolPanel.this.frame, JmolPanel.this.viewer);
        }
    }

    class AtomSetChooserAction
    extends AbstractAction {
        public AtomSetChooserAction() {
            super(JmolPanel.atomsetchooserAction);
        }

        public void actionPerformed(ActionEvent e) {
            JmolPanel.this.atomSetChooser.setVisible(true);
        }
    }

    class ScriptEditorAction
    extends AbstractAction {
        public ScriptEditorAction() {
            super(JmolPanel.editorAction);
        }

        public void actionPerformed(ActionEvent e) {
            if (JmolPanel.this.scriptEditor != null) {
                JmolPanel.this.scriptEditor.setVisible(true);
            }
        }
    }

    class ScriptWindowAction
    extends AbstractAction {
        public ScriptWindowAction() {
            super(JmolPanel.consoleAction);
        }

        public void actionPerformed(ActionEvent e) {
            if (JmolPanel.this.appConsole != null) {
                JmolPanel.this.appConsole.setVisible(true);
            }
        }
    }

    class RecentFilesAction
    extends AbstractAction {
        public RecentFilesAction() {
            super(JmolPanel.recentFilesAction);
        }

        public void actionPerformed(ActionEvent e) {
            JmolPanel.this.recentFiles.setVisible(true);
            String selection = JmolPanel.this.recentFiles.getFile();
            if (selection != null) {
                JmolPanel.this.viewer.openFileAsynchronously(selection);
            }
        }
    }

    class ExportAction
    extends AbstractAction {
        ExportAction() {
            super(JmolPanel.exportActionProperty);
        }

        public void actionPerformed(ActionEvent e) {
            Dialog sd = new Dialog();
            String fileName = sd.getImageFileNameFromDialog(JmolPanel.this.viewer, null, JmolPanel.this.imageType, imageChoices, imageExtensions, JmolPanel.this.qualityJPG, JmolPanel.this.qualityPNG);
            if (fileName == null) {
                return;
            }
            JmolPanel.this.qualityJPG = sd.getQuality("JPG");
            JmolPanel.this.qualityPNG = sd.getQuality("PNG");
            JmolPanel.this.imageType = sd.getType();
            String sType = JmolPanel.this.imageType;
            if (sType == null) {
                sType = fileName;
                int i = sType.lastIndexOf(".");
                if (i < 0) {
                    return;
                }
                sType = sType.substring(i + 1).toUpperCase();
            }
            String msg = sType.equals("PDF") ? this.createPdfDocument(new File(fileName)) : JmolPanel.this.createImageStatus(fileName, sType, null, sd.getQuality(sType));
            Logger.info(msg);
        }

        private String createPdfDocument(File file) {
            Document document = new Document();
            try {
                PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream(file));
                document.open();
                int w = JmolPanel.this.display.getWidth();
                int h = JmolPanel.this.display.getHeight();
                PdfContentByte cb = writer.getDirectContent();
                PdfTemplate tp = cb.createTemplate(w, h);
                Graphics2D g2 = tp.createGraphics(w, h);
                g2.setStroke(new BasicStroke(0.1f));
                tp.setWidth(w);
                tp.setHeight(h);
                JmolPanel.this.display.print(g2);
                g2.dispose();
                cb.addTemplate(tp, 72.0f, 720 - h);
            }
            catch (DocumentException de) {
                return de.getMessage();
            }
            catch (IOException ioe) {
                return ioe.getMessage();
            }
            document.close();
            return "OK PDF " + file.length() + " " + file.getAbsolutePath();
        }
    }

    class ExitAction
    extends AbstractAction {
        ExitAction() {
            super(JmolPanel.exitAction);
        }

        public void actionPerformed(ActionEvent e) {
            JmolPanel.this.doClose();
        }
    }

    class NewAction
    extends AbstractAction {
        NewAction() {
            super(JmolPanel.newAction);
        }

        NewAction(String nm) {
            super(nm);
        }

        public void actionPerformed(ActionEvent e) {
            JmolPanel.this.revalidate();
        }
    }

    class OpenUrlAction
    extends NewAction {
        String title;
        String prompt;

        OpenUrlAction() {
            super(JmolPanel.openurlAction);
            this.title = GT._("Open URL");
            this.prompt = GT._("Enter URL of molecular model");
        }

        public void actionPerformed(ActionEvent e) {
            String url = JOptionPane.showInputDialog(JmolPanel.this.frame, this.prompt, this.title, -1);
            if (url != null) {
                if (url.indexOf("://") == -1) {
                    url = "http://" + url;
                }
                JmolPanel.this.viewer.openFileAsynchronously(url);
            }
        }
    }

    class OpenAction
    extends NewAction {
        OpenAction() {
            super(JmolPanel.openAction);
        }

        public void actionPerformed(ActionEvent e) {
            String fileName = JmolPanel.this.getOpenFileNameFromDialog(null);
            if (fileName == null) {
                return;
            }
            if (fileName.startsWith("load append")) {
                JmolPanel.this.viewer.scriptWait(fileName);
            } else {
                JmolPanel.this.viewer.openFileAsynchronously(fileName);
            }
        }
    }

    class PrintAction
    extends AbstractAction {
        public PrintAction() {
            super(JmolPanel.printActionProperty);
        }

        public void actionPerformed(ActionEvent e) {
            JmolPanel.this.print();
        }
    }

    class CopyScriptAction
    extends AbstractAction {
        public CopyScriptAction() {
            super(JmolPanel.copyScriptActionProperty);
        }

        public void actionPerformed(ActionEvent e) {
            new ImageCreator(JmolPanel.this.viewer).clipImage((String)JmolPanel.this.viewer.getProperty("string", "stateInfo", null));
        }
    }

    class CopyImageAction
    extends AbstractAction {
        public CopyImageAction() {
            super(JmolPanel.copyImageActionProperty);
        }

        public void actionPerformed(ActionEvent e) {
            new ImageCreator(JmolPanel.this.viewer).clipImage(null);
        }
    }

    class PasteClipboardAction
    extends AbstractAction {
        public PasteClipboardAction() {
            super(JmolPanel.pasteClipboardActionProperty);
        }

        public void actionPerformed(ActionEvent e) {
            String str = ImageCreator.getClipboardTextStatic();
            if (str != null && str.length() > 0) {
                JmolPanel.this.viewer.loadInline(str, false);
            }
        }
    }

    class UguideAction
    extends AbstractAction {
        public UguideAction() {
            super(JmolPanel.uguideAction);
        }

        public void actionPerformed(ActionEvent e) {
            new HelpDialog(JmolPanel.this.frame).setVisible(true);
        }
    }

    class NewwinAction
    extends AbstractAction {
        NewwinAction() {
            super(JmolPanel.newwinAction);
        }

        public void actionPerformed(ActionEvent e) {
            JFrame newFrame = new JFrame();
            new Jmol(JmolPanel.this.jmolApp, null, newFrame, (Jmol)JmolPanel.this, JmolPanel.this.startupWidth, JmolPanel.this.startupHeight, "", null);
            newFrame.setVisible(true);
        }
    }

    class GaussianAction
    extends AbstractAction {
        public GaussianAction() {
            super(JmolPanel.gaussianAction);
        }

        public void actionPerformed(ActionEvent e) {
            if (JmolPanel.this.gaussianDialog == null) {
                JmolPanel.this.gaussianDialog = new GaussianDialog(JmolPanel.this.frame, JmolPanel.this.viewer);
            }
            JmolPanel.this.gaussianDialog.setVisible(true);
        }
    }

    class WhatsNewAction
    extends AbstractAction {
        public WhatsNewAction() {
            super(JmolPanel.whatsnewAction);
        }

        public void actionPerformed(ActionEvent e) {
            WhatsNewDialog wnd = new WhatsNewDialog(JmolPanel.this.frame);
            wnd.setVisible(true);
        }
    }

    class AboutAction
    extends AbstractAction {
        public AboutAction() {
            super(JmolPanel.aboutAction);
        }

        public void actionPerformed(ActionEvent e) {
            AboutDialog ad = new AboutDialog(JmolPanel.this.frame);
            ad.setVisible(true);
        }
    }

    class ConsoleAction
    extends AbstractAction {
        public ConsoleAction() {
            super("jconsole");
        }

        public void actionPerformed(ActionEvent e) {
            if (JmolPanel.this.consoleframe != null) {
                JmolPanel.this.consoleframe.setVisible(true);
            }
        }
    }

    class CloseAction
    extends AbstractAction {
        CloseAction() {
            super(JmolPanel.closeAction);
        }

        public void actionPerformed(ActionEvent e) {
            JmolPanel.this.frame.setVisible(false);
            JmolPanel.this.doClose();
        }
    }

    private static class ActionChangedListener
    implements PropertyChangeListener {
        AbstractButton button;

        ActionChangedListener(AbstractButton button) {
            this.button = button;
        }

        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (e.getPropertyName().equals("Name")) {
                String text = (String)e.getNewValue();
                if (this.button.getText() != null) {
                    this.button.setText(text);
                }
            } else if (propertyName.equals("enabled")) {
                Boolean enabledState = (Boolean)e.getNewValue();
                this.button.setEnabled(enabledState);
            }
        }
    }

    protected final class AppCloser
    extends WindowAdapter {
        protected AppCloser() {
        }

        public void windowClosing(WindowEvent e) {
            JmolPanel.this.doClose();
        }
    }
}

