/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jmolpanel;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jmol.i18n.GT;
import org.openscience.jmol.app.jmolpanel.JmolPanel;

class RecentFilesDialog
extends JDialog
implements ActionListener,
WindowListener {
    String selectedFileName = null;
    private static final int MAX_FILES = 10;
    private JButton okButton;
    private JButton cancelButton;
    String[] files = new String[10];
    JList fileList;
    Properties props = new Properties();

    public RecentFilesDialog(Frame boss) {
        super(boss, GT._("Recent Files"), true);
        this.getFiles();
        this.getContentPane().setLayout(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        this.okButton = new JButton(GT._("Open"));
        this.okButton.addActionListener(this);
        buttonPanel.add(this.okButton);
        this.cancelButton = new JButton(GT._("Cancel"));
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.cancelButton);
        this.getContentPane().add("South", buttonPanel);
        this.fileList = new JList<String>(this.files);
        this.fileList.setSelectedIndex(0);
        this.fileList.setSelectionMode(0);
        MouseAdapter dblClickListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                int dblClickIndex;
                if (e.getClickCount() == 2 && (dblClickIndex = RecentFilesDialog.this.fileList.locationToIndex(e.getPoint())) >= 0 && dblClickIndex < RecentFilesDialog.this.files.length && RecentFilesDialog.this.files[dblClickIndex] != null) {
                    RecentFilesDialog.this.selectedFileName = RecentFilesDialog.this.files[dblClickIndex];
                    RecentFilesDialog.this.close();
                }
            }
        };
        this.fileList.addMouseListener(dblClickListener);
        this.getContentPane().add("Center", this.fileList);
        this.setLocation(100, 100);
        this.pack();
    }

    private void getFiles() {
        this.props = JmolPanel.historyFile.getProperties();
        for (int i = 0; i < 10; ++i) {
            this.files[i] = this.props.getProperty("recentFilesFile" + i);
        }
    }

    public void addFile(String name) {
        int i;
        int currentPosition = -1;
        for (i = 0; i < 10; ++i) {
            if (this.files[i] == null || !this.files[i].equals(name)) continue;
            currentPosition = i;
        }
        if (currentPosition == 0) {
            return;
        }
        if (currentPosition > 0) {
            for (i = currentPosition; i < 9; ++i) {
                this.files[i] = this.files[i + 1];
            }
        }
        for (int j = 8; j >= 0; --j) {
            this.files[j + 1] = this.files[j];
        }
        this.files[0] = name;
        this.fileList.setListData(this.files);
        this.fileList.setSelectedIndex(0);
        this.pack();
        this.saveList();
    }

    public void saveList() {
        for (int i = 0; i < 10; ++i) {
            if (this.files[i] == null) continue;
            this.props.setProperty("recentFilesFile" + i, this.files[i]);
        }
        JmolPanel.historyFile.addProperties(this.props);
    }

    public String getFile() {
        return this.selectedFileName;
    }

    public void windowClosing(WindowEvent e) {
        this.cancel();
        this.close();
    }

    void cancel() {
        this.selectedFileName = null;
    }

    void close() {
        this.hide();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            int fileIndex = this.fileList.getSelectedIndex();
            if (fileIndex < this.files.length) {
                this.selectedFileName = this.files[fileIndex];
                this.close();
            }
        } else if (e.getSource() == this.cancelButton) {
            this.cancel();
            this.close();
        }
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void notifyFileOpen(String fullPathName) {
        if (fullPathName != null) {
            this.addFile(fullPathName);
        }
    }
}

