/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.webexport;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.filechooser.FileSystemView;
import org.jmol.api.JmolViewer;
import org.jmol.i18n.GT;
import org.openscience.jmol.app.webexport.LogPanel;

class JmolInstance {
    String name;
    String javaname;
    String script;
    int width;
    int height;
    String pictFile;
    boolean pictIsScratchFile;
    JmolViewer viewer;

    JmolInstance(JmolViewer viewer, String name, String script, int width, int height) {
        String pictfile;
        boolean made_scratchdir;
        this.viewer = viewer;
        this.name = name;
        this.javaname = name.replaceAll("[^a-zA-Z_0-9-]", "_");
        this.script = script;
        this.width = width;
        this.height = height;
        FileSystemView Directories = FileSystemView.getFileSystemView();
        File homedir = Directories.getHomeDirectory();
        String homedirpath = homedir.getPath();
        String scratchpath = homedirpath + "/.jmol_WPM";
        File scratchfile = new File(scratchpath);
        if (!scratchfile.exists() && !(made_scratchdir = scratchfile.mkdir())) {
            LogPanel.log(GT._("Attempt to make scratch directory failed."));
        }
        this.pictFile = pictfile = scratchpath + "/" + this.javaname + ".png";
        viewer.createImage(pictfile, "PNG", null, 2, width, height);
        this.pictIsScratchFile = true;
    }

    boolean movepict(String dirpath) throws IOException {
        String imagename = dirpath + "/" + this.javaname + ".png";
        if (this.pictFile.equals(imagename)) {
            return false;
        }
        String scratchname = this.pictFile;
        FileInputStream is = null;
        is = new FileInputStream(scratchname);
        FileOutputStream os = null;
        os = new FileOutputStream(imagename);
        int pngbyteint = is.read();
        while (pngbyteint != -1) {
            os.write(pngbyteint);
            pngbyteint = is.read();
        }
        os.flush();
        os.close();
        is.close();
        return true;
    }

    boolean delete() throws IOException {
        File scratchToErase = new File(this.pictFile);
        if (scratchToErase.exists() && !scratchToErase.delete()) {
            throw new IOException("Failed to delete scratch file " + this.pictFile + ".");
        }
        return true;
    }
}

