/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.webexport;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.openscience.jmol.app.webexport.ArrayListTransferHandler;
import org.openscience.jmol.app.webexport.LogPanel;
import org.openscience.jmol.app.webexport.WebExport;

class Molecules
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    JButton saveButton;
    JButton MolecopenButton;
    JButton MolecdeleteButton;
    JTextField appletPath;
    JFileChooser fc;
    JList MolecList;
    JComboBox RenderMode;
    JComboBox FormatBox;
    private static final int FromLinks = 1;
    private static final int FromMenu = 2;
    private static final int Wireframe = 1;
    private static final int BallandStick = 2;
    private static final int Spacefilling = 3;

    Molecules() {
    }

    JComponent getPanel() {
        JLabel Description = new JLabel("Create a web page with one Jmol Applet to display molecules chosen by user.");
        this.appletPath = new JTextField(20);
        this.appletPath.addActionListener(this);
        this.appletPath.setText("../../Applets/Java/Jmol");
        JPanel pathPanel = new JPanel();
        pathPanel.setLayout(new BorderLayout());
        pathPanel.add((Component)this.appletPath, "Last");
        pathPanel.setBorder(BorderFactory.createTitledBorder("Relative Path to Jmol Applet:"));
        JLabel RenderModeLabel = new JLabel("Rendering Mode:");
        String[] RenderModes = new String[]{"Wireframe", "BallandStick", "Spacefilling"};
        this.RenderMode = new JComboBox<String>(RenderModes);
        this.RenderMode.setSelectedIndex(2);
        JPanel RenderPanel = new JPanel();
        RenderPanel.add(RenderModeLabel);
        RenderPanel.add(this.RenderMode);
        JPanel PathCoorRendPanel = new JPanel();
        PathCoorRendPanel.setLayout(new BorderLayout());
        PathCoorRendPanel.add((Component)pathPanel, "First");
        PathCoorRendPanel.add((Component)RenderPanel, "Last");
        JLabel PageFormatLabel = new JLabel("Page Format:");
        String[] PageFormats = new String[]{"Molecules from links (best with 4 or less)", "Molecules from popup menu"};
        this.FormatBox = new JComboBox<String>(PageFormats);
        this.FormatBox.setSelectedIndex(0);
        JPanel FormatPanel = new JPanel();
        FormatPanel.add(PageFormatLabel);
        FormatPanel.add(this.FormatBox);
        this.saveButton = new JButton("Save .html as...");
        this.saveButton.addActionListener(this);
        JPanel savePanel = new JPanel();
        savePanel.add(this.saveButton);
        JPanel leftpanel = new JPanel();
        leftpanel.setLayout(new BorderLayout());
        leftpanel.add((Component)PathCoorRendPanel, "First");
        leftpanel.add((Component)FormatPanel, "Center");
        leftpanel.add((Component)savePanel, "Last");
        this.fc = new JFileChooser();
        ArrayListTransferHandler arrayListHandler = new ArrayListTransferHandler(null);
        DefaultListModel Molecfilelist = new DefaultListModel();
        this.MolecList = new JList(Molecfilelist);
        this.MolecList.setSelectionMode(1);
        this.MolecList.setTransferHandler(arrayListHandler);
        this.MolecList.setDragEnabled(true);
        JScrollPane MolecListView = new JScrollPane(this.MolecList);
        MolecListView.setPreferredSize(new Dimension(300, 200));
        this.MolecopenButton = new JButton("Add File(s)...");
        this.MolecopenButton.addActionListener(this);
        this.MolecdeleteButton = new JButton("Delete Selected");
        this.MolecdeleteButton.addActionListener(this);
        JPanel MolecButtonsPanel = new JPanel();
        MolecButtonsPanel.add(this.MolecopenButton);
        MolecButtonsPanel.add(this.MolecdeleteButton);
        JPanel MolecPanel = new JPanel();
        MolecPanel.setLayout(new BorderLayout());
        MolecPanel.add((Component)MolecButtonsPanel, "First");
        MolecPanel.add((Component)MolecListView, "Last");
        MolecPanel.setBorder(BorderFactory.createTitledBorder("Molecule Files (Drag to Preferred Order):"));
        JPanel MoleculePanel = new JPanel();
        MoleculePanel.setLayout(new BorderLayout());
        MoleculePanel.add((Component)Description, "First");
        MoleculePanel.add((Component)leftpanel, "Center");
        MoleculePanel.add((Component)MolecPanel, "After");
        return MoleculePanel;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.MolecopenButton) {
            this.fc.setMultiSelectionEnabled(true);
            this.fc.setDialogTitle("Choose the Molecule Files:");
            int returnVal = this.fc.showOpenDialog(this);
            if (returnVal == 0) {
                File[] files = this.fc.getSelectedFiles();
                DefaultListModel listModel = (DefaultListModel)this.MolecList.getModel();
                for (int i = 0; i < files.length; ++i) {
                    String str = files[i].getName();
                    listModel.addElement(str);
                }
            }
        } else if (e.getSource() == this.MolecdeleteButton) {
            DefaultListModel listModel = (DefaultListModel)this.MolecList.getModel();
            int[] todelete = this.MolecList.getSelectedIndices();
            for (int i = 0; i < todelete.length; ++i) {
                listModel.remove(todelete[i]);
            }
        } else if (e.getSource() == this.saveButton) {
            this.fc.setDialogTitle("Save .html file as:");
            int returnVal = this.fc.showSaveDialog(this);
            if (returnVal == 0) {
                File file = this.fc.getSelectedFile();
                DefaultListModel listModel = (DefaultListModel)this.MolecList.getModel();
                LogPanel.log("Saving: " + file.getName() + ".\n");
                for (int i = 0; i < listModel.getSize(); ++i) {
                    LogPanel.log("  Molecule file #" + i + " is " + listModel.getElementAt(i) + ".");
                }
                boolean retVal = true;
                try {
                    retVal = this.molectohtml(this.FormatBox.getSelectedIndex() + 1, this.RenderMode.getSelectedIndex() + 1, file, this.MolecList, this.appletPath.getText());
                }
                catch (IOException IOe) {
                    LogPanel.log(IOe.getMessage());
                }
                if (!retVal) {
                    LogPanel.log("Call to molectohtml unsuccessful.");
                }
            } else {
                LogPanel.log("Save command cancelled by \"user\".");
            }
        }
    }

    private boolean checkformat(int FormatChoice) throws IOException {
        switch (FormatChoice) {
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
        }
        throw new IOException("Unacceptable format choice for web page.");
    }

    public boolean molectohtml(int FormatChoice, int Rendering, File outfile, JList MolecList, String appletPath) throws IOException {
        boolean formatOK = false;
        formatOK = this.checkformat(FormatChoice);
        if (formatOK) {
            PrintStream out = null;
            out = new PrintStream(new FileOutputStream(outfile));
            out.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
            out.println("<html>");
            out.println("<head>");
            out.println("  <meta content=\"text/html; charset=ISO-8859-1\"");
            out.println(" http-equiv=\"content-type\">");
            out.println("  <title>Molecules using jmol</title>");
            out.println("  <meta content=\"???\" name=\"author\">");
            out.println("  <meta content=\"chemistry, Jmol, image, animation, rotatable, live display\" name=\"keywords\">");
            out.println("  <meta content=\"Molecule display using jmol\" name=\"description\">");
            out.println("  <meta");
            out.println(" content=\"Page design and layout by J. Gutow 7-2006, page written by Orbitals to Web.jar\"");
            out.println(" name=\"details\">");
            out.println("  <meta");
            out.println(" content=\"This page is designed to have the text and normal html edited in a standard web design\"");
            out.println(" name=\"instr1\">");
            out.println("  <meta");
            out.println(" content=\"program.  The javascript is to control the jmol applet (see below).  It is best to use\"");
            out.println(" name=\"instr2\">");
            out.println("  <meta");
            out.println(" content=\"the java program to generate the proper java script to allow orbital display.  It is\"");
            out.println(" name=\"instr3\">");
            out.println("  <meta");
            out.println(" content=\"important to have all the gzipped files in the same directory as the .html file.  The\"");
            out.println(" name=\"instr4\">");
            out.println("  <meta");
            out.println(" content=\"files needed are: 1) a gzipped files with the atom coordinates, in any of the formats Jmol\"");
            out.println(" name=\"instr5\">");
            out.println("  <meta");
            out.println(" content=\"can read.\"");
            out.println(" name=\"instr6\">");
            out.println("  <meta");
            out.println(" content=\"It is also recommended that the file names for the molecules correspond to\"");
            out.println(" name=\"instr8\">");
            out.println("  <meta");
            out.println(" content=\"reasonable names for the molecules as the file names are used to generate the menu items\"");
            out.println(" name=\"instr9\">");
            out.println("  <meta content=\"that appear in the popup menus or as links for selecting molecules.\"");
            out.println(" name=\"instr10\">");
            out.println("  <meta");
            out.println(" content=\"The relative path to Jmol on your server must be correct below!!\"");
            out.println(" name=\"instr11\">");
            out.println("  <script src=\"" + appletPath + "/Jmol.js\"></script>");
            out.println("</head>");
            out.println("<body>");
            out.println("<div style=\"text-align: center;\"><big><big><span");
            out.println(" style=\"font-weight: bold;\">&lt;Replace this text with your title&gt;<br>");
            out.println("</span></big></big>");
            out.println("<div style=\"text-align: left;\"><big><big><span");
            out.println(" style=\"font-weight: bold;\"></span></big></big>&lt;Describe your");
            out.println("molecules here. Don't forget to mention that there is a");
            out.println("live display below.&nbsp; The user's browser window may be too small to");
            out.println("display your text and the table containing the Jmol applet without");
            out.println("scrolling.&gt;<br>");
            out.println("<br>");
            out.println("<big><big><span style=\"font-weight: bold;\"></span></big></big>");
            out.println("<table style=\"width: 100%; text-align: left;\" border=\"1\" cellpadding=\"2\"");
            out.println(" cellspacing=\"2\">");
            out.println("  <tbody>");
            out.println("    <tr>");
            out.println("      <td style=\"vertical-align: top;\">");
            out.println("      <script>");
            out.println("jmolInitialize(\"" + appletPath + "\");");
            out.println("jmolApplet(300);");
            out.println("jmolBr();");
            out.println("jmolHtml(\"This image may be rotated and zoomed.  See below for more instructions.\");");
            out.println("        </script>");
            out.println("      <br>");
            out.println("      </td>");
            out.println("      <td style=\"vertical-align: top;\">");
            out.println("      <div style=\"text-align: right;\"> </div>");
            out.println("      <form name=\"appletcontrol\">");
            out.println("        <div style=\"text-align: right;\"> </div>");
            out.println("        <table style=\"width: 100%; text-align: left;\" border=\"0\"");
            out.println(" cellpadding=\"2\" cellspacing=\"2\">");
            out.println("          <tbody>");
            switch (FormatChoice) {
                case 1: {
                    int i;
                    for (i = 0; i < MolecList.getModel().getSize(); ++i) {
                        out.println("            <tr>");
                        out.println("              <td colspan=\"1\" rowspan=\"1\"");
                        out.println(" style=\"vertical-align: top; white-space: nowrap; text-align: right;\"><span");
                        out.println(" style=\"font-weight: bold;\">Molecule Name" + i + ":</span><br>");
                        out.println("              </td> <td>");
                        int dotIndex = MolecList.getModel().getElementAt(i).toString().indexOf(".");
                        String Itemname = MolecList.getModel().getElementAt(i).toString().substring(0, dotIndex);
                        out.println("                <script>");
                        switch (Rendering) {
                            case 1: {
                                out.println("       jmolLink('load " + MolecList.getModel().getElementAt(i) + "; spacefill 0%; wireframe; labels %e; set labeloffset 0 0; background black;',\"" + Itemname + "\");");
                                break;
                            }
                            case 2: {
                                out.println("       jmolLink('load " + MolecList.getModel().getElementAt(i) + "; spacefill 20%; wireframe 0.15; background black; ',\"" + Itemname + "\");");
                                break;
                            }
                            case 3: {
                                out.println("       jmolLink('load " + MolecList.getModel().getElementAt(i) + "; spacefill 100%; wireframe; background black; ',\"" + Itemname + "\");");
                            }
                        }
                        out.println("              </script></td><td> place holder text");
                        out.println("             </td></tr>");
                    }
                    break;
                }
                case 2: {
                    out.println("            <tr>");
                    out.println("              <td colspan=\"1\" rowspan=\"1\"");
                    out.println(" style=\"vertical-align: top; white-space: nowrap; text-align: right;\"><span");
                    out.println(" style=\"font-weight: bold;\">Choose a Molecule:</span><br>");
                    out.println("              </td>");
                    out.println("              <td style=\"vertical-align: top;\">");
                    out.println("              <script>");
                    out.println("\t\tjmolMenu([['load empty;','none'],");
                    int i = 0;
                    if (i < MolecList.getModel().getSize()) {
                        int dotIndex = MolecList.getModel().getElementAt(i).toString().indexOf(".");
                        String Itemname = MolecList.getModel().getElementAt(i).toString().substring(0, dotIndex);
                        switch (Rendering) {
                            case 1: {
                                out.println("       ['load " + MolecList.getModel().getElementAt(i) + "; spacefill 0%; wireframe; labels %e; set labeloffset 0 0; background black;',\"" + Itemname + "\"],");
                                break;
                            }
                            case 2: {
                                out.println("       ['load " + MolecList.getModel().getElementAt(i) + "; spacefill 20%; wireframe 0.15; background black; ',\"" + Itemname + "\"],");
                                break;
                            }
                            case 3: {
                                out.println("       ['load " + MolecList.getModel().getElementAt(i) + "; spacefill 100%; wireframe; background black; ',\"" + Itemname + "\"],");
                            }
                        }
                    }
                    out.println("\t\t]);");
                    out.println("\t\t</script>");
                    out.println("              <br>");
                    out.println("              </td>");
                    out.println("            </tr>");
                }
            }
            out.println("          </tbody>");
            out.println("        </table>");
            out.println("      </form>");
            out.println("&lt;This space can be used as a short caption for the applet at left.&gt;<br><br>");
            String Stamp = "";
            Stamp = WebExport.TimeStamp_WebLink();
            out.println(Stamp);
            out.println("Original");
            out.println("page composed by <a href=\"http://www.uwosh.edu/faculty_staff/gutow/\">J.");
            out.println("Gutow 7/2006</a>. </small> </td>");
            out.println("    </tr>");
            out.println("    <tr>");
            out.println("      <td colspan=\"2\" rowspan=\"1\" style=\"vertical-align: top;\">");
            out.println("      <div style=\"text-align: center;\"><span style=\"font-weight: bold;\">Instructions");
            out.println("for using Jmol to display");
            out.println("molecules</span>: <br>");
            out.println("      </div>");
            out.println("      <ol>");
            out.println("        <li>Choose which molecules to display by selecting them using the");
            out.println("popup menus or clicking on the appropriate link.");
            out.println("        </li>");
            out.println("        <li>ROTATE the image by");
            out.println("holding");
            out.println("down the mouse button while moving the cursor over the image.&nbsp; </li>");
            out.println("        <li>ZOOM by holding down the shift key while moving the cursor");
            out.println("up");
            out.println("(decrease magnification) or down (increase magnification) on top of the");
            out.println("image.&nbsp; </li>");
            out.println("        <li>Other options are available in the control menu accessible by");
            out.println("holding");
            out.println("the mouse button down while the cursor is over \"Jmol\" in the lower");
            out.println("right corner (right click also works on a multibutton mouse).&nbsp; </li>");
            out.println("        <li>For more info about Jmol go to <a target=\"_blank\"");
            out.println(" href=\"http://www.jmol.org\">www.jmol.org.</a></li>");
            out.println("      </ol>");
            out.println("      </td>");
            out.println("    </tr>");
            out.println("  </tbody>");
            out.println("</table>");
            out.println("</div>");
            out.println("</div>");
            out.println("</body>");
            out.println("</html>");
            out.close();
        }
        return true;
    }
}

