/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.cifpdb;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Vector;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Structure;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;

public class PdbReader
extends AtomSetCollectionReader {
    int lineLength;
    boolean isNMRdata;
    final Hashtable htFormul = new Hashtable();
    Hashtable htHetero = null;
    Hashtable htSites = null;
    protected String fileType = "pdb";
    String currentGroup3;
    String compnd;
    Hashtable htElementsInCurrentGroup;
    int maxSerial = 0;
    int[] chainAtomCounts;
    private static final String lineOptions = "ATOM    HETATM  MODEL   CONECT  HELIX   SHEET   TURN    HET     HETNAM  ANISOU  SITE    CRYST1  SCALE1  SCALE2  SCALE3  EXPDTA  FORMUL  REMARK  HEADER  COMPND  ";
    Vector biomolecules;
    Vector biomts;
    int atomCount;
    String lastAtomData;
    int lastAtomIndex;
    boolean haveMappedSerials;

    public void readAtomSetCollection(BufferedReader reader) {
        this.reader = reader;
        this.atomSetCollection = new AtomSetCollection(this.fileType);
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("isPDB", Boolean.TRUE);
        this.setFractionalCoordinates(false);
        this.htFormul.clear();
        this.currentGroup3 = null;
        this.isNMRdata = false;
        boolean iHaveModel = false;
        boolean iHaveModelStatement = false;
        StringBuffer pdbHeader = this.getHeader ? new StringBuffer() : null;
        try {
            block17: while (this.readLine() != null) {
                boolean isModel;
                this.lineLength = this.line.length();
                int ptOption = (this.lineLength < 6 ? -1 : lineOptions.indexOf(this.line.substring(0, 6))) >> 3;
                boolean isAtom = ptOption == 0 || ptOption == 1;
                boolean bl = isModel = ptOption == 2;
                if (this.getHeader) {
                    if (isAtom || isModel) {
                        this.getHeader = false;
                    } else {
                        pdbHeader.append(this.line).append('\n');
                    }
                }
                if (isModel) {
                    this.getHeader = false;
                    iHaveModelStatement = true;
                    int modelNo = this.getModelNumber();
                    int n = this.modelNumber = this.bsModels == null ? modelNo : this.modelNumber + 1;
                    if (!this.doGetModel(this.modelNumber)) {
                        if (this.isLastModel(this.modelNumber) && iHaveModel) break;
                        iHaveModel = false;
                        continue;
                    }
                    iHaveModel = true;
                    this.atomSetCollection.connectAll(this.maxSerial);
                    this.applySymmetryAndSetTrajectory();
                    this.model(modelNo);
                    continue;
                }
                if (iHaveModelStatement && !iHaveModel) continue;
                if (isAtom) {
                    this.getHeader = false;
                    this.atom();
                    continue;
                }
                switch (ptOption) {
                    case 3: {
                        this.conect();
                        continue block17;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        this.structure();
                        continue block17;
                    }
                    case 7: {
                        this.het();
                        continue block17;
                    }
                    case 8: {
                        this.hetnam();
                        continue block17;
                    }
                    case 9: {
                        this.anisou();
                        continue block17;
                    }
                    case 10: {
                        this.site();
                        continue block17;
                    }
                    case 11: {
                        this.cryst1();
                        continue block17;
                    }
                    case 12: 
                    case 13: 
                    case 14: {
                        this.scale(ptOption - 11);
                        continue block17;
                    }
                    case 15: {
                        this.expdta();
                        continue block17;
                    }
                    case 16: {
                        this.formul();
                        continue block17;
                    }
                    case 17: {
                        if (this.line.startsWith("REMARK 350")) {
                            this.remark350();
                            continue block17;
                        }
                        this.checkLineForScript();
                        continue block17;
                    }
                    case 18: {
                        this.header();
                        continue block17;
                    }
                    case 19: {
                        this.compnd();
                        continue block17;
                    }
                }
            }
            this.atomSetCollection.connectAll(this.maxSerial);
            if (this.biomolecules != null && this.biomolecules.size() > 0) {
                this.atomSetCollection.setAtomSetAuxiliaryInfo("biomolecules", this.biomolecules);
                this.setBiomoleculeAtomCounts();
                if (this.biomts != null && this.filter != null && this.filter.toUpperCase().indexOf("NOSYMMETRY") < 0) {
                    this.atomSetCollection.applySymmetry(this.biomts, this.applySymmetryToBonds, this.filter);
                }
            }
            this.applySymmetryAndSetTrajectory();
            if (this.htSites != null) {
                this.addSites(this.htSites);
            }
            if (pdbHeader != null) {
                this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("fileHeader", pdbHeader.toString());
            }
        }
        catch (Exception e) {
            this.setError(e);
        }
    }

    private void header() {
        if (this.lineLength < 8) {
            return;
        }
        if (this.lineLength >= 66) {
            this.atomSetCollection.setCollectionName(this.line.substring(62, 66));
        }
        if (this.lineLength > 50) {
            this.line = this.line.substring(0, 50);
        }
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("CLASSIFICATION", this.line.substring(7).trim());
    }

    private void compnd() {
        this.compnd = this.compnd == null ? "" : this.compnd + " ";
        if (this.lineLength > 62) {
            this.line = this.line.substring(0, 62);
        }
        this.compnd = this.compnd + this.line.substring(10).trim();
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("COMPND", this.compnd);
    }

    private void setBiomoleculeAtomCounts() {
        int i = this.biomolecules.size();
        while (--i >= 0) {
            Hashtable biomolecule = (Hashtable)this.biomolecules.elementAt(i);
            String chain = (String)biomolecule.get("chains");
            int nTransforms = ((Vector)biomolecule.get("biomts")).size();
            int nAtoms = 0;
            int j = chain.length() - 1;
            while (--j >= 0) {
                if (chain.charAt(j) != ':') continue;
                nAtoms += this.chainAtomCounts[chain.charAt(j + 1)];
            }
            biomolecule.put("atomCount", new Integer(nAtoms * nTransforms));
        }
    }

    private void remark350() throws Exception {
        Vector<float[]> biomts = null;
        this.biomolecules = new Vector();
        this.chainAtomCounts = new int[255];
        String title = "";
        String chainlist = "";
        int iMolecule = 0;
        boolean needLine = true;
        Hashtable<String, Object> info = null;
        int nBiomt = 0;
        while (true) {
            if (needLine) {
                this.readLine();
            } else {
                needLine = true;
            }
            if (this.line == null || !this.line.startsWith("REMARK 350")) break;
            try {
                if (this.line.startsWith("REMARK 350 BIOMOLECULE:")) {
                    if (nBiomt > 0) {
                        Logger.info("biomolecule " + iMolecule + ": number of transforms: " + nBiomt);
                    }
                    info = new Hashtable<String, Object>();
                    biomts = new Vector<float[]>();
                    iMolecule = this.parseInt(this.line.substring(this.line.indexOf(":") + 1));
                    title = this.line.trim();
                    info.put("molecule", new Integer(iMolecule));
                    info.put("title", title);
                    info.put("chains", "");
                    info.put("biomts", biomts);
                    this.biomolecules.add(info);
                    nBiomt = 0;
                }
                if (this.line.indexOf("APPLY THE FOLLOWING TO CHAINS:") >= 0) {
                    if (info == null) {
                        needLine = false;
                        this.line = "REMARK 350 BIOMOLECULE: 1  APPLY THE FOLLOWING TO CHAINS:";
                        continue;
                    }
                    chainlist = ":" + this.line.substring(41).trim().replace(' ', ':');
                    needLine = false;
                    while (this.readLine() != null && this.line.indexOf("BIOMT") < 0) {
                        chainlist = chainlist + ":" + this.line.substring(11).trim().replace(' ', ':');
                    }
                    if (this.filter != null && this.filter.toUpperCase().indexOf("BIOMOLECULE " + iMolecule + ";") >= 0) {
                        this.filter = this.filter + chainlist;
                        Logger.info("filter set to \"" + this.filter + "\"");
                        this.biomts = biomts;
                    }
                    if (info == null) {
                        return;
                    }
                    info.put("chains", chainlist);
                    continue;
                }
                if (!this.line.startsWith("REMARK 350   BIOMT1 ")) continue;
                ++nBiomt;
                float[] mat = new float[16];
                int i = 0;
                while (i < 12) {
                    String[] tokens = this.getTokens();
                    mat[i++] = this.parseFloat(tokens[4]);
                    mat[i++] = this.parseFloat(tokens[5]);
                    mat[i++] = this.parseFloat(tokens[6]);
                    mat[i++] = this.parseFloat(tokens[7]);
                    if (i != 4 && i != 8) continue;
                    this.readLine();
                }
                mat[15] = 1.0f;
                biomts.add(mat);
            }
            catch (Exception e) {
                this.biomts = null;
                this.biomolecules = null;
                return;
            }
        }
        if (nBiomt > 0) {
            Logger.info("biomolecule " + iMolecule + ": number of transforms: " + nBiomt);
        }
    }

    void atom() {
        boolean isHetero = this.line.startsWith("HETATM");
        char charAlternateLocation = this.line.charAt(16);
        int serial = this.parseInt(this.line, 6, 11);
        if (serial > this.maxSerial) {
            this.maxSerial = serial;
        }
        char chainID = this.line.charAt(21);
        if (this.chainAtomCounts != null) {
            char c = chainID;
            this.chainAtomCounts[c] = this.chainAtomCounts[c] + 1;
        }
        int sequenceNumber = this.parseInt(this.line, 22, 26);
        char insertionCode = this.line.charAt(26);
        String group3 = this.parseToken(this.line, 17, 20);
        if (group3 == null) {
            this.currentGroup3 = null;
            this.htElementsInCurrentGroup = null;
        } else if (!group3.equals(this.currentGroup3)) {
            this.currentGroup3 = group3;
            this.htElementsInCurrentGroup = (Hashtable)this.htFormul.get(group3);
        }
        String elementSymbol = this.deduceElementSymbol(isHetero);
        String rawAtomName = this.line.substring(12, 16);
        String atomName = rawAtomName.trim();
        int charge = 0;
        if (this.lineLength >= 80) {
            char chMagnitude = this.line.charAt(78);
            char chSign = this.line.charAt(79);
            if (chSign >= '0' && chSign <= '7') {
                char chT = chSign;
                chSign = chMagnitude;
                chMagnitude = chT;
            }
            if ((chSign == '+' || chSign == '-' || chSign == ' ') && chMagnitude >= '0' && chMagnitude <= '7') {
                charge = chMagnitude - 48;
                if (chSign == '-') {
                    charge = -charge;
                }
            }
        }
        float bfactor = this.readBFactor();
        int occupancy = this.readOccupancy();
        float partialCharge = this.readPartialCharge();
        float radius = this.readRadius();
        float x = this.parseFloat(this.line, 30, 38);
        float y = this.parseFloat(this.line, 38, 46);
        float z = this.parseFloat(this.line, 46, 54);
        Atom atom = new Atom();
        atom.atomName = atomName;
        atom.chainID = chainID;
        atom.group3 = this.currentGroup3;
        if (this.filter != null && !this.filterAtom(atom)) {
            return;
        }
        atom.elementSymbol = elementSymbol;
        if (charAlternateLocation != ' ') {
            atom.alternateLocationID = charAlternateLocation;
        }
        atom.formalCharge = charge;
        if (partialCharge != Float.MAX_VALUE) {
            atom.partialCharge = partialCharge;
        }
        atom.occupancy = occupancy;
        atom.bfactor = bfactor;
        this.setAtomCoord(atom, x, y, z);
        atom.isHetero = isHetero;
        atom.atomSerial = serial;
        atom.sequenceNumber = sequenceNumber;
        atom.insertionCode = JmolAdapter.canonizeInsertionCode(insertionCode);
        atom.radius = radius;
        this.lastAtomData = this.line.substring(6, 26);
        this.lastAtomIndex = this.atomSetCollection.getAtomCount();
        if (this.haveMappedSerials) {
            this.atomSetCollection.addAtomWithMappedSerialNumber(atom);
        } else {
            this.atomSetCollection.addAtom(atom);
        }
        if (this.atomCount++ == 0) {
            this.atomSetCollection.setAtomSetAuxiliaryInfo("isPDB", Boolean.TRUE);
        }
        if (isHetero && this.htHetero != null) {
            this.atomSetCollection.setAtomSetAuxiliaryInfo("hetNames", this.htHetero);
            this.htHetero = null;
        }
    }

    protected int readOccupancy() {
        int occupancy = 100;
        float floatOccupancy = this.parseFloat(this.line, 54, 60);
        if (!Float.isNaN(floatOccupancy)) {
            occupancy = (int)(floatOccupancy * 100.0f);
        }
        return occupancy;
    }

    protected float readBFactor() {
        return this.parseFloat(this.line, 60, 66);
    }

    protected float readPartialCharge() {
        return Float.MAX_VALUE;
    }

    protected float readRadius() {
        return Float.NaN;
    }

    String deduceElementSymbol(boolean isHetero) {
        if (this.lineLength >= 78) {
            char ch76 = this.line.charAt(76);
            char ch77 = this.line.charAt(77);
            if (ch76 == ' ' && Atom.isValidElementSymbol(ch77)) {
                return "" + ch77;
            }
            if (Atom.isValidElementSymbolNoCaseSecondChar(ch76, ch77)) {
                return "" + ch76 + ch77;
            }
        }
        char ch12 = this.line.charAt(12);
        char ch13 = this.line.charAt(13);
        if ((this.htElementsInCurrentGroup == null || this.htElementsInCurrentGroup.get(this.line.substring(12, 14)) != null) && Atom.isValidElementSymbolNoCaseSecondChar(ch12, ch13)) {
            return isHetero || ch12 != 'H' ? "" + ch12 + ch13 : "H";
        }
        if ((this.htElementsInCurrentGroup == null || this.htElementsInCurrentGroup.get("" + ch13) != null) && Atom.isValidElementSymbol(ch13)) {
            return "" + ch13;
        }
        if ((this.htElementsInCurrentGroup == null || this.htElementsInCurrentGroup.get("" + ch12) != null) && Atom.isValidElementSymbol(ch12)) {
            return "" + ch12;
        }
        return "Xx";
    }

    void conect() {
        int sourceSerial = -1;
        sourceSerial = this.parseInt(this.line, 6, 11);
        if (sourceSerial < 0) {
            return;
        }
        for (int i = 0; i < 9; i += i == 5 ? 2 : 1) {
            int targetSerial;
            int offset = i * 5 + 11;
            int offsetEnd = offset + 5;
            int n = targetSerial = offsetEnd <= this.lineLength ? this.parseInt(this.line, offset, offsetEnd) : -1;
            if (targetSerial < sourceSerial) continue;
            this.atomSetCollection.addConnection(new int[]{sourceSerial, targetSerial, i < 4 ? 1 : 2048});
        }
    }

    void structure() {
        int endIndex;
        int endChainIDIndex;
        int startIndex;
        int startChainIDIndex;
        String structureType = "none";
        if (this.line.startsWith("HELIX ")) {
            structureType = "helix";
            startChainIDIndex = 19;
            startIndex = 21;
            endChainIDIndex = 31;
            endIndex = 33;
        } else if (this.line.startsWith("SHEET ")) {
            structureType = "sheet";
            startChainIDIndex = 21;
            startIndex = 22;
            endChainIDIndex = 32;
            endIndex = 33;
        } else if (this.line.startsWith("TURN  ")) {
            structureType = "turn";
            startChainIDIndex = 19;
            startIndex = 20;
            endChainIDIndex = 30;
            endIndex = 31;
        } else {
            return;
        }
        if (this.lineLength < endIndex + 4) {
            return;
        }
        char startChainID = this.line.charAt(startChainIDIndex);
        int startSequenceNumber = this.parseInt(this.line, startIndex, startIndex + 4);
        char startInsertionCode = this.line.charAt(startIndex + 4);
        char endChainID = this.line.charAt(endChainIDIndex);
        int endSequenceNumber = this.parseInt(this.line, endIndex, endIndex + 4);
        char endInsertionCode = ' ';
        if (this.lineLength > endIndex + 4) {
            endInsertionCode = this.line.charAt(endIndex + 4);
        }
        Structure structure = new Structure(-1, structureType, startChainID, startSequenceNumber, startInsertionCode, endChainID, endSequenceNumber, endInsertionCode);
        this.atomSetCollection.addStructure(structure);
    }

    private int getModelNumber() {
        try {
            int startModelColumn = 6;
            int endModelColumn = 14;
            if (endModelColumn > this.lineLength) {
                endModelColumn = this.lineLength;
            }
            return this.parseInt(this.line, startModelColumn, endModelColumn);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    void model(int modelNumber) {
        this.haveMappedSerials = false;
        this.atomSetCollection.newAtomSet();
        this.atomSetCollection.setAtomSetAuxiliaryInfo("isPDB", Boolean.TRUE);
        this.atomSetCollection.setAtomSetNumber(modelNumber);
    }

    void cryst1() throws Exception {
        this.setUnitCell(this.getFloat(6, 9), this.getFloat(15, 9), this.getFloat(24, 9), this.getFloat(33, 7), this.getFloat(40, 7), this.getFloat(47, 7));
        this.setSpaceGroupName(PdbReader.parseTrimmed(this.line, 55, 66));
    }

    float getFloat(int ich, int cch) throws Exception {
        return this.parseFloat(this.line, ich, ich + cch);
    }

    void scale(int n) throws Exception {
        int pt = n * 4 + 2;
        this.setUnitCellItem(pt++, this.getFloat(10, 10));
        this.setUnitCellItem(pt++, this.getFloat(20, 10));
        this.setUnitCellItem(pt++, this.getFloat(30, 10));
        this.setUnitCellItem(pt++, this.getFloat(45, 10));
    }

    void expdta() {
        String technique = PdbReader.parseTrimmed(this.line, 10).toLowerCase();
        if (technique.regionMatches(true, 0, "nmr", 0, 3)) {
            this.isNMRdata = true;
        }
    }

    void formul() {
        String elementWithCount;
        Hashtable<String, Boolean> htElementsInGroup;
        String groupName = this.parseToken(this.line, 12, 15);
        String formula = PdbReader.parseTrimmed(this.line, 19, 70);
        int ichLeftParen = formula.indexOf(40);
        if (ichLeftParen >= 0) {
            int ichRightParen = formula.indexOf(41);
            if (ichRightParen < 0 || ichLeftParen >= ichRightParen || ichLeftParen + 1 == ichRightParen) {
                return;
            }
            formula = PdbReader.parseTrimmed(formula, ichLeftParen + 1, ichRightParen);
        }
        if ((htElementsInGroup = (Hashtable<String, Boolean>)this.htFormul.get(groupName)) == null) {
            htElementsInGroup = new Hashtable<String, Boolean>();
            this.htFormul.put(groupName, htElementsInGroup);
        }
        this.next[0] = 0;
        while ((elementWithCount = this.parseTokenNext(formula)) != null) {
            char chSecond;
            if (elementWithCount.length() < 2) continue;
            char chFirst = elementWithCount.charAt(0);
            if (Atom.isValidElementSymbolNoCaseSecondChar(chFirst, chSecond = elementWithCount.charAt(1))) {
                htElementsInGroup.put("" + chFirst + chSecond, Boolean.TRUE);
                continue;
            }
            if (!Atom.isValidElementSymbol(chFirst)) continue;
            htElementsInGroup.put("" + chFirst, Boolean.TRUE);
        }
    }

    void het() {
        String groupName;
        if (this.line.length() < 30) {
            return;
        }
        if (this.htHetero == null) {
            this.htHetero = new Hashtable();
        }
        if (this.htHetero.contains(groupName = this.parseToken(this.line, 7, 10))) {
            return;
        }
        String hetName = PdbReader.parseTrimmed(this.line, 30, 70);
        this.htHetero.put(groupName, hetName);
    }

    void hetnam() {
        if (this.htHetero == null) {
            this.htHetero = new Hashtable();
        }
        String groupName = this.parseToken(this.line, 11, 14);
        String hetName = PdbReader.parseTrimmed(this.line, 15, 70);
        if (groupName == null) {
            System.out.println("ERROR: HETNAM record does not contain a group name: " + this.line);
            return;
        }
        String htName = (String)this.htHetero.get(groupName);
        if (htName != null) {
            hetName = htName + hetName;
        }
        this.htHetero.put(groupName, hetName);
    }

    void anisou() {
        int index;
        float[] data = new float[8];
        data[6] = 1.0f;
        int serial = this.parseInt(this.line, 6, 11);
        if (this.line.substring(6, 26).equals(this.lastAtomData)) {
            index = this.lastAtomIndex;
        } else {
            if (!this.haveMappedSerials) {
                this.atomSetCollection.createAtomSerialMap();
            }
            index = this.atomSetCollection.getAtomSerialNumberIndex(serial);
            this.haveMappedSerials = true;
        }
        if (index < 0) {
            return;
        }
        Atom atom = this.atomSetCollection.getAtom(index);
        int i = 28;
        int pt = 0;
        while (i < 70) {
            data[pt] = this.parseFloat(this.line, i, i + 7);
            i += 7;
            ++pt;
        }
        i = 0;
        while (i < 6) {
            if (Float.isNaN(data[i])) {
                System.out.println("Bad ANISOU record: " + this.line);
                return;
            }
            int n = i++;
            data[n] = data[n] / 10000.0f;
        }
        atom.anisoBorU = data;
    }

    private void site() {
        int pt;
        String resName;
        if (this.htSites == null) {
            this.htSites = new Hashtable();
        }
        int seqNum = this.parseInt(this.line, 7, 10);
        int nResidues = this.parseInt(this.line, 15, 17);
        String siteID = PdbReader.parseTrimmed(this.line, 11, 14);
        Hashtable<String, Object> htSite = (Hashtable<String, Object>)this.htSites.get(siteID);
        if (htSite == null) {
            htSite = new Hashtable<String, Object>();
            htSite.put("seqNum", "site_" + seqNum);
            htSite.put("nResidues", new Integer(nResidues));
            htSite.put("groups", "");
            this.htSites.put(siteID, htSite);
        }
        String groups = (String)htSite.get("groups");
        for (int i = 0; i < 4 && (resName = PdbReader.parseTrimmed(this.line, pt = 18 + i * 11, pt + 3)).length() != 0; ++i) {
            String chainID = PdbReader.parseTrimmed(this.line, pt + 4, pt + 5);
            String seq = PdbReader.parseTrimmed(this.line, pt + 5, pt + 9);
            String iCode = PdbReader.parseTrimmed(this.line, pt + 9, pt + 10);
            groups = groups + (groups.length() == 0 ? "" : ",") + "[" + resName + "]" + seq;
            if (iCode.length() > 0) {
                groups = groups + "^" + iCode;
            }
            if (chainID.length() > 0) {
                groups = groups + ":" + chainID;
            }
            htSite.put("groups", groups);
        }
    }

    public void applySymmetryAndSetTrajectory() throws Exception {
        if (this.needToApplySymmetry && !this.isNMRdata && this.spaceGroup.indexOf(":") < 0) {
            this.spaceGroup = this.spaceGroup + ":?";
        }
        this.atomSetCollection.setCheckSpecial(false);
        super.applySymmetryAndSetTrajectory();
    }
}

