/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.api.JmolAdapter;

public class AdfReader
extends AtomSetCollectionReader {
    String energy = null;

    public void readAtomSetCollection(BufferedReader reader) {
        this.atomSetCollection = new AtomSetCollection("adf");
        this.reader = reader;
        boolean iHaveAtoms = false;
        this.modelNumber = 0;
        try {
            while (this.readLine() != null) {
                if (this.line.indexOf("Coordinates (Cartesian)") >= 0 || this.line.indexOf("G E O M E T R Y  ***  3D  Molecule  ***") >= 0) {
                    if (!this.doGetModel(++this.modelNumber)) {
                        if (!this.isLastModel(this.modelNumber) || !iHaveAtoms) {
                            iHaveAtoms = false;
                            continue;
                        }
                        break;
                    }
                    iHaveAtoms = true;
                    this.readCoordinates();
                    continue;
                }
                if (iHaveAtoms && this.line.indexOf("Energy:") >= 0) {
                    String[] tokens = this.getTokens();
                    this.energy = tokens[1];
                    continue;
                }
                if (!iHaveAtoms || this.line.indexOf("Vibrations") < 0) continue;
                this.readFrequencies();
            }
        }
        catch (Exception e) {
            this.setError(e);
        }
    }

    private void readCoordinates() throws Exception {
        String[] tokens;
        this.atomSetCollection.newAtomSet();
        this.atomSetCollection.setAtomSetName("" + this.energy);
        this.discardLinesUntilContains("----");
        while (this.readLine() != null && !this.line.startsWith(" -----") && (tokens = this.getTokens()).length >= 5) {
            String symbol = tokens[1];
            if (JmolAdapter.getElementNumber(symbol) < 1) continue;
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementSymbol = symbol;
            atom.set(this.parseFloat(tokens[2]), this.parseFloat(tokens[3]), this.parseFloat(tokens[4]));
            if (tokens.length <= 8) continue;
            atom.scale(0.5291772f);
        }
    }

    private void readFrequencies() throws Exception {
        this.readLine();
        int atomCount = this.atomSetCollection.getLastAtomSetAtomCount();
        while (this.readLine() != null) {
            while (this.readLine() != null && this.line.indexOf(".") < 0 && this.line.indexOf("====") < 0) {
            }
            if (this.line == null || this.line.indexOf(".") < 0) {
                return;
            }
            String[] frequencies = this.getTokens();
            this.readLine();
            int frequencyCount = frequencies.length;
            int firstModelAtom = this.atomSetCollection.getAtomCount();
            for (int i = 0; i < frequencyCount; ++i) {
                this.atomSetCollection.cloneLastAtomSet();
                this.atomSetCollection.setAtomSetName(frequencies[i] + " cm**-1");
                this.atomSetCollection.setAtomSetProperty("Frequency", frequencies[i] + " cm**-1");
                this.atomSetCollection.setAtomSetProperty(".PATH", "Frequencies");
            }
            int atomPt = 0;
            while (this.readLine() != null && this.line.indexOf(".") >= 0) {
                String[] tokens = this.getTokens();
                String symbol = tokens[0].substring(tokens[0].indexOf(".") + 1);
                if (JmolAdapter.getElementNumber(symbol) < 1) continue;
                int offset = 1;
                for (int j = 0; j < frequencyCount; ++j) {
                    int atomOffset = firstModelAtom + j * atomCount + atomPt;
                    Atom atom = this.atomSetCollection.getAtom(atomOffset);
                    float x = this.parseFloat(tokens[offset++]);
                    float y = this.parseFloat(tokens[offset++]);
                    float z = this.parseFloat(tokens[offset++]);
                    atom.addVibrationVector(x, y, z);
                }
                ++atomPt;
            }
        }
    }
}

