/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Vector;
import org.jmol.adapter.readers.more.MopacData;
import org.jmol.adapter.readers.more.MopacDataReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.Bond;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;

public class CsfReader
extends MopacDataReader {
    int nAtoms = 0;
    String atomicNumbers = "";
    int fieldCount;
    int nVibrations = 0;
    int nGaussians = 0;
    int nSlaters = 0;
    private Hashtable propertyItemCounts = new Hashtable();
    int[] fieldTypes = new int[100];
    static final byte objCls1 = 1;
    static final byte objID1 = 2;
    static final byte objCls2 = 3;
    static final byte objID2 = 4;
    static final String[] connectorFields = new String[]{"objCls1", "objID1", "objCls2", "objID2"};
    static final byte[] connectorFieldMap = new byte[]{1, 2, 3, 4};
    Hashtable connectors = new Hashtable();
    static final byte ID = -1;
    static final byte sym = 1;
    static final byte anum = 2;
    static final byte chrg = 3;
    static final byte xyz_coordinates = 4;
    static final byte pchrg = 5;
    static final String[] atomFields = new String[]{"ID", "sym", "anum", "chrg", "xyz_coordinates", "pchrg"};
    static final byte[] atomFieldMap = new byte[]{-1, 1, 2, 3, 4, 5};
    static final byte bondType = 1;
    static final String[] bondFields = new String[]{"ID", "type"};
    static final byte[] bondFieldMap = new byte[]{-1, 1};
    int nBonds = 0;
    static final byte normalMode = 1;
    static final byte vibEnergy = 2;
    static final byte transitionDipole = 3;
    static final String[] vibFields = new String[]{"ID", "normalMode", "Energy", "transitionDipole"};
    static final byte[] vibFieldMap = new byte[]{-1, 1, 2, 3};
    static final byte eig_val = 1;
    static final byte mo_occ = 2;
    static final byte eig_vec = 3;
    static final byte eig_vec_compressed = 4;
    static final byte coef_indices = 5;
    static final byte bfxn_ang = 6;
    static final byte sto_exp = 7;
    static final byte contractions = 8;
    static final byte gto_exp = 9;
    static final byte shell = 10;
    static final String[] moFields = new String[]{"ID", "eig_val", "mo_occ", "eig_vec", "eig_vec_compressed", "coef_indices", "bfxn_ang", "sto_exp", "contractions", "gto_exp", "shell"};
    static final byte[] moFieldMap = new byte[]{-1, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10};

    public void readAtomSetCollection(BufferedReader reader) {
        this.reader = reader;
        this.atomSetCollection = new AtomSetCollection("csf");
        try {
            this.readLine();
            while (this.line != null) {
                if (this.line.equals("local_transform")) {
                    this.processLocalTransform();
                } else if (this.line.startsWith("object_class")) {
                    this.processObjectClass();
                    continue;
                }
                this.readLine();
            }
        }
        catch (Exception e) {
            this.setError(e);
        }
    }

    private void processObjectClass() throws Exception {
        if (this.line.equals("object_class connector")) {
            this.processConnectorObject();
            return;
        }
        if (this.line.equals("object_class atom")) {
            this.processAtomObject();
            return;
        }
        if (this.line.equals("object_class bond")) {
            this.processBondObject();
            return;
        }
        if (this.line.equals("object_class vibrational_level")) {
            this.processVibrationObject();
            return;
        }
        if (this.line.equals("object_class mol_orbital")) {
            this.processMolecularOrbitalObject();
            return;
        }
        if (this.line.equals("object_class sto_basis_fxn")) {
            this.processBasisObject("sto");
            return;
        }
        if (this.line.equals("object_class gto_basis_fxn")) {
            this.processBasisObject("gto");
            return;
        }
        this.readLine();
    }

    private void processLocalTransform() throws Exception {
        String[] tokens = CsfReader.getTokens(this.readLine() + " " + this.readLine() + " " + this.readLine() + " " + this.readLine());
        this.setTransform(this.parseFloat(tokens[0]), this.parseFloat(tokens[1]), this.parseFloat(tokens[2]), this.parseFloat(tokens[4]), this.parseFloat(tokens[5]), this.parseFloat(tokens[6]), this.parseFloat(tokens[8]), this.parseFloat(tokens[9]), this.parseFloat(tokens[10]));
    }

    int getPropertyCount(String what) {
        Integer count = (Integer)this.propertyItemCounts.get(what);
        return what.equals("ID") ? 1 : (count == null ? 0 : count);
    }

    private int parseLineParameters(String[] fields, byte[] fieldMap) throws Exception {
        for (int i = 0; i < this.fieldCount; ++i) {
            this.fieldTypes[i] = 0;
        }
        this.fieldCount = -1;
        if (this.line == null || this.line.startsWith("property_flags:")) {
            this.readLine();
        }
        if (this.line == null || this.line.startsWith("object_class")) {
            return this.fieldCount;
        }
        String[] tokens = new String[]{};
        while (this.line != null) {
            tokens = this.getTokens();
            if (this.line.indexOf("property ") == 0) {
                this.propertyItemCounts.put(tokens[1], new Integer(tokens[6].equals("STRING") ? 1 : this.parseInt(tokens[5])));
            } else if (this.line.indexOf("ID") == 0) break;
            this.readLine();
        }
        int fpt = 0;
        for (int ipt = 0; ipt < tokens.length; ++ipt) {
            String field = tokens[ipt];
            int i = fields.length;
            while (--i >= 0) {
                if (!field.equals(fields[i])) continue;
                this.fieldTypes[fpt] = fieldMap[i];
                this.fieldCount = fpt + 1;
                break;
            }
            fpt += this.getPropertyCount(field);
        }
        return this.fieldCount;
    }

    private void fillCsfArray(String property, String[] tokens, int i0, Object f) throws Exception {
        int n = this.getPropertyCount(property);
        int ioffset = i0;
        boolean isInteger = f instanceof int[];
        for (int i = 0; i < n; ++i) {
            int ipt = ioffset + i;
            if (ipt == tokens.length) {
                tokens = CsfReader.getTokens(this.readLine());
                ioffset -= ipt - i0;
                ipt = i0;
            }
            if (isInteger) {
                ((int[])f)[i] = this.parseInt(tokens[ipt]);
                continue;
            }
            ((float[])f)[i] = this.parseFloat(tokens[ipt]);
        }
    }

    void processConnectorObject() throws Exception {
        this.readLine();
        this.parseLineParameters(connectorFields, connectorFieldMap);
        block6: while (this.readLine() != null && !this.line.startsWith("property_flags:")) {
            String thisAtomID = null;
            String thisBondID = null;
            String[] tokens = this.getTokens();
            String field2 = "";
            boolean isVibration = false;
            block7: for (int i = 0; i < this.fieldCount; ++i) {
                String field = tokens[i];
                switch (this.fieldTypes[i]) {
                    case 1: {
                        if (field.equals("atom")) continue block7;
                        continue block6;
                    }
                    case 3: {
                        field2 = field;
                        if (field.equals("sto_basis_fxn")) {
                            ++this.nSlaters;
                            continue block7;
                        }
                        if (field.equals("gto_basis_fxn")) {
                            ++this.nGaussians;
                            continue block7;
                        }
                        if (field.equals("vibrational_level")) {
                            isVibration = true;
                            continue block7;
                        }
                        if (field.equals("bond")) continue block7;
                        continue block6;
                    }
                    case 2: {
                        thisAtomID = "atom" + field;
                        continue block7;
                    }
                    case 4: {
                        thisBondID = field2 + field;
                        if (!isVibration) continue block7;
                        this.nVibrations = Math.max(this.nVibrations, this.parseInt(field));
                        continue block7;
                    }
                }
            }
            if (thisAtomID == null || thisBondID == null) continue;
            if (this.connectors.containsKey(thisBondID)) {
                String[] connect = (String[])this.connectors.get(thisBondID);
                connect[1] = thisAtomID;
                continue;
            }
            String[] connect = new String[2];
            connect[0] = thisAtomID;
            this.connectors.put(thisBondID, connect);
        }
    }

    void processAtomObject() throws Exception {
        this.readLine();
        this.parseLineParameters(atomFields, atomFieldMap);
        this.nAtoms = 0;
        while (this.readLine() != null && !this.line.startsWith("property_flags:")) {
            String[] tokens = this.getTokens();
            Atom atom = new Atom();
            block9: for (int i = 0; i < this.fieldCount; ++i) {
                String field = tokens[i];
                if (field == null) {
                    Logger.warn("field == null in " + this.line);
                }
                switch (this.fieldTypes[i]) {
                    case -1: {
                        atom.atomName = "atom" + field;
                        continue block9;
                    }
                    case 1: {
                        atom.elementSymbol = field;
                        continue block9;
                    }
                    case 2: {
                        this.atomicNumbers = this.atomicNumbers + field + " ";
                        continue block9;
                    }
                    case 3: {
                        atom.formalCharge = this.parseInt(field);
                        continue block9;
                    }
                    case 5: {
                        atom.partialCharge = this.parseFloat(field);
                        continue block9;
                    }
                    case 4: {
                        this.setAtomCoord(atom, this.parseFloat(field), this.parseFloat(tokens[i + 1]), this.parseFloat(tokens[i + 2]));
                    }
                }
            }
            if (Float.isNaN(atom.x) || Float.isNaN(atom.y) || Float.isNaN(atom.z)) {
                Logger.warn("atom " + atom.atomName + " has invalid/unknown coordinates");
                continue;
            }
            ++this.nAtoms;
            this.atomSetCollection.addAtomWithMappedName(atom);
        }
    }

    void processBondObject() throws Exception {
        this.readLine();
        this.parseLineParameters(bondFields, bondFieldMap);
        while (this.readLine() != null && !this.line.startsWith("property_flags:")) {
            String thisBondID = null;
            String[] tokens = this.getTokens();
            block5: for (int i = 0; i < this.fieldCount; ++i) {
                String field = tokens[i];
                switch (this.fieldTypes[i]) {
                    case -1: {
                        thisBondID = "bond" + field;
                        continue block5;
                    }
                    case 1: {
                        int order = 1;
                        if (field.equals("single")) {
                            order = 1;
                        } else if (field.equals("double")) {
                            order = 2;
                        } else if (field.equals("triple")) {
                            order = 3;
                        } else {
                            Logger.warn("unknown CSF bond order: " + field);
                        }
                        String[] connect = (String[])this.connectors.get(thisBondID);
                        Bond bond = new Bond();
                        bond.atomIndex1 = this.atomSetCollection.getAtomNameIndex(connect[0]);
                        bond.atomIndex2 = this.atomSetCollection.getAtomNameIndex(connect[1]);
                        bond.order = order;
                        this.atomSetCollection.addBond(bond);
                        ++this.nBonds;
                    }
                }
            }
        }
    }

    void processVibrationObject() throws Exception {
        Atom[] atoms = this.atomSetCollection.getAtoms();
        float[][] vibData = new float[this.nVibrations][this.nAtoms * 3];
        float[] energies = new float[this.nVibrations];
        this.readLine();
        while (this.line != null && this.parseLineParameters(vibFields, vibFieldMap) > 0) {
            while (this.readLine() != null && !this.line.startsWith("property_flags:")) {
                String[] tokens = this.getTokens();
                int thisvib = -1;
                block7: for (int i = 0; i < this.fieldCount; ++i) {
                    String field = tokens[i];
                    switch (this.fieldTypes[i]) {
                        case -1: {
                            thisvib = this.parseInt(field) - 1;
                            continue block7;
                        }
                        case 1: {
                            this.fillCsfArray("normalMode", tokens, i, vibData[thisvib]);
                            continue block7;
                        }
                        case 2: {
                            energies[thisvib] = this.parseFloat(field);
                        }
                    }
                }
            }
        }
        for (int i = 0; i < this.nVibrations; ++i) {
            this.atomSetCollection.cloneFirstAtomSetWithBonds(this.nBonds);
            this.atomSetCollection.setAtomSetName(energies[i] + " cm^-1", i + 1);
            this.atomSetCollection.setAtomSetProperty(".PATH", "Frequencies");
            int ipt = 0;
            int baseAtom = this.nAtoms * (i + 1);
            for (int iAtom = 0; iAtom < this.nAtoms; ++iAtom) {
                atoms[baseAtom + iAtom].addVibrationVector(vibData[i][ipt++], vibData[i][ipt++], vibData[i][ipt++]);
            }
        }
    }

    void processMolecularOrbitalObject() throws Exception {
        if (this.nSlaters == 0 && this.nGaussians == 0) {
            this.readLine();
            return;
        }
        this.nOrbitals = this.nSlaters + this.nGaussians;
        Logger.info("Reading CSF data for " + this.nOrbitals + " molecular orbitals");
        float[] energy = new float[this.nOrbitals];
        float[] occupancy = new float[this.nOrbitals];
        float[][] list = new float[this.nOrbitals][this.nOrbitals];
        float[][] listCompressed = null;
        int[][] coefIndices = null;
        int ipt = 0;
        boolean isCompressed = false;
        this.readLine();
        while (this.line != null && this.parseLineParameters(moFields, moFieldMap) > 0) {
            while (this.readLine() != null && !this.line.startsWith("property_flags:")) {
                String[] tokens = this.getTokens();
                block10: for (int i = 0; i < this.fieldCount; ++i) {
                    switch (this.fieldTypes[i]) {
                        case -1: {
                            ipt = this.parseInt(tokens[i]) - 1;
                            continue block10;
                        }
                        case 1: {
                            energy[ipt] = this.parseFloat(tokens[i]);
                            continue block10;
                        }
                        case 2: {
                            occupancy[ipt] = this.parseFloat(tokens[i]);
                            continue block10;
                        }
                        case 3: {
                            this.fillCsfArray("eig_vec", tokens, i, list[ipt]);
                            continue block10;
                        }
                        case 4: {
                            isCompressed = true;
                            if (listCompressed == null) {
                                listCompressed = new float[this.nOrbitals][this.nOrbitals];
                            }
                            this.fillCsfArray("eig_vec_compressed", tokens, i, listCompressed[ipt]);
                            continue block10;
                        }
                        case 5: {
                            if (coefIndices == null) {
                                coefIndices = new int[this.nOrbitals][this.nOrbitals];
                            }
                            this.fillCsfArray("coef_indices", tokens, i, coefIndices[ipt]);
                        }
                    }
                }
            }
        }
        for (int iMo = 0; iMo < this.nOrbitals; ++iMo) {
            if (isCompressed) {
                int pt;
                for (int i = 0; i < coefIndices[iMo].length && (pt = coefIndices[iMo][i] - 1) >= 0; ++i) {
                    list[iMo][pt] = listCompressed[iMo][i];
                }
            }
            for (int i = 0; i < this.nOrbitals; ++i) {
                if (!(Math.abs(list[iMo][i]) < 1.0E-4f)) continue;
                list[iMo][i] = 0.0f;
            }
            Hashtable<String, Object> mo = new Hashtable<String, Object>();
            mo.put("energy", new Float(energy[iMo]));
            mo.put("occupancy", new Float(occupancy[iMo]));
            mo.put("coefficients", list[iMo]);
            this.orbitals.addElement(mo);
        }
        this.setMOs("eV");
    }

    void processBasisObject(String sto_gto) throws Exception {
        int ipt;
        String[] atomNos = CsfReader.getTokens(this.atomicNumbers);
        this.nOrbitals = this.nSlaters + this.nGaussians;
        boolean isGaussian = sto_gto.equals("gto");
        float[][] zetas = new float[this.nOrbitals][];
        float[][] contractionCoefs = null;
        String[] types = new String[this.nOrbitals];
        int[] shells = new int[this.nOrbitals];
        int nZetas = 0;
        this.readLine();
        while (this.line != null && this.parseLineParameters(moFields, moFieldMap) > 0) {
            if (nZetas == 0) {
                nZetas = this.getPropertyCount(sto_gto + "_exp");
            }
            ipt = 0;
            while (this.readLine() != null && !this.line.startsWith("property_flags:")) {
                String[] tokens = this.getTokens();
                block9: for (int i = 0; i < this.fieldCount; ++i) {
                    String field = tokens[i];
                    switch (this.fieldTypes[i]) {
                        case -1: {
                            ipt = this.parseInt(field) - 1;
                            continue block9;
                        }
                        case 6: {
                            types[ipt] = field;
                            continue block9;
                        }
                        case 7: 
                        case 9: {
                            zetas[ipt] = new float[nZetas];
                            this.fillCsfArray(sto_gto + "_exp", tokens, i, zetas[ipt]);
                            continue block9;
                        }
                        case 10: {
                            shells[ipt] = this.parseInt(field);
                            continue block9;
                        }
                        case 8: {
                            if (contractionCoefs == null) {
                                contractionCoefs = new float[this.nOrbitals][nZetas];
                            }
                            this.fillCsfArray("contractions", tokens, i, contractionCoefs[ipt]);
                        }
                    }
                }
            }
        }
        if (isGaussian) {
            Vector<int[]> sdata = new Vector<int[]>();
            Vector<float[]> gdata = new Vector<float[]>();
            int iShell = 0;
            int gaussianCount = 0;
            for (int ipt2 = 0; ipt2 < this.nGaussians; ++ipt2) {
                int iAtom;
                if (shells[ipt2] == iShell) continue;
                iShell = shells[ipt2];
                int[] slater = new int[4];
                slater[0] = iAtom = this.atomSetCollection.getAtomNameIndex(((String[])this.connectors.get(sto_gto + "_basis_fxn" + (ipt2 + 1)))[0]);
                slater[1] = JmolAdapter.getQuantumShellTagID(types[ipt2].substring(0, 1));
                int nZ = 0;
                while (++nZ < nZetas && zetas[ipt2][nZ] != 0.0f) {
                }
                slater[2] = gaussianCount;
                slater[3] = nZ;
                sdata.addElement(slater);
                gaussianCount += nZ;
                for (int i = 0; i < nZ; ++i) {
                    gdata.addElement(new float[]{zetas[ipt2][i], contractionCoefs[ipt2][i]});
                }
            }
            float[][] garray = new float[gaussianCount][];
            for (int i = 0; i < gaussianCount; ++i) {
                garray[i] = (float[])gdata.get(i);
            }
            this.moData.put("shells", sdata);
            this.moData.put("gaussians", garray);
        } else {
            for (ipt = 0; ipt < this.nSlaters; ++ipt) {
                int iAtom = this.atomSetCollection.getAtomNameIndex(((String[])this.connectors.get(sto_gto + "_basis_fxn" + (ipt + 1)))[0]);
                int atomicNumber = this.parseInt(atomNos[iAtom]);
                for (int i = 0; i < nZetas && zetas[ipt][i] != 0.0f; ++i) {
                    this.createSlaterByType(iAtom, atomicNumber, types[ipt], zetas[ipt][i] * (float)(i == 0 ? 1 : -1), contractionCoefs == null ? 1.0f : contractionCoefs[ipt][i]);
                }
            }
            this.setSlaters();
        }
    }

    void createSlaterByType(int iAtom, int atomicNumber, String type, float zeta, float coef) {
        int pt = "S Px Py Pz Dx2-y2 Dxz Dz2 Dyz Dxy".indexOf(type);
        float absZeta = Math.abs(zeta);
        switch (pt) {
            case 0: {
                this.addSlater(iAtom, 0, 0, 0, MopacData.getNPQs(atomicNumber) - 1, zeta, MopacData.getMopacConstS(atomicNumber, absZeta) * coef);
                return;
            }
            case 2: 
            case 5: 
            case 8: {
                this.addSlater(iAtom, pt == 2 ? 1 : 0, pt == 5 ? 1 : 0, pt == 8 ? 1 : 0, MopacData.getNPQp(atomicNumber) - 2, zeta, MopacData.getMopacConstP(atomicNumber, absZeta) * coef);
                return;
            }
            case 11: 
            case 18: 
            case 22: 
            case 26: 
            case 30: {
                int dPt = pt == 11 ? 0 : (pt == 18 ? 1 : (pt == 22 ? 2 : (pt == 26 ? 3 : 4)));
                int dPt3 = dPt * 3;
                this.addSlater(iAtom, dValues[dPt3++], dValues[dPt3++], dValues[dPt3++], MopacData.getNPQd(atomicNumber) - 3, zeta, MopacData.getMopacConstD(atomicNumber, absZeta) * MopacData.getFactorD(dPt) * coef);
                return;
            }
        }
    }
}

