/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

public class CubeReader
extends AtomSetCollectionReader {
    boolean negativeAtomCount;
    int atomCount;
    boolean isAngstroms = false;
    final int[] voxelCounts = new int[3];
    final float[] origin = new float[3];
    final float[][] voxelVectors = new float[3][];

    public void readAtomSetCollection(BufferedReader br) {
        this.reader = br;
        this.atomSetCollection = new AtomSetCollection("cube");
        try {
            this.atomSetCollection.newAtomSet();
            this.readTitleLines();
            this.readAtomCountAndOrigin();
            this.readVoxelVectors();
            this.readAtoms();
            this.readExtraLine();
        }
        catch (Exception e) {
            this.setError(e);
        }
    }

    void readTitleLines() throws Exception {
        if (this.readLine().indexOf("#JVXL") == 0) {
            while (this.readLine().indexOf("#") == 0) {
            }
        }
        this.atomSetCollection.setAtomSetName(this.line.trim() + " - " + this.readLineTrimmed());
    }

    void readAtomCountAndOrigin() throws Exception {
        this.readLine();
        this.isAngstroms = this.line.indexOf("ANGSTROMS") >= 0;
        String[] tokens = this.getTokens();
        if (tokens[0].charAt(0) == '+') {
            tokens[0] = '-' + tokens[0].substring(1);
        }
        this.atomCount = this.parseInt(tokens[0]);
        this.origin[0] = this.parseFloat(tokens[1]);
        this.origin[1] = this.parseFloat(tokens[2]);
        this.origin[2] = this.parseFloat(tokens[3]);
        if (this.atomCount < 0) {
            this.atomCount = -this.atomCount;
            this.negativeAtomCount = true;
        }
    }

    void readVoxelVectors() throws Exception {
        this.readVoxelVector(0);
        this.readVoxelVector(1);
        this.readVoxelVector(2);
    }

    void readVoxelVector(int voxelVectorIndex) throws Exception {
        this.readLine();
        float[] voxelVector = new float[3];
        this.voxelVectors[voxelVectorIndex] = voxelVector;
        this.voxelCounts[voxelVectorIndex] = this.parseInt(this.line);
        voxelVector[0] = this.parseFloat();
        voxelVector[1] = this.parseFloat();
        voxelVector[2] = this.parseFloat();
    }

    void readAtoms() throws Exception {
        for (int i = 0; i < this.atomCount; ++i) {
            this.readLine();
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementNumber = (short)this.parseInt(this.line);
            atom.partialCharge = this.parseFloat();
            atom.x = this.parseFloat();
            atom.y = this.parseFloat();
            atom.z = this.parseFloat();
            if (this.isAngstroms) continue;
            atom.scale(0.5291772f);
        }
    }

    void readExtraLine() throws Exception {
        int nSurfaces;
        if (this.negativeAtomCount) {
            this.readLine();
        }
        if ((nSurfaces = this.parseInt(this.line)) != Integer.MIN_VALUE && nSurfaces < 0) {
            this.atomSetCollection.setFileTypeName("jvxl");
        }
    }
}

