/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.util.Hashtable;
import java.util.Vector;
import org.jmol.adapter.readers.more.MOReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;

public abstract class GamessReader
extends MOReader {
    protected Vector atomNames;
    private Hashtable calcOptions;
    private boolean isTypeSet;

    protected abstract void readAtomsInBohrCoordinates() throws Exception;

    protected void readGaussianBasis(String initiator, String terminator) throws Exception {
        String[] tokens;
        Vector<String[]> gdata = new Vector<String[]>();
        this.gaussianCount = 0;
        int nGaussians = 0;
        this.shellCount = 0;
        String thisShell = "0";
        this.discardLinesUntilContains(initiator);
        this.readLine();
        int[] slater = null;
        Hashtable shellsByAtomType = new Hashtable();
        Vector<int[]> slatersByAtomType = new Vector<int[]>();
        String atomType = null;
        block4: while (this.readLine() != null && this.line.indexOf(terminator) < 0) {
            if (this.line.indexOf("(") >= 0) {
                this.line = GamessReader.fixBasisLine(this.line);
            }
            tokens = this.getTokens();
            switch (tokens.length) {
                case 1: {
                    if (atomType != null) {
                        if (slater != null) {
                            slater[2] = nGaussians;
                            slatersByAtomType.addElement(slater);
                            slater = null;
                        }
                        shellsByAtomType.put(atomType, slatersByAtomType);
                    }
                    slatersByAtomType = new Vector();
                    atomType = tokens[0];
                    continue block4;
                }
                case 0: {
                    continue block4;
                }
            }
            if (!tokens[0].equals(thisShell)) {
                if (slater != null) {
                    slater[2] = nGaussians;
                    slatersByAtomType.addElement(slater);
                }
                thisShell = tokens[0];
                ++this.shellCount;
                slater = new int[]{JmolAdapter.getQuantumShellTagID(this.fixShellTag(tokens[1])), this.gaussianCount, 0};
                nGaussians = 0;
            }
            ++nGaussians;
            ++this.gaussianCount;
            gdata.addElement(tokens);
        }
        if (slater != null) {
            slater[2] = nGaussians;
            slatersByAtomType.addElement(slater);
        }
        if (atomType != null) {
            shellsByAtomType.put(atomType, slatersByAtomType);
        }
        this.gaussians = new float[this.gaussianCount][];
        for (int i = 0; i < this.gaussianCount; ++i) {
            tokens = (String[])gdata.get(i);
            this.gaussians[i] = new float[tokens.length - 3];
            for (int j = 3; j < tokens.length; ++j) {
                this.gaussians[i][j - 3] = this.parseFloat(tokens[j]);
            }
        }
        int atomCount = this.atomNames.size();
        if (this.shells == null && atomCount > 0) {
            this.shells = new Vector();
            for (int i = 0; i < atomCount; ++i) {
                atomType = (String)this.atomNames.elementAt(i);
                Vector slaters = (Vector)shellsByAtomType.get(atomType);
                if (slaters == null) {
                    Logger.error("slater for atom " + i + " atomType " + atomType + " was not found in listing. Ignoring molecular orbitals");
                    return;
                }
                for (int j = 0; j < slaters.size(); ++j) {
                    slater = (int[])slaters.elementAt(j);
                    this.shells.addElement(new int[]{i, slater[0], slater[1], slater[2]});
                }
            }
        }
        if (Logger.debugging) {
            Logger.debug(this.shellCount + " slater shells read");
            Logger.debug(this.gaussianCount + " gaussian primitives read");
        }
    }

    protected abstract String fixShellTag(String var1);

    protected void readFrequencies() throws Exception {
        int totalFrequencyCount = 0;
        int atomCount = this.atomSetCollection.getLastAtomSetAtomCount();
        float[] xComponents = new float[5];
        float[] yComponents = new float[5];
        float[] zComponents = new float[5];
        float[] frequencies = new float[5];
        this.discardLinesUntilContains("FREQUENCY:");
        while (this.line != null && this.line.indexOf("FREQUENCY:") >= 0) {
            int lineBaseFreqCount = totalFrequencyCount;
            int lineFreqCount = 0;
            String[] tokens = this.getTokens();
            for (int i = 0; i < tokens.length; ++i) {
                float frequency = this.parseFloat(tokens[i]);
                if (tokens[i].equals("I")) {
                    frequencies[lineFreqCount - 1] = -frequencies[lineFreqCount - 1];
                }
                if (Float.isNaN(frequency)) continue;
                frequencies[lineFreqCount] = frequency;
                ++lineFreqCount;
                if (Logger.debugging) {
                    Logger.debug(totalFrequencyCount + " frequency=" + frequency);
                }
                if (lineFreqCount == 5) break;
            }
            String[] red_masses = null;
            String[] intensities = null;
            this.readLine();
            if (this.line.indexOf("MASS") >= 0) {
                red_masses = this.getTokens();
                this.readLine();
            }
            if (this.line.indexOf("INTENS") >= 0) {
                intensities = this.getTokens();
            }
            for (int i = 0; i < lineFreqCount; ++i) {
                if (++totalFrequencyCount > 1) {
                    this.atomSetCollection.cloneFirstAtomSet();
                }
                this.atomSetCollection.setAtomSetName(frequencies[i] + " cm-1");
                this.atomSetCollection.setAtomSetProperty("Frequency", frequencies[i] + " cm-1");
                if (red_masses != null) {
                    this.atomSetCollection.setAtomSetProperty("Reduced Mass", red_masses[i + 2] + " AMU");
                }
                if (intensities == null) continue;
                this.atomSetCollection.setAtomSetProperty("IR Intensity", intensities[i + 2] + " D^2/AMU-Angstrom^2");
            }
            Atom[] atoms = this.atomSetCollection.getAtoms();
            this.discardLinesUntilBlank();
            for (int i = 0; i < atomCount; ++i) {
                this.readLine();
                this.readComponents(lineFreqCount, xComponents);
                this.readLine();
                this.readComponents(lineFreqCount, yComponents);
                this.readLine();
                this.readComponents(lineFreqCount, zComponents);
                for (int j = 0; j < lineFreqCount; ++j) {
                    int atomIndex = (lineBaseFreqCount + j) * atomCount + i;
                    Atom atom = atoms[atomIndex];
                    atom.vectorX = xComponents[j];
                    atom.vectorY = yComponents[j];
                    atom.vectorZ = zComponents[j];
                }
            }
            this.discardLines(12);
            this.readLine();
        }
    }

    private void readComponents(int count, float[] components) {
        int i = 0;
        int start = 20;
        while (i < count) {
            components[i] = this.parseFloat(this.line, start, start + 12);
            ++i;
            start += 12;
        }
    }

    protected static String fixBasisLine(String line) {
        int pt;
        line = line.replace(')', ' ');
        while ((pt = line.indexOf("(")) >= 0) {
            int pt1 = pt;
            while (line.charAt(--pt1) == ' ') {
            }
            while (line.charAt(--pt1) != ' ') {
            }
            line = line.substring(0, ++pt1) + line.substring(pt + 1);
        }
        return line;
    }

    protected void setCalculationType() {
        if (this.calcOptions == null || this.isTypeSet) {
            return;
        }
        this.isTypeSet = true;
        String SCFtype = (String)this.calcOptions.get("contrl_options_SCFTYP");
        String Runtype = (String)this.calcOptions.get("contrl_options_RUNTYP");
        String igauss = (String)this.calcOptions.get("basis_options_IGAUSS");
        String gbasis = (String)this.calcOptions.get("basis_options_GBASIS");
        boolean DFunc = !"0".equals((String)this.calcOptions.get("basis_options_NDFUNC"));
        boolean PFunc = !"0".equals((String)this.calcOptions.get("basis_options_NPFUNC"));
        boolean FFunc = !"0".equals((String)this.calcOptions.get("basis_options_NFFUNC"));
        String DFTtype = (String)this.calcOptions.get("contrl_options_DFTTYP");
        int perturb = this.parseInt((String)this.calcOptions.get("contrl_options_MPLEVL"));
        String CItype = (String)this.calcOptions.get("contrl_options_CITYP");
        String CCtype = (String)this.calcOptions.get("contrl_options_CCTYP");
        if (igauss == null && SCFtype == null) {
            return;
        }
        if (this.calculationType.equals("?")) {
            this.calculationType = "";
        }
        if (igauss != null) {
            if ("0".equals(igauss)) {
                boolean recognized = false;
                if (this.calculationType.length() > 0) {
                    this.calculationType = this.calculationType + " ";
                }
                if (gbasis.startsWith("ACC")) {
                    this.calculationType = this.calculationType + "aug-cc-p";
                }
                if (gbasis.startsWith("CC")) {
                    this.calculationType = this.calculationType + "cc-p";
                }
                if ((gbasis.startsWith("ACC") || gbasis.startsWith("CC")) && gbasis.endsWith("C")) {
                    this.calculationType = this.calculationType + "C";
                }
                if (gbasis.contains("CCD")) {
                    this.calculationType = this.calculationType + "VDZ";
                    recognized = true;
                }
                if (gbasis.contains("CCT")) {
                    this.calculationType = this.calculationType + "VTZ";
                    recognized = true;
                }
                if (gbasis.contains("CCQ")) {
                    this.calculationType = this.calculationType + "VQZ";
                    recognized = true;
                }
                if (gbasis.contains("CC5")) {
                    this.calculationType = this.calculationType + "V5Z";
                    recognized = true;
                }
                if (gbasis.contains("CC6")) {
                    this.calculationType = this.calculationType + "V6Z";
                    recognized = true;
                }
                if (!recognized) {
                    this.calculationType = this.calculationType + gbasis;
                }
            } else {
                if (this.calculationType.length() > 0) {
                    this.calculationType = this.calculationType + " ";
                }
                this.calculationType = this.calculationType + igauss + "-" + TextFormat.simpleReplace(gbasis, "N", "");
                if ("T".equals((String)this.calcOptions.get("basis_options_DIFFSP"))) {
                    if ("T".equals((String)this.calcOptions.get("basis_options_DIFFS"))) {
                        this.calculationType = this.calculationType + "+";
                    }
                    this.calculationType = this.calculationType + "+";
                }
                this.calculationType = this.calculationType + "G";
                if (DFunc || PFunc || FFunc) {
                    this.calculationType = this.calculationType + "(";
                    if (FFunc) {
                        this.calculationType = this.calculationType + "f";
                        if (DFunc || PFunc) {
                            this.calculationType = this.calculationType + ",";
                        }
                    }
                    if (DFunc) {
                        this.calculationType = this.calculationType + "d";
                        if (PFunc) {
                            this.calculationType = this.calculationType + ",";
                        }
                    }
                    if (PFunc) {
                        this.calculationType = this.calculationType + "p";
                    }
                    this.calculationType = this.calculationType + ")";
                }
            }
            if (DFTtype != null && !DFTtype.contains("NONE")) {
                if (this.calculationType.length() > 0) {
                    this.calculationType = this.calculationType + " ";
                }
                this.calculationType = this.calculationType + DFTtype;
            }
            if (CItype != null && !CItype.contains("NONE")) {
                if (this.calculationType.length() > 0) {
                    this.calculationType = this.calculationType + " ";
                }
                this.calculationType = this.calculationType + CItype;
            }
            if (CCtype != null && !CCtype.contains("NONE")) {
                if (this.calculationType.length() > 0) {
                    this.calculationType = this.calculationType + " ";
                }
                this.calculationType = this.calculationType + CCtype;
            }
            if (perturb > 0) {
                if (this.calculationType.length() > 0) {
                    this.calculationType = this.calculationType + " ";
                }
                this.calculationType = this.calculationType + "MP" + perturb;
            }
            if (SCFtype != null) {
                if (this.calculationType.length() > 0) {
                    this.calculationType = this.calculationType + " ";
                }
                this.calculationType = this.calculationType + SCFtype + " " + Runtype;
            }
        }
    }

    protected void readControlInfo() throws Exception {
        this.readCalculationInfo("contrl_options_");
    }

    protected void readBasisInfo() throws Exception {
        this.readCalculationInfo("basis_options_");
    }

    private void readCalculationInfo(String type) throws Exception {
        if (this.calcOptions == null) {
            this.calcOptions = new Hashtable();
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("calculationOptions", this.calcOptions);
        }
        while (this.readLine() != null && (this.line = this.line.trim()).length() > 0) {
            if (this.line.indexOf("=") < 0) continue;
            String[] tokens = GamessReader.getTokens(TextFormat.simpleReplace(this.line, "=", " = "));
            for (int i = 0; i < tokens.length; ++i) {
                if (!tokens[i].equals("=")) continue;
                try {
                    String value;
                    String key = type + tokens[i - 1];
                    String string = value = key.equals("basis_options_SPLIT3") ? tokens[++i] + " " + tokens[++i] + " " + tokens[++i] : tokens[++i];
                    if (Logger.debugging) {
                        Logger.debug(key + " = " + value);
                    }
                    this.calcOptions.put(key, value);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }
}

