/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import java.util.Vector;
import javax.vecmath.Vector3f;
import org.jmol.adapter.readers.more.GamessReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.util.Logger;

public class GamessUSReader
extends GamessReader {
    public void readAtomSetCollection(BufferedReader reader) {
        this.readAtomSetCollection(reader, "gamess");
    }

    protected boolean checkLine() throws Exception {
        if (this.line.contains("BASIS OPTIONS")) {
            this.readBasisInfo();
            return true;
        }
        if (this.line.contains("$CONTRL OPTIONS")) {
            this.readControlInfo();
            return true;
        }
        if (this.line.indexOf("ATOMIC BASIS SET") >= 0) {
            this.readGaussianBasis("SHELL TYPE", "TOTAL");
            return false;
        }
        boolean isBohr = this.line.indexOf("COORDINATES (BOHR)") >= 0;
        if (isBohr || this.line.indexOf("COORDINATES OF ALL ATOMS ARE (ANGS)") >= 0) {
            if (this.doGetModel(++this.modelNumber)) {
                this.atomNames = new Vector();
                if (isBohr) {
                    this.readAtomsInBohrCoordinates();
                } else {
                    this.readAtomsInAngstromCoordinates();
                }
                this.iHaveAtoms = true;
                return true;
            }
            if (this.isLastModel(this.modelNumber) && this.iHaveAtoms) {
                this.continuing = false;
                return false;
            }
            this.iHaveAtoms = false;
        }
        if (!this.iHaveAtoms) {
            return true;
        }
        if (this.line.indexOf("FREQUENCIES IN CM") >= 0) {
            this.readFrequencies();
            return true;
        }
        if (this.line.indexOf("SUMMARY OF THE EFFECTIVE FRAGMENT") >= 0) {
            this.readEFPInBohrCoordinates();
            return false;
        }
        if (this.line.indexOf("  TOTAL MULLIKEN AND LOWDIN ATOMIC POPULATIONS") >= 0) {
            this.readPartialCharges();
            return false;
        }
        if (this.line.indexOf("ELECTROSTATIC MOMENTS") >= 0) {
            this.readDipoleMoment();
            return true;
        }
        if (this.line.indexOf("- ALPHA SET -") >= 0) {
            this.alphaBeta = "alpha";
        } else if (this.line.indexOf("- BETA SET -") >= 0) {
            this.alphaBeta = "beta";
        } else if (this.line.indexOf("  EIGENVECTORS") >= 0 || this.line.indexOf("  INITIAL GUESS ORBITALS") >= 0 || this.line.indexOf("  MCSCF OPTIMIZED ORBITALS") >= 0 || this.line.indexOf("  MCSCF NATURAL ORBITALS") >= 0 || this.line.indexOf("  MOLECULAR ORBITALS") >= 0 && this.line.indexOf("  MOLECULAR ORBITALS LOCALIZED BY THE POPULATION METHOD") < 0) {
            if (!this.filterMO()) {
                return true;
            }
            this.readMolecularOrbitals(1);
            return false;
        }
        if (this.line.indexOf("EDMISTON-RUEDENBERG ENERGY LOCALIZED ORBITALS") >= 0 || this.line.indexOf("  THE PIPEK-MEZEY POPULATION LOCALIZED ORBITALS ARE") >= 0) {
            if (!this.filterMO()) {
                return true;
            }
            this.readMolecularOrbitals(0);
            return false;
        }
        if (this.line.indexOf("  NATURAL ORBITALS IN ATOMIC ORBITAL BASIS") >= 0) {
            if (!this.filterMO()) {
                return true;
            }
            this.readMolecularOrbitals(2);
            return false;
        }
        return this.checkNboLine();
    }

    protected void readMolecularOrbitals(int headerType) throws Exception {
        this.setCalculationType();
        super.readMolecularOrbitals(headerType);
    }

    protected void readEFPInBohrCoordinates() throws Exception {
        int atomCountInFirstModel = this.atomSetCollection.getAtomCount();
        this.discardLinesUntilContains("MULTIPOLE COORDINATES");
        this.readLine();
        this.readLine();
        while (this.readLine() != null && this.line.length() >= 72) {
            String atomName = this.line.substring(1, 2);
            if (atomName.charAt(0) == 'Z') {
                atomName = this.line.substring(2, 3);
            } else if (this.parseFloat(this.line, 67, 73) == 0.0f) continue;
            float x = this.parseFloat(this.line, 8, 25);
            float y = this.parseFloat(this.line, 25, 40);
            float z = this.parseFloat(this.line, 40, 56);
            if (Float.isNaN(x) || Float.isNaN(y) || Float.isNaN(z)) break;
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.atomName = atomName + ++atomCountInFirstModel;
            atom.set(x, y, z);
            atom.scale(0.5291772f);
            this.atomNames.addElement(atomName);
        }
    }

    protected void readAtomsInBohrCoordinates() throws Exception {
        String atomName;
        this.readLine();
        this.atomSetCollection.newAtomSet();
        int n = 0;
        while (this.readLine() != null && (atomName = this.parseToken(this.line, 1, 6)) != null) {
            float x = this.parseFloat(this.line, 17, 37);
            float y = this.parseFloat(this.line, 37, 57);
            float z = this.parseFloat(this.line, 57, 77);
            if (Float.isNaN(x) || Float.isNaN(y) || Float.isNaN(z)) break;
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.atomName = atomName + ++n;
            atom.set(x, y, z);
            atom.scale(0.5291772f);
            this.atomNames.addElement(atomName);
        }
    }

    private void readAtomsInAngstromCoordinates() throws Exception {
        Atom atom;
        float z;
        float y;
        float x;
        String atomName;
        this.readLine();
        this.readLine();
        this.atomSetCollection.newAtomSet();
        int n = 0;
        while (this.readLine() != null && (atomName = this.parseToken(this.line, 1, 6)) != null) {
            x = this.parseFloat(this.line, 16, 31);
            y = this.parseFloat(this.line, 31, 46);
            z = this.parseFloat(this.line, 46, 61);
            if (Float.isNaN(x) || Float.isNaN(y) || Float.isNaN(z)) break;
            atom = this.atomSetCollection.addNewAtom();
            atom.atomName = atomName + ++n;
            atom.set(x, y, z);
            this.atomNames.addElement(atomName);
        }
        if (this.line.indexOf("COORDINATES OF FRAGMENT MULTIPOLE CENTERS (ANGS)") >= 0) {
            this.readLine();
            this.readLine();
            this.readLine();
            while (this.readLine() != null && (atomName = this.parseToken(this.line, 1, 2)) != null) {
                if (this.parseToken(this.line, 1, 2).equals("Z")) {
                    atomName = this.parseToken(this.line, 2, 3);
                } else {
                    if (this.parseToken(this.line, 1, 9).equals("FRAGNAME")) continue;
                    atomName = this.parseToken(this.line, 1, 2);
                }
                x = this.parseFloat(this.line, 16, 31);
                y = this.parseFloat(this.line, 31, 46);
                z = this.parseFloat(this.line, 46, 61);
                if (Float.isNaN(x) || Float.isNaN(y) || Float.isNaN(z)) break;
                atom = this.atomSetCollection.addNewAtom();
                atom.atomName = atomName + ++n;
                atom.set(x, y, z);
                this.atomNames.addElement(atomName);
            }
        }
    }

    protected String fixShellTag(String tag) {
        return tag;
    }

    void readPartialCharges() throws Exception {
        String searchstr;
        String[] tokens = null;
        String string = searchstr = this.havePartialChargeFilter && this.filter.toUpperCase().indexOf("CHARGE=LOW") >= 0 ? "LOW.POP." : "MULL.POP.";
        while (this.readLine() != null && ("".equals(this.line.trim()) || this.line.contains("ATOM"))) {
            tokens = this.getTokens();
        }
        int poploc = 0;
        while (++poploc < tokens.length && !searchstr.equals(tokens[poploc])) {
        }
        if (++poploc >= tokens.length || !"CHARGE".equals(tokens[poploc++])) {
            return;
        }
        Atom[] atoms = this.atomSetCollection.getAtoms();
        int startAtom = this.atomSetCollection.getLastAtomSetAtomIndex();
        int endAtom = this.atomSetCollection.getAtomCount();
        for (int i = startAtom; i < endAtom && this.readLine() != null; ++i) {
            atoms[i].partialCharge = this.parseFloat(GamessUSReader.getTokens(this.prevline)[poploc]);
        }
    }

    void readDipoleMoment() throws Exception {
        String[] tokens = null;
        this.readLine();
        while (this.line != null && ("".equals(this.line.trim()) || !this.line.contains("DX"))) {
            this.readLine();
        }
        tokens = GamessUSReader.getTokens(this.line);
        if (tokens.length != 5) {
            return;
        }
        if ("DX".equals(tokens[0]) && "DY".equals(tokens[1]) && "DZ".equals(tokens[2])) {
            tokens = GamessUSReader.getTokens(this.readLine());
            Vector3f dipole = new Vector3f(this.parseFloat(tokens[0]), this.parseFloat(tokens[1]), this.parseFloat(tokens[2]));
            Logger.info("Molecular dipole for model " + this.atomSetCollection.getAtomSetCount() + " = " + dipole);
            this.atomSetCollection.setAtomSetAuxiliaryInfo("dipole", dipole);
        }
    }
}

