/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Vector3f;
import org.jmol.adapter.readers.more.MOReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;

public class GaussianReader
extends MOReader {
    private static final int STD_ORIENTATION_ATOMIC_NUMBER_OFFSET = 1;
    private static final int FREQ_FIRST_VECTOR_OFFSET = 2;
    private String energyString = "";
    private String energyKey = "";
    private int calculationNumber = 1;
    private int scanPoint = -1;
    private int equivalentAtomSets = 0;
    private int stepNumber = 0;

    public void readAtomSetCollection(BufferedReader reader) {
        this.readAtomSetCollection(reader, "gaussian");
    }

    protected boolean checkLine() throws Exception {
        if (this.line.startsWith(" Step number")) {
            this.equivalentAtomSets = 0;
            ++this.stepNumber;
            int scanPointIndex = this.line.indexOf("scan point");
            this.scanPoint = scanPointIndex > 0 ? this.parseInt(this.line, scanPointIndex + 10) : -1;
            return true;
        }
        if (this.line.indexOf("-- Stationary point found") > 0) {
            if (this.scanPoint >= 0) {
                ++this.scanPoint;
            }
            return true;
        }
        if (this.line.indexOf("Input orientation:") >= 0 || this.line.indexOf("Z-Matrix orientation:") >= 0 || this.line.indexOf("Standard orientation:") >= 0) {
            if (this.doGetModel(++this.modelNumber)) {
                ++this.equivalentAtomSets;
                if (Logger.debugging) {
                    Logger.debug(" model " + this.modelNumber + " step " + this.stepNumber + " equivalentAtomSet " + this.equivalentAtomSets + " calculation " + this.calculationNumber + " scan point " + this.scanPoint + this.line);
                }
                this.readAtoms();
                this.iHaveAtoms = true;
                return false;
            }
            if (this.isLastModel(this.modelNumber) && this.iHaveAtoms) {
                this.continuing = false;
                return false;
            }
            this.iHaveAtoms = false;
            return true;
        }
        if (!this.iHaveAtoms) {
            return true;
        }
        if (this.line.startsWith(" Energy=")) {
            this.setEnergy();
            return true;
        }
        if (this.line.startsWith(" SCF Done:")) {
            this.readSCFDone();
            return true;
        }
        if (this.line.startsWith(" Harmonic frequencies")) {
            this.readFrequencies();
            return true;
        }
        if (this.line.startsWith(" Total atomic charges:") || this.line.startsWith(" Mulliken atomic charges:")) {
            this.readPartialCharges();
            return true;
        }
        if (this.line.startsWith(" Dipole moment")) {
            this.readDipoleMoment();
            return true;
        }
        if (this.line.startsWith(" Standard basis:")) {
            Logger.debug(this.line);
            this.energyUnits = "";
            this.calculationType = this.line.substring(17).trim();
            return true;
        }
        if (this.line.startsWith(" General basis read from cards:")) {
            Logger.debug(this.line);
            this.energyUnits = "";
            this.calculationType = this.line.substring(31).trim();
            return true;
        }
        if (this.line.startsWith(" AO basis set:")) {
            this.readBasis();
            return true;
        }
        if (this.line.indexOf("Molecular Orbital Coefficients") >= 0) {
            if (!this.filterMO()) {
                return true;
            }
            this.readGaussianMolecularOrbitals();
            if (Logger.debugging) {
                Logger.debug(this.orbitals.size() + " molecular orbitals read");
            }
            return true;
        }
        if (this.line.startsWith(" Normal termination of Gaussian")) {
            ++this.calculationNumber;
            this.equivalentAtomSets = 0;
            return true;
        }
        return this.checkNboLine();
    }

    private void readSCFDone() throws Exception {
        String[] tokens = GaussianReader.getTokens(this.line, 11);
        this.energyKey = tokens[0];
        this.energyString = tokens[2] + " " + tokens[3];
        this.atomSetCollection.setAtomSetNames(this.energyKey + " = " + this.energyString, this.equivalentAtomSets);
        this.atomSetCollection.setAtomSetProperties(this.energyKey, this.energyString, this.equivalentAtomSets);
        tokens = GaussianReader.getTokens(this.readLine());
        this.atomSetCollection.setAtomSetProperties(tokens[0], tokens[2], this.equivalentAtomSets);
        this.atomSetCollection.setAtomSetProperties(tokens[3], tokens[5], this.equivalentAtomSets);
        tokens = GaussianReader.getTokens(this.readLine());
        this.atomSetCollection.setAtomSetProperties(tokens[0], tokens[2], this.equivalentAtomSets);
    }

    private void setEnergy() {
        String[] tokens = this.getTokens();
        this.energyKey = "Energy";
        this.energyString = tokens[1];
        this.atomSetCollection.setAtomSetNames("Energy = " + tokens[1], this.equivalentAtomSets);
    }

    private void readAtoms() throws Exception {
        this.atomSetCollection.newAtomSet();
        this.atomSetCollection.setAtomSetName(this.energyKey + " = " + this.energyString);
        String path = this.getTokens()[0];
        this.discardLines(4);
        while (this.readLine() != null && !this.line.startsWith(" --")) {
            String[] tokens = this.getTokens();
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementNumber = (byte)this.parseInt(tokens[1]);
            if (atom.elementNumber < 0) {
                atom.elementNumber = 0;
            }
            int offset = tokens.length - 3;
            atom.x = this.parseFloat(tokens[offset]);
            atom.y = this.parseFloat(tokens[++offset]);
            atom.z = this.parseFloat(tokens[++offset]);
        }
        this.atomSetCollection.setAtomSetProperty(".PATH", "Calculation " + this.calculationNumber + (this.scanPoint >= 0 ? SmarterJmolAdapter.PATH_SEPARATOR + "Scan Point " + this.scanPoint : "") + SmarterJmolAdapter.PATH_SEPARATOR + path);
    }

    void readBasis() throws Exception {
        String[] tokens;
        boolean doSphericalF;
        this.shells = new Vector();
        Vector<String[]> gdata = new Vector<String[]>();
        int atomCount = 0;
        this.gaussianCount = 0;
        this.shellCount = 0;
        String lastAtom = "";
        boolean doSphericalD = this.calculationType != null && this.calculationType.indexOf("5D") > 0;
        boolean bl = doSphericalF = this.calculationType != null && this.calculationType.indexOf("7F") > 0;
        while (this.readLine() != null && this.line.startsWith(" Atom")) {
            ++this.shellCount;
            tokens = this.getTokens();
            int[] slater = new int[4];
            if (!tokens[1].equals(lastAtom)) {
                ++atomCount;
            }
            lastAtom = tokens[1];
            slater[0] = atomCount - 1;
            String oType = tokens[4];
            slater[1] = doSphericalF && oType.indexOf("F") >= 0 || doSphericalD && oType.indexOf("D") >= 0 ? JmolAdapter.getQuantumShellTagIDSpherical(tokens[4]) : JmolAdapter.getQuantumShellTagID(tokens[4]);
            int nGaussians = this.parseInt(tokens[5]);
            slater[2] = this.gaussianCount;
            slater[3] = nGaussians;
            this.shells.addElement(slater);
            this.gaussianCount += nGaussians;
            for (int i = 0; i < nGaussians; ++i) {
                gdata.addElement(GaussianReader.getTokens(this.readLine()));
            }
        }
        if (atomCount == 0) {
            atomCount = 1;
        }
        this.gaussians = new float[this.gaussianCount][];
        for (int i = 0; i < this.gaussianCount; ++i) {
            tokens = (String[])gdata.get(i);
            this.gaussians[i] = new float[tokens.length];
            for (int j = 0; j < tokens.length; ++j) {
                this.gaussians[i][j] = this.parseFloat(tokens[j]);
            }
        }
        if (Logger.debugging) {
            Logger.debug(this.shellCount + " slater shells read");
            Logger.debug(this.gaussianCount + " gaussian primitives read");
        }
    }

    void readGaussianMolecularOrbitals() throws Exception {
        Hashtable[] mos = new Hashtable[5];
        Vector[] data = new Vector[5];
        int nThisLine = 0;
        while (this.readLine() != null && this.line.toUpperCase().indexOf("DENS") < 0) {
            int i;
            String[] tokens;
            if (this.line.indexOf("                    ") == 0) {
                this.addMOData(nThisLine, data, mos);
                tokens = GaussianReader.getTokens(this.readLine());
                nThisLine = tokens.length;
                for (i = 0; i < nThisLine; ++i) {
                    mos[i] = new Hashtable();
                    data[i] = new Vector();
                    mos[i].put("symmetry", tokens[i]);
                }
                tokens = GaussianReader.getStrings(this.readLine().substring(21), nThisLine, 10);
                for (i = 0; i < nThisLine; ++i) {
                    mos[i].put("energy", new Float(tokens[i]));
                }
                continue;
            }
            if (this.line.length() < 21 || this.line.charAt(11) != ' ' && !Character.isDigit(this.line.charAt(11))) continue;
            try {
                tokens = GaussianReader.getStrings(this.line.substring(21), nThisLine, 10);
                for (i = 0; i < nThisLine; ++i) {
                    data[i].addElement(tokens[i]);
                }
            }
            catch (Exception e) {
                Logger.error("Error reading Gaussian file Molecular Orbitals at line: " + this.line);
                break;
            }
        }
        this.addMOData(nThisLine, data, mos);
        this.setMOData(false);
    }

    private void readFrequencies() throws Exception, IOException {
        while (this.readLine() != null && this.line.indexOf(":") < 0) {
        }
        if (this.line == null) {
            throw new Exception("No frequencies encountered");
        }
        while ((this.line = this.readLine()) != null && this.line.length() > 15) {
            String[] symmetries = GaussianReader.getTokens(this.readLine());
            String[] frequencies = GaussianReader.getTokens(this.discardLinesUntilStartsWith(" Frequencies"), 15);
            String[] red_masses = GaussianReader.getTokens(this.discardLinesUntilStartsWith(" Red. masses"), 15);
            String[] frc_consts = GaussianReader.getTokens(this.discardLinesUntilStartsWith(" Frc consts"), 15);
            String[] intensities = GaussianReader.getTokens(this.discardLinesUntilStartsWith(" IR Inten"), 15);
            int frequencyCount = frequencies.length;
            for (int i = 0; i < frequencyCount; ++i) {
                this.atomSetCollection.cloneLastAtomSet();
                this.atomSetCollection.setAtomSetName(symmetries[i] + " " + frequencies[i] + " cm**-1");
                this.atomSetCollection.setAtomSetProperty(this.energyKey, this.energyString);
                this.atomSetCollection.setAtomSetProperty("Frequency", frequencies[i] + " cm**-1");
                this.atomSetCollection.setAtomSetProperty("Reduced Mass", red_masses[i] + " AMU");
                this.atomSetCollection.setAtomSetProperty("Force Constant", frc_consts[i] + " mDyne/A");
                this.atomSetCollection.setAtomSetProperty("IR Intensity", intensities[i] + " KM/Mole");
                this.atomSetCollection.setAtomSetProperty(".PATH", "Calculation " + this.calculationNumber + SmarterJmolAdapter.PATH_SEPARATOR + "Frequencies");
            }
            int atomCount = this.atomSetCollection.getLastAtomSetAtomCount();
            int firstModelAtom = this.atomSetCollection.getAtomCount() - frequencyCount * atomCount;
            this.discardLinesUntilStartsWith(" Atom AN");
            Atom[] atoms = this.atomSetCollection.getAtoms();
            for (int i = 0; i < atomCount; ++i) {
                String[] tokens = GaussianReader.getTokens(this.readLine());
                int atomCenterNumber = this.parseInt(tokens[0]);
                int offset = 2;
                for (int j = 0; j < frequencyCount; ++j) {
                    int atomOffset = firstModelAtom + j * atomCount + atomCenterNumber - 1;
                    Atom atom = atoms[atomOffset];
                    float x = this.parseFloat(tokens[offset++]);
                    float y = this.parseFloat(tokens[offset++]);
                    float z = this.parseFloat(tokens[offset++]);
                    atom.addVibrationVector(x, y, z);
                }
            }
        }
    }

    void readDipoleMoment() throws Exception {
        String[] tokens = GaussianReader.getTokens(this.readLine());
        if (tokens.length != 8) {
            return;
        }
        Vector3f dipole = new Vector3f(this.parseFloat(tokens[1]), this.parseFloat(tokens[3]), this.parseFloat(tokens[5]));
        Logger.info("Molecular dipole for model " + this.atomSetCollection.getAtomSetCount() + " = " + dipole);
        this.atomSetCollection.setAtomSetAuxiliaryInfo("dipole", dipole);
    }

    void readPartialCharges() throws Exception {
        this.discardLines(1);
        int atomCount = this.atomSetCollection.getAtomCount();
        int i0 = this.atomSetCollection.getLastAtomSetAtomIndex();
        Atom[] atoms = this.atomSetCollection.getAtoms();
        for (int i = i0; i < atomCount; ++i) {
            float charge;
            while (atoms[i].elementNumber == 0) {
                ++i;
            }
            atoms[i].partialCharge = charge = this.parseFloat(GaussianReader.getTokens(this.readLine())[2]);
        }
        Logger.info("Mulliken charges found for Model " + this.atomSetCollection.getAtomSetCount());
    }
}

