/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

public class HinReader
extends AtomSetCollectionReader {
    int atomIndex;
    int baseAtomIndex;

    public void readAtomSetCollection(BufferedReader reader) {
        this.reader = reader;
        this.atomSetCollection = new AtomSetCollection("hin");
        try {
            this.readAtoms();
        }
        catch (Exception e) {
            this.setError(e);
        }
    }

    void readAtoms() throws Exception {
        while (this.readLine() != null) {
            if (this.line.length() == 0 || this.line.charAt(0) == ';') continue;
            if (this.line.startsWith("mol ")) {
                this.processMol();
                continue;
            }
            if (this.line.startsWith("atom ")) {
                this.processAtom();
                continue;
            }
            if (!this.line.startsWith("endmol ")) continue;
            this.processEndmol();
        }
    }

    void processMol() throws Exception {
        this.atomSetCollection.newAtomSet();
        String molName = this.getMolName();
        this.atomSetCollection.setAtomSetName(molName);
        this.atomIndex = 0;
        this.baseAtomIndex = this.atomSetCollection.getAtomCount();
    }

    String getMolName() {
        this.parseToken(this.line);
        this.parseToken();
        return this.parseToken();
    }

    void processAtom() throws Exception {
        int fileAtomNumber = this.parseInt(this.line, 5);
        if (fileAtomNumber - 1 != this.atomIndex) {
            throw new Exception("bad atom number sequence ... expected:" + (this.atomIndex + 1) + " found:" + fileAtomNumber);
        }
        Atom atom = this.atomSetCollection.addNewAtom();
        this.parseToken();
        atom.elementSymbol = this.parseToken();
        this.parseToken();
        this.parseToken();
        atom.partialCharge = this.parseFloat();
        atom.x = this.parseFloat();
        atom.y = this.parseFloat();
        atom.z = this.parseFloat();
        int bondCount = this.parseInt();
        for (int i = 0; i < bondCount; ++i) {
            int bondOrder;
            int otherAtomNumber = this.parseInt();
            String bondTypeToken = this.parseToken();
            if (otherAtomNumber > this.atomIndex) continue;
            switch (bondTypeToken.charAt(0)) {
                case 's': {
                    bondOrder = 1;
                    break;
                }
                case 'd': {
                    bondOrder = 2;
                    break;
                }
                case 't': {
                    bondOrder = 3;
                    break;
                }
                case 'a': {
                    bondOrder = 515;
                    break;
                }
                default: {
                    throw new Exception("unrecognized bond type:" + bondTypeToken + " atom #" + fileAtomNumber);
                }
            }
            this.atomSetCollection.addNewBond(this.baseAtomIndex + this.atomIndex, this.baseAtomIndex + otherAtomNumber - 1, bondOrder);
        }
        ++this.atomIndex;
    }

    void processEndmol() {
    }
}

