/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import java.util.StringTokenizer;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;

public class JmeReader
extends AtomSetCollectionReader {
    StringTokenizer tokenizer;

    public void readAtomSetCollection(BufferedReader reader) {
        this.reader = reader;
        this.atomSetCollection = new AtomSetCollection("jme");
        try {
            this.readLine();
            this.tokenizer = new StringTokenizer(this.line, "\t ");
            int atomCount = this.parseInt(this.tokenizer.nextToken());
            int bondCount = this.parseInt(this.tokenizer.nextToken());
            this.atomSetCollection.setCollectionName("JME");
            this.readAtoms(atomCount);
            this.readBonds(bondCount);
        }
        catch (Exception e) {
            this.setError(e);
        }
    }

    void readAtoms(int atomCount) throws Exception {
        for (int i = 0; i < atomCount; ++i) {
            String strAtom = this.tokenizer.nextToken();
            int indexColon = strAtom.indexOf(58);
            String elementSymbol = (indexColon > 0 ? strAtom.substring(0, indexColon) : strAtom).intern();
            float x = this.parseFloat(this.tokenizer.nextToken());
            float y = this.parseFloat(this.tokenizer.nextToken());
            float z = 0.0f;
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementSymbol = elementSymbol;
            atom.set(x, y, z);
        }
    }

    void readBonds(int bondCount) throws Exception {
        for (int i = 0; i < bondCount; ++i) {
            int atomIndex1 = this.parseInt(this.tokenizer.nextToken());
            int atomIndex2 = this.parseInt(this.tokenizer.nextToken());
            int order = this.parseInt(this.tokenizer.nextToken());
            if (order < 1) {
                order = order == -1 ? 1025 : 1026;
            }
            this.atomSetCollection.addBond(new Bond(atomIndex1 - 1, atomIndex2 - 1, order));
        }
    }
}

