/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Vector;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;

abstract class MOReader
extends AtomSetCollectionReader {
    protected int shellCount = 0;
    protected int gaussianCount = 0;
    protected Hashtable moData = new Hashtable();
    protected Vector shells;
    protected float[][] gaussians;
    protected Vector orbitals = new Vector();
    protected String energyUnits = "";
    protected Vector moTypes;
    private boolean getNBOs;
    private boolean getNBOCharges;
    protected boolean haveNboCharges;
    private String[] filterTokens;
    private boolean filterIsNot;
    protected boolean iHaveAtoms = false;
    protected boolean continuing = true;
    protected boolean ignoreMOs = false;
    protected String alphaBeta = "";
    protected final int HEADER_GAMESS_UK_MO = 3;
    protected final int HEADER_GAMESS_OCCUPANCIES = 2;
    protected final int HEADER_GAMESS_ORIGINAL = 1;
    protected final int HEADER_NONE = 0;

    MOReader() {
    }

    public abstract void readAtomSetCollection(BufferedReader var1);

    protected abstract boolean checkLine() throws Exception;

    public void readAtomSetCollection(BufferedReader reader, String type) {
        this.initializeMoReader(reader, type);
        try {
            this.readLine();
            this.iHaveAtoms = false;
            while (this.line != null && this.continuing) {
                if (!this.checkLine()) continue;
                this.readLine();
            }
            this.finalizeMoReader();
        }
        catch (Exception e) {
            this.setError(e);
        }
    }

    protected void finalizeMoReader() {
    }

    private void initializeMoReader(BufferedReader reader, String type) {
        this.reader = reader;
        this.atomSetCollection = new AtomSetCollection("type");
        this.line = "\nNBOs in the AO basis:";
        this.getNBOs = this.filterMO();
        this.line = "\nNBOcharges";
        boolean bl = this.getNBOCharges = this.filter != null && this.filterMO();
        if (this.filter == null) {
            return;
        }
        this.filter = TextFormat.simpleReplace(this.filter, "nbocharges", "");
        if (this.filter.length() < 3) {
            this.filter = null;
        }
    }

    protected boolean filterMO() {
        if (this.filter == null) {
            return true;
        }
        boolean isOK = true;
        int nOK = 0;
        this.line = this.line.toLowerCase() + " " + this.alphaBeta;
        if (this.filterTokens == null) {
            this.filterIsNot = this.filter.indexOf("!") >= 0;
            this.filterTokens = MOReader.getTokens(this.filter.replace('!', ' ').replace(',', ' ').replace(';', ' ').toLowerCase());
        }
        for (int i = 0; i < this.filterTokens.length; ++i) {
            if (this.line.indexOf(this.filterTokens[i]) >= 0) {
                if (this.filterIsNot) continue;
                nOK = this.filterTokens.length;
                break;
            }
            if (!this.filterIsNot) continue;
            ++nOK;
        }
        boolean bl = isOK = nOK == this.filterTokens.length;
        if (this.line.indexOf(10) != 0) {
            Logger.info("filter MOs: " + isOK + " for \"" + this.line + "\"");
        }
        return isOK;
    }

    protected boolean checkNboLine() throws Exception {
        if (this.getNBOs) {
            if (this.line.indexOf("(Occupancy)   Bond orbital/ Coefficients/ Hybrids") >= 0) {
                this.getNboTypes();
                return false;
            }
            if (this.line.indexOf("NBOs in the AO basis:") >= 0) {
                this.readMolecularOrbitals(0);
                return false;
            }
        }
        if (this.getNBOCharges && this.line.indexOf("Summary of Natural Population Analysis:") >= 0) {
            this.getNboCharges();
            return true;
        }
        return true;
    }

    private void getNboCharges() throws Exception {
        if (this.haveNboCharges) {
            return;
        }
        this.discardLinesUntilContains("----");
        this.discardLinesUntilContains("----");
        this.haveNboCharges = true;
        int atomCount = this.atomSetCollection.getAtomCount();
        int i0 = this.atomSetCollection.getLastAtomSetAtomIndex();
        Atom[] atoms = this.atomSetCollection.getAtoms();
        for (int i = i0; i < atomCount; ++i) {
            float charge;
            while (atoms[i].elementNumber == 0) {
                ++i;
            }
            String[] tokens = MOReader.getTokens(this.readLine());
            if (tokens == null || tokens.length < 3 || Float.isNaN(charge = this.parseFloat(tokens[2]))) {
                Logger.info("Error reading NBO charges: " + this.line);
                return;
            }
            atoms[i].partialCharge = charge;
            if (!Logger.debugging) continue;
            Logger.debug("Atom " + i + " using NBOcharge: " + charge);
        }
        Logger.info("Using NBO charges for Model " + this.atomSetCollection.getAtomSetCount());
    }

    protected void getNboTypes() throws Exception {
        this.moTypes = new Vector();
        this.readLine();
        this.readLine();
        int n = 0;
        while (this.line != null && this.line.indexOf(".") == 4 && this.parseInt(this.line.substring(0, 4)) == n + 1) {
            this.moTypes.add(n++, this.line.substring(5, 34).trim());
            while (this.readLine() != null && this.line.startsWith("     ")) {
            }
        }
        Logger.info(n + " natural bond orbitals read");
    }

    protected void readMolecularOrbitals(int headerType) throws Exception {
        if (this.ignoreMOs) {
            this.readLine();
            return;
        }
        Hashtable[] mos = null;
        Vector[] data = null;
        Vector<String> coeffLabels = null;
        int nThisLine = 0;
        this.readLine();
        int moCount = 0;
        if (this.line.indexOf("---") >= 0) {
            this.readLine();
        }
        while (this.readLine() != null) {
            String[] tokens = this.getTokens();
            if (Logger.debugging) {
                Logger.debug(tokens.length + " --- " + this.line);
            }
            if (this.line.indexOf("end") >= 0) break;
            if (this.line.indexOf(" ALPHA SET ") >= 0) {
                this.alphaBeta = "alpha";
                if (this.readLine() == null) {
                    break;
                }
            } else if (this.line.indexOf(" BETA SET ") >= 0) {
                this.alphaBeta = "beta";
                if (this.readLine() == null) break;
            }
            if (this.line.length() == 0 || this.line.indexOf("--") >= 0 || this.line.indexOf(".....") >= 0 || this.line.indexOf("NBO BASIS") >= 0 || this.line.indexOf("CI EIGENVECTORS WILL BE LABELED") >= 0 || this.line.indexOf("   THIS LOCALIZATION HAD") >= 0) {
                for (int iMo = 0; iMo < nThisLine; ++iMo) {
                    float[] coefs = new float[data[iMo].size()];
                    int iCoeff = 0;
                    while (iCoeff < coefs.length) {
                        if (((String)coeffLabels.get(iCoeff)).equals("XXX")) {
                            int ifc;
                            Hashtable fCoeffs = new Hashtable();
                            for (ifc = 0; ifc < 10; ++ifc) {
                                fCoeffs.put(coeffLabels.get(iCoeff + ifc), data[iMo].get(iCoeff + ifc));
                            }
                            for (ifc = 0; ifc < 10; ++ifc) {
                                String orderLabel = JmolAdapter.getQuantumSubshellTag(5, ifc);
                                coefs[iCoeff++] = this.parseFloat((String)fCoeffs.get(orderLabel));
                            }
                            continue;
                        }
                        coefs[iCoeff] = this.parseFloat((String)data[iMo].get(iCoeff));
                        ++iCoeff;
                    }
                    mos[iMo].put("coefficients", coefs);
                    if (this.alphaBeta.length() > 0) {
                        mos[iMo].put("type", this.alphaBeta);
                    } else if (this.moTypes != null && moCount < this.moTypes.size()) {
                        mos[iMo].put("type", this.moTypes.get(moCount++));
                    }
                    this.orbitals.addElement(mos[iMo]);
                }
                nThisLine = 0;
                if (this.line.length() != 0) break;
                continue;
            }
            if (nThisLine == 0) {
                nThisLine = tokens.length;
                if (tokens[0].equals("AO")) {
                    --nThisLine;
                }
                if (mos == null || nThisLine > mos.length) {
                    mos = new Hashtable[nThisLine];
                    data = new Vector[nThisLine];
                }
                for (int i = 0; i < nThisLine; ++i) {
                    mos[i] = new Hashtable();
                    data[i] = new Vector();
                }
                this.getMOHeader(headerType, tokens, mos, nThisLine);
                coeffLabels = new Vector<String>();
                continue;
            }
            int nSkip = tokens.length - nThisLine;
            coeffLabels.addElement(JmolAdapter.canonicalizeQuantumSubshellTag(tokens[nSkip - 1].toUpperCase()));
            for (int i = 0; i < nThisLine; ++i) {
                data[i].addElement(tokens[i + nSkip]);
            }
            this.line = "";
        }
        this.energyUnits = "a.u.";
        this.setMOData(!this.alphaBeta.equals("alpha"));
    }

    protected void getMOHeader(int headerType, String[] tokens, Hashtable[] mos, int nThisLine) throws Exception {
        int i;
        this.readLine();
        switch (headerType) {
            default: {
                for (int i2 = 0; i2 < nThisLine; ++i2) {
                    mos[i2].put("energy", "");
                }
                return;
            }
            case 3: {
                for (int i3 = 0; i3 < nThisLine; ++i3) {
                    mos[i3].put("energy", new Float(tokens[i3]));
                }
                this.discardLines(5);
                return;
            }
            case 1: {
                tokens = this.getTokens();
                if (tokens.length == 0) {
                    tokens = MOReader.getTokens(this.readLine());
                }
                for (i = 0; i < nThisLine; ++i) {
                    mos[i].put("energy", new Float(tokens[i]));
                }
                this.readLine();
                break;
            }
            case 2: {
                boolean haveSymmetry = this.line.length() > 0 || this.readLine() != null;
                tokens = this.getTokens();
                for (int i4 = 0; i4 < nThisLine; ++i4) {
                    mos[i4].put("occupancy", new Float(tokens[i4].charAt(0) == '-' ? 2.0f : this.parseFloat(tokens[i4])));
                }
                this.readLine();
                if (haveSymmetry) break;
                return;
            }
        }
        if (this.line.length() > 0) {
            tokens = this.getTokens();
            for (i = 0; i < nThisLine; ++i) {
                mos[i].put("symmetry", tokens[i]);
            }
        }
    }

    protected void addMOData(int nColumns, Vector[] data, Hashtable[] mos) {
        for (int i = 0; i < nColumns; ++i) {
            float[] coefs = new float[data[i].size()];
            int j = coefs.length;
            while (--j >= 0) {
                coefs[j] = this.parseFloat((String)data[i].get(j));
            }
            mos[i].put("coefficients", coefs);
            this.orbitals.addElement(mos[i]);
        }
    }

    protected void setMOData(boolean clearOrbitals) {
        this.moData.put("calculationType", this.calculationType);
        this.moData.put("energyUnits", this.energyUnits);
        this.moData.put("shells", this.shells);
        this.moData.put("gaussians", this.gaussians);
        this.moData.put("mos", this.orbitals);
        this.setMOData(this.moData);
        if (clearOrbitals) {
            this.orbitals = new Vector();
            this.moData = new Hashtable();
            this.alphaBeta = "";
        }
    }
}

