/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import java.util.Vector;
import javax.vecmath.Point3f;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.Logger;

public class MdCrdReader
extends AtomSetCollectionReader {
    private Vector trajectorySteps;
    private int ptFloat = 0;
    private int lenLine = 0;

    public void readAtomSetCollection(BufferedReader br) {
        this.reader = br;
        this.atomSetCollection = new AtomSetCollection("mdcrd");
        this.atomSetCollection.addAtom(new Atom());
        this.trajectorySteps = (Vector)this.htParams.get("trajectorySteps");
        if (this.trajectorySteps == null) {
            this.trajectorySteps = new Vector();
            this.htParams.put("trajectorySteps", this.trajectorySteps);
        }
        try {
            this.readLine();
            this.readCoordinates();
            Logger.info("Total number of trajectory steps=" + this.trajectorySteps.size());
        }
        catch (Exception e) {
            this.setError(e);
        }
    }

    void readCoordinates() throws Exception {
        this.line = null;
        int atomCount = this.bsFilter == null ? this.templateAtomCount : (Integer)this.htParams.get("filteredAtomCount");
        boolean isPeriodic = this.htParams.containsKey("isPeriodic");
        int floatCount = this.templateAtomCount * 3 + (isPeriodic ? 3 : 0);
        while (true) {
            if (this.doGetModel(++this.modelNumber)) {
                Point3f[] trajectoryStep = new Point3f[atomCount];
                if (!this.getTrajectoryStep(trajectoryStep, isPeriodic)) {
                    return;
                }
                this.trajectorySteps.add(trajectoryStep);
                if (!this.isLastModel(this.modelNumber)) continue;
                return;
            }
            if (!this.skipFloats(floatCount)) break;
        }
    }

    private float getFloat() throws Exception {
        while (this.line == null || this.ptFloat >= this.lenLine) {
            if (this.readLine() == null) {
                return Float.NaN;
            }
            this.ptFloat = 0;
            this.lenLine = this.line.length();
        }
        this.ptFloat += 8;
        return this.parseFloat(this.line.substring(this.ptFloat - 8, this.ptFloat));
    }

    private Point3f getPoint() throws Exception {
        float x = this.getFloat();
        float y = this.getFloat();
        float z = this.getFloat();
        return Float.isNaN(z) ? null : new Point3f(x, y, z);
    }

    private boolean getTrajectoryStep(Point3f[] trajectoryStep, boolean isPeriodic) throws Exception {
        int atomCount = trajectoryStep.length;
        int n = -1;
        for (int i = 0; i < this.templateAtomCount; ++i) {
            Point3f pt = this.getPoint();
            if (pt == null) {
                return false;
            }
            if (this.bsFilter != null && !this.bsFilter.get(i)) continue;
            if (++n == atomCount) {
                return false;
            }
            trajectoryStep[n] = pt;
        }
        if (isPeriodic) {
            this.getPoint();
        }
        return this.line != null;
    }

    private boolean skipFloats(int n) throws Exception {
        for (int i = 0; i < n && this.readLine() != null; i += this.getTokens().length) {
        }
        return this.line != null;
    }
}

