/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import org.jmol.adapter.readers.more.FFReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;

public class MdTopReader
extends FFReader {
    private int nAtoms = 0;
    private int atomCount = 0;
    String[] group3s;

    public void readAtomSetCollection(BufferedReader reader) {
        this.reader = reader;
        this.atomSetCollection = new AtomSetCollection("mdtop");
        try {
            Atom atom;
            int i;
            this.setUserAtomTypes();
            this.readLine();
            while (this.line != null) {
                if (this.line.indexOf("%FLAG ") != 0) {
                    this.readLine();
                    continue;
                }
                this.line = this.line.substring(6).trim();
                if (this.line.equals("POINTERS")) {
                    this.getPointers();
                    continue;
                }
                if (this.line.equals("ATOM_NAME")) {
                    this.getAtomNames();
                    continue;
                }
                if (this.line.equals("CHARGE")) {
                    this.getCharges();
                    continue;
                }
                if (this.line.equals("RESIDUE_LABEL")) {
                    this.getResidueLabels();
                    continue;
                }
                if (this.line.equals("RESIDUE_POINTER")) {
                    this.getResiduePointers();
                    continue;
                }
                if (this.line.equals("AMBER_ATOM_TYPE")) {
                    this.getAtomTypes();
                    continue;
                }
                if (!this.line.equals("MASS")) continue;
                this.getMasses();
            }
            Atom[] atoms = this.atomSetCollection.getAtoms();
            if (this.filter == null) {
                this.nAtoms = this.atomCount;
            } else {
                Atom[] atoms2 = new Atom[atoms.length];
                this.nAtoms = 0;
                for (i = 0; i < this.atomCount; ++i) {
                    if (!this.filterAtom(atoms[i], i)) continue;
                    atoms2[this.nAtoms++] = atoms[i];
                }
                this.atomSetCollection.discardPreviousAtoms();
                for (i = 0; i < this.nAtoms; ++i) {
                    atom = atoms2[i];
                    this.atomSetCollection.addAtom(atom);
                }
            }
            Logger.info("Total number of atoms used=" + this.nAtoms);
            int j = 0;
            for (i = 0; i < this.nAtoms; ++i) {
                atom = atoms[i];
                if (i % 100 == 0) {
                    ++j;
                }
                this.setAtomCoord(atom, i % 100 * 2, j * 2, 0.0f);
                atom.isHetero = JmolAdapter.isHetero(atom.group3);
                String atomType = atom.atomName;
                atomType = atomType.substring(atomType.indexOf(0) + 1);
                if (this.getElementSymbol(atom, atomType)) continue;
                atom.elementSymbol = MdTopReader.deducePdbElementSymbol(atom.isHetero, atom.atomName, atom.group3);
            }
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("isPDB", Boolean.TRUE);
            this.atomSetCollection.setAtomSetAuxiliaryInfo("isPDB", Boolean.TRUE);
        }
        catch (Exception e) {
            this.setError(e);
        }
    }

    private String getDataBlock() throws Exception {
        StringBuffer sb = new StringBuffer();
        while (this.readLine() != null && this.line.indexOf("%FLAG") != 0) {
            sb.append(this.line);
        }
        return sb.toString();
    }

    private void getMasses() throws Exception {
    }

    private void getAtomTypes() throws Exception {
        this.readLine();
        String[] data = MdTopReader.getTokens(this.getDataBlock());
        Atom[] atoms = this.atomSetCollection.getAtoms();
        int i = this.atomCount;
        while (--i >= 0) {
            atoms[i].atomName = atoms[i].atomName + '\u0000' + data[i];
        }
    }

    private void getCharges() throws Exception {
        float[] data = new float[this.atomCount];
        this.readLine();
        MdTopReader.getTokensFloat(this.getDataBlock(), data, this.atomCount);
        Atom[] atoms = this.atomSetCollection.getAtoms();
        int i = this.atomCount;
        while (--i >= 0) {
            atoms[i].partialCharge = data[i];
        }
    }

    private void getResiduePointers() throws Exception {
        this.readLine();
        String[] resPtrs = MdTopReader.getTokens(this.getDataBlock());
        Logger.info("Total number of residues=" + resPtrs.length);
        int pt1 = this.atomCount;
        Atom[] atoms = this.atomSetCollection.getAtoms();
        int i = resPtrs.length;
        while (--i >= 0) {
            int pt2;
            int ptr = pt2 = this.parseInt(resPtrs[i]) - 1;
            while (ptr < pt1) {
                if (this.group3s != null) {
                    atoms[ptr].group3 = this.group3s[i];
                }
                atoms[ptr++].sequenceNumber = i + 1;
            }
            pt1 = pt2;
        }
    }

    private void getResidueLabels() throws Exception {
        this.readLine();
        this.group3s = MdTopReader.getTokens(this.getDataBlock());
    }

    private void getAtomNames() throws Exception {
        this.readLine();
        Atom[] atoms = this.atomSetCollection.getAtoms();
        int pt = 0;
        int i = 0;
        int len = 0;
        while (pt < this.atomCount) {
            if (i >= len) {
                this.readLine();
                i = 0;
                len = this.line.length();
            }
            atoms[pt++].atomName = this.line.substring(i, i + 4).trim();
            i += 4;
        }
    }

    private void getPointers() throws Exception {
        boolean isPeriodic;
        this.readLine();
        String data = "";
        int pt = 0;
        while (pt++ < 3 && (this.line = this.readLine()) != null && !this.line.startsWith("#")) {
            data = data + this.line;
        }
        String[] tokens = MdTopReader.getTokens(data);
        this.atomCount = this.parseInt(tokens[0]);
        boolean bl = isPeriodic = tokens[27].charAt(0) != '0';
        if (isPeriodic) {
            Logger.info("Periodic type: " + tokens[27]);
            this.htParams.put("isPeriodic", Boolean.TRUE);
        }
        Logger.info("Total number of atoms read=" + this.atomCount);
        this.htParams.put("templateAtomCount", new Integer(this.atomCount));
        for (int i = 0; i < this.atomCount; ++i) {
            this.atomSetCollection.addAtom(new Atom());
        }
    }
}

