/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import org.jmol.adapter.readers.more.FFReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.Bond;
import org.jmol.api.JmolAdapter;

public class Mol2Reader
extends FFReader {
    private int nAtoms = 0;
    private int atomCount = 0;
    private boolean isPDB = false;
    private int lastSequenceNumber = Integer.MAX_VALUE;
    private char chainID = (char)64;

    public void readAtomSetCollection(BufferedReader reader) {
        this.reader = reader;
        this.atomSetCollection = new AtomSetCollection("mol2");
        try {
            this.setUserAtomTypes();
            this.setFractionalCoordinates(false);
            this.readLine();
            this.modelNumber = 0;
            while (this.line != null) {
                if (this.line.equals("@<TRIPOS>MOLECULE") && this.doGetModel(++this.modelNumber)) {
                    this.processMolecule();
                    if (!this.isLastModel(this.modelNumber)) continue;
                    break;
                }
                this.readLine();
            }
        }
        catch (Exception e) {
            this.setError(e);
        }
    }

    private void processMolecule() throws Exception {
        boolean iHaveCharges;
        this.isPDB = false;
        String thisDataSetName = this.readLineTrimmed();
        this.lastSequenceNumber = Integer.MAX_VALUE;
        this.chainID = (char)64;
        this.readLine();
        this.line = this.line + " 0 0 0 0 0 0";
        this.atomCount = this.parseInt(this.line);
        int bondCount = this.parseInt();
        int resCount = this.parseInt();
        this.readLine();
        this.readLine();
        boolean bl = iHaveCharges = this.line.indexOf("NO_CHARGES") != 0;
        if (this.readLine() != null && (this.line.length() == 0 || this.line.charAt(0) != '@') && this.readLine() != null && this.line.length() != 0 && this.line.charAt(0) != '@') {
            thisDataSetName = thisDataSetName + ": " + this.line.trim();
        }
        this.newAtomSet(thisDataSetName);
        while (this.line != null && !this.line.equals("@<TRIPOS>MOLECULE")) {
            if (this.line.equals("@<TRIPOS>ATOM")) {
                this.readAtoms(this.atomCount, iHaveCharges);
                this.atomSetCollection.setAtomSetName(thisDataSetName);
            } else if (this.line.equals("@<TRIPOS>BOND")) {
                this.readBonds(bondCount);
            } else if (this.line.equals("@<TRIPOS>SUBSTRUCTURE")) {
                this.readResInfo(resCount);
            } else if (this.line.equals("@<TRIPOS>CRYSIN")) {
                this.readCrystalInfo();
            }
            this.readLine();
        }
        this.nAtoms += this.atomCount;
        if (this.isPDB) {
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("isPDB", Boolean.TRUE);
            this.atomSetCollection.setAtomSetAuxiliaryInfo("isPDB", Boolean.TRUE);
        }
        this.applySymmetryAndSetTrajectory();
    }

    private void readAtoms(int atomCount, boolean iHaveCharges) throws Exception {
        for (int i = 0; i < atomCount; ++i) {
            boolean deduceSymbol;
            Atom atom = this.atomSetCollection.addNewAtom();
            String[] tokens = Mol2Reader.getTokens(this.readLine());
            String atomType = tokens[5];
            atom.atomName = tokens[1] + '\u0000' + atomType;
            this.setAtomCoord(atom, this.parseFloat(tokens[2]), this.parseFloat(tokens[3]), this.parseFloat(tokens[4]));
            boolean bl = deduceSymbol = !this.getElementSymbol(atom, atomType);
            if (tokens.length > 6) {
                atom.sequenceNumber = this.parseInt(tokens[6]);
                if (atom.sequenceNumber < this.lastSequenceNumber) {
                    if (this.chainID == 'Z') {
                        this.chainID = (char)96;
                    }
                    this.chainID = (char)(this.chainID + '\u0001');
                }
                this.lastSequenceNumber = atom.sequenceNumber;
                atom.chainID = this.chainID;
            }
            if (tokens.length > 7) {
                atom.group3 = tokens[7];
                atom.isHetero = JmolAdapter.isHetero(atom.group3);
                if (!this.isPDB && atom.group3.length() <= 3 && JmolAdapter.lookupGroupID(atom.group3) >= 0) {
                    this.isPDB = true;
                }
                if (this.isPDB && deduceSymbol) {
                    atom.elementSymbol = Mol2Reader.deducePdbElementSymbol(atom.isHetero, atomType, atom.group3);
                }
            }
            if (tokens.length <= 8) continue;
            atom.partialCharge = this.parseFloat(tokens[8]);
        }
    }

    private void readBonds(int bondCount) throws Exception {
        for (int i = 0; i < bondCount; ++i) {
            String[] tokens = Mol2Reader.getTokens(this.readLine());
            int atomIndex1 = this.parseInt(tokens[1]);
            int atomIndex2 = this.parseInt(tokens[2]);
            int order = this.parseInt(tokens[3]);
            if (order == Integer.MIN_VALUE) {
                order = tokens[3].equals("ar") ? 515 : 7;
            }
            this.atomSetCollection.addBond(new Bond(this.nAtoms + atomIndex1 - 1, this.nAtoms + atomIndex2 - 1, order));
        }
    }

    private void readResInfo(int resCount) throws Exception {
        for (int i = 0; i < resCount; ++i) {
            this.readLine();
        }
    }

    private void readCrystalInfo() throws Exception {
        this.readLine();
        String[] tokens = this.getTokens();
        if (tokens.length < 6) {
            return;
        }
        for (int i = 0; i < 6; ++i) {
            this.setUnitCellItem(i, this.parseFloat(tokens[i]));
        }
        String name = "";
        for (int i = 6; i < tokens.length; ++i) {
            name = name + " " + tokens[i];
        }
        name = name == "" ? " P1" : name + " *";
        name = name.substring(1);
        this.setSpaceGroupName(name);
        Atom[] atoms = this.atomSetCollection.getAtoms();
        for (int i = 0; i < this.atomCount; ++i) {
            this.setAtomCoord(atoms[this.nAtoms + i]);
        }
    }
}

