/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.jmol.adapter.readers.more.MopacDataReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;

public class MoldenReader
extends MopacDataReader {
    protected float[] frequencies = null;
    protected AtomSetCollection freqAtomSet = null;

    public void readAtomSetCollection(BufferedReader reader) {
        this.reader = reader;
        this.atomSetCollection = new AtomSetCollection("molden");
        this.modelNumber = 0;
        try {
            this.readLine();
            while (this.line != null) {
                if (this.line.indexOf("[Atoms]") >= 0 || this.line.indexOf("[ATOMS]") >= 0) {
                    this.readAtoms();
                    continue;
                }
                if (this.line.indexOf("[GTO]") >= 0) {
                    this.readGaussianBasis();
                    continue;
                }
                if (this.line.indexOf("[MO]") >= 0) {
                    this.readMolecularOrbitals();
                    continue;
                }
                if (this.line.indexOf("[FREQ]") >= 0) {
                    this.readFreqsAndModes();
                    continue;
                }
                this.readLine();
            }
        }
        catch (Exception e) {
            this.setError(e);
        }
    }

    void readAtoms() throws Exception {
        boolean isAU;
        String coordUnit = this.getTokens()[1];
        int nPrevAtom = 0;
        int nCurAtom = 0;
        boolean bl = isAU = coordUnit.indexOf("Angs") < 0;
        if (isAU && coordUnit.indexOf("AU") < 0) {
            throw new Exception("invalid coordinate unit " + coordUnit + " in [Atoms]");
        }
        this.readLine();
        while (this.line != null && this.line.indexOf(91) < 0) {
            Atom atom = this.atomSetCollection.addNewAtom();
            String[] tokens = this.getTokens();
            atom.atomName = tokens[0];
            nCurAtom = this.parseInt(tokens[1]);
            if (nPrevAtom > 0 && nCurAtom != nPrevAtom + 1) {
                throw new Exception("out of order atom in [Atoms]");
            }
            nPrevAtom = nCurAtom;
            atom.set(this.parseFloat(tokens[3]), this.parseFloat(tokens[4]), this.parseFloat(tokens[5]));
            this.readLine();
        }
        if (isAU) {
            int i = this.atomSetCollection.getAtomCount();
            while (--i >= 0) {
                this.atomSetCollection.getAtom(i).scale(0.5291772f);
            }
        }
    }

    void readGaussianBasis() throws Exception {
        Vector<int[]> sdata = new Vector<int[]>();
        Vector<float[]> gdata = new Vector<float[]>();
        int atomIndex = 0;
        int gaussianPtr = 0;
        while (this.readLine() != null && (this.line = this.line.trim()).length() != 0 && this.line.charAt(0) != '[') {
            String[] tokens = this.getTokens();
            atomIndex = this.parseInt(tokens[0]) - 1;
            while (this.readLine() != null && this.line.trim().length() > 0) {
                tokens = this.getTokens();
                String shellLabel = tokens[0].toUpperCase();
                int nPrimitives = this.parseInt(tokens[1]);
                int[] slater = new int[]{atomIndex, JmolAdapter.getQuantumShellTagID(shellLabel), gaussianPtr, nPrimitives};
                int ip = nPrimitives;
                while (--ip >= 0) {
                    String[] primTokens = MoldenReader.getTokens(this.readLine());
                    int nTokens = primTokens.length;
                    float[] orbData = new float[nTokens];
                    for (int d = 0; d < nTokens; ++d) {
                        orbData[d] = this.parseFloat(primTokens[d]);
                    }
                    gdata.addElement(orbData);
                    ++gaussianPtr;
                }
                sdata.addElement(slater);
            }
        }
        float[][] garray = new float[gaussianPtr][];
        for (int i = 0; i < gaussianPtr; ++i) {
            garray[i] = (float[])gdata.get(i);
        }
        this.moData.put("shells", sdata);
        this.moData.put("gaussians", garray);
        if (Logger.debugging) {
            Logger.debug(sdata.size() + " slater shells read");
            Logger.debug(garray.length + " gaussian primitives read");
        }
        this.atomSetCollection.setAtomSetAuxiliaryInfo("moData", this.moData);
    }

    void readMolecularOrbitals() throws Exception {
        this.readLine();
        if (this.line.equals("[5D]")) {
            Vector sdata = (Vector)this.moData.get("shells");
            int i = sdata.size();
            while (--i >= 0) {
                int[] slater = (int[])sdata.get(i);
                switch (slater[1]) {
                    case 3: {
                        slater[1] = 4;
                        break;
                    }
                    case 5: {
                        slater[1] = 6;
                        break;
                    }
                }
            }
            this.readLine();
        }
        String[] tokens = this.getTokens();
        while (tokens != null && this.line.indexOf(91) < 0) {
            Hashtable<String, Object> mo = new Hashtable<String, Object>();
            Vector<String> data = new Vector<String>();
            float energy = Float.NaN;
            float occupancy = Float.NaN;
            while (tokens != null && this.parseInt(tokens[0]) == Integer.MIN_VALUE) {
                String[] kvPair;
                if (tokens[0].startsWith("Ene")) {
                    kvPair = this.splitKeyValue();
                    energy = this.parseFloat(kvPair[1]);
                } else if (tokens[0].startsWith("Occup")) {
                    kvPair = this.splitKeyValue();
                    occupancy = this.parseFloat(kvPair[1]);
                }
                tokens = MoldenReader.getTokens(this.readLine());
            }
            if (tokens == null) {
                throw new Exception("error reading MOs: unexpected EOF reading coeffs");
            }
            while (tokens != null && this.parseInt(tokens[0]) != Integer.MIN_VALUE) {
                if (tokens.length != 2) {
                    throw new Exception("invalid MO coefficient specification");
                }
                data.addElement(tokens[1]);
                tokens = MoldenReader.getTokens(this.readLine());
            }
            float[] coefs = new float[data.size()];
            int i = data.size();
            while (--i >= 0) {
                coefs[i] = this.parseFloat((String)data.get(i));
            }
            mo.put("energy", new Float(energy));
            mo.put("occupancy", new Float(occupancy));
            mo.put("coefficients", coefs);
            this.orbitals.addElement(mo);
            if (!Logger.debugging) continue;
            Logger.debug(coefs.length + " coefficients in MO " + this.orbitals.size());
        }
        Logger.debug("read " + this.orbitals.size() + " MOs");
        this.setMOs("eV");
    }

    void readFreqsAndModes() throws Exception {
        String[] tokens;
        Vector<String> frequencies = new Vector<String>();
        while (this.readLine() != null && this.line.indexOf(91) < 0) {
            frequencies.add(this.getTokens()[0]);
        }
        if (this.line.indexOf("[FR-COORD]") < 0) {
            throw new Exception("error reading normal modes: [FREQ] must be followed by [FR-COORD]");
        }
        int nFreqs = frequencies.size();
        int nAtoms = this.atomSetCollection.getFirstAtomSetAtomCount();
        this.atomSetCollection.cloneLastAtomSet();
        this.atomSetCollection.setAtomSetName("frequency base geometry");
        Atom[] atoms = this.atomSetCollection.getAtoms();
        for (int nAtom = 0; nAtom < nAtoms; ++nAtom) {
            tokens = MoldenReader.getTokens(this.readLine());
            Atom atom = atoms[nAtom + this.atomSetCollection.getLastAtomSetAtomIndex()];
            atom.atomName = tokens[0];
            atom.set(this.parseFloat(tokens[1]), this.parseFloat(tokens[2]), this.parseFloat(tokens[3]));
            atom.scale(0.5291772f);
        }
        this.readLine();
        if (this.line.indexOf("[FR-NORM-COORD]") < 0) {
            throw new Exception("error reading normal modes: [FR-COORD] must be followed by [FR-NORM-COORD]");
        }
        for (int nFreq = 0; nFreq < nFreqs; ++nFreq) {
            if (this.readLine().indexOf("Vibration") < 0) {
                throw new Exception("error reading normal modes: expected vibration data");
            }
            this.atomSetCollection.cloneLastAtomSet();
            this.atomSetCollection.setAtomSetName(frequencies.get(nFreq) + " cm-1");
            atoms = this.atomSetCollection.getAtoms();
            for (int nAtom = 0; nAtom < nAtoms; ++nAtom) {
                Atom atom = atoms[nAtom + this.atomSetCollection.getLastAtomSetAtomIndex()];
                tokens = MoldenReader.getTokens(this.readLine());
                atom.vectorX = this.parseFloat(tokens[0]) * 0.5291772f;
                atom.vectorY = this.parseFloat(tokens[1]) * 0.5291772f;
                atom.vectorZ = this.parseFloat(tokens[2]) * 0.5291772f;
            }
        }
        this.readLine();
    }

    String[] splitKeyValue() {
        return this.splitKeyValue("=", this.line);
    }

    String[] splitKeyValue(String sep) {
        return this.splitKeyValue(sep, this.line);
    }

    String[] splitKeyValue(String sep, String text) throws NoSuchElementException {
        String[] kvPair = new String[2];
        int posSep = text.indexOf(sep);
        if (posSep < 0) {
            throw new NoSuchElementException("separator not found");
        }
        kvPair[0] = text.substring(0, posSep);
        kvPair[1] = text.substring(posSep + sep.length());
        return kvPair;
    }
}

