/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.jmol.adapter.readers.more.MOReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;

public class QchemReader
extends MOReader {
    private int calculationNumber = 1;
    MOInfo[] alphas = null;
    MOInfo[] betas = null;
    int nShell = 0;
    int nBasis = 0;

    public void readAtomSetCollection(BufferedReader reader) {
        this.readAtomSetCollection(reader, "qchem");
    }

    protected boolean checkLine() throws Exception {
        if (this.line.indexOf("Standard Nuclear Orientation") >= 0) {
            this.readAtoms();
            this.moData = null;
            return true;
        }
        if (this.line.indexOf("Requested basis set is") >= 0) {
            this.readCalculationType();
            return true;
        }
        if (this.line.indexOf("VIBRATIONAL FREQUENCIES") >= 0) {
            this.readFrequencies();
            return true;
        }
        if (this.line.indexOf("Mulliken Net Atomic Charges") >= 0) {
            this.readPartialCharges();
            return true;
        }
        if (this.line.startsWith("Job ")) {
            ++this.calculationNumber;
            this.moData = null;
            return true;
        }
        if (this.line.indexOf("Basis set in general basis input format") >= 0) {
            if (this.moData == null) {
                this.readBasis();
            }
            return true;
        }
        if (this.moData == null) {
            return true;
        }
        if (this.line.indexOf("Orbital Energies (a.u.) and Symmetries") >= 0) {
            if (this.filterMO()) {
                this.readESym(true);
            }
            return true;
        }
        if (this.line.indexOf("Orbital Energies (a.u.)") >= 0) {
            if (this.filterMO()) {
                this.readESym(false);
            }
            return true;
        }
        if (this.line.indexOf("MOLECULAR ORBITAL COEFFICIENTS") >= 0) {
            if (this.filterMO()) {
                this.readQchemMolecularOrbitals();
            }
            return true;
        }
        return this.checkNboLine();
    }

    private void readCalculationType() {
        this.calculationType = this.line.substring(this.line.indexOf("set is") + 6).trim();
    }

    void readAtoms() throws Exception {
        this.atomSetCollection.newAtomSet();
        this.discardLines(2);
        while (this.readLine() != null && !this.line.startsWith(" --")) {
            String symbol;
            String[] tokens = this.getTokens();
            if (tokens.length < 5 || JmolAdapter.getElementNumber(symbol = tokens[1]) < 1) continue;
            float x = this.parseFloat(tokens[2]);
            float y = this.parseFloat(tokens[3]);
            float z = this.parseFloat(tokens[4]);
            if (Float.isNaN(x) || Float.isNaN(y) || Float.isNaN(z)) continue;
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementSymbol = symbol;
            atom.set(x, y, z);
            this.atomSetCollection.setAtomSetProperty(".PATH", "Calculation " + this.calculationNumber);
        }
    }

    private void readFrequencies() throws Exception, IOException {
        String[] frequencies = QchemReader.getTokens(this.discardLinesUntilStartsWith(" Frequency:"));
        while (true) {
            int frequencyCount = frequencies.length;
            for (int i = 1; i < frequencyCount; ++i) {
                this.atomSetCollection.cloneLastAtomSet();
                this.atomSetCollection.setAtomSetName(frequencies[i] + " cm**-1");
                this.atomSetCollection.setAtomSetProperty("Frequency", frequencies[i] + " cm**-1");
                this.atomSetCollection.setAtomSetProperty(".PATH", "Calculation " + this.calculationNumber + SmarterJmolAdapter.PATH_SEPARATOR + "Frequencies");
            }
            int atomCount = this.atomSetCollection.getLastAtomSetAtomCount();
            int firstModelAtom = this.atomSetCollection.getAtomCount() - frequencyCount * atomCount;
            this.discardLinesUntilStartsWith("               X");
            Atom[] atoms = this.atomSetCollection.getAtoms();
            for (int i = 0; i < atomCount; ++i) {
                String[] tokens = QchemReader.getTokens(this.readLine());
                int offset = 1;
                for (int j = 1; j < frequencyCount; ++j) {
                    int atomOffset = firstModelAtom + j * atomCount + i;
                    Atom atom = atoms[atomOffset];
                    float x = this.parseFloat(tokens[offset++]);
                    float y = this.parseFloat(tokens[offset++]);
                    float z = this.parseFloat(tokens[offset++]);
                    atom.addVibrationVector(x, y, z);
                }
            }
            while ((this.line = this.readLine()) != null && this.line.length() > 0) {
            }
            this.line = this.readLine();
            if (this.line.indexOf("STANDARD") >= 0) break;
            if (this.line.indexOf(" Frequency:") == -1) {
                frequencies = QchemReader.getTokens(this.discardLinesUntilStartsWith(" Frequency:"));
                continue;
            }
            frequencies = QchemReader.getTokens(this.line);
        }
    }

    void readPartialCharges() throws Exception {
        this.discardLines(3);
        Atom[] atoms = this.atomSetCollection.getAtoms();
        int atomCount = this.atomSetCollection.getLastAtomSetAtomCount();
        for (int i = 0; i < atomCount && this.readLine() != null; ++i) {
            atoms[i].partialCharge = this.parseFloat(this.getTokens()[2]);
        }
    }

    private void readBasis() throws Exception {
        String[] tokens;
        this.moData = new Hashtable();
        int atomCount = 0;
        int shellCount = 0;
        int gaussianCount = 0;
        Vector<int[]> sdata = new Vector<int[]>();
        Vector<String[]> gdata = new Vector<String[]>();
        this.discardLinesUntilStartsWith("$basis");
        this.readLine();
        while (this.readLine() != null) {
            int nGaussians;
            if (this.line.startsWith("****")) {
                ++atomCount;
                if (this.readLine() == null || !this.line.startsWith("$end")) continue;
                break;
            }
            ++shellCount;
            int[] slater = new int[4];
            tokens = QchemReader.getTokens(this.line);
            slater[0] = atomCount;
            slater[1] = JmolAdapter.getQuantumShellTagID(tokens[0]);
            slater[2] = gaussianCount;
            slater[3] = nGaussians = this.parseInt(tokens[1]);
            sdata.addElement(slater);
            gaussianCount += nGaussians;
            for (int i = 0; i < nGaussians; ++i) {
                gdata.addElement(QchemReader.getTokens(this.readLine()));
            }
        }
        float[][] garray = new float[gaussianCount][];
        for (int i = 0; i < gaussianCount; ++i) {
            tokens = (String[])gdata.get(i);
            garray[i] = new float[tokens.length];
            for (int j = 0; j < tokens.length; ++j) {
                garray[i][j] = this.parseFloat(tokens[j]);
            }
        }
        this.moData.put("shells", sdata);
        this.moData.put("gaussians", garray);
        if (Logger.debugging) {
            Logger.debug(shellCount + " slater shells read");
            Logger.debug(gaussianCount + " gaussian primitives read");
        }
        this.discardLinesUntilStartsWith(" There are");
        tokens = QchemReader.getTokens(this.line);
        this.nShell = this.parseInt(tokens[2]);
        this.nBasis = this.parseInt(tokens[5]);
        this.moData.put("calculationType", this.calculationType);
    }

    protected void readESym(boolean haveSym) throws Exception {
        String[] spin = new String[]{"A", "B"};
        this.alphas = new MOInfo[this.nBasis];
        this.betas = new MOInfo[this.nBasis];
        int ne = 0;
        boolean readBetas = false;
        this.discardLinesUntilStartsWith(" Alpha");
        String[] tokens = QchemReader.getTokens(this.line);
        MOInfo[] moInfos = this.alphas;
        block0: for (int e = 0; e < 2; ++e) {
            int nMO = 0;
            while (this.readLine() != null) {
                if (this.line.startsWith(" -- ")) {
                    ne = 0;
                    if (this.line.indexOf("Vacant") < 0 && this.line.indexOf("Occupied") > 0) {
                        ne = 1;
                    }
                    this.readLine();
                }
                if (this.line.startsWith(" -------")) {
                    e = 2;
                    continue block0;
                }
                int nOrbs = QchemReader.getTokens(this.line).length;
                if (nOrbs == 0 || this.line.startsWith(" Warning")) {
                    this.discardLinesUntilStartsWith(" Beta");
                    readBetas = true;
                    moInfos = this.betas;
                    continue block0;
                }
                if (haveSym) {
                    tokens = QchemReader.getTokens(this.readLine());
                }
                int i = 0;
                int j = 0;
                while (i < nOrbs) {
                    MOInfo info = new MOInfo();
                    info.ne = ne;
                    info.label = spin[e];
                    if (haveSym) {
                        info.symmetry = tokens[j] + tokens[j + 1];
                    }
                    moInfos[nMO] = info;
                    ++nMO;
                    ++i;
                    j += 2;
                }
            }
        }
        if (!readBetas) {
            this.betas = this.alphas;
        }
    }

    private void readQchemMolecularOrbitals() throws Exception {
        int i;
        int[] nOrbitalsPerShell = new int[]{1, 3, 4, 6, 5, 10, 7};
        int[][] reorder = new int[][]{{0}, {0, 1, 2}, {0, 1, 2, 3}, {0, 3, 1, 4, 5, 2}, {4, 2, 0, 1, 3}, {0, 4, 3, 1, 5, 9, 8, 6, 7, 2}, {6, 4, 2, 0, 1, 3, 5}};
        float[] reordered = new float[10];
        Vector orbitals = new Vector();
        String[] aoLabels = new String[this.nBasis];
        String orbitalType = QchemReader.getTokens(this.line)[0];
        int nMOs = this.readMOs(orbitalType.equals("RESTRICTED"), aoLabels, orbitals, this.alphas);
        if (orbitalType.equals("ALPHA")) {
            this.discardLinesUntilContains("BETA");
            nMOs += this.readMOs(false, aoLabels, orbitals, this.betas);
        }
        int iAO = 0;
        Vector sdata = (Vector)this.moData.get("shells");
        float[][] mocoef = new float[nMOs][];
        for (i = 0; i < nMOs; ++i) {
            Hashtable orb = (Hashtable)orbitals.get(i);
            mocoef[i] = (float[])orb.get("coefficients");
        }
        for (i = 0; i < this.nShell; ++i) {
            int[] slater = (int[])sdata.get(i);
            if (QchemReader.getTokens(aoLabels[iAO]).length > 1) {
                slater[1] = slater[1] + slater[1] % 2;
            }
            int nOrbs = nOrbitalsPerShell[slater[1]];
            if (slater[1] >= 3) {
                for (int j = 0; j < nMOs; ++j) {
                    int[] order = reorder[slater[1]];
                    int k = 0;
                    int l = iAO;
                    while (k < nOrbs) {
                        reordered[order[k]] = mocoef[j][l];
                        ++k;
                        ++l;
                    }
                    k = 0;
                    l = iAO;
                    while (k < nOrbs) {
                        mocoef[j][l] = reordered[k];
                        ++k;
                        ++l;
                    }
                }
            }
            iAO += nOrbs;
        }
        this.moData.put("mos", orbitals);
        this.moData.put("energyUnits", "au");
        this.setMOData(this.moData);
    }

    private int readMOs(boolean restricted, String[] aoLabels, Vector orbitals, MOInfo[] moInfos) throws Exception {
        Hashtable[] mos = new Hashtable[6];
        float[][] mocoef = new float[6][];
        int[] moid = new int[6];
        int nMOs = 0;
        while (this.readLine().length() > 2) {
            int i;
            String[] tokens = QchemReader.getTokens(this.line);
            int nMO = tokens.length;
            String[] energy = QchemReader.getTokens(this.readLine().substring(13));
            for (i = 0; i < nMO; ++i) {
                moid[i] = this.parseInt(tokens[i]) - 1;
                mocoef[i] = new float[this.nBasis];
                mos[i] = new Hashtable();
            }
            for (i = 0; i < this.nBasis; ++i) {
                tokens = QchemReader.getTokens(this.readLine());
                aoLabels[i] = this.line.substring(12, 17);
                int j = tokens.length - nMO;
                for (int k = 0; k < nMO; ++k) {
                    mocoef[k][i] = this.parseFloat(tokens[j]);
                    ++j;
                }
            }
            for (i = 0; i < nMO; ++i) {
                MOInfo moInfo = moInfos[moid[i]];
                mos[i].put("energy", new Float(energy[i]));
                mos[i].put("coefficients", mocoef[i]);
                String label = moInfo.label;
                int ne = moInfo.ne;
                if (restricted) {
                    ne = this.alphas[moid[i]].ne + this.betas[moid[i]].ne;
                }
                mos[i].put("occupancy", new Float(ne));
                if (ne == 2) {
                    label = "AB";
                }
                if (ne == 0) {
                    label = restricted ? "V" : "V" + label;
                }
                mos[i].put("symmetry", moInfo.symmetry + " " + label + "(" + (moid[i] + 1) + ")");
                orbitals.addElement(mos[i]);
            }
            nMOs += nMO;
        }
        return nMOs;
    }

    protected class MOInfo {
        int ne = 0;
        String label = "???";
        String symmetry = "???";

        protected MOInfo() {
        }
    }
}

