/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Vector3f;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.util.Logger;
import org.jmol.util.Parser;

public class SpartanArchive {
    private int atomCount = 0;
    private String bondData;
    private int moCount = 0;
    private int coefCount = 0;
    private int shellCount = 0;
    private int gaussianCount = 0;
    private String endCheck;
    private String calculationType = "";
    private String line;
    private AtomSetCollection atomSetCollection;
    private AtomSetCollectionReader r;
    private Hashtable moData;
    private Vector orbitals = new Vector();
    private int modelAtomCount;

    private String[] getTokens() {
        return Parser.getTokens(this.line);
    }

    SpartanArchive(AtomSetCollectionReader r, AtomSetCollection atomSetCollection, Hashtable moData) {
        this.initialize(r, atomSetCollection, moData, "");
    }

    SpartanArchive(AtomSetCollectionReader r, AtomSetCollection atomSetCollection, Hashtable moData, String bondData, String endCheck) {
        this.initialize(r, atomSetCollection, moData, bondData);
        this.endCheck = endCheck;
    }

    private void initialize(AtomSetCollectionReader r, AtomSetCollection atomSetCollection, Hashtable moData, String bondData) {
        this.r = r;
        this.atomSetCollection = atomSetCollection;
        this.moData = moData;
        moData.put("energyUnits", "");
        this.bondData = bondData;
    }

    int readArchive(String infoLine, boolean haveGeometryLine, int atomCount0, boolean doAddAtoms) throws Exception {
        this.modelAtomCount = this.setInfo(infoLine);
        this.line = haveGeometryLine ? "GEOMETRY" : "";
        boolean haveMOData = false;
        while (this.line != null) {
            if (this.line.equals("GEOMETRY")) {
                this.readAtoms(atomCount0, doAddAtoms);
                if (doAddAtoms && this.bondData.length() > 0) {
                    this.addBonds(this.bondData, atomCount0);
                }
            } else if (this.line.indexOf("BASIS") == 0) {
                this.readBasis();
            } else if (this.line.indexOf("WAVEFUNC") == 0 || this.line.indexOf("BETA") == 0) {
                this.readMolecularOrbital();
                haveMOData = true;
            } else if (this.line.equals("ENDARCHIVE") || this.endCheck != null && this.line.indexOf(this.endCheck) == 0) break;
            this.readLine();
        }
        if (haveMOData) {
            this.r.setMOData(this.moData);
        }
        return this.atomCount;
    }

    private static String[] getTokens(String info) {
        return Parser.getTokens(info);
    }

    private int parseInt(String info) {
        return this.r.parseInt(info);
    }

    private float parseFloat(String info) {
        return this.r.parseFloat(info);
    }

    private int setInfo(String info) throws Exception {
        String[] tokens = SpartanArchive.getTokens(info);
        if (Logger.debugging) {
            Logger.debug("reading Spartan archive info :" + info);
        }
        this.modelAtomCount = this.parseInt(tokens[0]);
        this.coefCount = this.parseInt(tokens[1]);
        this.shellCount = this.parseInt(tokens[2]);
        this.gaussianCount = this.parseInt(tokens[3]);
        this.moCount = this.parseInt(tokens[6]);
        this.calculationType = tokens[9];
        String s = (String)this.moData.get("calculationType");
        if (s == null) {
            s = this.calculationType;
        } else if (s.indexOf(this.calculationType) < 0) {
            s = this.calculationType + s;
        }
        this.r.calculationType = s;
        this.moData.put("calculationType", this.r.calculationType);
        return this.modelAtomCount;
    }

    void readAtoms(int atomCount0, boolean doAddAtoms) throws Exception {
        for (int i = 0; i < this.modelAtomCount; ++i) {
            this.readLine();
            String[] tokens = this.getTokens();
            Atom atom = doAddAtoms ? this.atomSetCollection.addNewAtom() : this.atomSetCollection.getAtom(atomCount0 - this.modelAtomCount + i);
            atom.elementSymbol = AtomSetCollectionReader.getElementSymbol(this.parseInt(tokens[0]));
            atom.set(this.parseFloat(tokens[1]), this.parseFloat(tokens[2]), this.parseFloat(tokens[3]));
            atom.scale(0.5291772f);
        }
        if (doAddAtoms && Logger.debugging) {
            Logger.debug(this.atomCount + " atoms read");
        }
    }

    void addBonds(String data, int atomCount0) {
        String[] tokens = SpartanArchive.getTokens(data);
        int i = this.modelAtomCount;
        while (i < tokens.length) {
            int bondOrder;
            int sourceIndex = this.parseInt(tokens[i++]) - 1 + atomCount0;
            int targetIndex = this.parseInt(tokens[i++]) - 1 + atomCount0;
            if ((bondOrder = this.parseInt(tokens[i++])) <= 0) continue;
            this.atomSetCollection.addBond(new Bond(sourceIndex, targetIndex, bondOrder < 4 ? bondOrder : (bondOrder == 5 ? 515 : 1)));
        }
        int bondCount = this.atomSetCollection.getBondCount();
        if (Logger.debugging) {
            Logger.debug(bondCount + " bonds read");
        }
    }

    void readBasis() throws Exception {
        int i;
        Vector<int[]> sdata = new Vector<int[]>();
        float[][] garray = new float[this.gaussianCount][];
        int[] typeArray = new int[this.gaussianCount];
        for (i = 0; i < this.shellCount; ++i) {
            this.readLine();
            String[] tokens = this.getTokens();
            int[] slater = new int[4];
            slater[0] = this.parseInt(tokens[3]) - 1;
            int iBasis = this.parseInt(tokens[0]);
            slater[1] = iBasis == 0 ? 0 : iBasis + 1;
            int gaussianPtr = slater[2] = this.parseInt(tokens[2]) - 1;
            int nGaussians = slater[3] = this.parseInt(tokens[1]);
            for (int j = 0; j < nGaussians; ++j) {
                typeArray[gaussianPtr + j] = iBasis;
            }
            sdata.addElement(slater);
        }
        for (i = 0; i < this.gaussianCount; ++i) {
            float alpha = this.parseFloat(this.readLine());
            String[] tokens = SpartanArchive.getTokens(this.readLine());
            int nData = tokens.length;
            float[] data = new float[nData + 1];
            data[0] = alpha;
            int iBasis = typeArray[i];
            switch (iBasis) {
                case 1: {
                    data[2] = this.parseFloat(tokens[1]);
                }
                case 0: {
                    data[1] = this.parseFloat(tokens[0]);
                    break;
                }
                case 2: {
                    data[1] = this.parseFloat(tokens[2]);
                    break;
                }
                case 3: {
                    data[1] = this.parseFloat(tokens[3]);
                }
            }
            garray[i] = data;
        }
        this.moData.put("shells", sdata);
        this.moData.put("gaussians", garray);
        if (Logger.debugging) {
            Logger.debug(sdata.size() + " slater shells read");
            Logger.debug(garray.length + " gaussian primitives read");
        }
    }

    void readMolecularOrbital() throws Exception {
        int i;
        int tokenPt = 0;
        String[] tokens = SpartanArchive.getTokens("");
        float[] energies = new float[this.moCount];
        float[][] coefficients = new float[this.moCount][this.coefCount];
        for (i = 0; i < this.moCount; ++i) {
            if (tokenPt == tokens.length) {
                tokens = SpartanArchive.getTokens(this.readLine());
                tokenPt = 0;
            }
            energies[i] = this.parseFloat(tokens[tokenPt++]);
        }
        for (i = 0; i < this.moCount; ++i) {
            for (int j = 0; j < this.coefCount; ++j) {
                if (tokenPt == tokens.length) {
                    tokens = SpartanArchive.getTokens(this.readLine());
                    tokenPt = 0;
                }
                coefficients[i][j] = this.parseFloat(tokens[tokenPt++]);
            }
        }
        for (i = 0; i < this.moCount; ++i) {
            Hashtable<String, Object> mo = new Hashtable<String, Object>();
            mo.put("energy", new Float(energies[i]));
            mo.put("coefficients", coefficients[i]);
            this.orbitals.addElement(mo);
        }
        if (Logger.debugging) {
            Logger.debug(this.orbitals.size() + " molecular orbitals read");
        }
        this.moData.put("mos", this.orbitals);
    }

    void readProperties() throws Exception {
        Logger.debug("Reading PROPARC properties records...");
        while (this.readLine() != null && !this.line.startsWith("ENDPROPARC") && !this.line.startsWith("END Directory Entry ")) {
            if (this.line.length() >= 4 && this.line.substring(0, 4).equals("PROP")) {
                this.readProperty();
            }
            if (this.line.length() >= 6 && this.line.substring(0, 6).equals("DIPOLE")) {
                this.readDipole();
            }
            if (this.line.length() < 7 || !this.line.substring(0, 7).equals("VIBFREQ")) continue;
            this.readVibFreqs();
        }
        this.setVibrationsFromProperties();
    }

    void readDipole() throws Exception {
        this.readLine();
        String[] tokens = this.getTokens();
        this.setDipole(tokens);
    }

    private void setDipole(String[] tokens) {
        if (tokens.length != 3) {
            return;
        }
        Vector3f dipole = new Vector3f(this.parseFloat(tokens[0]), this.parseFloat(tokens[1]), this.parseFloat(tokens[2]));
        this.atomSetCollection.setAtomSetAuxiliaryInfo("dipole", dipole);
    }

    private void readProperty() throws Exception {
        String[] tokens = this.getTokens();
        if (tokens.length == 0) {
            return;
        }
        boolean isString = tokens[1].startsWith("STRING");
        String keyName = tokens[2];
        boolean isDipole = keyName.equals("DIPOLE_VEC");
        Object value = new Object();
        Vector<Object> vector = new Vector<Object>();
        if (tokens[3].equals("=")) {
            value = isString ? this.getQuotedString(tokens[4].substring(0, 1)) : new Float(this.parseFloat(tokens[4]));
        } else if (tokens[tokens.length - 1].equals("BEGIN")) {
            int nValues = this.parseInt(tokens[tokens.length - 2]);
            if (nValues == 0) {
                nValues = 1;
            }
            boolean isArray = tokens.length == 6;
            Vector<Float> atomInfo = new Vector<Float>();
            int ipt = 0;
            while (this.readLine() != null && !this.line.substring(0, 3).equals("END")) {
                if (isString) {
                    value = this.getQuotedString("\"");
                    vector.addElement(value);
                    continue;
                }
                String[] tokens2 = this.getTokens();
                if (isDipole) {
                    this.setDipole(tokens2);
                }
                int i = 0;
                while (i < tokens2.length) {
                    if (isArray) {
                        atomInfo.addElement(new Float(this.parseFloat(tokens2[i])));
                        if ((ipt + 1) % nValues == 0) {
                            vector.addElement(atomInfo);
                            atomInfo = new Vector();
                        }
                    } else {
                        value = new Float(this.parseFloat(tokens2[i]));
                        vector.addElement(value);
                    }
                    ++i;
                    ++ipt;
                }
            }
            value = null;
        } else if (Logger.debugging) {
            Logger.debug(" Skipping property line " + this.line);
        }
        if (value != null) {
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo(keyName, value);
        }
        if (vector.size() != 0) {
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo(keyName, vector);
        }
    }

    void readVibFreqs() throws Exception {
        this.readLine();
        String label = "";
        int frequencyCount = this.parseInt(this.line);
        Vector vibrations = new Vector();
        Vector freqs = new Vector();
        if (Logger.debugging) {
            Logger.debug("reading VIBFREQ vibration records: frequencyCount = " + frequencyCount);
        }
        for (int i = 0; i < frequencyCount; ++i) {
            int atomCount0 = this.atomSetCollection.getAtomCount();
            this.atomSetCollection.cloneLastAtomSet();
            this.addBonds(this.bondData, atomCount0);
            this.readLine();
            Hashtable<String, Object> info = new Hashtable<String, Object>();
            float freq = this.parseFloat(this.line);
            info.put("freq", new Float(freq));
            if (this.line.length() > 15 && !(label = this.line.substring(15, this.line.length())).equals("???")) {
                info.put("label", label);
            }
            freqs.addElement(info);
            this.atomSetCollection.setAtomSetName(label + " " + freq + " cm^-1");
            this.atomSetCollection.setAtomSetProperty(".PATH", "Frequencies");
        }
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("VibFreqs", freqs);
        int atomCount = this.atomSetCollection.getFirstAtomSetAtomCount();
        Atom[] atoms = this.atomSetCollection.getAtoms();
        Vector vib = new Vector();
        Vector<Float> vibatom = new Vector<Float>();
        int ifreq = 0;
        int iatom = atomCount;
        int nValues = 3;
        float[] atomInfo = new float[3];
        while (this.readLine() != null) {
            String[] tokens2 = this.getTokens();
            for (int i = 0; i < tokens2.length; ++i) {
                float f;
                atomInfo[i % nValues] = f = this.parseFloat(tokens2[i]);
                vibatom.addElement(new Float(f));
                if ((i + 1) % nValues != 0) continue;
                atoms[iatom].addVibrationVector(atomInfo[0], atomInfo[1], atomInfo[2]);
                vib.addElement(vibatom);
                vibatom = new Vector();
                ++iatom;
            }
            if (iatom % atomCount != 0) continue;
            vibrations.addElement(vib);
            vib = new Vector();
            if (++ifreq != frequencyCount) continue;
            break;
        }
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("vibration", vibrations);
    }

    private void setVibrationsFromProperties() throws Exception {
        Object v;
        Vector freq_modes = (Vector)this.atomSetCollection.getAtomSetCollectionAuxiliaryInfo("FREQ_MODES");
        if (freq_modes == null) {
            return;
        }
        Vector freq_lab = (Vector)this.atomSetCollection.getAtomSetCollectionAuxiliaryInfo("FREQ_LAB");
        Vector freq_val = (Vector)this.atomSetCollection.getAtomSetCollectionAuxiliaryInfo("FREQ_VAL");
        int frequencyCount = freq_val.size();
        Vector vibrations = new Vector();
        Vector freqs = new Vector();
        if (Logger.debugging) {
            Logger.debug("reading PROP VALUE:VIB FREQ_MODE vibration records: frequencyCount = " + frequencyCount);
        }
        for (int i = 0; i < frequencyCount; ++i) {
            int atomCount0 = this.atomSetCollection.getAtomCount();
            this.atomSetCollection.cloneLastAtomSet();
            this.addBonds(this.bondData, atomCount0);
            Hashtable<String, Object> info = new Hashtable<String, Object>();
            v = freq_val.get(i);
            info.put("freq", v);
            float freq = ((Float)v).floatValue();
            String label = (String)freq_lab.get(i);
            if (!label.equals("???")) {
                info.put("label", label);
            }
            freqs.addElement(info);
            this.atomSetCollection.setAtomSetName(label + " " + freq + " cm^-1");
            this.atomSetCollection.setAtomSetProperty(".PATH", "Frequencies");
        }
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("VibFreqs", freqs);
        int atomCount = this.atomSetCollection.getFirstAtomSetAtomCount();
        Atom[] atoms = this.atomSetCollection.getAtoms();
        int iatom = atomCount;
        for (int i = 0; i < frequencyCount; ++i) {
            int ipt = 0;
            Vector vib = new Vector();
            Vector mode = (Vector)freq_modes.get(i);
            for (int ia = 0; ia < atomCount; ++ia) {
                Vector vibatom = new Vector();
                v = mode.get(ipt++);
                float vx = ((Float)v).floatValue();
                vibatom.addElement(v);
                v = mode.get(ipt++);
                float vy = ((Float)v).floatValue();
                vibatom.addElement(v);
                v = mode.get(ipt++);
                float vz = ((Float)v).floatValue();
                vibatom.addElement(v);
                atoms[iatom++].addVibrationVector(vx, vy, vz);
                vib.addElement(vibatom);
            }
            vibrations.addElement(vib);
            vib = new Vector();
        }
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("vibration", vibrations);
    }

    private String getQuotedString(String strQuote) {
        int i = this.line.indexOf(strQuote);
        int j = this.line.lastIndexOf(strQuote);
        return j == i ? "" : this.line.substring(i + 1, j);
    }

    private String readLine() throws Exception {
        this.line = this.r.readLine();
        if (Logger.debugging) {
            Logger.debug(this.line);
        }
        return this.line;
    }
}

