/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import java.util.Hashtable;
import org.jmol.adapter.readers.more.SpartanArchive;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

public class SpartanReader
extends AtomSetCollectionReader {
    String modelName = "Spartan file";
    int atomCount;
    Hashtable moData = new Hashtable();

    public void readAtomSetCollection(BufferedReader reader) {
        this.reader = reader;
        this.atomSetCollection = new AtomSetCollection("spartan");
        String cartesianHeader = "Cartesian Coordinates (Ang";
        try {
            if (this.isSpartanArchive(cartesianHeader)) {
                SpartanArchive spartanArchive = new SpartanArchive(this, this.atomSetCollection, this.moData);
                this.atomCount = spartanArchive.readArchive(this.line, true, 0, true);
                if (this.atomCount > 0) {
                    this.atomSetCollection.setAtomSetName(this.modelName);
                }
            } else if (this.line.indexOf(cartesianHeader) >= 0) {
                this.readAtoms();
                this.discardLinesUntilContains("Vibrational Frequencies");
                if (this.line != null) {
                    this.readFrequencies();
                }
            }
        }
        catch (Exception e) {
            this.setError(e);
        }
    }

    boolean isSpartanArchive(String strNotArchive) throws Exception {
        String lastLine = "";
        while (this.readLine() != null) {
            if (this.line.equals("GEOMETRY")) {
                this.line = lastLine;
                return true;
            }
            if (this.line.indexOf(strNotArchive) >= 0) {
                return false;
            }
            lastLine = this.line;
        }
        return false;
    }

    void readAtoms() throws Exception {
        this.discardLinesUntilBlank();
        while (this.readLine() != null && this.parseInt(this.line, 0, 3) > 0) {
            String elementSymbol = this.parseToken(this.line, 4, 6);
            String atomName = this.parseToken(this.line, 7, 13);
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementSymbol = elementSymbol;
            atom.atomName = atomName;
            atom.set(this.parseFloat(this.line, 17, 30), this.parseFloat(this.line, 31, 44), this.parseFloat(this.line, 45, 58));
        }
    }

    void readFrequencies() throws Exception {
        int totalFrequencyCount = 0;
        block0: while (true) {
            float frequency;
            int lineFreqCount;
            this.discardLinesUntilNonBlank();
            int lineBaseFreqCount = totalFrequencyCount;
            this.next[0] = 16;
            for (lineFreqCount = 0; lineFreqCount < 3 && !Float.isNaN(frequency = this.parseFloat()); ++lineFreqCount) {
                if (++totalFrequencyCount <= 1) continue;
                this.atomSetCollection.cloneFirstAtomSet();
            }
            if (lineFreqCount == 0) {
                return;
            }
            Atom[] atoms = this.atomSetCollection.getAtoms();
            this.discardLines(2);
            int firstAtomSetAtomCount = this.atomSetCollection.getFirstAtomSetAtomCount();
            int i = 0;
            while (true) {
                if (i >= firstAtomSetAtomCount) continue block0;
                this.readLine();
                for (int j = 0; j < lineFreqCount; ++j) {
                    int ichCoords = j * 23 + 10;
                    float x = this.parseFloat(this.line, ichCoords, ichCoords + 7);
                    float y = this.parseFloat(this.line, ichCoords + 7, ichCoords + 14);
                    float z = this.parseFloat(this.line, ichCoords + 14, ichCoords + 21);
                    int atomIndex = (lineBaseFreqCount + j) * firstAtomSetAtomCount + i;
                    Atom atom = atoms[atomIndex];
                    atom.vectorX = x;
                    atom.vectorY = y;
                    atom.vectorZ = z;
                }
                ++i;
            }
            break;
        }
    }
}

