/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import java.util.Hashtable;
import org.jmol.adapter.readers.more.SpartanArchive;
import org.jmol.adapter.readers.more.SpartanInputReader;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.Logger;

public class SpartanSmolReader
extends SpartanInputReader {
    private String endCheck = "END Directory Entry ";
    private Hashtable moData = new Hashtable();
    private String title;
    SpartanArchive spartanArchive;
    Hashtable titles;

    public void readAtomSetCollection(BufferedReader reader) {
        this.modelName = "Spartan file";
        this.reader = reader;
        try {
            this.readLine();
            this.atomSetCollection = new AtomSetCollection("spartan smol");
            boolean iHaveModelStatement = false;
            boolean iHaveModel = false;
            while (this.line != null) {
                if (this.line.indexOf("JMOL_MODEL") >= 0 && !this.line.startsWith("END")) {
                    if (this.modelNumber > 0) {
                        this.applySymmetryAndSetTrajectory();
                    }
                    iHaveModelStatement = true;
                    int modelNo = this.getModelNumber();
                    this.modelNumber = this.bsModels == null && modelNo != Integer.MIN_VALUE ? modelNo : this.modelNumber + 1;
                    this.bondData = "";
                    if (!this.doGetModel(this.modelNumber)) {
                        if (this.isLastModel(this.modelNumber) && iHaveModel) break;
                        iHaveModel = false;
                        this.readLine();
                        continue;
                    }
                    iHaveModel = true;
                    this.atomSetCollection.newAtomSet();
                    this.moData = new Hashtable();
                    if (modelNo == Integer.MIN_VALUE) {
                        modelNo = this.modelNumber;
                        this.title = "Model " + this.line.substring(this.line.lastIndexOf(" ") + 1);
                    } else {
                        this.title = (String)this.titles.get("Title" + modelNo);
                        this.title = "Profile " + modelNo + (this.title == null ? "" : ": " + this.title);
                    }
                    Logger.info(this.title);
                    this.atomSetCollection.setAtomSetAuxiliaryInfo("title", this.title);
                    this.atomSetCollection.setAtomSetName(this.title);
                    this.atomSetCollection.setAtomSetAuxiliaryInfo("isPDB", Boolean.FALSE);
                    this.atomSetCollection.setAtomSetNumber(modelNo);
                    this.readLine();
                    continue;
                }
                if (iHaveModelStatement && !iHaveModel) {
                    this.readLine();
                    continue;
                }
                if (this.line.indexOf("BEGIN") == 0) {
                    String lcline = this.line.toLowerCase();
                    if (lcline.endsWith("input")) {
                        this.bondData = "";
                        this.readInputRecords();
                        if (this.atomSetCollection.errorMessage != null) {
                            return;
                        }
                        if (this.title != null) {
                            this.atomSetCollection.setAtomSetName(this.title);
                        }
                    } else {
                        if (lcline.endsWith("_output")) {
                            this.readLine();
                            continue;
                        }
                        if (lcline.endsWith("output")) {
                            this.readOutput();
                            continue;
                        }
                        if (lcline.endsWith("molecule") || lcline.endsWith("molecule:asbinarystring")) {
                            this.readTransform();
                            continue;
                        }
                        if (lcline.endsWith("proparc") || lcline.endsWith("propertyarchive")) {
                            this.readProperties();
                            continue;
                        }
                        if (lcline.endsWith("archive")) {
                            this.readArchive();
                            continue;
                        }
                    }
                }
                if (this.line != null && this.line.indexOf("5D shell") >= 0) {
                    this.calculationType = this.line;
                    this.moData.put("calculationType", this.calculationType);
                }
                this.readLine();
            }
            if (this.atomCount > 0) {
                this.applySymmetryAndSetTrajectory();
            }
            if (this.atomCount > 0 && this.spartanArchive != null && this.atomSetCollection.getBondCount() == 0 && this.bondData != null) {
                this.spartanArchive.addBonds(this.bondData, 0);
            }
        }
        catch (Exception e) {
            this.setError(e);
        }
    }

    private void readOutput() throws Exception {
        this.titles = new Hashtable();
        String header = "";
        while (this.readLine() != null && !this.line.startsWith("END ")) {
            header = header + this.line + "\n";
            int pt = this.line.indexOf(")");
            if (pt <= 0) continue;
            this.titles.put("Title" + this.parseInt(this.line.substring(0, pt)), this.line.substring(pt + 1).trim());
        }
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("fileHeader", header);
    }

    private void readArchive() throws Exception {
        this.spartanArchive = new SpartanArchive(this, this.atomSetCollection, this.moData, this.bondData, this.endCheck);
        if (this.readArchiveHeader()) {
            this.modelAtomCount = this.spartanArchive.readArchive(this.line, false, this.atomCount, false);
            if (this.atomCount == 0 || !this.isTrajectory) {
                this.atomCount += this.modelAtomCount;
            }
        }
    }

    private void readProperties() throws Exception {
        this.spartanArchive.readProperties();
        if (!this.atomSetCollection.setAtomSetCollectionPartialCharges("MULCHARGES")) {
            this.atomSetCollection.setAtomSetCollectionPartialCharges("Q1_CHARGES");
        }
        Float n = (Float)this.atomSetCollection.getAtomSetCollectionAuxiliaryInfo("HOMO_N");
        if (this.moData != null && n != null) {
            this.moData.put("HOMO", new Integer(n.intValue()));
        }
        this.readLine();
    }

    private int getModelNumber() {
        try {
            int pt = this.line.indexOf("JMOL_MODEL ") + 11;
            return this.parseInt(this.line, pt);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private void readTransform() throws Exception {
        MoleculeRecord mr = new MoleculeRecord(this.readLine());
        mr.setTrans();
    }

    private boolean readArchiveHeader() throws Exception {
        String modelInfo = this.readLine();
        Logger.debug(modelInfo);
        if (modelInfo.indexOf("Error:") == 0) {
            return false;
        }
        this.atomSetCollection.setCollectionName(modelInfo);
        this.modelName = this.readLine();
        Logger.debug(this.modelName);
        this.readLine();
        return true;
    }

    private class MoleculeRecord {
        float[] mat;

        MoleculeRecord(String binaryCodes) {
            int i;
            String[] tokens = AtomSetCollectionReader.getTokens(binaryCodes.trim());
            if (tokens.length < 16) {
                return;
            }
            byte[] bytes = new byte[tokens.length];
            for (i = 0; i < tokens.length; ++i) {
                bytes[i] = (byte)Integer.parseInt(tokens[i], 16);
            }
            this.mat = new float[16];
            i = 16;
            int j = bytes.length;
            while (--i >= 0) {
                this.mat[i] = this.bytesToDoubleToFloat(bytes, j);
                j -= 8;
            }
        }

        private float bytesToDoubleToFloat(byte[] bytes, int j) {
            double d = Double.longBitsToDouble(((long)bytes[--j] & 0xFFL) << 56 | ((long)bytes[--j] & 0xFFL) << 48 | ((long)bytes[--j] & 0xFFL) << 40 | ((long)bytes[--j] & 0xFFL) << 32 | ((long)bytes[--j] & 0xFFL) << 24 | ((long)bytes[--j] & 0xFFL) << 16 | ((long)bytes[--j] & 0xFFL) << 8 | (long)bytes[--j] & 0xFFL);
            return (float)d;
        }

        protected void setTrans() {
            if (this.mat == null) {
                return;
            }
            SpartanSmolReader.this.setTransform(this.mat[0], this.mat[1], this.mat[2], this.mat[4], this.mat[5], this.mat[6], this.mat[8], this.mat[9], this.mat[10]);
        }
    }
}

