/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Vector;
import org.jmol.adapter.readers.more.MopacDataReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.Bond;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;

public class WebMOReader
extends MopacDataReader {
    public void readAtomSetCollection(BufferedReader reader) {
        this.reader = reader;
        this.atomSetCollection = new AtomSetCollection("webmo");
        this.modelNumber = 0;
        try {
            this.readLine();
            while (this.line != null) {
                if (this.line.equals("[HEADER]")) {
                    this.readHeader();
                    continue;
                }
                if (this.line.equals("[ATOMS]")) {
                    this.readAtoms();
                    continue;
                }
                if (this.line.equals("[BONDS]")) {
                    this.readBonds();
                    continue;
                }
                if (this.line.equals("[AO_ORDER]")) {
                    this.readAtomicOrbitalOrder();
                    continue;
                }
                if (this.line.equals("[GTO]")) {
                    this.readGaussianBasis();
                    continue;
                }
                if (this.line.equals("[STO]")) {
                    this.readSlaterBasis();
                    continue;
                }
                if (this.line.indexOf("[MO") == 0) {
                    if (!this.doGetModel(++this.modelNumber)) continue;
                    this.readMolecularOrbital();
                    if (!this.isLastModel(this.modelNumber)) continue;
                    break;
                }
                this.readLine();
            }
            if (Logger.debugging) {
                Logger.debug(this.orbitals.size() + " molecular orbitals read");
            }
        }
        catch (Exception e) {
            this.setError(e);
        }
    }

    void readHeader() throws Exception {
        while (this.readLine() != null && this.line.length() > 0) {
            this.moData.put("calculationType", "?");
            String[] tokens = this.getTokens();
            tokens[0] = tokens[0].substring(0, 1).toLowerCase() + tokens[0].substring(1, tokens[0].length());
            String str = "";
            for (int i = 1; i < tokens.length; ++i) {
                str = str + (i == 1 ? "" : " ") + tokens[i].toLowerCase();
            }
            this.moData.put(tokens[0], str);
        }
    }

    void readAtoms() throws Exception {
        boolean isAtomicNumber;
        this.readLine();
        boolean bl = isAtomicNumber = this.parseInt(this.line) != Integer.MIN_VALUE;
        while (this.line != null && (this.line.length() == 0 || this.line.charAt(0) != '[')) {
            if (this.line.length() != 0) {
                Atom atom = this.atomSetCollection.addNewAtom();
                String[] tokens = this.getTokens();
                atom.elementSymbol = isAtomicNumber ? WebMOReader.getElementSymbol(this.parseInt(tokens[0])) : tokens[0];
                atom.set(this.parseFloat(tokens[1]), this.parseFloat(tokens[2]), this.parseFloat(tokens[3]));
                atom.scale(0.5291772f);
            }
            this.readLine();
        }
    }

    void readBonds() throws Exception {
        while (this.readLine() != null && (this.line.length() == 0 || this.line.charAt(0) != '[')) {
            if (this.line.length() == 0) continue;
            String[] tokens = this.getTokens();
            int atomIndex1 = this.parseInt(tokens[0]);
            int atomIndex2 = this.parseInt(tokens[1]);
            int order = this.parseInt(tokens[2]);
            this.atomSetCollection.addBond(new Bond(atomIndex1 - 1, atomIndex2 - 1, order));
        }
    }

    void readAtomicOrbitalOrder() throws Exception {
        Hashtable<String, String[]> info = new Hashtable<String, String[]>();
        while (this.readLine() != null && (this.line.length() == 0 || this.line.charAt(0) != '[')) {
            if (this.line.length() == 0) continue;
            String[] tokens = this.getTokens();
            info.put(tokens[0].substring(0, 1), tokens);
        }
        this.moData.put("atomicOrbitalOrder", info);
    }

    void readGaussianBasis() throws Exception {
        Vector<int[]> sdata = new Vector<int[]>();
        Vector<float[]> gdata = new Vector<float[]>();
        int atomIndex = 0;
        int gaussianPtr = 0;
        while (this.readLine() != null && (this.line.length() == 0 || this.line.charAt(0) != '[')) {
            String[] tokens = this.getTokens();
            if (tokens.length == 0) continue;
            if (tokens.length != 1) {
                throw new Exception("Error reading GTOs: missing atom index");
            }
            int[] slater = new int[4];
            atomIndex = this.parseInt(tokens[0]) - 1;
            tokens = WebMOReader.getTokens(this.readLine());
            int nGaussians = this.parseInt(tokens[1]);
            slater[0] = atomIndex;
            slater[1] = JmolAdapter.getQuantumShellTagID(tokens[0]);
            slater[2] = gaussianPtr;
            slater[3] = nGaussians;
            for (int i = 0; i < nGaussians; ++i) {
                String[] strData = WebMOReader.getTokens(this.readLine());
                int nData = strData.length;
                float[] data = new float[nData];
                for (int d = 0; d < nData; ++d) {
                    data[d] = this.parseFloat(strData[d]);
                }
                gdata.addElement(data);
                ++gaussianPtr;
            }
            sdata.addElement(slater);
        }
        float[][] garray = new float[gaussianPtr][];
        for (int i = 0; i < gaussianPtr; ++i) {
            garray[i] = (float[])gdata.get(i);
        }
        this.moData.put("shells", sdata);
        this.moData.put("gaussians", garray);
        if (Logger.debugging) {
            Logger.debug(sdata.size() + " slater shells read");
            Logger.debug(garray.length + " gaussian primitives read");
        }
        this.atomSetCollection.setAtomSetAuxiliaryInfo("moData", this.moData);
    }

    void readSlaterBasis() throws Exception {
        while (this.readLine() != null && (this.line.length() == 0 || this.line.charAt(0) != '[')) {
            String[] tokens = this.getTokens();
            if (tokens.length < 7) continue;
            this.addSlater(this.parseInt(tokens[0]) - 1, this.parseInt(tokens[1]), this.parseInt(tokens[2]), this.parseInt(tokens[3]), this.parseInt(tokens[4]), this.parseFloat(tokens[5]), this.parseFloat(tokens[6]));
        }
        this.setSlaters();
    }

    void readMolecularOrbital() throws Exception {
        Hashtable<String, Object> mo = new Hashtable<String, Object>();
        Vector<String> data = new Vector<String>();
        float energy = this.parseFloat(this.readLine());
        float occupancy = this.parseFloat(this.readLine());
        while (this.readLine() != null && (this.line.length() == 0 || this.line.charAt(0) != '[')) {
            if (this.line.length() == 0) continue;
            String[] tokens = this.getTokens();
            data.addElement(tokens[1]);
        }
        float[] coefs = new float[data.size()];
        int i = data.size();
        while (--i >= 0) {
            coefs[i] = this.parseFloat((String)data.get(i));
        }
        mo.put("energy", new Float(energy));
        mo.put("occupancy", new Float(occupancy));
        mo.put("coefficients", coefs);
        this.orbitals.addElement(mo);
        this.setMOs("eV");
    }
}

