/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xml;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.HashMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import netscape.javascript.JSObject;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Resolver;
import org.jmol.util.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XmlReader
extends AtomSetCollectionReader {
    protected XmlReader parent;
    protected Atom atom;
    String[] implementedAttributes = new String[]{"id"};
    protected boolean keepChars;
    protected String chars;

    public void readAtomSetCollection(BufferedReader reader) {
        this.reader = reader;
        XMLReader xmlReader = this.getXMLReader();
        if (xmlReader == null) {
            this.atomSetCollection = new AtomSetCollection("xml");
            this.atomSetCollection.errorMessage = "No XML reader found";
            return;
        }
        try {
            this.processXml(xmlReader);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.atomSetCollection.errorMessage = "XML reader error: " + e.getMessage();
        }
    }

    private XMLReader getXMLReader() {
        XMLReader xmlr = null;
        if (xmlr == null && System.getProperty("java.version").compareTo("1.4") >= 0) {
            xmlr = this.allocateXmlReader14();
        }
        if (xmlr == null) {
            xmlr = this.allocateXmlReaderAelfred2();
        }
        return xmlr;
    }

    private XMLReader allocateXmlReader14() {
        XMLReader xmlr = null;
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            SAXParser saxParser = spf.newSAXParser();
            xmlr = saxParser.getXMLReader();
            Logger.debug("Using JAXP/SAX XML parser.");
        }
        catch (Exception e) {
            Logger.debug("Could not instantiate JAXP/SAX XML reader: " + e.getMessage());
        }
        return xmlr;
    }

    private XMLReader allocateXmlReaderAelfred2() {
        XMLReader xmlr = null;
        try {
            xmlr = (XMLReader)this.getClass().getClassLoader().loadClass("gnu.xml.aelfred2.XmlReader").newInstance();
            Logger.debug("Using Aelfred2 XML parser.");
        }
        catch (Exception e) {
            Logger.debug("Could not instantiate Aelfred2 XML reader!");
        }
        return xmlr;
    }

    private Object processXml(XMLReader xmlReader) throws Exception {
        this.atomSetCollection = new AtomSetCollection(this.readerName);
        Object res = this.getXmlReader();
        if (res instanceof String) {
            return res;
        }
        XmlReader thisReader = (XmlReader)res;
        thisReader.processXml(this, this.atomSetCollection, this.reader, xmlReader);
        return thisReader;
    }

    private Object getXmlReader() {
        String className = null;
        String err = null;
        XmlReader thisReader = null;
        try {
            int pt = this.readerName.indexOf("(");
            String name = pt < 0 ? this.readerName : this.readerName.substring(0, pt);
            className = Resolver.getReaderClassBase(name);
            Class<?> atomSetCollectionReaderClass = Class.forName(className);
            thisReader = (XmlReader)atomSetCollectionReaderClass.newInstance();
        }
        catch (Exception e) {
            err = "File reader was not found:" + className;
            Logger.error(err);
            return err;
        }
        return thisReader;
    }

    protected void processXml(XmlReader parent, AtomSetCollection atomSetCollection, BufferedReader reader, XMLReader xmlReader) {
    }

    protected void parseReaderXML(XMLReader xmlReader) {
        xmlReader.setEntityResolver(new DummyResolver());
        InputSource is = new InputSource(this.reader);
        is.setSystemId("foo");
        try {
            xmlReader.parse(is);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.atomSetCollection.errorMessage = "XML parsing error: " + e.getMessage();
        }
    }

    public void readAtomSetCollectionFromDOM(Object Node2) {
        this.processXml((JSObject)Node2);
    }

    private Object processXml(JSObject DOMNode) {
        this.atomSetCollection = new AtomSetCollection(this.readerName);
        String className = null;
        String err = null;
        XmlReader thisReader = null;
        String name = this.readerName.substring(0, this.readerName.indexOf("("));
        try {
            className = Resolver.getReaderClassBase(name);
            Class<?> atomSetCollectionReaderClass = Class.forName(className);
            thisReader = (XmlReader)atomSetCollectionReaderClass.newInstance();
        }
        catch (Exception e) {
            err = "File reader was not found:" + className;
            Logger.error(err);
            return err;
        }
        thisReader.processXml(this, this.atomSetCollection, this.reader, DOMNode);
        return thisReader;
    }

    protected void processXml(XmlReader parent, AtomSetCollection atomSetCollection, BufferedReader reader, JSObject DOMNode) {
    }

    protected void processStartElement(String namespaceURI, String localName, String qName, HashMap atts) {
    }

    protected void setKeepChars(boolean TF) {
        this.keepChars = TF;
        this.chars = null;
    }

    protected void processEndElement(String uri, String localName, String qName) {
    }

    public class JmolXmlHandler
    extends DefaultHandler
    implements ErrorHandler {
        public HashMap atts;

        public JmolXmlHandler() {
        }

        public JmolXmlHandler(XMLReader xmlReader2) {
            this.setHandler(xmlReader2, this);
        }

        public void setHandler(XMLReader xmlReader, JmolXmlHandler handler) {
            try {
                xmlReader.setFeature("http://xml.org/sax/features/validation", false);
                xmlReader.setFeature("http://xml.org/sax/features/namespaces", true);
                xmlReader.setEntityResolver(handler);
                xmlReader.setContentHandler(handler);
                xmlReader.setErrorHandler(handler);
            }
            catch (Exception e) {
                Logger.error("ERROR IN XmlReader.JmolXmlHandler.setHandler", e);
            }
        }

        public void startDocument() {
        }

        public void endDocument() {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) {
            this.getAttributes(attributes);
            if (Logger.debugging) {
                Logger.debug("start " + localName);
            }
            this.startElement(namespaceURI, localName, qName);
        }

        private void startElement(String namespaceURI, String localName, String qName) {
            XmlReader.this.processStartElement(namespaceURI, localName, qName, this.atts);
        }

        public void endElement(String uri, String localName, String qName) {
            if (Logger.debugging) {
                Logger.debug("end " + localName);
            }
            XmlReader.this.processEndElement(uri, localName, qName);
        }

        public void characters(char[] ch, int start, int length) {
            if (XmlReader.this.keepChars) {
                XmlReader.this.chars = XmlReader.this.chars == null ? new String(ch, start, length) : XmlReader.this.chars + new String(ch, start, length);
            }
        }

        public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) {
            if (Logger.debugging) {
                Logger.debug("Not resolving this:\n      name: " + name + "\n  systemID: " + systemId + "\n  publicID: " + publicId + "\n   baseURI: " + baseURI);
            }
            return null;
        }

        public InputSource resolveEntity(String publicId, String systemId) {
            if (Logger.debugging) {
                Logger.debug("Not resolving this:\n  publicID: " + publicId + "\n  systemID: " + systemId);
            }
            return null;
        }

        public void error(SAXParseException exception) {
            Logger.error("SAX ERROR:" + exception.getMessage());
        }

        public void fatalError(SAXParseException exception) {
            Logger.error("SAX FATAL:" + exception.getMessage());
        }

        public void warning(SAXParseException exception) {
            Logger.warn("SAX WARNING:" + exception.getMessage());
        }

        protected void walkDOMTree(JSObject DOMNode) {
            String namespaceURI = (String)DOMNode.getMember("namespaceURI");
            String localName = (String)DOMNode.getMember("localName");
            String qName = (String)DOMNode.getMember("nodeName");
            JSObject attributes = (JSObject)DOMNode.getMember("attributes");
            this.getAttributes(attributes);
            this.startElement(namespaceURI, localName, qName);
            if (((Boolean)DOMNode.call("hasChildNodes", null)).booleanValue()) {
                for (JSObject nextNode = (JSObject)DOMNode.getMember("firstChild"); nextNode != (JSObject)null; nextNode = (JSObject)nextNode.getMember("nextSibling")) {
                    this.walkDOMTree(nextNode);
                }
            }
            this.endElement(namespaceURI, localName, qName);
        }

        private void getAttributes(Attributes attributes) {
            int nAtts = attributes.getLength();
            this.atts = new HashMap(nAtts);
            int i = nAtts;
            while (--i >= 0) {
                this.atts.put(attributes.getLocalName(i), attributes.getValue(i));
            }
        }

        private void getAttributes(JSObject attributes) {
            if (attributes == null) {
                this.atts = new HashMap(0);
                return;
            }
            int nAtts = ((Number)attributes.getMember("length")).intValue();
            this.atts = new HashMap(nAtts);
            int i = XmlReader.this.implementedAttributes.length;
            while (--i >= 0) {
                Object[] attArgs = new Object[]{XmlReader.this.implementedAttributes[i]};
                JSObject attNode = (JSObject)attributes.call("getNamedItem", attArgs);
                if (attNode == null) continue;
                String attLocalName = (String)attNode.getMember("name");
                String attValue = (String)attNode.getMember("value");
                this.atts.put(attLocalName, attValue);
            }
        }
    }

    public static class DummyResolver
    implements EntityResolver {
        public InputSource resolveEntity(String publicID, String systemID) throws SAXException {
            if (Logger.debugging) {
                Logger.debug("Jmol SAX EntityResolver not resolving:\n  publicID: " + publicID + "\n  systemID: " + systemID);
            }
            return new InputSource(new BufferedReader(new StringReader("")));
        }
    }
}

