/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xml;

import java.io.BufferedReader;
import java.util.BitSet;
import java.util.HashMap;
import netscape.javascript.JSObject;
import org.jmol.adapter.readers.xml.XmlReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.util.TextFormat;
import org.xml.sax.XMLReader;

public class XmlXsdReader
extends XmlReader {
    String[] xsdImplementedAttributes = new String[]{"ID", "XYZ", "Connections", "Components", "IsBackboneAtom", "Connects", "Type", "Name"};
    private BitSet bsBackbone = new BitSet();
    private int iChain = -1;
    private int iGroup = 0;
    private int iAtom = 0;

    protected void processXml(XmlReader parent, AtomSetCollection atomSetCollection, BufferedReader reader, XMLReader xmlReader) {
        this.init(parent, atomSetCollection);
        this.reader = reader;
        new XsdHandler(xmlReader);
        this.parseReaderXML(xmlReader);
        this.fin();
    }

    protected void processXml(XmlReader parent, AtomSetCollection atomSetCollection, BufferedReader reader, JSObject DOMNode) {
        this.init(parent, atomSetCollection);
        this.implementedAttributes = this.xsdImplementedAttributes;
        new XsdHandler().walkDOMTree(DOMNode);
        this.fin();
    }

    private void init(XmlReader parent, AtomSetCollection atomSetCollection) {
        this.parent = parent;
        this.atomSetCollection = atomSetCollection;
        parent.htParams.put("backboneAtoms", this.bsBackbone);
    }

    private void fin() {
        this.atomSetCollection.clearSymbolicMap();
    }

    public void processStartElement(String namespaceURI, String localName, String qName, HashMap atts) {
        System.out.println(namespaceURI + " " + localName + " " + atts);
        if ("Molecule".equals(localName)) {
            this.atomSetCollection.newAtomSet();
            this.atomSetCollection.setAtomSetName((String)atts.get("Name"));
            return;
        }
        if ("LinearChain".equals(localName)) {
            this.iGroup = 0;
            ++this.iChain;
        }
        if ("RepeatUnit".equals(localName)) {
            ++this.iGroup;
        }
        if ("Atom3d".equals(localName)) {
            boolean isBackbone;
            this.atom = new Atom();
            this.atom.elementSymbol = (String)atts.get("Components");
            this.atom.atomName = (String)atts.get("ID");
            this.atom.atomSerial = ++this.iAtom;
            if (this.iChain >= 0) {
                this.atom.chainID = (char)((this.iChain - 1) % 26 + 65);
            }
            this.atom.group3 = "UNK";
            if (this.iGroup == 0) {
                this.iGroup = 1;
            }
            this.atom.sequenceNumber = this.iGroup;
            String xyz = (String)atts.get("XYZ");
            if (xyz != null) {
                String[] tokens = XmlXsdReader.getTokens(xyz.replace(',', ' '));
                this.atom.set(this.parseFloat(tokens[0]), this.parseFloat(tokens[1]), this.parseFloat(tokens[2]));
            }
            if (isBackbone = "1".equals((String)atts.get("IsBackboneAtom"))) {
                this.bsBackbone.set(this.iAtom);
            }
            return;
        }
        if ("Bond".equals(localName)) {
            String[] atoms = TextFormat.split((String)atts.get("Connects"), ',');
            int order = 1;
            if (atts.containsKey("Type")) {
                String type = (String)atts.get("Type");
                if (type.equals("Double")) {
                    order = 2;
                } else if (type.equals("Triple")) {
                    order = 3;
                }
            }
            this.atomSetCollection.addNewBond(atoms[0], atoms[1], order);
            return;
        }
    }

    public void processEndElement(String uri, String localName, String qName) {
        if ("Atom3d".equals(localName)) {
            if (this.atom.elementSymbol != null && !Float.isNaN(this.atom.z)) {
                this.atomSetCollection.addAtomWithMappedName(this.atom);
            }
            this.atom = null;
            return;
        }
        this.keepChars = false;
        this.chars = null;
    }

    class XsdHandler
    extends XmlReader.JmolXmlHandler {
        XsdHandler() {
        }

        XsdHandler(XMLReader xmlReader) {
            this.setHandler(xmlReader, this);
        }
    }
}

