/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.api.Interface;
import org.jmol.api.JmolAdapter;
import org.jmol.api.SymmetryInterface;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.util.Quaternion;

public abstract class AtomSetCollectionReader {
    public static final float ANGSTROMS_PER_BOHR = 0.5291772f;
    protected AtomSetCollection atomSetCollection;
    protected BufferedReader reader;
    protected String readerName;
    public Hashtable htParams;
    public String line;
    public String prevline;
    protected int[] next = new int[1];
    private long ptLine;
    public int[] latticeCells;
    public boolean iHaveUnitCell;
    public boolean iHaveSymmetryOperators;
    protected boolean doApplySymmetry;
    protected boolean ignoreFileSymmetryOperators;
    protected boolean isTrajectory;
    protected boolean applySymmetryToBonds;
    protected boolean needToApplySymmetry;
    protected boolean getHeader;
    protected int templateAtomCount;
    protected int modelNumber;
    protected BitSet bsModels;
    protected BitSet bsFilter;
    protected String filter;
    protected boolean haveAtomFilter;
    protected String spaceGroup;
    protected boolean havePartialChargeFilter;
    public String calculationType = "?";
    private boolean iHaveFractionalCoordinates;
    private boolean doPackUnitCell;
    private boolean doConvertToFractional;
    private boolean fileCoordinatesAreFractional;
    private boolean ignoreFileUnitCell;
    private boolean ignoreFileSpaceGroupName;
    private float symmetryRange;
    private float[] notionalUnitCell;
    private int[] firstLastStep;
    private int desiredModelNumber = Integer.MIN_VALUE;
    private int lastModelNumber = Integer.MAX_VALUE;
    private int desiredSpaceGroupIndex = -1;
    private SymmetryInterface symmetry;
    private boolean haveModel = false;
    private int nMatrixElements = 0;
    private Matrix3f matrixRotate;
    private String previousScript;

    public Object readData(String filename, Hashtable htParams, BufferedReader reader) throws Exception {
        this.initialize(htParams);
        this.readAtomSetCollection(reader);
        reader.close();
        return this.finalize(htParams, filename);
    }

    protected Object readData(String filename, Hashtable htParams, Object DOMNode) {
        this.initialize(htParams);
        this.readAtomSetCollectionFromDOM(DOMNode);
        return this.finalize(htParams, filename);
    }

    public abstract void readAtomSetCollection(BufferedReader var1);

    public void readAtomSetCollectionFromDOM(Object DOMNode) {
    }

    private Object finalize(Hashtable htParams, String filename) {
        String fileType;
        if (!htParams.containsKey("templateAtomCount")) {
            htParams.put("templateAtomCount", new Integer(this.atomSetCollection.getAtomCount()));
        }
        if (htParams.containsKey("bsFilter")) {
            htParams.put("filteredAtomCount", new Integer(BitSetUtil.cardinalityOf((BitSet)htParams.get("bsFilter"))));
        }
        if (!this.calculationType.equals("?")) {
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("calculationType", this.calculationType);
        }
        if ((fileType = this.atomSetCollection.fileTypeName).indexOf("(") >= 0) {
            fileType = fileType.substring(0, fileType.indexOf("("));
        }
        int i = this.atomSetCollection.getAtomSetCount();
        while (--i >= 0) {
            this.atomSetCollection.setAtomSetAuxiliaryInfo("fileName", filename, i);
            this.atomSetCollection.setAtomSetAuxiliaryInfo("fileType", fileType, i);
        }
        this.atomSetCollection.freeze();
        if (this.atomSetCollection.errorMessage != null) {
            return this.atomSetCollection.errorMessage + "\nfor file " + filename + "\ntype " + this.atomSetCollection.fileTypeName;
        }
        if (this.atomSetCollection.atomCount == 0) {
            return "No atoms found\nfor file " + filename + "\ntype " + this.atomSetCollection.fileTypeName;
        }
        return this.atomSetCollection;
    }

    protected void setError(Exception e) {
        e.printStackTrace();
        this.atomSetCollection.errorMessage = this.line == null ? "Unexpected end of file after line " + --this.ptLine + ":\n" + this.prevline : "Error reading file at line " + this.ptLine + ":\n" + this.line + "\n" + e.getMessage();
    }

    void initialize(Hashtable htParams) {
        int ptFile;
        this.initializeSymmetry();
        this.htParams = htParams;
        this.getHeader = htParams.containsKey("getHeader");
        this.readerName = (String)htParams.get("readerName");
        if (htParams.containsKey("modelNumber")) {
            this.desiredModelNumber = (Integer)htParams.get("modelNumber");
        }
        this.applySymmetryToBonds = htParams.containsKey("applySymmetryToBonds");
        this.filter = (String)htParams.get("filter");
        this.haveAtomFilter = this.filter != null && (this.filter.indexOf(".") >= 0 || this.filter.indexOf("[") >= 0 || this.filter.indexOf(".") >= 0);
        this.havePartialChargeFilter = this.filter != null && this.filter.toLowerCase().indexOf("charge=") >= 0;
        this.bsFilter = (BitSet)htParams.get("bsFilter");
        if (this.bsFilter == null && this.filter != null) {
            this.bsFilter = new BitSet();
            htParams.put("bsFilter", this.bsFilter);
            this.filter = (";" + this.filter + ";").replace(',', ';');
            Logger.info("filtering with " + this.filter);
        }
        int n = ptFile = htParams.containsKey("ptFile") ? (Integer)htParams.get("ptFile") : -1;
        if (ptFile > 0 && htParams.containsKey("firstLastSteps")) {
            Object val = ((Vector)htParams.get("firstLastSteps")).elementAt(ptFile - 1);
            if (val instanceof BitSet) {
                this.bsModels = (BitSet)val;
            } else {
                this.firstLastStep = (int[])val;
            }
            this.templateAtomCount = (Integer)htParams.get("templateAtomCount");
        } else if (htParams.containsKey("firstLastStep")) {
            this.isTrajectory = htParams.containsKey("isTrajectory");
            this.firstLastStep = (int[])htParams.get("firstLastStep");
        } else if (htParams.containsKey("bsModels")) {
            this.isTrajectory = htParams.containsKey("isTrajectory");
            this.bsModels = (BitSet)htParams.get("bsModels");
        }
        if (this.bsModels != null || this.firstLastStep != null) {
            this.desiredModelNumber = Integer.MIN_VALUE;
        }
        if (this.bsModels == null && this.firstLastStep != null) {
            if (this.firstLastStep[0] < 0) {
                this.firstLastStep[0] = 0;
            }
            if (this.firstLastStep[2] == 0 || this.firstLastStep[1] < this.firstLastStep[0]) {
                this.firstLastStep[1] = -1;
            }
            if (this.firstLastStep[2] < 1) {
                this.firstLastStep[2] = 1;
            }
            this.bsModels = new BitSet();
            this.bsModels.set(this.firstLastStep[0]);
            if (this.firstLastStep[1] > this.firstLastStep[0]) {
                for (int i = this.firstLastStep[0]; i <= this.firstLastStep[1]; i += this.firstLastStep[2]) {
                    this.bsModels.set(i);
                }
            }
        }
        if (this.bsModels != null && (this.firstLastStep == null || this.firstLastStep[1] != -1)) {
            this.lastModelNumber = BitSetUtil.length(this.bsModels);
        }
        this.symmetryRange = htParams.containsKey("symmetryRange") ? ((Float)htParams.get("symmetryRange")).floatValue() : 0.0f;
        this.latticeCells = new int[3];
        if (htParams.containsKey("lattice")) {
            Point3f pt = (Point3f)htParams.get("lattice");
            this.latticeCells[0] = (int)pt.x;
            this.latticeCells[1] = (int)pt.y;
            this.latticeCells[2] = (int)pt.z;
            this.doPackUnitCell = htParams.containsKey("packed") || this.latticeCells[2] < 0;
        }
        boolean bl = this.doApplySymmetry = this.latticeCells[0] > 0 && this.latticeCells[1] > 0;
        if (!this.doApplySymmetry) {
            this.latticeCells[0] = 0;
            this.latticeCells[1] = 0;
            this.latticeCells[2] = 0;
        }
        if (htParams.containsKey("spaceGroupIndex")) {
            this.desiredSpaceGroupIndex = (Integer)htParams.get("spaceGroupIndex");
            if (this.desiredSpaceGroupIndex == -2) {
                this.spaceGroup = (String)htParams.get("spaceGroupName");
            }
            this.ignoreFileSpaceGroupName = this.desiredSpaceGroupIndex == -2 || this.desiredSpaceGroupIndex >= 0;
            boolean bl2 = this.ignoreFileSymmetryOperators = this.desiredSpaceGroupIndex != -1;
        }
        if (htParams.containsKey("unitcell")) {
            float[] fParams = (float[])htParams.get("unitcell");
            this.setUnitCell(fParams[0], fParams[1], fParams[2], fParams[3], fParams[4], fParams[5]);
            this.ignoreFileUnitCell = this.iHaveUnitCell;
        }
    }

    protected boolean doGetModel(int modelNumber) {
        boolean isOK = this.bsModels == null ? this.desiredModelNumber == Integer.MIN_VALUE || modelNumber == this.desiredModelNumber : (modelNumber > this.lastModelNumber ? false : modelNumber > 0 && this.bsModels.get(modelNumber - 1) || this.haveModel && this.firstLastStep != null && this.firstLastStep[1] < 0 && (this.firstLastStep[2] < 2 || (modelNumber - 1 - this.firstLastStep[0]) % this.firstLastStep[2] == 0));
        this.haveModel |= isOK;
        return isOK;
    }

    protected boolean isLastModel(int modelNumber) {
        return this.desiredModelNumber != Integer.MIN_VALUE || modelNumber >= this.lastModelNumber;
    }

    private void initializeSymmetry() {
        this.iHaveUnitCell = this.ignoreFileUnitCell;
        if (!this.ignoreFileUnitCell) {
            this.notionalUnitCell = new float[22];
            int i = 22;
            while (--i >= 0) {
                this.notionalUnitCell[i] = Float.NaN;
            }
            this.symmetry = null;
        }
        if (!this.ignoreFileSpaceGroupName) {
            this.spaceGroup = "unspecified *";
        }
        this.needToApplySymmetry = false;
    }

    protected void newAtomSet(String name) {
        if (this.atomSetCollection.currentAtomSetIndex >= 0) {
            this.atomSetCollection.newAtomSet();
            this.atomSetCollection.setCollectionName("<collection of " + (this.atomSetCollection.currentAtomSetIndex + 1) + " models>");
        } else {
            this.atomSetCollection.setCollectionName(name);
        }
        Logger.debug(name);
    }

    public void setSpaceGroupName(String name) {
        if (this.ignoreFileSpaceGroupName) {
            return;
        }
        this.spaceGroup = name.trim();
    }

    public void setSymmetryOperator(String xyz) {
        if (this.ignoreFileSymmetryOperators) {
            return;
        }
        this.atomSetCollection.setLatticeCells(this.latticeCells, this.applySymmetryToBonds, this.doPackUnitCell);
        if (!this.atomSetCollection.addSpaceGroupOperation(xyz)) {
            Logger.warn("Skipping symmetry operation " + xyz);
        }
        this.iHaveSymmetryOperators = true;
    }

    private void initializeCartesianToFractional() {
        int i;
        for (i = 0; i < 16; ++i) {
            if (Float.isNaN(this.notionalUnitCell[6 + i])) continue;
            return;
        }
        for (i = 0; i < 16; ++i) {
            this.notionalUnitCell[6 + i] = i % 5 == 0 ? 1 : 0;
        }
        this.nMatrixElements = 0;
    }

    public void clearLatticeParameters() {
        if (this.ignoreFileUnitCell) {
            return;
        }
        for (int i = 6; i < this.notionalUnitCell.length; ++i) {
            this.notionalUnitCell[i] = Float.NaN;
        }
        this.checkUnitCell(6);
    }

    public void setUnitCellItem(int i, float x) {
        if (this.ignoreFileUnitCell) {
            return;
        }
        if (!Float.isNaN(x) && i >= 6 && Float.isNaN(this.notionalUnitCell[6])) {
            this.initializeCartesianToFractional();
        }
        this.notionalUnitCell[i] = x;
        if (Logger.debugging) {
            Logger.debug("setunitcellitem " + i + " " + x);
        }
        if (i < 6 || Float.isNaN(x)) {
            this.iHaveUnitCell = this.checkUnitCell(6);
        } else if (++this.nMatrixElements == 12) {
            this.checkUnitCell(22);
        }
    }

    protected void setUnitCell(float a, float b, float c, float alpha, float beta, float gamma) {
        if (this.ignoreFileUnitCell) {
            return;
        }
        this.notionalUnitCell[0] = a;
        this.notionalUnitCell[1] = b;
        this.notionalUnitCell[2] = c;
        this.notionalUnitCell[3] = alpha;
        this.notionalUnitCell[4] = beta;
        this.notionalUnitCell[5] = gamma;
        this.iHaveUnitCell = this.checkUnitCell(6);
    }

    public void addPrimitiveLatticeVector(int i, float[] xyz) {
        i = 6 + i * 3;
        this.notionalUnitCell[i++] = xyz[0];
        this.notionalUnitCell[i++] = xyz[1];
        this.notionalUnitCell[i++] = xyz[2];
        this.checkUnitCell(15);
    }

    private boolean checkUnitCell(int n) {
        for (int i = 0; i < n; ++i) {
            if (!Float.isNaN(this.notionalUnitCell[i])) continue;
            return false;
        }
        this.newSymmetry().setUnitCell(this.notionalUnitCell);
        if (this.doApplySymmetry) {
            this.doConvertToFractional = !this.fileCoordinatesAreFractional;
        }
        return true;
    }

    private SymmetryInterface newSymmetry() {
        this.symmetry = (SymmetryInterface)Interface.getOptionInterface("symmetry.Symmetry");
        return this.symmetry;
    }

    public void setFractionalCoordinates(boolean TF) {
        this.iHaveFractionalCoordinates = this.fileCoordinatesAreFractional = TF;
    }

    protected boolean filterAtom(Atom atom) {
        return !this.haveAtomFilter || this.filterAtom(atom, this.atomSetCollection.atomCount);
    }

    protected boolean filterAtom(Atom atom, int iAtom) {
        boolean isOK;
        block5: {
            block6: {
                String code;
                block4: {
                    isOK = false;
                    if (atom.group3 == null) break block4;
                    code = "[" + atom.group3.toUpperCase() + "]";
                    if (this.filter.indexOf("![") < 0 ? this.filter.indexOf("[") >= 0 && this.filter.toUpperCase().indexOf(code) < 0 : this.filter.toUpperCase().indexOf(code) >= 0) break block5;
                }
                if (atom.atomName == null) break block6;
                code = "." + atom.atomName.toUpperCase() + ";";
                if (this.filter.indexOf("!.") < 0 ? this.filter.indexOf("*.") >= 0 && this.filter.toUpperCase().indexOf(code) < 0 : this.filter.toUpperCase().indexOf(code) >= 0) break block5;
            }
            if (!(this.filter.indexOf("!:") >= 0 ? this.filter.indexOf(":" + atom.chainID) >= 0 : this.filter.indexOf(":") >= 0 && this.filter.indexOf(":" + atom.chainID) < 0)) {
                isOK = true;
            }
        }
        this.bsFilter.set(iAtom, isOK);
        return isOK;
    }

    public void setAtomCoord(Atom atom, float x, float y, float z) {
        atom.set(x, y, z);
        this.setAtomCoord(atom);
    }

    public void setAtomCoord(Atom atom) {
        if (this.doConvertToFractional && !this.fileCoordinatesAreFractional && this.symmetry != null) {
            this.symmetry.toFractional(atom);
            this.iHaveFractionalCoordinates = true;
        }
        this.needToApplySymmetry = true;
    }

    protected void addSites(Hashtable htSites) {
        this.atomSetCollection.setAtomSetAuxiliaryInfo("pdbSites", htSites);
        Enumeration e = htSites.keys();
        String sites = "";
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            Hashtable htSite = (Hashtable)htSites.get(name);
            int i = name.length();
            while (--i >= 0) {
                char ch = name.charAt(i);
                if (Character.isLetterOrDigit(ch) || ch == '\'') continue;
                name = name.substring(0, i) + "_" + name.substring(i + 1);
            }
            String seqNum = (String)htSite.get("seqNum");
            String groups = (String)htSite.get("groups");
            if (groups.length() == 0) continue;
            this.addJmolScript("@site_" + name + " " + groups);
            this.addJmolScript("@" + seqNum + " " + groups);
            this.addJmolScript("site_" + name + " = \"" + groups + "\".split(\",\")");
            sites = sites + (sites == "" ? "" : ",") + "site_" + name;
        }
        this.addJmolScript("site_list = \"" + sites + "\".split(\",\")");
    }

    public void applySymmetryAndSetTrajectory() throws Exception {
        if (this.isTrajectory) {
            this.atomSetCollection.setTrajectory();
        }
        if (!this.needToApplySymmetry || !this.iHaveUnitCell) {
            this.initializeSymmetry();
            return;
        }
        this.atomSetCollection.setCoordinatesAreFractional(this.iHaveFractionalCoordinates);
        this.atomSetCollection.setNotionalUnitCell(this.notionalUnitCell);
        this.atomSetCollection.setAtomSetSpaceGroupName(this.spaceGroup);
        this.atomSetCollection.setSymmetryRange(this.symmetryRange);
        if (this.doConvertToFractional || this.fileCoordinatesAreFractional) {
            this.atomSetCollection.setLatticeCells(this.latticeCells, this.applySymmetryToBonds, this.doPackUnitCell);
            if (this.ignoreFileSpaceGroupName || !this.iHaveSymmetryOperators) {
                SymmetryInterface symmetry = (SymmetryInterface)Interface.getOptionInterface("symmetry.Symmetry");
                if (symmetry.createSpaceGroup(this.desiredSpaceGroupIndex, this.spaceGroup.indexOf("*") >= 0 ? "P1" : this.spaceGroup, this.notionalUnitCell, this.atomSetCollection.doNormalize)) {
                    this.atomSetCollection.setAtomSetSpaceGroupName(symmetry.getSpaceGroupName());
                    this.atomSetCollection.applySymmetry(symmetry);
                }
            } else {
                this.atomSetCollection.applySymmetry();
            }
        }
        this.initializeSymmetry();
    }

    public void setMOData(Hashtable moData) {
        this.atomSetCollection.setAtomSetAuxiliaryInfo("moData", moData);
        Vector orbitals = (Vector)moData.get("mos");
        if (orbitals != null) {
            Logger.info(orbitals.size() + " molecular orbitals read in model " + this.modelNumber);
        }
    }

    public void setTransform(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3) {
        if (this.matrixRotate != null) {
            return;
        }
        this.matrixRotate = new Matrix3f();
        Vector3f v = new Vector3f();
        v.set(x1, y1, z1);
        v.normalize();
        this.matrixRotate.setColumn(0, v);
        v.set(x2, y2, z2);
        v.normalize();
        this.matrixRotate.setColumn(1, v);
        v.set(x3, y3, z3);
        v.normalize();
        this.matrixRotate.setColumn(2, v);
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("defaultOrientationMatrix", new Matrix3f(this.matrixRotate));
        Quaternion q = new Quaternion(this.matrixRotate);
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("defaultOrientationQuaternion", q);
        Logger.info("defaultOrientationMatrix = " + this.matrixRotate);
    }

    public static String getElementSymbol(int elementNumber) {
        return JmolAdapter.getElementSymbol(elementNumber);
    }

    protected static String deducePdbElementSymbol(boolean isHetero, String XX, String group3) {
        int i = XX.indexOf(0);
        String atomType = null;
        if (i >= 0) {
            atomType = XX.substring(i + 1);
            XX = XX.substring(0, i);
            if (atomType != null && atomType.length() == 1) {
                return atomType;
            }
        }
        if (XX.equalsIgnoreCase(group3)) {
            return XX;
        }
        int len = XX.length();
        char ch1 = ' ';
        i = 0;
        while (i < len) {
            char c = XX.charAt(i++);
            ch1 = c;
            if (c <= '9') continue;
        }
        char ch2 = i < len ? (char)XX.charAt(i) : (char)' ';
        String full = group3 + "." + ch1 + ch2;
        if ("OEC.CA ICA.CA OC1.CA OC2.CA OC4.CA".indexOf(full) >= 0) {
            return "Ca";
        }
        if (XX.indexOf("'") > 0 || XX.indexOf("*") >= 0 || "HCNO".indexOf(ch1) >= 0 && ch2 <= 'H' || XX.startsWith("CM")) {
            return "" + ch1;
        }
        if (isHetero && Atom.isValidElementSymbolNoCaseSecondChar(ch1, ch2)) {
            return ("" + ch1 + ch2).trim();
        }
        if (Atom.isValidElementSymbol(ch1)) {
            return "" + ch1;
        }
        if (Atom.isValidElementSymbol(ch2)) {
            return "" + ch2;
        }
        return "Xx";
    }

    protected void fillDataBlock(String[][] data) throws Exception {
        int nLines = data.length;
        for (int i = 0; i < nLines; ++i) {
            data[i] = AtomSetCollectionReader.getTokens(this.discardLinesUntilNonBlank());
        }
    }

    protected void discardLines(int nLines) throws Exception {
        int i = nLines;
        while (--i >= 0) {
            this.readLine();
        }
    }

    protected String discardLinesUntilStartsWith(String startsWith) throws Exception {
        while (this.readLine() != null && !this.line.startsWith(startsWith)) {
        }
        return this.line;
    }

    protected String discardLinesUntilContains(String containsMatch) throws Exception {
        while (this.readLine() != null && this.line.indexOf(containsMatch) < 0) {
        }
        return this.line;
    }

    protected void discardLinesUntilBlank() throws Exception {
        while (this.readLine() != null && this.line.trim().length() != 0) {
        }
    }

    protected String discardLinesUntilNonBlank() throws Exception {
        while (this.readLine() != null && this.line.trim().length() == 0) {
        }
        return this.line;
    }

    protected void checkLineForScript(String line) {
        this.line = line;
        this.checkLineForScript();
    }

    public void checkLineForScript() {
        int pt;
        if (this.line.indexOf("Jmol PDB-encoded data") >= 0) {
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("jmolData", "" + this.line);
        }
        if (this.line.endsWith("#noautobond")) {
            this.line = this.line.substring(0, this.line.lastIndexOf(35)).trim();
            this.atomSetCollection.setNoAutoBond();
        }
        if ((pt = this.line.indexOf("jmolscript:")) >= 0) {
            String script = this.line.substring(pt + 11, this.line.length());
            if (script.indexOf("#") >= 0) {
                script = script.substring(0, script.indexOf("#"));
            }
            this.addJmolScript(script);
            this.line = this.line.substring(0, pt).trim();
        }
    }

    protected void addJmolScript(String script) {
        Logger.info("#jmolScript: " + script);
        if (this.previousScript == null) {
            this.previousScript = "";
        } else if (!this.previousScript.endsWith(";")) {
            this.previousScript = this.previousScript + ";";
        }
        this.previousScript = this.previousScript + script;
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("jmolscript", this.previousScript);
    }

    public String readLine() throws Exception {
        this.prevline = this.line;
        this.line = this.reader.readLine();
        ++this.ptLine;
        if (Logger.debugging) {
            Logger.debug(this.line);
        }
        return this.line;
    }

    protected String readLineTrimmed() throws Exception {
        this.readLine();
        if (this.line == null) {
            this.line = "";
        }
        this.line = this.line.trim();
        return this.line;
    }

    protected static final String[] getStrings(String sinfo, int nFields, int width) {
        String[] fields = new String[nFields];
        int i = 0;
        int pt = 0;
        while (i < nFields) {
            fields[i] = sinfo.substring(pt, pt + width);
            ++i;
            pt += width;
        }
        return fields;
    }

    protected String[] getTokens() {
        return Parser.getTokens(this.line);
    }

    protected static void getTokensFloat(String s, float[] f, int n) {
        Parser.parseFloatArray(AtomSetCollectionReader.getTokens(s), f, n);
    }

    public static String[] getTokens(String s) {
        return Parser.getTokens(s);
    }

    protected static String[] getTokens(String s, int iStart) {
        return Parser.getTokens(s, iStart);
    }

    protected float parseFloat() {
        return Parser.parseFloat(this.line, this.next);
    }

    public float parseFloat(String s) {
        this.next[0] = 0;
        return Parser.parseFloat(s, this.next);
    }

    protected float parseFloat(String s, int iStart, int iEnd) {
        this.next[0] = iStart;
        return Parser.parseFloat(s, iEnd, this.next);
    }

    protected int parseInt() {
        return Parser.parseInt(this.line, this.next);
    }

    public int parseInt(String s) {
        this.next[0] = 0;
        return Parser.parseInt(s, this.next);
    }

    protected int parseInt(String s, int iStart) {
        this.next[0] = iStart;
        return Parser.parseInt(s, this.next);
    }

    protected int parseInt(String s, int iStart, int iEnd) {
        this.next[0] = iStart;
        return Parser.parseInt(s, iEnd, this.next);
    }

    protected String parseToken() {
        return Parser.parseToken(this.line, this.next);
    }

    protected String parseToken(String s) {
        this.next[0] = 0;
        return Parser.parseToken(s, this.next);
    }

    protected String parseTokenNext(String s) {
        return Parser.parseToken(s, this.next);
    }

    protected String parseToken(String s, int iStart, int iEnd) {
        this.next[0] = iStart;
        return Parser.parseToken(s, iEnd, this.next);
    }

    protected static String parseTrimmed(String s, int iStart) {
        return Parser.parseTrimmed(s, iStart);
    }

    protected static String parseTrimmed(String s, int iStart, int iEnd) {
        return Parser.parseTrimmed(s, iStart, iEnd);
    }
}

