/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;

class LimitedLineReader {
    private char[] buf;
    private int cchBuf;
    private int ichCurrent;

    LimitedLineReader(BufferedReader bufferedReader, int readLimit) throws Exception {
        bufferedReader.mark(readLimit);
        this.buf = new char[readLimit];
        this.cchBuf = Math.max(bufferedReader.read(this.buf), 0);
        this.ichCurrent = 0;
        bufferedReader.reset();
    }

    String getHeader(int n) {
        return n == 0 ? new String(this.buf) : new String(this.buf, 0, Math.min(this.cchBuf, n));
    }

    String readLineWithNewline() {
        while (this.ichCurrent < this.cchBuf) {
            int ichBeginningOfLine = this.ichCurrent;
            int ch = 0;
            while (this.ichCurrent < this.cchBuf && (ch = this.buf[this.ichCurrent++]) != 13 && ch != 10) {
            }
            if (ch == 13 && this.ichCurrent < this.cchBuf && this.buf[this.ichCurrent] == '\n') {
                ++this.ichCurrent;
            }
            int cchLine = this.ichCurrent - ichBeginningOfLine;
            if (this.buf[ichBeginningOfLine] == '#' && (this.buf.length < ichBeginningOfLine + 6 || this.buf[ichBeginningOfLine + 1] != ' ' || this.buf[ichBeginningOfLine + 2] != 'J' || this.buf[ichBeginningOfLine + 3] != 'm' || this.buf[ichBeginningOfLine + 4] != 'o' || this.buf[ichBeginningOfLine + 5] != 'l')) continue;
            StringBuffer sb = new StringBuffer(cchLine);
            sb.append(this.buf, ichBeginningOfLine, cchLine);
            return sb.toString();
        }
        return "";
    }
}

