/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.Resolver;
import org.jmol.adapter.smarter.Structure;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolFileReaderInterface;
import org.jmol.util.CompoundDocument;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;
import org.jmol.util.ZipUtil;

public class SmarterJmolAdapter
extends JmolAdapter {
    public static final String PATH_KEY = ".PATH";
    public static final String PATH_SEPARATOR = System.getProperty("path.separator");

    public SmarterJmolAdapter() {
        super("SmarterJmolAdapter");
    }

    public void finish(Object atomSetCollection) {
        ((AtomSetCollection)atomSetCollection).finish();
    }

    public String[] specialLoad(String name, String type) {
        return Resolver.specialLoad(name, type);
    }

    public Object getAtomSetCollectionFromReader(String name, String type, BufferedReader bufferedReader, Hashtable htParams) {
        return SmarterJmolAdapter.staticGetAtomSetCollectionFromReader(name, type, bufferedReader, htParams);
    }

    private static Object staticGetAtomSetCollectionFromReader(String name, String type, BufferedReader bufferedReader, Hashtable htParams) {
        try {
            Object atomSetCollectionOrErrorMessage = Resolver.getAtomCollectionAndCloseReader(name, type, bufferedReader, htParams, -1);
            if (atomSetCollectionOrErrorMessage instanceof String) {
                return atomSetCollectionOrErrorMessage;
            }
            AtomSetCollection atomSetCollection = (AtomSetCollection)atomSetCollectionOrErrorMessage;
            if (atomSetCollection.errorMessage != null) {
                return atomSetCollection.errorMessage;
            }
            return atomSetCollection;
        }
        catch (Throwable e) {
            try {
                bufferedReader.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            bufferedReader = null;
            Logger.error(null, e);
            return "" + e;
        }
    }

    public Object getAtomSetCollectionFromReaders(JmolFileReaderInterface fileReader, String[] names, String[] types, Hashtable[] htparamsSet) {
        return SmarterJmolAdapter.staticGetAtomSetCollectionFromReaders(fileReader, names, types, htparamsSet);
    }

    private static Object staticGetAtomSetCollectionFromReaders(JmolFileReaderInterface fileReader, String[] names, String[] types, Hashtable[] htparamsSet) {
        int size = names.length;
        AtomSetCollection[] atomSetCollections = new AtomSetCollection[size];
        for (int i = 0; i < size; ++i) {
            try {
                BufferedReader reader = fileReader.getBufferedReader(i);
                if (reader == null) {
                    return null;
                }
                Object atomSetCollectionOrErrorMessage = Resolver.getAtomCollectionAndCloseReader(names[i], types == null ? null : types[i], reader, htparamsSet == null ? null : htparamsSet[i], i);
                if (atomSetCollectionOrErrorMessage instanceof String) {
                    return atomSetCollectionOrErrorMessage;
                }
                if (atomSetCollectionOrErrorMessage instanceof AtomSetCollection) {
                    atomSetCollections[i] = (AtomSetCollection)atomSetCollectionOrErrorMessage;
                    if (atomSetCollections[i].errorMessage == null) continue;
                    return atomSetCollections[i].errorMessage;
                }
                return "unknown reader error";
            }
            catch (Exception e) {
                Logger.error(null, e);
                return "" + e;
            }
            catch (Error er) {
                Logger.error(null, er);
                return "" + er;
            }
        }
        if (htparamsSet != null && htparamsSet[0].containsKey("trajectorySteps")) {
            atomSetCollections[0].finalizeTrajectory((Vector)htparamsSet[0].get("trajectorySteps"));
            return atomSetCollections[0];
        }
        AtomSetCollection result = new AtomSetCollection(atomSetCollections);
        if (result.errorMessage != null) {
            return result.errorMessage;
        }
        return result;
    }

    public Object getAtomSetCollectionOrBufferedReaderFromZip(InputStream is, String fileName, String[] zipDirectory, Hashtable htParams, boolean asBufferedReader) {
        return SmarterJmolAdapter.staticGetAtomSetCollectionOrBufferedReaderFromZip(is, fileName, zipDirectory, htParams, 1, asBufferedReader);
    }

    private static Object staticGetAtomSetCollectionOrBufferedReaderFromZip(InputStream is, String fileName, String[] zipDirectory, Hashtable htParams, int subFilePtr, boolean asBufferedReader) {
        boolean exceptFiles;
        boolean haveManifest;
        String manifest;
        String subFileName;
        String[] subFileList;
        boolean doCombine = subFilePtr == 1;
        int selectedFile = 0;
        if (htParams != null && htParams.containsKey("modelNumber") && (selectedFile = ((Integer)htParams.get("modelNumber")).intValue()) > 0 && doCombine) {
            htParams.remove("modelNumber");
        }
        String[] stringArray = subFileList = htParams == null ? null : (String[])htParams.get("subFileList");
        if (subFileList == null) {
            subFileList = Resolver.checkSpecialInZip(zipDirectory);
        }
        String string = subFileName = subFileList == null || subFilePtr >= subFileList.length ? null : subFileList[subFilePtr];
        if (subFileName != null && (subFileName.startsWith("/") || subFileName.startsWith("\\"))) {
            subFileName = subFileName.substring(1);
        }
        String string2 = manifest = htParams == null ? null : (String)htParams.get("manifest");
        if (manifest == null) {
            manifest = zipDirectory.length > 0 ? zipDirectory[0] : "";
        }
        boolean bl = haveManifest = manifest.length() > 0;
        if (haveManifest) {
            if (Logger.debugging) {
                Logger.info("manifest for  " + fileName + ":\n" + manifest);
            }
            manifest = '|' + manifest.replace('\r', '|').replace('\n', '|') + '|';
        }
        boolean ignoreErrors = manifest.indexOf("IGNORE_ERRORS") >= 0;
        boolean selectAll = manifest.indexOf("IGNORE_MANIFEST") >= 0;
        boolean bl2 = exceptFiles = manifest.indexOf("EXCEPT_FILES") >= 0;
        if (selectAll || subFileName != null) {
            haveManifest = false;
        }
        Vector<Object> vCollections = new Vector<Object>();
        Hashtable<String, Object> htCollections = haveManifest ? new Hashtable<String, Object>() : null;
        boolean nFiles = false;
        StringBuffer ret = Resolver.checkSpecialData(is, zipDirectory);
        if (ret instanceof String) {
            return (String)((Object)ret);
        }
        StringBuffer data = ret;
        try {
            ZipEntry ze;
            if (data != null) {
                BufferedReader reader = new BufferedReader(new StringReader(data.toString()));
                if (asBufferedReader) {
                    return reader;
                }
                Object atomSetCollectionOrError = Resolver.getAtomCollectionAndCloseReader(fileName, null, reader, htParams, -1);
                if (atomSetCollectionOrError instanceof String) {
                    return atomSetCollectionOrError;
                }
                if (atomSetCollectionOrError instanceof AtomSetCollection) {
                    AtomSetCollection atomSetCollection = (AtomSetCollection)atomSetCollectionOrError;
                    if (atomSetCollection.errorMessage != null) {
                        if (ignoreErrors) {
                            return null;
                        }
                        return atomSetCollection.errorMessage;
                    }
                    return atomSetCollection;
                }
                if (ignoreErrors) {
                    return null;
                }
                return "unknown reader error";
            }
            ZipInputStream zis = ZipUtil.getStream(is);
            while ((ze = zis.getNextEntry()) != null && (selectedFile <= 0 || vCollections.size() < selectedFile)) {
                if (ze.isDirectory()) continue;
                byte[] bytes = ZipUtil.getZipEntryAsBytes(zis);
                String thisEntry = ze.getName();
                if (subFileName != null && !thisEntry.equals(subFileName) || thisEntry.equals("JmolManifest") || haveManifest && exceptFiles == manifest.indexOf("|" + thisEntry + "|") >= 0) continue;
                if (ZipUtil.isZipFile(bytes)) {
                    BufferedInputStream bis = new BufferedInputStream(new ByteArrayInputStream(bytes));
                    String[] zipDir2 = ZipUtil.getZipDirectoryAndClose(bis, true);
                    bis = new BufferedInputStream(new ByteArrayInputStream(bytes));
                    Object atomSetCollections = SmarterJmolAdapter.staticGetAtomSetCollectionOrBufferedReaderFromZip(bis, fileName + "|" + thisEntry, zipDir2, htParams, ++subFilePtr, asBufferedReader);
                    if (atomSetCollections instanceof String) {
                        if (ignoreErrors) continue;
                        return atomSetCollections;
                    }
                    if (atomSetCollections instanceof AtomSetCollection || atomSetCollections instanceof Vector) {
                        if (haveManifest && !exceptFiles) {
                            htCollections.put(thisEntry, atomSetCollections);
                            continue;
                        }
                        vCollections.addElement(atomSetCollections);
                        continue;
                    }
                    if (atomSetCollections instanceof BufferedReader) {
                        if (doCombine) {
                            zis.close();
                        }
                        return atomSetCollections;
                    }
                    if (ignoreErrors) continue;
                    zis.close();
                    return "unknown zip reader error";
                }
                String sData = CompoundDocument.isCompoundDocument(bytes) ? new CompoundDocument(new BufferedInputStream(new ByteArrayInputStream(bytes))).getAllData("Molecule").toString() : new String(bytes);
                BufferedReader reader = new BufferedReader(new StringReader(sData));
                if (asBufferedReader) {
                    if (doCombine) {
                        zis.close();
                    }
                    return reader;
                }
                Object atomSetCollection = Resolver.getAtomCollectionAndCloseReader(fileName + "|" + ze.getName(), null, reader, htParams, -1);
                if (atomSetCollection instanceof AtomSetCollection) {
                    if (haveManifest && !exceptFiles) {
                        htCollections.put(thisEntry, atomSetCollection);
                    } else {
                        vCollections.addElement(atomSetCollection);
                    }
                    AtomSetCollection a = (AtomSetCollection)atomSetCollection;
                    if (a.errorMessage == null || ignoreErrors) continue;
                    zis.close();
                    return a.errorMessage;
                }
                if (ignoreErrors) continue;
                zis.close();
                return "" + atomSetCollection;
            }
            if (doCombine) {
                zis.close();
            }
            if (haveManifest && !exceptFiles) {
                String[] list = TextFormat.split(manifest, '|');
                for (int i = 0; i < list.length; ++i) {
                    String file = list[i];
                    if (file.length() == 0 || file.indexOf("#") == 0) continue;
                    if (htCollections.containsKey(file)) {
                        vCollections.add(htCollections.get(file));
                        continue;
                    }
                    if (!Logger.debugging) continue;
                    Logger.info("manifested file " + file + " was not found in " + fileName);
                }
            }
            if (!doCombine) {
                return vCollections;
            }
            AtomSetCollection result = new AtomSetCollection(vCollections);
            if (result.errorMessage != null) {
                if (ignoreErrors) {
                    return null;
                }
                return result.errorMessage;
            }
            if (nFiles) {
                selectedFile = 1;
            }
            if (selectedFile > 0 && selectedFile <= vCollections.size()) {
                return vCollections.elementAt(selectedFile - 1);
            }
            return result;
        }
        catch (Exception e) {
            if (ignoreErrors) {
                return null;
            }
            Logger.error(null, e);
            return "" + e;
        }
        catch (Error er) {
            Logger.error(null, er);
            return "" + er;
        }
    }

    public Object getAtomSetCollectionFromDOM(Object DOMNode) {
        return SmarterJmolAdapter.staticGetAtomSetCollectionFromDOM(DOMNode);
    }

    private static Object staticGetAtomSetCollectionFromDOM(Object DOMNode) {
        try {
            Object atomSetCollectionOrErrorMessage = Resolver.DOMResolve(DOMNode);
            if (atomSetCollectionOrErrorMessage instanceof String) {
                return atomSetCollectionOrErrorMessage;
            }
            if (atomSetCollectionOrErrorMessage instanceof AtomSetCollection) {
                AtomSetCollection atomSetCollection = (AtomSetCollection)atomSetCollectionOrErrorMessage;
                if (atomSetCollection.errorMessage != null) {
                    return atomSetCollection.errorMessage;
                }
                return atomSetCollection;
            }
            return "unknown DOM reader error";
        }
        catch (Exception e) {
            Logger.error(null, e);
            return "" + e;
        }
        catch (Error er) {
            Logger.error(null, er);
            return "" + er;
        }
    }

    public String getFileTypeName(Object atomSetCollectionOrReader) {
        return SmarterJmolAdapter.staticGetFileTypeName(atomSetCollectionOrReader);
    }

    private static String staticGetFileTypeName(Object atomSetCollectionOrReader) {
        if (atomSetCollectionOrReader == null) {
            return null;
        }
        if (atomSetCollectionOrReader instanceof BufferedReader) {
            return Resolver.getFileType((BufferedReader)atomSetCollectionOrReader);
        }
        if (atomSetCollectionOrReader instanceof AtomSetCollection) {
            return ((AtomSetCollection)atomSetCollectionOrReader).fileTypeName;
        }
        return null;
    }

    public String getAtomSetCollectionName(Object atomSetCollection) {
        return ((AtomSetCollection)atomSetCollection).collectionName;
    }

    public Properties getAtomSetCollectionProperties(Object atomSetCollection) {
        return ((AtomSetCollection)atomSetCollection).atomSetCollectionProperties;
    }

    public Hashtable getAtomSetCollectionAuxiliaryInfo(Object atomSetCollection) {
        return ((AtomSetCollection)atomSetCollection).atomSetCollectionAuxiliaryInfo;
    }

    public int getAtomSetCount(Object atomSetCollection) {
        return ((AtomSetCollection)atomSetCollection).atomSetCount;
    }

    public int getAtomSetNumber(Object atomSetCollection, int atomSetIndex) {
        return ((AtomSetCollection)atomSetCollection).getAtomSetNumber(atomSetIndex);
    }

    public String getAtomSetName(Object atomSetCollection, int atomSetIndex) {
        return ((AtomSetCollection)atomSetCollection).getAtomSetName(atomSetIndex);
    }

    public Properties getAtomSetProperties(Object atomSetCollection, int atomSetIndex) {
        return ((AtomSetCollection)atomSetCollection).getAtomSetProperties(atomSetIndex);
    }

    public Hashtable getAtomSetAuxiliaryInfo(Object atomSetCollection, int atomSetIndex) {
        return ((AtomSetCollection)atomSetCollection).getAtomSetAuxiliaryInfo(atomSetIndex);
    }

    public int getEstimatedAtomCount(Object atomSetCollection) {
        return ((AtomSetCollection)atomSetCollection).getAtomCount();
    }

    public boolean coordinatesAreFractional(Object atomSetCollection) {
        return ((AtomSetCollection)atomSetCollection).coordinatesAreFractional;
    }

    public float[] getNotionalUnitcell(Object atomSetCollection) {
        return ((AtomSetCollection)atomSetCollection).notionalUnitCell;
    }

    public float[] getPdbScaleMatrix(Object atomSetCollection) {
        float[] a = ((AtomSetCollection)atomSetCollection).notionalUnitCell;
        if (a.length < 22) {
            return null;
        }
        float[] b = new float[16];
        for (int i = 0; i < 16; ++i) {
            b[i] = a[6 + i];
        }
        return b;
    }

    public float[] getPdbScaleTranslate(Object atomSetCollection) {
        float[] a = ((AtomSetCollection)atomSetCollection).notionalUnitCell;
        if (a.length < 22) {
            return null;
        }
        float[] b = new float[]{a[9], a[13], a[17]};
        return b;
    }

    public String getClientAtomStringProperty(Object clientAtom, String propertyName) {
        return null;
    }

    public JmolAdapter.AtomIterator getAtomIterator(Object atomSetCollection) {
        return new AtomIterator((AtomSetCollection)atomSetCollection);
    }

    public JmolAdapter.BondIterator getBondIterator(Object atomSetCollection) {
        return new BondIterator((AtomSetCollection)atomSetCollection);
    }

    public JmolAdapter.StructureIterator getStructureIterator(Object atomSetCollection) {
        return ((AtomSetCollection)atomSetCollection).structureCount == 0 ? null : new StructureIterator((AtomSetCollection)atomSetCollection);
    }

    public class StructureIterator
    extends JmolAdapter.StructureIterator {
        int structureCount;
        Structure[] structures;
        Structure structure;
        int istructure;

        StructureIterator(AtomSetCollection atomSetCollection) {
            super(SmarterJmolAdapter.this);
            this.structureCount = atomSetCollection.structureCount;
            this.structures = atomSetCollection.structures;
            this.istructure = 0;
        }

        public boolean hasNext() {
            if (this.istructure == this.structureCount) {
                return false;
            }
            this.structure = this.structures[this.istructure++];
            return true;
        }

        public int getModelIndex() {
            return this.structure.modelIndex;
        }

        public String getStructureType() {
            return this.structure.structureType;
        }

        public char getStartChainID() {
            return JmolAdapter.canonizeChainID(this.structure.startChainID);
        }

        public int getStartSequenceNumber() {
            return this.structure.startSequenceNumber;
        }

        public char getStartInsertionCode() {
            return JmolAdapter.canonizeInsertionCode(this.structure.startInsertionCode);
        }

        public char getEndChainID() {
            return JmolAdapter.canonizeChainID(this.structure.endChainID);
        }

        public int getEndSequenceNumber() {
            return this.structure.endSequenceNumber;
        }

        public char getEndInsertionCode() {
            return this.structure.endInsertionCode;
        }
    }

    class BondIterator
    extends JmolAdapter.BondIterator {
        AtomSetCollection atomSetCollection;
        Bond[] bonds;
        int ibond;
        Bond bond;
        int bondCount;

        BondIterator(AtomSetCollection atomSetCollection) {
            super(SmarterJmolAdapter.this);
            this.atomSetCollection = atomSetCollection;
            this.bonds = atomSetCollection.bonds;
            this.bondCount = atomSetCollection.bondCount;
            this.ibond = 0;
        }

        public boolean hasNext() {
            if (this.ibond == this.bondCount) {
                return false;
            }
            this.bond = this.bonds[this.ibond++];
            return true;
        }

        public Object getAtomUniqueID1() {
            return new Integer(this.bond.atomIndex1);
        }

        public Object getAtomUniqueID2() {
            return new Integer(this.bond.atomIndex2);
        }

        public int getEncodedOrder() {
            return this.bond.order;
        }
    }

    class AtomIterator
    extends JmolAdapter.AtomIterator {
        AtomSetCollection atomSetCollection;
        int iatom;
        Atom atom;
        int atomCount;
        Atom[] atoms;

        AtomIterator(AtomSetCollection atomSetCollection) {
            super(SmarterJmolAdapter.this);
            this.atomSetCollection = atomSetCollection;
            this.atomCount = atomSetCollection.atomCount;
            this.atoms = atomSetCollection.atoms;
            this.iatom = 0;
        }

        public boolean hasNext() {
            if (this.iatom == this.atomCount) {
                return false;
            }
            this.atom = this.atoms[this.iatom++];
            return true;
        }

        public int getAtomSetIndex() {
            return this.atom.atomSetIndex;
        }

        public BitSet getAtomSymmetry() {
            return this.atom.bsSymmetry;
        }

        public int getAtomSite() {
            return this.atom.atomSite + 1;
        }

        public Object getUniqueID() {
            return new Integer(this.atom.atomIndex);
        }

        public String getElementSymbol() {
            if (this.atom.elementSymbol != null) {
                return this.atom.elementSymbol;
            }
            return this.atom.getElementSymbol();
        }

        public int getElementNumber() {
            return this.atom.elementNumber;
        }

        public String getAtomName() {
            return this.atom.atomName;
        }

        public int getFormalCharge() {
            return this.atom.formalCharge;
        }

        public float getPartialCharge() {
            return this.atom.partialCharge;
        }

        public Object[] getEllipsoid() {
            return this.atom.ellipsoid;
        }

        public float getRadius() {
            return this.atom.radius;
        }

        public float getX() {
            return this.atom.x;
        }

        public float getY() {
            return this.atom.y;
        }

        public float getZ() {
            return this.atom.z;
        }

        public float getVectorX() {
            return this.atom.vectorX;
        }

        public float getVectorY() {
            return this.atom.vectorY;
        }

        public float getVectorZ() {
            return this.atom.vectorZ;
        }

        public float getBfactor() {
            return Float.isNaN(this.atom.bfactor) && this.atom.anisoBorU != null ? this.atom.anisoBorU[7] * 100.0f : this.atom.bfactor;
        }

        public int getOccupancy() {
            return this.atom.occupancy;
        }

        public boolean getIsHetero() {
            return this.atom.isHetero;
        }

        public int getAtomSerial() {
            return this.atom.atomSerial;
        }

        public char getChainID() {
            return JmolAdapter.canonizeChainID(this.atom.chainID);
        }

        public char getAlternateLocationID() {
            return JmolAdapter.canonizeAlternateLocationID(this.atom.alternateLocationID);
        }

        public String getGroup3() {
            return this.atom.group3;
        }

        public int getSequenceNumber() {
            return this.atom.sequenceNumber;
        }

        public char getInsertionCode() {
            return JmolAdapter.canonizeInsertionCode(this.atom.insertionCode);
        }
    }
}

