/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.console;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Keymap;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.jmol.api.JmolAppletConsoleInterface;
import org.jmol.api.JmolViewer;
import org.jmol.applet.Jvm12;
import org.jmol.console.JmolConsole;
import org.jmol.i18n.GT;
import org.jmol.util.Logger;

public class AppletConsole
extends JmolConsole
implements JmolAppletConsoleInterface {
    private final JTextArea input = new ControlEnterTextArea();
    private final JTextPane output = new JTextPane();
    private final Document outputDocument = this.output.getDocument();
    private JFrame jf;
    private Jvm12 jvm12;
    private final SimpleAttributeSet attributesCommand = new SimpleAttributeSet();
    private JMenuBar menubar;
    private JButton clearOutButton;
    private JButton clearInButton;
    private JButton loadButton;
    protected Hashtable map = new Hashtable();
    protected Hashtable labels = null;

    public Object getMyMenuBar() {
        return this.menubar;
    }

    public void dispose() {
        this.jf.dispose();
        super.dispose();
    }

    public void set(JmolViewer viewer, Jvm12 jvm12) {
        this.viewer = viewer;
        this.jvm12 = jvm12;
        boolean doTranslate = GT.getDoTranslate();
        GT.setDoTranslate(true);
        this.jf = new JFrame(GT._("Jmol Script Console"));
        this.jf.setSize(600, 400);
        this.editButton = new JButton(GT._("Editor"));
        this.stateButton = new JButton(GT._("State"));
        this.runButton = new JButton(GT._("Run"));
        this.clearOutButton = new JButton(GT._("Clear Output"));
        this.clearInButton = new JButton(GT._("Clear Input"));
        this.historyButton = new JButton(GT._("History"));
        this.loadButton = new JButton(GT._("Load"));
        this.setupInput();
        this.setupOutput();
        JScrollPane jscrollInput = new JScrollPane(this.input);
        jscrollInput.setMinimumSize(new Dimension(2, 100));
        JScrollPane jscrollOutput = new JScrollPane(this.output);
        jscrollOutput.setMinimumSize(new Dimension(2, 100));
        Container c = this.jf.getContentPane();
        this.menubar = this.createMenubar();
        this.jf.setJMenuBar(this.menubar);
        c.setLayout(new BoxLayout(c, 1));
        JSplitPane jsp = new JSplitPane(0, jscrollOutput, jscrollInput);
        jsp.setResizeWeight(0.9);
        jsp.setDividerLocation(200);
        jsp.setAlignmentX(0.5f);
        c.add(jsp);
        Container c2 = new Container();
        c2.setLayout(new BoxLayout(c2, 0));
        c2.add(Box.createGlue());
        c2.add(this.editButton);
        c2.add(this.runButton);
        c2.add(this.loadButton);
        c2.add(this.clearInButton);
        c2.add(this.clearOutButton);
        c2.add(this.historyButton);
        c2.add(this.stateButton);
        c2.add(Box.createGlue());
        c.add(c2);
        JLabel label1 = new JLabel(GT._("press CTRL-ENTER for new line or paste model data and press Load"), 0);
        label1.setAlignmentX(0.5f);
        c.add(label1);
        this.editButton.addActionListener(this);
        this.runButton.addActionListener(this);
        this.clearInButton.addActionListener(this);
        this.clearOutButton.addActionListener(this);
        this.historyButton.addActionListener(this);
        this.stateButton.addActionListener(this);
        this.loadButton.addActionListener(this);
        this.jf.addWindowListener(this);
        GT.setDoTranslate(doTranslate);
    }

    protected JMenuBar createMenubar() {
        JMenuBar mb = new JMenuBar();
        mb.add(Box.createHorizontalGlue());
        this.addHelpMenuBar(mb);
        return mb;
    }

    protected void addHelpMenuBar(JMenuBar menuBar) {
        JMenu m0 = this.newJMenu("help");
        JMenuItem item = this.newJMenuItem("search");
        item.addActionListener(this);
        item.setName("help ?search=?");
        m0.add(item);
        if (m0 == null) {
            return;
        }
        this.addHelpItems(m0, "commands", "command");
        this.addHelpItems(m0, "functions", "mathfunc");
        this.addHelpItems(m0, "parameters", "setparam");
        this.addHelpItems(m0, "more", "misc");
        menuBar.add(m0);
    }

    private void addHelpItems(JMenu m0, String key, String attr) {
        JMenu m = this.newJMenu(key);
        String[] commands = (String[])this.viewer.getProperty(null, "tokenList", attr);
        m0.add(m);
        JMenu m2 = null;
        String firstCommand = null;
        int n = 20;
        for (int i = 0; i < commands.length; ++i) {
            String cmd = commands[i];
            if (!Character.isLetter(cmd.charAt(0))) continue;
            JMenuItem item = new JMenuItem(cmd);
            item.addActionListener(this);
            item.setName("help " + cmd);
            if (m2 == null) {
                m2 = new JMenu();
                firstCommand = cmd;
                m2.add(item);
                m2.setText(firstCommand);
                continue;
            }
            if (i % n + 1 == n) {
                m2.add(item);
                m2.setText(firstCommand + " - " + cmd);
                m.add(m2);
                m2 = null;
                continue;
            }
            m2.add(item);
            if (i + 1 != commands.length || m2 == null) continue;
            m2.setText(firstCommand + " - " + cmd);
            m.add(m2);
        }
    }

    protected JMenuItem createMenuItem(String cmd) {
        return this.newJMenuItem(cmd);
    }

    private void setupInput() {
        this.input.setLineWrap(true);
        this.input.setWrapStyleWord(true);
        this.input.setDragEnabled(true);
        Keymap map = this.input.getKeymap();
        KeyStroke shiftA = KeyStroke.getKeyStroke(65, 1);
        map.removeKeyStrokeBinding(shiftA);
    }

    private void setupOutput() {
        this.output.setEditable(false);
        this.output.setDragEnabled(true);
        StyleConstants.setBold(this.attributesCommand, true);
    }

    public void setVisible(boolean visible) {
        if (Logger.debugging) {
            Logger.debug("Console.setVisible(" + visible + ")");
        }
        this.jf.setVisible(visible);
        this.input.requestFocus();
    }

    public void output(String message) {
        this.output(message, null);
    }

    private void output(String message, AttributeSet att) {
        if (message == null || message.length() == 0) {
            this.output.setText("");
            return;
        }
        if (message.charAt(message.length() - 1) != '\n') {
            message = message + "\n";
        }
        try {
            this.outputDocument.insertString(this.outputDocument.getLength(), message, att);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.output.setCaretPosition(this.outputDocument.getLength());
    }

    public String getText() {
        return this.output.getText();
    }

    protected void clearContent(String text) {
        this.output.setText(text);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.clearInButton) {
            this.input.setText("");
            return;
        }
        if (source == this.clearOutButton) {
            this.output.setText("");
            return;
        }
        if (source == this.loadButton) {
            this.viewer.loadInline(this.input.getText(), false);
            return;
        }
        if (source instanceof JMenuItem) {
            this.execute(((JMenuItem)source).getName());
            return;
        }
        super.actionPerformed(e);
    }

    protected void execute(String strCommand) {
        String strErrorMessage;
        String cmd;
        String string = cmd = strCommand == null ? this.input.getText() : strCommand;
        if (strCommand == null) {
            this.input.setText(null);
        }
        if ((strErrorMessage = this.viewer.script(cmd + "\u0000## EDITOR_IGNORE ##")) != null && !strErrorMessage.equals("pending")) {
            this.output(strErrorMessage);
        }
        if (strCommand == null) {
            this.input.requestFocus();
        }
    }

    public void windowClosed(WindowEvent we) {
        this.jvm12.console = null;
    }

    public void windowClosing(WindowEvent we) {
        this.jvm12.console = null;
    }

    private Hashtable setupLabels() {
        Hashtable<String, String> labels = new Hashtable<String, String>();
        labels.put("help", GT._("&Help"));
        labels.put("search", GT._("&Search..."));
        labels.put("commands", GT._("&Commands"));
        labels.put("functions", GT._("Math &Functions"));
        labels.put("parameters", GT._("Set &Parameters"));
        labels.put("more", GT._("&More"));
        return labels;
    }

    private String getLabel(String key) {
        if (this.labels == null) {
            this.labels = this.setupLabels();
        }
        return (String)this.labels.get(key);
    }

    private JMenu newJMenu(String key) {
        String label = this.getLabel(key);
        return new KeyJMenu(key, AppletConsole.getLabelWithoutMnemonic(label), AppletConsole.getMnemonic(label));
    }

    private JMenuItem newJMenuItem(String key) {
        String label = this.getLabel(key);
        return new KeyJMenuItem(key, AppletConsole.getLabelWithoutMnemonic(label), AppletConsole.getMnemonic(label));
    }

    private static String getLabelWithoutMnemonic(String label) {
        if (label == null) {
            return null;
        }
        int index = label.indexOf(38);
        if (index == -1) {
            return label;
        }
        return label.substring(0, index) + (index < label.length() - 1 ? label.substring(index + 1) : "");
    }

    private static char getMnemonic(String label) {
        if (label == null) {
            return ' ';
        }
        int index = label.indexOf(38);
        if (index == -1 || index == label.length() - 1) {
            return ' ';
        }
        return label.charAt(index + 1);
    }

    private class KeyJMenuItem
    extends JMenuItem
    implements GetKey {
        String key;

        KeyJMenuItem(String key, String label, char mnemonic) {
            super(label);
            if (mnemonic != ' ') {
                this.setMnemonic(mnemonic);
            }
            this.key = key;
            AppletConsole.this.map.put(key, this);
        }

        public String getKey() {
            return this.key;
        }
    }

    private class KeyJMenu
    extends JMenu
    implements GetKey {
        String key;

        KeyJMenu(String key, String label, char mnemonic) {
            super(label);
            if (mnemonic != ' ') {
                this.setMnemonic(mnemonic);
            }
            this.key = key;
            AppletConsole.this.map.put(key, this);
        }

        public String getKey() {
            return this.key;
        }
    }

    private static interface GetKey {
        public String getKey();
    }

    class ControlEnterTextArea
    extends JTextArea {
        ControlEnterTextArea() {
        }

        public void processComponentKeyEvent(KeyEvent ke) {
            switch (ke.getID()) {
                case 401: {
                    if (ke.getKeyCode() == 10 && !ke.isControlDown()) {
                        AppletConsole.this.execute(null);
                        return;
                    }
                    if (ke.getKeyCode() == 38) {
                        this.recallCommand(true);
                        return;
                    }
                    if (ke.getKeyCode() != 40) break;
                    this.recallCommand(false);
                    return;
                }
                case 402: {
                    if (ke.getKeyCode() != 10 || ke.isControlDown()) break;
                    return;
                }
            }
            if (ke.getKeyCode() == 10) {
                ke.setModifiers(0);
            }
            super.processComponentKeyEvent(ke);
        }

        private void recallCommand(boolean up) {
            String cmd = AppletConsole.this.viewer.getSetHistory(up ? -1 : 1);
            if (cmd == null) {
                return;
            }
            this.setText(cmd);
        }
    }
}

