/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export.image;

import java.awt.Image;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.jmol.api.JmolImageCreatorInterface;
import org.jmol.api.JmolViewer;
import org.jmol.export.image.GifEncoder;
import org.jmol.export.image.ImageSelection;
import org.jmol.export.image.PngEncoder;
import org.jmol.export.image.PpmEncoder;
import org.jmol.util.Base64;
import org.jmol.util.JpegEncoder;
import org.jmol.util.Logger;

public class ImageCreator
implements JmolImageCreatorInterface {
    JmolViewer viewer;

    public ImageCreator() {
    }

    public ImageCreator(JmolViewer viewer) {
        this.viewer = viewer;
    }

    public void setViewer(JmolViewer viewer) {
        this.viewer = viewer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String clipImage(String text) {
        String msg;
        try {
            if (text == null) {
                Image image = this.viewer.getScreenImage();
                ImageSelection.setClipboard(image);
                msg = "OK " + image.getWidth(null) * image.getHeight(null);
            } else {
                ImageSelection.setClipboard(text);
                msg = "OK " + text.length();
            }
        }
        catch (Error er) {
            msg = this.viewer.getErrorMessage();
        }
        finally {
            if (text == null) {
                this.viewer.releaseScreenImage();
            }
        }
        return msg;
    }

    public String getClipboardText() {
        return ImageSelection.getClipboardText();
    }

    public static String getClipboardTextStatic() {
        return ImageSelection.getClipboardText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object createImage(String fileName, String type, Object text_or_bytes, int quality) {
        String string;
        long len;
        block28: {
            boolean isText;
            boolean isBytes = text_or_bytes instanceof byte[];
            String text = isBytes ? null : (String)text_or_bytes;
            boolean bl = isText = quality == Integer.MIN_VALUE;
            if ((isText || isBytes) && text_or_bytes == null) {
                return "NO DATA";
            }
            FileOutputStream os = null;
            len = -1L;
            try {
                if (isBytes) {
                    len = ((byte[])text_or_bytes).length;
                    os = new FileOutputStream(fileName);
                    os.write((byte[])text_or_bytes);
                    os.flush();
                    os.close();
                    break block28;
                }
                if (isText) {
                    os = new FileOutputStream(fileName);
                    OutputStreamWriter osw = new OutputStreamWriter(os);
                    BufferedWriter bw = new BufferedWriter(osw, 8192);
                    len = text.length();
                    bw.write(text);
                    bw.close();
                    os = null;
                } else {
                    len = 1L;
                    Object bytesOrError = this.getImageBytes(type, quality, fileName, null);
                    if (bytesOrError instanceof String) {
                        String bw = (String)bytesOrError;
                        return bw;
                    }
                    byte[] bytes = (byte[])bytesOrError;
                    if (bytes != null) {
                        String e = new String(bytes);
                        return e;
                    }
                    len = new File(fileName).length();
                }
            }
            catch (IOException exc) {
                if (exc != null) {
                    Logger.error("IO Exception", exc);
                    String string2 = exc.toString();
                    return string2;
                }
            }
            finally {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        if (len < 0L) {
            string = "Creation of " + fileName + " failed: " + this.viewer.getErrorMessageUntranslated();
            return string;
        }
        string = "OK " + type + " " + len + " " + fileName + (quality == Integer.MIN_VALUE ? "" : "; quality=" + quality);
        return string;
    }

    public Object getImageBytes(String type, int quality, String fileName, OutputStream os) throws IOException {
        byte[] bytes = null;
        String errMsg = null;
        boolean isOsTemp = os == null && fileName != null;
        boolean asBytes = os == null && fileName == null;
        Image image = this.viewer.getScreenImage();
        try {
            if (image == null) {
                errMsg = this.viewer.getErrorMessage();
            } else {
                if (isOsTemp) {
                    os = new FileOutputStream(fileName);
                }
                if (type.equalsIgnoreCase("JPEG") || type.equalsIgnoreCase("JPG")) {
                    if (quality <= 0) {
                        quality = 75;
                    }
                    if (asBytes) {
                        bytes = JpegEncoder.getBytes(image, quality);
                    } else {
                        JpegEncoder.write(image, quality, os);
                        bytes = null;
                    }
                } else if (type.equalsIgnoreCase("JPG64") || type.equalsIgnoreCase("JPEG64")) {
                    if (quality <= 0) {
                        quality = 75;
                    }
                    bytes = JpegEncoder.getBytes(image, quality);
                    if (asBytes) {
                        bytes = Base64.getBytes64(bytes);
                    } else {
                        Base64.write(bytes, os);
                        bytes = null;
                    }
                } else if (type.equalsIgnoreCase("PNG")) {
                    if (quality < 0) {
                        quality = 2;
                    } else if (quality > 9) {
                        quality = 9;
                    }
                    if (asBytes) {
                        bytes = PngEncoder.getBytes(image, quality);
                    } else {
                        PngEncoder.write(image, quality, os);
                        bytes = null;
                    }
                } else if (type.equalsIgnoreCase("PPM")) {
                    if (asBytes) {
                        bytes = PpmEncoder.getBytes(image);
                    } else {
                        PpmEncoder.write(image, os);
                        bytes = null;
                    }
                } else if (type.equalsIgnoreCase("GIF")) {
                    if (asBytes) {
                        bytes = GifEncoder.getBytes(image);
                    } else {
                        GifEncoder.write(image, os);
                        bytes = null;
                    }
                }
                if (os != null) {
                    os.flush();
                }
                if (isOsTemp) {
                    os.close();
                }
            }
        }
        catch (IOException e) {
            this.viewer.releaseScreenImage();
            throw new IOException("" + e);
        }
        catch (Error er) {
            this.viewer.releaseScreenImage();
            throw new Error(er);
        }
        this.viewer.releaseScreenImage();
        if (errMsg != null) {
            return errMsg;
        }
        return bytes;
    }
}

