/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export.image;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.jmol.util.Logger;

public class ImageSelection
implements Transferable {
    private Image image;
    private String text;

    public static void setClipboard(Image image) {
        ImageSelection sel = new ImageSelection(image);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(sel, null);
    }

    public static void setClipboard(String text) {
        ImageSelection sel = new ImageSelection(text);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(sel, null);
    }

    public ImageSelection(Image image) {
        this.image = image;
    }

    public ImageSelection(String text) {
        this.text = text;
    }

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] dataFlavorArray;
        if (this.text == null) {
            DataFlavor[] dataFlavorArray2 = new DataFlavor[1];
            dataFlavorArray = dataFlavorArray2;
            dataFlavorArray2[0] = DataFlavor.imageFlavor;
        } else {
            DataFlavor[] dataFlavorArray3 = new DataFlavor[1];
            dataFlavorArray = dataFlavorArray3;
            dataFlavorArray3[0] = DataFlavor.stringFlavor;
        }
        return dataFlavorArray;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return DataFlavor.imageFlavor.equals(flavor);
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (DataFlavor.imageFlavor.equals(flavor)) {
            return this.image;
        }
        if (DataFlavor.stringFlavor.equals(flavor)) {
            return this.text;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public static String getClipboardText() {
        boolean hasTransferableText;
        String result = null;
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable contents = clipboard.getContents(null);
        boolean bl = hasTransferableText = contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor);
        if (hasTransferableText) {
            try {
                result = (String)contents.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException ex) {
                Logger.error("Clipboard problem", ex);
                ex.printStackTrace();
            }
            catch (IOException ex) {
                Logger.error("Clipboard problem", ex);
                ex.printStackTrace();
            }
        }
        return result;
    }
}

