/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import org.jmol.g3d.Graphics3D;
import org.jmol.g3d.Shade3D;
import org.jmol.util.Int2IntHash;

class Colix3D {
    private static int colixMax = 4;
    private static int[] argbs = new int[128];
    private static int[] argbsGreyscale;
    private static int[][] ashades;
    private static int[][] ashadesGreyscale;
    private static final Int2IntHash colixHash;
    static final int[] predefinedArgbs;

    Colix3D() {
    }

    static short getColix(int argb) {
        int c;
        if (argb == 0) {
            return 0;
        }
        int translucentFlag = 0;
        if ((argb & 0xFF000000) != -16777216) {
            argb |= 0xFF000000;
            translucentFlag = 8192;
        }
        return (c = colixHash.get(argb)) > 0 ? (short)(c | translucentFlag) : (short)(Colix3D.allocateColix(argb) | translucentFlag);
    }

    private static synchronized int allocateColix(int argb) {
        if ((argb & 0xFF000000) != -16777216) {
            throw new IndexOutOfBoundsException();
        }
        int i = colixMax;
        while (--i >= 4) {
            if (argb != argbs[i]) continue;
            return (short)i;
        }
        if (colixMax == argbs.length) {
            int oldSize = colixMax;
            int newSize = oldSize * 2;
            int[] t0 = new int[newSize];
            System.arraycopy(argbs, 0, t0, 0, oldSize);
            argbs = t0;
            if (argbsGreyscale != null) {
                t0 = new int[newSize];
                System.arraycopy(argbsGreyscale, 0, t0, 0, oldSize);
                argbsGreyscale = t0;
            }
            int[][] t2 = new int[newSize][];
            System.arraycopy(ashades, 0, t2, 0, oldSize);
            ashades = t2;
            if (ashadesGreyscale != null) {
                t2 = new int[newSize][];
                System.arraycopy(ashadesGreyscale, 0, t2, 0, oldSize);
                ashadesGreyscale = t2;
            }
        }
        Colix3D.argbs[Colix3D.colixMax] = argb;
        if (argbsGreyscale != null) {
            Colix3D.argbsGreyscale[Colix3D.colixMax] = Graphics3D.calcGreyscaleRgbFromRgb(argb);
        }
        colixHash.put(argb, colixMax);
        return colixMax++;
    }

    private static synchronized void calcArgbsGreyscale() {
        if (argbsGreyscale != null) {
            return;
        }
        int[] a = new int[argbs.length];
        int i = argbs.length;
        while (--i >= 4) {
            a[i] = Graphics3D.calcGreyscaleRgbFromRgb(argbs[i]);
        }
        argbsGreyscale = a;
    }

    static final int getArgb(short colix) {
        return argbs[colix & 0xFFFF87FF];
    }

    static final int getArgbGreyscale(short colix) {
        if (argbsGreyscale == null) {
            Colix3D.calcArgbsGreyscale();
        }
        return argbsGreyscale[colix & 0xFFFF87FF];
    }

    static final int[] getShades(short colix) {
        int[] shades = ashades[colix = (short)(colix & 0xFFFF87FF)];
        if (shades == null) {
            Colix3D.ashades[colix] = Shade3D.getShades(argbs[colix], false);
            shades = Colix3D.ashades[colix];
        }
        return shades;
    }

    static final int[] getShadesGreyscale(short colix) {
        int[] shadesGreyscale;
        colix = (short)(colix & 0xFFFF87FF);
        if (ashadesGreyscale == null) {
            ashadesGreyscale = new int[ashades.length][];
        }
        if ((shadesGreyscale = ashadesGreyscale[colix]) == null) {
            Colix3D.ashadesGreyscale[colix] = Shade3D.getShades(argbs[colix], true);
            shadesGreyscale = Colix3D.ashadesGreyscale[colix];
        }
        return shadesGreyscale;
    }

    static final synchronized void flushShades() {
        int i = colixMax;
        while (--i >= 0) {
            Colix3D.ashades[i] = null;
        }
        Shade3D.sphereShadingCalculated = false;
    }

    static {
        ashades = new int[128][];
        colixHash = new Int2IntHash();
        predefinedArgbs = new int[]{-16777216, -23296, -16181, -16776961, -1, -16711681, -65536, -16744448, -8355712, -4144960, -16711936, -8388608, -16777088, -8355840, -8388480, -16744320, -65281, -256, -38476, -10496};
        for (int i = 0; i < predefinedArgbs.length; ++i) {
            Colix3D.getColix(predefinedArgbs[i]);
        }
    }
}

