/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

final class Rgb16 {
    int rScaled;
    int gScaled;
    int bScaled;

    Rgb16() {
    }

    Rgb16(int argb) {
        this.set(argb);
    }

    void set(int argb) {
        this.rScaled = argb >> 8 & 0xFF00 | 0x80;
        this.gScaled = argb & 0xFF00 | 0x80;
        this.bScaled = argb << 8 & 0xFF00 | 0x80;
    }

    void set(Rgb16 other) {
        this.rScaled = other.rScaled;
        this.gScaled = other.gScaled;
        this.bScaled = other.bScaled;
    }

    void diffDiv(Rgb16 rgb16A, Rgb16 rgb16B, int divisor) {
        this.rScaled = (rgb16A.rScaled - rgb16B.rScaled) / divisor;
        this.gScaled = (rgb16A.gScaled - rgb16B.gScaled) / divisor;
        this.bScaled = (rgb16A.bScaled - rgb16B.bScaled) / divisor;
    }

    void setAndIncrement(Rgb16 base, Rgb16 other) {
        this.rScaled = base.rScaled;
        base.rScaled += other.rScaled;
        this.gScaled = base.gScaled;
        base.gScaled += other.gScaled;
        this.bScaled = base.bScaled;
        base.bScaled += other.bScaled;
    }

    int getArgb() {
        return 0xFF000000 | this.rScaled << 8 & 0xFF0000 | this.gScaled & 0xFF00 | this.bScaled >> 8;
    }

    public String toString() {
        return "Rgb16(" + this.rScaled + ',' + this.gScaled + ',' + this.bScaled + " -> " + (this.rScaled >> 8 & 0xFF) + ',' + (this.gScaled >> 8 & 0xFF) + ',' + (this.bScaled >> 8 & 0xFF) + ')';
    }
}

