/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import org.jmol.g3d.Platform3D;

final class Swing3D
extends Platform3D {
    private static final DirectColorModel rgbColorModel = new DirectColorModel(24, 0xFF0000, 65280, 255, 0);
    private static final int[] sampleModelBitMasks = new int[]{0xFF0000, 65280, 255};
    private static final DirectColorModel rgbColorModelT = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
    private static final int[] sampleModelBitMasksT = new int[]{0xFF0000, 65280, 255, -16777216};
    private static boolean backgroundTransparent = false;

    Swing3D() {
    }

    Image allocateImage() {
        return new BufferedImage(rgbColorModel, Raster.createWritableRaster(new SinglePixelPackedSampleModel(3, this.windowWidth, this.windowHeight, sampleModelBitMasks), new DataBufferInt(this.pBuffer, this.windowSize), null), false, null);
    }

    void setBackgroundTransparent(boolean tf) {
        backgroundTransparent = tf;
    }

    Image allocateOffscreenImage(int width, int height) {
        return new BufferedImage(width, height, 1);
    }

    Graphics getGraphics(Image image) {
        return Swing3D.getStaticGraphics(image);
    }

    static Graphics getStaticGraphics(Image image) {
        Graphics2D g2d = ((BufferedImage)image).createGraphics();
        if (backgroundTransparent) {
            // empty if block
        }
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        return g2d;
    }
}

