/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.geodesic;

import java.util.BitSet;
import javax.vecmath.Point3f;
import org.jmol.atomdata.AtomData;
import org.jmol.atomdata.AtomDataServer;
import org.jmol.geodesic.Geodesic;
import org.jmol.modelset.AtomIndexIterator;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;

public final class EnvelopeCalculation {
    private short[] mads;
    private AtomData atomData = new AtomData();
    private AtomDataServer viewer;
    private int atomCount;
    public static final float SURFACE_DISTANCE_FOR_CALCULATION = 3.0f;
    public static final int MAX_LEVEL = 3;
    private float maxRadius = 0.0f;
    private float scale = 1.0f;
    private float setRadius = Float.MAX_VALUE;
    private float addRadius = Float.MAX_VALUE;
    private boolean modelZeroBased;
    private int[][] dotsConvexMaps;
    private int dotsConvexMax;
    private int geodesicCount;
    private int[] geodesicMap;
    private int[] mapT;
    private static final int[] mapNull = new int[0];
    private BitSet bsSurface;
    private boolean disregardNeighbors = false;
    private BitSet bsMySelected;
    private float radiusP;
    private float diameterP;
    private Point3f[] currentPoints;
    private int indexI;
    private Point3f centerI;
    private float radiusI;
    private float radiiIP2;
    private final Point3f pointT = new Point3f();
    private Point3f centerT;
    private final Point3f[] vertexTest = new Point3f[12];
    private static int[] power4 = new int[]{1, 4, 16, 64, 256};
    private int neighborCount;
    private int[] neighborIndices;
    private Point3f[] neighborCenters;
    private float[] neighborPlusProbeRadii2;
    private float[] neighborRadii2;

    public EnvelopeCalculation(AtomDataServer viewer, int atomCount, short[] mads) {
        for (int i = 0; i < 12; ++i) {
            this.vertexTest[i] = new Point3f();
        }
        this.neighborIndices = new int[16];
        this.neighborCenters = new Point3f[16];
        this.neighborPlusProbeRadii2 = new float[16];
        this.neighborRadii2 = new float[16];
        this.viewer = viewer;
        this.atomCount = atomCount;
        this.mads = mads;
        this.geodesicCount = Geodesic.getVertexVectorsCount();
        this.geodesicMap = EnvelopeCalculation.allocateBitmap(this.geodesicCount);
        this.mapT = EnvelopeCalculation.allocateBitmap(this.geodesicCount);
    }

    public int[][] getDotsConvexMaps() {
        return this.dotsConvexMaps;
    }

    public int getDotsConvexMax() {
        return this.dotsConvexMax;
    }

    public void allocDotsConvexMaps(int max) {
        if (this.dotsConvexMax >= max) {
            return;
        }
        this.dotsConvexMax = max;
        this.dotsConvexMaps = new int[max][];
    }

    public BitSet getBsSurfaceClone() {
        return this.bsSurface == null ? null : BitSetUtil.copy(this.bsSurface);
    }

    public void setMads(short[] mads) {
        this.mads = mads;
    }

    public void setFromBits(int index, BitSet bs) {
        EnvelopeCalculation.setAllBits(this.geodesicMap, this.geodesicCount);
        int iDot = this.geodesicCount;
        while (--iDot >= 0) {
            if (bs.get(iDot)) continue;
            EnvelopeCalculation.clearBit(this.geodesicMap, iDot);
        }
        if (this.dotsConvexMaps == null) {
            this.dotsConvexMaps = new int[this.atomCount][];
        }
        int[] map = mapNull;
        int count = this.getMapStorageCount(this.geodesicMap);
        if (count > 0) {
            map = new int[count];
            System.arraycopy(this.geodesicMap, 0, map, 0, count);
        }
        this.dotsConvexMaps[index] = map;
        this.dotsConvexMax = Math.max(this.dotsConvexMax, index);
    }

    public float getRadius() {
        return this.setRadius;
    }

    public void newSet() {
        this.dotsConvexMax = 0;
        this.dotsConvexMaps = null;
        this.diameterP = 0.0f;
        this.radiusP = 0.0f;
        this.mads = null;
    }

    public void calculate(float addRadius, float setRadius, float scale, float maxRadius, BitSet bsSelected, BitSet bsIgnore, boolean useVanderwaalsRadius, boolean disregardNeighbors, boolean onlySelectedDots, boolean isSurface, boolean multiModel) {
        this.addRadius = addRadius == Float.MAX_VALUE ? 0.0f : addRadius;
        this.setRadius = setRadius == Float.MAX_VALUE && !useVanderwaalsRadius ? 3.0f : setRadius;
        this.scale = scale;
        boolean bl = this.atomData.useIonic = !useVanderwaalsRadius;
        this.atomData.adpMode = setRadius == 32767.0f ? 1 : (setRadius == -32768.0f ? -1 : 0);
        this.atomData.modelIndex = multiModel ? -1 : 0;
        this.modelZeroBased = !multiModel;
        this.viewer.fillAtomData(this.atomData, 2);
        this.atomCount = this.atomData.atomCount;
        this.setRadii(useVanderwaalsRadius);
        this.bsMySelected = onlySelectedDots && bsSelected != null ? BitSetUtil.copy(bsSelected) : (bsIgnore != null ? BitSetUtil.setAll(this.atomCount) : null);
        BitSetUtil.andNot(this.bsMySelected, bsIgnore);
        this.disregardNeighbors = disregardNeighbors;
        this.bsSurface = new BitSet();
        this.maxRadius = maxRadius == Float.MAX_VALUE ? setRadius : maxRadius;
        int i = this.atomCount;
        while (--i >= 0) {
            if (bsSelected != null && !bsSelected.get(i) || bsIgnore != null && bsIgnore.get(i)) continue;
            this.setAtomI(i);
            this.getNeighbors();
            this.calcConvexMap(isSurface);
        }
        this.currentPoints = null;
        this.setDotsConvexMax();
    }

    private void setRadii(boolean useVanderwaalsRadius) {
        for (int i = 0; i < this.atomCount; ++i) {
            this.atomData.atomRadius[i] = this.mads != null ? (float)this.mads[i] / 1000.0f : this.addRadius + (this.setRadius != Float.MAX_VALUE && this.setRadius != 32767.0f && this.setRadius != -32768.0f ? this.setRadius : this.atomData.atomRadius[i] * this.scale);
        }
    }

    public Point3f[] getPoints() {
        if (this.dotsConvexMaps == null) {
            this.calculate(Float.MAX_VALUE, 3.0f, 1.0f, Float.MAX_VALUE, this.bsMySelected, null, false, false, false, false, false);
        }
        if (this.currentPoints != null) {
            return this.currentPoints;
        }
        int nPoints = 0;
        int dotCount = 42;
        int i = this.dotsConvexMax;
        while (--i >= 0) {
            nPoints += this.getPointCount(this.dotsConvexMaps[i], dotCount);
        }
        Point3f[] points = new Point3f[nPoints];
        if (nPoints == 0) {
            return points;
        }
        nPoints = 0;
        int i2 = this.dotsConvexMax;
        while (--i2 >= 0) {
            if (this.dotsConvexMaps[i2] == null) continue;
            int iDot = this.dotsConvexMaps[i2].length << 5;
            if (iDot > dotCount) {
                iDot = dotCount;
            }
            while (--iDot >= 0) {
                if (!EnvelopeCalculation.getBit(this.dotsConvexMaps[i2], iDot)) continue;
                Point3f pt = new Point3f();
                pt.scaleAdd(this.atomData.atomRadius[i2], Geodesic.getVertexVector(iDot), this.atomData.atomXyz[i2]);
                points[nPoints++] = pt;
            }
        }
        this.currentPoints = points;
        return points;
    }

    public static final boolean getBit(int[] bitmap, int i) {
        return bitmap[i >> 5] << (i & 0x1F) < 0;
    }

    private int getPointCount(int[] visibilityMap, int dotCount) {
        if (visibilityMap == null) {
            return 0;
        }
        int iDot = visibilityMap.length << 5;
        if (iDot > dotCount) {
            iDot = dotCount;
        }
        int n = 0;
        n = 0;
        while (--iDot >= 0) {
            if (!EnvelopeCalculation.getBit(visibilityMap, iDot)) continue;
            ++n;
        }
        return n;
    }

    private void setDotsConvexMax() {
        if (this.dotsConvexMaps == null) {
            this.dotsConvexMax = 0;
        } else {
            int i = this.atomCount;
            while (--i >= 0 && this.dotsConvexMaps[i] == null) {
            }
            this.dotsConvexMax = i + 1;
        }
    }

    public float getAppropriateRadius(int atomIndex) {
        return this.mads != null ? (float)this.mads[atomIndex] / 1000.0f : this.atomData.atomRadius[atomIndex];
    }

    private void setAtomI(int indexI) {
        this.indexI = indexI;
        this.centerI = this.atomData.atomXyz[indexI];
        this.radiusI = this.atomData.atomRadius[indexI];
        this.radiiIP2 = this.radiusI + this.radiusP;
        this.radiiIP2 *= this.radiiIP2;
    }

    private void calcConvexMap(boolean isSurface) {
        if (this.dotsConvexMaps == null) {
            this.dotsConvexMaps = new int[this.atomCount][];
        }
        this.calcConvexBits();
        int[] map = mapNull;
        int count = this.getMapStorageCount(this.geodesicMap);
        if (count > 0) {
            this.bsSurface.set(this.indexI);
            if (isSurface) {
                this.addIncompleteFaces(this.geodesicMap);
                this.addIncompleteFaces(this.geodesicMap);
            }
            count = this.getMapStorageCount(this.geodesicMap);
            map = new int[count];
            System.arraycopy(this.geodesicMap, 0, map, 0, count);
        }
        this.dotsConvexMaps[this.indexI] = map;
    }

    private int getMapStorageCount(int[] map) {
        int indexLast = map.length;
        while (--indexLast >= 0 && map[indexLast] == 0) {
        }
        return indexLast + 1;
    }

    private void addIncompleteFaces(int[] points) {
        EnvelopeCalculation.clearBitmap(this.mapT);
        short[] faces = Geodesic.getFaceVertexes(3);
        int len = faces.length;
        short maxPt = -1;
        int f = 0;
        while (f < len) {
            short p1 = faces[f++];
            short p2 = faces[f++];
            short p3 = faces[f++];
            boolean ok1 = EnvelopeCalculation.getBit(points, p1);
            boolean ok2 = EnvelopeCalculation.getBit(points, p2);
            boolean ok3 = EnvelopeCalculation.getBit(points, p3);
            if (!ok1 && !ok2 && !ok3 || ok1 && ok2 && ok3) continue;
            if (!ok1) {
                EnvelopeCalculation.setBit(this.mapT, p1);
                if (maxPt < p1) {
                    maxPt = p1;
                }
            }
            if (!ok2) {
                EnvelopeCalculation.setBit(this.mapT, p2);
                if (maxPt < p2) {
                    maxPt = p2;
                }
            }
            if (ok3) continue;
            EnvelopeCalculation.setBit(this.mapT, p3);
            if (maxPt >= p3) continue;
            maxPt = p3;
        }
        for (short i = 0; i <= maxPt; ++i) {
            if (!EnvelopeCalculation.getBit(this.mapT, i)) continue;
            EnvelopeCalculation.setBit(points, i);
        }
    }

    private void calcConvexBits() {
        EnvelopeCalculation.setAllBits(this.geodesicMap, this.geodesicCount);
        float combinedRadii = this.radiusI + this.radiusP;
        if (this.neighborCount == 0) {
            return;
        }
        short[] faces = Geodesic.getFaceVertexes(3);
        int p4 = power4[2];
        EnvelopeCalculation.clearBitmap(this.mapT);
        for (int i = 0; i < 12; ++i) {
            this.vertexTest[i].set(Geodesic.getVertexVector(i));
            this.vertexTest[i].scaleAdd(combinedRadii, this.centerI);
        }
        for (int f = 0; f < 20; ++f) {
            int faceTest = 0;
            short p1 = faces[3 * p4 * (4 * f + 0)];
            short p2 = faces[3 * p4 * (4 * f + 1)];
            short p3 = faces[3 * p4 * (4 * f + 2)];
            for (int j = 0; j < this.neighborCount; ++j) {
                boolean ok3;
                float maxDist = this.neighborPlusProbeRadii2[j];
                this.centerT = this.neighborCenters[j];
                boolean ok1 = this.vertexTest[p1].distanceSquared(this.centerT) >= maxDist;
                boolean ok2 = this.vertexTest[p2].distanceSquared(this.centerT) >= maxDist;
                boolean bl = ok3 = this.vertexTest[p3].distanceSquared(this.centerT) >= maxDist;
                if (!ok1) {
                    EnvelopeCalculation.clearBit(this.geodesicMap, p1);
                }
                if (!ok2) {
                    EnvelopeCalculation.clearBit(this.geodesicMap, p2);
                }
                if (!ok3) {
                    EnvelopeCalculation.clearBit(this.geodesicMap, p3);
                }
                if (ok1 || ok2 || ok3) continue;
                faceTest = -1;
                break;
            }
            int kFirst = f * 12 * p4;
            int kLast = kFirst + 12 * p4;
            for (int k = kFirst; k < kLast; ++k) {
                short vect = faces[k];
                if (EnvelopeCalculation.getBit(this.mapT, vect) || !EnvelopeCalculation.getBit(this.geodesicMap, vect)) continue;
                switch (faceTest) {
                    case -1: {
                        EnvelopeCalculation.clearBit(this.geodesicMap, vect);
                        break;
                    }
                    case 0: {
                        for (int j = 0; j < this.neighborCount; ++j) {
                            float maxDist = this.neighborPlusProbeRadii2[j];
                            this.centerT = this.neighborCenters[j];
                            this.pointT.set(Geodesic.getVertexVector(vect));
                            this.pointT.scaleAdd(combinedRadii, this.centerI);
                            if (!(this.pointT.distanceSquared(this.centerT) < maxDist)) continue;
                            EnvelopeCalculation.clearBit(this.geodesicMap, vect);
                        }
                        break;
                    }
                }
                EnvelopeCalculation.setBit(this.mapT, vect);
            }
        }
    }

    private void getNeighbors() {
        this.neighborCount = 0;
        if (this.disregardNeighbors) {
            return;
        }
        AtomIndexIterator iter = this.viewer.getWithinAtomSetIterator(this.indexI, this.radiusI + this.diameterP + this.maxRadius, this.bsMySelected, false, this.modelZeroBased);
        while (iter.hasNext()) {
            int indexN = iter.next();
            float neighborRadius = this.atomData.atomRadius[indexN];
            if (this.centerI.distance(this.atomData.atomXyz[indexN]) > this.radiusI + this.radiusP + this.radiusP + neighborRadius) continue;
            if (this.neighborCount == this.neighborIndices.length) {
                this.neighborIndices = ArrayUtil.doubleLength(this.neighborIndices);
                this.neighborCenters = (Point3f[])ArrayUtil.doubleLength(this.neighborCenters);
                this.neighborPlusProbeRadii2 = ArrayUtil.doubleLength(this.neighborPlusProbeRadii2);
                this.neighborRadii2 = ArrayUtil.doubleLength(this.neighborRadii2);
            }
            this.neighborCenters[this.neighborCount] = this.atomData.atomXyz[indexN];
            this.neighborIndices[this.neighborCount] = indexN;
            float neighborPlusProbeRadii = neighborRadius + this.radiusP;
            this.neighborPlusProbeRadii2[this.neighborCount] = neighborPlusProbeRadii * neighborPlusProbeRadii;
            this.neighborRadii2[this.neighborCount] = neighborRadius * neighborRadius;
            ++this.neighborCount;
        }
    }

    private static final int[] allocateBitmap(int count) {
        return new int[count + 31 >> 5];
    }

    private static final void setBit(int[] bitmap, int i) {
        int n = i >> 5;
        bitmap[n] = bitmap[n] | 1 << (~i & 0x1F);
    }

    private static final void clearBit(int[] bitmap, int i) {
        int n = i >> 5;
        bitmap[n] = bitmap[n] & ~(1 << (~i & 0x1F));
    }

    private static final void setAllBits(int[] bitmap, int count) {
        int i = count >> 5;
        if ((count & 0x1F) != 0) {
            bitmap[i] = Integer.MIN_VALUE >> count - 1;
        }
        while (--i >= 0) {
            bitmap[i] = -1;
        }
    }

    private static final void clearBitmap(int[] bitmap) {
        int i = bitmap.length;
        while (--i >= 0) {
            bitmap[i] = 0;
        }
    }

    public void deleteAtoms(int firstAtomDeleted, int nAtomsDeleted, BitSet bsAtoms) {
        this.dotsConvexMaps = (int[][])ArrayUtil.deleteElements(this.dotsConvexMaps, firstAtomDeleted, nAtomsDeleted);
        this.dotsConvexMax = this.dotsConvexMaps.length;
        if (this.mads != null) {
            this.mads = (short[])ArrayUtil.deleteElements(this.mads, firstAtomDeleted, nAtomsDeleted);
        }
        this.atomData.atomRadius = (float[])ArrayUtil.deleteElements(this.atomData.atomRadius, firstAtomDeleted, nAtomsDeleted);
        this.atomData.atomXyz = (Point3f[])ArrayUtil.deleteElements(this.atomData.atomXyz, firstAtomDeleted, nAtomsDeleted);
        this.atomData.atomCount -= nAtomsDeleted;
        this.atomCount = this.atomData.atomCount;
    }
}

