/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.calc;

import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Point4f;
import javax.vecmath.Vector3f;
import org.jmol.jvxl.api.VertexDataServer;
import org.jmol.jvxl.data.VolumeData;
import org.jmol.util.ArrayUtil;
import org.jmol.util.Logger;

public class MarchingSquares {
    public static final int CONTOUR_POINT = -1;
    public static final int VERTEX_POINT = -2;
    public static final int EDGE_POINT = -3;
    private boolean logMessages = false;
    private VertexDataServer surfaceReader;
    private VolumeData volumeData;
    private static final int nContourMax = 100;
    public static final int defaultContourCount = 9;
    private int nContourSegments;
    private int nContoursSpecified;
    private int contourType;
    private Point4f thePlane;
    private boolean is3DContour;
    private int thisContour = 0;
    private float valueMin;
    private float valueMax;
    private int nVertices;
    private final Vector3f pointVector = new Vector3f();
    private final Point3f pointA = new Point3f();
    private final Point3f pointB = new Point3f();
    private final Vector3f edgeVector = new Vector3f();
    private final Point3f planarOrigin = new Point3f();
    private final Vector3f[] planarVectors = new Vector3f[3];
    private final Vector3f[] unitPlanarVectors = new Vector3f[3];
    private final float[] planarVectorLengths = new float[2];
    private final Matrix3f matXyzToPlane = new Matrix3f();
    private boolean contourFromZero;
    private static final Point3i[] squareVertexOffsets = new Point3i[]{new Point3i(0, 0, 0), new Point3i(1, 0, 0), new Point3i(1, 1, 0), new Point3i(0, 1, 0)};
    private static final Vector3f[] squareVertexVectors = new Vector3f[]{new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f)};
    private static final byte[] edgeVertexes2d = new byte[]{0, 1, 1, 2, 2, 3, 3, 0};
    private static final byte[] insideMaskTable2d = new byte[]{0, 9, 3, 10, 6, 15, 5, 12, 12, 5, 15, 6, 10, 3, 9, 0};
    private int contourVertexCount;
    private ContourVertex[] contourVertexes;
    private final int[] pixelCounts;
    private final Matrix3f planarMatrix;
    private float[][] pixelData;
    private final float[] vertexValues2d;
    private final Point3f[] contourPoints;
    private int squareCountX;
    private int squareCountY;
    private PlanarSquare[] planarSquares;
    private int nSquares;
    private float contourPlaneMinimumValue;
    private float contourPlaneMaximumValue;
    private int contourIndex;
    private float[] squareFractions;
    private final Point3f pixelOrigin;
    private Vector3f[] pixelVertexVectors;
    private final int[] triangleVertexList;
    private final Point3i ptiTemp;

    public MarchingSquares(VertexDataServer surfaceReader, VolumeData volumeData, Point4f thePlane, int nContours, int thisContour, boolean contourFromZero) {
        this.planarVectors[0] = new Vector3f();
        this.planarVectors[1] = new Vector3f();
        this.planarVectors[2] = new Vector3f();
        this.unitPlanarVectors[0] = new Vector3f();
        this.unitPlanarVectors[1] = new Vector3f();
        this.unitPlanarVectors[2] = new Vector3f();
        this.contourFromZero = true;
        this.pixelCounts = new int[2];
        this.planarMatrix = new Matrix3f();
        this.vertexValues2d = new float[4];
        this.contourPoints = new Point3f[4];
        int i = 4;
        while (--i >= 0) {
            this.contourPoints[i] = new Point3f();
        }
        this.pixelOrigin = new Point3f();
        this.pixelVertexVectors = new Vector3f[4];
        this.triangleVertexList = new int[20];
        this.ptiTemp = new Point3i();
        this.surfaceReader = surfaceReader;
        this.volumeData = volumeData;
        this.thePlane = thePlane;
        this.thisContour = thisContour;
        this.is3DContour = thePlane == null;
        this.nContoursSpecified = nContours;
        this.contourFromZero = contourFromZero;
        i = contourFromZero ? 1 : (this.is3DContour ? 1 : 2);
        int n = this.nContourSegments = nContours == 0 ? 9 + i : nContours + i;
        if (this.nContourSegments > 100) {
            this.nContourSegments = 100;
        }
        this.setContourType();
    }

    public int getContourType() {
        return this.contourType;
    }

    public void setMinMax(float valueMin, float valueMax) {
        this.valueMin = valueMin;
        this.valueMax = valueMax;
    }

    private void setContourType() {
        if (this.is3DContour) {
            this.planarVectors[0].set(this.volumeData.volumetricVectors[0]);
            this.planarVectors[1].set(this.volumeData.volumetricVectors[1]);
            this.pixelCounts[0] = this.volumeData.voxelCounts[0];
            this.pixelCounts[1] = this.volumeData.voxelCounts[1];
            this.contourType = 2;
            return;
        }
        this.contourType = MarchingSquares.getContourType(this.thePlane, this.volumeData.volumetricVectors);
    }

    private static int getContourType(Point4f plane, Vector3f[] volumetricVectors) {
        Vector3f norm = new Vector3f(plane.x, plane.y, plane.z);
        float dotX = norm.dot(volumetricVectors[0]);
        float dotY = norm.dot(volumetricVectors[1]);
        float dotZ = norm.dot(volumetricVectors[2]);
        dotX *= dotX;
        dotY *= dotY;
        dotZ *= dotZ;
        float max = Math.max(dotX, dotY);
        int iType = max < dotZ ? 2 : (max == dotY ? 1 : 0);
        return iType;
    }

    public int generateContourData(boolean haveData) {
        Logger.info("generateContours: " + this.nContourSegments + " segments");
        if (!this.is3DContour) {
            this.getPlanarVectors();
        }
        this.setPlanarTransform();
        this.getPlanarOrigin();
        MarchingSquares.setupMatrix(this.planarMatrix, this.planarVectors);
        this.calcPixelVertexVectors();
        if (!this.is3DContour) {
            this.getPixelCounts();
        }
        this.createPlanarSquares();
        this.loadPixelData(haveData);
        this.nVertices = 0;
        if (this.logMessages) {
            int n = this.pixelCounts[0] / 2;
            Logger.info(ArrayUtil.dumpArray("generateContourData", this.pixelData, n - 4, n + 4, n - 4, n + 4));
        }
        boolean centerIsLow = this.createContours(this.valueMin, this.valueMax);
        this.triangulateContours(centerIsLow);
        Logger.info("generateContours: " + this.nVertices + " vertices");
        return this.contourVertexCount;
    }

    private void getPlanarVectors() {
        this.planarVectors[2].set(0.0f, 0.0f, 0.0f);
        Vector3f thePlaneNormal = new Vector3f(this.thePlane.x, this.thePlane.y, this.thePlane.z);
        Vector3f[] volumetricVectors = this.volumeData.volumetricVectors;
        Vector3f vZ = volumetricVectors[this.contourType];
        float vZdotNorm = vZ.dot(thePlaneNormal);
        switch (this.contourType) {
            case 0: {
                this.planarVectors[0].scaleAdd(-volumetricVectors[1].dot(thePlaneNormal) / vZdotNorm, vZ, volumetricVectors[1]);
                this.planarVectors[1].scaleAdd(-volumetricVectors[2].dot(thePlaneNormal) / vZdotNorm, vZ, volumetricVectors[2]);
                break;
            }
            case 1: {
                this.planarVectors[0].scaleAdd(-volumetricVectors[2].dot(thePlaneNormal) / vZdotNorm, vZ, volumetricVectors[2]);
                this.planarVectors[1].scaleAdd(-volumetricVectors[0].dot(thePlaneNormal) / vZdotNorm, vZ, volumetricVectors[0]);
                break;
            }
            case 2: {
                this.planarVectors[0].scaleAdd(-volumetricVectors[0].dot(thePlaneNormal) / vZdotNorm, vZ, volumetricVectors[0]);
                this.planarVectors[1].scaleAdd(-volumetricVectors[1].dot(thePlaneNormal) / vZdotNorm, vZ, volumetricVectors[1]);
            }
        }
    }

    private void setPlanarTransform() {
        int i;
        this.planarVectorLengths[0] = this.planarVectors[0].length();
        this.planarVectorLengths[1] = this.planarVectors[1].length();
        this.unitPlanarVectors[0].normalize(this.planarVectors[0]);
        this.unitPlanarVectors[1].normalize(this.planarVectors[1]);
        this.unitPlanarVectors[2].cross(this.unitPlanarVectors[0], this.unitPlanarVectors[1]);
        MarchingSquares.setupMatrix(this.matXyzToPlane, this.unitPlanarVectors);
        this.matXyzToPlane.invert();
        float alpha = this.planarVectors[0].angle(this.planarVectors[1]);
        Logger.info("planar axes type " + this.contourType + " axis angle = " + (double)alpha / Math.PI * 180.0 + " normal=" + this.unitPlanarVectors[2]);
        for (i = 0; i < 2; ++i) {
            Logger.info("planar vectors / lengths:" + this.planarVectors[i] + " / " + this.planarVectorLengths[i]);
        }
        for (i = 0; i < 3; ++i) {
            Logger.info("unit orthogonal plane vectors:" + this.unitPlanarVectors[i]);
        }
    }

    private void getPlanarOrigin() {
        if (this.contourVertexCount == 0) {
            this.planarOrigin.set(0.0f, 0.0f, 0.0f);
            return;
        }
        float minX = Float.MAX_VALUE;
        float minY = Float.MAX_VALUE;
        this.planarOrigin.set(this.contourVertexes[0].vertexXYZ);
        for (int i = 0; i < this.contourVertexCount; ++i) {
            this.pointVector.set(this.contourVertexes[i].vertexXYZ);
            this.xyzToPixelVector(this.pointVector);
            if (this.pointVector.x < minX) {
                minX = this.pointVector.x;
            }
            if (!(this.pointVector.y < minY)) continue;
            minY = this.pointVector.y;
        }
        this.planarOrigin.set(this.pixelPtToXYZ((int)(minX * 1.0001f), (int)(minY * 1.0001f)));
    }

    public int addContourVertex(int x, int y, int z, Point3i offsets, Point3f vertexXYZ, float value) {
        if (this.contourVertexes == null) {
            this.contourVertexes = new ContourVertex[256];
        }
        if (this.contourVertexCount == this.contourVertexes.length) {
            this.contourVertexes = (ContourVertex[])ArrayUtil.doubleLength(this.contourVertexes);
        }
        int vPt = this.surfaceReader.addVertexCopy(vertexXYZ, value, -2);
        this.contourVertexes[this.contourVertexCount++] = new ContourVertex(x += offsets.x, y += offsets.y, z += offsets.z, vertexXYZ, vPt);
        return vPt;
    }

    public int getContourVertexCount() {
        return this.contourVertexCount;
    }

    public void setContourData(int i, float value) {
        this.contourVertexes[i].setValue(value, this.volumeData);
    }

    private void loadPixelData(boolean haveData) {
        this.pixelData = new float[this.pixelCounts[0]][this.pixelCounts[1]];
        this.contourPlaneMinimumValue = Float.MAX_VALUE;
        this.contourPlaneMaximumValue = -3.4028235E38f;
        for (int i = 0; i < this.contourVertexCount; ++i) {
            int y;
            int x;
            float value;
            ContourVertex c = this.contourVertexes[i];
            Point3i pt = this.locatePixel(c.vertexXYZ);
            c.setPixelLocation(pt);
            if (haveData) {
                value = c.value;
            } else {
                value = this.volumeData.lookupInterpolatedVoxelValue(c.vertexXYZ);
                c.setValue(value, null);
            }
            if (value < this.contourPlaneMinimumValue) {
                this.contourPlaneMinimumValue = value;
            }
            if (value > this.contourPlaneMaximumValue) {
                this.contourPlaneMaximumValue = value;
            }
            if ((x = pt.x) >= 0 && x < this.pixelCounts[0] && (y = pt.y) >= 0 && y < this.pixelCounts[1]) {
                this.pixelData[x][y] = value;
                if (x != this.squareCountX && y != this.squareCountY) {
                    this.planarSquares[x * this.squareCountY + y].setVertex(0, c.vertexIndex);
                }
                if (x != 0 && y != this.squareCountY) {
                    this.planarSquares[(x - 1) * this.squareCountY + y].setVertex(1, c.vertexIndex);
                }
                if (y != 0 && x != this.squareCountX) {
                    this.planarSquares[x * this.squareCountY + y - 1].setVertex(3, c.vertexIndex);
                }
                if (y == 0 || x == 0) continue;
                this.planarSquares[(x - 1) * this.squareCountY + y - 1].setVertex(2, c.vertexIndex);
                continue;
            }
            Logger.error("loadPixelData out of bounds: " + pt.x + " " + pt.y + "?");
        }
    }

    public float getInterpolatedPixelValue(Point3f ptXYZ) {
        int xDown;
        this.pointVector.set(ptXYZ);
        this.xyzToPixelVector(this.pointVector);
        float x = this.pointVector.x;
        float y = this.pointVector.y;
        if (Float.isNaN(x)) {
            return Float.NaN;
        }
        int n = x >= (float)this.pixelCounts[0] ? this.pixelCounts[0] - 1 : (xDown = x < 0.0f ? 0 : (int)x);
        int yDown = y >= (float)this.pixelCounts[1] ? this.pixelCounts[1] - 1 : (y < 0.0f ? 0 : (int)y);
        int xUp = xDown + (xDown == this.pixelCounts[0] - 1 ? 0 : 1);
        int yUp = yDown + (yDown == this.pixelCounts[1] - 1 ? 0 : 1);
        float value = VolumeData.getFractional2DValue(x - (float)xDown, y - (float)yDown, this.pixelData[xDown][yDown], this.pixelData[xUp][yDown], this.pixelData[xDown][yUp], this.pixelData[xUp][yUp]);
        return value;
    }

    private void getPixelCounts() {
        int max = 1;
        for (int i = 0; i < 3; ++i) {
            if (i == this.contourType) continue;
            max = Math.max(max, this.volumeData.voxelCounts[i]);
        }
        this.pixelCounts[0] = this.pixelCounts[1] = max;
    }

    private void createPlanarSquares() {
        this.squareCountX = this.pixelCounts[0] - 1;
        this.squareCountY = this.pixelCounts[1] - 1;
        this.planarSquares = new PlanarSquare[this.squareCountX * this.squareCountY];
        this.nSquares = 0;
        for (int x = 0; x < this.squareCountX; ++x) {
            for (int y = 0; y < this.squareCountY; ++y) {
                this.planarSquares[this.nSquares++] = new PlanarSquare(this.nContourSegments);
            }
        }
        Logger.info("nSquares = " + this.nSquares);
    }

    public boolean createContours(float min, float max) {
        float diff = max - min;
        boolean centerIsLow = true;
        int lastInside = -1;
        Logger.info("generateContourData min=" + min + " max=" + max + " nContours=" + (this.nContourSegments - 1) + " (" + this.nContoursSpecified + " specified)");
        for (int i = 0; i < this.nContourSegments; ++i) {
            this.contourIndex = i;
            float cutoff = this.contourFromZero ? min + (float)i * 1.0f / (float)this.nContourSegments * diff : (i == 0 ? -3.4028235E38f : (i == this.nContourSegments - 1 ? Float.MAX_VALUE : min + (float)(i - 1) * 1.0f / (float)(this.nContourSegments - 1) * diff));
            int insideCount = this.generateContourData(cutoff);
            if (lastInside < 0) {
                lastInside = insideCount;
                continue;
            }
            if (lastInside <= insideCount) continue;
            centerIsLow = false;
            lastInside = 0;
        }
        return centerIsLow;
    }

    private int generateContourData(float contourCutoff) {
        int[][] isoPointIndexes2d = new int[this.squareCountY][4];
        float[][] squareFractions2d = new float[this.squareCountY][4];
        int i = this.squareCountY;
        while (--i >= 0) {
            isoPointIndexes2d[i][3] = -1;
            isoPointIndexes2d[i][2] = -1;
            isoPointIndexes2d[i][1] = -1;
            isoPointIndexes2d[i][0] = -1;
        }
        if ((double)Math.abs(contourCutoff) < 1.0E-4) {
            contourCutoff = contourCutoff < 0.0f ? -1.0E-4f : 1.0E-4f;
        }
        int insideCount = 0;
        int contourCount = 0;
        int x = this.squareCountX;
        while (--x >= 0) {
            int y = this.squareCountY;
            while (--y >= 0) {
                int[] pixelPointIndexes = this.propagateNeighborPointIndexes2d(x, y, isoPointIndexes2d, squareFractions2d);
                int insideMask = 0;
                int i2 = 4;
                while (--i2 >= 0) {
                    float vertexValue;
                    Point3i offset = squareVertexOffsets[i2];
                    this.vertexValues2d[i2] = vertexValue = this.pixelData[x + offset.x][y + offset.y];
                    if (!this.isInside2d(vertexValue, contourCutoff)) continue;
                    insideMask |= 1 << i2;
                    ++insideCount;
                }
                if (insideMask == 15) {
                    this.planarSquares[x * this.squareCountY + y].addEdgeMask(this.contourIndex, 0, 15);
                    continue;
                }
                ++contourCount;
                this.processOneQuadrilateral(insideMask, contourCutoff, pixelPointIndexes, x, y);
            }
        }
        return insideCount;
    }

    private boolean isInside2d(float voxelValue, float max) {
        return this.contourFromZero ? max > 0.0f && voxelValue >= max || max <= 0.0f && voxelValue <= max : voxelValue < max;
    }

    private int[] propagateNeighborPointIndexes2d(int x, int y, int[][] isoPointIndexes2d, float[][] squareFractions2d) {
        boolean noYNeighbor;
        boolean noXNeighbor;
        int[] pixelPointIndexes = isoPointIndexes2d[y];
        this.squareFractions = squareFractions2d[y];
        boolean bl = noXNeighbor = x == this.squareCountX - 1;
        if (noXNeighbor) {
            pixelPointIndexes[0] = -1;
            pixelPointIndexes[1] = -1;
            pixelPointIndexes[2] = -1;
            pixelPointIndexes[3] = -1;
        } else {
            pixelPointIndexes[1] = pixelPointIndexes[3];
            this.squareFractions[1] = 1.0f - this.squareFractions[3];
        }
        boolean bl2 = noYNeighbor = y == this.squareCountY - 1;
        if (noYNeighbor) {
            pixelPointIndexes[2] = -1;
        } else {
            pixelPointIndexes[2] = isoPointIndexes2d[y + 1][0];
            this.squareFractions[2] = 1.0f - squareFractions2d[y + 1][0];
        }
        pixelPointIndexes[0] = -1;
        pixelPointIndexes[3] = -1;
        return pixelPointIndexes;
    }

    private void processOneQuadrilateral(int insideMask, float cutoff, int[] pixelPointIndexes, int x, int y) {
        byte edgeMask = insideMaskTable2d[insideMask];
        this.planarSquares[x * this.squareCountY + y].addEdgeMask(this.contourIndex, edgeMask, insideMask);
        int iEdge = 4;
        while (--iEdge >= 0) {
            if ((edgeMask & 1 << iEdge) == 0 || pixelPointIndexes[iEdge] >= 0) continue;
            byte vertexA = edgeVertexes2d[2 * iEdge];
            byte vertexB = edgeVertexes2d[2 * iEdge + 1];
            float valueA = this.vertexValues2d[vertexA];
            float valueB = this.vertexValues2d[vertexB];
            if (this.is3DContour) {
                this.calcVertexPoints3d(x, y, vertexA, vertexB);
            } else {
                this.calcVertexPoints2d(x, y, vertexA, vertexB);
            }
            this.squareFractions[iEdge] = this.calcContourPoint(cutoff, valueA, valueB, this.contourPoints[iEdge]);
            pixelPointIndexes[iEdge] = this.surfaceReader.addVertexCopy(this.contourPoints[iEdge], cutoff, -1);
            ++this.nVertices;
        }
        this.planarSquares[x * this.squareCountY + y].setIntersectionPoints(this.contourIndex, pixelPointIndexes, this.squareFractions);
    }

    private void calcVertexPoints2d(int x, int y, int vertexA, int vertexB) {
        this.pixelOrigin.scaleAdd(x, this.planarVectors[0], this.planarOrigin);
        this.pixelOrigin.scaleAdd(y, this.planarVectors[1], this.pixelOrigin);
        this.pointA.add(this.pixelOrigin, this.pixelVertexVectors[vertexA]);
        this.pointB.add(this.pixelOrigin, this.pixelVertexVectors[vertexB]);
    }

    private void calcVertexPoints3d(int x, int y, int vertexA, int vertexB) {
        this.contourLocateXYZ(x + MarchingSquares.squareVertexOffsets[vertexA].x, y + MarchingSquares.squareVertexOffsets[vertexA].y, this.pointA);
        this.contourLocateXYZ(x + MarchingSquares.squareVertexOffsets[vertexB].x, y + MarchingSquares.squareVertexOffsets[vertexB].y, this.pointB);
    }

    private void contourLocateXYZ(int ix, int iy, Point3f pt) {
        int i = this.findContourVertex(ix, iy);
        if (i < 0) {
            pt.x = Float.NaN;
            return;
        }
        ContourVertex c = this.contourVertexes[i];
        pt.set(c.vertexXYZ);
    }

    private int findContourVertex(int ix, int iy) {
        for (int i = 0; i < this.contourVertexCount; ++i) {
            if (this.contourVertexes[i].pixelLocation[0] != ix || this.contourVertexes[i].pixelLocation[1] != iy) continue;
            return i;
        }
        return -1;
    }

    private float calcContourPoint(float cutoff, float valueA, float valueB, Point3f contourPoint) {
        float diff = valueB - valueA;
        float fraction = (cutoff - valueA) / diff;
        this.edgeVector.sub(this.pointB, this.pointA);
        contourPoint.scaleAdd(fraction, this.edgeVector, this.pointA);
        return fraction;
    }

    private void calcPixelVertexVectors() {
        int i = 4;
        while (--i >= 0) {
            this.pixelVertexVectors[i] = new Vector3f();
            this.planarMatrix.transform(squareVertexVectors[i], this.pixelVertexVectors[i]);
        }
    }

    private void triangulateContours(boolean centerIsLow) {
        int offset = centerIsLow ? -1 : 1;
        for (int contourIndex = 0; contourIndex < this.nContourSegments; ++contourIndex) {
            if (this.thisContour > 0 && this.thisContour != contourIndex + 1) continue;
            for (int squareIndex = 0; squareIndex < this.nSquares; ++squareIndex) {
                boolean isTerminal;
                PlanarSquare square = this.planarSquares[squareIndex];
                int edgeMask0 = square.edgeMask12[contourIndex];
                boolean bl = isTerminal = contourIndex + offset < 0 || contourIndex + offset == this.nContourSegments;
                if ((edgeMask0 &= 0xFF) == 0 && !isTerminal && square.edgeMask12[contourIndex + offset] == 0 || edgeMask0 == 15 && !isTerminal && square.edgeMask12[contourIndex + offset] == 15) continue;
                boolean isOK = true;
                int edgeMask = edgeMask0;
                if (!isTerminal && (edgeMask0 = square.edgeMask12[contourIndex + offset]) != 0) {
                    int andMask = (edgeMask & edgeMask0 & 0xF0) >> 4;
                    int orMask = ((edgeMask | edgeMask0) & 0xF0) >> 4;
                    if (andMask != 0) {
                        for (int i = 0; i < 4; ++i) {
                            if ((andMask & 1 << i) != 0) {
                                if (!(square.fractions[contourIndex][i] > square.fractions[contourIndex + offset][i])) break;
                                isOK = false;
                                break;
                            }
                            if ((orMask & 1 << i) != 0) break;
                        }
                    }
                    edgeMask ^= edgeMask0 & 0xF0F;
                }
                if (edgeMask == 0 && !isTerminal) continue;
                this.fillSquare(square, contourIndex, edgeMask, !isOK, offset);
            }
        }
    }

    private void fillSquare(PlanarSquare square, int contourIndex, int edgeMask, boolean reverseWinding, int offset) {
        int vPt = 0;
        boolean lowerFirst = reverseWinding;
        int mesh1 = -1;
        int mesh2 = -1;
        for (int i = 0; i < 4; ++i) {
            if (square.vertexes[i] < 0) {
                return;
            }
            boolean newVertex = (edgeMask & 1 << i) != 0;
            boolean thisIntersect = (edgeMask & 1 << 4 + i) != 0;
            boolean lowerIntersect = (edgeMask & 1 << 8 + i) != 0;
            boolean lowerLast = false;
            if (newVertex) {
                this.triangleVertexList[vPt++] = square.vertexes[i];
            }
            if (lowerFirst && lowerIntersect) {
                lowerLast = true;
                this.triangleVertexList[vPt++] = square.intersectionPoints[contourIndex + offset][i];
            }
            if (thisIntersect) {
                lowerLast = false;
                int n = vPt++;
                int n2 = square.intersectionPoints[contourIndex][i];
                this.triangleVertexList[n] = n2;
                int pt = n2;
                if (mesh1 < 0) {
                    mesh1 = pt;
                } else {
                    mesh2 = pt;
                }
            }
            if (!lowerFirst && lowerIntersect) {
                lowerLast = true;
                this.triangleVertexList[vPt++] = square.intersectionPoints[contourIndex + offset][i];
            }
            if (lowerLast && newVertex) {
                lowerFirst = true;
            }
            if (thisIntersect && newVertex) {
                lowerFirst = false;
            }
            if (thisIntersect && !lowerLast) {
                lowerFirst = false;
            }
            if (!thisIntersect || !lowerLast) continue;
            lowerFirst = true;
        }
        this.createTriangleSet(vPt, mesh1, mesh2);
    }

    private void createTriangleSet(int nVertex, int mesh1, int mesh2) {
        int k = this.triangleVertexList[1];
        for (int i = 2; i < nVertex; ++i) {
            int check;
            int iA = this.triangleVertexList[0];
            int iB = k;
            int iC = this.triangleVertexList[i];
            int n = iA == mesh1 && iB == mesh2 || iB == mesh1 && iA == mesh2 ? 1 : (iB == mesh1 && iC == mesh2 || iC == mesh1 && iB == mesh2 ? 2 : (check = iA == mesh1 && iC == mesh2 || iC == mesh1 && iA == mesh2 ? 4 : 0));
            if (iA >= 0 && iB >= 0 && iC >= 0) {
                this.surfaceReader.addTriangleCheck(iA, iB, iC, check, false, 0);
            }
            k = this.triangleVertexList[i];
        }
    }

    private static void setupMatrix(Matrix3f mat, Vector3f[] cols) {
        for (int i = 0; i < 3; ++i) {
            mat.setColumn(i, cols[i]);
        }
    }

    private void xyzToPixelVector(Vector3f vector) {
        vector.sub(vector, this.planarOrigin);
        this.matXyzToPlane.transform(vector);
        vector.x /= this.planarVectorLengths[0];
        vector.y /= this.planarVectorLengths[1];
    }

    private Point3f pixelPtToXYZ(int x, int y) {
        Point3f ptXyz = new Point3f();
        ptXyz.scaleAdd(x, this.planarVectors[0], this.planarOrigin);
        ptXyz.scaleAdd(y, this.planarVectors[1], ptXyz);
        return ptXyz;
    }

    private Point3i locatePixel(Point3f ptXyz) {
        this.pointVector.set(ptXyz);
        this.xyzToPixelVector(this.pointVector);
        this.ptiTemp.x = (int)(this.pointVector.x + 0.5f);
        this.ptiTemp.y = (int)(this.pointVector.y + 0.5f);
        return this.ptiTemp;
    }

    private static class PlanarSquare {
        int[] edgeMask12;
        int edgeMask12All;
        int nInside;
        int nOutside;
        int nThrough;
        int contourBits;
        final int[] vertexes = new int[]{-1, -1, -1, -1};
        float[][] fractions;
        int[][] intersectionPoints;

        PlanarSquare(int nContourSegments) {
            this.edgeMask12 = new int[nContourSegments];
            this.intersectionPoints = new int[nContourSegments][4];
            this.fractions = new float[nContourSegments][4];
            this.edgeMask12All = 0;
            this.contourBits = 0;
        }

        void setIntersectionPoints(int contourIndex, int[] pts, float[] f) {
            for (int i = 0; i < 4; ++i) {
                this.intersectionPoints[contourIndex][i] = pts[i];
                this.fractions[contourIndex][i] = f[i];
            }
        }

        void setVertex(int iV, int pt) {
            if (this.vertexes[iV] != -1 && this.vertexes[iV] != pt) {
                Logger.error("iV IS NOT -1 or pt:" + iV + " " + this.vertexes[iV] + "!=" + pt);
            }
            this.vertexes[iV] = pt;
        }

        void addEdgeMask(int contourIndex, int edgeMask4, int insideMask) {
            if (insideMask != 0) {
                this.contourBits |= 1 << contourIndex;
            }
            this.edgeMask12[contourIndex] = ((edgeMask4 << 4) + edgeMask4 << 4) + insideMask;
            this.edgeMask12All |= this.edgeMask12[contourIndex];
            if (insideMask == 0) {
                ++this.nOutside;
            } else if (insideMask == 15) {
                ++this.nInside;
            } else {
                ++this.nThrough;
            }
        }
    }

    private static class ContourVertex {
        Point3f vertexXYZ = new Point3f();
        Point3i voxelLocation;
        int[] pixelLocation = new int[2];
        float value;
        int vertexIndex;

        ContourVertex(int x, int y, int z, Point3f vertexXYZ, int vPt) {
            this.vertexXYZ.set(vertexXYZ);
            this.voxelLocation = new Point3i(x, y, z);
            this.vertexIndex = vPt;
        }

        void setValue(float value, VolumeData volumeData) {
            this.value = value;
            if (volumeData != null && volumeData.voxelData != null) {
                volumeData.voxelData[this.voxelLocation.x][this.voxelLocation.y][this.voxelLocation.z] = value;
            }
        }

        void setPixelLocation(Point3i pt) {
            this.pixelLocation[0] = pt.x;
            this.pixelLocation[1] = pt.y;
        }
    }
}

